use Module::Build;

Module::Build -> new
(
	module_name    => 'Graph::Easy::Marpa',
	license        => 'artistic',
	dist_abstract  => 'A Marpa-based parser for Graph::Easy-style Graphviz files',
	dist_author    => 'Ron Savage <ron@savage.net.au>',
	build_requires =>
	{
		Test::More => 0.94,
		Test::Pod  => 1.44,
	},
	configure_requires =>
	{
		Module::Build => 0.3800,
	},
	requires =>
	{
		Capture::Tiny         => 0.11,
		Config                => undef,
		Config::Tiny          => 2.14,
		Data::Section::Simple => 0.02,
		Date::Simple          => 3.03,
		File::Basename        => 2.78,
		File::Copy            => 2.21,
		File::HomeDir         => 0.99,
		File::Slurp           => 9999.19,
		File::Spec            => 3.33,
		Getopt::Long          => 2.38,
		GraphViz2             => 1.09,
		Hash::FieldHash       => 0.10,
		HTML::Entities::Interpolate => 1.04,
		IO::File              => 1.14,
		List::Compare         => 0.37,
		Log::Handler          => 0.71,
		Marpa::R2             => 2.022000,
		Module::Load          => 0.18,
		#OpenOffice::OODoc    => 2.125, # Optionally used in Lexer.pm.
		Path::Class           => 0.24,
		Perl6::Slurp          => 0.03,
		Pod::Usage            => 1.36,
		Set::Array            => 0.23,
		Set::FA::Element      => 1.08,
		Sort::Naturally       => 1.02,
		strict                => 0,
		Text::CSV_XS          => 0.80,
		Text::Xslate          => 1.4001,
		Try::Tiny             => 0.09,
		warnings              => 0,
	},
) -> create_build_script();
