package Catalyst::Manual::Monthly;
use strict;
use warnings;

our $VERSION = '0.01';

=head1 NAME

Catalyst::Manual::Monthly

This is repository for the monthly articles which replace the Catalyst
Advent Calendar.  Following the Catalyst philosophy, the Catalyst monthly
doesn't use Catalyst it uses the CPAN toolchain to achieve its aims.
Occasionally a catalyst application (e.g. Metacpan) might be used for
system integration tasks.

Articles are stored in directories as with:
lib/Catalyst/Monthly/[Year]/[Month]/[SomeDescriptiveFilename].pod

In due course an RSS scraper will be written to facilitate notifications of
publication of new articles and edits to old articles.

=head1 AUTHOR

Catalyst Documentation Team

<zarquon@cpan.org> and others.

=head1 BUGS

Please report any bugs or requests to C<bug-catalyst-manual-monthly
at rt.cpan.org>, or through the web interface at
L<http://rt.cpan.org/NoAuth/ReportBug.html?Queue=Catalyst-Manual-Monthly>.
I will be notified, and then you'll automatically be notified of progress
on your bug as I make changes.

=head2 Contributions

Submit contributions via the RT queue above, or by bugging people on #catalyst on irc.perl.org.


=head1 ACKNOWLEDGEMENTS

Catalyst Core developer team, past and present, catalyst contributors, and
the CPAN toolchain hackers.

=head1 LICENSE AND COPYRIGHT

Copyright 2012 Catalyst Documentation team

This documentation can be redistributed under the terms of either: the GNU
General Public License as published by the Free Software Foundation; or the
Artistic License.

See http://dev.perl.org/licenses/ for more information.


=cut

1; # End of Catalyst::Manual::Monthly
