use 5.008001;
use strict;
use warnings;

package Crypt::Diceware::Wordlist::Beale;
# ABSTRACT: Crypt::Diceware wordlist from the alternative Diceware list
our $VERSION = '0.001'; # VERSION

our @Words = qw{
  a a's a-1 a-z aa aaa aaaa aaron ab aback abacus abase abash abate abbey
  abbot abbr abby abc abc's abcd abduct abdul abe abed abel abet abhor abide
  ablaze able abm abner aboard abode abort about above abram absent absorb
  abuse abut abyss ac ac/dc accept accuse ace aces ache ached aches achoo
  achy acid acidic acids acme acne acorn acquit acre acres acrid act acted
  actor acts acute ad ada adage adagio adair adam adams adapt add added adder
  addict addle adds adele adept adieu adios adjust adler admit ado adobe
  adolf adonis adopt adore adorn ads adult advent adverb advise ae aeiou
  aerial aesop af afar affair afghan afire afoot afraid africa afro aft after
  ag again agate age aged agenda agent ages agile aging aglow agnes agnew ago
  agony agree ah aha ahab ahead ahem ahmed ahoy ai aid aide aided ail aim
  aimed aims ain't air airman airway airy aisle aj ajar ajax ak aka akers
  akin akqj akron al alan alarm alas alaska album alden ale alec aleck alert
  alex alexa alexei algae alger ali alias alibi alice alien alight align
  alike alive alkali all allah allan allen alley allied allot allow alloy
  allure ally alma almost alms aloft aloha alone along aloof aloud alp alpha
  alps also alsop altar alter altho alto alum alumni alvin alyx am am/fm
  amass amaze amber amble ambush amen amend ames amid amigo amino amish amiss
  amity ammo amok among amos amour amp ampere ample amply amps amulet amuse
  amy an anal anchor and andes andre andrew andy anew angel angelo anger
  angie angle angles anglo angry angst angus anita ankle ann anna anne annex
  annie annoy annul anon answer ant ante anti antic anton ants anus anvil any
  anyhow anyway ao aok aorta ap apart apathy ape apes apex aphid aplomb
  appeal appear append apple apply apr april apron apt aq aqua ar arab arabs
  araby arbor arc arcade arch archer arcs ardent are area areas arena argon
  argue aria arid arise ark arlene arm armed armor arms army arnold aroma
  arose array arrive arrow arson art artery arthur artie arts arty aryan as
  asap ascend ascii ash ashen ashes ashley ashy asia asian aside ask asked
  askew asks asleep asp aspen aspire ass asses asset assn assure asthma astor
  astral at at&t atari ate athens atlas atm atoll atom atomic atoms atone
  atop attic attire attn au audio audit audrey aug augur august auk aunt
  aunts aura aural austin auto autumn av avail avert avery avian aviate avid
  avis avoid avon avow aw await awake award aware awash away awe awed awful
  awl awn awoke awol awry ax axe axes axiom axis axle ay aye az aztec azure b
  b&w b's b-52 ba baal babe babel babes baboon baby bach back backup bacon
  bad badge badly baffle bag bagel baggy bags bah bahama bail bait bake baker
  bakes bald bale bali balk balkan ball balled ballot balls balm balmy balsa
  bambi ban banal banana band bandit bands bandy bane bang bangs banish banjo
  bank banks bar barb barbs bard bare barf barge bark barks barley barn
  barnes baron barony barry bars bart barter barton base bash basic basil
  basin basis bask basket bass baste bat batch bates bath bathe baths baton
  bats bauble baud bawd bawdy bawl bay bayer bayou bays bazaar bb bbb bbbb
  bbc bbs bc bcd bd be beach beacon bead beads beady beak beam beams bean
  beans bear beard bears beast beat beats beau beauty beaver bebop beck becky
  bed beds bee beech beef beefy been beep beeps beer beers bees beet beets
  befall befit befog beg began beget beggar begin begs begun behind beige
  being beirut belch belfry belief bell bella belle bellow bells belly below
  belt belts bemoan ben bench bend bender bends benign benny bent benz beret
  berg berlin berra berry bert berth beryl beset bess best bet beta beth
  betray bets betsy bette betty bevy beware beyond bf bflat bg bh bi bias bib
  bible biceps bid bide bids bier big bigamy bigot bike biker bikini bile
  bilge bilk bill bills billy bimbo bin binary bind binge bingo biped birch
  bird birdie birds birth bison bisque bit bite bites bits bitten biz bj bk
  bl blab black blade blah blair blake blame bland blank blare blast blat
  blaze bldg bleak bleat bled bleed blend bless blew blimp blind blink blip
  blips bliss blithe blitz bloat blob blobs bloc block bloke blond blonde
  blood bloom bloop blot blotch blots blow blown blows blt blue blues bluff
  blunt blur blurs blurt blush blvd blythe bm bmw bn bo boa boar board boast
  boat boats bob bobby bobcat bobs bode body bog bogey boggy bogs bogus boil
  boils boise bold bolt bolts bomb bombay bombs bond bone bones bong bongo
  bonn bonus bony boo boob booby boogie book books boom boon boone boor boost
  boot booth boots booty booze bop borax border bore bored bores borg boris
  born borneo boron bosom boss bossy boston botch both bottle bough bouncy
  bound bout bovine bow bowed bowel bowie bowl bowls bows box boxed boxer
  boxes boxy boy boyd boyle boys bozo bp bq br bra brace brad brady brag
  brags braid brain brainy brake bran brand brandy brash brass brassy brat
  brats brave bravo brawl brawn bray brazil bread break breath bred breed
  breeze brew brian briar bribe brick bride bridge brief brig brim brine
  bring brink briny brisk broad broil broke broken bronco bronx brood brook
  broom broth brow brown brows browse bruce bruin brunch bruno brunt brush
  brutal brute bryan bs bt btu bu bub buck bucks bud buddha buddy budge buds
  buff bug buggy bugle bugs buick build built bulb bulbs bulge bulk bulky
  bull bulls bully bum bump bumps bumpy bums bun bunch bunco bundy bunk bunny
  buns bunt bunts buoy bureau burg burger buried burke burly burma burn burns
  burnt burp burps burro burst burt burton bury bus bush bushel bushy buss
  bust busy but butane butch butt butte buxom buy buyer buys buzz bv bvm bw
  bwana bx by bye bylaw byline byob bypass byrd byron byte bytes byway bz c
  c&w c's c/o ca cab cabal cabana cabin cable cabot cache cackle cacti
  caddy cadet caesar cafe cage caged cages cagey cain cairn cairo cajun cake
  cakes calf calico call calls callus calm calms calvin cam came camel cameo
  camera camp camps camry can can't canal canary cancer candle candy cane
  caned canes cannot canny canoe canon canopy cans canto canvas canyon cap
  cape caped caper capri car carat carbon card care cares caress caret cargo
  carl carla carlo carol carp carpet carrie carry cars carson cart caruso
  carve case cases casey cash cashew cask casket cast caste cat catch cater
  cathy cats catsup catty caulk cause cave cavern caves cavort cb cc ccc cccc
  cccp cd cde ce cease cecil cedar cede celery celia cell cello census cent
  cents ceo cesar cf cg ch chad chafe chaff chain chair chalk champ chance
  chant chaos chap chapel char charm chart chase chasm chaste chat chats
  cheap cheat check cheek cheeky cheer chef cherub chess chest chevy chew
  chews chewy chi chic chick chide chief child chile chili chill chilly chime
  chimp chin china chip chips chirp chisel chit chive chloe chock choir choke
  chomp chop chopin chops choral chord chore chose chosen chow chris chub
  chuck chug chum chump chunk churn chute ci cia ciao cicada cider cigar
  cilia cinch cindy cipher circa circe cite citrus city civet civic civil cj
  ck cl clad claim clam clammy clamp clan clang clank clap claps clara clark
  clash clasp class claus clause claw claws clay clean clear cleat clef cleft
  clem cleo clerk clever cliche click cliff climb cling clink clip cloak
  clock clod clog clone close closet clot cloth cloud clout clove clown cloy
  club clubs cluck clue clues clump clumsy clung clyde cm cn co co2 coach
  coal coast coat coats coax cob cobble cobol cobra coca cock cockle cocky
  cocoa cod coda coddle code coded codes cody coed cog cogent cogs cohen coif
  coil coils coin coins coke cola colby cold cole colon colony color colt
  coma comb combat combo come comet comfy comic comma con conch condo cone
  coney congo conic convex convoy conway coo cook cooky cool coon coop cooper
  coors coos coot cop cope copes copper copra cops copy coral cord cords core
  cork corn corny corp corps cortex cost costs cot couch cough could count
  coup coupe court cousin cove coven cover covet cow cowboy cowl cows cox coy
  coyote cozy cp cpa cpr cpu cq cr crab crack craft crag craig cram cramp
  crane crank crap craps crash crass crate crater crave crawl craze crazy
  creak cream credit credo creed creek creep creole crepe crept cress crest
  crete crew crib cried crime crimp crisp croak crock crocus crone crony
  crook croon crop crops cross crow crowd crown crows crt crud crude cruel
  crumb crunch crush crust crux cry crypt cs ct cu cub cuba cuban cube cubic
  cubs cud cuddle cue cues cuff cull cult cults cup cupful cupid cups cur
  curb curd cure cured curfew curie curio curl curls curry curse curt curve
  cusp cuss cut cute cutlet cuts cv cw cx cy cycle cynic cyrus cyst cz czar
  czech d d&d d's d-day da dab dad daddy daffy daft dagger dahlia daily dairy
  dais daisy dale dally dam dame damn damon damp damsel dan dana dance dandy
  dane dang dank danny dante dare dared dares dark darken darn dart darts
  darwin daryl dash data date dates datum daub daunt dave david davis davy
  dawn day days daze dazed db dbms dc dd ddd dddd dds ddt de deacon dead deaf
  deal deals dealt dean dear death debby debit debra debris debt debts debug
  debut dec decal decay deck decor decoy decree decry dee deed deeds deejay
  deem deep deer def defect defer deform deft defy deify deity del delay
  delhi deli delia della delta deluxe delve demo demon demur den denial denim
  denny dense dent dents deny depot dept depth deputy derby derek desist desk
  desks detach deter detox deuce devil devoid dew dewey dewy df dg dh di dial
  dials diana diane diaper diary dibs dice dick did die died diego dies
  diesel diet diets dig digit digs dike dilate dill dim dime dimes dimly dims
  din dinah dine diner ding dingo dingy dint diode dip dips dire dirge dirk
  dirt dirty disc disco dish disk disney ditch ditto ditty diva divan dive
  dives divot dixie dizzy dj dk dl dm dn dna do dobro doc dock docket doctor
  dodge dodo doe does doff dog dogma dogs doily doing dolby dole doll dolly
  dolt dome domed domino don don't done donna donor donut doom door dope
  dopey dora doris dorm dose dot dote dots double doubt doug dough douse dove
  doves dowel down dowry doze dozen dp dq dr drab draft drag drain drake
  drama drank drape draw drawl drawn dread dream dreamy dregs dress dressy
  drew dried drier dries drift drill drink drip drips drive droid droll drone
  drool droop drop drops drove drown dru drub drug drugs druid drum drums
  drunk dry dryad ds dt du dual duane dub dublin duck ducks duct dud dude due
  duel dues duet duff dug duke dull dully duly dumb dumbo dummy dump dumps
  dumpy dun dunce dune dung dunk duo dupe during dusk dusky dust dusty dutch
  duty dv dw dwarf dwell dwelt dwight dx dy dyad dye dyed dying dylan dynamo
  dz e e's ea each eager eagle ear earl early earn earns ears earth ease
  easel east easy eat eaten eater eats eave eaves eb ebb ebony ec echo ed
  eddie eddy eden edgar edge edges edgy edible edict edify edit edith editor
  edits edna edsel edwin ee eee eeee eeg eel eerie ef efface efg eflat eft eg
  egg eggs ego egress egret egypt eh ei eight ej eject ek ekg el elate elbow
  elder elect elegy elena eleven elf elfin eli elide eliot elite eliza elk
  elks ella ellen elm elmer elms elope elroy else elsie elton elude elves
  elvis ely em email embalm embed ember emcee emery emil emile emily emit
  emits emma emmy emote employ empty emu en enact enamel end ended endow ends
  enema enemy enigma enjoy enmity ennui enoch ensue enter entrap entry envoy
  envy eo eon eons ep epic epics epoch epoxy epsom eq equal equip er era
  erase erect ergo eric erica erie erik erin ernest ernie erode eros err
  errand errol error erupt es esp espy esq essay ester et eta etc etch ethel
  ether ethic ethos ethyl etude eu eureka ev eva evade evans eve even event
  ever every evict evil evita evoke evolve ew ewe ex exact exalt exam exams
  excel excess exec exert exile exist exit exits exodus expel expo extant
  extent extol extra exult exxon ey eye eyed eyes ez ezra f f's fa fable
  fabric face faces facet facile fact facts fad fade fads fail faint fair
  fairy faith fake faker fall false fame fan fancy fang fangs fanny fans far
  farce fare farm farms fast fat fatal fate father fats fatty fault fauna
  faust faux fawn fax faze fb fbi fc fd fe fear fears feast feat feb fed fee
  feeble feed feeds feel feels fees feet feign feint felice felix fell felon
  felt femur fence fend fern ferry fetal fetch fete fetid fetus feud fever
  few fez ff fff ffff fg fgh fh fi fiat fib fiber fickle fido field fiend
  fiery fife fifth fifty fig fight figs fiji filch file filed files filet
  fill filler filly film films filmy filth fin final finale finch find fine
  fined finer finite fink finn finny fir fire firm first fish fishy fist fit
  fits five fix fixed fizz fj fjord fk fl flab flag flail flair flak flake
  flaky flame flank flap flare flash flask flat flavor flaw flax flay flea
  fled flee fleet flesh flew flex flick flier flies flinch fling flint flip
  flirt flit flo float flock flog flood floor flop floppy flora flour flow
  flown floyd flu flub flue fluff fluid fluke flung flush flute flux fly
  flyer fm fn fo foal foam foamy fob focal focus fodder foe foes fog foggy
  fogy foil foist fold folio folk folly fond font food fool foot fop for
  foray force ford fore forge forgot fork form forms fort forte forth forty
  forum fossil foul found fount four fowl fox foxes foxy foyer fp fq fr frail
  frame france frank franz frau fraud fray freak fred free freed freer frenzy
  freon fresh fret freud fri friar fried fries frill frilly frisky fritz
  frock frog frogs from frond front frost froth frown froze fruit fry fs ft
  fu fudge fuel fugue fuji full fully fumble fume fumes fun fund funds fungi
  funk funky funny fur furl furry furs fury fuse fuss fussy fuzz fuzzy fv fw
  fx fy fyi fz g g's ga gab gable gadget gaea gaffe gag gags gail gaily gain
  gait gal gala galaxy gale gall gallop gam game games gamma gamut gamy
  gander gang gangs gap gape gapes gaps garb gargle garish gary gas gash gasp
  gasps gassy gate gates gator gauche gaudy gauge gaunt gauze gave gavel gawk
  gawky gay gaze gazed gazes gb gc gd ge gear gears gee geese gel geld gem
  gems gene genes genie genre gent gentry geo gerbil germ germs get gets gf
  gg ggg gggg gh ghetto ghi ghost ghoul ghq gi giant giddy gift gifts gig gil
  gila gild gill gills gilt gimme gimpy gin gina ginger gino gird girl girls
  girth gist give given gives gizmo gj gk gl glad glade glamor glance gland
  glare glass glaze gleam glean glee glen glenn glib glide glint gloat glob
  globe gloom glory gloss glove glow glows glue glued gluey gluing glum glut
  gm gmt gn gnash gnat gnaw gnaws gnome gnp gnu go goad goal goals goat goats
  gob god godly gods goes goggle gogh gogo going gold golf golly gomez gone
  gong goo good goods goody gooey goof goofy goon goose gordon gore gorge
  gory gosh gospel got gouge gould gourd gout govt gown gowns gp gpa gq gr
  grab grabs grace grad grade grady graft grail grain gram grams grand grant
  grape graph grasp grass grate grave gravel gravy gray graze great greed
  greedy greek green greet greg greta grew grey grid grief grieve grill grim
  grime grimy grin grind grins grip gripe grips grist grit groan grog groin
  groom groove grope gross group grout grove grow growl grown grows grub
  grubs gruff grunt gs gt gu guam guano guard guess guest gui guide guild
  guile guilt guise guitar gulag gulf gull gulls gully gulp gum gumbo gummy
  gun gunk guns guppy gurgle guru gus gush gust gusto gusts gusty gut guts
  gutsy guy guys gv gw gwen gx gy gym gyp gypsum gypsy gyro gz h h's h2o ha
  habit hack had hag haha haiku hail hair hairdo hairs hairy haiti hal half
  hall halls halo halt halts halve ham hamlet hammer hams hand handle hands
  handy hang hank hanna hans happy hard hardy hare harem hark harley harm
  harms harp harps harry harsh hart harv harvey has hash hasp haste hasty hat
  hatch hate hates hatred hats haul hauls haunt have haven havoc hawk hawks
  hay haydn hayes hazard haze hazel hazy hb hc hd hdtv he he'd he'll head
  heads heady heal heals heap heaps hear heard hears heart heat heath heats
  heave heaven heavy hebrew heck heckle hectic hedge heed heel heels heft
  hefty height heinz heir heirs held helen helga helix hell hello helm help
  hem hemp hems hen hence henry hens hep her herb herbs herd here hero herod
  heroic heron herr hers hertz hew hex hexed hey hf hg hh hhh hhhh hi hick
  hid hide hides high hij hijack hike hikes hill hills hilly hilt him hind
  hindu hinge hint hints hip hippo hips hiram hire hired hires his hiss hit
  hitch hits hiv hive hives hj hk hl hm hn ho hoagy hoard hoax hobby hobo
  hock hockey hoe hog hogan hogs hoist hold holds holdup hole holes holly
  holmes holy home honda hone honey honk honor hooch hood hoof hook hooks
  hookup hoop hoot hop hope hopes hops horde horn horny horse hose host hot
  hotel hotrod hound hour house hovel hover how howdy howl howls hoyle hp hq
  hr hrh hs ht hu hub hubbub hubby hubs hue hues huey huff hug huge hugh hugo
  hugs huh hula hulk hull hum human humid humor hump humps hums humus hun
  hunch hung hunk hunt hunts hurl huron hurrah hurry hurt hush husk husky hut
  hutch hv hw hwy hx hy hyde hydra hyena hymn hymnal hype hyper hypo hz i i'd
  i'll i'm i's i've ia ian ib ibid ibm ibsen ic icbm ice iced icicle icing
  icky icon icons icy id ida idaho idea ideal ideas idiom idiot idle idly
  idol idols ie if iffy ig igloo ignite igor ih ii iii iiii ij ijk ik ike il
  iliad ill im image imbibe imf imp impel imply import imps in inane inc inca
  incest inch incur index india indies indy inept inert infamy infect infer
  info ingot inhale ink inky inlay inlet inn inner inns input insect inset
  insult intel intend inter into intro invoke io ion ions iota iou iowa ip iq
  ir ira iran iraq iraqi irate ire irene iris irish irk irked irma iron irons
  irony irvin is isaac isabel islam island isle ism isn't israel issue isuzu
  it it'd it'll it's italy itch itchy item items iu iud iv ivan ivory ivy iw
  ix iy iz j j's ja jab jack jackal jacob jade jaded jag jaguar jail jam jamb
  james jan jane janet janis japan jar jars jason jaunt java jaw jaws jay
  jazz jazzy jb jc jd je jean jeans jed jedi jeep jeer jeers jeff jello jelly
  jenny jerk jerks jerky jerry jersey jesse jest jesus jet jets jew jewel
  jewish jf jfk jg jh ji jiffy jig jiggle jigs jill jilt jim jimmy jinx jive
  jj jjj jjjj jk jkl jl jm jn jo joan job jobs jock jockey jody joe joel joey
  jog jogs john join joins joint joke joker jokes jolly jolt jonas jones jose
  josef josh joshua jostle jot jots joust jove jowl jowls joy joyce jp jq jr
  js jt ju juan judas jude judge judo judy jug juggle jugs juice juicy jul
  julep jules julia julie julio july jumbo jump jumps jumpy jun june jung
  junk junky juno junta juror jury just jut jute jv jw jx jy jz k k's ka
  kafka kale kane kansas kant kappa kaput karate karen karl karma karol kate
  kathy katie kay kayak kayo kazoo kb kc kd ke keats kebob keel keen keep
  keeps keg kegs keith kelly kelp ken kennel kent kept kerry kettle kevin key
  keyed keys kf kg kgb kh khaki khan khz ki kibitz kick kicks kid kidney kids
  kill kills kiln kilo kilt kilts kim kin kind kinds king kings kink kinky
  kiosk kirby kirk kiss kit kite kites kitty kiwi kj kk kkk kkkk kl klan
  klaus klaxon klein klm klutz km kn knack knave knead knee kneel knees knelt
  knew knife knight knit knits knob knobs knock knot knots know known knows
  knox ko koala koan kodak kong kook kooks kooky koran korea kp kq kr kraft
  kraut kris ks kt ku kudo kudos kudzu kurt kv kw kx ky kz l l's la lab label
  labor labs lace laces lack lacks lacy lad ladder ladle lads lady lag lager
  lagoon lags laid lair lake lakes lam lamar lamb lambs lame lamp lamps lana
  lance land lands lane lanky laos lap lapel laps lapse lara lard large lark
  larks larry larva larynx laser lash lass lasso last latch late later latest
  latex lathe latin laud laugh launch laura lava law lawn lawns laws lawson
  lax lay layer layla lays lazy lb lbj lbs lc lcd ld le lead leads leaf leafy
  leah leak leaks leaky lean leap leaps lear learn leary lease leash least
  leave led leda ledge lee leech leer leers leery leeway left lefty leg
  legacy legal legion legs lei lemon len lend lends length lenin lenny lens
  lent leo leon leona leper leroy less lest let let's lets letter levee level
  lever levis levy lewd lewis lf lg lh li liar liars lib libel libido libya
  lice lick licks lid lids lie lied lien lies lieu lieut life lift light like
  liked likes lil lilac lilt lily lima limb limbo limbs lime limit limp limps
  linda line linen lines lingo link lint linus lion lip lips liquid lira lisa
  lisp list listen lists liszt lit litton live liver livid liz liza lizzie lj
  lk ll lll llll lloyd lm lmn ln lo load loaf loam loamy loan lob lobby lobe
  lobs local loch lock locks lode lodge loft lofty log logan logic logo logs
  loin loins lois loiter loki lola loll lone loner long longs look looks loom
  loon loony loop loose loot lop lopez lops lord lore loren lose loser loses
  loss lost lot lots lotto lotus lou loud louis louise louse lousy lout love
  loved lover low lower lowry lox loyal lp lq lr ls lsd lt ltd lu luau lucas
  luce lucia lucid luck lucky lucy ludwig lug luger lugs luis luke lull lulu
  lump lumps lumpy luna lunar lunch lung lunge lungs lurch lure lurid lurk
  lurks lush lust lusty lute luxury lv lw lx ly lye lying lyle lymph lynch
  lynn lynx lyre lyric lz m m&m m's m-16 ma ma'am mabel mac macaw mace macho
  macro mad madam made madly madman mafia magic magma magnet magoo magpie
  maid maids mail maim maims main maine maize maj major make malady male
  malice mall malls malt mama mambo mammal man mane mango mania manic manly
  manna manor mantle many mao map maple maps mar marble march marco mare
  mares marge margo maria marie marine mario mark marks marlin marrow marry
  mars marsh mart marty martyr marx mary mash mask masks mason mass mast
  masts mat match mate mated mates math mats matt matzo maud maude maul mauls
  maw max maxim may maybe mayhem mayo mayor mazda maze mazes mb mba mc mccoy
  mcgee md me meadow meal meals mean means meant meat meaty mecca medal media
  medic medley meek meet meets meg meld melee mellow melody melon melt melts
  memo memoir men mend mends menu meow mercy mere merge merit merry mesa mesh
  mess messy met metal meteor meter metro meyer mf mg mgm mgmt mh mi mia
  miami mice mickey micro mid midas midst mig might migs mike mild mildew
  mile miles milk milky mill mills milo mime mimes mimi mimic mince mind
  minds mine mined miner mines mini mink minnow minor mint mints minty minus
  mirage mire mired mirth mirv misc miser misery miss mist mists misty mit
  mite mites mitt mitts mix mixed mixer mixes mixup mj mk ml mm mmm mmmm mn
  mno mo moan moans moat mob mobil mobs moby mock mocks mod mode model modem
  moe mogul moist mojo molar mold molds mole moles molly molt molten mom
  momma mommy mon mona money monk monkey mono month monty moo mooch mood
  moods moody moon moons moor moore moose mop mope mopes mops moral morale
  morbid more morn moron morph morse morsel mort mosaic moses moss mossy most
  mote motel moth mother moths motif motor motto mound mount mourn mouse
  mousy mouth move moved moves movie mow mowed mower mows moxie mp mpg mph mq
  mr mrs ms msdos msg mt mu much muck mucus mud muddy muff muffin mug muggy
  mugs mulch mule mules mull mum mumble mummy mumps munch mural muriel murk
  murky muse muses mush mushy music musk musky muslim muss must musty mute
  muted mutt muzak mv mw mx my mylar mynah myob myopia myra myron myself myth
  myths mz n n's na nab nabs nacl nag nags nail nails naive naked name named
  names nan nancy naomi nap nape napkin naps nasa nasal nash nasty nat natal
  nate nato nature nausea naval navel navy nay nazi nb nc nd ne near nearby
  neat neck necks ned need needs needy negate negro neigh neil nell neon nerd
  nerve nest nests net nets never new newly news newt next nf ng nguyen nh ni
  nice nicer nick nickel nico niece nifty night nil nile nina nine ninja
  ninth niobe nip nips nitwit nix nixon nj nk nl nm nn nne nnn nnnn nnw no
  noah noble nod node nods noel noise noisy nomad none nono nook noon noose
  nop nope nor nora norm norma north norway nose nosy not notch note noted
  notes noun nouns nov nova novak novel now np nq nr ns nt nu nuance nude
  nudge nuke null numb nun nuns nurse nut nutmeg nuts nutty nv nw nx ny nyc
  nylon nymph nz o o's oa oaf oak oaken oar oars oasis oat oath oats ob obese
  obey obeys obit object oboe oc occur ocean ocr oct octal octave od odd odds
  ode odor odors oe of off offend offer often og ogle ogled ogles ogre oh
  ohio oho oi oil oiled oils oily oink oj ok okay okays okra ol olaf old
  older ole olga olive olson om omaha omega omen omens omit omits on once one
  onion only onset onto onward oo ooo oooo oops ooze oozed op opal opals opec
  open opens opera opium opq opt optic opus oq or oral orb orbit orbs orchid
  order ore organ orgy ornery orphan os oscar ot other otis otter otto ou
  ouch ought ouija ounce our ours oust out outdo outer outlaw ov oval ovals
  ovary oven ovens over overt ow owe owed owens owes owing owl owls own owned
  owner owns ox oxen oxide oy oz ozone p p's pa pablo pace paces pack packet
  packs pact pad paddy pads pagan page pages paid pail pain pains paint pair
  pajama pal pale palm palms pals pam pan panama panda pane panel pang panic
  pans pansy pant pants papa paper pappy par pardon pare paris park parks
  parse part parts party pascal pass past paste pasty pat patch path paths
  patio pats patsy patton patty paul paula pause pave paved paves paw pawed
  pawn pawns paws pay payday pb pc pd pdq pe pea peace peach peak peaks pear
  pearl pears peas pebble pecan peck pecks pedal pedro pee peed peek peel
  peep peer peeve peg peggy pegs pelt pen penal pencil penn penny pens peony
  people pep peppy pepsi per perch percy perez peril period perk perks perky
  perm perry pert peru peso pest pests pet petal pete peter pets petty pf pfc
  pg ph phase phd phi phil phlox phone phony photo phrase pi piano pick picks
  pickup picky picnic pie piece pier pierce piers pies piety pig piggy pigs
  pike pile piles pill pills pilot pimp pimple pin pinch pine pines ping pink
  pinko pins pint pinto pinup pious pip pipe piper pirate pit pita pitch pith
  pithy pits pity pivot pixel pixie pizza pj pk pl place plague plaid plain
  plan plane planet plank plant plate plato play plays plaza plea plead pleas
  pleat pledge plod plods plop plot plots plow plows ploy ploys pluck plug
  plugs plum plume plump plums plus plush pluto ply pm pms pn po poach pobox
  pod pods poe poem poems poet poetry pogo poi point poise poison poke poked
  pokes pol polar pole poles police polio polk polka poll polls polo pomp
  pond ponds pony pooch pooh pool pools poop poor pop pope poppy pops porch
  pore pores pork porn porous port pose posed poses posh posse post posts
  posy pot potato pots potts pouch pound pour pours pout pouts pow powder
  power pox pp ppm ppp pppp pq pqr pr prank prawn pray prays preen prefix
  prep press prexy prey price prick pride prig prim prime prince print prior
  prism prissy privy prize pro probe prod prods prof prom promo prone prong
  proof prop propel props prose proud prove prow prowl proxy prude prune pry
  ps psalm psi psych pt pu pub pubic pubs puck pucker puddle pudgy puff puffs
  puffy pug puke pull pulls pulp pulse puma pump pumps pun punch punish punk
  punks punky puns punt punts puny pup pupil puppy pure purge purr purse pus
  push pushy pussy put puts putt putty puzzle pv pvc pw px py pygmy pyre
  pyrex pz q q&a q's qa qb qc qd qe qed qf qg qh qi qj qk ql qm qn qo qp qq
  qqq qqqq qr qrs qs qt qu quack quad quail quake quarry quart queasy queen
  query quest queue quick quiet quill quilt quinn quip quips quirk quit quite
  quits quiver quiz quota quote qv qw qx qy qz r r&b r&d r&r r's ra rabbi
  rabbit rabid race raced races rack racy radar radio radish raft rafts rag
  rage raged rags raid raids rail rails rain rains rainy raise rake raked
  rakes rally ralph ram rambo ramp rams ramsey ran ranch rand randy rang
  range rank ranks rant rants raoul rap rape raped rapid raps rare rascal
  rash rat rate rated rates ratio rats rattle rave raved raven raw ray rayon
  rays raze razor rb rc rd re reach read reads ready reagan real realm reap
  rear rebel rebut recap recipe recur red redeem redo reduce reed reeds reef
  reek reeks reel reels ref refer refs regal regs rehab reich reid reign rein
  reins reject relax relay relic rely rem remedy remit remix rena rend renee
  renew reno renown rent rents rep repay repel repent reply reps rerun reset
  resin resort rest rests retch return reuse rev reveal revel review rex rf
  rg rh rhino rho rhoda rhyme ri rib ribs rice rich rick ricky rico rid ride
  rider ridge rif rifle rift rig riggs right rigid rigs riley rim rims rind
  ring ringo rings rink rinse rio riot riots rip ripe ripen ripley rips rise
  risen risk risky rite ritual rival river rivet rj rk rl rm rn rna ro roach
  road roads roam roar roast rob robe robin robot robs rock rocket rocks
  rocky rod rode rodeo rods roger rogue role roll rolls roman rome romeo romp
  ron roof rook rookie room rooms roomy roost root roots rope rosa rose ross
  rosy rot rote roth rots rouge rough round rouse rout route rover row rowdy
  rows roy royal rp rpg rq rr rrr rrrr rs rst rsvp rt ru rub rube rubs ruby
  rude rudy rufus rug rugged rugs ruin ruins rule ruler rules rum rummy rumor
  rump rumpus run rune runes rung runs runt runway rural ruse rush russ rust
  rusts rusty rut ruth ruts rv rw rx ry ryan rye rz s s's sa saber sable sac
  sack sacks sacred sad saddle sadly safari safe safer safes sag saga sagas
  sage sags said sail sails saint sake sal salad salami sale sales salk sally
  salon salt salts salty salvo sam same sammy samuel sand sandal sands sandy
  sane sang sank santa sap sappy saps sara sarah saran sase sash sat satan
  satin sauce saucy saudi saul sauna saute save saved saves savvy saw saws
  sawyer sax say says sb sc scab scald scale scalp scam scamp scan scans scar
  scare scarf scars scary scat scene scent school scoff scold scoop scoot
  scope scorch score scorn scot scott scour scout scow scowl scram scrap
  scrape screw scrip scrod scrub scuba scuff scum scurry sd sdi se sea seal
  seals seam seams seamy sean sear sears seas season seat seats sect sects
  sedan seduce see seed seeds seedy seek seeks seem seems seen seep seer
  seers sees seethe seize self sell sells semen semi send sends sense sent
  sentry sep sepia sequel sequin serb serf serum serve servo set seth sets
  setup seven sever severe sew sewed sewer sewn sews sex sexy sf sg sgt sh
  shack shade shady shaft shaggy shake shaken shaky shall sham shame shank
  shape share shari shark sharp shave shaw shawl she she'd she's shea sheaf
  shear sheath shed sheds sheep sheer sheet sheik shelf shell shh shift
  shifty shin shine shins shiny ship ships shirk shirt shock shoe shoes shone
  shoo shook shoot shop shops shore short shot shots shout shove show shown
  shows shrank shred shrew shriek shrub shrug shuck shun shut shuts shy shyly
  si sic sick sicko sid side siege siesta sieve sift sifts sigh sighs sight
  sigma sign signal signs silk silks silky sill silly silo silt silver simms
  simon simons sims sin since sinew sing sings sink sinks sins sinus sip sips
  sir sire siren sis sit site sites sits six sixgun sixth sixty size sizes sj
  sk skate skew ski skid skids skies skill skim skimpy skims skin skip skips
  skirt skis skit skits skulk skull skunk sky sl slab slabs slack slain slam
  slams slang slant slap slaps slash slate slater slave slaw slay sled sleds
  sleek sleep sleet slept slew slice slick slid slide slim slime slimy sling
  slip slips slit sliver slob slog sloop slop slope sloppy slops slosh slot
  sloth slots slow slows slug slugs slum slump slums slung slur slurp slurs
  sly slyly sm smack small smart smash smear smell smile smirk smith smock
  smog smoke smoky smooth smug smut sn snack snafu snag snail snake snap
  snaps snare snarl snatch sneak sneer sniff snip snipe snob snobs snoop
  snore snort snot snout snow snows snowy snub snubs snuff snug so soak soaks
  soap soapy soar soars sob sober sobs social sock socks sod soda sofa soft
  soften soggy soil soils sol solar sold sole solemn solid solo solve somber
  some son sonar song songs sonny sons sony soon soot sop sore sorry sort
  sorts sos sot soul sound soup soupy sour source south sow sown sows sox soy
  soyuz sp spa space spade spain spam span spank spans spar spare spark
  sparks spas spasm spat spawn spay speak spear spec speck sped speed spell
  spend spent sperm spew sphinx spice spicy spies spike spiky spill spin
  spine spins spiny spire spit spite spits spitz splat split spock spoil
  spoke sponge spoof spook spooky spool spoon spore sport spot spots spout
  sprain spray spree sprig spruce spry spud spun spunk spur spurn spurs spurt
  spy sq squad squat squid squint squirm sr ss sse sss ssss sst ssw st stab
  stabs stack stacy staff stag stage stain stair stake stale stalk stall
  stamp stan stance stand stank star stare stark starr stars start stash stat
  state stats statue stay stays steady steak steal steam steed steel steep
  steer stein stella stem stems step steps stern steve stew stick stiff still
  sting stingy stink stint stir stirs stock stoke stole stomp stone stony
  stood stool stoop stop stops store stork storm stormy story stout stove
  stow strafe strap straw stray strep strike strip stroll strum strut stu
  stuart stub stuck stud study stuff stuffy stump stun stung stunk stuns
  stunt sty style styx su suave sub subs subtle such suck sucks suds sue sued
  suede sues suey sugar suit suite suits sulk sulks sulky sultry sum sumac
  summon sumo sums sun sung sunk sunny suns sunset sunup sup super supt sure
  surf surge susan sushi susie sutton suzy sv sven sw swab swag swam swami
  swamp swampy swan swank swans swap swarm swat sway sways swear sweat sweaty
  swede sweep sweet swell swept swift swig swim swims swine swing swipe swirl
  swish swiss swoop sword swore sworn swum swung sx sy sybil symbol syrup sz
  t t&a t's ta tab table tablet taboo tabs tabu tack tacky taco tact tactic
  tad taffy taft tag tags tail tails taint take taken takes tale tales talk
  talks tall tally talon tame tamer tamper tan tang tango tangy tank tanks
  tans tanya tao tap tape taped taper tapes taps tar tardy target tarp tarry
  tart tarts task taste tasty tate tater tattle tau taunt taut tavern tax
  taxi tb tba tbsp tc td te tea teach teacup teak team teams tear tease tech
  ted teddy tee teen teens tees teeth tell tells temp temper temple tempo
  temps tempt ten tend tends tenor tens tense tent tenth tents term terms
  terra terry terse test tests testy tex texan texas text tf tg tgif th thai
  than thank that thaw thaws the theft their them theme then there these
  theta they thick thief thigh thin thing think thins third this tho thong
  thor thorn thorny those thread three threw throb throw throws thru thu thud
  thug thumb thump thur thus thyme ti tiara tibet tic tick ticket ticks tics
  tidal tidbit tide tidy tie tied tier ties tiger tight tile tiled tiles till
  tilt tim time times timex timid tin tina tinge tinny tint tiny tip tipoff
  tips tipsy tire tired tires title tj tk tl tlc tm tn tnt to toad toads
  toast toby today todd toe toes tofu toga toil toilet toils token tokyo told
  toll tolls tom tomb tombs tommy ton tonal tone toni tonic tons tonsil tony
  too took tool tools toot tooth top topaz topic topple tops topsy torah
  torch tore torn torso tort tory toss tot total tote totem tots touch tough
  tour tours tout tow towel tower town tows toxic toy toys tp tq tr trace
  track tract tracy trade trail train trait tramp trap traps trash tray trays
  tread treat treble tree trees trek trench trend trial tribe trick tricky
  tried tries trig trill trim trims trio trip tripe trips trite troll troop
  trot trots trout troy truce truck trudge trudy true truly trunk truss trust
  truth try ts tsar tsp tt ttt tttt tu tub tuba tube tubes tubs tuck tue tues
  tuft tufts tug tugs tulip tumble tuna tune tuned tunic tunnel turf turk
  turkey turn tush tusk tusks tut tutor tutu tuv tux tv tw twa twain tweak
  tweed twice twig twigs twin twine twins twirl twist twisty twit two twos tx
  ty tycoon tying tyke tyler type typed types typo tz u u's u-2 ua ub uc ud
  ue uf ufo ug ugh ugly uh ui uj uk ul ulcer um umpire un uncle uncut under
  undo undue unfit unify union unit unite units unity unix untie until unto
  unwed uo up uphill uphold upi upon upper uproar ups upset uptake uq ur
  urban urge urged urges urine urn us usa usaf usage use used useful uses
  usher usia ussr usual usurp ut utah utmost utter uu uuu uuuu uv uvula uvw
  uw ux uy uz v v's v-8 va vacuum vague vain val vale valet valid valor value
  valve vamp van vance vane vans vapor vary vase vases vast vat vats vault vb
  vc vcr vd ve veal veep veer veers veggie veil vein veins venal vend vendor
  vends venom vent vents venus vera verb verbs verdi verge verify vern verna
  verne verse verve very vessel vest vests vet veto vets vex vexed vexes vf
  vg vh vi via vial vibes vic vice vices vicky video vie viet view vigil
  vigor vii viii vile vinci vine vines vinyl viola violet vip virgil virgo
  virus visa vise visit visor vista vital vito viva vivian vivid vixen vj vk
  vl vlad vm vn vo vocal vodka vogue voice void volt volts volvo vomit vote
  vouch vow vowel vows vp vq vr vs vt vtol vu vulcan vv vvv vvvv vw vwx vx vy
  vz w w's w/o wa wacko wacky wad wade wades wafer waffle wag wage wager
  wages wagon wags wahoo waif wail wails waist wait wake waken waldo walk
  wall walls wally walrus walsh walt walton waltz wand wang want wants war
  ward warm warmth warn warns warp warren wars wart warts wary was wash wasp
  wasps waste watch water watt watts wave waved waver waves wavy wax waxy way
  wayne ways wb wc wd we we'd we'll we're we've weak wealth wear wears weary
  weave web webb webs wed wedge weds wee weed weedy week weeks weep weeps
  weigh weird welch weld well wells welsh wendy went wept were wes west wet
  wets wf wg wh whale wham wharf what wheat whee wheel when where whew which
  whiff while whim whine whinny whip whips whir whirl white whiz who who'd
  whoa whole whom whoop whoosh whose why wi wick wide widen wider widow width
  wield wife wig wigs wild wiley wilkes will wills willy wilma wilt wily wimp
  wimpy win wince winch wind windy wine wines wing wings wink winks winnie
  wino wins winter wipe wire wires wiry wise wiser wish wisp wispy wit witch
  with wits witty wj wk wl wm wn wnw wo woe woes wok woke wolf wolff woman
  womb women won won't wonder wong woo wood woods woody woof wool woos word
  words wordy wore work world worm worms wormy worn worry worse worst worth
  would wound wove woven wow wp wq wr wrap wrath wreak wreck wren wring wrist
  write writhe wrong wrote wry ws wsw wt wu wv ww wwi wwii www wwww wx wxy wy
  wyatt wylie wyman wynn wz x x's xa xb xc xd xe xerox xf xg xh xi xii xiii
  xiv xj xk xl xm xmas xn xo xp xq xr xray xrays xs xt xu xv xvi xvii xw xx
  xxx xxxx xy xyz xz y y'all y's ya yacht yahoo yak yale yam yamaha yams yang
  yank yanks yap yard yards yarn yawn yawns yb yc yd ye yea yeah year yearn
  yeast yeats yell yellow yelp yen yep yes yet yew yews yf yg yh yi yield yin
  yip yips yj yk yl ym yn yo yodel yoga yogi yoke yokel yolk yore york you
  you'd young your yours youth yoyo yp yq yr yrs ys yt ytd yu yucca yuck
  yukon yule yv yw yx yy yyy yyyy yz z z's za zag zap zaps zb zc zd ze zeal
  zealot zebra zeke zen zero zest zesty zeta zf zg zh zi zig ziggy zigzag
  zilch zinc zing zion zip zips ziti zj zk zl zm zn zo zoe zone zoned zoo
  zoom zooms zoos zowie zp zq zr zs zt zu zulu zv zw zx zy zz zzz zzzz !  !!
  """" $ $$ % %% & ( () (c) (r) (tm)) * ** + - 0 007 1 1% 1/2 1/3 1/4
  1/8 10 10% 100 100% 1000 100th 101 101st 10:00 10:30 10th 11 111 1111 11:00
  11:30 11th 12 123 1234 12:00 12:30 12th 13 13th 14 1492 14th 15 15% 1500
  15th 16 1600 16th 17 1700 1776 17th 18 1800 18th 19 1900 1910 1920 1925
  1930 1935 1940 1945 1950 1955 1960 1965 1970 1975 1980 1985 1990 1991 1992
  1993 1994 1995 1996 1997 19th 1:00 1:30 1st 2 2% 2/3 20 20% 200 2000 2001
  2020 20th 21 21st 22 222 2222 22nd 23 234 2345 23rd 24 2468 24th 25 25%
  25th 26 26th 27 27th 28 28th 29 29th 2:00 2:30 2nd 3 3% 3/4 3/8 30 30% 300
  3000 30th 31 31st 32 32nd 33 333 3333 33rd 34 345 3456 34th 35 35% 35th 36
  36th 37 37th 38 38th 39 39th 3:00 3:30 3rd 4 4% 40 40% 400 4000 40th 41
  41st 42 42nd 43 4321 43rd 44 444 4444 44th 45 45% 456 4567 45th 46 46th 47
  47th 48 48th 49 49th 4:00 4:30 4th 5 5% 5/8 50 50% 500 5000 50th 51 51st 52
  52nd 53 53rd 54 54th 55 55% 555 5555 55th 56 567 5678 56th 57 57th 58 58th
  59 59th 5:00 5:30 5th 6 6% 60 60% 600 6000 60th 61 61st 62 62nd 63 63rd 64
  65 65% 65th 66 666 6666 66th 67 678 6789 67th 68 68th 69 69th 6:00 6:30 6th
  7 7% 7/8 70 70% 700 7000 70th 71 71st 72 72nd 73 73rd 74 74th 75 75% 75th
  76 76th 77 777 7777 77th 78 789 78th 79 79th 7:00 7:30 7th 8 8% 80 80% 800
  8000 80th 81 81st 82 82nd 83 83rd 84 84th 85 85% 85th 86 86th 87 87th 88
  888 8888 88th 89 89th 8:00 8:30 8th 9 9% 9-5 90 90% 900 9000 90th 91 91st
  92 92nd 93 93rd 94 94th 95 95% 95th 96 96th 97 97th 98 98% 98.6 9876 98th
  99 99% 999 9999 99th 9:00 9:30 9th : ; = ?  ??  @
};

push @Words, '#', '##', 'c#', 'f#'; # otherwise qw{} complains

1;


# vim: ts=2 sts=2 sw=2 et:

__END__

=pod

=head1 NAME

Crypt::Diceware::Wordlist::Beale - Crypt::Diceware wordlist from the alternative Diceware list

=head1 VERSION

version 0.001

=head1 SYNOPSIS

  use Crypt::Diceware words => { wordlist => 'Beale' };

  my @phrase = words(4);

=head1 DESCRIPTION

The L<alternative English Diceware
wordlist|http://world.std.com/%7Ereinhold/beale.wordlist.asc> by Alan Beale.
Compared to the original, it is said to contain fewer Americanisms and
obscure words.

=for Pod::Coverage method_names_here

=head1 SEE ALSO

=over 4

=item *

L<Crypt::Diceware>

=back

=head1 AUTHOR

David Golden <dagolden@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2013 by David Golden.

This is free software, licensed under:

  The Apache License, Version 2.0, January 2004

=cut
