#!
#  @file           GetInfo.pm
#  @author         DL SAP DB INTERFACES
#  @ingroup        dbd::MaxDB
#  @brief          
#
#\if EMIT_LICENCE
#
#    ========== licence begin  GPL
#    Copyright (c) 2001-2005 SAP AG
#
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of the GNU General Public License
#    as published by the Free Software Foundation; either version 2
#    of the License, or (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#    ========== licence end

#\endif
#*/

require 5.004;

# Experimental implementation. If a SQLDBC metadata object is available, this
# module should not be used anymore.

# The %info hash was automatically generated by
# DBI::DBD::Metadata::write_getinfo_pm v.

package DBD::MaxDB::GetInfo;

use strict;
use DBD::MaxDB();

# Beware: not officially documented interfaces...
# use DBI::Const::GetInfoType qw(%GetInfoType);
# use DBI::Const::GetInfoReturn qw(%GetInfoReturnTypes %GetInfoReturnValues);

my $sql_driver = 'MaxDB';
my $sql_ver_fmt = '%02d.%02d';   # version string: ##.##
my $sql_driver_ver = sprintf $sql_ver_fmt, split (/\./, $DBD::MaxDB::VERSION);

my @Keywords = qw(

ABS
ACOS
ADDDATE
ADDTIME
ALPHA
ASCII
ASIN
ATAN
ATAN2
BINARY
BOOLEAN
BYTE
CEIL
CEILING
CHR
CONCAT
CONNECTED
COS
COSH
COT
CURDATE
CURTIME
DATABASE
DATEDIFF
DAYNAME
DAYOFMONTH
DAYOFWEEK
DAYOFYEAR
DBYTE
DECODE
DEFAULT
DEGREES
DIGITS
DIRECT
EBCDIC
ENTRY
ENTRYDEF
EXP
EXPAND
FIXED
FLOOR
GRAPHIC
GREATEST
HEX
IFNULL
INITCAP
INT
INTERNAL
LCASE
LEAST
LENGTH
LFILL
LINK
LIST
LN
LOCALSYSDBA
LOCATE
LOG
LOG10
LONG
LPAD
LTRIM
MAKEDATE
MAKETIME
MAPCHAR
MBCS
MICROSECOND
MOD
MONTHNAME
NOROUND
NOW
NUM
OBJECT
PACKED
PI
POWER
PREV
RADIANS
REAL
REFERENCED
REJECT
REPLACE
RFILL
ROUND
ROWID
ROWNO
RPAD
RTRIM
SELUPD
SHOW
SIGN
SIN
SINH
SOUNDEX
SPACE
SQRT
STAMP
STATISTICS
STDDEV
SUBDATE
SUBSTR
SUBTIME
SYSDBA
TAN
TANH
TIMEDIFF
TIMEZONE
TOIDENTIFIER
TRIM
TRUNC
TRUNCATE
UCASE
UID
UNICODE
USERGROUP
VARGRAPHIC
VARIANCE
WEEK
WEEKOFYEAR
ZONED
);


sub sql_keywords {

    return join ',', @Keywords;

}



sub sql_data_source_name {
    my $dbh = shift;
    return "dbi:$sql_driver:" . $dbh->{Name};
}

sub sql_user_name {
    my $dbh = shift;
    # CURRENT_USER is a non-standard attribute, probably undef
    # Username is a standard DBI attribute
    return $dbh->{CURRENT_USER} || $dbh->{Username};
}

# our %info = (	# Perl 5.005_03 does not accept 'our'
no strict;
%info = (
     20 => 'N',                           # SQL_ACCESSIBLE_PROCEDURES
     19 => 'N',                           # SQL_ACCESSIBLE_TABLES
      0 => 8,                             # SQL_ACTIVE_CONNECTIONS
    116 => 0,                             # SQL_ACTIVE_ENVIRONMENTS
      1 => 32767,                         # SQL_ACTIVE_STATEMENTS
    169 => 64,                            # SQL_AGGREGATE_FUNCTIONS
    117 => 0,                             # SQL_ALTER_DOMAIN
     86 => 5963,                          # SQL_ALTER_TABLE
  10021 => 2,                             # SQL_ASYNC_MODE
    120 => 0,                             # SQL_BATCH_ROW_COUNT
    121 => 0,                             # SQL_BATCH_SUPPORT
     82 => 80,                            # SQL_BOOKMARK_PERSISTENCE
    114 => 1,                             # SQL_CATALOG_LOCATION
  10003 => 'N',                           # SQL_CATALOG_NAME
     41 => '.',                           # SQL_CATALOG_NAME_SEPARATOR
     42 => 'Qualifier',                   # SQL_CATALOG_TERM
     92 => 0,                             # SQL_CATALOG_USAGE
  10004 => '',                            # SQL_COLLATING_SEQUENCE
  10004 => '',                            # SQL_COLLATION_SEQ
     87 => 'Y',                           # SQL_COLUMN_ALIAS
     22 => 0,                             # SQL_CONCAT_NULL_BEHAVIOR
     53 => 0,                             # SQL_CONVERT_BIGINT
     54 => 0,                             # SQL_CONVERT_BINARY
     55 => 0,                             # SQL_CONVERT_BIT
     56 => 0,                             # SQL_CONVERT_CHAR
     57 => 0,                             # SQL_CONVERT_DATE
     58 => 0,                             # SQL_CONVERT_DECIMAL
     59 => 0,                             # SQL_CONVERT_DOUBLE
     60 => 0,                             # SQL_CONVERT_FLOAT
     48 => 0,                             # SQL_CONVERT_FUNCTIONS
    173 => '-1',                          # SQL_CONVERT_GUID
     61 => 0,                             # SQL_CONVERT_INTEGER
    123 => '-1',                          # SQL_CONVERT_INTERVAL_DAY_TIME
    124 => '-1',                          # SQL_CONVERT_INTERVAL_YEAR_MONTH
     71 => 0,                             # SQL_CONVERT_LONGVARBINARY
     62 => 0,                             # SQL_CONVERT_LONGVARCHAR
     63 => 0,                             # SQL_CONVERT_NUMERIC
     64 => 0,                             # SQL_CONVERT_REAL
     65 => 0,                             # SQL_CONVERT_SMALLINT
     66 => 0,                             # SQL_CONVERT_TIME
     67 => 0,                             # SQL_CONVERT_TIMESTAMP
     68 => 0,                             # SQL_CONVERT_TINYINT
     69 => 0,                             # SQL_CONVERT_VARBINARY
     70 => 0,                             # SQL_CONVERT_VARCHAR
    122 => '-1',                          # SQL_CONVERT_WCHAR
    125 => '-1',                          # SQL_CONVERT_WLONGVARCHAR
    126 => '-1',                          # SQL_CONVERT_WVARCHAR
     74 => 2,                             # SQL_CORRELATION_NAME
    127 => 0,                             # SQL_CREATE_ASSERTION
    128 => 0,                             # SQL_CREATE_CHARACTER_SET
    129 => 0,                             # SQL_CREATE_COLLATION
    130 => 23,                            # SQL_CREATE_DOMAIN
    131 => 0,                             # SQL_CREATE_SCHEMA
    132 => 13841,                         # SQL_CREATE_TABLE
    133 => 0,                             # SQL_CREATE_TRANSLATION
    134 => 3,                             # SQL_CREATE_VIEW
     23 => 2,                             # SQL_CURSOR_COMMIT_BEHAVIOR
     24 => 1,                             # SQL_CURSOR_ROLLBACK_BEHAVIOR
  10001 => 0,                             # SQL_CURSOR_SENSITIVITY
      2 => \&sql_data_source_name,        # SQL_DATA_SOURCE_NAME
     25 => 'N',                           # SQL_DATA_SOURCE_READ_ONLY
    119 => 0,                             # SQL_DATETIME_LITERALS
     17 => '',                            # SQL_DBMS_NAME
     18 => '07.06.000',                   # SQL_DBMS_VER
     18 => '07.06.000',                   # SQL_DBMS_VERSION
    170 => 3,                             # SQL_DDL_INDEX
     26 => 2,                             # SQL_DEFAULT_TRANSACTION_ISOLATION
     26 => 2,                             # SQL_DEFAULT_TXN_ISOLATION
  10002 => 'Y',                           # SQL_DESCRIBE_PARAMETER
    171 => '03.52.9042.0000',             # SQL_DM_VER
      3 => 31072656,                      # SQL_DRIVER_HDBC
#   135 => undef,                         # SQL_DRIVER_HDESC
      4 => 31072480,                      # SQL_DRIVER_HENV
#    76 => undef,                         # SQL_DRIVER_HLIB
#     5 => undef,                         # SQL_DRIVER_HSTMT
      6 => '',                            # SQL_DRIVER_NAME
     77 => '03.51',                       # SQL_DRIVER_ODBC_VER
      7 => $sql_driver_ver,               # SQL_DRIVER_VER
    136 => 0,                             # SQL_DROP_ASSERTION
    137 => 0,                             # SQL_DROP_CHARACTER_SET
    138 => 0,                             # SQL_DROP_COLLATION
    139 => 1,                             # SQL_DROP_DOMAIN
    140 => 0,                             # SQL_DROP_SCHEMA
    141 => 7,                             # SQL_DROP_TABLE
    142 => 0,                             # SQL_DROP_TRANSLATION
    143 => 7,                             # SQL_DROP_VIEW
    144 => 37455,                         # SQL_DYNAMIC_CURSOR_ATTRIBUTES1
    145 => 14,                            # SQL_DYNAMIC_CURSOR_ATTRIBUTES2
     27 => 'N',                           # SQL_EXPRESSIONS_IN_ORDERBY
      8 => 191,                           # SQL_FETCH_DIRECTION
     84 => 0,                             # SQL_FILE_USAGE
    146 => 1,                             # SQL_FORWARD_ONLY_CURSOR_ATTRIBUTES1
    147 => 1,                             # SQL_FORWARD_ONLY_CURSOR_ATTRIBUTES2
     81 => 15,                            # SQL_GETDATA_EXTENSIONS
     88 => 2,                             # SQL_GROUP_BY
     28 => 1,                             # SQL_IDENTIFIER_CASE
     29 => '"',                           # SQL_IDENTIFIER_QUOTE_CHAR
    148 => 3,                             # SQL_INDEX_KEYWORDS
    149 => 0,                             # SQL_INFO_SCHEMA_VIEWS
    172 => 7,                             # SQL_INSERT_STATEMENT
     73 => 'N',                           # SQL_INTEGRITY
    150 => 130639,                        # SQL_KEYSET_CURSOR_ATTRIBUTES1
    151 => 113,                           # SQL_KEYSET_CURSOR_ATTRIBUTES2
     89 => \&sql_keywords,                # SQL_KEYWORDS
    113 => 'Y',                           # SQL_LIKE_ESCAPE_CLAUSE
     78 => 1,                             # SQL_LOCK_TYPES
     34 => 0,                             # SQL_MAXIMUM_CATALOG_NAME_LENGTH
     97 => 128,                           # SQL_MAXIMUM_COLUMNS_IN_GROUP_BY
     98 => 16,                            # SQL_MAXIMUM_COLUMNS_IN_INDEX
     99 => 128,                           # SQL_MAXIMUM_COLUMNS_IN_ORDER_BY
    100 => 1023,                          # SQL_MAXIMUM_COLUMNS_IN_SELECT
    101 => 1023,                          # SQL_MAXIMUM_COLUMNS_IN_TABLE
     30 => 32,                            # SQL_MAXIMUM_COLUMN_NAME_LENGTH
      1 => 32767,                         # SQL_MAXIMUM_CONCURRENT_ACTIVITIES
     31 => 32,                            # SQL_MAXIMUM_CURSOR_NAME_LENGTH
      0 => 8,                             # SQL_MAXIMUM_DRIVER_CONNECTIONS
  10005 => 64,                            # SQL_MAXIMUM_IDENTIFIER_LENGTH
    102 => 1024,                          # SQL_MAXIMUM_INDEX_SIZE
    104 => 0,                             # SQL_MAXIMUM_ROW_SIZE
     32 => 32,                            # SQL_MAXIMUM_SCHEMA_NAME_LENGTH
    105 => 0,                             # SQL_MAXIMUM_STATEMENT_LENGTH
  20000 => '-1',                          # SQL_MAXIMUM_STMT_OCTETS
  20001 => '',                            # SQL_MAXIMUM_STMT_OCTETS_DATA
  20002 => '-1',                          # SQL_MAXIMUM_STMT_OCTETS_SCHEMA
    106 => 64,                            # SQL_MAXIMUM_TABLES_IN_SELECT
     35 => 32,                            # SQL_MAXIMUM_TABLE_NAME_LENGTH
    107 => 32,                            # SQL_MAXIMUM_USER_NAME_LENGTH
  10022 => 0,                             # SQL_MAX_ASYNC_CONCURRENT_STATEMENTS
    112 => 0,                             # SQL_MAX_BINARY_LITERAL_LEN
     34 => 0,                             # SQL_MAX_CATALOG_NAME_LEN
    108 => 0,                             # SQL_MAX_CHAR_LITERAL_LEN
     97 => 128,                           # SQL_MAX_COLUMNS_IN_GROUP_BY
     98 => 16,                            # SQL_MAX_COLUMNS_IN_INDEX
     99 => 128,                           # SQL_MAX_COLUMNS_IN_ORDER_BY
    100 => 1023,                          # SQL_MAX_COLUMNS_IN_SELECT
    101 => 1023,                          # SQL_MAX_COLUMNS_IN_TABLE
     30 => 32,                            # SQL_MAX_COLUMN_NAME_LEN
      1 => 32767,                         # SQL_MAX_CONCURRENT_ACTIVITIES
     31 => 32,                            # SQL_MAX_CURSOR_NAME_LEN
      0 => 8,                             # SQL_MAX_DRIVER_CONNECTIONS
  10005 => 64,                            # SQL_MAX_IDENTIFIER_LEN
    102 => 1024,                          # SQL_MAX_INDEX_SIZE
     32 => 32,                            # SQL_MAX_OWNER_NAME_LEN
     33 => 32,                            # SQL_MAX_PROCEDURE_NAME_LEN
     34 => 0,                             # SQL_MAX_QUALIFIER_NAME_LEN
    104 => 0,                             # SQL_MAX_ROW_SIZE
    103 => 'N',                           # SQL_MAX_ROW_SIZE_INCLUDES_LONG
     32 => 32,                            # SQL_MAX_SCHEMA_NAME_LEN
    105 => 0,                             # SQL_MAX_STATEMENT_LEN
    106 => 64,                            # SQL_MAX_TABLES_IN_SELECT
     35 => 32,                            # SQL_MAX_TABLE_NAME_LEN
    107 => 32,                            # SQL_MAX_USER_NAME_LEN
     37 => 'Y',                           # SQL_MULTIPLE_ACTIVE_TXN
     36 => 'N',                           # SQL_MULT_RESULT_SETS
    111 => 'N',                           # SQL_NEED_LONG_DATA_LEN
     75 => 1,                             # SQL_NON_NULLABLE_COLUMNS
     85 => 1,                             # SQL_NULL_COLLATION
     49 => 15073279,                      # SQL_NUMERIC_FUNCTIONS
      9 => 2,                             # SQL_ODBC_API_CONFORMANCE
    152 => '',                           # SQL_ODBC_INTERFACE_CONFORMANCE
     12 => 1,                             # SQL_ODBC_SAG_CLI_CONFORMANCE
     15 => 2,                             # SQL_ODBC_SQL_CONFORMANCE
     73 => 'N',                           # SQL_ODBC_SQL_OPT_IEF
     10 => '03.52.0000',                  # SQL_ODBC_VER
    115 => '-1',                          # SQL_OJ_CAPABILITIES
     90 => 'N',                           # SQL_ORDER_BY_COLUMNS_IN_SELECT
     38 => 'Y',                           # SQL_OUTER_JOINS
    115 => '-1',                          # SQL_OUTER_JOIN_CAPABILITIES
     39 => 'Owner',                       # SQL_OWNER_TERM
     91 => 31,                            # SQL_OWNER_USAGE
    153 => 0,                             # SQL_PARAM_ARRAY_ROW_COUNTS
    154 => 3,                             # SQL_PARAM_ARRAY_SELECTS
     80 => 7,                             # SQL_POSITIONED_STATEMENTS
     79 => 31,                            # SQL_POS_OPERATIONS
     21 => 'Y',                           # SQL_PROCEDURES
     40 => 'stored procedure',            # SQL_PROCEDURE_TERM
    114 => 1,                             # SQL_QUALIFIER_LOCATION
     41 => '.',                           # SQL_QUALIFIER_NAME_SEPARATOR
     42 => 'Qualifier',                   # SQL_QUALIFIER_TERM
     92 => 0,                             # SQL_QUALIFIER_USAGE
     93 => 3,                             # SQL_QUOTED_IDENTIFIER_CASE
     11 => 'Y',                           # SQL_ROW_UPDATES
     39 => 'Owner',                       # SQL_SCHEMA_TERM
     91 => 31,                            # SQL_SCHEMA_USAGE
     43 => 15,                            # SQL_SCROLL_CONCURRENCY
     44 => 23,                            # SQL_SCROLL_OPTIONS
     14 => '\\',                          # SQL_SEARCH_PATTERN_ESCAPE
     13 => '',                            # SQL_SERVER_NAME
     94 => '#@$',                         # SQL_SPECIAL_CHARACTERS
    155 => 0,                             # SQL_SQL92_DATETIME_FUNCTIONS
    156 => 0,                             # SQL_SQL92_FOREIGN_KEY_DELETE_RULE
    157 => 0,                             # SQL_SQL92_FOREIGN_KEY_UPDATE_RULE
    158 => 0,                             # SQL_SQL92_GRANT
    159 => 0,                             # SQL_SQL92_NUMERIC_VALUE_FUNCTIONS
    160 => 0,                             # SQL_SQL92_PREDICATES
    161 => 0,                             # SQL_SQL92_RELATIONAL_JOIN_OPERATORS
    162 => 0,                             # SQL_SQL92_REVOKE
    163 => 0,                             # SQL_SQL92_ROW_VALUE_CONSTRUCTOR
    164 => 0,                             # SQL_SQL92_STRING_FUNCTIONS
    165 => 0,                             # SQL_SQL92_VALUE_EXPRESSIONS
    118 => 1,                             # SQL_SQL_CONFORMANCE
    166 => 0,                             # SQL_STANDARD_CLI_CONFORMANCE
    167 => 65103,                         # SQL_STATIC_CURSOR_ATTRIBUTES1
    168 => 14,                            # SQL_STATIC_CURSOR_ATTRIBUTES2
     83 => 0,                             # SQL_STATIC_SENSITIVITY
     50 => 204669,                        # SQL_STRING_FUNCTIONS
     95 => 23,                            # SQL_SUBQUERIES
     51 => 7,                             # SQL_SYSTEM_FUNCTIONS
     45 => 'Table',                       # SQL_TABLE_TERM
    109 => 0,                             # SQL_TIMEDATE_ADD_INTERVALS
    110 => 0,                             # SQL_TIMEDATE_DIFF_INTERVALS
     52 => 106431,                        # SQL_TIMEDATE_FUNCTIONS
     46 => 2,                             # SQL_TRANSACTION_CAPABLE
     72 => 15,                            # SQL_TRANSACTION_ISOLATION_OPTION
     46 => 2,                             # SQL_TXN_CAPABLE
     72 => 15,                            # SQL_TXN_ISOLATION_OPTION
     96 => 3,                             # SQL_UNION
     96 => 3,                             # SQL_UNION_STATEMENT
     47 => \&sql_user_name,               # SQL_USER_NAME
  10000 => 1995,                          # SQL_XOPEN_CLI_YEAR
);

1;

__END__
