
use strict;
use warnings;



use ExtUtils::MakeMaker 6.30;



my %WriteMakefileArgs = (
  "ABSTRACT" => "Search::Query dialect for simple DBIx::Class query generation",
  "AUTHOR" => "Alexander Hartmaier <abraxxa\@cpan.org>",
  "BUILD_REQUIRES" => {
    "Config::General" => "2.51",
    "Test::DBIx::Class" => "0.35",
    "Test::More" => "0.98"
  },
  "CONFIGURE_REQUIRES" => {
    "ExtUtils::MakeMaker" => "6.30"
  },
  "DISTNAME" => "Search-Query-Dialect-DBIxClass",
  "EXE_FILES" => [],
  "LICENSE" => "perl",
  "NAME" => "Search::Query::Dialect::DBIxClass",
  "PREREQ_PM" => {
    "Search::Query" => "0.21"
  },
  "VERSION" => "0.003",
  "test" => {
    "TESTS" => "t/*.t"
  }
);


unless ( eval { ExtUtils::MakeMaker->VERSION(6.56) } ) {
  my $br = delete $WriteMakefileArgs{BUILD_REQUIRES};
  my $pp = $WriteMakefileArgs{PREREQ_PM};
  for my $mod ( keys %$br ) {
    if ( exists $pp->{$mod} ) {
      $pp->{$mod} = $br->{$mod} if $br->{$mod} > $pp->{$mod};
    }
    else {
      $pp->{$mod} = $br->{$mod};
    }
  }
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);



