
use strict;
use warnings;



use ExtUtils::MakeMaker 6.30;



my %WriteMakefileArgs = (
  "ABSTRACT" => "a library for sending email",
  "AUTHOR" => "Ricardo Signes <rjbs\@cpan.org>",
  "BUILD_REQUIRES" => {},
  "CONFIGURE_REQUIRES" => {
    "ExtUtils::MakeMaker" => "6.30"
  },
  "DISTNAME" => "Email-Sender",
  "EXE_FILES" => [],
  "LICENSE" => "perl",
  "NAME" => "Email::Sender",
  "PREREQ_PM" => {
    "Carp" => 0,
    "Email::Abstract" => "3.006",
    "Email::Address" => 0,
    "Email::Simple" => "1.998",
    "Fcntl" => 0,
    "File::Basename" => 0,
    "File::Path" => 0,
    "File::Spec" => 0,
    "IO::File" => 0,
    "IO::Handle" => 0,
    "List::MoreUtils" => 0,
    "Module::Runtime" => 0,
    "Moo" => "1.000008",
    "Moo::Role" => 0,
    "MooX::Types::MooseLike" => "0.15",
    "MooX::Types::MooseLike::Base" => 0,
    "Net::SMTP" => 0,
    "Scalar::Util" => 0,
    "Sub::Exporter" => 0,
    "Sub::Exporter::Util" => 0,
    "Sys::Hostname" => 0,
    "Throwable::Error" => "0.200003",
    "Try::Tiny" => 0,
    "strict" => 0,
    "warnings" => 0
  },
  "TEST_REQUIRES" => {
    "Capture::Tiny" => "0.08",
    "Cwd" => 0,
    "Exporter" => 0,
    "File::Temp" => 0,
    "Test::More" => "0.96",
    "blib" => 0,
    "lib" => 0
  },
  "VERSION" => "1.300009",
  "test" => {
    "TESTS" => "t/*.t"
  }
);


unless ( eval { ExtUtils::MakeMaker->VERSION(6.63_03) } ) {
  my $tr = delete $WriteMakefileArgs{TEST_REQUIRES};
  my $br = $WriteMakefileArgs{BUILD_REQUIRES};
  for my $mod ( keys %$tr ) {
    if ( exists $br->{$mod} ) {
      $br->{$mod} = $tr->{$mod} if $tr->{$mod} > $br->{$mod};
    }
    else {
      $br->{$mod} = $tr->{$mod};
    }
  }
}

unless ( eval { ExtUtils::MakeMaker->VERSION(6.56) } ) {
  my $br = delete $WriteMakefileArgs{BUILD_REQUIRES};
  my $pp = $WriteMakefileArgs{PREREQ_PM};
  for my $mod ( keys %$br ) {
    if ( exists $pp->{$mod} ) {
      $pp->{$mod} = $br->{$mod} if $br->{$mod} > $pp->{$mod};
    }
    else {
      $pp->{$mod} = $br->{$mod};
    }
  }
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);



