/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.internal.selenesedriver;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.thoughtworks.selenium.Selenium;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.openqa.selenium.internal.selenesedriver.AbstractElementFinder;

public class FindElements
extends AbstractElementFinder<List<Map<String, String>>> {
    private static final String SCRIPT = "selenium.browserbot.findElementsLikeWebDriver('%s', '%s', %s);";

    @Override
    protected List<Map<String, String>> executeFind(Selenium selenium, String how, String using, String parentLocator) {
        String result = selenium.getEval(String.format(SCRIPT, how, using, parentLocator));
        Iterable<String> allKeys = Splitter.on(",").split(result);
        ArrayList<Map<String, String>> toReturn = Lists.newArrayList();
        for (String key : allKeys) {
            if (key.length() <= 0) continue;
            toReturn.add(this.newElement(key));
        }
        return toReturn;
    }

    @Override
    protected List<Map<String, String>> onFailure(String how, String using) {
        return Lists.newArrayList();
    }
}

