/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.logging;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.logging.Level;

public class LogLevelMapping {
    private static Map<Long, Level> levelMap;
    private static final String DEBUG = "DEBUG";

    static {
        Level[] supportedLevels = new Level[]{Level.ALL, Level.FINE, Level.INFO, Level.WARNING, Level.SEVERE, Level.OFF};
        ImmutableMap.Builder<Long, Level> builder = ImmutableMap.builder();
        Level[] levelArray = supportedLevels;
        int n = supportedLevels.length;
        int n2 = 0;
        while (n2 < n) {
            Level level = levelArray[n2];
            builder.put(Long.valueOf(level.intValue()), level);
            ++n2;
        }
        levelMap = builder.build();
    }

    public static Level toLevel(long longValue) {
        return levelMap.get(longValue);
    }

    public static Level toLevel(String logLevelName) {
        if (logLevelName.equals(DEBUG)) {
            return Level.FINE;
        }
        return levelMap.get(Level.parse(logLevelName).intValue());
    }
}

