/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server.handler;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.server.JsonParametersAware;
import org.openqa.selenium.remote.server.Session;
import org.openqa.selenium.remote.server.handler.WebElementHandler;
import org.openqa.selenium.remote.server.rest.ResultType;

public class FindChildElement
extends WebElementHandler
implements JsonParametersAware {
    private volatile By by;

    public FindChildElement(Session session) {
        super(session);
    }

    @Override
    public void setJsonParameters(Map<String, Object> allParameters) throws Exception {
        this.by = this.newBySelector().pickFromJsonParameters(allParameters);
    }

    @Override
    public ResultType call() throws Exception {
        WebElement element = this.getElement().findElement(this.by);
        String elementId = this.getKnownElements().add(element);
        this.response.setValue(ImmutableMap.of("ELEMENT", elementId));
        return ResultType.SUCCESS;
    }

    public String toString() {
        return String.format("[find child element: %s, %s]", this.getElementAsString(), this.by);
    }
}

