/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server.commands;

import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import org.openqa.selenium.internal.Base64Encoder;
import org.openqa.selenium.server.RobotRetriever;

public class CaptureScreenshotToStringCommand {
    public static final String ID = "captureScreenshotToString";
    private static final Logger log = Logger.getLogger(CaptureScreenshotToStringCommand.class.getName());

    public String execute() {
        try {
            return "OK," + this.captureAndEncodeSystemScreenshot();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Problem capturing a screenshot to string", e);
            return "ERROR: Problem capturing a screenshot to string: " + e.getMessage();
        }
    }

    public String captureAndEncodeSystemScreenshot() throws InterruptedException, ExecutionException, TimeoutException, IOException {
        Robot robot = RobotRetriever.getRobot();
        Rectangle captureSize = new Rectangle(Toolkit.getDefaultToolkit().getScreenSize());
        BufferedImage bufferedImage = robot.createScreenCapture(captureSize);
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)bufferedImage, "png", outStream);
        return new Base64Encoder().encode(outStream.toByteArray());
    }
}

