/*
 * Decompiled with CFR 0.152.
 */
package org.seleniumhq.jetty7.server.nio;

import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.seleniumhq.jetty7.io.NetworkTrafficListener;
import org.seleniumhq.jetty7.io.nio.NetworkTrafficSelectChannelEndPoint;
import org.seleniumhq.jetty7.io.nio.SelectChannelEndPoint;
import org.seleniumhq.jetty7.io.nio.SelectorManager;
import org.seleniumhq.jetty7.server.nio.SelectChannelConnector;

public class NetworkTrafficSelectChannelConnector
extends SelectChannelConnector {
    private final List<NetworkTrafficListener> listeners = new CopyOnWriteArrayList<NetworkTrafficListener>();

    public void addNetworkTrafficListener(NetworkTrafficListener listener) {
        this.listeners.add(listener);
    }

    public void removeNetworkTrafficListener(NetworkTrafficListener listener) {
        this.listeners.remove(listener);
    }

    protected SelectChannelEndPoint newEndPoint(SocketChannel channel, SelectorManager.SelectSet selectSet, SelectionKey key) throws IOException {
        NetworkTrafficSelectChannelEndPoint endPoint = new NetworkTrafficSelectChannelEndPoint(channel, selectSet, key, this._maxIdleTime, this.listeners);
        endPoint.setConnection(selectSet.getManager().newConnection(channel, endPoint, key.attachment()));
        endPoint.notifyOpened();
        return endPoint;
    }

    protected void endPointClosed(SelectChannelEndPoint endpoint) {
        super.endPointClosed(endpoint);
        ((NetworkTrafficSelectChannelEndPoint)endpoint).notifyClosed();
    }
}

