/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.jetty.servlet;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.openqa.jetty.http.HttpFields;
import org.openqa.jetty.log.LogFactory;
import org.openqa.jetty.util.IO;
import org.openqa.jetty.util.LineInput;
import org.openqa.jetty.util.LogSupport;
import org.openqa.jetty.util.StringUtil;

public class CGI
extends HttpServlet {
    private static Log log = LogFactory.getLog(CGI.class);
    protected File _docRoot;
    protected String _path;
    protected String _cmdPrefix;
    protected EnvList _env;

    @Override
    public void init() throws ServletException {
        this._env = new EnvList();
        this._cmdPrefix = this.getInitParameter("commandPrefix");
        String tmp = this.getInitParameter("cgibinResourceBase");
        if (tmp == null) {
            tmp = this.getServletContext().getRealPath("/");
        }
        if (log.isDebugEnabled()) {
            log.debug("CGI: CGI bin " + tmp);
        }
        if (tmp == null) {
            log.warn("CGI: no CGI bin !");
            throw new ServletException();
        }
        File dir2 = new File(tmp);
        if (!dir2.exists()) {
            log.warn("CGI: CGI bin does not exist - " + dir2);
            throw new ServletException();
        }
        if (!dir2.canRead()) {
            log.warn("CGI: CGI bin is not readable - " + dir2);
            throw new ServletException();
        }
        if (!dir2.isDirectory()) {
            log.warn("CGI: CGI bin is not a directory - " + dir2);
            throw new ServletException();
        }
        try {
            this._docRoot = dir2.getCanonicalFile();
            if (log.isDebugEnabled()) {
                log.debug("CGI: CGI bin accepted - " + this._docRoot);
            }
        }
        catch (IOException e) {
            log.warn("CGI: CGI bin failed - " + dir2);
            e.printStackTrace();
            throw new ServletException();
        }
        this._path = this.getInitParameter("Path");
        if (log.isDebugEnabled()) {
            log.debug("CGI: PATH accepted - " + this._path);
        }
        if (this._path != null) {
            this._env.set("PATH", this._path);
        }
        Enumeration e = this.getInitParameterNames();
        while (e.hasMoreElements()) {
            String n = (String)e.nextElement();
            if (n == null || !n.startsWith("ENV_")) continue;
            this._env.set(n.substring(4), this.getInitParameter(n));
        }
    }

    @Override
    public void service(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String both;
        String pathInContext = String.valueOf(StringUtil.nonNull(req.getServletPath())) + StringUtil.nonNull(req.getPathInfo());
        if (log.isDebugEnabled()) {
            log.debug("CGI: req.getContextPath() : " + req.getContextPath());
        }
        if (log.isDebugEnabled()) {
            log.debug("CGI: req.getServletPath() : " + req.getServletPath());
        }
        if (log.isDebugEnabled()) {
            log.debug("CGI: req.getPathInfo()    : " + req.getPathInfo());
        }
        if (log.isDebugEnabled()) {
            log.debug("CGI: _docRoot             : " + this._docRoot);
        }
        String first = both = pathInContext;
        String last = "";
        File exe = new File(this._docRoot, first);
        while ((first.endsWith("/") || !exe.exists()) && first.length() >= 0) {
            int index = first.lastIndexOf(47);
            first = first.substring(0, index);
            last = both.substring(index, both.length());
            exe = new File(this._docRoot, first);
        }
        if (first.length() == 0 || !exe.exists() || !exe.getCanonicalPath().equals(exe.getAbsolutePath()) || exe.isDirectory()) {
            res.sendError(404);
        } else {
            if (log.isDebugEnabled()) {
                log.debug("CGI: script is " + exe);
            }
            if (log.isDebugEnabled()) {
                log.debug("CGI: pathInfo is " + last);
            }
            this.exec(exe, last, req, res);
        }
    }

    private void exec(File command, String pathInfo, HttpServletRequest req, HttpServletResponse res) throws IOException {
        Process p;
        block21: {
            String path = command.toString();
            File dir2 = command.getParentFile();
            if (log.isDebugEnabled()) {
                log.debug("CGI: execing: " + path);
            }
            EnvList env = new EnvList(this._env);
            env.set("AUTH_TYPE", req.getAuthType());
            env.set("CONTENT_LENGTH", Integer.toString(req.getContentLength()));
            env.set("CONTENT_TYPE", req.getContentType());
            env.set("GATEWAY_INTERFACE", "CGI/1.1");
            env.set("PATH_INFO", pathInfo);
            env.set("PATH_TRANSLATED", req.getPathTranslated());
            env.set("QUERY_STRING", req.getQueryString());
            env.set("REMOTE_ADDR", req.getRemoteAddr());
            env.set("REMOTE_HOST", req.getRemoteHost());
            env.set("REMOTE_USER", req.getRemoteUser());
            env.set("REQUEST_METHOD", req.getMethod());
            String scriptName = req.getRequestURI().substring(0, req.getRequestURI().length() - pathInfo.length());
            env.set("SCRIPT_NAME", scriptName);
            env.set("SCRIPT_FILENAME", this.getServletContext().getRealPath(scriptName));
            env.set("SERVER_NAME", req.getServerName());
            env.set("SERVER_PORT", Integer.toString(req.getServerPort()));
            env.set("SERVER_PROTOCOL", req.getProtocol());
            env.set("SERVER_SOFTWARE", this.getServletContext().getServerInfo());
            Enumeration enm = req.getHeaderNames();
            while (enm.hasMoreElements()) {
                String name = (String)enm.nextElement();
                String value = req.getHeader(name);
                env.set("HTTP_" + name.toUpperCase().replace('-', '_'), value);
            }
            env.set("HTTPS", req.isSecure() ? "ON" : "OFF");
            String execCmd = path;
            if (execCmd.indexOf(" ") >= 0) {
                execCmd = "\"" + execCmd + "\"";
            }
            if (this._cmdPrefix != null) {
                execCmd = String.valueOf(this._cmdPrefix) + " " + execCmd;
            }
            p = dir2 == null ? Runtime.getRuntime().exec(execCmd, env.getEnvArray()) : Runtime.getRuntime().exec(execCmd, env.getEnvArray(), dir2);
            final ServletInputStream inFromReq = req.getInputStream();
            final OutputStream outToCgi = p.getOutputStream();
            final int inputLength = req.getContentLength();
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (inputLength > 0) {
                            IO.copy(inFromReq, outToCgi, (long)inputLength);
                        }
                        outToCgi.close();
                    }
                    catch (IOException e) {
                        LogSupport.ignore(log, e);
                    }
                }
            }).start();
            try {
                LineInput li = new LineInput(p.getInputStream());
                HttpFields fields = new HttpFields();
                fields.read(li);
                String ContentStatus = "Status";
                String redirect = fields.get("Location");
                String status = fields.get(ContentStatus);
                if (status != null) {
                    log.debug("Found a Status header - setting status on response");
                    fields.remove(ContentStatus);
                    int i = status.indexOf(32);
                    if (i > 0) {
                        status = status.substring(0, i);
                    }
                    res.setStatus(Integer.parseInt(status));
                }
                Iterator i = fields.iterator();
                while (i.hasNext()) {
                    HttpFields.Entry e = (HttpFields.Entry)i.next();
                    res.addHeader(e.getKey(), e.getValue());
                }
                if (status == null && redirect != null) {
                    if (!redirect.startsWith("http:/") && !redirect.startsWith("https:/")) {
                        res.sendRedirect(redirect);
                    } else {
                        res.setStatus(302);
                    }
                }
                IO.copy(li, res.getOutputStream());
                p.waitFor();
                int exitValue = p.exitValue();
                if (log.isDebugEnabled()) {
                    log.debug("CGI: p.exitValue(): " + exitValue);
                }
                if (exitValue != 0) {
                    log.warn("Non-zero exit status (" + exitValue + ") from CGI program: " + path);
                    if (!res.isCommitted()) {
                        res.sendError(500, "Failed to exec CGI");
                    }
                }
            }
            catch (IOException iOException) {
                log.debug("CGI: Client closed connection!");
                p.destroy();
                break block21;
            }
            catch (InterruptedException interruptedException) {
                try {
                    log.debug("CGI: interrupted!");
                    break block21;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    p.destroy();
                }
            }
            p.destroy();
        }
        if (log.isDebugEnabled()) {
            log.debug("CGI: Finished exec: " + p);
        }
    }

    private static class EnvList {
        private Map envMap;

        EnvList() {
            this.envMap = new HashMap();
        }

        EnvList(EnvList l) {
            this.envMap = new HashMap(l.envMap);
        }

        public void set(String name, String value) {
            this.envMap.put(name, String.valueOf(name) + "=" + StringUtil.nonNull(value));
        }

        public String[] getEnvArray() {
            return this.envMap.values().toArray(new String[this.envMap.size()]);
        }
    }
}

