/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server.handler;

import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.server.Session;
import org.openqa.selenium.remote.server.handler.WebDriverHandler;
import org.openqa.selenium.remote.server.rest.ResultType;
import org.openqa.selenium.server.log.LoggingManager;
import org.openqa.selenium.server.log.PerSessionLogHandler;

public class DeleteSession
extends WebDriverHandler {
    public DeleteSession(Session session) {
        super(session);
    }

    @Override
    public ResultType call() throws Exception {
        WebDriver driver = this.getDriver();
        if (driver == null) {
            return ResultType.SUCCESS;
        }
        try {
            LoggingManager.perSessionLogHandler().fetchAndStoreLogsFromDriver(this.getSessionId(), driver);
        }
        catch (Throwable throwable) {}
        driver.quit();
        PerSessionLogHandler logHandler = LoggingManager.perSessionLogHandler();
        logHandler.transferThreadTempLogsToSessionLogs(this.getSessionId());
        return ResultType.SUCCESS;
    }

    public String toString() {
        return String.format("[delete session: %s]", this.getRealSessionId());
    }
}

