/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server.browserlaunchers;

import com.google.common.collect.Maps;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.browserlaunchers.BrowserLauncher;
import org.openqa.selenium.remote.server.DriverSessions;
import org.openqa.selenium.server.RemoteControlConfiguration;
import org.openqa.selenium.server.browserlaunchers.BrowserOptions;
import org.openqa.selenium.server.browserlaunchers.BrowserStringParser;
import org.openqa.selenium.server.browserlaunchers.CustomBrowserLauncher;
import org.openqa.selenium.server.browserlaunchers.DrivenSeleniumLauncher;
import org.openqa.selenium.server.browserlaunchers.Firefox2Launcher;
import org.openqa.selenium.server.browserlaunchers.Firefox3Launcher;
import org.openqa.selenium.server.browserlaunchers.FirefoxChromeLauncher;
import org.openqa.selenium.server.browserlaunchers.FirefoxCustomProfileLauncher;
import org.openqa.selenium.server.browserlaunchers.FirefoxLauncher;
import org.openqa.selenium.server.browserlaunchers.GoogleChromeLauncher;
import org.openqa.selenium.server.browserlaunchers.HTABrowserLauncher;
import org.openqa.selenium.server.browserlaunchers.InternetExplorerCustomProxyLauncher;
import org.openqa.selenium.server.browserlaunchers.InternetExplorerLauncher;
import org.openqa.selenium.server.browserlaunchers.KonquerorLauncher;
import org.openqa.selenium.server.browserlaunchers.MockBrowserLauncher;
import org.openqa.selenium.server.browserlaunchers.OperaCustomProfileLauncher;
import org.openqa.selenium.server.browserlaunchers.ProxyInjectionFirefoxCustomProfileLauncher;
import org.openqa.selenium.server.browserlaunchers.ProxyInjectionInternetExplorerCustomProxyLauncher;
import org.openqa.selenium.server.browserlaunchers.SafariCustomProfileLauncher;
import org.openqa.selenium.server.browserlaunchers.SafariLauncher;

public class BrowserLauncherFactory {
    private static Logger log = Logger.getLogger(BrowserLauncherFactory.class.getName());
    private static final Pattern CUSTOM_PATTERN = Pattern.compile("^\\*?custom( .*)?$");
    private static final Map<String, Class<? extends BrowserLauncher>> supportedBrowsers = Maps.newHashMap();
    private final DriverSessions webdriverSessions;

    static {
        supportedBrowsers.put("firefoxproxy", FirefoxCustomProfileLauncher.class);
        supportedBrowsers.put("firefox", FirefoxLauncher.class);
        supportedBrowsers.put("chrome", FirefoxChromeLauncher.class);
        supportedBrowsers.put("firefoxchrome", FirefoxChromeLauncher.class);
        supportedBrowsers.put("firefox2", Firefox2Launcher.class);
        supportedBrowsers.put("firefox3", Firefox3Launcher.class);
        supportedBrowsers.put("iexploreproxy", InternetExplorerCustomProxyLauncher.class);
        supportedBrowsers.put("safari", SafariLauncher.class);
        supportedBrowsers.put("safariproxy", SafariCustomProfileLauncher.class);
        supportedBrowsers.put("iehta", HTABrowserLauncher.class);
        supportedBrowsers.put("iexplore", InternetExplorerLauncher.class);
        supportedBrowsers.put("opera", OperaCustomProfileLauncher.class);
        supportedBrowsers.put("piiexplore", ProxyInjectionInternetExplorerCustomProxyLauncher.class);
        supportedBrowsers.put("pifirefox", ProxyInjectionFirefoxCustomProfileLauncher.class);
        supportedBrowsers.put("konqueror", KonquerorLauncher.class);
        supportedBrowsers.put("mock", MockBrowserLauncher.class);
        supportedBrowsers.put("googlechrome", GoogleChromeLauncher.class);
        supportedBrowsers.put("webdriver", DrivenSeleniumLauncher.class);
    }

    public BrowserLauncherFactory() {
        this(null);
    }

    public BrowserLauncherFactory(DriverSessions webdriverSessions) {
        this.webdriverSessions = webdriverSessions;
    }

    public BrowserLauncher getBrowserLauncher(String browser, String sessionId, RemoteControlConfiguration configuration, Capabilities browserOptions) {
        if (browser == null) {
            throw new IllegalArgumentException("browser may not be null");
        }
        String executablePath = null;
        if (BrowserOptions.hasOptionsSet(browserOptions)) {
            executablePath = BrowserOptions.getExecutablePath(browserOptions);
        } else {
            configuration.copySettingsIntoBrowserOptions(browserOptions);
        }
        for (String key : supportedBrowsers.keySet()) {
            BrowserStringParser.Result result = new BrowserStringParser().parseBrowserStartCommand(key, browser);
            if (!result.match()) continue;
            if (executablePath == null) {
                executablePath = result.customLauncher();
                browserOptions = BrowserOptions.setExecutablePath(browserOptions, executablePath);
            }
            log.fine("Requested browser string '" + browser + "' matches *" + key + " ");
            return this.createBrowserLauncher(supportedBrowsers.get(key), executablePath, sessionId, configuration, browserOptions);
        }
        log.fine("Requested browser string '" + browser + "' does not match any known browser, treating it as a custom browser...");
        Matcher CustomMatcher2 = CUSTOM_PATTERN.matcher(browser);
        if (CustomMatcher2.find()) {
            String browserStartCommand = CustomMatcher2.group(1);
            if (browserStartCommand == null) {
                throw new RuntimeException("You must specify the path to an executable when using *custom!\n\n");
            }
            browserStartCommand = browserStartCommand.substring(1);
            return new CustomBrowserLauncher(browserStartCommand, sessionId, configuration, browserOptions);
        }
        throw this.browserNotSupported(browser);
    }

    public static Map<String, Class<? extends BrowserLauncher>> getSupportedLaunchers() {
        return supportedBrowsers;
    }

    public static void addBrowserLauncher(String browser, Class<? extends BrowserLauncher> clazz) {
        supportedBrowsers.put(browser, clazz);
    }

    private RuntimeException browserNotSupported(String browser) {
        StringBuffer errorMessage = new StringBuffer("Browser not supported: " + browser);
        errorMessage.append('\n');
        if (!browser.startsWith("*")) {
            errorMessage.append("(Did you forget to add a *?)\n");
        }
        errorMessage.append('\n');
        errorMessage.append("Supported browsers include:\n");
        for (String name : supportedBrowsers.keySet()) {
            errorMessage.append("  *").append(name).append('\n');
        }
        errorMessage.append("  *custom\n");
        return new RuntimeException(errorMessage.toString());
    }

    private BrowserLauncher createBrowserLauncher(Class<? extends BrowserLauncher> c, String browserStartCommand, String sessionId, RemoteControlConfiguration configuration, Capabilities browserOptions) {
        try {
            try {
                Constructor<? extends BrowserLauncher> ctor = c.getConstructor(Capabilities.class, RemoteControlConfiguration.class, String.class, String.class);
                BrowserLauncher browserLauncher = ctor.newInstance(browserOptions, configuration, sessionId, browserStartCommand);
                if (browserLauncher instanceof DrivenSeleniumLauncher) {
                    ((DrivenSeleniumLauncher)browserLauncher).setDriverSessions(this.webdriverSessions);
                }
                return browserLauncher;
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }
}

