/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host;

import com.gargoylesoftware.htmlunit.ScriptResult;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HtmlBody;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.host.Event;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.htmlunit.corejs.javascript.Function;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventListenersContainer
implements Serializable {
    private static final long serialVersionUID = -4612648636521726975L;
    private static final Log LOG = LogFactory.getLog(EventListenersContainer.class);
    private final Map<String, Handlers> eventHandlers_ = new HashMap<String, Handlers>();
    private final SimpleScriptable jsNode_;

    EventListenersContainer(SimpleScriptable jsNode) {
        this.jsNode_ = jsNode;
    }

    public boolean addEventListener(String type, Function listener, boolean useCapture) {
        List<Function> listeners = this.getHandlersOrCreateIt(type).getHandlers(useCapture);
        if (listeners.contains(listener)) {
            LOG.debug((Object)(type + " listener already registered, skipping it (" + listener + ")"));
            return false;
        }
        listeners.add(listener);
        return true;
    }

    private Handlers getHandlersOrCreateIt(String type) {
        Handlers handlers = this.eventHandlers_.get(type.toLowerCase());
        if (handlers == null) {
            handlers = new Handlers();
            this.eventHandlers_.put(type.toLowerCase(), handlers);
        }
        return handlers;
    }

    private List<Function> getHandlers(String eventType, boolean useCapture) {
        Handlers handlers = this.eventHandlers_.get(eventType.toLowerCase());
        if (handlers != null) {
            return handlers.getHandlers(useCapture);
        }
        return null;
    }

    public void removeEventListener(String type, Function listener, boolean useCapture) {
        List<Function> handlers = this.getHandlers(type, useCapture);
        if (handlers != null) {
            handlers.remove(listener);
        }
    }

    public void setEventHandlerProp(String eventName, Object value) {
        Handlers handlers = this.getHandlersOrCreateIt(eventName);
        handlers.handler_ = value;
    }

    public Object getEventHandlerProp(String eventName) {
        Handlers handlers = this.eventHandlers_.get(eventName);
        if (handlers == null) {
            return null;
        }
        return handlers.handler_;
    }

    private ScriptResult executeEventListeners(boolean useCapture, Event event, Object[] args) {
        boolean ie = this.jsNode_.getWindow().getWebWindow().getWebClient().getBrowserVersion().isIE();
        ScriptResult allResult = null;
        List<Function> handlers = this.getHandlers(event.jsxGet_type(), useCapture);
        if (handlers != null && !handlers.isEmpty()) {
            event.setCurrentTarget((Scriptable)this.jsNode_);
            DomNode node = this.jsNode_.getDomNodeOrDie();
            HtmlPage page = (HtmlPage)node.getPage();
            ArrayList<Function> handlersToExecute = new ArrayList<Function>(handlers);
            for (Function listener : handlersToExecute) {
                ScriptResult result = page.executeJavaScriptFunctionIfPossible(listener, (Scriptable)this.jsNode_, args, node);
                if (event.isPropagationStopped()) {
                    allResult = result;
                }
                if (!ie) continue;
                if (ScriptResult.isFalse(result)) {
                    allResult = result;
                    continue;
                }
                Object eventReturnValue = event.jsxGet_returnValue();
                if (!(eventReturnValue instanceof Boolean) || ((Boolean)eventReturnValue).booleanValue()) continue;
                allResult = new ScriptResult(false, page);
            }
        }
        return allResult;
    }

    private ScriptResult executeEventHandler(Event event, Object[] propHandlerArgs) {
        Function handler = this.getEventHandler(event.jsxGet_type());
        if (handler != null) {
            DomNode node = this.jsNode_.getDomNodeOrDie();
            event.setCurrentTarget((Scriptable)this.jsNode_);
            HtmlPage page = (HtmlPage)node.getPage();
            LOG.debug((Object)("Executing " + event.jsxGet_type() + " handler for " + node));
            return page.executeJavaScriptFunctionIfPossible(handler, (Scriptable)this.jsNode_, propHandlerArgs, node);
        }
        return null;
    }

    public ScriptResult executeBubblingListeners(Event event, Object[] args, Object[] propHandlerArgs) {
        ScriptResult newResult;
        ScriptResult result = null;
        if (!(this.jsNode_.getDomNodeOrDie() instanceof HtmlBody)) {
            result = this.executeEventHandler(event, propHandlerArgs);
            if (event.isPropagationStopped()) {
                return result;
            }
        }
        if ((newResult = this.executeEventListeners(false, event, args)) != null) {
            result = newResult;
        }
        return result;
    }

    public ScriptResult executeCapturingListeners(Event event, Object[] args) {
        return this.executeEventListeners(true, event, args);
    }

    public Function getEventHandler(String eventName) {
        Object handler = this.getEventHandlerProp(eventName.toLowerCase());
        if (handler instanceof Function) {
            return (Function)handler;
        }
        return null;
    }

    public ScriptResult executeListeners(Event event, Object[] args, Object[] propHandlerArgs) {
        event.setEventPhase((short)1);
        ScriptResult result = this.executeEventListeners(true, event, args);
        if (event.isPropagationStopped()) {
            return result;
        }
        event.setEventPhase((short)2);
        ScriptResult newResult = this.executeEventHandler(event, propHandlerArgs);
        if (newResult != null) {
            result = newResult;
        }
        if (event.isPropagationStopped()) {
            return result;
        }
        event.setEventPhase((short)3);
        newResult = this.executeEventListeners(false, event, args);
        if (newResult != null) {
            result = newResult;
        }
        return result;
    }

    void copyFrom(EventListenersContainer eventListenersContainer) {
        for (Map.Entry<String, Handlers> entry : eventListenersContainer.eventHandlers_.entrySet()) {
            Handlers handlers = entry.getValue().clone();
            this.eventHandlers_.put(entry.getKey(), handlers);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[node=" + this.jsNode_ + " handlers=" + this.eventHandlers_.keySet() + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Handlers
    implements Serializable {
        private static final long serialVersionUID = -5322935816539773122L;
        private final List<Function> capturingHandlers_ = new ArrayList<Function>();
        private final List<Function> bubblingHandlers_ = new ArrayList<Function>();
        private Object handler_;

        Handlers() {
        }

        List<Function> getHandlers(boolean useCapture) {
            if (useCapture) {
                return this.capturingHandlers_;
            }
            return this.bubblingHandlers_;
        }

        protected Handlers clone() {
            Handlers clone = new Handlers();
            clone.handler_ = this.handler_;
            clone.capturingHandlers_.addAll(this.capturingHandlers_);
            clone.bubblingHandlers_.addAll(this.bubblingHandlers_);
            return clone;
        }
    }
}

