/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.util;

import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebConnection;
import com.gargoylesoftware.htmlunit.WebRequestSettings;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.WebResponseData;
import com.gargoylesoftware.htmlunit.WebResponseImpl;
import com.gargoylesoftware.htmlunit.util.WebConnectionWrapper;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import org.apache.commons.httpclient.NameValuePair;

public abstract class FalsifyingWebConnection
extends WebConnectionWrapper {
    public FalsifyingWebConnection(WebConnection webConnection) throws IllegalArgumentException {
        super(webConnection);
    }

    public FalsifyingWebConnection(WebClient webClient) throws IllegalArgumentException {
        super(webClient);
    }

    protected WebResponse deliverFromAlternateUrl(WebRequestSettings webRequestSettings, URL url) throws IOException {
        URL originalUrl = webRequestSettings.getUrl();
        webRequestSettings.setUrl(url);
        WebResponse resp = super.getResponse(webRequestSettings);
        resp.getRequestSettings().setUrl(originalUrl);
        return resp;
    }

    protected WebResponse replaceContent(WebResponse wr, String newContent) throws IOException {
        byte[] body = newContent.getBytes(wr.getContentCharset());
        WebResponseData wrd = new WebResponseData(body, wr.getStatusCode(), wr.getStatusMessage(), wr.getResponseHeaders());
        return new WebResponseImpl(wrd, wr.getRequestSettings().getUrl(), wr.getRequestSettings().getHttpMethod(), wr.getLoadTime());
    }

    protected WebResponse createWebResponse(WebRequestSettings wr, String content, String contentType) throws IOException {
        return this.createWebResponse(wr, content, contentType, 200, "OK");
    }

    protected WebResponse createWebResponse(WebRequestSettings wr, String content, String contentType, int responseCode, String responseMessage) throws IOException {
        ArrayList<NameValuePair> headers = new ArrayList<NameValuePair>();
        String encoding = "UTF-8";
        headers.add(new NameValuePair("content-type", contentType + "; charset=" + "UTF-8"));
        byte[] body = content.getBytes("UTF-8");
        WebResponseData wrd = new WebResponseData(body, responseCode, responseMessage, headers);
        return new WebResponseImpl(wrd, wr.getUrl(), wr.getHttpMethod(), 0L);
    }
}

