/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit;

import com.gargoylesoftware.htmlunit.util.Cookie;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.CookieStore;
import org.apache.http.cookie.CookieOrigin;
import org.apache.http.cookie.CookieSpec;
import org.apache.http.cookie.CookieSpecRegistry;
import org.apache.http.impl.client.DefaultHttpClient;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CookieManager
implements Serializable {
    private static final long serialVersionUID = 4145377365165079425L;
    public static final String HTMLUNIT_COOKIE_POLICY = "compatibility";
    private boolean cookiesEnabled_ = true;
    private final Set<Cookie> cookies_;
    private final transient CookieSpecRegistry registry_ = new DefaultHttpClient().getCookieSpecs();

    public CookieManager() {
        this.cookies_ = new LinkedHashSet<Cookie>();
    }

    public synchronized void setCookiesEnabled(boolean enabled) {
        this.cookiesEnabled_ = enabled;
    }

    public synchronized boolean isCookiesEnabled() {
        return this.cookiesEnabled_;
    }

    public synchronized Set<Cookie> getCookies() {
        return Collections.unmodifiableSet(this.cookies_);
    }

    public synchronized Set<Cookie> getCookies(URL url) {
        String host = url.getHost();
        String path = url.getPath();
        boolean secure = "https".equals(url.getProtocol());
        int port = url.getPort() != -1 ? url.getPort() : url.getDefaultPort();
        Date now = new Date();
        Iterator<Cookie> iter = this.cookies_.iterator();
        while (iter.hasNext()) {
            Cookie cookie = iter.next();
            if (cookie.getExpires() == null || !now.after(cookie.getExpires())) continue;
            iter.remove();
        }
        CookieSpec spec = this.registry_.getCookieSpec(HTMLUNIT_COOKIE_POLICY);
        org.apache.http.cookie.Cookie[] all = Cookie.toHttpClient(this.cookies_);
        CookieOrigin cookieOrigin = new CookieOrigin(host, port, path, secure);
        ArrayList<org.apache.http.cookie.Cookie> matches = new ArrayList<org.apache.http.cookie.Cookie>();
        for (org.apache.http.cookie.Cookie cookie : all) {
            if (!spec.match(cookie, cookieOrigin)) continue;
            matches.add(cookie);
        }
        LinkedHashSet<Cookie> cookies = new LinkedHashSet<Cookie>();
        cookies.addAll(Cookie.fromHttpClient(matches));
        return Collections.unmodifiableSet(cookies);
    }

    public synchronized Cookie getCookie(String name) {
        for (Cookie cookie : this.cookies_) {
            if (!StringUtils.equals((String)cookie.getName(), (String)name)) continue;
            return cookie;
        }
        return null;
    }

    public synchronized void addCookie(Cookie cookie) {
        this.cookies_.remove(cookie);
        if (cookie.getExpires() == null || cookie.getExpires().after(new Date())) {
            this.cookies_.add(cookie);
        }
    }

    public synchronized void removeCookie(Cookie cookie) {
        this.cookies_.remove(cookie);
    }

    public synchronized void clearCookies() {
        this.cookies_.clear();
    }

    protected synchronized void updateState(CookieStore state) {
        if (!this.cookiesEnabled_) {
            return;
        }
        state.clear();
        for (Cookie cookie : this.cookies_) {
            state.addCookie(cookie.toHttpClient());
        }
    }

    protected synchronized void updateFromState(CookieStore state) {
        if (!this.cookiesEnabled_) {
            return;
        }
        this.cookies_.clear();
        this.cookies_.addAll(Cookie.fromHttpClient(state.getCookies()));
    }
}

