/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.TextUtil;
import com.gargoylesoftware.htmlunit.WebRequest;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlAnchor
extends HtmlElement {
    private static final long serialVersionUID = 7968778206454737178L;
    private static final Log LOG = LogFactory.getLog(HtmlAnchor.class);
    public static final String TAG_NAME = "a";

    HtmlAnchor(String namespaceURI, String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        super(namespaceURI, qualifiedName, page, attributes);
    }

    protected void doClickAction(String hrefSuffix) throws IOException {
        String href = this.getHrefAttribute() + hrefSuffix;
        if (LOG.isDebugEnabled()) {
            String w = this.getPage().getEnclosingWindow().getName();
            LOG.debug((Object)("do click action in window '" + w + "', using href '" + href + "'"));
        }
        if (href.length() == 0) {
            return;
        }
        HtmlPage page = (HtmlPage)this.getPage();
        if (TextUtil.startsWithIgnoreCase(href, "javascript:")) {
            StringBuilder builder = new StringBuilder(href.length());
            for (int i = 0; i < href.length(); ++i) {
                char ch = href.charAt(i);
                if (ch == '%' && i + 2 < href.length()) {
                    char ch1 = Character.toUpperCase(href.charAt(i + 1));
                    char ch2 = Character.toUpperCase(href.charAt(i + 2));
                    if ((Character.isDigit(ch1) || ch1 >= 'A' && ch1 <= 'F') && (Character.isDigit(ch2) || ch2 >= 'A' && ch2 <= 'F')) {
                        builder.append((char)Integer.parseInt(href.substring(i + 1, i + 3), 16));
                        i += 2;
                        continue;
                    }
                }
                builder.append(ch);
            }
            page.executeJavaScriptIfPossible(builder.toString(), "javascript url", this.getStartLineNumber());
            return;
        }
        URL url = page.getFullyQualifiedUrl(href);
        WebRequest webRequest = new WebRequest(url);
        webRequest.setAdditionalHeader("Referer", page.getWebResponse().getWebRequest().getUrl().toExternalForm());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting page for " + url.toExternalForm() + ", derived from href '" + href + "', using the originating URL " + page.getWebResponse().getWebRequest().getUrl()));
        }
        page.getWebClient().download(page.getEnclosingWindow(), page.getResolvedTarget(this.getTargetAttribute()), webRequest, "Link click");
    }

    @Override
    protected void doClickAction() throws IOException {
        this.doClickAction("");
    }

    public final String getCharsetAttribute() {
        return this.getAttribute("charset");
    }

    public final String getTypeAttribute() {
        return this.getAttribute("type");
    }

    public final String getNameAttribute() {
        return this.getAttribute("name");
    }

    public final String getHrefAttribute() {
        return this.getAttribute("href").trim();
    }

    public final String getHrefLangAttribute() {
        return this.getAttribute("hreflang");
    }

    public final String getRelAttribute() {
        return this.getAttribute("rel");
    }

    public final String getRevAttribute() {
        return this.getAttribute("rev");
    }

    public final String getAccessKeyAttribute() {
        return this.getAttribute("accesskey");
    }

    public final String getShapeAttribute() {
        return this.getAttribute("shape");
    }

    public final String getCoordsAttribute() {
        return this.getAttribute("coords");
    }

    public final String getTabIndexAttribute() {
        return this.getAttribute("tabindex");
    }

    public final String getOnFocusAttribute() {
        return this.getAttribute("onfocus");
    }

    public final String getOnBlurAttribute() {
        return this.getAttribute("onblur");
    }

    public final String getTargetAttribute() {
        return this.getAttribute("target");
    }

    public final Page openLinkInNewWindow() throws MalformedURLException {
        URL target = ((HtmlPage)this.getPage()).getFullyQualifiedUrl(this.getHrefAttribute());
        String windowName = "HtmlAnchor.openLinkInNewWindow() target";
        WebWindow newWindow = this.getPage().getWebClient().openWindow(target, "HtmlAnchor.openLinkInNewWindow() target");
        return newWindow.getEnclosedPage();
    }
}

