/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.html.BaseFrame;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HtmlDivision;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlHtml;
import com.gargoylesoftware.htmlunit.html.HtmlImage;
import com.gargoylesoftware.htmlunit.html.HtmlInlineFrame;
import com.gargoylesoftware.htmlunit.html.HtmlLink;
import com.gargoylesoftware.htmlunit.html.HtmlOrderedList;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.HtmlScript;
import com.gargoylesoftware.htmlunit.html.HtmlSpan;
import com.gargoylesoftware.htmlunit.html.HtmlStyle;
import com.gargoylesoftware.htmlunit.html.HtmlTable;
import com.gargoylesoftware.htmlunit.html.HtmlTitle;
import com.gargoylesoftware.htmlunit.html.HtmlUnorderedList;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageReader;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class XmlSerializer {
    private final StringBuilder buffer_ = new StringBuilder();
    private final StringBuilder indent_ = new StringBuilder();
    private File outputDir_;

    XmlSerializer() {
    }

    public void save(HtmlPage page, File file) throws IOException {
        File outputFile;
        String fileName = file.getName();
        if (!fileName.endsWith(".htm") && !fileName.endsWith(".html")) {
            fileName = fileName + ".html";
        }
        if ((outputFile = new File(file.getParentFile(), fileName)).exists()) {
            throw new IOException("File already exists: " + outputFile);
        }
        fileName = fileName.substring(0, fileName.lastIndexOf(46));
        this.outputDir_ = new File(file.getParentFile(), fileName);
        FileUtils.writeStringToFile((File)outputFile, (String)this.asXml(page.getDocumentElement()));
    }

    public String asXml(HtmlElement node) throws IOException {
        this.buffer_.setLength(0);
        this.indent_.setLength(0);
        String charsetName = null;
        if (node.getPage() instanceof HtmlPage) {
            charsetName = node.getPage().getPageEncoding();
        }
        if (charsetName != null && node instanceof HtmlHtml) {
            this.buffer_.append("<?xml version=\"1.0\" encoding=\"").append(charsetName).append("\"?>").append('\n');
        }
        this.printXml(node);
        String response = this.buffer_.toString();
        this.buffer_.setLength(0);
        return response;
    }

    protected void printXml(DomElement node) throws IOException {
        if (!this.isExcluded(node)) {
            boolean hasChildren = node.getFirstChild() != null;
            this.buffer_.append((CharSequence)this.indent_).append('<');
            this.printOpeningTag(node);
            if (!hasChildren && !this.isEmptyXmlTagExpanded(node)) {
                this.buffer_.append("/>").append('\n');
            } else {
                this.buffer_.append(">").append('\n');
                for (DomNode child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                    this.indent_.append("  ");
                    if (child instanceof DomElement) {
                        this.printXml((DomElement)child);
                    } else {
                        this.buffer_.append(child);
                    }
                    this.indent_.setLength(this.indent_.length() - 2);
                }
                this.buffer_.append((CharSequence)this.indent_).append("</").append(node.getTagName()).append('>').append('\n');
            }
        }
    }

    protected boolean isEmptyXmlTagExpanded(DomNode node) {
        return node instanceof HtmlDivision || node instanceof HtmlInlineFrame || node instanceof HtmlOrderedList || node instanceof HtmlScript || node instanceof HtmlSpan || node instanceof HtmlStyle || node instanceof HtmlTable || node instanceof HtmlTitle || node instanceof HtmlUnorderedList;
    }

    protected void printOpeningTag(DomElement node) throws IOException {
        this.buffer_.append(node.getTagName());
        Map<String, DomAttr> attributes = node instanceof HtmlImage ? this.getAttributesFor((HtmlImage)node) : (node instanceof HtmlLink ? this.getAttributesFor((HtmlLink)node) : (node instanceof BaseFrame ? this.getAttributesFor((BaseFrame)node) : node.getAttributesMap()));
        for (String name : attributes.keySet()) {
            this.buffer_.append(" ");
            this.buffer_.append(name);
            this.buffer_.append("=\"");
            this.buffer_.append(StringEscapeUtils.escapeXml((String)attributes.get(name).getNodeValue()));
            this.buffer_.append("\"");
        }
    }

    private Map<String, DomAttr> getAttributesFor(BaseFrame frame) throws IOException {
        Map<String, DomAttr> map = this.createAttributesCopyWithClonedAttribute(frame, "src");
        DomAttr srcAttr = map.get("src");
        Page enclosedPage = frame.getEnclosedPage();
        String suffix = this.getFileExtension(enclosedPage);
        File file = this.createFile(srcAttr.getValue(), "." + suffix);
        if (enclosedPage instanceof HtmlPage) {
            file.delete();
            ((HtmlPage)enclosedPage).save(file);
        } else {
            InputStream is = enclosedPage.getWebResponse().getContentAsStream();
            FileOutputStream fos = new FileOutputStream(file);
            IOUtils.copyLarge((InputStream)is, (OutputStream)fos);
            IOUtils.closeQuietly((InputStream)is);
            IOUtils.closeQuietly((OutputStream)fos);
        }
        srcAttr.setValue(file.getParentFile().getName() + "/" + file.getName());
        return map;
    }

    private String getFileExtension(Page enclosedPage) {
        if (enclosedPage instanceof HtmlPage) {
            return "html";
        }
        URL url = enclosedPage.getUrl();
        if (url.getPath().contains(".")) {
            return StringUtils.substringAfterLast((String)url.getPath(), (String)".");
        }
        return ".unknown";
    }

    protected Map<String, DomAttr> getAttributesFor(HtmlLink link) throws IOException {
        Map<String, DomAttr> map = this.createAttributesCopyWithClonedAttribute(link, "href");
        DomAttr hrefAttr = map.get("href");
        File file = this.createFile(hrefAttr.getValue(), ".css");
        FileUtils.writeStringToFile((File)file, (String)link.getWebResponse(true).getContentAsString());
        hrefAttr.setValue(this.outputDir_.getName() + File.separatorChar + file.getName());
        return map;
    }

    protected Map<String, DomAttr> getAttributesFor(HtmlImage image) throws IOException {
        Map<String, DomAttr> map = this.createAttributesCopyWithClonedAttribute(image, "src");
        DomAttr srcAttr = map.get("src");
        ImageReader reader = image.getImageReader();
        File file = this.createFile(srcAttr.getValue(), "." + reader.getFormatName());
        image.saveAs(file);
        this.outputDir_.mkdirs();
        String valueOnFileSystem = this.outputDir_.getName() + File.separatorChar + file.getName();
        srcAttr.setValue(valueOnFileSystem);
        return map;
    }

    private Map<String, DomAttr> createAttributesCopyWithClonedAttribute(HtmlElement elt, String attrName) {
        HashMap<String, DomAttr> newMap = new HashMap<String, DomAttr>(elt.getAttributesMap());
        DomAttr attr = (DomAttr)newMap.get(attrName);
        DomAttr clonedAttr = new DomAttr(attr.getPage(), attr.getNamespaceURI(), attr.getQualifiedName(), attr.getValue(), attr.getSpecified());
        newMap.put(attrName, clonedAttr);
        return newMap;
    }

    protected boolean isExcluded(DomElement element) {
        return element instanceof HtmlScript;
    }

    private File createFile(String url, String extension) throws IOException {
        String name = url.replaceFirst("/$", "").replaceAll(".*/", "");
        name = StringUtils.substringBefore((String)name, (String)"?");
        if (!(name = StringUtils.substringBefore((String)name, (String)";")).endsWith(extension)) {
            name = name + extension;
        }
        int counter = 0;
        while (true) {
            String fileName = counter != 0 ? StringUtils.substringBeforeLast((String)name, (String)".") + "_" + counter + "." + StringUtils.substringAfterLast((String)name, (String)".") : name;
            this.outputDir_.mkdirs();
            File f = new File(this.outputDir_, fileName);
            if (f.createNewFile()) {
                return f;
            }
            ++counter;
        }
    }
}

