/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.xml;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.host.Document;
import com.gargoylesoftware.htmlunit.javascript.host.DocumentFragment;
import com.gargoylesoftware.htmlunit.javascript.host.Element;
import com.gargoylesoftware.htmlunit.javascript.host.Node;
import com.gargoylesoftware.htmlunit.util.StringUtils;
import org.w3c.dom.NamedNodeMap;

public class XMLSerializer
extends SimpleScriptable {
    private static final long serialVersionUID = -934136191731299896L;

    public void jsConstructor() {
    }

    public String jsxFunction_serializeToString(Node root) {
        if (root instanceof Document) {
            root = ((Document)root).jsxGet_documentElement();
        } else if (root instanceof DocumentFragment) {
            root = root.jsxGet_firstChild();
        }
        if (root instanceof Element) {
            StringBuilder buffer = new StringBuilder();
            boolean isIE = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.GENERATED_139);
            this.toXml(1, (DomNode)root.getDomNodeOrDie(), buffer, isIE);
            if (isIE) {
                buffer.append('\r').append('\n');
            }
            return buffer.toString();
        }
        if (root == null) {
            return "";
        }
        return ((DomNode)root.getDomNodeOrDie()).asXml();
    }

    private void toXml(int indent, DomNode node, StringBuilder buffer, boolean isIE) {
        String nodeName = node.getNodeName();
        if (!isIE && node.getPage() instanceof HtmlPage) {
            nodeName = nodeName.toUpperCase();
        }
        buffer.append('<').append(nodeName);
        if (node.getNamespaceURI() != null && node.getPrefix() != null) {
            boolean sameNamespace = false;
            DomNode parentNode = node.getParentNode();
            while (parentNode instanceof DomElement) {
                if (node.getNamespaceURI().equals(parentNode.getNamespaceURI())) {
                    sameNamespace = true;
                }
                parentNode = parentNode.getParentNode();
            }
            if (node.getParentNode() == null || !sameNamespace) {
                ((DomElement)node).setAttribute("xmlns:" + node.getPrefix(), node.getNamespaceURI());
            }
        }
        NamedNodeMap attributesMap = node.getAttributes();
        for (int i = 0; i < attributesMap.getLength(); ++i) {
            DomAttr attrib = (DomAttr)attributesMap.item(i);
            buffer.append(' ').append(attrib.getQualifiedName()).append('=').append('\"').append(attrib.getValue()).append('\"');
        }
        boolean startTagClosed = false;
        block7: for (DomNode child : node.getChildren()) {
            if (!startTagClosed) {
                buffer.append('>');
                startTagClosed = true;
            }
            switch (child.getNodeType()) {
                case 1: {
                    this.toXml(indent + 1, child, buffer, isIE);
                    break;
                }
                case 3: {
                    String value = child.getNodeValue();
                    value = StringUtils.escapeXmlChars(value);
                    if (isIE && value.trim().length() == 0) {
                        buffer.append('\r').append('\n');
                        DomNode sibling = child.getNextSibling();
                        if (sibling == null || sibling.getNodeType() != 1) continue block7;
                        for (int i = 0; i < indent; ++i) {
                            buffer.append('\t');
                        }
                        continue block7;
                    }
                    buffer.append(value);
                    break;
                }
                case 4: 
                case 8: {
                    buffer.append(child.asXml());
                    break;
                }
            }
        }
        if (!startTagClosed) {
            buffer.append('/').append('>');
        } else {
            buffer.append('<').append('/').append(node.getNodeName()).append('>');
        }
    }
}

