/* Driver template for the LEMON parser generator.
** The author disclaims copyright to this source code.
*/
/* First off, code is include which follows the "include" declaration
** in the input file. */
#include <stdio.h>
#line 33 "parse.y"

#include "sqliteInt.h"
#include "parse.h"

/*
** An instance of this structure holds information about the
** LIMIT clause of a SELECT statement.
*/
struct LimitVal {
  int limit;    /* The LIMIT value.  -1 if there is no limit */
  int offset;   /* The OFFSET.  0 if there is none */
};

/*
** An instance of this structure is used to store the LIKE,
** GLOB, NOT LIKE, and NOT GLOB operators.
*/
struct LikeOp {
  int opcode;   /* Either TK_GLOB or TK_LIKE */
  int not;      /* True if the NOT keyword is present */
};

/*
** An instance of the following structure describes the event of a
** TRIGGER.  "a" is the event type, one of TK_UPDATE, TK_INSERT,
** TK_DELETE, or TK_INSTEAD.  If the event is of the form
**
**      UPDATE ON (a,b,c)
**
** Then the "b" IdList records the list "a,b,c".
*/
struct TrigEvent { int a; IdList * b; };

/*
** An instance of this structure holds the ATTACH key and the key type.
*/
struct AttachKey { int type;  Token key; };

#line 48 "parse.c"
/* Next is all token values, in a form suitable for use by makeheaders.
** This section will be null unless lemon is run with the -m switch.
*/
/* 
** These constants (all generated automatically by the parser generator)
** specify the various kinds of tokens (terminals) that the parser
** understands. 
**
** Each symbol here is a terminal symbol in the grammar.
*/
/* Make sure the INTERFACE macro is defined.
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/* The next thing included is series of defines which control
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 terminals
**                       and nonterminals.  "int" is used otherwise.
**    YYNOCODE           is a number of type YYCODETYPE which corresponds
**                       to no legal terminal or nonterminal number.  This
**                       number is used to fill in empty slots of the hash 
**                       table.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       have fall-back values which should be used if the
**                       original value of the token will not parse.
**    YYACTIONTYPE       is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 rules and
**                       states combined.  "int" is used otherwise.
**    sqlite3ParserTOKENTYPE     is the data type used for minor tokens given 
**                       directly to the parser from the tokenizer.
**    YYMINORTYPE        is the data type used for all minor tokens.
**                       This is typically a union of many types, one of
**                       which is sqlite3ParserTOKENTYPE.  The entry in the union
**                       for base tokens is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.
**    sqlite3ParserARG_SDECL     A static variable declaration for the %extra_argument
**    sqlite3ParserARG_PDECL     A parameter declaration for the %extra_argument
**    sqlite3ParserARG_STORE     Code to store %extra_argument into yypParser
**    sqlite3ParserARG_FETCH     Code to extract %extra_argument from yypParser
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
*/
#define YYCODETYPE unsigned char
#define YYNOCODE 225
#define YYACTIONTYPE unsigned short int
#define sqlite3ParserTOKENTYPE Token
typedef union {
  sqlite3ParserTOKENTYPE yy0;
  struct {int value; int mask;} yy47;
  TriggerStep* yy91;
  Token yy98;
  Select* yy107;
  struct TrigEvent yy146;
  ExprList* yy210;
  Expr* yy258;
  SrcList* yy259;
  IdList* yy272;
  int yy284;
  struct AttachKey yy292;
  struct LikeOp yy342;
  struct LimitVal yy404;
  int yy449;
} YYMINORTYPE;
#define YYSTACKDEPTH 100
#define sqlite3ParserARG_SDECL Parse *pParse;
#define sqlite3ParserARG_PDECL ,Parse *pParse
#define sqlite3ParserARG_FETCH Parse *pParse = yypParser->pParse
#define sqlite3ParserARG_STORE yypParser->pParse = pParse
#define YYNSTATE 537
#define YYNRULE 292
#define YYERRORSYMBOL 130
#define YYERRSYMDT yy449
#define YYFALLBACK 1
#define YY_NO_ACTION      (YYNSTATE+YYNRULE+2)
#define YY_ACCEPT_ACTION  (YYNSTATE+YYNRULE+1)
#define YY_ERROR_ACTION   (YYNSTATE+YYNRULE)

/* Next are that tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N < YYNSTATE                  Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   YYNSTATE <= N < YYNSTATE+YYNRULE   Reduce by rule N-YYNSTATE.
**
**   N == YYNSTATE+YYNRULE              A syntax error has occurred.
**
**   N == YYNSTATE+YYNRULE+1            The parser accepts its input.
**
**   N == YYNSTATE+YYNRULE+2            No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as
**
**      yy_action[ yy_shift_ofst[S] + X ]
**
** If the index value yy_shift_ofst[S]+X is out of range or if the value
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X or if yy_shift_ofst[S]
** is equal to YY_SHIFT_USE_DFLT, it means that the action is not in the table
** and that yy_default[S] should be used instead.  
**
** The formula above is for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array and YY_REDUCE_USE_DFLT is used in place of
** YY_SHIFT_USE_DFLT.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
*/
static const YYACTIONTYPE yy_action[] = {
 /*     0 */   257,  325,  255,  138,  140,  142,  144,  146,  148,  150,
 /*    10 */   152,  154,  156,  345,   87,   88,  159,   12,  311,  310,
 /*    20 */   158,  146,  148,  150,  152,  154,  156,  813,  150,  152,
 /*    30 */   154,  156,  430,   50,  124,  112,  160,  169,  174,  179,
 /*    40 */   168,  173,  134,  136,  128,  130,  126,  132,  138,  140,
 /*    50 */   142,  144,  146,  148,  150,  152,  154,  156,  114,  439,
 /*    60 */    44,  256,   39,   58,   64,   66,  299,  330,  612,  293,
 /*    70 */   351,  223,   92,  332,  326,  159,   13,   14,  353,  158,
 /*    80 */   188,  355,  361,  366,  266,   12,  267,  259,  342,   87,
 /*    90 */    88,   12,  369,  124,  112,  160,  169,  174,  179,  168,
 /*   100 */   173,  134,  136,  128,  130,  126,  132,  138,  140,  142,
 /*   110 */   144,  146,  148,  150,  152,  154,  156,  297,  292,  349,
 /*   120 */   114,  183,  282,  185,  186,  403,   12,   31,   32,  225,
 /*   130 */    41,  255,  353,  269,  159,  355,  361,  366,  158,  166,
 /*   140 */   175,  180,  188,  286,   13,   14,  369,   92,  350,  382,
 /*   150 */    13,   14,  124,  112,  160,  169,  174,  179,  168,  173,
 /*   160 */   134,  136,  128,  130,  126,  132,  138,  140,  142,  144,
 /*   170 */   146,  148,  150,  152,  154,  156,   98,   96,   12,  159,
 /*   180 */   237,   98,   96,  158,  336,   13,   14,  337,  338,  265,
 /*   190 */   256,  225,  272,  807,  339,  515,   12,  124,  112,  160,
 /*   200 */   169,  174,  179,  168,  173,  134,  136,  128,  130,  126,
 /*   210 */   132,  138,  140,  142,  144,  146,  148,  150,  152,  154,
 /*   220 */   156,  128,  130,  126,  132,  138,  140,  142,  144,  146,
 /*   230 */   148,  150,  152,  154,  156,    5,  353,   13,   14,  355,
 /*   240 */   361,  366,  100,   87,   88,   92,  787,  697,  159,  349,
 /*   250 */   369,  815,  158,  542,   27,   13,   14,  383,   32,  518,
 /*   260 */   273,  546,   69,  247,   10,  765,  124,  112,  160,  169,
 /*   270 */   174,  179,  168,  173,  134,  136,  128,  130,  126,  132,
 /*   280 */   138,  140,  142,  144,  146,  148,  150,  152,  154,  156,
 /*   290 */    73,  658,   12,  159,  269,    4,    6,  158,   56,   57,
 /*   300 */    24,   92,  274,  252,  513,  181,  488,  275,  407,   12,
 /*   310 */     8,  124,  112,  160,  169,  174,  179,  168,  173,  134,
 /*   320 */   136,  128,  130,  126,  132,  138,  140,  142,  144,  146,
 /*   330 */   148,  150,  152,  154,  156,  219,   73,   47,  547,  187,
 /*   340 */   763,  183,  514,  185,  186,  183,   48,  185,  186,  569,
 /*   350 */   464,   13,   14,  114,  114,   12,  114,   49,  516,  517,
 /*   360 */    45,  499,  288,  159,  545,  631,  287,  158,   13,   14,
 /*   370 */    46,  183,  480,  185,  186,  111,  474,  249,  474,  808,
 /*   380 */   205,  124,  112,  160,  169,  174,  179,  168,  173,  134,
 /*   390 */   136,  128,  130,  126,  132,  138,  140,  142,  144,  146,
 /*   400 */   148,  150,  152,  154,  156,    9,  780,  486,  159,  482,
 /*   410 */   103,  230,  158,  457,   13,   14,   92,   11,  470,  183,
 /*   420 */   506,  185,  186,   12,   50,  561,  124,  112,  160,  169,
 /*   430 */   174,  179,  168,  173,  134,  136,  128,  130,  126,  132,
 /*   440 */   138,  140,  142,  144,  146,  148,  150,  152,  154,  156,
 /*   450 */   291,   36,  335,   39,   58,   64,   66,  299,  330,  183,
 /*   460 */   304,  185,  186,  537,  332,  304,  633,  159,   91,   87,
 /*   470 */    88,  158,  534,  535,  497,  810,  166,  175,  180,  368,
 /*   480 */   378,  484,   13,   14,  548,  124,  112,  160,  169,  174,
 /*   490 */   179,  168,  173,  134,  136,  128,  130,  126,  132,  138,
 /*   500 */   140,  142,  144,  146,  148,  150,  152,  154,  156,  441,
 /*   510 */   306,  659,  159,  244,  419,  306,  158,  418,   19,  183,
 /*   520 */   332,  185,  186,  623,  166,  175,  180,   92,  289,  420,
 /*   530 */   124,  112,  160,  169,  174,  179,  168,  173,  134,  136,
 /*   540 */   128,  130,  126,  132,  138,  140,  142,  144,  146,  148,
 /*   550 */   150,  152,  154,  156,  475,  447,  437,  159,  244,  438,
 /*   560 */   183,  158,  185,  186,  660,   77,  830,    1,  536,    3,
 /*   570 */   413,  415,  414,  553,  246,  124,  177,  160,  169,  174,
 /*   580 */   179,  168,  173,  134,  136,  128,  130,  126,  132,  138,
 /*   590 */   140,  142,  144,  146,  148,  150,  152,  154,  156,  245,
 /*   600 */   764,  691,  159,   89,   87,   88,  158,  269,  183,   41,
 /*   610 */   185,  186,   15,   16,   17,  388,   21,  452,  823,  246,
 /*   620 */   625,  112,  160,  169,  174,  179,  168,  173,  134,  136,
 /*   630 */   128,  130,  126,  132,  138,  140,  142,  144,  146,  148,
 /*   640 */   150,  152,  154,  156,  245,   77,  257,  159,  255,  227,
 /*   650 */   396,  158,  391,  380,  303,  527,  554,  422,  504,  325,
 /*   660 */   379,   72,   92,  417,  503,   68,   23,  160,  169,  174,
 /*   670 */   179,  168,  173,  134,  136,  128,  130,  126,  132,  138,
 /*   680 */   140,  142,  144,  146,  148,  150,  152,  154,  156,  207,
 /*   690 */   372,   72,  114,   77,   73,   68,  114,  387,   33,  189,
 /*   700 */   114,  348,  340,  182,  436,  402,  468,  256,  162,  203,
 /*   710 */   238,  215,  161,  555,  111,  195,  193,  294,  188,  207,
 /*   720 */   114,  660,  188,  191,   70,   71,  114,  433,  113,  189,
 /*   730 */   164,  165,  326,   73,   73,  227,  255,  307,  314,  316,
 /*   740 */   556,  501,  198,  436,  691,  195,  193,   72,  131,  312,
 /*   750 */   105,   68,  325,  191,   70,   71,  221,  163,  113,  460,
 /*   760 */   119,  120,  121,  122,  197,  773,  423,  225,   72,  313,
 /*   770 */   434,  224,   68,   73,  442,  207,   77,   47,  467,  444,
 /*   780 */   341,  325,  114,  363,  255,  189,   48,   25,  199,   74,
 /*   790 */   119,  120,  121,  122,  197,  256,  207,   49,  460,  114,
 /*   800 */   209,  195,  193,  283,  290,  114,  189,   28,   73,  191,
 /*   810 */    70,   71,  358,  446,  113,  457,  309,  114,  444,   73,
 /*   820 */   325,  194,  195,  193,   72,  326,  259,  133,   68,   51,
 /*   830 */   191,   70,   71,  529,  114,  113,   62,   35,  334,  206,
 /*   840 */    53,   29,   63,  256,  329,  259,  119,  120,  121,  122,
 /*   850 */   197,  319,  207,  238,  326,  222,  147,  223,    7,  114,
 /*   860 */   114,  277,  189,   18,   20,   22,  386,  119,  120,  121,
 /*   870 */   122,  197,  766,  114,   98,   96,  451,  521,  195,  193,
 /*   880 */   260,  135,  137,  531,  534,  535,  191,   70,   71,  114,
 /*   890 */   114,  113,  114,  326,  114,  204,  510,   34,  441,  114,
 /*   900 */   114,  267,  507,  508,  471,  402,  114,  114,  114,  114,
 /*   910 */   114,  139,  141,  114,  296,  114,  143,  114,  465,  560,
 /*   920 */   267,  176,  145,  119,  120,  121,  122,  197,  455,  196,
 /*   930 */   459,  149,  151,  114,  284,  178,  114,  220,  114,  153,
 /*   940 */   114,  487,  114,  489,  493,  437,  359,  416,  321,  479,
 /*   950 */   114,  402,  114,  114,   77,  155,  281,  473,  157,  471,
 /*   960 */   218,  611,  192,   30,  216,  402,   94,   95,  343,  114,
 /*   970 */   344,  803,  271,  395,  472,  239,  402,  114,  402,  242,
 /*   980 */   252,  411,  412,  114,  255,   99,  385,  481,  114,   43,
 /*   990 */    44,  234,  171,  184,  325,  802,  636,  114,  373,  408,
 /*  1000 */   321,  404,  114,   73,  402,  123,  114,  364,   90,  321,
 /*  1010 */   167,  320,  491,  321,  483,  240,   73,    2,    3,  190,
 /*  1020 */    26,  170,  384,   40,  367,  402,  114,  402,  125,  114,
 /*  1030 */    38,   79,  431,   37,  321,   41,  329,   42,  280,   52,
 /*  1040 */   428,   55,   59,  256,   54,   60,   67,   75,  127,   77,
 /*  1050 */    61,  129,   65,  570,   76,  571,  235,  238,   84,   78,
 /*  1060 */   101,  495,   80,  485,   81,  233,  102,  322,   86,  104,
 /*  1070 */    93,   97,  108,  107,   82,  109,  110,  115,  117,   83,
 /*  1080 */   172,  156,   85,  637,  638,  217,  639,  116,  202,  118,
 /*  1090 */   208,  211,  226,  210,  212,  213,  106,  214,  227,  236,
 /*  1100 */   241,  228,  231,  232,  229,  223,  243,  200,  251,  248,
 /*  1110 */   201,  250,  253,  258,  254,  270,  262,  261,  263,  264,
 /*  1120 */   268,  276,  278,  285,  295,  279,  298,  318,  301,  303,
 /*  1130 */   333,  300,  305,  323,  327,  346,  356,  357,  362,  370,
 /*  1140 */   371,  374,   53,  302,  354,  394,  331,  324,  308,  315,
 /*  1150 */   375,  401,  317,  347,  328,  389,  390,  392,  393,  409,
 /*  1160 */   397,  795,  398,  410,  421,  424,  360,  365,  800,  425,
 /*  1170 */   801,  381,  352,  377,  376,  400,  426,  427,  429,  771,
 /*  1180 */   772,  698,  399,  435,  432,  699,  443,  794,  445,  438,
 /*  1190 */   809,  449,  453,  450,  454,  440,  811,  458,  448,  462,
 /*  1200 */   461,  812,  463,  469,  477,  476,  814,  630,  456,  632,
 /*  1210 */   478,  779,  821,  490,  690,  492,  498,  494,  496,  693,
 /*  1220 */   696,  500,  509,  505,  781,  511,  782,  512,  783,  784,
 /*  1230 */   466,  785,  520,  502,  786,  519,  405,  523,  530,  525,
 /*  1240 */   524,  822,  406,  528,  824,  825,  533,  828,  518,  518,
 /*  1250 */   518,  518,  518,  518,  522,  518,  518,  518,  518,  518,
 /*  1260 */   526,  532,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */    24,  139,   26,   72,   73,   74,   75,   76,   77,   78,
 /*    10 */    79,   80,   81,  154,  155,  156,   40,   26,   88,   89,
 /*    20 */    44,   76,   77,   78,   79,   80,   81,    9,   78,   79,
 /*    30 */    80,   81,  170,   60,   58,   59,   60,   61,   62,   63,
 /*    40 */    64,   65,   66,   67,   68,   69,   70,   71,   72,   73,
 /*    50 */    74,   75,   76,   77,   78,   79,   80,   81,  139,  173,
 /*    60 */   174,   85,   89,   90,   91,   92,   93,   94,   23,   23,
 /*    70 */    25,   25,  213,  100,  212,   40,   85,   86,   87,   44,
 /*    80 */   161,   90,   91,   92,   23,   26,   25,  152,  154,  155,
 /*    90 */   156,   26,  101,   58,   59,   60,   61,   62,   63,   64,
 /*   100 */    65,   66,   67,   68,   69,   70,   71,   72,   73,   74,
 /*   110 */    75,   76,   77,   78,   79,   80,   81,   23,  199,  139,
 /*   120 */   139,  103,  187,  105,  106,  143,   26,  147,  148,  210,
 /*   130 */    95,   26,   87,  139,   40,   90,   91,   92,   44,  204,
 /*   140 */   205,  206,  161,   78,   85,   86,  101,  213,  168,  169,
 /*   150 */    85,   86,   58,   59,   60,   61,   62,   63,   64,   65,
 /*   160 */    66,   67,   68,   69,   70,   71,   72,   73,   74,   75,
 /*   170 */    76,   77,   78,   79,   80,   81,   76,   77,   26,   40,
 /*   180 */   199,   76,   77,   44,  152,   85,   86,  155,  156,  195,
 /*   190 */    85,  210,   22,   11,   89,   95,   26,   58,   59,   60,
 /*   200 */    61,   62,   63,   64,   65,   66,   67,   68,   69,   70,
 /*   210 */    71,   72,   73,   74,   75,   76,   77,   78,   79,   80,
 /*   220 */    81,   68,   69,   70,   71,   72,   73,   74,   75,   76,
 /*   230 */    77,   78,   79,   80,   81,    9,   87,   85,   86,   90,
 /*   240 */    91,   92,  154,  155,  156,  213,    9,    9,   40,  139,
 /*   250 */   101,    9,   44,    9,  144,   85,   86,  147,  148,   22,
 /*   260 */   146,    9,   22,  111,   12,  126,   58,   59,   60,   61,
 /*   270 */    62,   63,   64,   65,   66,   67,   68,   69,   70,   71,
 /*   280 */    72,   73,   74,   75,   76,   77,   78,   79,   80,   81,
 /*   290 */   176,   23,   26,   40,  139,  135,  136,   44,   13,   14,
 /*   300 */   140,  213,  188,  189,   67,   22,  146,  193,  126,   26,
 /*   310 */   137,   58,   59,   60,   61,   62,   63,   64,   65,   66,
 /*   320 */    67,   68,   69,   70,   71,   72,   73,   74,   75,   76,
 /*   330 */    77,   78,   79,   80,   81,  127,  176,   18,    9,   23,
 /*   340 */    17,  103,  139,  105,  106,  103,   27,  105,  106,  109,
 /*   350 */   195,   85,   86,  139,  139,   26,  139,   38,  155,  156,
 /*   360 */    41,  201,  104,   40,    9,    9,  108,   44,   85,   86,
 /*   370 */    51,  103,   20,  105,  106,  161,  161,  111,  161,   11,
 /*   380 */   127,   58,   59,   60,   61,   62,   63,   64,   65,   66,
 /*   390 */    67,   68,   69,   70,   71,   72,   73,   74,   75,   76,
 /*   400 */    77,   78,   79,   80,   81,  138,    9,   55,   40,   57,
 /*   410 */   196,  197,   44,  139,   85,   86,  213,  139,  203,  103,
 /*   420 */   203,  105,  106,   26,   60,    9,   58,   59,   60,   61,
 /*   430 */    62,   63,   64,   65,   66,   67,   68,   69,   70,   71,
 /*   440 */    72,   73,   74,   75,   76,   77,   78,   79,   80,   81,
 /*   450 */    23,   87,   88,   89,   90,   91,   92,   93,   94,  103,
 /*   460 */    45,  105,  106,    0,  100,   45,    9,   40,  154,  155,
 /*   470 */   156,   44,    9,   10,  200,   17,  204,  205,  206,  159,
 /*   480 */    60,  129,   85,   86,    9,   58,   59,   60,   61,   62,
 /*   490 */    63,   64,   65,   66,   67,   68,   69,   70,   71,   72,
 /*   500 */    73,   74,   75,   76,   77,   78,   79,   80,   81,   51,
 /*   510 */    95,   23,   40,   25,   28,   95,   44,   31,  138,  103,
 /*   520 */   100,  105,  106,    9,  204,  205,  206,  213,   23,   43,
 /*   530 */    58,   59,   60,   61,   62,   63,   64,   65,   66,   67,
 /*   540 */    68,   69,   70,   71,   72,   73,   74,   75,   76,   77,
 /*   550 */    78,   79,   80,   81,   96,   97,   98,   40,   25,   58,
 /*   560 */   103,   44,  105,  106,   24,  107,  131,  132,  133,  134,
 /*   570 */    96,   97,   98,    9,   86,   58,   59,   60,   61,   62,
 /*   580 */    63,   64,   65,   66,   67,   68,   69,   70,   71,   72,
 /*   590 */    73,   74,   75,   76,   77,   78,   79,   80,   81,  111,
 /*   600 */    17,    9,   40,  154,  155,  156,   44,  139,  103,   95,
 /*   610 */   105,  106,   13,   14,   15,   20,  138,   25,    9,   86,
 /*   620 */   119,   59,   60,   61,   62,   63,   64,   65,   66,   67,
 /*   630 */    68,   69,   70,   71,   72,   73,   74,   75,   76,   77,
 /*   640 */    78,   79,   80,   81,  111,  107,   24,   40,   26,  109,
 /*   650 */    55,   44,   57,  164,  165,   46,    9,   21,  120,  139,
 /*   660 */   171,   22,  213,  195,  146,   26,  138,   60,   61,   62,
 /*   670 */    63,   64,   65,   66,   67,   68,   69,   70,   71,   72,
 /*   680 */    73,   74,   75,   76,   77,   78,   79,   80,   81,   50,
 /*   690 */   170,   22,  139,  107,  176,   26,  139,  142,  149,   60,
 /*   700 */   139,  152,  153,  146,  146,  139,  120,   85,   40,  126,
 /*   710 */   118,  128,   44,    9,  161,   76,   77,   78,  161,   50,
 /*   720 */   139,   95,  161,   84,   85,   86,  139,   91,   89,   60,
 /*   730 */    62,   63,  212,  176,  176,  109,   26,   96,   97,   98,
 /*   740 */     9,  175,  161,  146,    9,   76,   77,   22,  161,   32,
 /*   750 */   197,   26,  139,   84,   85,   86,  199,   89,   89,  201,
 /*   760 */   121,  122,  123,  124,  125,  129,  211,  210,   22,   52,
 /*   770 */   215,  210,   26,  176,  216,   50,  107,   18,  146,  221,
 /*   780 */    22,  139,  139,  170,   26,   60,   27,  141,  207,  146,
 /*   790 */   121,  122,  123,  124,  125,   85,   50,   38,  201,  139,
 /*   800 */    41,   76,   77,   78,  161,  139,   60,  145,  176,   84,
 /*   810 */    85,   86,  170,  216,   89,  139,   99,  139,  221,  176,
 /*   820 */   139,  161,   76,   77,   22,  212,  152,  161,   26,   89,
 /*   830 */    84,   85,   86,  123,  139,   89,   29,  157,  158,  161,
 /*   840 */   100,   23,   35,   85,  164,  152,  121,  122,  123,  124,
 /*   850 */   125,  170,   50,  118,  212,   23,  161,   25,   11,  139,
 /*   860 */   139,  187,   60,   16,   17,   18,   19,  121,  122,  123,
 /*   870 */   124,  125,  126,  139,   76,   77,  200,   30,   76,   77,
 /*   880 */   187,  161,  161,   36,    9,   10,   84,   85,   86,  139,
 /*   890 */   139,   89,  139,  212,  139,  161,   49,  150,   51,  139,
 /*   900 */   139,   25,   23,   56,   25,  139,  139,  139,  139,  139,
 /*   910 */   139,  161,  161,  139,  161,  139,  161,  139,   23,    9,
 /*   920 */    25,  161,  161,  121,  122,  123,  124,  125,  161,  161,
 /*   930 */   161,  161,  161,  139,  139,  161,  139,  161,  139,  161,
 /*   940 */   139,  175,  139,   96,   97,   98,   23,   47,   25,  102,
 /*   950 */   139,  139,  139,  139,  107,  161,  161,   23,  161,   25,
 /*   960 */   161,   23,  161,   25,  161,  139,  121,  122,   23,  139,
 /*   970 */    25,   95,  161,  146,  161,  161,  139,  139,  139,  188,
 /*   980 */   189,   53,   54,  139,   26,   25,  146,  175,  139,  173,
 /*   990 */   174,  161,   60,  104,  139,   95,  107,  139,   23,  161,
 /*  1000 */    25,  175,  139,  176,  139,  161,  139,   23,   48,   25,
 /*  1010 */   161,   23,  175,   25,  175,   25,  176,  133,  134,  161,
 /*  1020 */    22,   89,   24,  159,  161,  139,  139,  139,  161,  139,
 /*  1030 */   158,  179,   23,  139,   25,   95,  164,   33,  186,  159,
 /*  1040 */   175,   42,   46,   85,  167,  160,   22,  177,  161,  107,
 /*  1050 */   159,  161,  159,  109,  176,  109,  115,  118,  184,  178,
 /*  1060 */   113,  175,  180,  175,  181,  116,  114,  212,  117,   25,
 /*  1070 */   214,  214,   94,  160,  182,   26,  151,  109,  109,  183,
 /*  1080 */    89,   81,  185,  107,  107,  126,  107,  139,   17,  139,
 /*  1090 */    22,  174,  139,   23,   25,  139,  198,   23,  109,  114,
 /*  1100 */   110,  139,  198,  160,  143,   25,  190,  208,  111,  139,
 /*  1110 */   209,  139,  139,  139,  143,   95,  192,  191,  112,   22,
 /*  1120 */   139,   23,  191,  109,   23,  192,  159,   22,  162,  165,
 /*  1130 */   167,  139,  139,  198,  198,   23,   46,   22,   22,   46,
 /*  1140 */    22,   93,  100,  163,  139,   24,  151,  160,  166,  166,
 /*  1150 */   139,   95,  166,  152,  160,  139,  143,  139,  143,   39,
 /*  1160 */   139,   11,  143,   37,   47,  129,  159,  159,   95,  139,
 /*  1170 */    95,  169,  169,  163,  162,  218,  143,   95,   22,    9,
 /*  1180 */   129,  119,  217,   11,  159,  119,   17,    9,    9,   58,
 /*  1190 */    17,  139,  139,   99,   67,  172,    9,   67,  172,  139,
 /*  1200 */   119,    9,   22,   22,  139,  110,    9,    9,  181,    9,
 /*  1210 */   181,    9,    9,  110,    9,  181,  181,  172,   99,    9,
 /*  1220 */     9,  119,  139,   22,    9,  139,    9,  143,    9,    9,
 /*  1230 */   202,    9,   23,  202,    9,  139,  219,  152,   34,  139,
 /*  1240 */    24,    9,  220,  152,    9,    9,  139,    9,  224,  224,
 /*  1250 */   224,  224,  224,  224,  222,  224,  224,  224,  224,  224,
 /*  1260 */   223,  222,
};
#define YY_SHIFT_USE_DFLT (-71)
static const short yy_shift_ofst[] = {
 /*     0 */   875,  463,  -71,  847,  226,  -71,  244,  599,  252,  355,
 /*    10 */   329,  475,  -71,  -71,  -71,  -71,  -71,  -71,  252,  564,
 /*    20 */   252,  647,  252,  704,  998,  731,   59,  938,  818,  910,
 /*    30 */    -9,  -71,  958,  -71,  364,  -71,   59,  -27,  -71,  940,
 /*    40 */   -71, 1004,  319,  -71,  -71,  -71,  -71,  -71,  -71,  -71,
 /*    50 */   740,  940,  -71,  999,  -71,  285,  -71,  -71,  996,  807,
 /*    60 */   940,  -71,  -71,  -71,  940,  -71, 1024,  802,  240,  639,
 /*    70 */   944,  946,  669,  -71,  505,  942,  -71,  258,  -71,  990,
 /*    80 */   939,  941,  949,  947,  951,  -71,  798,  -71,  -71,  960,
 /*    90 */   798,  -71,  845,  -71,  -71,  -71,  845,  -71,  -71,  798,
 /*   100 */   -71,  952,  802, 1044,  802,  978,  807,  -71, 1049,  -71,
 /*   110 */   -71,  472,  802,  -71,  968,   59,  969,   59,  -71,  -71,
 /*   120 */   -71,  -71,  -71,  607,  802,  562,  802,  -69,  802,  -69,
 /*   130 */   802,  -69,  802,  -69,  802,  153,  802,  153,  802,  -55,
 /*   140 */   802,  -55,  802,  -55,  802,  -55,  802,  -50,  802,  -50,
 /*   150 */   802, 1000,  802, 1000,  802, 1000,  802,  -71,  -71,  -71,
 /*   160 */   668,  -71,  -71,  -71,  -71,  -71,  802,  153,  -71,  932,
 /*   170 */   -71,  991,  -71,  -71,  -71,  802,  517,  802,  153,  -71,
 /*   180 */   283,  669,  316,  889,  976,  977,  979,  -71,  472,  802,
 /*   190 */   607,  802,  -71,  802,  -71,  802,  -71,  746,  139,  959,
 /*   200 */   583, 1071,  -71,  802,  253,  802,  472, 1068,  759, 1070,
 /*   210 */   -71, 1069,   59, 1074,  -71,  802,  323,  802,  208,  802,
 /*   220 */   472,  832,  -71,  802,  -71,  -71,  989,   59,  -71,  -71,
 /*   230 */   978,  807,  -71,  802,  472,  985,  802, 1080,  802,  472,
 /*   240 */   -71,  -71,  533,  -71,  -71,  -71,  152,  -71,  266,  -71,
 /*   250 */   997,  -71,  170,  989,  622,  -71,  -71,   59,  -71,  -71,
 /*   260 */  1020, 1006,  -71, 1097,   59,   61,  -71,   59,  -71,  -71,
 /*   270 */   802,  472,  942,  268,  488, 1098,  622, 1020, 1006,  -71,
 /*   280 */   725,  -24,  -71,  -71, 1014,   65,  -71,  -71,  -71,  -71,
 /*   290 */   427,  -71,   46,  -71, 1101,  -71,   94,  940,  -71,   59,
 /*   300 */  1105,  -71,  415,  -71,   59,  -71,  641,  717,  -71,  -70,
 /*   310 */   -71,  -71,  -71,  -71,  717,  -71,  717,  -71,   59,  988,
 /*   320 */   -71,   59,  978,  807,  -71,  -71,  978,  807,  -71,  -71,
 /*   330 */  1049,  -71,  999,  -71,  -71,  105,  -71,  -71,  -71,  -71,
 /*   340 */   758,  798,  945,  -71,  798, 1112,  -71,  -71,  -71,  -71,
 /*   350 */    45,  149,  -71,   59,  -71, 1090, 1115,   59,  923,  940,
 /*   360 */   -71, 1116,   59,  984,  940,  -71,  802,   35,  -71, 1093,
 /*   370 */  1118,   59,  975, 1048,   59, 1105,  -71,  420, 1042,  -71,
 /*   380 */   -71,  -71,  -71,  -71,  942,  416,  636,  595,   59,  989,
 /*   390 */   -71,   59,  540, 1121,  942,  356,   59,  989,  486,  474,
 /*   400 */  1056,   59,  989,  -71, 1120,  182, 1150,  802,  368, 1126,
 /*   410 */   928,  -71,  -71, 1073, 1075,  900,   59,  876,  -71,  -71,
 /*   420 */  1117,  -71,  -71, 1036,   59,  626, 1082,   59, 1156,   59,
 /*   430 */  1009,  514, 1170, 1051, 1172,  458,  242,  501,  319,  -71,
 /*   440 */  1062, 1066, 1169, 1178, 1179,  458, 1173, 1131,   59, 1094,
 /*   450 */    59,  592,   59, 1127,  802,  472, 1187, 1130,  802,  472,
 /*   460 */  1081,   59, 1180,   59,  895,  -71,  586,   18, 1181,  802,
 /*   470 */   934,  802,  472, 1192,  472, 1095,   59,  735, 1197,  352,
 /*   480 */    59, 1198,   59, 1200,   59, 1202,   59, 1203,  457, 1103,
 /*   490 */    59,  735, 1205, 1131,   59, 1119,   59,  592, 1210, 1102,
 /*   500 */    59, 1180,  538,  238, 1201,  802,  879, 1211,  397, 1215,
 /*   510 */    59,  989,  237,  100, 1217, 1219, 1220, 1222,   59, 1209,
 /*   520 */  1225, 1204,  958, 1216,   59,  609, 1232,  710, 1235, 1236,
 /*   530 */   -71, 1204,   59, 1238,  -71,  -71,  -71,
};
#define YY_REDUCE_USE_DFLT (-142)
static const short yy_reduce_ofst[] = {
 /*     0 */   435,  884, -142,  160, -142, -142, -142,  173,  267, -142,
 /*    10 */   278, -142, -142, -142, -142, -142, -142, -142,  380, -142,
 /*    20 */   478, -142,  528, -142,  646, -142,  110,  662, -142, -142,
 /*    30 */   -20, -142,  549,  747,  680, -142,  894,  872, -142,  864,
 /*    40 */  -142, -142,  816, -142, -142, -142, -142, -142, -142, -142,
 /*    50 */  -142,  880, -142,  877, -142, -142, -142, -142, -142,  885,
 /*    60 */   891, -142, -142, -142,  893, -142, -142,  753, -142,  -81,
 /*    70 */  -142, -142,  643, -142,  870,  878, -142,  881,  852,  882,
 /*    80 */   883,  892,  896,  874,  897, -142,  449, -142, -142, -142,
 /*    90 */   314, -142,  856, -142, -142, -142,  857, -142, -142,   88,
 /*   100 */  -142, -142,  214, -142,  553,  898,  913, -142,  925, -142,
 /*   110 */  -142,  272,  844, -142, -142,  948, -142,  950, -142, -142,
 /*   120 */  -142, -142, -142,  272,  867,  272,  887,  272,  890,  272,
 /*   130 */   587,  272,  666,  272,  720,  272,  721,  272,  750,  272,
 /*   140 */   751,  272,  755,  272,  761,  272,  695,  272,  770,  272,
 /*   150 */   771,  272,  778,  272,  794,  272,  797,  272, -142, -142,
 /*   160 */  -142, -142, -142, -142, -142, -142,  849,  272, -142, -142,
 /*   170 */  -142, -142, -142, -142, -142,  760,  272,  774,  272, -142,
 /*   180 */   953,  557,  870, -142, -142, -142, -142, -142,  272,  858,
 /*   190 */   272,  801,  272,  660,  272,  768,  272,  581,  272,  899,
 /*   200 */   901, -142, -142,  734,  272,  678,  272, -142,  917, -142,
 /*   210 */  -142, -142,  956, -142, -142,  803,  272,  799,  272,  776,
 /*   220 */   272, -142, -142,  561, -142, -142,  961,  962, -142, -142,
 /*   230 */   904,  943, -142,  830,  272, -142,  -19, -142,  814,  272,
 /*   240 */  -142,  791,  916, -142, -142, -142,  970, -142,  972, -142,
 /*   250 */  -142, -142,  973,  971,  693, -142, -142,  974, -142, -142,
 /*   260 */   926,  924, -142, -142,   -6, -142, -142,  981, -142, -142,
 /*   270 */   811,  272,  114,  870,  916, -142,  674,  931,  933, -142,
 /*   280 */   795,  -65, -142, -142, -142,  948, -142, -142, -142, -142,
 /*   290 */   272, -142, -142, -142, -142, -142,  272,  967, -142,  992,
 /*   300 */   966,  980,  964, -142,  993, -142, -142,  982, -142, -142,
 /*   310 */  -142, -142, -142, -142,  983, -142,  986, -142,  681, -142,
 /*   320 */  -142,  855,  935,  987, -142, -142,  936,  994, -142, -142,
 /*   330 */   995, -142,  963, -142, -142,   32, -142, -142, -142, -142,
 /*   340 */  1001,  -66, -142, -142, -141, -142, -142, -142, -142, -142,
 /*   350 */  1002, 1003, -142, 1005, -142, -142, -142,  642, -142, 1007,
 /*   360 */  -142, -142,  613, -142, 1008, -142,  863,  320, -142, -142,
 /*   370 */  -142,  520, -142, -142, 1011, 1012, 1010,  489, -142, -142,
 /*   380 */  -142, -142, -142, -142,  840,  870,  555, -142, 1016, 1013,
 /*   390 */  -142, 1018, 1015, -142,  827,  870, 1021, 1019,  965,  957,
 /*   400 */  -142,  826,  -18, -142, 1017, 1022, -142,  838,  272, -142,
 /*   410 */  -142, -142, -142, -142, -142, -142,  468, -142, -142, -142,
 /*   420 */  -142, -142, -142, -142, 1030, 1033, -142,  865, -142, -138,
 /*   430 */  -142, 1025, -142, -142, -142,  558,  870, 1023, -114, -142,
 /*   440 */  -142, -142, -142, -142, -142,  597, -142, 1026, 1052, -142,
 /*   450 */   676, 1027, 1053, -142,  767,  272, -142, -142,  769,  272,
 /*   460 */  -142, 1060, 1028,  155, -142, -142,  632,  870, -142,  215,
 /*   470 */  -142,  813,  272, -142,  272, -142, 1065, 1029, -142, -142,
 /*   480 */   812, -142,  839, -142,  888, -142,  766, -142,  870, -142,
 /*   490 */   837, 1034, -142, 1045,  886, -142,  274, 1035, -142, -142,
 /*   500 */   566, 1031,  518,  870, -142,  217, -142, -142, 1083, -142,
 /*   510 */  1086, 1084, -142,  203, -142, -142, -142, -142, 1096, -142,
 /*   520 */  -142, 1032, 1085, -142, 1100, 1037, -142, 1091, -142, -142,
 /*   530 */  -142, 1039, 1107, -142, -142, -142, -142,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */   544,  544,  538,  829,  829,  540,  829,  549,  829,  829,
 /*    10 */   829,  829,  569,  570,  571,  550,  551,  552,  829,  829,
 /*    20 */   829,  829,  829,  829,  829,  829,  829,  829,  829,  829,
 /*    30 */   829,  562,  572,  581,  564,  580,  829,  829,  582,  623,
 /*    40 */   588,  829,  829,  624,  627,  628,  629,  818,  819,  820,
 /*    50 */   829,  623,  589,  608,  606,  829,  609,  610,  829,  679,
 /*    60 */   623,  590,  677,  678,  623,  591,  829,  829,  708,  770,
 /*    70 */   714,  709,  829,  634,  829,  829,  635,  643,  645,  652,
 /*    80 */   691,  682,  684,  672,  686,  640,  793,  578,  579,  687,
 /*    90 */   793,  688,  829,  788,  790,  791,  829,  789,  792,  793,
 /*   100 */   689,  829,  829,  673,  829,  680,  679,  674,  829,  566,
 /*   110 */   681,  676,  829,  707,  829,  829,  710,  829,  711,  712,
 /*   120 */   713,  715,  716,  719,  829,  720,  829,  721,  829,  722,
 /*   130 */   829,  723,  829,  724,  829,  725,  829,  726,  829,  727,
 /*   140 */   829,  728,  829,  729,  829,  730,  829,  731,  829,  732,
 /*   150 */   829,  733,  829,  734,  829,  735,  829,  736,  737,  738,
 /*   160 */   829,  739,  740,  745,  753,  756,  829,  741,  742,  829,
 /*   170 */   743,  829,  746,  744,  752,  829,  829,  829,  754,  755,
 /*   180 */   829,  770,  829,  829,  829,  829,  829,  758,  769,  829,
 /*   190 */   747,  829,  748,  829,  749,  829,  750,  829,  829,  829,
 /*   200 */   829,  829,  760,  829,  829,  829,  761,  829,  829,  829,
 /*   210 */   816,  829,  829,  829,  817,  829,  829,  829,  829,  829,
 /*   220 */   762,  829,  757,  770,  767,  768,  660,  829,  661,  759,
 /*   230 */   680,  679,  675,  829,  685,  829,  770,  683,  829,  692,
 /*   240 */   644,  655,  653,  654,  663,  664,  829,  665,  829,  666,
 /*   250 */   829,  667,  829,  660,  651,  567,  568,  829,  649,  650,
 /*   260 */   669,  671,  656,  829,  829,  829,  670,  829,  704,  705,
 /*   270 */   829,  668,  655,  829,  829,  829,  651,  669,  671,  657,
 /*   280 */   829,  651,  646,  647,  829,  829,  648,  641,  642,  751,
 /*   290 */   829,  706,  829,  717,  829,  718,  829,  623,  592,  829,
 /*   300 */   774,  596,  593,  597,  829,  598,  829,  829,  599,  829,
 /*   310 */   602,  603,  604,  605,  829,  600,  829,  601,  829,  829,
 /*   320 */   775,  829,  680,  679,  776,  778,  680,  679,  777,  594,
 /*   330 */   829,  595,  608,  607,  583,  793,  584,  585,  586,  587,
 /*   340 */   573,  793,  829,  574,  793,  829,  575,  577,  576,  565,
 /*   350 */   829,  829,  613,  829,  616,  829,  829,  829,  829,  623,
 /*   360 */   617,  829,  829,  829,  623,  618,  829,  623,  619,  829,
 /*   370 */   829,  829,  829,  829,  829,  774,  596,  621,  829,  620,
 /*   380 */   622,  614,  615,  563,  829,  829,  559,  829,  829,  660,
 /*   390 */   557,  829,  829,  829,  829,  829,  829,  660,  799,  829,
 /*   400 */   829,  829,  660,  662,  804,  829,  829,  829,  829,  829,
 /*   410 */   829,  805,  806,  829,  829,  829,  829,  829,  796,  797,
 /*   420 */   829,  798,  558,  829,  829,  829,  829,  829,  829,  829,
 /*   430 */   829,  829,  829,  829,  829,  829,  829,  829,  829,  626,
 /*   440 */   829,  829,  829,  829,  829,  829,  829,  625,  829,  829,
 /*   450 */   829,  829,  829,  829,  829,  694,  829,  829,  829,  695,
 /*   460 */   829,  829,  702,  829,  829,  703,  829,  829,  829,  829,
 /*   470 */   829,  829,  700,  829,  701,  829,  829,  829,  829,  829,
 /*   480 */   829,  829,  829,  829,  829,  829,  829,  829,  829,  829,
 /*   490 */   829,  829,  829,  625,  829,  829,  829,  829,  829,  829,
 /*   500 */   829,  702,  829,  829,  829,  829,  829,  829,  829,  829,
 /*   510 */   829,  660,  829,  793,  829,  829,  829,  829,  829,  829,
 /*   520 */   829,  827,  829,  829,  829,  829,  829,  829,  829,  829,
 /*   530 */   826,  827,  829,  829,  541,  543,  539,
};
#define YY_SZ_ACTTAB (sizeof(yy_action)/sizeof(yy_action[0]))

/* The next table maps tokens into fallback tokens.  If a construct
** like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammer, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /* END_OF_FILE => nothing */
    0,  /*    ILLEGAL => nothing */
    0,  /*      SPACE => nothing */
    0,  /* UNCLOSED_STRING => nothing */
    0,  /*    COMMENT => nothing */
    0,  /*   FUNCTION => nothing */
    0,  /*     COLUMN => nothing */
    0,  /* AGG_FUNCTION => nothing */
    0,  /*       SEMI => nothing */
   26,  /*    EXPLAIN => ID */
   26,  /*      BEGIN => ID */
    0,  /* TRANSACTION => nothing */
   26,  /*   DEFERRED => ID */
   26,  /*  IMMEDIATE => ID */
   26,  /*  EXCLUSIVE => ID */
    0,  /*     COMMIT => nothing */
   26,  /*        END => ID */
    0,  /*   ROLLBACK => nothing */
    0,  /*     CREATE => nothing */
    0,  /*      TABLE => nothing */
   26,  /*       TEMP => ID */
    0,  /*         LP => nothing */
    0,  /*         RP => nothing */
    0,  /*         AS => nothing */
    0,  /*      COMMA => nothing */
    0,  /*         ID => nothing */
   26,  /*      ABORT => ID */
   26,  /*      AFTER => ID */
   26,  /*        ASC => ID */
   26,  /*     ATTACH => ID */
   26,  /*     BEFORE => ID */
   26,  /*    CASCADE => ID */
   26,  /*   CONFLICT => ID */
   26,  /*   DATABASE => ID */
   26,  /*       DESC => ID */
   26,  /*     DETACH => ID */
   26,  /*       EACH => ID */
   26,  /*       FAIL => ID */
   26,  /*        FOR => ID */
   26,  /*       GLOB => ID */
   26,  /*     IGNORE => ID */
   26,  /*  INITIALLY => ID */
   26,  /*    INSTEAD => ID */
   26,  /*       LIKE => ID */
   26,  /*      MATCH => ID */
   26,  /*        KEY => ID */
   26,  /*         OF => ID */
   26,  /*     OFFSET => ID */
   26,  /*     PRAGMA => ID */
   26,  /*      RAISE => ID */
   26,  /*    REPLACE => ID */
   26,  /*   RESTRICT => ID */
   26,  /*        ROW => ID */
   26,  /*  STATEMENT => ID */
   26,  /*    TRIGGER => ID */
   26,  /*     VACUUM => ID */
   26,  /*       VIEW => ID */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*        NOT => nothing */
    0,  /*         IS => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         IN => nothing */
    0,  /*     ISNULL => nothing */
    0,  /*    NOTNULL => nothing */
    0,  /*         NE => nothing */
    0,  /*         EQ => nothing */
    0,  /*         GT => nothing */
    0,  /*         LE => nothing */
    0,  /*         LT => nothing */
    0,  /*         GE => nothing */
    0,  /*     BITAND => nothing */
    0,  /*      BITOR => nothing */
    0,  /*     LSHIFT => nothing */
    0,  /*     RSHIFT => nothing */
    0,  /*       PLUS => nothing */
    0,  /*      MINUS => nothing */
    0,  /*       STAR => nothing */
    0,  /*      SLASH => nothing */
    0,  /*        REM => nothing */
    0,  /*     CONCAT => nothing */
    0,  /*     UMINUS => nothing */
    0,  /*      UPLUS => nothing */
    0,  /*     BITNOT => nothing */
    0,  /*     STRING => nothing */
    0,  /*    JOIN_KW => nothing */
    0,  /* CONSTRAINT => nothing */
    0,  /*    DEFAULT => nothing */
    0,  /*       NULL => nothing */
    0,  /*    PRIMARY => nothing */
    0,  /*     UNIQUE => nothing */
    0,  /*      CHECK => nothing */
    0,  /* REFERENCES => nothing */
    0,  /*    COLLATE => nothing */
    0,  /*         ON => nothing */
    0,  /*     DELETE => nothing */
    0,  /*     UPDATE => nothing */
    0,  /*     INSERT => nothing */
    0,  /*        SET => nothing */
    0,  /* DEFERRABLE => nothing */
    0,  /*    FOREIGN => nothing */
    0,  /*       DROP => nothing */
    0,  /*      UNION => nothing */
    0,  /*        ALL => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*     EXCEPT => nothing */
    0,  /*     SELECT => nothing */
    0,  /*   DISTINCT => nothing */
    0,  /*        DOT => nothing */
    0,  /*       FROM => nothing */
    0,  /*       JOIN => nothing */
    0,  /*      USING => nothing */
    0,  /*      ORDER => nothing */
    0,  /*         BY => nothing */
    0,  /*      GROUP => nothing */
    0,  /*     HAVING => nothing */
    0,  /*      LIMIT => nothing */
    0,  /*      WHERE => nothing */
    0,  /*       INTO => nothing */
    0,  /*     VALUES => nothing */
    0,  /*    INTEGER => nothing */
    0,  /*      FLOAT => nothing */
    0,  /*       BLOB => nothing */
    0,  /*   VARIABLE => nothing */
    0,  /*       CASE => nothing */
    0,  /*       WHEN => nothing */
    0,  /*       THEN => nothing */
    0,  /*       ELSE => nothing */
    0,  /*      INDEX => nothing */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
*/
struct yyStackEntry {
  int stateno;       /* The state-number */
  int major;         /* The major token value.  This is the code
                     ** number for the token at this stack level */
  YYMINORTYPE minor; /* The user-supplied minor token value.  This
                     ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  int yyidx;                    /* Index of top element in stack */
  int yyerrcnt;                 /* Shifts left before out of the error */
  sqlite3ParserARG_SDECL                /* A place to hold %extra_argument */
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void sqlite3ParserTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  "$",             "END_OF_FILE",   "ILLEGAL",       "SPACE",       
  "UNCLOSED_STRING",  "COMMENT",       "FUNCTION",      "COLUMN",      
  "AGG_FUNCTION",  "SEMI",          "EXPLAIN",       "BEGIN",       
  "TRANSACTION",   "DEFERRED",      "IMMEDIATE",     "EXCLUSIVE",   
  "COMMIT",        "END",           "ROLLBACK",      "CREATE",      
  "TABLE",         "TEMP",          "LP",            "RP",          
  "AS",            "COMMA",         "ID",            "ABORT",       
  "AFTER",         "ASC",           "ATTACH",        "BEFORE",      
  "CASCADE",       "CONFLICT",      "DATABASE",      "DESC",        
  "DETACH",        "EACH",          "FAIL",          "FOR",         
  "GLOB",          "IGNORE",        "INITIALLY",     "INSTEAD",     
  "LIKE",          "MATCH",         "KEY",           "OF",          
  "OFFSET",        "PRAGMA",        "RAISE",         "REPLACE",     
  "RESTRICT",      "ROW",           "STATEMENT",     "TRIGGER",     
  "VACUUM",        "VIEW",          "OR",            "AND",         
  "NOT",           "IS",            "BETWEEN",       "IN",          
  "ISNULL",        "NOTNULL",       "NE",            "EQ",          
  "GT",            "LE",            "LT",            "GE",          
  "BITAND",        "BITOR",         "LSHIFT",        "RSHIFT",      
  "PLUS",          "MINUS",         "STAR",          "SLASH",       
  "REM",           "CONCAT",        "UMINUS",        "UPLUS",       
  "BITNOT",        "STRING",        "JOIN_KW",       "CONSTRAINT",  
  "DEFAULT",       "NULL",          "PRIMARY",       "UNIQUE",      
  "CHECK",         "REFERENCES",    "COLLATE",       "ON",          
  "DELETE",        "UPDATE",        "INSERT",        "SET",         
  "DEFERRABLE",    "FOREIGN",       "DROP",          "UNION",       
  "ALL",           "INTERSECT",     "EXCEPT",        "SELECT",      
  "DISTINCT",      "DOT",           "FROM",          "JOIN",        
  "USING",         "ORDER",         "BY",            "GROUP",       
  "HAVING",        "LIMIT",         "WHERE",         "INTO",        
  "VALUES",        "INTEGER",       "FLOAT",         "BLOB",        
  "VARIABLE",      "CASE",          "WHEN",          "THEN",        
  "ELSE",          "INDEX",         "error",         "input",       
  "cmdlist",       "ecmd",          "explain",       "cmdx",        
  "cmd",           "transtype",     "trans_opt",     "nm",          
  "create_table",  "create_table_args",  "temp",          "dbnm",        
  "columnlist",    "conslist_opt",  "select",        "column",      
  "columnid",      "type",          "carglist",      "id",          
  "ids",           "typename",      "signed",        "plus_num",    
  "minus_num",     "carg",          "ccons",         "onconf",      
  "sortorder",     "expr",          "idxlist_opt",   "refargs",     
  "defer_subclause",  "refarg",        "refact",        "init_deferred_pred_opt",
  "conslist",      "tcons",         "idxlist",       "defer_subclause_opt",
  "orconf",        "resolvetype",   "raisetype",     "fullname",    
  "oneselect",     "multiselect_op",  "distinct",      "selcollist",  
  "from",          "where_opt",     "groupby_opt",   "having_opt",  
  "orderby_opt",   "limit_opt",     "sclp",          "as",          
  "seltablist",    "stl_prefix",    "joinop",        "on_opt",      
  "using_opt",     "seltablist_paren",  "joinop2",       "inscollist",  
  "sortlist",      "sortitem",      "collate",       "exprlist",    
  "setlist",       "insert_cmd",    "inscollist_opt",  "itemlist",    
  "likeop",        "between_op",    "in_op",         "case_operand",
  "case_exprlist",  "case_else",     "expritem",      "uniqueflag",  
  "idxitem",       "plus_opt",      "number",        "trigger_decl",
  "trigger_cmd_list",  "trigger_time",  "trigger_event",  "foreach_clause",
  "when_clause",   "trigger_cmd",   "database_kw_opt",  "key_opt",     
};
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "input ::= cmdlist",
 /*   1 */ "cmdlist ::= cmdlist ecmd",
 /*   2 */ "cmdlist ::= ecmd",
 /*   3 */ "ecmd ::= explain cmdx SEMI",
 /*   4 */ "ecmd ::= SEMI",
 /*   5 */ "cmdx ::= cmd",
 /*   6 */ "explain ::= EXPLAIN",
 /*   7 */ "explain ::=",
 /*   8 */ "cmd ::= BEGIN transtype trans_opt",
 /*   9 */ "trans_opt ::=",
 /*  10 */ "trans_opt ::= TRANSACTION",
 /*  11 */ "trans_opt ::= TRANSACTION nm",
 /*  12 */ "transtype ::=",
 /*  13 */ "transtype ::= DEFERRED",
 /*  14 */ "transtype ::= IMMEDIATE",
 /*  15 */ "transtype ::= EXCLUSIVE",
 /*  16 */ "cmd ::= COMMIT trans_opt",
 /*  17 */ "cmd ::= END trans_opt",
 /*  18 */ "cmd ::= ROLLBACK trans_opt",
 /*  19 */ "cmd ::= create_table create_table_args",
 /*  20 */ "create_table ::= CREATE temp TABLE nm dbnm",
 /*  21 */ "temp ::= TEMP",
 /*  22 */ "temp ::=",
 /*  23 */ "create_table_args ::= LP columnlist conslist_opt RP",
 /*  24 */ "create_table_args ::= AS select",
 /*  25 */ "columnlist ::= columnlist COMMA column",
 /*  26 */ "columnlist ::= column",
 /*  27 */ "column ::= columnid type carglist",
 /*  28 */ "columnid ::= nm",
 /*  29 */ "id ::= ID",
 /*  30 */ "ids ::= ID",
 /*  31 */ "ids ::= STRING",
 /*  32 */ "nm ::= ID",
 /*  33 */ "nm ::= STRING",
 /*  34 */ "nm ::= JOIN_KW",
 /*  35 */ "type ::=",
 /*  36 */ "type ::= typename",
 /*  37 */ "type ::= typename LP signed RP",
 /*  38 */ "type ::= typename LP signed COMMA signed RP",
 /*  39 */ "typename ::= ids",
 /*  40 */ "typename ::= typename ids",
 /*  41 */ "signed ::= plus_num",
 /*  42 */ "signed ::= minus_num",
 /*  43 */ "carglist ::= carglist carg",
 /*  44 */ "carglist ::=",
 /*  45 */ "carg ::= CONSTRAINT nm ccons",
 /*  46 */ "carg ::= ccons",
 /*  47 */ "carg ::= DEFAULT ids",
 /*  48 */ "carg ::= DEFAULT plus_num",
 /*  49 */ "carg ::= DEFAULT minus_num",
 /*  50 */ "carg ::= DEFAULT NULL",
 /*  51 */ "ccons ::= NULL onconf",
 /*  52 */ "ccons ::= NOT NULL onconf",
 /*  53 */ "ccons ::= PRIMARY KEY sortorder onconf",
 /*  54 */ "ccons ::= UNIQUE onconf",
 /*  55 */ "ccons ::= CHECK LP expr RP onconf",
 /*  56 */ "ccons ::= REFERENCES nm idxlist_opt refargs",
 /*  57 */ "ccons ::= defer_subclause",
 /*  58 */ "ccons ::= COLLATE id",
 /*  59 */ "refargs ::=",
 /*  60 */ "refargs ::= refargs refarg",
 /*  61 */ "refarg ::= MATCH nm",
 /*  62 */ "refarg ::= ON DELETE refact",
 /*  63 */ "refarg ::= ON UPDATE refact",
 /*  64 */ "refarg ::= ON INSERT refact",
 /*  65 */ "refact ::= SET NULL",
 /*  66 */ "refact ::= SET DEFAULT",
 /*  67 */ "refact ::= CASCADE",
 /*  68 */ "refact ::= RESTRICT",
 /*  69 */ "defer_subclause ::= NOT DEFERRABLE init_deferred_pred_opt",
 /*  70 */ "defer_subclause ::= DEFERRABLE init_deferred_pred_opt",
 /*  71 */ "init_deferred_pred_opt ::=",
 /*  72 */ "init_deferred_pred_opt ::= INITIALLY DEFERRED",
 /*  73 */ "init_deferred_pred_opt ::= INITIALLY IMMEDIATE",
 /*  74 */ "conslist_opt ::=",
 /*  75 */ "conslist_opt ::= COMMA conslist",
 /*  76 */ "conslist ::= conslist COMMA tcons",
 /*  77 */ "conslist ::= conslist tcons",
 /*  78 */ "conslist ::= tcons",
 /*  79 */ "tcons ::= CONSTRAINT nm",
 /*  80 */ "tcons ::= PRIMARY KEY LP idxlist RP onconf",
 /*  81 */ "tcons ::= UNIQUE LP idxlist RP onconf",
 /*  82 */ "tcons ::= CHECK expr onconf",
 /*  83 */ "tcons ::= FOREIGN KEY LP idxlist RP REFERENCES nm idxlist_opt refargs defer_subclause_opt",
 /*  84 */ "defer_subclause_opt ::=",
 /*  85 */ "defer_subclause_opt ::= defer_subclause",
 /*  86 */ "onconf ::=",
 /*  87 */ "onconf ::= ON CONFLICT resolvetype",
 /*  88 */ "orconf ::=",
 /*  89 */ "orconf ::= OR resolvetype",
 /*  90 */ "resolvetype ::= raisetype",
 /*  91 */ "resolvetype ::= IGNORE",
 /*  92 */ "resolvetype ::= REPLACE",
 /*  93 */ "cmd ::= DROP TABLE fullname",
 /*  94 */ "cmd ::= CREATE temp VIEW nm dbnm AS select",
 /*  95 */ "cmd ::= DROP VIEW fullname",
 /*  96 */ "cmd ::= select",
 /*  97 */ "select ::= oneselect",
 /*  98 */ "select ::= select multiselect_op oneselect",
 /*  99 */ "multiselect_op ::= UNION",
 /* 100 */ "multiselect_op ::= UNION ALL",
 /* 101 */ "multiselect_op ::= INTERSECT",
 /* 102 */ "multiselect_op ::= EXCEPT",
 /* 103 */ "oneselect ::= SELECT distinct selcollist from where_opt groupby_opt having_opt orderby_opt limit_opt",
 /* 104 */ "distinct ::= DISTINCT",
 /* 105 */ "distinct ::= ALL",
 /* 106 */ "distinct ::=",
 /* 107 */ "sclp ::= selcollist COMMA",
 /* 108 */ "sclp ::=",
 /* 109 */ "selcollist ::= sclp expr as",
 /* 110 */ "selcollist ::= sclp STAR",
 /* 111 */ "selcollist ::= sclp nm DOT STAR",
 /* 112 */ "as ::= AS nm",
 /* 113 */ "as ::= ids",
 /* 114 */ "as ::=",
 /* 115 */ "from ::=",
 /* 116 */ "from ::= FROM seltablist",
 /* 117 */ "stl_prefix ::= seltablist joinop",
 /* 118 */ "stl_prefix ::=",
 /* 119 */ "seltablist ::= stl_prefix nm dbnm as on_opt using_opt",
 /* 120 */ "seltablist ::= stl_prefix LP seltablist_paren RP as on_opt using_opt",
 /* 121 */ "seltablist_paren ::= select",
 /* 122 */ "seltablist_paren ::= seltablist",
 /* 123 */ "dbnm ::=",
 /* 124 */ "dbnm ::= DOT nm",
 /* 125 */ "fullname ::= nm dbnm",
 /* 126 */ "joinop ::= COMMA",
 /* 127 */ "joinop ::= JOIN",
 /* 128 */ "joinop ::= JOIN_KW JOIN",
 /* 129 */ "joinop ::= JOIN_KW nm JOIN",
 /* 130 */ "joinop ::= JOIN_KW nm nm JOIN",
 /* 131 */ "on_opt ::= ON expr",
 /* 132 */ "on_opt ::=",
 /* 133 */ "using_opt ::= USING LP inscollist RP",
 /* 134 */ "using_opt ::=",
 /* 135 */ "orderby_opt ::=",
 /* 136 */ "orderby_opt ::= ORDER BY sortlist",
 /* 137 */ "sortlist ::= sortlist COMMA sortitem collate sortorder",
 /* 138 */ "sortlist ::= sortitem collate sortorder",
 /* 139 */ "sortitem ::= expr",
 /* 140 */ "sortorder ::= ASC",
 /* 141 */ "sortorder ::= DESC",
 /* 142 */ "sortorder ::=",
 /* 143 */ "collate ::=",
 /* 144 */ "collate ::= COLLATE id",
 /* 145 */ "groupby_opt ::=",
 /* 146 */ "groupby_opt ::= GROUP BY exprlist",
 /* 147 */ "having_opt ::=",
 /* 148 */ "having_opt ::= HAVING expr",
 /* 149 */ "limit_opt ::=",
 /* 150 */ "limit_opt ::= LIMIT signed",
 /* 151 */ "limit_opt ::= LIMIT signed OFFSET signed",
 /* 152 */ "limit_opt ::= LIMIT signed COMMA signed",
 /* 153 */ "cmd ::= DELETE FROM fullname where_opt",
 /* 154 */ "where_opt ::=",
 /* 155 */ "where_opt ::= WHERE expr",
 /* 156 */ "cmd ::= UPDATE orconf fullname SET setlist where_opt",
 /* 157 */ "setlist ::= setlist COMMA nm EQ expr",
 /* 158 */ "setlist ::= nm EQ expr",
 /* 159 */ "cmd ::= insert_cmd INTO fullname inscollist_opt VALUES LP itemlist RP",
 /* 160 */ "cmd ::= insert_cmd INTO fullname inscollist_opt select",
 /* 161 */ "insert_cmd ::= INSERT orconf",
 /* 162 */ "insert_cmd ::= REPLACE",
 /* 163 */ "itemlist ::= itemlist COMMA expr",
 /* 164 */ "itemlist ::= expr",
 /* 165 */ "inscollist_opt ::=",
 /* 166 */ "inscollist_opt ::= LP inscollist RP",
 /* 167 */ "inscollist ::= inscollist COMMA nm",
 /* 168 */ "inscollist ::= nm",
 /* 169 */ "expr ::= LP expr RP",
 /* 170 */ "expr ::= NULL",
 /* 171 */ "expr ::= ID",
 /* 172 */ "expr ::= JOIN_KW",
 /* 173 */ "expr ::= nm DOT nm",
 /* 174 */ "expr ::= nm DOT nm DOT nm",
 /* 175 */ "expr ::= INTEGER",
 /* 176 */ "expr ::= FLOAT",
 /* 177 */ "expr ::= STRING",
 /* 178 */ "expr ::= BLOB",
 /* 179 */ "expr ::= VARIABLE",
 /* 180 */ "expr ::= ID LP exprlist RP",
 /* 181 */ "expr ::= ID LP STAR RP",
 /* 182 */ "expr ::= expr AND expr",
 /* 183 */ "expr ::= expr OR expr",
 /* 184 */ "expr ::= expr LT expr",
 /* 185 */ "expr ::= expr GT expr",
 /* 186 */ "expr ::= expr LE expr",
 /* 187 */ "expr ::= expr GE expr",
 /* 188 */ "expr ::= expr NE expr",
 /* 189 */ "expr ::= expr EQ expr",
 /* 190 */ "expr ::= expr BITAND expr",
 /* 191 */ "expr ::= expr BITOR expr",
 /* 192 */ "expr ::= expr LSHIFT expr",
 /* 193 */ "expr ::= expr RSHIFT expr",
 /* 194 */ "expr ::= expr PLUS expr",
 /* 195 */ "expr ::= expr MINUS expr",
 /* 196 */ "expr ::= expr STAR expr",
 /* 197 */ "expr ::= expr SLASH expr",
 /* 198 */ "expr ::= expr REM expr",
 /* 199 */ "expr ::= expr CONCAT expr",
 /* 200 */ "likeop ::= LIKE",
 /* 201 */ "likeop ::= GLOB",
 /* 202 */ "likeop ::= NOT LIKE",
 /* 203 */ "likeop ::= NOT GLOB",
 /* 204 */ "expr ::= expr likeop expr",
 /* 205 */ "expr ::= expr ISNULL",
 /* 206 */ "expr ::= expr IS NULL",
 /* 207 */ "expr ::= expr NOTNULL",
 /* 208 */ "expr ::= expr NOT NULL",
 /* 209 */ "expr ::= expr IS NOT NULL",
 /* 210 */ "expr ::= NOT expr",
 /* 211 */ "expr ::= BITNOT expr",
 /* 212 */ "expr ::= MINUS expr",
 /* 213 */ "expr ::= PLUS expr",
 /* 214 */ "expr ::= LP select RP",
 /* 215 */ "between_op ::= BETWEEN",
 /* 216 */ "between_op ::= NOT BETWEEN",
 /* 217 */ "expr ::= expr between_op expr AND expr",
 /* 218 */ "in_op ::= IN",
 /* 219 */ "in_op ::= NOT IN",
 /* 220 */ "expr ::= expr in_op LP exprlist RP",
 /* 221 */ "expr ::= expr in_op LP select RP",
 /* 222 */ "expr ::= expr in_op nm dbnm",
 /* 223 */ "expr ::= CASE case_operand case_exprlist case_else END",
 /* 224 */ "case_exprlist ::= case_exprlist WHEN expr THEN expr",
 /* 225 */ "case_exprlist ::= WHEN expr THEN expr",
 /* 226 */ "case_else ::= ELSE expr",
 /* 227 */ "case_else ::=",
 /* 228 */ "case_operand ::= expr",
 /* 229 */ "case_operand ::=",
 /* 230 */ "exprlist ::= exprlist COMMA expritem",
 /* 231 */ "exprlist ::= expritem",
 /* 232 */ "expritem ::= expr",
 /* 233 */ "expritem ::=",
 /* 234 */ "cmd ::= CREATE uniqueflag INDEX nm dbnm ON fullname LP idxlist RP onconf",
 /* 235 */ "uniqueflag ::= UNIQUE",
 /* 236 */ "uniqueflag ::=",
 /* 237 */ "idxlist_opt ::=",
 /* 238 */ "idxlist_opt ::= LP idxlist RP",
 /* 239 */ "idxlist ::= idxlist COMMA idxitem collate sortorder",
 /* 240 */ "idxlist ::= idxitem collate sortorder",
 /* 241 */ "idxitem ::= nm",
 /* 242 */ "cmd ::= DROP INDEX fullname",
 /* 243 */ "cmd ::= VACUUM",
 /* 244 */ "cmd ::= VACUUM nm",
 /* 245 */ "cmd ::= PRAGMA nm dbnm EQ nm",
 /* 246 */ "cmd ::= PRAGMA nm dbnm EQ ON",
 /* 247 */ "cmd ::= PRAGMA nm dbnm EQ plus_num",
 /* 248 */ "cmd ::= PRAGMA nm dbnm EQ minus_num",
 /* 249 */ "cmd ::= PRAGMA nm dbnm LP nm RP",
 /* 250 */ "cmd ::= PRAGMA nm dbnm",
 /* 251 */ "plus_num ::= plus_opt number",
 /* 252 */ "minus_num ::= MINUS number",
 /* 253 */ "number ::= INTEGER",
 /* 254 */ "number ::= FLOAT",
 /* 255 */ "plus_opt ::= PLUS",
 /* 256 */ "plus_opt ::=",
 /* 257 */ "cmd ::= CREATE trigger_decl BEGIN trigger_cmd_list END",
 /* 258 */ "trigger_decl ::= temp TRIGGER nm dbnm trigger_time trigger_event ON fullname foreach_clause when_clause",
 /* 259 */ "trigger_time ::= BEFORE",
 /* 260 */ "trigger_time ::= AFTER",
 /* 261 */ "trigger_time ::= INSTEAD OF",
 /* 262 */ "trigger_time ::=",
 /* 263 */ "trigger_event ::= DELETE",
 /* 264 */ "trigger_event ::= INSERT",
 /* 265 */ "trigger_event ::= UPDATE",
 /* 266 */ "trigger_event ::= UPDATE OF inscollist",
 /* 267 */ "foreach_clause ::=",
 /* 268 */ "foreach_clause ::= FOR EACH ROW",
 /* 269 */ "foreach_clause ::= FOR EACH STATEMENT",
 /* 270 */ "when_clause ::=",
 /* 271 */ "when_clause ::= WHEN expr",
 /* 272 */ "trigger_cmd_list ::= trigger_cmd SEMI trigger_cmd_list",
 /* 273 */ "trigger_cmd_list ::=",
 /* 274 */ "trigger_cmd ::= UPDATE orconf nm SET setlist where_opt",
 /* 275 */ "trigger_cmd ::= insert_cmd INTO nm inscollist_opt VALUES LP itemlist RP",
 /* 276 */ "trigger_cmd ::= insert_cmd INTO nm inscollist_opt select",
 /* 277 */ "trigger_cmd ::= DELETE FROM nm where_opt",
 /* 278 */ "trigger_cmd ::= select",
 /* 279 */ "expr ::= RAISE LP IGNORE RP",
 /* 280 */ "expr ::= RAISE LP raisetype COMMA nm RP",
 /* 281 */ "raisetype ::= ROLLBACK",
 /* 282 */ "raisetype ::= ABORT",
 /* 283 */ "raisetype ::= FAIL",
 /* 284 */ "cmd ::= DROP TRIGGER fullname",
 /* 285 */ "cmd ::= ATTACH database_kw_opt ids AS nm key_opt",
 /* 286 */ "key_opt ::=",
 /* 287 */ "key_opt ::= KEY ids",
 /* 288 */ "key_opt ::= KEY BLOB",
 /* 289 */ "database_kw_opt ::= DATABASE",
 /* 290 */ "database_kw_opt ::=",
 /* 291 */ "cmd ::= DETACH database_kw_opt nm",
};
#endif /* NDEBUG */

/*
** This function returns the symbolic name associated with a token
** value.
*/
const char *sqlite3ParserTokenName(int tokenType){
#ifndef NDEBUG
  if( tokenType>0 && tokenType<(sizeof(yyTokenName)/sizeof(yyTokenName[0])) ){
    return yyTokenName[tokenType];
  }else{
    return "Unknown";
  }
#else
  return "";
#endif
}

/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to sqlite3Parser and sqlite3ParserFree.
*/
void *sqlite3ParserAlloc(void *(*mallocProc)(size_t)){
  yyParser *pParser;
  pParser = (yyParser*)(*mallocProc)( (size_t)sizeof(yyParser) );
  if( pParser ){
    pParser->yyidx = -1;
  }
  return pParser;
}

/* The following function deletes the value associated with a
** symbol.  The symbol can be either a terminal or nonterminal.
** "yymajor" is the symbol code, and "yypminor" is a pointer to
** the value.
*/
static void yy_destructor(YYCODETYPE yymajor, YYMINORTYPE *yypminor){
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are not used
    ** inside the C code.
    */
    case 146:
    case 176:
    case 193:
#line 303 "parse.y"
{sqlite3SelectDelete((yypminor->yy107));}
#line 1238 "parse.c"
      break;
    case 161:
    case 181:
    case 183:
    case 191:
    case 197:
    case 210:
#line 552 "parse.y"
{sqlite3ExprDelete((yypminor->yy258));}
#line 1248 "parse.c"
      break;
    case 162:
    case 170:
    case 179:
    case 182:
    case 184:
    case 186:
    case 196:
    case 199:
    case 200:
    case 203:
    case 208:
#line 744 "parse.y"
{sqlite3ExprListDelete((yypminor->yy210));}
#line 1263 "parse.c"
      break;
    case 175:
    case 180:
    case 188:
    case 189:
#line 428 "parse.y"
{sqlite3SrcListDelete((yypminor->yy259));}
#line 1271 "parse.c"
      break;
    case 192:
    case 195:
    case 202:
#line 446 "parse.y"
{sqlite3IdListDelete((yypminor->yy272));}
#line 1278 "parse.c"
      break;
    case 216:
    case 221:
#line 833 "parse.y"
{sqlite3DeleteTriggerStep((yypminor->yy91));}
#line 1284 "parse.c"
      break;
    case 218:
#line 817 "parse.y"
{sqlite3IdListDelete((yypminor->yy146).b);}
#line 1289 "parse.c"
      break;
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
**
** Return the major token number for the symbol popped.
*/
static int yy_pop_parser_stack(yyParser *pParser){
  YYCODETYPE yymajor;
  yyStackEntry *yytos = &pParser->yystack[pParser->yyidx];

  if( pParser->yyidx<0 ) return 0;
#ifndef NDEBUG
  if( yyTraceFILE && pParser->yyidx>=0 ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yymajor = yytos->major;
  yy_destructor( yymajor, &yytos->minor);
  pParser->yyidx--;
  return yymajor;
}

/* 
** Deallocate and destroy a parser.  Destructors are all called for
** all stack elements before shutting the parser down.
**
** Inputs:
** <ul>
** <li>  A pointer to the parser.  This should be a pointer
**       obtained from sqlite3ParserAlloc.
** <li>  A pointer to a function used to reclaim memory obtained
**       from malloc.
** </ul>
*/
void sqlite3ParserFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
  yyParser *pParser = (yyParser*)p;
  if( pParser==0 ) return;
  while( pParser->yyidx>=0 ) yy_pop_parser_stack(pParser);
  (*freeProc)((void*)pParser);
}

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_shift_action(
  yyParser *pParser,        /* The parser */
  int iLookAhead            /* The look-ahead token */
){
  int i;
  int stateno = pParser->yystack[pParser->yyidx].stateno;
 
  /* if( pParser->yyidx<0 ) return YY_NO_ACTION;  */
  i = yy_shift_ofst[stateno];
  if( i==YY_SHIFT_USE_DFLT ){
    return yy_default[stateno];
  }
  if( iLookAhead==YYNOCODE ){
    return YY_NO_ACTION;
  }
  i += iLookAhead;
  if( i<0 || i>=YY_SZ_ACTTAB || yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
    int iFallback;            /* Fallback token */
    if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
           && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
           yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
      }
#endif
      return yy_find_shift_action(pParser, iFallback);
    }
#endif
    return yy_default[stateno];
  }else{
    return yy_action[i];
  }
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_reduce_action(
  yyParser *pParser,        /* The parser */
  int iLookAhead            /* The look-ahead token */
){
  int i;
  int stateno = pParser->yystack[pParser->yyidx].stateno;
 
  i = yy_reduce_ofst[stateno];
  if( i==YY_REDUCE_USE_DFLT ){
    return yy_default[stateno];
  }
  if( iLookAhead==YYNOCODE ){
    return YY_NO_ACTION;
  }
  i += iLookAhead;
  if( i<0 || i>=YY_SZ_ACTTAB || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }else{
    return yy_action[i];
  }
}

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  int yyNewState,               /* The new state to shift in */
  int yyMajor,                  /* The major token to shift in */
  YYMINORTYPE *yypMinor         /* Pointer ot the minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yyidx++;
  if( yypParser->yyidx>=YYSTACKDEPTH ){
     sqlite3ParserARG_FETCH;
     yypParser->yyidx--;
#ifndef NDEBUG
     if( yyTraceFILE ){
       fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
     }
#endif
     while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
     /* Here code is inserted which will execute if the parser
     ** stack every overflows */
     sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument var */
     return;
  }
  yytos = &yypParser->yystack[yypParser->yyidx];
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor = *yypMinor;
#ifndef NDEBUG
  if( yyTraceFILE && yypParser->yyidx>0 ){
    int i;
    fprintf(yyTraceFILE,"%sShift %d\n",yyTracePrompt,yyNewState);
    fprintf(yyTraceFILE,"%sStack:",yyTracePrompt);
    for(i=1; i<=yypParser->yyidx; i++)
      fprintf(yyTraceFILE," %s",yyTokenName[yypParser->yystack[i].major]);
    fprintf(yyTraceFILE,"\n");
  }
#endif
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;         /* Symbol on the left-hand side of the rule */
  unsigned char nrhs;     /* Number of right-hand side symbols in the rule */
} yyRuleInfo[] = {
  { 131, 1 },
  { 132, 2 },
  { 132, 1 },
  { 133, 3 },
  { 133, 1 },
  { 135, 1 },
  { 134, 1 },
  { 134, 0 },
  { 136, 3 },
  { 138, 0 },
  { 138, 1 },
  { 138, 2 },
  { 137, 0 },
  { 137, 1 },
  { 137, 1 },
  { 137, 1 },
  { 136, 2 },
  { 136, 2 },
  { 136, 2 },
  { 136, 2 },
  { 140, 5 },
  { 142, 1 },
  { 142, 0 },
  { 141, 4 },
  { 141, 2 },
  { 144, 3 },
  { 144, 1 },
  { 147, 3 },
  { 148, 1 },
  { 151, 1 },
  { 152, 1 },
  { 152, 1 },
  { 139, 1 },
  { 139, 1 },
  { 139, 1 },
  { 149, 0 },
  { 149, 1 },
  { 149, 4 },
  { 149, 6 },
  { 153, 1 },
  { 153, 2 },
  { 154, 1 },
  { 154, 1 },
  { 150, 2 },
  { 150, 0 },
  { 157, 3 },
  { 157, 1 },
  { 157, 2 },
  { 157, 2 },
  { 157, 2 },
  { 157, 2 },
  { 158, 2 },
  { 158, 3 },
  { 158, 4 },
  { 158, 2 },
  { 158, 5 },
  { 158, 4 },
  { 158, 1 },
  { 158, 2 },
  { 163, 0 },
  { 163, 2 },
  { 165, 2 },
  { 165, 3 },
  { 165, 3 },
  { 165, 3 },
  { 166, 2 },
  { 166, 2 },
  { 166, 1 },
  { 166, 1 },
  { 164, 3 },
  { 164, 2 },
  { 167, 0 },
  { 167, 2 },
  { 167, 2 },
  { 145, 0 },
  { 145, 2 },
  { 168, 3 },
  { 168, 2 },
  { 168, 1 },
  { 169, 2 },
  { 169, 6 },
  { 169, 5 },
  { 169, 3 },
  { 169, 10 },
  { 171, 0 },
  { 171, 1 },
  { 159, 0 },
  { 159, 3 },
  { 172, 0 },
  { 172, 2 },
  { 173, 1 },
  { 173, 1 },
  { 173, 1 },
  { 136, 3 },
  { 136, 7 },
  { 136, 3 },
  { 136, 1 },
  { 146, 1 },
  { 146, 3 },
  { 177, 1 },
  { 177, 2 },
  { 177, 1 },
  { 177, 1 },
  { 176, 9 },
  { 178, 1 },
  { 178, 1 },
  { 178, 0 },
  { 186, 2 },
  { 186, 0 },
  { 179, 3 },
  { 179, 2 },
  { 179, 4 },
  { 187, 2 },
  { 187, 1 },
  { 187, 0 },
  { 180, 0 },
  { 180, 2 },
  { 189, 2 },
  { 189, 0 },
  { 188, 6 },
  { 188, 7 },
  { 193, 1 },
  { 193, 1 },
  { 143, 0 },
  { 143, 2 },
  { 175, 2 },
  { 190, 1 },
  { 190, 1 },
  { 190, 2 },
  { 190, 3 },
  { 190, 4 },
  { 191, 2 },
  { 191, 0 },
  { 192, 4 },
  { 192, 0 },
  { 184, 0 },
  { 184, 3 },
  { 196, 5 },
  { 196, 3 },
  { 197, 1 },
  { 160, 1 },
  { 160, 1 },
  { 160, 0 },
  { 198, 0 },
  { 198, 2 },
  { 182, 0 },
  { 182, 3 },
  { 183, 0 },
  { 183, 2 },
  { 185, 0 },
  { 185, 2 },
  { 185, 4 },
  { 185, 4 },
  { 136, 4 },
  { 181, 0 },
  { 181, 2 },
  { 136, 6 },
  { 200, 5 },
  { 200, 3 },
  { 136, 8 },
  { 136, 5 },
  { 201, 2 },
  { 201, 1 },
  { 203, 3 },
  { 203, 1 },
  { 202, 0 },
  { 202, 3 },
  { 195, 3 },
  { 195, 1 },
  { 161, 3 },
  { 161, 1 },
  { 161, 1 },
  { 161, 1 },
  { 161, 3 },
  { 161, 5 },
  { 161, 1 },
  { 161, 1 },
  { 161, 1 },
  { 161, 1 },
  { 161, 1 },
  { 161, 4 },
  { 161, 4 },
  { 161, 3 },
  { 161, 3 },
  { 161, 3 },
  { 161, 3 },
  { 161, 3 },
  { 161, 3 },
  { 161, 3 },
  { 161, 3 },
  { 161, 3 },
  { 161, 3 },
  { 161, 3 },
  { 161, 3 },
  { 161, 3 },
  { 161, 3 },
  { 161, 3 },
  { 161, 3 },
  { 161, 3 },
  { 161, 3 },
  { 204, 1 },
  { 204, 1 },
  { 204, 2 },
  { 204, 2 },
  { 161, 3 },
  { 161, 2 },
  { 161, 3 },
  { 161, 2 },
  { 161, 3 },
  { 161, 4 },
  { 161, 2 },
  { 161, 2 },
  { 161, 2 },
  { 161, 2 },
  { 161, 3 },
  { 205, 1 },
  { 205, 2 },
  { 161, 5 },
  { 206, 1 },
  { 206, 2 },
  { 161, 5 },
  { 161, 5 },
  { 161, 4 },
  { 161, 5 },
  { 208, 5 },
  { 208, 4 },
  { 209, 2 },
  { 209, 0 },
  { 207, 1 },
  { 207, 0 },
  { 199, 3 },
  { 199, 1 },
  { 210, 1 },
  { 210, 0 },
  { 136, 11 },
  { 211, 1 },
  { 211, 0 },
  { 162, 0 },
  { 162, 3 },
  { 170, 5 },
  { 170, 3 },
  { 212, 1 },
  { 136, 3 },
  { 136, 1 },
  { 136, 2 },
  { 136, 5 },
  { 136, 5 },
  { 136, 5 },
  { 136, 5 },
  { 136, 6 },
  { 136, 3 },
  { 155, 2 },
  { 156, 2 },
  { 214, 1 },
  { 214, 1 },
  { 213, 1 },
  { 213, 0 },
  { 136, 5 },
  { 215, 10 },
  { 217, 1 },
  { 217, 1 },
  { 217, 2 },
  { 217, 0 },
  { 218, 1 },
  { 218, 1 },
  { 218, 1 },
  { 218, 3 },
  { 219, 0 },
  { 219, 3 },
  { 219, 3 },
  { 220, 0 },
  { 220, 2 },
  { 216, 3 },
  { 216, 0 },
  { 221, 6 },
  { 221, 8 },
  { 221, 5 },
  { 221, 4 },
  { 221, 1 },
  { 161, 4 },
  { 161, 6 },
  { 174, 1 },
  { 174, 1 },
  { 174, 1 },
  { 136, 3 },
  { 136, 6 },
  { 223, 0 },
  { 223, 2 },
  { 223, 2 },
  { 222, 1 },
  { 222, 0 },
  { 136, 3 },
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
*/
static void yy_reduce(
  yyParser *yypParser,         /* The parser */
  int yyruleno                 /* Number of the rule by which to reduce */
){
  int yygoto;                     /* The next state */
  int yyact;                      /* The next action */
  YYMINORTYPE yygotominor;        /* The LHS of the rule reduced */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  sqlite3ParserARG_FETCH;
  yymsp = &yypParser->yystack[yypParser->yyidx];
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno>=0 
        && yyruleno<sizeof(yyRuleName)/sizeof(yyRuleName[0]) ){
    fprintf(yyTraceFILE, "%sReduce [%s].\n", yyTracePrompt,
      yyRuleName[yyruleno]);
  }
#endif /* NDEBUG */

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
      case 5:
#line 86 "parse.y"
{ sqlite3FinishCoding(pParse); }
#line 1796 "parse.c"
        break;
      case 6:
#line 87 "parse.y"
{ sqlite3BeginParse(pParse, 1); }
#line 1801 "parse.c"
        break;
      case 7:
#line 88 "parse.y"
{ sqlite3BeginParse(pParse, 0); }
#line 1806 "parse.c"
        break;
      case 8:
#line 93 "parse.y"
{sqlite3BeginTransaction(pParse, yymsp[-1].minor.yy284);}
#line 1811 "parse.c"
        break;
      case 12:
#line 98 "parse.y"
{yygotominor.yy284 = TK_DEFERRED;}
#line 1816 "parse.c"
        break;
      case 13:
      case 14:
      case 15:
      case 99:
      case 101:
      case 102:
#line 99 "parse.y"
{yygotominor.yy284 = yymsp[0].major;}
#line 1826 "parse.c"
        break;
      case 16:
      case 17:
#line 102 "parse.y"
{sqlite3CommitTransaction(pParse);}
#line 1832 "parse.c"
        break;
      case 18:
#line 104 "parse.y"
{sqlite3RollbackTransaction(pParse);}
#line 1837 "parse.c"
        break;
      case 20:
#line 109 "parse.y"
{
   sqlite3StartTable(pParse,&yymsp[-4].minor.yy0,&yymsp[-1].minor.yy98,&yymsp[0].minor.yy98,yymsp[-3].minor.yy284,0);
}
#line 1844 "parse.c"
        break;
      case 21:
      case 72:
      case 104:
      case 216:
      case 219:
#line 113 "parse.y"
{yygotominor.yy284 = 1;}
#line 1853 "parse.c"
        break;
      case 22:
      case 71:
      case 73:
      case 84:
      case 105:
      case 106:
      case 215:
      case 218:
#line 114 "parse.y"
{yygotominor.yy284 = 0;}
#line 1865 "parse.c"
        break;
      case 23:
#line 115 "parse.y"
{
  sqlite3EndTable(pParse,&yymsp[0].minor.yy0,0);
}
#line 1872 "parse.c"
        break;
      case 24:
#line 118 "parse.y"
{
  sqlite3EndTable(pParse,0,yymsp[0].minor.yy107);
  sqlite3SelectDelete(yymsp[0].minor.yy107);
}
#line 1880 "parse.c"
        break;
      case 28:
#line 130 "parse.y"
{sqlite3AddColumn(pParse,&yymsp[0].minor.yy98);}
#line 1885 "parse.c"
        break;
      case 29:
      case 30:
      case 31:
      case 32:
      case 33:
      case 34:
      case 253:
      case 254:
#line 136 "parse.y"
{yygotominor.yy98 = yymsp[0].minor.yy0;}
#line 1897 "parse.c"
        break;
      case 36:
#line 185 "parse.y"
{sqlite3AddColumnType(pParse,&yymsp[0].minor.yy98,&yymsp[0].minor.yy98);}
#line 1902 "parse.c"
        break;
      case 37:
#line 186 "parse.y"
{sqlite3AddColumnType(pParse,&yymsp[-3].minor.yy98,&yymsp[0].minor.yy0);}
#line 1907 "parse.c"
        break;
      case 38:
#line 188 "parse.y"
{sqlite3AddColumnType(pParse,&yymsp[-5].minor.yy98,&yymsp[0].minor.yy0);}
#line 1912 "parse.c"
        break;
      case 39:
      case 112:
      case 113:
      case 124:
      case 144:
      case 241:
      case 251:
      case 252:
#line 190 "parse.y"
{yygotominor.yy98 = yymsp[0].minor.yy98;}
#line 1924 "parse.c"
        break;
      case 40:
#line 191 "parse.y"
{yygotominor.yy98.z=yymsp[-1].minor.yy98.z; yygotominor.yy98.n=yymsp[0].minor.yy98.n+(yymsp[0].minor.yy98.z-yymsp[-1].minor.yy98.z);}
#line 1929 "parse.c"
        break;
      case 41:
#line 193 "parse.y"
{ yygotominor.yy284 = atoi(yymsp[0].minor.yy98.z); }
#line 1934 "parse.c"
        break;
      case 42:
#line 194 "parse.y"
{ yygotominor.yy284 = -atoi(yymsp[0].minor.yy98.z); }
#line 1939 "parse.c"
        break;
      case 47:
      case 48:
#line 199 "parse.y"
{sqlite3AddDefaultValue(pParse,&yymsp[0].minor.yy98,0);}
#line 1945 "parse.c"
        break;
      case 49:
#line 201 "parse.y"
{sqlite3AddDefaultValue(pParse,&yymsp[0].minor.yy98,1);}
#line 1950 "parse.c"
        break;
      case 52:
#line 208 "parse.y"
{sqlite3AddNotNull(pParse, yymsp[0].minor.yy284);}
#line 1955 "parse.c"
        break;
      case 53:
#line 209 "parse.y"
{sqlite3AddPrimaryKey(pParse,0,yymsp[0].minor.yy284);}
#line 1960 "parse.c"
        break;
      case 54:
#line 210 "parse.y"
{sqlite3CreateIndex(pParse,0,0,0,0,yymsp[0].minor.yy284,0,0);}
#line 1965 "parse.c"
        break;
      case 56:
#line 213 "parse.y"
{sqlite3CreateForeignKey(pParse,0,&yymsp[-2].minor.yy98,yymsp[-1].minor.yy210,yymsp[0].minor.yy284);}
#line 1970 "parse.c"
        break;
      case 57:
#line 214 "parse.y"
{sqlite3DeferForeignKey(pParse,yymsp[0].minor.yy284);}
#line 1975 "parse.c"
        break;
      case 58:
#line 215 "parse.y"
{sqlite3AddCollateType(pParse, yymsp[0].minor.yy98.z, yymsp[0].minor.yy98.n);}
#line 1980 "parse.c"
        break;
      case 59:
#line 223 "parse.y"
{ yygotominor.yy284 = OE_Restrict * 0x010101; }
#line 1985 "parse.c"
        break;
      case 60:
#line 224 "parse.y"
{ yygotominor.yy284 = (yymsp[-1].minor.yy284 & yymsp[0].minor.yy47.mask) | yymsp[0].minor.yy47.value; }
#line 1990 "parse.c"
        break;
      case 61:
#line 226 "parse.y"
{ yygotominor.yy47.value = 0;     yygotominor.yy47.mask = 0x000000; }
#line 1995 "parse.c"
        break;
      case 62:
#line 227 "parse.y"
{ yygotominor.yy47.value = yymsp[0].minor.yy284;     yygotominor.yy47.mask = 0x0000ff; }
#line 2000 "parse.c"
        break;
      case 63:
#line 228 "parse.y"
{ yygotominor.yy47.value = yymsp[0].minor.yy284<<8;  yygotominor.yy47.mask = 0x00ff00; }
#line 2005 "parse.c"
        break;
      case 64:
#line 229 "parse.y"
{ yygotominor.yy47.value = yymsp[0].minor.yy284<<16; yygotominor.yy47.mask = 0xff0000; }
#line 2010 "parse.c"
        break;
      case 65:
#line 231 "parse.y"
{ yygotominor.yy284 = OE_SetNull; }
#line 2015 "parse.c"
        break;
      case 66:
#line 232 "parse.y"
{ yygotominor.yy284 = OE_SetDflt; }
#line 2020 "parse.c"
        break;
      case 67:
#line 233 "parse.y"
{ yygotominor.yy284 = OE_Cascade; }
#line 2025 "parse.c"
        break;
      case 68:
#line 234 "parse.y"
{ yygotominor.yy284 = OE_Restrict; }
#line 2030 "parse.c"
        break;
      case 69:
      case 70:
      case 85:
      case 87:
      case 89:
      case 90:
      case 161:
#line 236 "parse.y"
{yygotominor.yy284 = yymsp[0].minor.yy284;}
#line 2041 "parse.c"
        break;
      case 80:
#line 253 "parse.y"
{sqlite3AddPrimaryKey(pParse,yymsp[-2].minor.yy210,yymsp[0].minor.yy284);}
#line 2046 "parse.c"
        break;
      case 81:
#line 255 "parse.y"
{sqlite3CreateIndex(pParse,0,0,0,yymsp[-2].minor.yy210,yymsp[0].minor.yy284,0,0);}
#line 2051 "parse.c"
        break;
      case 83:
#line 258 "parse.y"
{
    sqlite3CreateForeignKey(pParse, yymsp[-6].minor.yy210, &yymsp[-3].minor.yy98, yymsp[-2].minor.yy210, yymsp[-1].minor.yy284);
    sqlite3DeferForeignKey(pParse, yymsp[0].minor.yy284);
}
#line 2059 "parse.c"
        break;
      case 86:
      case 88:
#line 272 "parse.y"
{yygotominor.yy284 = OE_Default;}
#line 2065 "parse.c"
        break;
      case 91:
#line 277 "parse.y"
{yygotominor.yy284 = OE_Ignore;}
#line 2070 "parse.c"
        break;
      case 92:
      case 162:
#line 278 "parse.y"
{yygotominor.yy284 = OE_Replace;}
#line 2076 "parse.c"
        break;
      case 93:
#line 282 "parse.y"
{
  sqlite3DropTable(pParse, yymsp[0].minor.yy259, 0);
}
#line 2083 "parse.c"
        break;
      case 94:
#line 288 "parse.y"
{
  sqlite3CreateView(pParse, &yymsp[-6].minor.yy0, &yymsp[-3].minor.yy98, &yymsp[-2].minor.yy98, yymsp[0].minor.yy107, yymsp[-5].minor.yy284);
}
#line 2090 "parse.c"
        break;
      case 95:
#line 291 "parse.y"
{
  sqlite3DropTable(pParse, yymsp[0].minor.yy259, 1);
}
#line 2097 "parse.c"
        break;
      case 96:
#line 297 "parse.y"
{
  sqlite3Select(pParse, yymsp[0].minor.yy107, SRT_Callback, 0, 0, 0, 0, 0);
  sqlite3SelectDelete(yymsp[0].minor.yy107);
}
#line 2105 "parse.c"
        break;
      case 97:
      case 121:
#line 307 "parse.y"
{yygotominor.yy107 = yymsp[0].minor.yy107;}
#line 2111 "parse.c"
        break;
      case 98:
#line 308 "parse.y"
{
  if( yymsp[0].minor.yy107 ){
    yymsp[0].minor.yy107->op = yymsp[-1].minor.yy284;
    yymsp[0].minor.yy107->pPrior = yymsp[-2].minor.yy107;
  }
  yygotominor.yy107 = yymsp[0].minor.yy107;
}
#line 2122 "parse.c"
        break;
      case 100:
#line 317 "parse.y"
{yygotominor.yy284 = TK_ALL;}
#line 2127 "parse.c"
        break;
      case 103:
#line 321 "parse.y"
{
  yygotominor.yy107 = sqlite3SelectNew(yymsp[-6].minor.yy210,yymsp[-5].minor.yy259,yymsp[-4].minor.yy258,yymsp[-3].minor.yy210,yymsp[-2].minor.yy258,yymsp[-1].minor.yy210,yymsp[-7].minor.yy284,yymsp[0].minor.yy404.limit,yymsp[0].minor.yy404.offset);
}
#line 2134 "parse.c"
        break;
      case 107:
      case 238:
#line 342 "parse.y"
{yygotominor.yy210 = yymsp[-1].minor.yy210;}
#line 2140 "parse.c"
        break;
      case 108:
      case 135:
      case 145:
      case 237:
#line 343 "parse.y"
{yygotominor.yy210 = 0;}
#line 2148 "parse.c"
        break;
      case 109:
#line 344 "parse.y"
{
   yygotominor.yy210 = sqlite3ExprListAppend(yymsp[-2].minor.yy210,yymsp[-1].minor.yy258,yymsp[0].minor.yy98.n?&yymsp[0].minor.yy98:0);
}
#line 2155 "parse.c"
        break;
      case 110:
#line 347 "parse.y"
{
  yygotominor.yy210 = sqlite3ExprListAppend(yymsp[-1].minor.yy210, sqlite3Expr(TK_ALL, 0, 0, 0), 0);
}
#line 2162 "parse.c"
        break;
      case 111:
#line 350 "parse.y"
{
  Expr *pRight = sqlite3Expr(TK_ALL, 0, 0, 0);
  Expr *pLeft = sqlite3Expr(TK_ID, 0, 0, &yymsp[-2].minor.yy98);
  yygotominor.yy210 = sqlite3ExprListAppend(yymsp[-3].minor.yy210, sqlite3Expr(TK_DOT, pLeft, pRight, 0), 0);
}
#line 2171 "parse.c"
        break;
      case 114:
#line 362 "parse.y"
{yygotominor.yy98.n = 0;}
#line 2176 "parse.c"
        break;
      case 115:
#line 374 "parse.y"
{yygotominor.yy259 = sqliteMalloc(sizeof(*yygotominor.yy259));}
#line 2181 "parse.c"
        break;
      case 116:
#line 375 "parse.y"
{yygotominor.yy259 = yymsp[0].minor.yy259;}
#line 2186 "parse.c"
        break;
      case 117:
#line 380 "parse.y"
{
   yygotominor.yy259 = yymsp[-1].minor.yy259;
   if( yygotominor.yy259 && yygotominor.yy259->nSrc>0 ) yygotominor.yy259->a[yygotominor.yy259->nSrc-1].jointype = yymsp[0].minor.yy284;
}
#line 2194 "parse.c"
        break;
      case 118:
#line 384 "parse.y"
{yygotominor.yy259 = 0;}
#line 2199 "parse.c"
        break;
      case 119:
#line 385 "parse.y"
{
  yygotominor.yy259 = sqlite3SrcListAppend(yymsp[-5].minor.yy259,&yymsp[-4].minor.yy98,&yymsp[-3].minor.yy98);
  if( yymsp[-2].minor.yy98.n ) sqlite3SrcListAddAlias(yygotominor.yy259,&yymsp[-2].minor.yy98);
  if( yymsp[-1].minor.yy258 ){
    if( yygotominor.yy259 && yygotominor.yy259->nSrc>1 ){ yygotominor.yy259->a[yygotominor.yy259->nSrc-2].pOn = yymsp[-1].minor.yy258; }
    else { sqlite3ExprDelete(yymsp[-1].minor.yy258); }
  }
  if( yymsp[0].minor.yy272 ){
    if( yygotominor.yy259 && yygotominor.yy259->nSrc>1 ){ yygotominor.yy259->a[yygotominor.yy259->nSrc-2].pUsing = yymsp[0].minor.yy272; }
    else { sqlite3IdListDelete(yymsp[0].minor.yy272); }
  }
}
#line 2215 "parse.c"
        break;
      case 120:
#line 398 "parse.y"
{
  yygotominor.yy259 = sqlite3SrcListAppend(yymsp[-6].minor.yy259,0,0);
  yygotominor.yy259->a[yygotominor.yy259->nSrc-1].pSelect = yymsp[-4].minor.yy107;
  if( yymsp[-2].minor.yy98.n ) sqlite3SrcListAddAlias(yygotominor.yy259,&yymsp[-2].minor.yy98);
  if( yymsp[-1].minor.yy258 ){
    if( yygotominor.yy259 && yygotominor.yy259->nSrc>1 ){ yygotominor.yy259->a[yygotominor.yy259->nSrc-2].pOn = yymsp[-1].minor.yy258; }
    else { sqlite3ExprDelete(yymsp[-1].minor.yy258); }
  }
  if( yymsp[0].minor.yy272 ){
    if( yygotominor.yy259 && yygotominor.yy259->nSrc>1 ){ yygotominor.yy259->a[yygotominor.yy259->nSrc-2].pUsing = yymsp[0].minor.yy272; }
    else { sqlite3IdListDelete(yymsp[0].minor.yy272); }
  }
}
#line 2232 "parse.c"
        break;
      case 122:
#line 419 "parse.y"
{
   yygotominor.yy107 = sqlite3SelectNew(0,yymsp[0].minor.yy259,0,0,0,0,0,-1,0);
}
#line 2239 "parse.c"
        break;
      case 123:
#line 424 "parse.y"
{yygotominor.yy98.z=0; yygotominor.yy98.n=0;}
#line 2244 "parse.c"
        break;
      case 125:
#line 429 "parse.y"
{yygotominor.yy259 = sqlite3SrcListAppend(0,&yymsp[-1].minor.yy98,&yymsp[0].minor.yy98);}
#line 2249 "parse.c"
        break;
      case 126:
      case 127:
#line 433 "parse.y"
{ yygotominor.yy284 = JT_INNER; }
#line 2255 "parse.c"
        break;
      case 128:
#line 435 "parse.y"
{ yygotominor.yy284 = sqlite3JoinType(pParse,&yymsp[-1].minor.yy0,0,0); }
#line 2260 "parse.c"
        break;
      case 129:
#line 436 "parse.y"
{ yygotominor.yy284 = sqlite3JoinType(pParse,&yymsp[-2].minor.yy0,&yymsp[-1].minor.yy98,0); }
#line 2265 "parse.c"
        break;
      case 130:
#line 438 "parse.y"
{ yygotominor.yy284 = sqlite3JoinType(pParse,&yymsp[-3].minor.yy0,&yymsp[-2].minor.yy98,&yymsp[-1].minor.yy98); }
#line 2270 "parse.c"
        break;
      case 131:
      case 139:
      case 148:
      case 155:
      case 226:
      case 228:
      case 232:
#line 442 "parse.y"
{yygotominor.yy258 = yymsp[0].minor.yy258;}
#line 2281 "parse.c"
        break;
      case 132:
      case 147:
      case 154:
      case 227:
      case 229:
      case 233:
#line 443 "parse.y"
{yygotominor.yy258 = 0;}
#line 2291 "parse.c"
        break;
      case 133:
      case 166:
#line 447 "parse.y"
{yygotominor.yy272 = yymsp[-1].minor.yy272;}
#line 2297 "parse.c"
        break;
      case 134:
      case 165:
#line 448 "parse.y"
{yygotominor.yy272 = 0;}
#line 2303 "parse.c"
        break;
      case 136:
      case 146:
#line 459 "parse.y"
{yygotominor.yy210 = yymsp[0].minor.yy210;}
#line 2309 "parse.c"
        break;
      case 137:
#line 460 "parse.y"
{
  yygotominor.yy210 = sqlite3ExprListAppend(yymsp[-4].minor.yy210,yymsp[-2].minor.yy258,yymsp[-1].minor.yy98.n>0?&yymsp[-1].minor.yy98:0);
  if( yygotominor.yy210 ) yygotominor.yy210->a[yygotominor.yy210->nExpr-1].sortOrder = yymsp[0].minor.yy284;
}
#line 2317 "parse.c"
        break;
      case 138:
#line 464 "parse.y"
{
  yygotominor.yy210 = sqlite3ExprListAppend(0,yymsp[-2].minor.yy258,yymsp[-1].minor.yy98.n>0?&yymsp[-1].minor.yy98:0);
  if( yygotominor.yy210 && yygotominor.yy210->a ) yygotominor.yy210->a[0].sortOrder = yymsp[0].minor.yy284;
}
#line 2325 "parse.c"
        break;
      case 140:
      case 142:
#line 473 "parse.y"
{yygotominor.yy284 = SQLITE_SO_ASC;}
#line 2331 "parse.c"
        break;
      case 141:
#line 474 "parse.y"
{yygotominor.yy284 = SQLITE_SO_DESC;}
#line 2336 "parse.c"
        break;
      case 143:
#line 476 "parse.y"
{yygotominor.yy98.z = 0; yygotominor.yy98.n = 0;}
#line 2341 "parse.c"
        break;
      case 149:
#line 490 "parse.y"
{yygotominor.yy404.limit = -1; yygotominor.yy404.offset = 0;}
#line 2346 "parse.c"
        break;
      case 150:
#line 491 "parse.y"
{yygotominor.yy404.limit = yymsp[0].minor.yy284; yygotominor.yy404.offset = 0;}
#line 2351 "parse.c"
        break;
      case 151:
#line 493 "parse.y"
{yygotominor.yy404.limit = yymsp[-2].minor.yy284; yygotominor.yy404.offset = yymsp[0].minor.yy284;}
#line 2356 "parse.c"
        break;
      case 152:
#line 495 "parse.y"
{yygotominor.yy404.limit = yymsp[0].minor.yy284; yygotominor.yy404.offset = yymsp[-2].minor.yy284;}
#line 2361 "parse.c"
        break;
      case 153:
#line 499 "parse.y"
{sqlite3DeleteFrom(pParse,yymsp[-1].minor.yy259,yymsp[0].minor.yy258);}
#line 2366 "parse.c"
        break;
      case 156:
#line 513 "parse.y"
{sqlite3Update(pParse,yymsp[-3].minor.yy259,yymsp[-1].minor.yy210,yymsp[0].minor.yy258,yymsp[-4].minor.yy284);}
#line 2371 "parse.c"
        break;
      case 157:
#line 516 "parse.y"
{yygotominor.yy210 = sqlite3ExprListAppend(yymsp[-4].minor.yy210,yymsp[0].minor.yy258,&yymsp[-2].minor.yy98);}
#line 2376 "parse.c"
        break;
      case 158:
#line 517 "parse.y"
{yygotominor.yy210 = sqlite3ExprListAppend(0,yymsp[0].minor.yy258,&yymsp[-2].minor.yy98);}
#line 2381 "parse.c"
        break;
      case 159:
#line 523 "parse.y"
{sqlite3Insert(pParse, yymsp[-5].minor.yy259, yymsp[-1].minor.yy210, 0, yymsp[-4].minor.yy272, yymsp[-7].minor.yy284);}
#line 2386 "parse.c"
        break;
      case 160:
#line 525 "parse.y"
{sqlite3Insert(pParse, yymsp[-2].minor.yy259, 0, yymsp[0].minor.yy107, yymsp[-1].minor.yy272, yymsp[-4].minor.yy284);}
#line 2391 "parse.c"
        break;
      case 163:
      case 230:
#line 535 "parse.y"
{yygotominor.yy210 = sqlite3ExprListAppend(yymsp[-2].minor.yy210,yymsp[0].minor.yy258,0);}
#line 2397 "parse.c"
        break;
      case 164:
      case 231:
#line 536 "parse.y"
{yygotominor.yy210 = sqlite3ExprListAppend(0,yymsp[0].minor.yy258,0);}
#line 2403 "parse.c"
        break;
      case 167:
#line 545 "parse.y"
{yygotominor.yy272 = sqlite3IdListAppend(yymsp[-2].minor.yy272,&yymsp[0].minor.yy98);}
#line 2408 "parse.c"
        break;
      case 168:
#line 546 "parse.y"
{yygotominor.yy272 = sqlite3IdListAppend(0,&yymsp[0].minor.yy98);}
#line 2413 "parse.c"
        break;
      case 169:
#line 554 "parse.y"
{yygotominor.yy258 = yymsp[-1].minor.yy258; sqlite3ExprSpan(yygotominor.yy258,&yymsp[-2].minor.yy0,&yymsp[0].minor.yy0); }
#line 2418 "parse.c"
        break;
      case 170:
      case 175:
      case 176:
      case 177:
      case 178:
#line 555 "parse.y"
{yygotominor.yy258 = sqlite3Expr(yymsp[0].major, 0, 0, &yymsp[0].minor.yy0);}
#line 2427 "parse.c"
        break;
      case 171:
      case 172:
#line 556 "parse.y"
{yygotominor.yy258 = sqlite3Expr(TK_ID, 0, 0, &yymsp[0].minor.yy0);}
#line 2433 "parse.c"
        break;
      case 173:
#line 558 "parse.y"
{
  Expr *temp1 = sqlite3Expr(TK_ID, 0, 0, &yymsp[-2].minor.yy98);
  Expr *temp2 = sqlite3Expr(TK_ID, 0, 0, &yymsp[0].minor.yy98);
  yygotominor.yy258 = sqlite3Expr(TK_DOT, temp1, temp2, 0);
}
#line 2442 "parse.c"
        break;
      case 174:
#line 563 "parse.y"
{
  Expr *temp1 = sqlite3Expr(TK_ID, 0, 0, &yymsp[-4].minor.yy98);
  Expr *temp2 = sqlite3Expr(TK_ID, 0, 0, &yymsp[-2].minor.yy98);
  Expr *temp3 = sqlite3Expr(TK_ID, 0, 0, &yymsp[0].minor.yy98);
  Expr *temp4 = sqlite3Expr(TK_DOT, temp2, temp3, 0);
  yygotominor.yy258 = sqlite3Expr(TK_DOT, temp1, temp4, 0);
}
#line 2453 "parse.c"
        break;
      case 179:
#line 574 "parse.y"
{
  Token *pToken = &yymsp[0].minor.yy0;
  Expr *pExpr = yygotominor.yy258 = sqlite3Expr(TK_VARIABLE, 0, 0, pToken);
  sqlite3ExprAssignVarNumber(pParse, pExpr);
}
#line 2462 "parse.c"
        break;
      case 180:
#line 579 "parse.y"
{
  yygotominor.yy258 = sqlite3ExprFunction(yymsp[-1].minor.yy210, &yymsp[-3].minor.yy0);
  sqlite3ExprSpan(yygotominor.yy258,&yymsp[-3].minor.yy0,&yymsp[0].minor.yy0);
}
#line 2470 "parse.c"
        break;
      case 181:
#line 583 "parse.y"
{
  yygotominor.yy258 = sqlite3ExprFunction(0, &yymsp[-3].minor.yy0);
  sqlite3ExprSpan(yygotominor.yy258,&yymsp[-3].minor.yy0,&yymsp[0].minor.yy0);
}
#line 2478 "parse.c"
        break;
      case 182:
      case 183:
      case 184:
      case 185:
      case 186:
      case 187:
      case 188:
      case 189:
      case 190:
      case 191:
      case 192:
      case 193:
      case 194:
      case 195:
      case 196:
      case 197:
      case 198:
      case 199:
#line 587 "parse.y"
{yygotominor.yy258 = sqlite3Expr(yymsp[-1].major, yymsp[-2].minor.yy258, yymsp[0].minor.yy258, 0);}
#line 2500 "parse.c"
        break;
      case 200:
#line 606 "parse.y"
{yygotominor.yy342.opcode = TK_LIKE; yygotominor.yy342.not = 0;}
#line 2505 "parse.c"
        break;
      case 201:
#line 607 "parse.y"
{yygotominor.yy342.opcode = TK_GLOB; yygotominor.yy342.not = 0;}
#line 2510 "parse.c"
        break;
      case 202:
#line 608 "parse.y"
{yygotominor.yy342.opcode = TK_LIKE; yygotominor.yy342.not = 1;}
#line 2515 "parse.c"
        break;
      case 203:
#line 609 "parse.y"
{yygotominor.yy342.opcode = TK_GLOB; yygotominor.yy342.not = 1;}
#line 2520 "parse.c"
        break;
      case 204:
#line 610 "parse.y"
{
  ExprList *pList = sqlite3ExprListAppend(0, yymsp[0].minor.yy258, 0);
  pList = sqlite3ExprListAppend(pList, yymsp[-2].minor.yy258, 0);
  yygotominor.yy258 = sqlite3ExprFunction(pList, 0);
  if( yygotominor.yy258 ) yygotominor.yy258->op = yymsp[-1].minor.yy342.opcode;
  if( yymsp[-1].minor.yy342.not ) yygotominor.yy258 = sqlite3Expr(TK_NOT, yygotominor.yy258, 0, 0);
  sqlite3ExprSpan(yygotominor.yy258, &yymsp[-2].minor.yy258->span, &yymsp[0].minor.yy258->span);
}
#line 2532 "parse.c"
        break;
      case 205:
#line 618 "parse.y"
{
  yygotominor.yy258 = sqlite3Expr(TK_ISNULL, yymsp[-1].minor.yy258, 0, 0);
  sqlite3ExprSpan(yygotominor.yy258,&yymsp[-1].minor.yy258->span,&yymsp[0].minor.yy0);
}
#line 2540 "parse.c"
        break;
      case 206:
#line 622 "parse.y"
{
  yygotominor.yy258 = sqlite3Expr(TK_ISNULL, yymsp[-2].minor.yy258, 0, 0);
  sqlite3ExprSpan(yygotominor.yy258,&yymsp[-2].minor.yy258->span,&yymsp[0].minor.yy0);
}
#line 2548 "parse.c"
        break;
      case 207:
#line 626 "parse.y"
{
  yygotominor.yy258 = sqlite3Expr(TK_NOTNULL, yymsp[-1].minor.yy258, 0, 0);
  sqlite3ExprSpan(yygotominor.yy258,&yymsp[-1].minor.yy258->span,&yymsp[0].minor.yy0);
}
#line 2556 "parse.c"
        break;
      case 208:
#line 630 "parse.y"
{
  yygotominor.yy258 = sqlite3Expr(TK_NOTNULL, yymsp[-2].minor.yy258, 0, 0);
  sqlite3ExprSpan(yygotominor.yy258,&yymsp[-2].minor.yy258->span,&yymsp[0].minor.yy0);
}
#line 2564 "parse.c"
        break;
      case 209:
#line 634 "parse.y"
{
  yygotominor.yy258 = sqlite3Expr(TK_NOTNULL, yymsp[-3].minor.yy258, 0, 0);
  sqlite3ExprSpan(yygotominor.yy258,&yymsp[-3].minor.yy258->span,&yymsp[0].minor.yy0);
}
#line 2572 "parse.c"
        break;
      case 210:
      case 211:
#line 638 "parse.y"
{
  yygotominor.yy258 = sqlite3Expr(yymsp[-1].major, yymsp[0].minor.yy258, 0, 0);
  sqlite3ExprSpan(yygotominor.yy258,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy258->span);
}
#line 2581 "parse.c"
        break;
      case 212:
#line 646 "parse.y"
{
  yygotominor.yy258 = sqlite3Expr(TK_UMINUS, yymsp[0].minor.yy258, 0, 0);
  sqlite3ExprSpan(yygotominor.yy258,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy258->span);
}
#line 2589 "parse.c"
        break;
      case 213:
#line 650 "parse.y"
{
  yygotominor.yy258 = sqlite3Expr(TK_UPLUS, yymsp[0].minor.yy258, 0, 0);
  sqlite3ExprSpan(yygotominor.yy258,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy258->span);
}
#line 2597 "parse.c"
        break;
      case 214:
#line 654 "parse.y"
{
  yygotominor.yy258 = sqlite3Expr(TK_SELECT, 0, 0, 0);
  if( yygotominor.yy258 ) yygotominor.yy258->pSelect = yymsp[-1].minor.yy107;
  sqlite3ExprSpan(yygotominor.yy258,&yymsp[-2].minor.yy0,&yymsp[0].minor.yy0);
}
#line 2606 "parse.c"
        break;
      case 217:
#line 662 "parse.y"
{
  ExprList *pList = sqlite3ExprListAppend(0, yymsp[-2].minor.yy258, 0);
  pList = sqlite3ExprListAppend(pList, yymsp[0].minor.yy258, 0);
  yygotominor.yy258 = sqlite3Expr(TK_BETWEEN, yymsp[-4].minor.yy258, 0, 0);
  if( yygotominor.yy258 ) yygotominor.yy258->pList = pList;
  if( yymsp[-3].minor.yy284 ) yygotominor.yy258 = sqlite3Expr(TK_NOT, yygotominor.yy258, 0, 0);
  sqlite3ExprSpan(yygotominor.yy258,&yymsp[-4].minor.yy258->span,&yymsp[0].minor.yy258->span);
}
#line 2618 "parse.c"
        break;
      case 220:
#line 673 "parse.y"
{
  yygotominor.yy258 = sqlite3Expr(TK_IN, yymsp[-4].minor.yy258, 0, 0);
  if( yygotominor.yy258 ) yygotominor.yy258->pList = yymsp[-1].minor.yy210;
  if( yymsp[-3].minor.yy284 ) yygotominor.yy258 = sqlite3Expr(TK_NOT, yygotominor.yy258, 0, 0);
  sqlite3ExprSpan(yygotominor.yy258,&yymsp[-4].minor.yy258->span,&yymsp[0].minor.yy0);
}
#line 2628 "parse.c"
        break;
      case 221:
#line 679 "parse.y"
{
  yygotominor.yy258 = sqlite3Expr(TK_IN, yymsp[-4].minor.yy258, 0, 0);
  if( yygotominor.yy258 ) yygotominor.yy258->pSelect = yymsp[-1].minor.yy107;
  if( yymsp[-3].minor.yy284 ) yygotominor.yy258 = sqlite3Expr(TK_NOT, yygotominor.yy258, 0, 0);
  sqlite3ExprSpan(yygotominor.yy258,&yymsp[-4].minor.yy258->span,&yymsp[0].minor.yy0);
}
#line 2638 "parse.c"
        break;
      case 222:
#line 685 "parse.y"
{
  SrcList *pSrc = sqlite3SrcListAppend(0,&yymsp[-1].minor.yy98,&yymsp[0].minor.yy98);
  yygotominor.yy258 = sqlite3Expr(TK_IN, yymsp[-3].minor.yy258, 0, 0);
  if( yygotominor.yy258 ) yygotominor.yy258->pSelect = sqlite3SelectNew(0,pSrc,0,0,0,0,0,-1,0);
  if( yymsp[-2].minor.yy284 ) yygotominor.yy258 = sqlite3Expr(TK_NOT, yygotominor.yy258, 0, 0);
  sqlite3ExprSpan(yygotominor.yy258,&yymsp[-3].minor.yy258->span,yymsp[0].minor.yy98.z?&yymsp[0].minor.yy98:&yymsp[-1].minor.yy98);
}
#line 2649 "parse.c"
        break;
      case 223:
#line 695 "parse.y"
{
  yygotominor.yy258 = sqlite3Expr(TK_CASE, yymsp[-3].minor.yy258, yymsp[-1].minor.yy258, 0);
  if( yygotominor.yy258 ) yygotominor.yy258->pList = yymsp[-2].minor.yy210;
  sqlite3ExprSpan(yygotominor.yy258, &yymsp[-4].minor.yy0, &yymsp[0].minor.yy0);
}
#line 2658 "parse.c"
        break;
      case 224:
#line 702 "parse.y"
{
  yygotominor.yy210 = sqlite3ExprListAppend(yymsp[-4].minor.yy210, yymsp[-2].minor.yy258, 0);
  yygotominor.yy210 = sqlite3ExprListAppend(yygotominor.yy210, yymsp[0].minor.yy258, 0);
}
#line 2666 "parse.c"
        break;
      case 225:
#line 706 "parse.y"
{
  yygotominor.yy210 = sqlite3ExprListAppend(0, yymsp[-2].minor.yy258, 0);
  yygotominor.yy210 = sqlite3ExprListAppend(yygotominor.yy210, yymsp[0].minor.yy258, 0);
}
#line 2674 "parse.c"
        break;
      case 234:
#line 731 "parse.y"
{
  if( yymsp[-9].minor.yy284!=OE_None ) yymsp[-9].minor.yy284 = yymsp[0].minor.yy284;
  if( yymsp[-9].minor.yy284==OE_Default) yymsp[-9].minor.yy284 = OE_Abort;
  sqlite3CreateIndex(pParse, &yymsp[-7].minor.yy98, &yymsp[-6].minor.yy98, yymsp[-4].minor.yy259, yymsp[-2].minor.yy210, yymsp[-9].minor.yy284, &yymsp[-10].minor.yy0, &yymsp[-1].minor.yy0);
}
#line 2683 "parse.c"
        break;
      case 235:
      case 282:
#line 738 "parse.y"
{yygotominor.yy284 = OE_Abort;}
#line 2689 "parse.c"
        break;
      case 236:
#line 739 "parse.y"
{yygotominor.yy284 = OE_None;}
#line 2694 "parse.c"
        break;
      case 239:
#line 749 "parse.y"
{
  Expr *p = 0;
  if( yymsp[-1].minor.yy98.n>0 ){
    p = sqlite3Expr(TK_COLUMN, 0, 0, 0);
    if( p ) p->pColl = sqlite3LocateCollSeq(pParse, yymsp[-1].minor.yy98.z, yymsp[-1].minor.yy98.n);
  }
  yygotominor.yy210 = sqlite3ExprListAppend(yymsp[-4].minor.yy210, p, &yymsp[-2].minor.yy98);
}
#line 2706 "parse.c"
        break;
      case 240:
#line 757 "parse.y"
{
  Expr *p = 0;
  if( yymsp[-1].minor.yy98.n>0 ){
    p = sqlite3Expr(TK_COLUMN, 0, 0, 0);
    if( p ) p->pColl = sqlite3LocateCollSeq(pParse, yymsp[-1].minor.yy98.z, yymsp[-1].minor.yy98.n);
  }
  yygotominor.yy210 = sqlite3ExprListAppend(0, p, &yymsp[-2].minor.yy98);
}
#line 2718 "parse.c"
        break;
      case 242:
#line 770 "parse.y"
{sqlite3DropIndex(pParse, yymsp[0].minor.yy259);}
#line 2723 "parse.c"
        break;
      case 243:
      case 244:
#line 774 "parse.y"
{sqlite3Vacuum(pParse,0);}
#line 2729 "parse.c"
        break;
      case 245:
      case 247:
#line 779 "parse.y"
{sqlite3Pragma(pParse,&yymsp[-3].minor.yy98,&yymsp[-2].minor.yy98,&yymsp[0].minor.yy98,0);}
#line 2735 "parse.c"
        break;
      case 246:
#line 780 "parse.y"
{sqlite3Pragma(pParse,&yymsp[-3].minor.yy98,&yymsp[-2].minor.yy98,&yymsp[0].minor.yy0,0);}
#line 2740 "parse.c"
        break;
      case 248:
#line 782 "parse.y"
{
  sqlite3Pragma(pParse,&yymsp[-3].minor.yy98,&yymsp[-2].minor.yy98,&yymsp[0].minor.yy98,1);
}
#line 2747 "parse.c"
        break;
      case 249:
#line 785 "parse.y"
{sqlite3Pragma(pParse,&yymsp[-4].minor.yy98,&yymsp[-3].minor.yy98,&yymsp[-1].minor.yy98,0);}
#line 2752 "parse.c"
        break;
      case 250:
#line 786 "parse.y"
{sqlite3Pragma(pParse,&yymsp[-1].minor.yy98,&yymsp[0].minor.yy98,0,0);}
#line 2757 "parse.c"
        break;
      case 257:
#line 796 "parse.y"
{
  Token all;
  all.z = yymsp[-3].minor.yy98.z;
  all.n = (yymsp[0].minor.yy0.z - yymsp[-3].minor.yy98.z) + yymsp[0].minor.yy0.n;
  sqlite3FinishTrigger(pParse, yymsp[-1].minor.yy91, &all);
}
#line 2767 "parse.c"
        break;
      case 258:
#line 805 "parse.y"
{
  sqlite3BeginTrigger(pParse, &yymsp[-7].minor.yy98, &yymsp[-6].minor.yy98, yymsp[-5].minor.yy284, yymsp[-4].minor.yy146.a, yymsp[-4].minor.yy146.b, yymsp[-2].minor.yy259, yymsp[-1].minor.yy284, yymsp[0].minor.yy258, yymsp[-9].minor.yy284);
  yygotominor.yy98 = (yymsp[-6].minor.yy98.n==0?yymsp[-7].minor.yy98:yymsp[-6].minor.yy98);
}
#line 2775 "parse.c"
        break;
      case 259:
      case 262:
#line 811 "parse.y"
{ yygotominor.yy284 = TK_BEFORE; }
#line 2781 "parse.c"
        break;
      case 260:
#line 812 "parse.y"
{ yygotominor.yy284 = TK_AFTER;  }
#line 2786 "parse.c"
        break;
      case 261:
#line 813 "parse.y"
{ yygotominor.yy284 = TK_INSTEAD;}
#line 2791 "parse.c"
        break;
      case 263:
      case 264:
      case 265:
#line 818 "parse.y"
{yygotominor.yy146.a = yymsp[0].major; yygotominor.yy146.b = 0;}
#line 2798 "parse.c"
        break;
      case 266:
#line 821 "parse.y"
{yygotominor.yy146.a = TK_UPDATE; yygotominor.yy146.b = yymsp[0].minor.yy272;}
#line 2803 "parse.c"
        break;
      case 267:
      case 268:
#line 824 "parse.y"
{ yygotominor.yy284 = TK_ROW; }
#line 2809 "parse.c"
        break;
      case 269:
#line 826 "parse.y"
{ yygotominor.yy284 = TK_STATEMENT; }
#line 2814 "parse.c"
        break;
      case 270:
#line 829 "parse.y"
{ yygotominor.yy258 = 0; }
#line 2819 "parse.c"
        break;
      case 271:
#line 830 "parse.y"
{ yygotominor.yy258 = yymsp[0].minor.yy258; }
#line 2824 "parse.c"
        break;
      case 272:
#line 834 "parse.y"
{
  yymsp[-2].minor.yy91->pNext = yymsp[0].minor.yy91;
  yygotominor.yy91 = yymsp[-2].minor.yy91;
}
#line 2832 "parse.c"
        break;
      case 273:
#line 838 "parse.y"
{ yygotominor.yy91 = 0; }
#line 2837 "parse.c"
        break;
      case 274:
#line 844 "parse.y"
{ yygotominor.yy91 = sqlite3TriggerUpdateStep(&yymsp[-3].minor.yy98, yymsp[-1].minor.yy210, yymsp[0].minor.yy258, yymsp[-4].minor.yy284); }
#line 2842 "parse.c"
        break;
      case 275:
#line 849 "parse.y"
{yygotominor.yy91 = sqlite3TriggerInsertStep(&yymsp[-5].minor.yy98, yymsp[-4].minor.yy272, yymsp[-1].minor.yy210, 0, yymsp[-7].minor.yy284);}
#line 2847 "parse.c"
        break;
      case 276:
#line 852 "parse.y"
{yygotominor.yy91 = sqlite3TriggerInsertStep(&yymsp[-2].minor.yy98, yymsp[-1].minor.yy272, 0, yymsp[0].minor.yy107, yymsp[-4].minor.yy284);}
#line 2852 "parse.c"
        break;
      case 277:
#line 856 "parse.y"
{yygotominor.yy91 = sqlite3TriggerDeleteStep(&yymsp[-1].minor.yy98, yymsp[0].minor.yy258);}
#line 2857 "parse.c"
        break;
      case 278:
#line 859 "parse.y"
{yygotominor.yy91 = sqlite3TriggerSelectStep(yymsp[0].minor.yy107); }
#line 2862 "parse.c"
        break;
      case 279:
#line 862 "parse.y"
{
  yygotominor.yy258 = sqlite3Expr(TK_RAISE, 0, 0, 0); 
  yygotominor.yy258->iColumn = OE_Ignore;
  sqlite3ExprSpan(yygotominor.yy258, &yymsp[-3].minor.yy0, &yymsp[0].minor.yy0);
}
#line 2871 "parse.c"
        break;
      case 280:
#line 867 "parse.y"
{
  yygotominor.yy258 = sqlite3Expr(TK_RAISE, 0, 0, &yymsp[-1].minor.yy98); 
  yygotominor.yy258->iColumn = yymsp[-3].minor.yy284;
  sqlite3ExprSpan(yygotominor.yy258, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0);
}
#line 2880 "parse.c"
        break;
      case 281:
#line 873 "parse.y"
{yygotominor.yy284 = OE_Rollback;}
#line 2885 "parse.c"
        break;
      case 283:
#line 875 "parse.y"
{yygotominor.yy284 = OE_Fail;}
#line 2890 "parse.c"
        break;
      case 284:
#line 879 "parse.y"
{
  sqlite3DropTrigger(pParse,yymsp[0].minor.yy259);
}
#line 2897 "parse.c"
        break;
      case 285:
#line 884 "parse.y"
{
  sqlite3Attach(pParse, &yymsp[-3].minor.yy98, &yymsp[-1].minor.yy98, yymsp[0].minor.yy292.type, &yymsp[0].minor.yy292.key);
}
#line 2904 "parse.c"
        break;
      case 286:
#line 888 "parse.y"
{ yygotominor.yy292.type = 0; }
#line 2909 "parse.c"
        break;
      case 287:
#line 889 "parse.y"
{ yygotominor.yy292.type=1; yygotominor.yy292.key = yymsp[0].minor.yy98; }
#line 2914 "parse.c"
        break;
      case 288:
#line 890 "parse.y"
{ yygotominor.yy292.type=2; yygotominor.yy292.key = yymsp[0].minor.yy0; }
#line 2919 "parse.c"
        break;
      case 291:
#line 896 "parse.y"
{
  sqlite3Detach(pParse, &yymsp[0].minor.yy98);
}
#line 2926 "parse.c"
        break;
  };
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yypParser->yyidx -= yysize;
  yyact = yy_find_reduce_action(yypParser,yygoto);
  if( yyact < YYNSTATE ){
    yy_shift(yypParser,yyact,yygoto,&yygotominor);
  }else if( yyact == YYNSTATE + YYNRULE + 1 ){
    yy_accept(yypParser);
  }
}

/*
** The following code executes when the parse fails
*/
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  sqlite3ParserARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
  sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  YYMINORTYPE yyminor            /* The minor type of the error token */
){
  sqlite3ParserARG_FETCH;
#define TOKEN (yyminor.yy0)
#line 23 "parse.y"

  if( pParse->zErrMsg==0 ){
    if( TOKEN.z[0] ){
      sqlite3ErrorMsg(pParse, "near \"%T\": syntax error", &TOKEN);
    }else{
      sqlite3ErrorMsg(pParse, "incomplete SQL statement");
    }
  }
#line 2978 "parse.c"
  sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  sqlite3ParserARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
  sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "sqlite3ParserAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void sqlite3Parser(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  sqlite3ParserTOKENTYPE yyminor       /* The value for the token */
  sqlite3ParserARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  int yyact;            /* The parser action. */
  int yyendofinput;     /* True if we are at the end of input */
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
  yyParser *yypParser;  /* The parser */

  /* (re)initialize the parser, if necessary */
  yypParser = (yyParser*)yyp;
  if( yypParser->yyidx<0 ){
    if( yymajor==0 ) return;
    yypParser->yyidx = 0;
    yypParser->yyerrcnt = -1;
    yypParser->yystack[0].stateno = 0;
    yypParser->yystack[0].major = 0;
  }
  yyminorunion.yy0 = yyminor;
  yyendofinput = (yymajor==0);
  sqlite3ParserARG_STORE;

#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sInput %s\n",yyTracePrompt,yyTokenName[yymajor]);
  }
#endif

  do{
    yyact = yy_find_shift_action(yypParser,yymajor);
    if( yyact<YYNSTATE ){
      yy_shift(yypParser,yyact,yymajor,&yyminorunion);
      yypParser->yyerrcnt--;
      if( yyendofinput && yypParser->yyidx>=0 ){
        yymajor = 0;
      }else{
        yymajor = YYNOCODE;
      }
    }else if( yyact < YYNSTATE + YYNRULE ){
      yy_reduce(yypParser,yyact-YYNSTATE);
    }else if( yyact == YY_ERROR_ACTION ){
      int yymx;
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yymx = yypParser->yystack[yypParser->yyidx].major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yymajor,&yyminorunion);
        yymajor = YYNOCODE;
      }else{
         while(
          yypParser->yyidx >= 0 &&
          yymx != YYERRORSYMBOL &&
          (yyact = yy_find_shift_action(yypParser,YYERRORSYMBOL)) >= YYNSTATE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yyidx < 0 || yymajor==0 ){
          yy_destructor(yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          YYMINORTYPE u2;
          u2.YYERRSYMDT = 0;
          yy_shift(yypParser,yyact,YYERRORSYMBOL,&u2);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
      }
      yymajor = YYNOCODE;
#endif
    }else{
      yy_accept(yypParser);
      yymajor = YYNOCODE;
    }
  }while( yymajor!=YYNOCODE && yypParser->yyidx>=0 );
  return;
}
