package SPOPS::Error;

# $Id: Error.pm,v 3.2 2003/01/02 06:00:25 lachoy Exp $

use strict;
use vars         qw( @FIELDS );
use Data::Dumper qw( Dumper );

*_w    = *SPOPS::_w;
*DEBUG = *SPOPS::DEBUG;

$SPOPS::Error::VERSION  = sprintf("%d.%02d", q$Revision: 3.2 $ =~ /(\d+)\.(\d+)/);

@FIELDS   = qw( user_msg system_msg type extra
                package filename line method );

sub clear {
    my ( $class ) = @_;
    no strict 'refs';
    for ( @FIELDS ) { ${ $class . '::' . $_ } = undef }
}


sub get {
    my ( $class ) = @_;
    no strict 'refs';
    return { map { $_ => ${ $class . '::' . $_ } } @FIELDS };
}


sub set {
    my ( $class, $p ) = @_;
    $class->clear;
    {
        no strict 'refs';
        for ( @FIELDS ) { ${ $class . '::' . $_ } = $p->{ $_} }
    }

    # Set the caller information if the user didn't pass anything in

    unless ( $p->{package} and $p->{filename} and $p->{line} ) {
        ( $SPOPS::Error::package,
          $SPOPS::Error::filename,
          $SPOPS::Error::line,
          $SPOPS::Error::method ) = caller(0);
    }
    return $class->get;
}

1;

__END__

=pod

=head1 NAME

SPOPS::Error - (DEPRECATED) Centralized error messages from all SPOPS objects.

=head1 SYNOPSIS

NOTE: AS OF SPOPS 0.56 THIS CLASS IS DEPRECATED IN FAVOR OF THE
SPOPS::Exception HIERARCHY. THAT CLASS MAINTAINS BACKWARD
COMPATIBILITY WITH THIS ONE, BUT THIS WILL BE REMOVED SOMETIME BEFORE
A FINAL 1.0 RELEASE.

 # Using SPOPS in your application

 my $obj_list = eval { $class->fetch_group({ where => 'this = that' }) };
 if ( $@ ) {
   warn "Error found! Error: $@\n",
        "Error type: $SPOPS::Error::type\n",
        "More specific: $SPOPS::Error::system_msg\n",
        "Extra stuff:\n",
        "--$SPOPS::Error::extra->{sql}\n",
        "--$SPOPS::Error::extra->{valuesb}\n";
 }

=head1 DESCRIPTION

This class provides a central location for error messages from all
SPOPS modules. The error information collected in these variables is
guaranteed to result from the most recent error generated by SPOPS.

=head1 VARIABLES

All of these variables are package variables, so you refer to them
like this:

  $SPOPS::Error::<variable_name>
  $SPOPS::Error::system_msg

See the L<NOTES> section below for hints on making the error variables
shorter.

B<user_msg> ($)

A generic message that is suitable for showing a user. When telling a
user something went wrong, you do not want to tell them:

 execute called with 2 bind variables when 1 are needed

instead, you want to tell them:

 Database query failed to execute

Typically, this is the message that the SPOPS class will C<die()>
with.

B<system_msg> ($)

Even though you do not want to show your users details of the error,
you still need to know them! The variable I<system_msg> gives you
details regarding the error.

B<type> ($)

SPOPS knows about a few types of errors. Some depend on your SPOPS
implementation (e.g., DBI, dbm, LDAP, etc.). Others can be:

=over 4

=item *

B<security>: There is a security violation and the action could not be
completed

=back

B<package> ($)

Set to the package from where the error was thrown.

B<method> ($)

Set to the method from where the error was thrown. (If set
automatically, this is a fully-qualified subroutine name.)

B<filename> ($)

Set to the filename from where the error was thrown.

B<line> ($)

Set to the line number from where the error was thrown.

B<extra> (\%)

Different SPOPS classes have different information related to the
current request. For instance, DBI errors will typically fill the
'sql' and 'values' keys. Other SPOPS implementations may use different
keys; see their documentation for details.

=head1 METHODS

B<clear()>

Clears the current error saved in the class. Classes outside the
B<SPOPS::> hierarchy should never need to call this.

No return value.

B<get()>

Returns a hashref with all the currently set error values.

B<set( \%params )>

First clears the variables then sets them all in one fell swoop. The
variables that are set are passed in the first argument, a
hashref. Also sets both the package, method, filename and line and
variables for you, although you can override by setting manually.

Returns the results from a C<get()>, including the results that may be
automatically filled in.

=head1 NOTES

Some people might find it easier to alias a local package variable to
a SPOPS error variable. For instance, you can do:

 *err_user_msg   = \$SPOPS::Error::user_msg;
 *err_system_msg = \$SPOPS::Error::system_msg;
 *err_type       = \$SPOPS::Error::type;
 *err_extra      = \%SPOPS::Error::extra;

And then refer to the alias in your local package:

 my $obj_list = eval { $obj->fetch_group({ where => 'this = that' }) };
 if ( $@ ) {
   warn "Error found! Error: $@\n",
        "Error type: $err_type\n",
        "More specific: $err_system_msg\n",
        "Extra stuff:\n",
        "--$err_extra{sql}\n",
        "--$err_extra{values}\n";
 }

Whatever floats your boat.

=head1 TO DO

Nothing known.

=head1 BUGS

None known.

=head1 COPYRIGHT

Copyright (c) 2001-2002 intes.net, inc.. All rights reserved.

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.

=head1 AUTHORS

Chris Winters E<lt>chris@cwinters.comE<gt>

=cut
