#!perl

use strict;
use warnings;
use Test::More tests => 19;
use Test::Differences;
use IO::CaptureOutput qw(capture_exec);

my @perl = ( $^X, '-Ilib' );
push @perl, '-MDevel::Cover=-silent,1,-db,cover_db,-ignore,.,+select,advent,+select,Advent' if exists $INC{'Devel/Cover.pm'};

my @files = (
  [ 'ex/sample.pod', 'ex/sample.html', '## Please see file perltidy.ERR
Possible SPELLING ERRORS:
	href
	lt
	pre
	mispelling
', ],
  [ 'ex/getting_started.pod', 'ex/getting_started.html', '## Please see file perltidy.ERR
', ],
  [ 'ex/footnotes.pod', 'ex/footnotes.html', 'Possible SPELLING ERRORS:
	sourcedcode
', ],
);

foreach my $info ( @files ){
  my ($podfile, $htmlfile, $errors) = @$info;
  my ($stdout, $stderr, $success, $exit_code) = capture_exec( @perl, 'bin/pod2advent', $podfile );

  is($success, 1, "[$podfile] success");
  is($exit_code, 0, "[$podfile] exit code");

  my $html = do{ local $/ = undef; open FILE, '<', $htmlfile; <FILE> };
  s/^<!-- Generated by Pod::Advent .+? -->$//m for $html, $stdout;

  eq_or_diff($stderr, $errors, "[$podfile] errors match");
  SKIP: {
    ok( $stdout, "[$podfile] got output" )
	or skip 'no output!', 1;
    eq_or_diff($stdout, $html,   "[$podfile] output matches");
  }
}


my ($stdout, $stderr, $success, $exit_code) = capture_exec( @perl, 'bin/pod2advent');
is($success, 0, "[no args] failed");
ok($exit_code>>8, "[no args] exit code");
eq_or_diff($stdout, '', "[no args] file matches");
eq_or_diff($stderr, "need pod filename at bin/pod2advent line 7.\n", "[no args] errors match");


