use strict;
use warnings;
use Test::More 0.88;
# This is a relatively nice way to avoid Test::NoWarnings breaking our
# expectations by adding extra tests, without using no_plan.  It also helps
# avoid any other test module that feels introducing random tests, or even
# test plans, is a nice idea.
our $success = 0;
END { $success && done_testing; }

# List our own version used to generate this
my $v = "\nGenerated by Dist::Zilla::Plugin::ReportVersions::Tiny v1.08\n";

eval {                     # no excuses!
    # report our Perl details
    my $want = '5.016';
    $v .= "perl: $] (wanted $want) on $^O from $^X\n\n";
};
defined($@) and diag("$@");

# Now, our module version dependencies:
sub pmver {
    my ($module, $wanted) = @_;
    $wanted = " (want $wanted)";
    my $pmver;
    eval "require $module;";
    if ($@) {
        if ($@ =~ m/Can't locate .* in \@INC/) {
            $pmver = 'module not found.';
        } else {
            diag("${module}: $@");
            $pmver = 'died during require.';
        }
    } else {
        my $version;
        eval { $version = $module->VERSION; };
        if ($@) {
            diag("${module}: $@");
            $pmver = 'died during VERSION check.';
        } elsif (defined $version) {
            $pmver = "$version";
        } else {
            $pmver = '<undef>';
        }
    }

    # So, we should be good, right?
    return sprintf('%-45s => %-10s%-15s%s', $module, $pmver, $wanted, "\n");
}

eval { $v .= pmver('App::Cmd::Setup','any version') };
eval { $v .= pmver('CPAN::Mini','any version') };
eval { $v .= pmver('CPAN::Recent::Uploads','any version') };
eval { $v .= pmver('Config::Tiny','any version') };
eval { $v .= pmver('DateTime','any version') };
eval { $v .= pmver('Encode','any version') };
eval { $v .= pmver('Exporter::Lite','any version') };
eval { $v .= pmver('File::Copy','any version') };
eval { $v .= pmver('File::Find','any version') };
eval { $v .= pmver('File::HomeDir::PathClass','any version') };
eval { $v .= pmver('File::ShareDir::PathClass','any version') };
eval { $v .= pmver('File::Temp','any version') };
eval { $v .= pmver('File::pushd','any version') };
eval { $v .= pmver('Find::Lib','any version') };
eval { $v .= pmver('LWP::Simple','any version') };
eval { $v .= pmver('LWP::UserAgent','any version') };
eval { $v .= pmver('List::AllUtils','any version') };
eval { $v .= pmver('Log::Dispatchouli','any version') };
eval { $v .= pmver('MetaCPAN::API','any version') };
eval { $v .= pmver('Module::Build','0.3601') };
eval { $v .= pmver('Moose','any version') };
eval { $v .= pmver('Moose::Role','any version') };
eval { $v .= pmver('MooseX::Has::Sugar','any version') };
eval { $v .= pmver('MooseX::SemiAffordanceAccessor','any version') };
eval { $v .= pmver('MooseX::Singleton','any version') };
eval { $v .= pmver('ORDB::CPAN::Mageia','any version') };
eval { $v .= pmver('Parallel::ForkManager','any version') };
eval { $v .= pmver('Parse::CPAN::Meta','1.4401') };
eval { $v .= pmver('Parse::CPAN::Packages::Fast','any version') };
eval { $v .= pmver('Path::Class','0.22') };
eval { $v .= pmver('Pod::Coverage::TrustPod','any version') };
eval { $v .= pmver('RRDTool::OO','any version') };
eval { $v .= pmver('Readonly','any version') };
eval { $v .= pmver('Template','any version') };
eval { $v .= pmver('Test::More','0.88') };
eval { $v .= pmver('Test::Pod','1.41') };
eval { $v .= pmver('Test::Pod::Coverage','1.08') };
eval { $v .= pmver('Text::Padding','any version') };
eval { $v .= pmver('URPM','any version') };
eval { $v .= pmver('strict','any version') };
eval { $v .= pmver('version','0.9901') };
eval { $v .= pmver('warnings','any version') };


# All done.
$v .= <<'EOT';

Thanks for using my code.  I hope it works for you.
If not, please try and include this output in the bug report.
That will help me reproduce the issue and solve your problem.

EOT

diag($v);
ok(1, "we really didn't test anything, just reporting data");
$success = 1;

# Work around another nasty module on CPAN. :/
no warnings 'once';
$Template::Test::NO_FLUSH = 1;
exit 0;
