#
# This file is part of Test-Apocalypse
#
# This software is copyright (c) 2011 by Apocalypse.
#
# This is free software; you can redistribute it and/or modify it under
# the same terms as the Perl 5 programming language system itself.
#
use strict; use warnings;
package Test::Apocalypse::Fixme;
BEGIN {
  $Test::Apocalypse::Fixme::VERSION = '1.000';
}
BEGIN {
  $Test::Apocalypse::Fixme::AUTHORITY = 'cpan:APOCAL';
}

# ABSTRACT: Plugin for Test::Fixme

use Test::More;
use Test::Fixme 0.04;

sub _do_automated { 0 }

sub do_test {
	TODO: {
		local $TODO = "Fixme";
		run_tests(
			'where'			=> 'lib',
			'match'			=> qr/[F]IXME|[T]ODO|[X]XX/, # zany format so it won't pick up this file!
			'filename_match'	=> qr/\.(?:pm|pl|xs)$/, # specify this so we skip .c files generated by XS
		);
	}

	return;
}

1;


__END__
=pod

=for Pod::Coverage do_test

=head1 NAME

Test::Apocalypse::Fixme - Plugin for Test::Fixme

=head1 VERSION

  This document describes v1.000 of Test::Apocalypse::Fixme - released March 04, 2011 as part of Test-Apocalypse.

=head1 DESCRIPTION

Encapsulates L<Test::Fixme> functionality.

=head1 SEE ALSO

Please see those modules/websites for more information related to this module.

=over 4

=item *

L<Test::Apocalypse>

=back

=head1 AUTHOR

Apocalypse <APOCAL@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2011 by Apocalypse.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

The full text of the license can be found in the LICENSE file included with this distribution.

=cut

