#!/usr/bin/perl -w

# -o, -b, -B, -V, SIMPLE_BACKUP_SUFFIX, VERSION_CONTROL

use strict;
use Test; plan tests => 11;

sub touch {
    my $file = shift;
    open F, "> $file" or die "Couldn't touch '$file': $!";
    close F;
}

{
    my $i = 0;
    sub file {
        my $file = 'kupo' . ++$i . '.txt';
        touch $file;
        $file;
    }
}

touch 'kupo.txt';
unlink <*txt*> or die "Couldn't unlink files: $!";

my $file;

# .orig
$file = file;
system("perl ../patch -so $file < extension.diff") == 0
    or die "Couldn't patch: $!";
ok(-e "$file.orig");

# -b .bak
$file = file;
system("perl ../patch -so $file -b .bak < extension.diff") == 0
    or die "Couldn't patch: $!";
ok(-e "$file.bak");

# -B copy-
$file = file;
system("perl ../patch -so $file -B copy- < extension.diff") == 0
    or die "Couldn't patch: $!";
ok(-e "copy-$file");

# -V simple
$file = file;
system("perl ../patch -so $file -V simple < extension.diff") == 0
    or die "Couldn't patch: $!";
ok(-e "$file.orig");

# -V existing   ...numbered backups don't exist
$file = file;
system("perl ../patch -so $file -V existing < extension.diff") == 0
    or die "Couldn't patch: $!";
ok(-e "$file.orig");

# -V existing   ...numbered backups already exist
$file = file;
touch "$file.~1~";
system("perl ../patch -so $file -V existing < extension.diff") == 0
    or die "Couldn't patch: $!";
ok(-e "$file.~2~");

# -V numbered   ...start .~1~
$file = file;
system("perl ../patch -so $file -V numbered < extension.diff") == 0
    or die "Couldn't patch: $!";
ok(-e "$file.~1~");

# -V numbered   ...continue .~2~
$file = file;
touch "$file.~1~";
system("perl ../patch -so $file -V numbered < extension.diff") == 0
    or die "Couldn't patch: $!";
ok(-e "$file.~2~");

$ENV{VERSION_CONTROL} = 'numbered';  # ...continue .~2~
$file = file;
touch "$file.~1~";
system("perl ../patch -so $file < extension.diff") == 0
    or die "Couldn't patch: $!";
ok(-e "$file.~2~");

$ENV{VERSION_CONTROL} = 'existing';  # ...doesn't exist
$file = file;
system("perl ../patch -so $file < extension.diff") == 0
    or die "Couldn't patch: $!";
ok(-e "$file.orig");

$ENV{VERSION_CONTROL} = 'existing';  # ...doesn't exist
$ENV{SIMPLE_BACKUP_SUFFIX} = '.bak'; # .bak
$file = file;
system("perl ../patch -so $file < extension.diff") == 0
    or die "Couldn't patch: $!";
ok(-e "$file.bak");

unlink <*txt*> or die "Couldn't unlink files: $!";


