#!/usr/bin/perl -w

# -R, -E, -D, -l, -r, -F

use strict;
use Test; plan tests => 7;
use File::Copy;
use File::Compare;

# -R

system("perl ../patch -s -R -o reverse.txt santa.kurune santa.diff") == 0
    or die "Couldn't patch: $!";
ok(compare('reverse.txt', 'santa.kulock') == 0);

# -E

system("perl ../patch -s -o empty1.txt santa.kulock santa.E.diff") == 0
    or die "Couldn't patch: $!";
system("perl ../patch -s -E -o empty2.txt santa.kulock santa.E.diff") == 0
    or die "Couldn't patch: $!";
ok(-e 'empty1.txt' && -z 'empty1.txt' && ! -e 'empty2.txt');

# -D

system("perl ../patch -s -D kupo -o ifdef.txt santa.kulock santa.diff") == 0
    or die "Couldn't patch: $!";
ok(compare('ifdef.txt', 'santa.ifdef') == 0);

open IN, "< santa.diff" or die "Couldn't open 'santa.diff': $!";
open OUT, "> loose.txt"  or die "Couldn't open 'loose.txt: $!";
binmode IN;
binmode OUT;
while (<IN>) {
    s/(?!^) +/\t\t/g unless /^[\@\+]/;
    print OUT $_;
}
close IN;
close OUT;

# -l

system("perl ../patch -s -o loose1.txt santa.kulock < loose.txt") == 0
    or die "Couldn't patch: $!";
ok(-e 'loose1.txt.rej');

# -r

system("perl ../patch -s -r reject.txt -o loose2.txt santa.kulock < loose.txt")
    == 0 or die "Couldn't patch: $!";
ok(-e 'reject.txt');

system("perl ../patch -s -l -o loose3.txt santa.kulock < loose.txt") == 0
    or die "Couldn't patch: $!";
ok(compare('loose3.txt', 'santa.kurune') == 0);

# -F

open IN, "< santa.diff" or die "Couldn't open 'santa.diff': $!";
open OUT, "> fuzz.txt"  or die "Couldn't open 'fuzz.txt: $!";
binmode IN;
binmode OUT;
while (<IN>) {
    if (/^ send me:$/) {
        <IN>;
        print OUT " fuzz 1\n fuzz 2\n";
    } else {
        print OUT $_;
    }
}
close IN;
close OUT;

system("perl ../patch -s -F1 -o fuzz1.txt santa.kulock < fuzz.txt") == 0
    or die "Couldn't patch: $!";
system("perl ../patch -s -F2 -o fuzz2.txt santa.kulock < fuzz.txt") == 0
    or die "Couldn't patch: $!";
ok(
    compare('fuzz1.txt', 'santa.kurune') != 0 &&
    compare('fuzz2.txt', 'santa.kurune') == 0
);


unlink <*txt*> or die "Couldn't unlink files: $!";


