package XXX;
use 5.006001;
use strict;
use warnings;
no warnings 'redefine';
use base 'Exporter';

{
    no strict 'refs';
    *{"YYY::"} = *{"XXX::"};
}

our $VERSION = '0.14';
our @EXPORT = qw( WWW XXX YYY ZZZ );

my $dump_type = 'yaml';
my $dump_module = 'YAML';

sub import {
    my ($package, @args) = @_;
    for (my $i = 0; $i < @args; $i++) {
        my $arg = $args[$i];
        if ($arg =~ /^-dumper$/i) {
            $dump_type = 'dumper';
            $dump_module = 'Data::Dumper';
        }
        elsif ($arg =~ /^-yaml$/i) {
            $dump_type = 'yaml';
            $dump_module = 'YAML';
        }
        elsif ($arg eq '-with') {
            die "-with requires another argument"
              unless $i++ < @args;
            my $with = $args[$i];
            $dump_module = $with;
            $dump_type = 
                $with =~ /^YAML/ ? 'yaml' :
                $with eq 'Data::Dumper' ? 'dumper' :
                die "Don't know how to use XXX -with $with";
        }
        else {
            next;
        }
        last;
    }
    eval "require $dump_module; 1" or die $@;
    @_ = ($package);
    goto &Exporter::import;
}

sub _xxx_dump {
    no strict 'refs';
    no warnings;
    if ($dump_type eq 'yaml') {
        return &{"$dump_module\::Dump"}(@_) . "...\n";
    }
    elsif ($dump_type eq 'dumper') {
        $Data::Dumper::Sortkeys = 1;
        $Data::Dumper::Indent = 1;
        return Data::Dumper::Dumper(@_);
    }
    else {
        die "XXX had an internal error";
    }
}

sub _at_line_number {
    my ($file_path, $line_number) = (caller(1))[1,2];
    "  at $file_path line $line_number\n";
}

sub WWW {
    warn _xxx_dump(@_) . _at_line_number;
    return wantarray ? @_ : $_[0];
}

sub XXX {
    die _xxx_dump(@_) . _at_line_number;
}

sub YYY {
    print _xxx_dump(@_) . _at_line_number;
    return wantarray ? @_ : $_[0];
}

sub ZZZ {
    require Carp;
    Carp::confess(_xxx_dump(@_));
}

1;

=encoding utf8

=head1 NAME

XXX - See Your Data in the Nude

=head1 SYNOPSIS

    use XXX;
    XXX my $dog = Dog->new({has => ['fleas', 'style']});
    my $dog = XXX Dog->new({has => ['fleas', 'style']});
    my $dog = Dog->new(XXX {has => ['fleas', 'style']});
    my $dog = Dog->new({XXX has => ['fleas', 'style']});
    my $dog = Dog->new({has => XXX ['fleas', 'style']});
    my $dog = Dog->new({has => [XXX 'fleas', 'style']});

=head1 DESCRIPTION

XXX.pm exports a function called XXX that you can put just about
anywhere in your Perl code to make it die with a YAML dump of the
arguments to its right.

The charm of XXX-debugging is that it is easy to type, rarely requires
parens and stands out visually so that you remember to remove it.

XXX.pm also exports WWW, YYY and ZZZ which do similar debugging things.

=head1 FUNCTIONS

=over

=item WWW

WWW will warn a dump of its arguments, and then return the original
arguments. This means you can stick it in the middle of expressions.

mnemonic: W for warn

=item XXX

XXX will die with a dump of its arguments.

mnemonic: XXX == Death, Nudity

=item YYY

YYY will print a dump of its arguments, and then return the original
arguments. This means you can stick it in the middle of expressions.

mnemonic: YYY == Why Why Why??? or YAML YAML YAML

=item ZZZ

ZZZ will Carp::confess a dump of its arguments.

mnemonic: You should confess all your sins before you sleep. zzzzzzzz

=back

=head1 ADVANCED USAGE

By default, XXX uses YAML.pm to dump your data. You can change this like so:

    use XXX -with => 'Data::Dumper';
    use XXX -with => 'YAML::XS';
    use XXX -with => 'YAML::SomeOtherYamlModule';

You can also use these forms, but they are now deprecated:

    use XXX -dumper;
    use XXX -yaml;

=head1 NOTE FOR INSTALLING XXX

Use `cpanm`. It just works!

    > cpanm --sudo XXX

Otherwise, read this...

At this time CPAN indexes XXX.pm to some other module distribution that
doesn't even have an XXX.pm module. Oh the wonders of CPAN. To install
this module, ask for YYY.pm instead. Something like this should work:

    > sudo cpan YYY

This will install XXX.pm and YYY.pm (which is an exact copy of XXX.pm).
You can use either one. :)

=head1 AUTHOR

Ingy döt Net <ingy@cpan.org>

=head1 COPYRIGHT

Copyright (c) 2006, 2008, 2010. Ingy döt Net.

This program is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

See L<http://www.perl.com/perl/misc/Artistic.html>

=cut
