/* Driver template for the LEMON parser generator.
** The author disclaims copyright to this source code.
*/
/* First off, code is include which follows the "include" declaration
** in the input file. */
#include <stdio.h>
#line 33 "parse.y"

#include "sqliteInt.h"
#include "parse.h"

/*
** An instance of this structure holds information about the
** LIMIT clause of a SELECT statement.
*/
struct LimitVal {
  int limit;    /* The LIMIT value.  -1 if there is no limit */
  int offset;   /* The OFFSET.  0 if there is none */
};

/*
** An instance of the following structure describes the event of a
** TRIGGER.  "a" is the event type, one of TK_UPDATE, TK_INSERT,
** TK_DELETE, or TK_INSTEAD.  If the event is of the form
**
**      UPDATE ON (a,b,c)
**
** Then the "b" IdList records the list "a,b,c".
*/
struct TrigEvent { int a; IdList * b; };

/*
** An instance of this structure holds the ATTACH key and the key type.
*/
struct AttachKey { int type;  Token key; };


#line 39 "parse.c"
/* Next is all token values, in a form suitable for use by makeheaders.
** This section will be null unless lemon is run with the -m switch.
*/
/* 
** These constants (all generated automatically by the parser generator)
** specify the various kinds of tokens (terminals) that the parser
** understands. 
**
** Each symbol here is a terminal symbol in the grammar.
*/
/* Make sure the INTERFACE macro is defined.
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/* The next thing included is series of defines which control
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 terminals
**                       and nonterminals.  "int" is used otherwise.
**    YYNOCODE           is a number of type YYCODETYPE which corresponds
**                       to no legal terminal or nonterminal number.  This
**                       number is used to fill in empty slots of the hash 
**                       table.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       have fall-back values which should be used if the
**                       original value of the token will not parse.
**    YYACTIONTYPE       is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 rules and
**                       states combined.  "int" is used otherwise.
**    sqlite3ParserTOKENTYPE     is the data type used for minor tokens given 
**                       directly to the parser from the tokenizer.
**    YYMINORTYPE        is the data type used for all minor tokens.
**                       This is typically a union of many types, one of
**                       which is sqlite3ParserTOKENTYPE.  The entry in the union
**                       for base tokens is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.
**    sqlite3ParserARG_SDECL     A static variable declaration for the %extra_argument
**    sqlite3ParserARG_PDECL     A parameter declaration for the %extra_argument
**    sqlite3ParserARG_STORE     Code to store %extra_argument into yypParser
**    sqlite3ParserARG_FETCH     Code to extract %extra_argument from yypParser
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
*/
#define YYCODETYPE unsigned char
#define YYNOCODE 220
#define YYACTIONTYPE unsigned short int
#define sqlite3ParserTOKENTYPE Token
typedef union {
  sqlite3ParserTOKENTYPE yy0;
  struct LimitVal yy22;
  struct AttachKey yy72;
  TriggerStep* yy107;
  Expr* yy164;
  ExprList* yy232;
  IdList* yy246;
  SrcList* yy283;
  struct {int value; int mask;} yy299;
  Token yy318;
  Select* yy375;
  struct TrigEvent yy414;
  int yy424;
  int yy439;
} YYMINORTYPE;
#define YYSTACKDEPTH 100
#define sqlite3ParserARG_SDECL Parse *pParse;
#define sqlite3ParserARG_PDECL ,Parse *pParse
#define sqlite3ParserARG_FETCH Parse *pParse = yypParser->pParse
#define sqlite3ParserARG_STORE yypParser->pParse = pParse
#define YYNSTATE 565
#define YYNRULE 293
#define YYERRORSYMBOL 130
#define YYERRSYMDT yy439
#define YYFALLBACK 1
#define YY_NO_ACTION      (YYNSTATE+YYNRULE+2)
#define YY_ACCEPT_ACTION  (YYNSTATE+YYNRULE+1)
#define YY_ERROR_ACTION   (YYNSTATE+YYNRULE)

/* Next are that tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N < YYNSTATE                  Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   YYNSTATE <= N < YYNSTATE+YYNRULE   Reduce by rule N-YYNSTATE.
**
**   N == YYNSTATE+YYNRULE              A syntax error has occurred.
**
**   N == YYNSTATE+YYNRULE+1            The parser accepts its input.
**
**   N == YYNSTATE+YYNRULE+2            No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as
**
**      yy_action[ yy_shift_ofst[S] + X ]
**
** If the index value yy_shift_ofst[S]+X is out of range or if the value
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X or if yy_shift_ofst[S]
** is equal to YY_SHIFT_USE_DFLT, it means that the action is not in the table
** and that yy_default[S] should be used instead.  
**
** The formula above is for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array and YY_REDUCE_USE_DFLT is used in place of
** YY_SHIFT_USE_DFLT.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
*/
static YYACTIONTYPE yy_action[] = {
 /*     0 */   264,  140,  262,  119,  123,  117,  121,  129,  131,  133,
 /*    10 */   135,  144,  146,  148,  150,  152,  154,  137,  143,  859,
 /*    20 */     1,  564,    3,  142,  129,  131,  133,  135,  144,  146,
 /*    30 */   148,  150,  152,  154,  641,  690,   26,  115,  103,  139,
 /*    40 */   127,  125,  156,  161,  157,  162,  166,  119,  123,  117,
 /*    50 */   121,  129,  131,  133,  135,  144,  146,  148,  150,  152,
 /*    60 */   154,  367,  247,  143,  263,  369,  375,  380,  142,  144,
 /*    70 */   146,  148,  150,  152,  154,   34,  383,  148,  150,  152,
 /*    80 */   154,  336,  115,  103,  139,  127,  125,  156,  161,  157,
 /*    90 */   162,  166,  119,  123,  117,  121,  129,  131,  133,  135,
 /*   100 */   144,  146,  148,  150,  152,  154,  167,  344,  143,  363,
 /*   110 */    11,  424,  425,  142,   23,    4,    6,  397,   28,   20,
 /*   120 */   169,   37,  171,  172,  535,  506,  663,  115,  103,  139,
 /*   130 */   127,  125,  156,  161,  157,  162,  166,  119,  123,  117,
 /*   140 */   121,  129,  131,  133,  135,  144,  146,  148,  150,  152,
 /*   150 */   154,   68,  248,   45,  575,   40,  394,  310,  295,  298,
 /*   160 */   346,  349,  294,  393,   41,  264,  279,  262,   11,  343,
 /*   170 */    11,  345,   12,   13,  352,  353,  519,   42,  143,  262,
 /*   180 */    43,   32,  342,  142,   35,   53,   59,   61,  306,  337,
 /*   190 */    55,   44,  537,  538,  539,  339,  213,  115,  103,  139,
 /*   200 */   127,  125,  156,  161,  157,  162,  166,  119,  123,  117,
 /*   210 */   121,  129,  131,  133,  135,  144,  146,  148,  150,  152,
 /*   220 */   154,   11,  169,  143,  171,  172,   11,  692,  142,  263,
 /*   230 */    12,   13,   12,   13,   11,  350,  401,  221,  351,   45,
 /*   240 */    11,  263,  115,  103,  139,  127,  125,  156,  161,  157,
 /*   250 */   162,  166,  119,  123,  117,  121,  129,  131,  133,  135,
 /*   260 */   144,  146,  148,  150,  152,  154,   56,  840,  793,  173,
 /*   270 */    35,   53,   59,   61,  306,  337,  642,   51,  365,  545,
 /*   280 */   543,  339,  296,   12,   13,   52,  367,  105,   12,   13,
 /*   290 */   369,  375,  380,  143,   37,  293,   12,   13,  142,  436,
 /*   300 */   536,  383,   12,   13,  455,  448,   29,  102,  845,  362,
 /*   310 */   354,  191,  115,  103,  139,  127,  125,  156,  161,  157,
 /*   320 */   162,  166,  119,  123,  117,  121,  129,  131,  133,  135,
 /*   330 */   144,  146,  148,  150,  152,  154,  304,  363,  249,  259,
 /*   340 */    94,  237,  692,  105,  367,   27,   28,  450,  369,  375,
 /*   350 */   380,  489,  461,  451,  169,  143,  171,  172,  817,  383,
 /*   360 */   142,  232,   72,  488,  364,  396,  361,  169,  546,  171,
 /*   370 */   172,   64,  838,   68,  115,  103,  139,  127,  125,  156,
 /*   380 */   161,  157,  162,  166,  119,  123,  117,  121,  129,  131,
 /*   390 */   133,  135,  144,  146,  148,  150,  152,  154,  474,   11,
 /*   400 */   143,  311,  665,  527,  169,  142,  171,  172,  794,  843,
 /*   410 */   534,  356,  574,  460,  402,    9,  392,  280,  458,  115,
 /*   420 */   103,  139,  127,  125,  156,  161,  157,  162,  166,  119,
 /*   430 */   123,  117,  121,  129,  131,  133,  135,  144,  146,  148,
 /*   440 */   150,  152,  154,   68,  221,  143,  169,  359,  171,  172,
 /*   450 */   142,  332,  410,  313,  405,  281,  259,  479,  339,  274,
 /*   460 */   282,   12,   13,  593,  115,  103,  139,  127,  125,  156,
 /*   470 */   161,  157,  162,  166,  119,  123,  117,  121,  129,  131,
 /*   480 */   133,  135,  144,  146,  148,  150,  152,  154,  197,  256,
 /*   490 */   170,  494,  105,  668,  154,  435,  722,  201,  169,   69,
 /*   500 */   171,  172,   90,  105,  105,  169,  105,  171,  172,  691,
 /*   510 */   205,  251,  297,  195,  143,  728,   83,   85,  329,  142,
 /*   520 */   189,  276,  209,  184,  174,   68,  174,   82,   88,  503,
 /*   530 */   653,  497,  795,  115,  164,  139,  127,  125,  156,  161,
 /*   540 */   157,  162,  166,  119,  123,  117,  121,  129,  131,  133,
 /*   550 */   135,  144,  146,  148,  150,  152,  154,   11,  565,  143,
 /*   560 */   244,  585,  299,   72,  142,  185,   57,  562,  563,  219,
 /*   570 */   447,  219,  429,  478,   58,  253,  482,  360,  115,  227,
 /*   580 */   139,  127,  125,  156,  161,  157,  162,  166,  119,  123,
 /*   590 */   117,  121,  129,  131,  133,  135,  144,  146,  148,  150,
 /*   600 */   152,  154,  252,  500,  143,  262,  803,  245,  300,  142,
 /*   610 */   217,  169,  395,  171,  172,  426,  428,  427,   37,   12,
 /*   620 */    13,  366,  832,  115,  103,  139,  127,  125,  156,  161,
 /*   630 */   157,  162,  166,  119,  123,  117,  121,  129,  131,  133,
 /*   640 */   135,  144,  146,  148,  150,  152,  154,  254,  105,  143,
 /*   650 */   722,  314,  321,  323,  142,   31,  341,  169,   74,  171,
 /*   660 */   172,  692,  336,  466,  266,  287,  274,  263,  174,  103,
 /*   670 */   139,  127,  125,  156,  161,  157,  162,  166,  119,  123,
 /*   680 */   117,  121,  129,  131,  133,  135,  144,  146,  148,  150,
 /*   690 */   152,  154,  230,  810,  143,  289,   11,  311,  368,  142,
 /*   700 */   355,  251,  276,    5,  262,  557,   67,   11,  541,  332,
 /*   710 */    63,  542,  137,  218,  332,  139,  127,  125,  156,  161,
 /*   720 */   157,  162,  166,  119,  123,  117,  121,  129,  131,  133,
 /*   730 */   135,  144,  146,  148,  150,  152,  154,  193,  377,  432,
 /*   740 */    72,  833,  431,  444,  378,  370,  328,  175,   67,  313,
 /*   750 */   692,  221,   63,  525,  430,  143,  332,  433,   12,   13,
 /*   760 */   142,  245,  374,  181,  179,  253,  263,  105,   30,   12,
 /*   770 */    13,  177,   65,   66,  110,  450,  333,  111,  104,  193,
 /*   780 */   332,  333,  225,  229,  105,  386,  471,  488,  105,  175,
 /*   790 */   347,   67,  252,  348,  319,   63,   72,  387,  105,  328,
 /*   800 */   371,   68,  332,  409,  102,  181,  179,  224,  165,  372,
 /*   810 */   112,  113,  183,  177,   65,   66,  110,  320,  145,  111,
 /*   820 */   104,  376,  193,  333,  105,  692,  474,  484,  234,   68,
 /*   830 */   217,  326,  175,   67,  562,  563,  159,   63,   96,  221,
 /*   840 */   105,  456,  221,  465,  149,  105,  458,  333,  181,  179,
 /*   850 */   290,  105,  112,  113,  183,  796,  177,   65,   66,  110,
 /*   860 */   192,  105,  111,  104,  193,  246,  316,  158,  105,  333,
 /*   870 */   445,  241,  328,  105,  175,   67,    2,    3,  318,   63,
 /*   880 */   317,  116,  216,  105,  217,  160,  385,  105,  136,  452,
 /*   890 */   181,  179,  301,  473,  379,  112,  113,  183,  177,   65,
 /*   900 */    66,  110,  105,  118,  111,  104,  193,  151,  105,  168,
 /*   910 */     7,  105,   14,   16,   18,  400,  175,  373,  327,  328,
 /*   920 */   328,  528,  174,  485,  852,  273,  549,  274,  176,  837,
 /*   930 */   471,  469,  181,  179,  559,   68,  105,  112,  113,  183,
 /*   940 */   177,   65,   66,  110,  105,  105,  111,  104,  531,  105,
 /*   950 */   455,  231,  655,  105,  105,  529,  228,  524,  215,   60,
 /*   960 */   384,  555,  105,  399,  174,  138,  105,  219,  105,  120,
 /*   970 */   105,  105,  105,  226,  155,  105,  105,   68,  276,  112,
 /*   980 */   113,  183,  190,   68,  105,  105,  122,  517,  124,   68,
 /*   990 */   126,  214,  178,  105,   62,  128,  141,  507,  512,  451,
 /*  1000 */   233,  105,  105,  493,  212,  130,  105,  105,   72,  219,
 /*  1010 */   382,  105,  105,  182,   46,  105,  105,  266,  105,  388,
 /*  1020 */   105,  210,  163,  266,  389,   48,  132,  114,  325,  105,
 /*  1030 */   272,  278,  381,  481,  390,  153,  486,  357,  134,  358,
 /*  1040 */   303,  487,  291,  485,  420,   22,  105,  398,  284,  180,
 /*  1050 */   105,   48,  391,  137,  267,  220,   70,   72,  403,   68,
 /*  1060 */   669,  221,  288,  404,  406,  408,  147,  407,  411,  412,
 /*  1070 */   421,  413,  670,  414,  415,  416,  417,  422,  825,  418,
 /*  1080 */   671,  423,  570,  830,  831,  419,  437,  434,  439,  594,
 /*  1090 */   438,  440,  441,  443,  446,  442,  801,  802,  454,  449,
 /*  1100 */   211,  453,  729,  186,  730,  187,  457,  188,  824,  595,
 /*  1110 */   459,   33,  839,  452,  462,  464,  470,  463,  467,  468,
 /*  1120 */   841,  472,  475,  476,  477,  480,  483,  194,  842,  491,
 /*  1130 */   490,  492,  844,  196,  495,  496,  662,  498,  664,  499,
 /*  1140 */   501,  809,  502,  198,  504,  505,  850,  508,  509,  510,
 /*  1150 */   721,  199,  511,  513,  514,  516,  200,  515,  518,  724,
 /*  1160 */    71,  521,  520,  523,  522,  526,  202,  727,  530,  811,
 /*  1170 */   532,  533,  203,  812,  204,  813,  814,   73,  815,  540,
 /*  1180 */   818,  206,  820,  821,  819,  207,   75,  547,  208,  245,
 /*  1190 */   548,  816,  851,  558,  551,   76,  853,  544,  552,  553,
 /*  1200 */   854,  556,  561,  857,   77,   81,  242,  550,  240,   78,
 /*  1210 */   554,   92,  560,  223,  222,   79,   87,   80,   36,   15,
 /*  1220 */    38,  235,   84,  577,   99,   86,   39,  236,    8,  239,
 /*  1230 */   243,  238,   17,  217,  578,  573,  250,   89,  579,   19,
 /*  1240 */    93,  255,  257,   95,  258,   97,   21,   91,  260,  580,
 /*  1250 */   265,  261,  277,  100,   98,  269,  268,  270,  271,  106,
 /*  1260 */   275,  283,  286,  285,   50,  101,   25,  108,  107,   24,
 /*  1270 */   584,  109,   47,  292,  576,  302,  305,   10,   54,  514,
 /*  1280 */   307,   49,  514,  312,  514,  308,  514,  514,  514,  514,
 /*  1290 */   514,  514,  514,  330,  309,  514,  514,  514,  514,  514,
 /*  1300 */   514,  514,  310,  338,  514,  514,  514,  514,  514,  331,
 /*  1310 */   315,  334,  322,  514,  324,  514,  514,  514,  514,  514,
 /*  1320 */   335,  340,
};
static YYCODETYPE yy_lookahead[] = {
 /*     0 */    21,  199,   23,   68,   69,   70,   71,   72,   73,   74,
 /*    10 */    75,   76,   77,   78,   79,   80,   81,  199,   39,  131,
 /*    20 */   132,  133,  134,   44,   72,   73,   74,   75,   76,   77,
 /*    30 */    78,   79,   80,   81,   20,   20,   22,   58,   59,   60,
 /*    40 */    61,   62,   63,   64,   65,   66,   67,   68,   69,   70,
 /*    50 */    71,   72,   73,   74,   75,   76,   77,   78,   79,   80,
 /*    60 */    81,   88,   22,   39,   85,   92,   93,   94,   44,   76,
 /*    70 */    77,   78,   79,   80,   81,  155,  103,   78,   79,   80,
 /*    80 */    81,  161,   58,   59,   60,   61,   62,   63,   64,   65,
 /*    90 */    66,   67,   68,   69,   70,   71,   72,   73,   74,   75,
 /*   100 */    76,   77,   78,   79,   80,   81,   19,   23,   39,  138,
 /*   110 */    23,   53,   54,   44,  143,  135,  136,  146,  147,  139,
 /*   120 */   105,   97,  107,  108,  138,  145,    9,   58,   59,   60,
 /*   130 */    61,   62,   63,   64,   65,   66,   67,   68,   69,   70,
 /*   140 */    71,   72,   73,   74,   75,   76,   77,   78,   79,   80,
 /*   150 */    81,  171,  112,   60,    9,   15,  161,  162,  106,   20,
 /*   160 */    76,   77,  110,  168,   24,   21,   19,   23,   23,   85,
 /*   170 */    23,   87,   85,   86,   90,   91,  196,   37,   39,   23,
 /*   180 */    40,   88,   89,   44,   91,   92,   93,   94,   95,   96,
 /*   190 */   157,   51,  206,  207,  208,  102,  127,   58,   59,   60,
 /*   200 */    61,   62,   63,   64,   65,   66,   67,   68,   69,   70,
 /*   210 */    71,   72,   73,   74,   75,   76,   77,   78,   79,   80,
 /*   220 */    81,   23,  105,   39,  107,  108,   23,  101,   44,   85,
 /*   230 */    85,   86,   85,   86,   23,   87,  141,  111,   90,   60,
 /*   240 */    23,   85,   58,   59,   60,   61,   62,   63,   64,   65,
 /*   250 */    66,   67,   68,   69,   70,   71,   72,   73,   74,   75,
 /*   260 */    76,   77,   78,   79,   80,   81,  156,   14,   14,   20,
 /*   270 */    91,   92,   93,   94,   95,   96,   20,   33,   22,   76,
 /*   280 */    77,  102,   20,   85,   86,   41,   88,  138,   85,   86,
 /*   290 */    92,   93,   94,   39,   97,   78,   85,   86,   44,  204,
 /*   300 */    97,  103,   85,   86,   51,  210,  148,  158,    9,  151,
 /*   310 */   152,  127,   58,   59,   60,   61,   62,   63,   64,   65,
 /*   320 */    66,   67,   68,   69,   70,   71,   72,   73,   74,   75,
 /*   330 */    76,   77,   78,   79,   80,   81,   20,  138,  183,  184,
 /*   340 */   191,  192,    9,  138,   88,  146,  147,  145,   92,   93,
 /*   350 */    94,   98,   99,  100,  105,   39,  107,  108,    9,  103,
 /*   360 */    44,   20,  109,  158,  165,  166,  151,  105,   19,  107,
 /*   370 */   108,   19,   11,  171,   58,   59,   60,   61,   62,   63,
 /*   380 */    64,   65,   66,   67,   68,   69,   70,   71,   72,   73,
 /*   390 */    74,   75,   76,   77,   78,   79,   80,   81,  196,   23,
 /*   400 */    39,   45,    9,  198,  105,   44,  107,  108,   14,    9,
 /*   410 */    61,  153,    9,  211,   17,   12,   60,  145,  216,   58,
 /*   420 */    59,   60,   61,   62,   63,   64,   65,   66,   67,   68,
 /*   430 */    69,   70,   71,   72,   73,   74,   75,   76,   77,   78,
 /*   440 */    79,   80,   81,  171,  111,   39,  105,  153,  107,  108,
 /*   450 */    44,  138,   55,   97,   57,  183,  184,   20,  102,   22,
 /*   460 */   188,   85,   86,  111,   58,   59,   60,   61,   62,   63,
 /*   470 */    64,   65,   66,   67,   68,   69,   70,   71,   72,   73,
 /*   480 */    74,   75,   76,   77,   78,   79,   80,   81,   15,  113,
 /*   490 */   106,   17,  138,  109,   81,   18,    9,   24,  105,  145,
 /*   500 */   107,  108,   22,  138,  138,  105,  138,  107,  108,   20,
 /*   510 */    37,   22,  158,   40,   39,    9,   76,   77,  205,   44,
 /*   520 */   126,  138,  128,  158,  158,  171,  158,   87,   48,   55,
 /*   530 */     9,   57,  126,   58,   59,   60,   61,   62,   63,   64,
 /*   540 */    65,   66,   67,   68,   69,   70,   71,   72,   73,   74,
 /*   550 */    75,   76,   77,   78,   79,   80,   81,   23,    0,   39,
 /*   560 */   194,    9,  194,  109,   44,  200,   26,    9,   10,  203,
 /*   570 */    93,  203,   47,  190,   34,   86,  122,   20,   58,   59,
 /*   580 */    60,   61,   62,   63,   64,   65,   66,   67,   68,   69,
 /*   590 */    70,   71,   72,   73,   74,   75,   76,   77,   78,   79,
 /*   600 */    80,   81,  113,  129,   39,   23,  129,  120,   20,   44,
 /*   610 */    22,  105,  166,  107,  108,   98,   99,  100,   97,   85,
 /*   620 */    86,  166,   97,   58,   59,   60,   61,   62,   63,   64,
 /*   630 */    65,   66,   67,   68,   69,   70,   71,   72,   73,   74,
 /*   640 */    75,   76,   77,   78,   79,   80,   81,  113,  138,   39,
 /*   650 */     9,   98,   99,  100,   44,  154,  155,  105,  174,  107,
 /*   660 */   108,   21,  161,   22,  151,  181,   22,   85,  158,   59,
 /*   670 */    60,   61,   62,   63,   64,   65,   66,   67,   68,   69,
 /*   680 */    70,   71,   72,   73,   74,   75,   76,   77,   78,   79,
 /*   690 */    80,   81,   19,    9,   39,  182,   23,   45,  138,   44,
 /*   700 */    19,   22,  138,    9,   23,  123,   19,   23,   87,  138,
 /*   710 */    23,   90,  199,  203,  138,   60,   61,   62,   63,   64,
 /*   720 */    65,   66,   67,   68,   69,   70,   71,   72,   73,   74,
 /*   730 */    75,   76,   77,   78,   79,   80,   81,   50,  167,   25,
 /*   740 */   109,   97,   28,  167,   20,   46,   22,   60,   19,   97,
 /*   750 */    19,  111,   23,  122,  190,   39,  138,   43,   85,   86,
 /*   760 */    44,  120,  156,   76,   77,   86,   85,  138,  149,   85,
 /*   770 */    86,   84,   85,   86,   87,  145,  205,   90,   91,   50,
 /*   780 */   138,  205,   66,   67,  138,  167,  138,  158,  138,   60,
 /*   790 */    87,   19,  113,   90,   29,   23,  109,   20,  138,   22,
 /*   800 */    19,  171,  138,  145,  158,   76,   77,   91,  158,  167,
 /*   810 */   123,  124,  125,   84,   85,   86,   87,   52,  158,   90,
 /*   820 */    91,   19,   50,  205,  138,   97,  196,  198,   20,  171,
 /*   830 */    22,  167,   60,   19,    9,   10,   60,   23,  192,  111,
 /*   840 */   138,  211,  111,  195,  158,  138,  216,  205,   76,   77,
 /*   850 */    78,  138,  123,  124,  125,  126,   84,   85,   86,   87,
 /*   860 */   158,  138,   90,   91,   50,  158,  101,   91,  138,  205,
 /*   870 */    20,  158,   22,  138,   60,   19,  133,  134,   89,   23,
 /*   880 */    91,  158,   20,  138,   22,   91,   19,  138,  158,   58,
 /*   890 */    76,   77,   78,  158,  156,  123,  124,  125,   84,   85,
 /*   900 */    86,   87,  138,  158,   90,   91,   50,  158,  138,  145,
 /*   910 */    11,  138,   13,   14,   15,   16,   60,   20,   20,   22,
 /*   920 */    22,   20,  158,   22,    9,   20,   27,   22,  158,   11,
 /*   930 */   138,  158,   76,   77,   35,  171,  138,  123,  124,  125,
 /*   940 */    84,   85,   86,   87,  138,  138,   90,   91,   49,  138,
 /*   950 */    51,  145,  121,  138,  138,   56,  158,  145,  194,  156,
 /*   960 */    46,   46,  138,  145,  158,  158,  138,  203,  138,  158,
 /*   970 */   138,  138,  138,  158,  158,  138,  138,  171,  138,  123,
 /*   980 */   124,  125,  158,  171,  138,  138,  158,  195,  158,  171,
 /*   990 */   158,  158,  158,  138,   19,  158,  158,   98,   99,  100,
 /*  1000 */   194,  138,  138,  104,  158,  158,  138,  138,  109,  203,
 /*  1010 */   156,  138,  138,  158,   91,  138,  138,  151,  138,   95,
 /*  1020 */   138,  158,  158,  151,  138,  102,  158,  158,   19,  138,
 /*  1030 */   190,  158,  158,  145,  159,  158,  158,   20,  158,   22,
 /*  1040 */   158,   20,  138,   22,  126,   19,  138,   21,  182,  158,
 /*  1050 */   138,  102,  160,  199,  182,  138,  172,  109,  138,  171,
 /*  1060 */   109,  111,  158,  142,  138,   21,  158,  142,  138,  142,
 /*  1070 */   158,  212,  109,  213,   97,  138,  142,   38,   11,  214,
 /*  1080 */   109,   36,    9,   97,   97,  215,  129,   47,  142,  111,
 /*  1090 */   138,   97,  138,   19,  156,  142,    9,  129,  169,   11,
 /*  1100 */   126,  170,  121,  201,  121,  202,   14,   14,    9,  111,
 /*  1110 */     9,  138,   14,   58,  169,  101,  176,  138,  138,   61,
 /*  1120 */     9,   61,  121,  138,   19,  197,   19,   19,    9,  138,
 /*  1130 */   112,  176,    9,   20,  138,  142,    9,  138,    9,  142,
 /*  1140 */   138,    9,  142,   22,  138,  142,    9,  112,  138,  142,
 /*  1150 */     9,  138,  176,  169,  138,  101,   20,  142,  176,    9,
 /*  1160 */   171,  138,  121,  197,  142,   19,   22,    9,  138,    9,
 /*  1170 */   138,  142,  138,    9,   20,    9,    9,  173,    9,  209,
 /*  1180 */     9,   22,    9,    9,    9,  138,  175,  138,   20,  120,
 /*  1190 */    20,    9,    9,   32,  151,  176,    9,  209,   21,  138,
 /*  1200 */     9,  151,  138,    9,  177,  119,  117,  217,  118,  178,
 /*  1210 */   218,  115,  217,  142,  138,  179,  153,  180,  156,  137,
 /*  1220 */    31,  138,   87,    9,   96,   87,  170,  142,  137,  157,
 /*  1230 */   116,  193,  137,   22,    9,    9,  185,  153,    9,  137,
 /*  1240 */   116,  138,  138,   22,  113,  193,  140,  153,  138,    9,
 /*  1250 */   138,  142,   97,   23,  157,  187,  186,  114,   19,  111,
 /*  1260 */   138,   20,  187,  186,   42,  150,   20,  111,  138,  144,
 /*  1270 */     9,  138,  156,  111,    9,   20,  156,  138,   46,  219,
 /*  1280 */   138,  164,  219,  138,  219,  159,  219,  219,  219,  219,
 /*  1290 */   219,  219,  219,  193,  160,  219,  219,  219,  219,  219,
 /*  1300 */   219,  219,  162,  150,  219,  219,  219,  219,  219,  157,
 /*  1310 */   163,  193,  163,  219,  163,  219,  219,  219,  219,  219,
 /*  1320 */   157,  164,
};
#define YY_SHIFT_USE_DFLT (-66)
static short yy_shift_ofst[] = {
 /*     0 */   825,  558,  -66,  899,  694,  -66, 1073,  403, 1226,  145,
 /*    10 */  1265,  -66,  -66,  -66,  403, 1214,  403, 1225,  403, 1229,
 /*    20 */  1026, 1240,  211,   14, 1246, 1261,  198,  -66,  156,  -66,
 /*    30 */    93,  -66,  211,  179,  -66,  197,  -66, 1189,  140,  -66,
 /*    40 */   -66,  -66,  -66,  -66,  -66,  923,  197,  -66, 1222,  -66,
 /*    50 */   244,  -66,  -66, 1232,  540,  197,  -66,  -66,  -66,  197,
 /*    60 */   -66,  975,  856,  352,  814,  978,  998,  687,  -66,  262,
 /*    70 */   948,  -66,   52,  -66,   40, 1069, 1089, 1090, 1096, 1086,
 /*    80 */   -66,  440,  -66, 1135,  -66, 1138,  -66,  480,  440,  -66,
 /*    90 */   440,  -66, 1124,  856, 1221,  856, 1128,  540,  -66, 1230,
 /*   100 */   -66,  -66,  565,  856,  -66, 1148,  211, 1156,  211,  -66,
 /*   110 */   -66,  -66,  -66,  -66,  655,  856,  610,  856,  -48,  856,
 /*   120 */   -48,  856,  -48,  856,  -48,  856,  -65,  856,  -65,  856,
 /*   130 */    -7,  856,   -7,  856,   -7,  856,   -7,  856,  -65,  716,
 /*   140 */   856,  -65,  -66,  -66,  856,   -1,  856,   -1,  856,  413,
 /*   150 */   856,  413,  856,  413,  856,  -66,  -66,  776,  -66,  794,
 /*   160 */   -66,  -66,  856,  475,  856,  -65,   87,  687,  249,  384,
 /*   170 */   951,  963,  971,  -66,  565,  856,  655,  856,  -66,  856,
 /*   180 */   -66,  856,  -66,  729,  406,  974,  394, 1093,  -66,  856,
 /*   190 */   184,  856,  565, 1108,  473, 1113,  -66, 1121,  211, 1136,
 /*   200 */   -66, 1144,  211, 1154,  -66, 1159,  211, 1168,  -66,  856,
 /*   210 */   254,  856,   69,  856,  565,  862,  -66,  856,  -66,  -66,
 /*   220 */   950,  211,  -66,  -66,  -66,  856,  520,  856,  655,  673,
 /*   230 */   687,  341,  -66,  808,  -66,  950,  -66, 1128,  540,  -66,
 /*   240 */   856,  565, 1114,  856, 1211,  856,  565,  -66,  -66,  679,
 /*   250 */   -66,  -66,  -66,  534,  -66,  376,  -66, 1131,  -66,  147,
 /*   260 */   950,  144,  -66,  -66,  211,  -66,  -66, 1155, 1143,  -66,
 /*   270 */  1239,  211,  905,  -66,  211,  -66,  -66,  856,  565,  948,
 /*   280 */    15,  489, 1241,  144, 1155, 1143,  -66,  772,  -21,  -66,
 /*   290 */   -66, 1162,  217,  -66,  -66,  -66,  -66,  139,  -66,  588,
 /*   300 */   -66, 1255,  -66,  316,  197,  -66,  211, 1009,  -66,  652,
 /*   310 */   -66,  211,  -66,  553,  765,  -66,  789,  -66,  -66,  -66,
 /*   320 */   -66,  765,  -66,  765,  -66,  211,  898,  -66,  211, 1128,
 /*   330 */   540,  -66,  -66, 1128,  540,  -66,  -66, 1230,  -66, 1222,
 /*   340 */   -66,  -66,   84,  -66,  -66,  -66,  703,  -66,  -66,  148,
 /*   350 */   -66,  -66,  -66,  -66,  681,  440, 1017,  -66,  440,  557,
 /*   360 */   -66,  -66,  -66,  -66,  256,  -27,  -66,  211,  -66,  699,
 /*   370 */   781,  211,  897,  197,  -66,  802,  211,  724,  197,  -66,
 /*   380 */   856,   24,  -66,  914,  867,  211,  777,  924,  211, 1009,
 /*   390 */   -66,  356,  949,  -66,  -66,  -66,  -66,  -66,  948,  552,
 /*   400 */   477,  397,  211,  950,  -66,  211,  640, 1044,  948,  117,
 /*   410 */   211,  950,  714,  517,  977,  211,  950, 1039,  918, 1067,
 /*   420 */   856,  361, 1045,   58,  -66,  -66,  986,  987,  525,  211,
 /*   430 */   644,  -66,  -66, 1040,  -66,  -66,  957,  211,  728,  994,
 /*   440 */   211,  731, 1074,  211,  850,  521, 1087,  968, 1088,  253,
 /*   450 */   299,  831,  140,  -66,  981,  983, 1092, 1099, 1101,  253,
 /*   460 */  1098, 1055,  211, 1014,  211,  641,  211, 1058,  856,  565,
 /*   470 */  1111, 1060,  856,  565, 1001,  211, 1105,  211,  437,  -66,
 /*   480 */   454,  400, 1107,  856, 1021,  856,  565, 1119,  565, 1018,
 /*   490 */   211,  487, 1123,  474,  211,  333, 1127,  211,  333, 1129,
 /*   500 */   211,  333, 1132,  211,  333, 1137,  393, 1035,  211,  950,
 /*   510 */   487, 1141, 1055,  211,  126, 1054,  211,  641, 1150, 1041,
 /*   520 */   211,  950, 1105,  631,  506, 1146,  856,  901, 1158,  684,
 /*   530 */  1160,  211,  950,  349,  203, 1164, 1166, 1167, 1169,  621,
 /*   540 */  1171, 1173, 1174,  621, 1175,  -66,  211, 1170, 1182, 1161,
 /*   550 */   156, 1177,  211,  915, 1183,  582, 1187, 1191,  -66, 1161,
 /*   560 */   211, 1194,  -66,  -66,  -66,
};
#define YY_REDUCE_USE_DFLT (-199)
static short yy_reduce_ofst[] = {
 /*     0 */  -112,  743, -199,  -20, -199, -199, -199, 1091, -199, 1139,
 /*    10 */  -199, -199, -199, -199, 1082, -199, 1095, -199, 1102, -199,
 /*    20 */  1106, -199,  -29, 1125, -199, -199,  199, -199,  158,  619,
 /*    30 */   501, -199,  973,  -80, -199, 1062, -199, -199, 1056, -199,
 /*    40 */  -199, -199, -199, -199, -199, -199, 1116, -199, 1117, -199,
 /*    50 */  -199, -199, -199, -199,   33,  110, -199, -199, -199,  803,
 /*    60 */  -199, -199,  882, -199,  368, -199, -199,  354, -199,  884,
 /*    70 */   989, -199, 1004,  484, 1011, 1019, 1027, 1031, 1036, 1037,
 /*    80 */  -199, 1063, -199, -199, -199, -199, -199, -199, 1084, -199,
 /*    90 */  1094, -199, -199,  149, -199,  646, 1052, 1097, -199, 1115,
 /*   100 */  -199, -199, -182,  869, -199, -199, 1130, -199, 1133, -199,
 /*   110 */  -199, -199, -199, -199, -182,  723, -182,  745, -182,  811,
 /*   120 */  -182,  828, -182,  830, -182,  832, -182,  837, -182,  847,
 /*   130 */  -182,  868, -182,  880, -182,  730, -182,  807, -182, -198,
 /*   140 */   838, -182, -199, -199,  660, -182,  908, -182,  686, -182,
 /*   150 */   749, -182,  877, -182,  816, -182, -199, -199, -199, -199,
 /*   160 */  -199, -199,  864, -182,  650, -182,  917,  764,  884, -199,
 /*   170 */  -199, -199, -199, -199, -182,  770, -182,  834, -182,  891,
 /*   180 */  -182,  855, -182,  365, -182,  902,  903, -199, -199,  824,
 /*   190 */  -182,  702, -182, -199, -199, -199, -199, -199, 1013, -199,
 /*   200 */  -199, -199, 1034, -199, -199, -199, 1047, -199, -199,  863,
 /*   210 */  -182,  846, -182,  833, -182, -199, -199,  510, -199, -199,
 /*   220 */  1071, 1076, -199, -199, -199,  815, -182,  798, -182, 1083,
 /*   230 */   806,  884, -199, -199, -199, 1085, -199, 1038, 1072, -199,
 /*   240 */   713, -182, -199,  366, -199,  707, -182, -199,  155, 1051,
 /*   250 */  -199, -199, -199, 1103, -199, 1104, -199, -199, -199, 1110,
 /*   260 */  1109,  872, -199, -199, 1112, -199, -199, 1070, 1068, -199,
 /*   270 */  -199,  840, -199, -199, 1122, -199, -199,  873, -182,  272,
 /*   280 */   884, 1051, -199,  866, 1077, 1075, -199,  904,  513, -199,
 /*   290 */  -199, -199, 1130, -199, -199, -199, -199, -182, -199, -199,
 /*   300 */  -199, -199, -199, -182, 1120, -199, 1142, 1126, 1134, 1140,
 /*   310 */  -199, 1145, -199, -199, 1147, -199, -199, -199, -199, -199,
 /*   320 */  -199, 1149, -199, 1151, -199,  664, -199, -199,  313, 1100,
 /*   330 */  1152, -199, -199, 1118, 1163, -199, -199, 1153, -199, 1157,
 /*   340 */  -199, -199, -199, -199, -199, -199, -199, -199, -199, -199,
 /*   350 */  -199, -199, -199, -199,  215,  258, -199, -199,  294, -199,
 /*   360 */  -199, -199, -199, -199,  446,  455, -199,  560, -199, -199,
 /*   370 */  -199,  642, -199,  606, -199, -199,  571, -199,  738, -199,
 /*   380 */   874,  854, -199, -199, -199,  618, -199, -199,  886,  875,
 /*   390 */   892,   -5, -199, -199, -199, -199, -199, -199,  818,  884,
 /*   400 */    95, -199,  920,  921, -199,  926,  925, -199,  658,  884,
 /*   410 */   930,  927,  859,  860, -199,  937,  934,  865,  870, -199,
 /*   420 */   912, -182, -199, -199, -199, -199, -199, -199, -199,  564,
 /*   430 */  -199, -199, -199, -199, -199, -199, -199,  952,  946, -199,
 /*   440 */   954,  953, -199,  576, -199,  938, -199, -199, -199,  630,
 /*   450 */   884,  929,  931, -199, -199, -199, -199, -199, -199,  202,
 /*   460 */  -199,  945,  979, -199,  648,  940,  980, -199,  773, -182,
 /*   470 */  -199, -199,  735, -182, -199,  985,  928,  383, -199, -199,
 /*   480 */   888,  884, -199,  629, -199,  878, -182, -199, -182, -199,
 /*   490 */   991,  955, -199, -199,  996,  993, -199,  999,  997, -199,
 /*   500 */  1002, 1000, -199, 1006, 1003, -199,  884, -199, 1010, 1007,
 /*   510 */   976, -199,  984, 1016, 1015, -199,  792,  982, -199, -199,
 /*   520 */  1023, 1022,  966,  812,  884, -199,  205, -199, -199, 1030,
 /*   530 */  -199, 1032, 1029, -199,  -14, -199, -199, -199, -199,  970,
 /*   540 */  -199, -199, -199,  988, -199, -199, 1049, -199, -199,  990,
 /*   550 */  1043, -199, 1061,  992, -199, 1050, -199, -199, -199,  995,
 /*   560 */  1064, -199, -199, -199, -199,
};
static YYACTIONTYPE yy_default[] = {
 /*     0 */   572,  572,  566,  858,  858,  568,  858,  858,  858,  858,
 /*    10 */   858,  593,  594,  595,  858,  858,  858,  858,  858,  858,
 /*    20 */   858,  858,  858,  858,  858,  858,  858,  586,  596,  606,
 /*    30 */   588,  605,  858,  858,  607,  653,  618,  858,  858,  654,
 /*    40 */   657,  658,  659,  660,  661,  858,  653,  619,  638,  636,
 /*    50 */   858,  639,  640,  858,  710,  653,  620,  708,  709,  653,
 /*    60 */   621,  858,  858,  739,  800,  745,  740,  858,  666,  858,
 /*    70 */   858,  667,  675,  677,  684,  722,  713,  715,  703,  717,
 /*    80 */   672,  858,  602,  858,  603,  858,  604,  718,  858,  719,
 /*    90 */   858,  720,  858,  858,  704,  858,  711,  710,  705,  858,
 /*   100 */   590,  712,  707,  858,  738,  858,  858,  741,  858,  742,
 /*   110 */   743,  744,  746,  747,  750,  858,  751,  858,  752,  858,
 /*   120 */   753,  858,  754,  858,  755,  858,  756,  858,  757,  858,
 /*   130 */   758,  858,  759,  858,  760,  858,  761,  858,  762,  858,
 /*   140 */   858,  763,  764,  765,  858,  766,  858,  767,  858,  768,
 /*   150 */   858,  769,  858,  770,  858,  771,  772,  858,  773,  858,
 /*   160 */   776,  774,  858,  858,  858,  782,  858,  800,  858,  858,
 /*   170 */   858,  858,  858,  785,  799,  858,  777,  858,  778,  858,
 /*   180 */   779,  858,  780,  858,  858,  858,  858,  858,  790,  858,
 /*   190 */   858,  858,  791,  858,  858,  858,  846,  858,  858,  858,
 /*   200 */   847,  858,  858,  858,  848,  858,  858,  858,  849,  858,
 /*   210 */   858,  858,  858,  858,  792,  858,  784,  800,  797,  798,
 /*   220 */   692,  858,  693,  788,  775,  858,  858,  858,  783,  858,
 /*   230 */   800,  858,  787,  858,  786,  692,  789,  711,  710,  706,
 /*   240 */   858,  716,  858,  800,  714,  858,  723,  676,  687,  685,
 /*   250 */   686,  694,  695,  858,  696,  858,  697,  858,  698,  858,
 /*   260 */   692,  683,  591,  592,  858,  681,  682,  700,  702,  688,
 /*   270 */   858,  858,  858,  701,  858,  735,  736,  858,  699,  687,
 /*   280 */   858,  858,  858,  683,  700,  702,  689,  858,  683,  678,
 /*   290 */   679,  858,  858,  680,  673,  674,  781,  858,  737,  858,
 /*   300 */   748,  858,  749,  858,  653,  622,  858,  804,  626,  623,
 /*   310 */   627,  858,  628,  858,  858,  629,  858,  632,  633,  634,
 /*   320 */   635,  858,  630,  858,  631,  858,  858,  805,  858,  711,
 /*   330 */   710,  806,  808,  711,  710,  807,  624,  858,  625,  638,
 /*   340 */   637,  608,  858,  609,  610,  611,  858,  612,  615,  858,
 /*   350 */   613,  616,  614,  617,  597,  858,  858,  598,  858,  858,
 /*   360 */   599,  601,  600,  589,  858,  858,  643,  858,  646,  858,
 /*   370 */   858,  858,  858,  653,  647,  858,  858,  858,  653,  648,
 /*   380 */   858,  653,  649,  858,  858,  858,  858,  858,  858,  804,
 /*   390 */   626,  651,  858,  650,  652,  644,  645,  587,  858,  858,
 /*   400 */   583,  858,  858,  692,  581,  858,  858,  858,  858,  858,
 /*   410 */   858,  692,  829,  858,  858,  858,  692,  834,  858,  858,
 /*   420 */   858,  858,  858,  858,  835,  836,  858,  858,  858,  858,
 /*   430 */   858,  826,  827,  858,  828,  582,  858,  858,  858,  858,
 /*   440 */   858,  858,  858,  858,  858,  858,  858,  858,  858,  858,
 /*   450 */   858,  858,  858,  656,  858,  858,  858,  858,  858,  858,
 /*   460 */   858,  655,  858,  858,  858,  858,  858,  858,  858,  725,
 /*   470 */   858,  858,  858,  726,  858,  858,  733,  858,  858,  734,
 /*   480 */   858,  858,  858,  858,  858,  858,  731,  858,  732,  858,
 /*   490 */   858,  858,  858,  858,  858,  858,  858,  858,  858,  858,
 /*   500 */   858,  858,  858,  858,  858,  858,  858,  858,  858,  692,
 /*   510 */   858,  858,  655,  858,  858,  858,  858,  858,  858,  858,
 /*   520 */   858,  692,  733,  858,  858,  858,  858,  858,  858,  858,
 /*   530 */   858,  858,  692,  858,  823,  858,  858,  858,  858,  858,
 /*   540 */   858,  858,  858,  858,  858,  822,  858,  858,  858,  856,
 /*   550 */   858,  858,  858,  858,  858,  858,  858,  858,  855,  856,
 /*   560 */   858,  858,  569,  571,  567,
};
#define YY_SZ_ACTTAB (sizeof(yy_action)/sizeof(yy_action[0]))

/* The next table maps tokens into fallback tokens.  If a construct
** like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammer, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /* END_OF_FILE => nothing */
    0,  /*    ILLEGAL => nothing */
    0,  /*      SPACE => nothing */
    0,  /* UNCLOSED_STRING => nothing */
    0,  /*    COMMENT => nothing */
    0,  /*   FUNCTION => nothing */
    0,  /*     COLUMN => nothing */
    0,  /* AGG_FUNCTION => nothing */
    0,  /*       SEMI => nothing */
   23,  /*    EXPLAIN => ID */
   23,  /*      BEGIN => ID */
    0,  /* TRANSACTION => nothing */
    0,  /*     COMMIT => nothing */
   23,  /*        END => ID */
    0,  /*   ROLLBACK => nothing */
    0,  /*     CREATE => nothing */
    0,  /*      TABLE => nothing */
   23,  /*       TEMP => ID */
    0,  /*         LP => nothing */
    0,  /*         RP => nothing */
    0,  /*         AS => nothing */
    0,  /*      COMMA => nothing */
    0,  /*         ID => nothing */
   23,  /*      ABORT => ID */
   23,  /*      AFTER => ID */
   23,  /*        ASC => ID */
   23,  /*     ATTACH => ID */
   23,  /*     BEFORE => ID */
   23,  /*    CASCADE => ID */
   23,  /*    CLUSTER => ID */
   23,  /*   CONFLICT => ID */
   23,  /*   DATABASE => ID */
   23,  /*   DEFERRED => ID */
   23,  /*       DESC => ID */
   23,  /*     DETACH => ID */
   23,  /*       EACH => ID */
   23,  /*       FAIL => ID */
   23,  /*        FOR => ID */
   23,  /*       GLOB => ID */
   23,  /*     IGNORE => ID */
   23,  /*  IMMEDIATE => ID */
   23,  /*  INITIALLY => ID */
   23,  /*    INSTEAD => ID */
   23,  /*       LIKE => ID */
   23,  /*      MATCH => ID */
   23,  /*        KEY => ID */
   23,  /*         OF => ID */
   23,  /*     OFFSET => ID */
   23,  /*     PRAGMA => ID */
   23,  /*      RAISE => ID */
   23,  /*    REPLACE => ID */
   23,  /*   RESTRICT => ID */
   23,  /*        ROW => ID */
   23,  /*  STATEMENT => ID */
   23,  /*    TRIGGER => ID */
   23,  /*     VACUUM => ID */
   23,  /*       VIEW => ID */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*        NOT => nothing */
    0,  /*         EQ => nothing */
    0,  /*         NE => nothing */
    0,  /*     ISNULL => nothing */
    0,  /*    NOTNULL => nothing */
    0,  /*         IS => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         IN => nothing */
    0,  /*         GT => nothing */
    0,  /*         GE => nothing */
    0,  /*         LT => nothing */
    0,  /*         LE => nothing */
    0,  /*     BITAND => nothing */
    0,  /*      BITOR => nothing */
    0,  /*     LSHIFT => nothing */
    0,  /*     RSHIFT => nothing */
    0,  /*       PLUS => nothing */
    0,  /*      MINUS => nothing */
    0,  /*       STAR => nothing */
    0,  /*      SLASH => nothing */
    0,  /*        REM => nothing */
    0,  /*     CONCAT => nothing */
    0,  /*     UMINUS => nothing */
    0,  /*      UPLUS => nothing */
    0,  /*     BITNOT => nothing */
    0,  /*     STRING => nothing */
    0,  /*    JOIN_KW => nothing */
    0,  /*    INTEGER => nothing */
    0,  /* CONSTRAINT => nothing */
    0,  /*    DEFAULT => nothing */
    0,  /*      FLOAT => nothing */
    0,  /*       NULL => nothing */
    0,  /*    PRIMARY => nothing */
    0,  /*     UNIQUE => nothing */
    0,  /*      CHECK => nothing */
    0,  /* REFERENCES => nothing */
    0,  /*    COLLATE => nothing */
    0,  /*         ON => nothing */
    0,  /*     DELETE => nothing */
    0,  /*     UPDATE => nothing */
    0,  /*     INSERT => nothing */
    0,  /*        SET => nothing */
    0,  /* DEFERRABLE => nothing */
    0,  /*    FOREIGN => nothing */
    0,  /*       DROP => nothing */
    0,  /*      UNION => nothing */
    0,  /*        ALL => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*     EXCEPT => nothing */
    0,  /*     SELECT => nothing */
    0,  /*   DISTINCT => nothing */
    0,  /*        DOT => nothing */
    0,  /*       FROM => nothing */
    0,  /*       JOIN => nothing */
    0,  /*      USING => nothing */
    0,  /*      ORDER => nothing */
    0,  /*         BY => nothing */
    0,  /*      GROUP => nothing */
    0,  /*     HAVING => nothing */
    0,  /*      LIMIT => nothing */
    0,  /*      WHERE => nothing */
    0,  /*       INTO => nothing */
    0,  /*     VALUES => nothing */
    0,  /*       BLOB => nothing */
    0,  /*   VARIABLE => nothing */
    0,  /*       CASE => nothing */
    0,  /*       WHEN => nothing */
    0,  /*       THEN => nothing */
    0,  /*       ELSE => nothing */
    0,  /*      INDEX => nothing */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
*/
struct yyStackEntry {
  int stateno;       /* The state-number */
  int major;         /* The major token value.  This is the code
                     ** number for the token at this stack level */
  YYMINORTYPE minor; /* The user-supplied minor token value.  This
                     ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  int yyidx;                    /* Index of top element in stack */
  int yyerrcnt;                 /* Shifts left before out of the error */
  sqlite3ParserARG_SDECL                /* A place to hold %extra_argument */
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void sqlite3ParserTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *yyTokenName[] = { 
  "$",             "END_OF_FILE",   "ILLEGAL",       "SPACE",       
  "UNCLOSED_STRING",  "COMMENT",       "FUNCTION",      "COLUMN",      
  "AGG_FUNCTION",  "SEMI",          "EXPLAIN",       "BEGIN",       
  "TRANSACTION",   "COMMIT",        "END",           "ROLLBACK",    
  "CREATE",        "TABLE",         "TEMP",          "LP",          
  "RP",            "AS",            "COMMA",         "ID",          
  "ABORT",         "AFTER",         "ASC",           "ATTACH",      
  "BEFORE",        "CASCADE",       "CLUSTER",       "CONFLICT",    
  "DATABASE",      "DEFERRED",      "DESC",          "DETACH",      
  "EACH",          "FAIL",          "FOR",           "GLOB",        
  "IGNORE",        "IMMEDIATE",     "INITIALLY",     "INSTEAD",     
  "LIKE",          "MATCH",         "KEY",           "OF",          
  "OFFSET",        "PRAGMA",        "RAISE",         "REPLACE",     
  "RESTRICT",      "ROW",           "STATEMENT",     "TRIGGER",     
  "VACUUM",        "VIEW",          "OR",            "AND",         
  "NOT",           "EQ",            "NE",            "ISNULL",      
  "NOTNULL",       "IS",            "BETWEEN",       "IN",          
  "GT",            "GE",            "LT",            "LE",          
  "BITAND",        "BITOR",         "LSHIFT",        "RSHIFT",      
  "PLUS",          "MINUS",         "STAR",          "SLASH",       
  "REM",           "CONCAT",        "UMINUS",        "UPLUS",       
  "BITNOT",        "STRING",        "JOIN_KW",       "INTEGER",     
  "CONSTRAINT",    "DEFAULT",       "FLOAT",         "NULL",        
  "PRIMARY",       "UNIQUE",        "CHECK",         "REFERENCES",  
  "COLLATE",       "ON",            "DELETE",        "UPDATE",      
  "INSERT",        "SET",           "DEFERRABLE",    "FOREIGN",     
  "DROP",          "UNION",         "ALL",           "INTERSECT",   
  "EXCEPT",        "SELECT",        "DISTINCT",      "DOT",         
  "FROM",          "JOIN",          "USING",         "ORDER",       
  "BY",            "GROUP",         "HAVING",        "LIMIT",       
  "WHERE",         "INTO",          "VALUES",        "BLOB",        
  "VARIABLE",      "CASE",          "WHEN",          "THEN",        
  "ELSE",          "INDEX",         "error",         "input",       
  "cmdlist",       "ecmd",          "explain",       "cmdx",        
  "cmd",           "trans_opt",     "nm",            "create_table",
  "create_table_args",  "temp",          "dbnm",          "columnlist",  
  "conslist_opt",  "select",        "column",        "columnid",    
  "type",          "carglist",      "id",            "ids",         
  "typename",      "signed",        "carg",          "ccons",       
  "onconf",        "sortorder",     "expr",          "idxlist_opt", 
  "refargs",       "defer_subclause",  "refarg",        "refact",      
  "init_deferred_pred_opt",  "conslist",      "tcons",         "idxlist",     
  "defer_subclause_opt",  "orconf",        "resolvetype",   "oneselect",   
  "multiselect_op",  "distinct",      "selcollist",    "from",        
  "where_opt",     "groupby_opt",   "having_opt",    "orderby_opt", 
  "limit_opt",     "sclp",          "as",            "seltablist",  
  "stl_prefix",    "joinop",        "on_opt",        "using_opt",   
  "seltablist_paren",  "joinop2",       "inscollist",    "sortlist",    
  "sortitem",      "collate",       "exprlist",      "setlist",     
  "insert_cmd",    "inscollist_opt",  "itemlist",      "likeop",      
  "case_operand",  "case_exprlist",  "case_else",     "expritem",    
  "uniqueflag",    "idxitem",       "plus_num",      "minus_num",   
  "plus_opt",      "number",        "trigger_decl",  "trigger_cmd_list",
  "trigger_time",  "trigger_event",  "foreach_clause",  "when_clause", 
  "trigger_cmd",   "database_kw_opt",  "key_opt",     
};
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *yyRuleName[] = {
 /*   0 */ "input ::= cmdlist",
 /*   1 */ "cmdlist ::= cmdlist ecmd",
 /*   2 */ "cmdlist ::= ecmd",
 /*   3 */ "ecmd ::= explain cmdx SEMI",
 /*   4 */ "ecmd ::= SEMI",
 /*   5 */ "cmdx ::= cmd",
 /*   6 */ "explain ::= EXPLAIN",
 /*   7 */ "explain ::=",
 /*   8 */ "cmd ::= BEGIN trans_opt",
 /*   9 */ "trans_opt ::=",
 /*  10 */ "trans_opt ::= TRANSACTION",
 /*  11 */ "trans_opt ::= TRANSACTION nm",
 /*  12 */ "cmd ::= COMMIT trans_opt",
 /*  13 */ "cmd ::= END trans_opt",
 /*  14 */ "cmd ::= ROLLBACK trans_opt",
 /*  15 */ "cmd ::= create_table create_table_args",
 /*  16 */ "create_table ::= CREATE temp TABLE nm dbnm",
 /*  17 */ "temp ::= TEMP",
 /*  18 */ "temp ::=",
 /*  19 */ "create_table_args ::= LP columnlist conslist_opt RP",
 /*  20 */ "create_table_args ::= AS select",
 /*  21 */ "columnlist ::= columnlist COMMA column",
 /*  22 */ "columnlist ::= column",
 /*  23 */ "column ::= columnid type carglist",
 /*  24 */ "columnid ::= nm",
 /*  25 */ "id ::= ID",
 /*  26 */ "ids ::= ID",
 /*  27 */ "ids ::= STRING",
 /*  28 */ "nm ::= ID",
 /*  29 */ "nm ::= STRING",
 /*  30 */ "nm ::= JOIN_KW",
 /*  31 */ "type ::=",
 /*  32 */ "type ::= typename",
 /*  33 */ "type ::= typename LP signed RP",
 /*  34 */ "type ::= typename LP signed COMMA signed RP",
 /*  35 */ "typename ::= ids",
 /*  36 */ "typename ::= typename ids",
 /*  37 */ "signed ::= INTEGER",
 /*  38 */ "signed ::= PLUS INTEGER",
 /*  39 */ "signed ::= MINUS INTEGER",
 /*  40 */ "carglist ::= carglist carg",
 /*  41 */ "carglist ::=",
 /*  42 */ "carg ::= CONSTRAINT nm ccons",
 /*  43 */ "carg ::= ccons",
 /*  44 */ "carg ::= DEFAULT STRING",
 /*  45 */ "carg ::= DEFAULT ID",
 /*  46 */ "carg ::= DEFAULT INTEGER",
 /*  47 */ "carg ::= DEFAULT PLUS INTEGER",
 /*  48 */ "carg ::= DEFAULT MINUS INTEGER",
 /*  49 */ "carg ::= DEFAULT FLOAT",
 /*  50 */ "carg ::= DEFAULT PLUS FLOAT",
 /*  51 */ "carg ::= DEFAULT MINUS FLOAT",
 /*  52 */ "carg ::= DEFAULT NULL",
 /*  53 */ "ccons ::= NULL onconf",
 /*  54 */ "ccons ::= NOT NULL onconf",
 /*  55 */ "ccons ::= PRIMARY KEY sortorder onconf",
 /*  56 */ "ccons ::= UNIQUE onconf",
 /*  57 */ "ccons ::= CHECK LP expr RP onconf",
 /*  58 */ "ccons ::= REFERENCES nm idxlist_opt refargs",
 /*  59 */ "ccons ::= defer_subclause",
 /*  60 */ "ccons ::= COLLATE id",
 /*  61 */ "refargs ::=",
 /*  62 */ "refargs ::= refargs refarg",
 /*  63 */ "refarg ::= MATCH nm",
 /*  64 */ "refarg ::= ON DELETE refact",
 /*  65 */ "refarg ::= ON UPDATE refact",
 /*  66 */ "refarg ::= ON INSERT refact",
 /*  67 */ "refact ::= SET NULL",
 /*  68 */ "refact ::= SET DEFAULT",
 /*  69 */ "refact ::= CASCADE",
 /*  70 */ "refact ::= RESTRICT",
 /*  71 */ "defer_subclause ::= NOT DEFERRABLE init_deferred_pred_opt",
 /*  72 */ "defer_subclause ::= DEFERRABLE init_deferred_pred_opt",
 /*  73 */ "init_deferred_pred_opt ::=",
 /*  74 */ "init_deferred_pred_opt ::= INITIALLY DEFERRED",
 /*  75 */ "init_deferred_pred_opt ::= INITIALLY IMMEDIATE",
 /*  76 */ "conslist_opt ::=",
 /*  77 */ "conslist_opt ::= COMMA conslist",
 /*  78 */ "conslist ::= conslist COMMA tcons",
 /*  79 */ "conslist ::= conslist tcons",
 /*  80 */ "conslist ::= tcons",
 /*  81 */ "tcons ::= CONSTRAINT nm",
 /*  82 */ "tcons ::= PRIMARY KEY LP idxlist RP onconf",
 /*  83 */ "tcons ::= UNIQUE LP idxlist RP onconf",
 /*  84 */ "tcons ::= CHECK expr onconf",
 /*  85 */ "tcons ::= FOREIGN KEY LP idxlist RP REFERENCES nm idxlist_opt refargs defer_subclause_opt",
 /*  86 */ "defer_subclause_opt ::=",
 /*  87 */ "defer_subclause_opt ::= defer_subclause",
 /*  88 */ "onconf ::=",
 /*  89 */ "onconf ::= ON CONFLICT resolvetype",
 /*  90 */ "orconf ::=",
 /*  91 */ "orconf ::= OR resolvetype",
 /*  92 */ "resolvetype ::= ROLLBACK",
 /*  93 */ "resolvetype ::= ABORT",
 /*  94 */ "resolvetype ::= FAIL",
 /*  95 */ "resolvetype ::= IGNORE",
 /*  96 */ "resolvetype ::= REPLACE",
 /*  97 */ "cmd ::= DROP TABLE nm dbnm",
 /*  98 */ "cmd ::= CREATE temp VIEW nm dbnm AS select",
 /*  99 */ "cmd ::= DROP VIEW nm dbnm",
 /* 100 */ "cmd ::= select",
 /* 101 */ "select ::= oneselect",
 /* 102 */ "select ::= select multiselect_op oneselect",
 /* 103 */ "multiselect_op ::= UNION",
 /* 104 */ "multiselect_op ::= UNION ALL",
 /* 105 */ "multiselect_op ::= INTERSECT",
 /* 106 */ "multiselect_op ::= EXCEPT",
 /* 107 */ "oneselect ::= SELECT distinct selcollist from where_opt groupby_opt having_opt orderby_opt limit_opt",
 /* 108 */ "distinct ::= DISTINCT",
 /* 109 */ "distinct ::= ALL",
 /* 110 */ "distinct ::=",
 /* 111 */ "sclp ::= selcollist COMMA",
 /* 112 */ "sclp ::=",
 /* 113 */ "selcollist ::= sclp expr as",
 /* 114 */ "selcollist ::= sclp STAR",
 /* 115 */ "selcollist ::= sclp nm DOT STAR",
 /* 116 */ "as ::= AS nm",
 /* 117 */ "as ::= ids",
 /* 118 */ "as ::=",
 /* 119 */ "from ::=",
 /* 120 */ "from ::= FROM seltablist",
 /* 121 */ "stl_prefix ::= seltablist joinop",
 /* 122 */ "stl_prefix ::=",
 /* 123 */ "seltablist ::= stl_prefix nm dbnm as on_opt using_opt",
 /* 124 */ "seltablist ::= stl_prefix LP seltablist_paren RP as on_opt using_opt",
 /* 125 */ "seltablist_paren ::= select",
 /* 126 */ "seltablist_paren ::= seltablist",
 /* 127 */ "dbnm ::=",
 /* 128 */ "dbnm ::= DOT nm",
 /* 129 */ "joinop ::= COMMA",
 /* 130 */ "joinop ::= JOIN",
 /* 131 */ "joinop ::= JOIN_KW JOIN",
 /* 132 */ "joinop ::= JOIN_KW nm JOIN",
 /* 133 */ "joinop ::= JOIN_KW nm nm JOIN",
 /* 134 */ "on_opt ::= ON expr",
 /* 135 */ "on_opt ::=",
 /* 136 */ "using_opt ::= USING LP inscollist RP",
 /* 137 */ "using_opt ::=",
 /* 138 */ "orderby_opt ::=",
 /* 139 */ "orderby_opt ::= ORDER BY sortlist",
 /* 140 */ "sortlist ::= sortlist COMMA sortitem collate sortorder",
 /* 141 */ "sortlist ::= sortitem collate sortorder",
 /* 142 */ "sortitem ::= expr",
 /* 143 */ "sortorder ::= ASC",
 /* 144 */ "sortorder ::= DESC",
 /* 145 */ "sortorder ::=",
 /* 146 */ "collate ::=",
 /* 147 */ "collate ::= COLLATE id",
 /* 148 */ "groupby_opt ::=",
 /* 149 */ "groupby_opt ::= GROUP BY exprlist",
 /* 150 */ "having_opt ::=",
 /* 151 */ "having_opt ::= HAVING expr",
 /* 152 */ "limit_opt ::=",
 /* 153 */ "limit_opt ::= LIMIT signed",
 /* 154 */ "limit_opt ::= LIMIT signed OFFSET signed",
 /* 155 */ "limit_opt ::= LIMIT signed COMMA signed",
 /* 156 */ "cmd ::= DELETE FROM nm dbnm where_opt",
 /* 157 */ "where_opt ::=",
 /* 158 */ "where_opt ::= WHERE expr",
 /* 159 */ "cmd ::= UPDATE orconf nm dbnm SET setlist where_opt",
 /* 160 */ "setlist ::= setlist COMMA nm EQ expr",
 /* 161 */ "setlist ::= nm EQ expr",
 /* 162 */ "cmd ::= insert_cmd INTO nm dbnm inscollist_opt VALUES LP itemlist RP",
 /* 163 */ "cmd ::= insert_cmd INTO nm dbnm inscollist_opt select",
 /* 164 */ "insert_cmd ::= INSERT orconf",
 /* 165 */ "insert_cmd ::= REPLACE",
 /* 166 */ "itemlist ::= itemlist COMMA expr",
 /* 167 */ "itemlist ::= expr",
 /* 168 */ "inscollist_opt ::=",
 /* 169 */ "inscollist_opt ::= LP inscollist RP",
 /* 170 */ "inscollist ::= inscollist COMMA nm",
 /* 171 */ "inscollist ::= nm",
 /* 172 */ "expr ::= LP expr RP",
 /* 173 */ "expr ::= NULL",
 /* 174 */ "expr ::= ID",
 /* 175 */ "expr ::= JOIN_KW",
 /* 176 */ "expr ::= nm DOT nm",
 /* 177 */ "expr ::= nm DOT nm DOT nm",
 /* 178 */ "expr ::= INTEGER",
 /* 179 */ "expr ::= FLOAT",
 /* 180 */ "expr ::= STRING",
 /* 181 */ "expr ::= BLOB",
 /* 182 */ "expr ::= VARIABLE",
 /* 183 */ "expr ::= ID LP exprlist RP",
 /* 184 */ "expr ::= ID LP STAR RP",
 /* 185 */ "expr ::= expr AND expr",
 /* 186 */ "expr ::= expr OR expr",
 /* 187 */ "expr ::= expr LT expr",
 /* 188 */ "expr ::= expr GT expr",
 /* 189 */ "expr ::= expr LE expr",
 /* 190 */ "expr ::= expr GE expr",
 /* 191 */ "expr ::= expr NE expr",
 /* 192 */ "expr ::= expr EQ expr",
 /* 193 */ "expr ::= expr BITAND expr",
 /* 194 */ "expr ::= expr BITOR expr",
 /* 195 */ "expr ::= expr LSHIFT expr",
 /* 196 */ "expr ::= expr RSHIFT expr",
 /* 197 */ "expr ::= expr likeop expr",
 /* 198 */ "expr ::= expr NOT likeop expr",
 /* 199 */ "likeop ::= LIKE",
 /* 200 */ "likeop ::= GLOB",
 /* 201 */ "expr ::= expr PLUS expr",
 /* 202 */ "expr ::= expr MINUS expr",
 /* 203 */ "expr ::= expr STAR expr",
 /* 204 */ "expr ::= expr SLASH expr",
 /* 205 */ "expr ::= expr REM expr",
 /* 206 */ "expr ::= expr CONCAT expr",
 /* 207 */ "expr ::= expr ISNULL",
 /* 208 */ "expr ::= expr IS NULL",
 /* 209 */ "expr ::= expr NOTNULL",
 /* 210 */ "expr ::= expr NOT NULL",
 /* 211 */ "expr ::= expr IS NOT NULL",
 /* 212 */ "expr ::= NOT expr",
 /* 213 */ "expr ::= BITNOT expr",
 /* 214 */ "expr ::= MINUS expr",
 /* 215 */ "expr ::= PLUS expr",
 /* 216 */ "expr ::= LP select RP",
 /* 217 */ "expr ::= expr BETWEEN expr AND expr",
 /* 218 */ "expr ::= expr NOT BETWEEN expr AND expr",
 /* 219 */ "expr ::= expr IN LP exprlist RP",
 /* 220 */ "expr ::= expr IN LP select RP",
 /* 221 */ "expr ::= expr NOT IN LP exprlist RP",
 /* 222 */ "expr ::= expr NOT IN LP select RP",
 /* 223 */ "expr ::= expr IN nm dbnm",
 /* 224 */ "expr ::= expr NOT IN nm dbnm",
 /* 225 */ "expr ::= CASE case_operand case_exprlist case_else END",
 /* 226 */ "case_exprlist ::= case_exprlist WHEN expr THEN expr",
 /* 227 */ "case_exprlist ::= WHEN expr THEN expr",
 /* 228 */ "case_else ::= ELSE expr",
 /* 229 */ "case_else ::=",
 /* 230 */ "case_operand ::= expr",
 /* 231 */ "case_operand ::=",
 /* 232 */ "exprlist ::= exprlist COMMA expritem",
 /* 233 */ "exprlist ::= expritem",
 /* 234 */ "expritem ::= expr",
 /* 235 */ "expritem ::=",
 /* 236 */ "cmd ::= CREATE uniqueflag INDEX nm dbnm ON nm dbnm LP idxlist RP onconf",
 /* 237 */ "uniqueflag ::= UNIQUE",
 /* 238 */ "uniqueflag ::=",
 /* 239 */ "idxlist_opt ::=",
 /* 240 */ "idxlist_opt ::= LP idxlist RP",
 /* 241 */ "idxlist ::= idxlist COMMA idxitem collate sortorder",
 /* 242 */ "idxlist ::= idxitem collate sortorder",
 /* 243 */ "idxitem ::= nm",
 /* 244 */ "cmd ::= DROP INDEX nm dbnm",
 /* 245 */ "cmd ::= VACUUM",
 /* 246 */ "cmd ::= VACUUM nm",
 /* 247 */ "cmd ::= PRAGMA nm dbnm EQ nm",
 /* 248 */ "cmd ::= PRAGMA nm dbnm EQ ON",
 /* 249 */ "cmd ::= PRAGMA nm dbnm EQ plus_num",
 /* 250 */ "cmd ::= PRAGMA nm dbnm EQ minus_num",
 /* 251 */ "cmd ::= PRAGMA nm dbnm LP nm RP",
 /* 252 */ "cmd ::= PRAGMA nm dbnm",
 /* 253 */ "plus_num ::= plus_opt number",
 /* 254 */ "minus_num ::= MINUS number",
 /* 255 */ "number ::= INTEGER",
 /* 256 */ "number ::= FLOAT",
 /* 257 */ "plus_opt ::= PLUS",
 /* 258 */ "plus_opt ::=",
 /* 259 */ "cmd ::= CREATE trigger_decl BEGIN trigger_cmd_list END",
 /* 260 */ "trigger_decl ::= temp TRIGGER nm dbnm trigger_time trigger_event ON nm dbnm foreach_clause when_clause",
 /* 261 */ "trigger_time ::= BEFORE",
 /* 262 */ "trigger_time ::= AFTER",
 /* 263 */ "trigger_time ::= INSTEAD OF",
 /* 264 */ "trigger_time ::=",
 /* 265 */ "trigger_event ::= DELETE",
 /* 266 */ "trigger_event ::= INSERT",
 /* 267 */ "trigger_event ::= UPDATE",
 /* 268 */ "trigger_event ::= UPDATE OF inscollist",
 /* 269 */ "foreach_clause ::=",
 /* 270 */ "foreach_clause ::= FOR EACH ROW",
 /* 271 */ "foreach_clause ::= FOR EACH STATEMENT",
 /* 272 */ "when_clause ::=",
 /* 273 */ "when_clause ::= WHEN expr",
 /* 274 */ "trigger_cmd_list ::= trigger_cmd SEMI trigger_cmd_list",
 /* 275 */ "trigger_cmd_list ::=",
 /* 276 */ "trigger_cmd ::= UPDATE orconf nm SET setlist where_opt",
 /* 277 */ "trigger_cmd ::= insert_cmd INTO nm inscollist_opt VALUES LP itemlist RP",
 /* 278 */ "trigger_cmd ::= insert_cmd INTO nm inscollist_opt select",
 /* 279 */ "trigger_cmd ::= DELETE FROM nm where_opt",
 /* 280 */ "trigger_cmd ::= select",
 /* 281 */ "expr ::= RAISE LP IGNORE RP",
 /* 282 */ "expr ::= RAISE LP ROLLBACK COMMA nm RP",
 /* 283 */ "expr ::= RAISE LP ABORT COMMA nm RP",
 /* 284 */ "expr ::= RAISE LP FAIL COMMA nm RP",
 /* 285 */ "cmd ::= DROP TRIGGER nm dbnm",
 /* 286 */ "cmd ::= ATTACH database_kw_opt ids AS nm key_opt",
 /* 287 */ "key_opt ::=",
 /* 288 */ "key_opt ::= KEY ids",
 /* 289 */ "key_opt ::= KEY BLOB",
 /* 290 */ "database_kw_opt ::= DATABASE",
 /* 291 */ "database_kw_opt ::=",
 /* 292 */ "cmd ::= DETACH database_kw_opt nm",
};
#endif /* NDEBUG */

/*
** This function returns the symbolic name associated with a token
** value.
*/
const char *sqlite3ParserTokenName(int tokenType){
#ifndef NDEBUG
  if( tokenType>0 && tokenType<(sizeof(yyTokenName)/sizeof(yyTokenName[0])) ){
    return yyTokenName[tokenType];
  }else{
    return "Unknown";
  }
#else
  return "";
#endif
}

/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to sqlite3Parser and sqlite3ParserFree.
*/
void *sqlite3ParserAlloc(void *(*mallocProc)(size_t)){
  yyParser *pParser;
  pParser = (yyParser*)(*mallocProc)( (size_t)sizeof(yyParser) );
  if( pParser ){
    pParser->yyidx = -1;
  }
  return pParser;
}

/* The following function deletes the value associated with a
** symbol.  The symbol can be either a terminal or nonterminal.
** "yymajor" is the symbol code, and "yypminor" is a pointer to
** the value.
*/
static void yy_destructor(YYCODETYPE yymajor, YYMINORTYPE *yypminor){
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are not used
    ** inside the C code.
    */
    case 145:
    case 171:
    case 188:
#line 291 "parse.y"
{sqlite3SelectDelete((yypminor->yy375));}
#line 1249 "parse.c"
      break;
    case 158:
    case 176:
    case 178:
    case 186:
    case 192:
    case 203:
#line 538 "parse.y"
{sqlite3ExprDelete((yypminor->yy164));}
#line 1259 "parse.c"
      break;
    case 159:
    case 167:
    case 174:
    case 177:
    case 179:
    case 181:
    case 191:
    case 194:
    case 195:
    case 198:
    case 201:
#line 755 "parse.y"
{sqlite3ExprListDelete((yypminor->yy232));}
#line 1274 "parse.c"
      break;
    case 175:
    case 183:
    case 184:
#line 358 "parse.y"
{sqlite3SrcListDelete((yypminor->yy283));}
#line 1281 "parse.c"
      break;
    case 187:
    case 190:
    case 197:
#line 430 "parse.y"
{sqlite3IdListDelete((yypminor->yy246));}
#line 1288 "parse.c"
      break;
    case 211:
    case 216:
#line 847 "parse.y"
{sqlite3DeleteTriggerStep((yypminor->yy107));}
#line 1294 "parse.c"
      break;
    case 213:
#line 831 "parse.y"
{sqlite3IdListDelete((yypminor->yy414).b);}
#line 1299 "parse.c"
      break;
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
**
** Return the major token number for the symbol popped.
*/
static int yy_pop_parser_stack(yyParser *pParser){
  YYCODETYPE yymajor;
  yyStackEntry *yytos = &pParser->yystack[pParser->yyidx];

  if( pParser->yyidx<0 ) return 0;
#ifndef NDEBUG
  if( yyTraceFILE && pParser->yyidx>=0 ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yymajor = yytos->major;
  yy_destructor( yymajor, &yytos->minor);
  pParser->yyidx--;
  return yymajor;
}

/* 
** Deallocate and destroy a parser.  Destructors are all called for
** all stack elements before shutting the parser down.
**
** Inputs:
** <ul>
** <li>  A pointer to the parser.  This should be a pointer
**       obtained from sqlite3ParserAlloc.
** <li>  A pointer to a function used to reclaim memory obtained
**       from malloc.
** </ul>
*/
void sqlite3ParserFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
  yyParser *pParser = (yyParser*)p;
  if( pParser==0 ) return;
  while( pParser->yyidx>=0 ) yy_pop_parser_stack(pParser);
  (*freeProc)((void*)pParser);
}

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_shift_action(
  yyParser *pParser,        /* The parser */
  int iLookAhead            /* The look-ahead token */
){
  int i;
  int stateno = pParser->yystack[pParser->yyidx].stateno;
 
  /* if( pParser->yyidx<0 ) return YY_NO_ACTION;  */
  i = yy_shift_ofst[stateno];
  if( i==YY_SHIFT_USE_DFLT ){
    return yy_default[stateno];
  }
  if( iLookAhead==YYNOCODE ){
    return YY_NO_ACTION;
  }
  i += iLookAhead;
  if( i<0 || i>=YY_SZ_ACTTAB || yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
    int iFallback;            /* Fallback token */
    if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
           && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
           yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
      }
#endif
      return yy_find_shift_action(pParser, iFallback);
    }
#endif
    return yy_default[stateno];
  }else{
    return yy_action[i];
  }
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_reduce_action(
  yyParser *pParser,        /* The parser */
  int iLookAhead            /* The look-ahead token */
){
  int i;
  int stateno = pParser->yystack[pParser->yyidx].stateno;
 
  i = yy_reduce_ofst[stateno];
  if( i==YY_REDUCE_USE_DFLT ){
    return yy_default[stateno];
  }
  if( iLookAhead==YYNOCODE ){
    return YY_NO_ACTION;
  }
  i += iLookAhead;
  if( i<0 || i>=YY_SZ_ACTTAB || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }else{
    return yy_action[i];
  }
}

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  int yyNewState,               /* The new state to shift in */
  int yyMajor,                  /* The major token to shift in */
  YYMINORTYPE *yypMinor         /* Pointer ot the minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yyidx++;
  if( yypParser->yyidx>=YYSTACKDEPTH ){
     sqlite3ParserARG_FETCH;
     yypParser->yyidx--;
#ifndef NDEBUG
     if( yyTraceFILE ){
       fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
     }
#endif
     while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
     /* Here code is inserted which will execute if the parser
     ** stack every overflows */
     sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument var */
     return;
  }
  yytos = &yypParser->yystack[yypParser->yyidx];
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor = *yypMinor;
#ifndef NDEBUG
  if( yyTraceFILE && yypParser->yyidx>0 ){
    int i;
    fprintf(yyTraceFILE,"%sShift %d\n",yyTracePrompt,yyNewState);
    fprintf(yyTraceFILE,"%sStack:",yyTracePrompt);
    for(i=1; i<=yypParser->yyidx; i++)
      fprintf(yyTraceFILE," %s",yyTokenName[yypParser->yystack[i].major]);
    fprintf(yyTraceFILE,"\n");
  }
#endif
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static struct {
  YYCODETYPE lhs;         /* Symbol on the left-hand side of the rule */
  unsigned char nrhs;     /* Number of right-hand side symbols in the rule */
} yyRuleInfo[] = {
  { 131, 1 },
  { 132, 2 },
  { 132, 1 },
  { 133, 3 },
  { 133, 1 },
  { 135, 1 },
  { 134, 1 },
  { 134, 0 },
  { 136, 2 },
  { 137, 0 },
  { 137, 1 },
  { 137, 2 },
  { 136, 2 },
  { 136, 2 },
  { 136, 2 },
  { 136, 2 },
  { 139, 5 },
  { 141, 1 },
  { 141, 0 },
  { 140, 4 },
  { 140, 2 },
  { 143, 3 },
  { 143, 1 },
  { 146, 3 },
  { 147, 1 },
  { 150, 1 },
  { 151, 1 },
  { 151, 1 },
  { 138, 1 },
  { 138, 1 },
  { 138, 1 },
  { 148, 0 },
  { 148, 1 },
  { 148, 4 },
  { 148, 6 },
  { 152, 1 },
  { 152, 2 },
  { 153, 1 },
  { 153, 2 },
  { 153, 2 },
  { 149, 2 },
  { 149, 0 },
  { 154, 3 },
  { 154, 1 },
  { 154, 2 },
  { 154, 2 },
  { 154, 2 },
  { 154, 3 },
  { 154, 3 },
  { 154, 2 },
  { 154, 3 },
  { 154, 3 },
  { 154, 2 },
  { 155, 2 },
  { 155, 3 },
  { 155, 4 },
  { 155, 2 },
  { 155, 5 },
  { 155, 4 },
  { 155, 1 },
  { 155, 2 },
  { 160, 0 },
  { 160, 2 },
  { 162, 2 },
  { 162, 3 },
  { 162, 3 },
  { 162, 3 },
  { 163, 2 },
  { 163, 2 },
  { 163, 1 },
  { 163, 1 },
  { 161, 3 },
  { 161, 2 },
  { 164, 0 },
  { 164, 2 },
  { 164, 2 },
  { 144, 0 },
  { 144, 2 },
  { 165, 3 },
  { 165, 2 },
  { 165, 1 },
  { 166, 2 },
  { 166, 6 },
  { 166, 5 },
  { 166, 3 },
  { 166, 10 },
  { 168, 0 },
  { 168, 1 },
  { 156, 0 },
  { 156, 3 },
  { 169, 0 },
  { 169, 2 },
  { 170, 1 },
  { 170, 1 },
  { 170, 1 },
  { 170, 1 },
  { 170, 1 },
  { 136, 4 },
  { 136, 7 },
  { 136, 4 },
  { 136, 1 },
  { 145, 1 },
  { 145, 3 },
  { 172, 1 },
  { 172, 2 },
  { 172, 1 },
  { 172, 1 },
  { 171, 9 },
  { 173, 1 },
  { 173, 1 },
  { 173, 0 },
  { 181, 2 },
  { 181, 0 },
  { 174, 3 },
  { 174, 2 },
  { 174, 4 },
  { 182, 2 },
  { 182, 1 },
  { 182, 0 },
  { 175, 0 },
  { 175, 2 },
  { 184, 2 },
  { 184, 0 },
  { 183, 6 },
  { 183, 7 },
  { 188, 1 },
  { 188, 1 },
  { 142, 0 },
  { 142, 2 },
  { 185, 1 },
  { 185, 1 },
  { 185, 2 },
  { 185, 3 },
  { 185, 4 },
  { 186, 2 },
  { 186, 0 },
  { 187, 4 },
  { 187, 0 },
  { 179, 0 },
  { 179, 3 },
  { 191, 5 },
  { 191, 3 },
  { 192, 1 },
  { 157, 1 },
  { 157, 1 },
  { 157, 0 },
  { 193, 0 },
  { 193, 2 },
  { 177, 0 },
  { 177, 3 },
  { 178, 0 },
  { 178, 2 },
  { 180, 0 },
  { 180, 2 },
  { 180, 4 },
  { 180, 4 },
  { 136, 5 },
  { 176, 0 },
  { 176, 2 },
  { 136, 7 },
  { 195, 5 },
  { 195, 3 },
  { 136, 9 },
  { 136, 6 },
  { 196, 2 },
  { 196, 1 },
  { 198, 3 },
  { 198, 1 },
  { 197, 0 },
  { 197, 3 },
  { 190, 3 },
  { 190, 1 },
  { 158, 3 },
  { 158, 1 },
  { 158, 1 },
  { 158, 1 },
  { 158, 3 },
  { 158, 5 },
  { 158, 1 },
  { 158, 1 },
  { 158, 1 },
  { 158, 1 },
  { 158, 1 },
  { 158, 4 },
  { 158, 4 },
  { 158, 3 },
  { 158, 3 },
  { 158, 3 },
  { 158, 3 },
  { 158, 3 },
  { 158, 3 },
  { 158, 3 },
  { 158, 3 },
  { 158, 3 },
  { 158, 3 },
  { 158, 3 },
  { 158, 3 },
  { 158, 3 },
  { 158, 4 },
  { 199, 1 },
  { 199, 1 },
  { 158, 3 },
  { 158, 3 },
  { 158, 3 },
  { 158, 3 },
  { 158, 3 },
  { 158, 3 },
  { 158, 2 },
  { 158, 3 },
  { 158, 2 },
  { 158, 3 },
  { 158, 4 },
  { 158, 2 },
  { 158, 2 },
  { 158, 2 },
  { 158, 2 },
  { 158, 3 },
  { 158, 5 },
  { 158, 6 },
  { 158, 5 },
  { 158, 5 },
  { 158, 6 },
  { 158, 6 },
  { 158, 4 },
  { 158, 5 },
  { 158, 5 },
  { 201, 5 },
  { 201, 4 },
  { 202, 2 },
  { 202, 0 },
  { 200, 1 },
  { 200, 0 },
  { 194, 3 },
  { 194, 1 },
  { 203, 1 },
  { 203, 0 },
  { 136, 12 },
  { 204, 1 },
  { 204, 0 },
  { 159, 0 },
  { 159, 3 },
  { 167, 5 },
  { 167, 3 },
  { 205, 1 },
  { 136, 4 },
  { 136, 1 },
  { 136, 2 },
  { 136, 5 },
  { 136, 5 },
  { 136, 5 },
  { 136, 5 },
  { 136, 6 },
  { 136, 3 },
  { 206, 2 },
  { 207, 2 },
  { 209, 1 },
  { 209, 1 },
  { 208, 1 },
  { 208, 0 },
  { 136, 5 },
  { 210, 11 },
  { 212, 1 },
  { 212, 1 },
  { 212, 2 },
  { 212, 0 },
  { 213, 1 },
  { 213, 1 },
  { 213, 1 },
  { 213, 3 },
  { 214, 0 },
  { 214, 3 },
  { 214, 3 },
  { 215, 0 },
  { 215, 2 },
  { 211, 3 },
  { 211, 0 },
  { 216, 6 },
  { 216, 8 },
  { 216, 5 },
  { 216, 4 },
  { 216, 1 },
  { 158, 4 },
  { 158, 6 },
  { 158, 6 },
  { 158, 6 },
  { 136, 4 },
  { 136, 6 },
  { 218, 0 },
  { 218, 2 },
  { 218, 2 },
  { 217, 1 },
  { 217, 0 },
  { 136, 3 },
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
*/
static void yy_reduce(
  yyParser *yypParser,         /* The parser */
  int yyruleno                 /* Number of the rule by which to reduce */
){
  int yygoto;                     /* The next state */
  int yyact;                      /* The next action */
  YYMINORTYPE yygotominor;        /* The LHS of the rule reduced */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  sqlite3ParserARG_FETCH;
  yymsp = &yypParser->yystack[yypParser->yyidx];
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno>=0 
        && yyruleno<sizeof(yyRuleName)/sizeof(yyRuleName[0]) ){
    fprintf(yyTraceFILE, "%sReduce [%s].\n", yyTracePrompt,
      yyRuleName[yyruleno]);
  }
#endif /* NDEBUG */

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
      case 5:
#line 77 "parse.y"
{ sqlite3FinishCoding(pParse); }
#line 1807 "parse.c"
        break;
      case 6:
#line 78 "parse.y"
{ sqlite3BeginParse(pParse, 1); }
#line 1812 "parse.c"
        break;
      case 7:
#line 79 "parse.y"
{ sqlite3BeginParse(pParse, 0); }
#line 1817 "parse.c"
        break;
      case 8:
#line 84 "parse.y"
{sqlite3BeginTransaction(pParse);}
#line 1822 "parse.c"
        break;
      case 12:
      case 13:
#line 88 "parse.y"
{sqlite3CommitTransaction(pParse);}
#line 1828 "parse.c"
        break;
      case 14:
#line 90 "parse.y"
{sqlite3RollbackTransaction(pParse);}
#line 1833 "parse.c"
        break;
      case 16:
#line 95 "parse.y"
{
   sqlite3StartTable(pParse,&yymsp[-4].minor.yy0,&yymsp[-1].minor.yy318,&yymsp[0].minor.yy318,yymsp[-3].minor.yy424,0);
}
#line 1840 "parse.c"
        break;
      case 17:
      case 74:
      case 108:
#line 99 "parse.y"
{yygotominor.yy424 = 1;}
#line 1847 "parse.c"
        break;
      case 18:
      case 73:
      case 75:
      case 86:
      case 109:
      case 110:
#line 100 "parse.y"
{yygotominor.yy424 = 0;}
#line 1857 "parse.c"
        break;
      case 19:
#line 101 "parse.y"
{
  sqlite3EndTable(pParse,&yymsp[0].minor.yy0,0);
}
#line 1864 "parse.c"
        break;
      case 20:
#line 104 "parse.y"
{
  sqlite3EndTable(pParse,0,yymsp[0].minor.yy375);
  sqlite3SelectDelete(yymsp[0].minor.yy375);
}
#line 1872 "parse.c"
        break;
      case 24:
#line 116 "parse.y"
{sqlite3AddColumn(pParse,&yymsp[0].minor.yy318);}
#line 1877 "parse.c"
        break;
      case 25:
      case 26:
      case 27:
      case 28:
      case 29:
      case 30:
      case 255:
      case 256:
#line 122 "parse.y"
{yygotominor.yy318 = yymsp[0].minor.yy0;}
#line 1889 "parse.c"
        break;
      case 32:
#line 165 "parse.y"
{sqlite3AddColumnType(pParse,&yymsp[0].minor.yy318,&yymsp[0].minor.yy318);}
#line 1894 "parse.c"
        break;
      case 33:
#line 166 "parse.y"
{sqlite3AddColumnType(pParse,&yymsp[-3].minor.yy318,&yymsp[0].minor.yy0);}
#line 1899 "parse.c"
        break;
      case 34:
#line 168 "parse.y"
{sqlite3AddColumnType(pParse,&yymsp[-5].minor.yy318,&yymsp[0].minor.yy0);}
#line 1904 "parse.c"
        break;
      case 35:
      case 128:
      case 147:
      case 243:
      case 253:
      case 254:
#line 170 "parse.y"
{yygotominor.yy318 = yymsp[0].minor.yy318;}
#line 1914 "parse.c"
        break;
      case 36:
#line 171 "parse.y"
{yygotominor.yy318.z=yymsp[-1].minor.yy318.z; yygotominor.yy318.n=yymsp[-1].minor.yy318.n+Addr(yymsp[0].minor.yy318.z)-Addr(yymsp[-1].minor.yy318.z);}
#line 1919 "parse.c"
        break;
      case 37:
      case 38:
#line 173 "parse.y"
{ yygotominor.yy424 = atoi(yymsp[0].minor.yy0.z); }
#line 1925 "parse.c"
        break;
      case 39:
#line 175 "parse.y"
{ yygotominor.yy424 = -atoi(yymsp[0].minor.yy0.z); }
#line 1930 "parse.c"
        break;
      case 44:
      case 45:
      case 46:
      case 47:
      case 49:
      case 50:
#line 180 "parse.y"
{sqlite3AddDefaultValue(pParse,&yymsp[0].minor.yy0,0);}
#line 1940 "parse.c"
        break;
      case 48:
      case 51:
#line 184 "parse.y"
{sqlite3AddDefaultValue(pParse,&yymsp[0].minor.yy0,1);}
#line 1946 "parse.c"
        break;
      case 54:
#line 194 "parse.y"
{sqlite3AddNotNull(pParse, yymsp[0].minor.yy424);}
#line 1951 "parse.c"
        break;
      case 55:
#line 195 "parse.y"
{sqlite3AddPrimaryKey(pParse,0,yymsp[0].minor.yy424);}
#line 1956 "parse.c"
        break;
      case 56:
#line 196 "parse.y"
{sqlite3CreateIndex(pParse,0,0,0,0,yymsp[0].minor.yy424,0,0);}
#line 1961 "parse.c"
        break;
      case 58:
#line 199 "parse.y"
{sqlite3CreateForeignKey(pParse,0,&yymsp[-2].minor.yy318,yymsp[-1].minor.yy232,yymsp[0].minor.yy424);}
#line 1966 "parse.c"
        break;
      case 59:
#line 200 "parse.y"
{sqlite3DeferForeignKey(pParse,yymsp[0].minor.yy424);}
#line 1971 "parse.c"
        break;
      case 60:
#line 201 "parse.y"
{sqlite3AddCollateType(pParse, yymsp[0].minor.yy318.z, yymsp[0].minor.yy318.n);}
#line 1976 "parse.c"
        break;
      case 61:
#line 209 "parse.y"
{ yygotominor.yy424 = OE_Restrict * 0x010101; }
#line 1981 "parse.c"
        break;
      case 62:
#line 210 "parse.y"
{ yygotominor.yy424 = (yymsp[-1].minor.yy424 & yymsp[0].minor.yy299.mask) | yymsp[0].minor.yy299.value; }
#line 1986 "parse.c"
        break;
      case 63:
#line 212 "parse.y"
{ yygotominor.yy299.value = 0;     yygotominor.yy299.mask = 0x000000; }
#line 1991 "parse.c"
        break;
      case 64:
#line 213 "parse.y"
{ yygotominor.yy299.value = yymsp[0].minor.yy424;     yygotominor.yy299.mask = 0x0000ff; }
#line 1996 "parse.c"
        break;
      case 65:
#line 214 "parse.y"
{ yygotominor.yy299.value = yymsp[0].minor.yy424<<8;  yygotominor.yy299.mask = 0x00ff00; }
#line 2001 "parse.c"
        break;
      case 66:
#line 215 "parse.y"
{ yygotominor.yy299.value = yymsp[0].minor.yy424<<16; yygotominor.yy299.mask = 0xff0000; }
#line 2006 "parse.c"
        break;
      case 67:
#line 217 "parse.y"
{ yygotominor.yy424 = OE_SetNull; }
#line 2011 "parse.c"
        break;
      case 68:
#line 218 "parse.y"
{ yygotominor.yy424 = OE_SetDflt; }
#line 2016 "parse.c"
        break;
      case 69:
#line 219 "parse.y"
{ yygotominor.yy424 = OE_Cascade; }
#line 2021 "parse.c"
        break;
      case 70:
#line 220 "parse.y"
{ yygotominor.yy424 = OE_Restrict; }
#line 2026 "parse.c"
        break;
      case 71:
      case 72:
      case 87:
      case 164:
#line 222 "parse.y"
{yygotominor.yy424 = yymsp[0].minor.yy424;}
#line 2034 "parse.c"
        break;
      case 82:
#line 239 "parse.y"
{sqlite3AddPrimaryKey(pParse,yymsp[-2].minor.yy232,yymsp[0].minor.yy424);}
#line 2039 "parse.c"
        break;
      case 83:
#line 241 "parse.y"
{sqlite3CreateIndex(pParse,0,0,0,yymsp[-2].minor.yy232,yymsp[0].minor.yy424,0,0);}
#line 2044 "parse.c"
        break;
      case 85:
#line 244 "parse.y"
{
    sqlite3CreateForeignKey(pParse, yymsp[-6].minor.yy232, &yymsp[-3].minor.yy318, yymsp[-2].minor.yy232, yymsp[-1].minor.yy424);
    sqlite3DeferForeignKey(pParse, yymsp[0].minor.yy424);
}
#line 2052 "parse.c"
        break;
      case 88:
      case 90:
#line 258 "parse.y"
{ yygotominor.yy424 = OE_Default; }
#line 2058 "parse.c"
        break;
      case 89:
      case 91:
#line 259 "parse.y"
{ yygotominor.yy424 = yymsp[0].minor.yy424; }
#line 2064 "parse.c"
        break;
      case 92:
#line 262 "parse.y"
{ yygotominor.yy424 = OE_Rollback; }
#line 2069 "parse.c"
        break;
      case 93:
      case 237:
#line 263 "parse.y"
{ yygotominor.yy424 = OE_Abort; }
#line 2075 "parse.c"
        break;
      case 94:
#line 264 "parse.y"
{ yygotominor.yy424 = OE_Fail; }
#line 2080 "parse.c"
        break;
      case 95:
#line 265 "parse.y"
{ yygotominor.yy424 = OE_Ignore; }
#line 2085 "parse.c"
        break;
      case 96:
#line 266 "parse.y"
{ yygotominor.yy424 = OE_Replace; }
#line 2090 "parse.c"
        break;
      case 97:
#line 270 "parse.y"
{
  sqlite3DropTable(pParse, sqlite3SrcListAppend(0,&yymsp[-1].minor.yy318,&yymsp[0].minor.yy318), 0);
}
#line 2097 "parse.c"
        break;
      case 98:
#line 276 "parse.y"
{
  sqlite3CreateView(pParse, &yymsp[-6].minor.yy0, &yymsp[-3].minor.yy318, &yymsp[-2].minor.yy318, yymsp[0].minor.yy375, yymsp[-5].minor.yy424);
}
#line 2104 "parse.c"
        break;
      case 99:
#line 279 "parse.y"
{
  sqlite3DropTable(pParse, sqlite3SrcListAppend(0,&yymsp[-1].minor.yy318,&yymsp[0].minor.yy318), 1);
}
#line 2111 "parse.c"
        break;
      case 100:
#line 285 "parse.y"
{
  sqlite3Select(pParse, yymsp[0].minor.yy375, SRT_Callback, 0, 0, 0, 0, 0);
  sqlite3SelectDelete(yymsp[0].minor.yy375);
}
#line 2119 "parse.c"
        break;
      case 101:
      case 125:
#line 295 "parse.y"
{yygotominor.yy375 = yymsp[0].minor.yy375;}
#line 2125 "parse.c"
        break;
      case 102:
#line 296 "parse.y"
{
  if( yymsp[0].minor.yy375 ){
    yymsp[0].minor.yy375->op = yymsp[-1].minor.yy424;
    yymsp[0].minor.yy375->pPrior = yymsp[-2].minor.yy375;
  }
  yygotominor.yy375 = yymsp[0].minor.yy375;
}
#line 2136 "parse.c"
        break;
      case 103:
#line 304 "parse.y"
{yygotominor.yy424 = TK_UNION;}
#line 2141 "parse.c"
        break;
      case 104:
#line 305 "parse.y"
{yygotominor.yy424 = TK_ALL;}
#line 2146 "parse.c"
        break;
      case 105:
#line 306 "parse.y"
{yygotominor.yy424 = TK_INTERSECT;}
#line 2151 "parse.c"
        break;
      case 106:
#line 307 "parse.y"
{yygotominor.yy424 = TK_EXCEPT;}
#line 2156 "parse.c"
        break;
      case 107:
#line 309 "parse.y"
{
  yygotominor.yy375 = sqlite3SelectNew(yymsp[-6].minor.yy232,yymsp[-5].minor.yy283,yymsp[-4].minor.yy164,yymsp[-3].minor.yy232,yymsp[-2].minor.yy164,yymsp[-1].minor.yy232,yymsp[-7].minor.yy424,yymsp[0].minor.yy22.limit,yymsp[0].minor.yy22.offset);
}
#line 2163 "parse.c"
        break;
      case 111:
      case 240:
#line 330 "parse.y"
{yygotominor.yy232 = yymsp[-1].minor.yy232;}
#line 2169 "parse.c"
        break;
      case 112:
      case 138:
      case 148:
      case 239:
#line 331 "parse.y"
{yygotominor.yy232 = 0;}
#line 2177 "parse.c"
        break;
      case 113:
#line 332 "parse.y"
{
   yygotominor.yy232 = sqlite3ExprListAppend(yymsp[-2].minor.yy232,yymsp[-1].minor.yy164,yymsp[0].minor.yy318.n?&yymsp[0].minor.yy318:0);
}
#line 2184 "parse.c"
        break;
      case 114:
#line 335 "parse.y"
{
  yygotominor.yy232 = sqlite3ExprListAppend(yymsp[-1].minor.yy232, sqlite3Expr(TK_ALL, 0, 0, 0), 0);
}
#line 2191 "parse.c"
        break;
      case 115:
#line 338 "parse.y"
{
  Expr *pRight = sqlite3Expr(TK_ALL, 0, 0, 0);
  Expr *pLeft = sqlite3Expr(TK_ID, 0, 0, &yymsp[-2].minor.yy318);
  yygotominor.yy232 = sqlite3ExprListAppend(yymsp[-3].minor.yy232, sqlite3Expr(TK_DOT, pLeft, pRight, 0), 0);
}
#line 2200 "parse.c"
        break;
      case 116:
      case 117:
#line 348 "parse.y"
{ yygotominor.yy318 = yymsp[0].minor.yy318; }
#line 2206 "parse.c"
        break;
      case 118:
#line 350 "parse.y"
{ yygotominor.yy318.n = 0; }
#line 2211 "parse.c"
        break;
      case 119:
#line 362 "parse.y"
{yygotominor.yy283 = sqliteMalloc(sizeof(*yygotominor.yy283));}
#line 2216 "parse.c"
        break;
      case 120:
#line 363 "parse.y"
{yygotominor.yy283 = yymsp[0].minor.yy283;}
#line 2221 "parse.c"
        break;
      case 121:
#line 368 "parse.y"
{
   yygotominor.yy283 = yymsp[-1].minor.yy283;
   if( yygotominor.yy283 && yygotominor.yy283->nSrc>0 ) yygotominor.yy283->a[yygotominor.yy283->nSrc-1].jointype = yymsp[0].minor.yy424;
}
#line 2229 "parse.c"
        break;
      case 122:
#line 372 "parse.y"
{yygotominor.yy283 = 0;}
#line 2234 "parse.c"
        break;
      case 123:
#line 373 "parse.y"
{
  yygotominor.yy283 = sqlite3SrcListAppend(yymsp[-5].minor.yy283,&yymsp[-4].minor.yy318,&yymsp[-3].minor.yy318);
  if( yymsp[-2].minor.yy318.n ) sqlite3SrcListAddAlias(yygotominor.yy283,&yymsp[-2].minor.yy318);
  if( yymsp[-1].minor.yy164 ){
    if( yygotominor.yy283 && yygotominor.yy283->nSrc>1 ){ yygotominor.yy283->a[yygotominor.yy283->nSrc-2].pOn = yymsp[-1].minor.yy164; }
    else { sqlite3ExprDelete(yymsp[-1].minor.yy164); }
  }
  if( yymsp[0].minor.yy246 ){
    if( yygotominor.yy283 && yygotominor.yy283->nSrc>1 ){ yygotominor.yy283->a[yygotominor.yy283->nSrc-2].pUsing = yymsp[0].minor.yy246; }
    else { sqlite3IdListDelete(yymsp[0].minor.yy246); }
  }
}
#line 2250 "parse.c"
        break;
      case 124:
#line 386 "parse.y"
{
  yygotominor.yy283 = sqlite3SrcListAppend(yymsp[-6].minor.yy283,0,0);
  yygotominor.yy283->a[yygotominor.yy283->nSrc-1].pSelect = yymsp[-4].minor.yy375;
  if( yymsp[-2].minor.yy318.n ) sqlite3SrcListAddAlias(yygotominor.yy283,&yymsp[-2].minor.yy318);
  if( yymsp[-1].minor.yy164 ){
    if( yygotominor.yy283 && yygotominor.yy283->nSrc>1 ){ yygotominor.yy283->a[yygotominor.yy283->nSrc-2].pOn = yymsp[-1].minor.yy164; }
    else { sqlite3ExprDelete(yymsp[-1].minor.yy164); }
  }
  if( yymsp[0].minor.yy246 ){
    if( yygotominor.yy283 && yygotominor.yy283->nSrc>1 ){ yygotominor.yy283->a[yygotominor.yy283->nSrc-2].pUsing = yymsp[0].minor.yy246; }
    else { sqlite3IdListDelete(yymsp[0].minor.yy246); }
  }
}
#line 2267 "parse.c"
        break;
      case 126:
#line 407 "parse.y"
{
   yygotominor.yy375 = sqlite3SelectNew(0,yymsp[0].minor.yy283,0,0,0,0,0,-1,0);
}
#line 2274 "parse.c"
        break;
      case 127:
#line 412 "parse.y"
{yygotominor.yy318.z=0; yygotominor.yy318.n=0;}
#line 2279 "parse.c"
        break;
      case 129:
      case 130:
#line 417 "parse.y"
{ yygotominor.yy424 = JT_INNER; }
#line 2285 "parse.c"
        break;
      case 131:
#line 419 "parse.y"
{ yygotominor.yy424 = sqlite3JoinType(pParse,&yymsp[-1].minor.yy0,0,0); }
#line 2290 "parse.c"
        break;
      case 132:
#line 420 "parse.y"
{ yygotominor.yy424 = sqlite3JoinType(pParse,&yymsp[-2].minor.yy0,&yymsp[-1].minor.yy318,0); }
#line 2295 "parse.c"
        break;
      case 133:
#line 422 "parse.y"
{ yygotominor.yy424 = sqlite3JoinType(pParse,&yymsp[-3].minor.yy0,&yymsp[-2].minor.yy318,&yymsp[-1].minor.yy318); }
#line 2300 "parse.c"
        break;
      case 134:
      case 142:
      case 151:
      case 158:
      case 228:
      case 230:
      case 234:
#line 426 "parse.y"
{yygotominor.yy164 = yymsp[0].minor.yy164;}
#line 2311 "parse.c"
        break;
      case 135:
      case 150:
      case 157:
      case 229:
      case 231:
      case 235:
#line 427 "parse.y"
{yygotominor.yy164 = 0;}
#line 2321 "parse.c"
        break;
      case 136:
      case 169:
#line 431 "parse.y"
{yygotominor.yy246 = yymsp[-1].minor.yy246;}
#line 2327 "parse.c"
        break;
      case 137:
      case 168:
#line 432 "parse.y"
{yygotominor.yy246 = 0;}
#line 2333 "parse.c"
        break;
      case 139:
      case 149:
#line 443 "parse.y"
{yygotominor.yy232 = yymsp[0].minor.yy232;}
#line 2339 "parse.c"
        break;
      case 140:
#line 444 "parse.y"
{
  yygotominor.yy232 = sqlite3ExprListAppend(yymsp[-4].minor.yy232,yymsp[-2].minor.yy164,yymsp[-1].minor.yy318.n>0?&yymsp[-1].minor.yy318:0);
  if( yygotominor.yy232 ) yygotominor.yy232->a[yygotominor.yy232->nExpr-1].sortOrder = yymsp[0].minor.yy424;
}
#line 2347 "parse.c"
        break;
      case 141:
#line 448 "parse.y"
{
  yygotominor.yy232 = sqlite3ExprListAppend(0,yymsp[-2].minor.yy164,yymsp[-1].minor.yy318.n>0?&yymsp[-1].minor.yy318:0);
  if( yygotominor.yy232 && yygotominor.yy232->a ) yygotominor.yy232->a[0].sortOrder = yymsp[0].minor.yy424;
}
#line 2355 "parse.c"
        break;
      case 143:
      case 145:
#line 457 "parse.y"
{yygotominor.yy424 = SQLITE_SO_ASC;}
#line 2361 "parse.c"
        break;
      case 144:
#line 458 "parse.y"
{yygotominor.yy424 = SQLITE_SO_DESC;}
#line 2366 "parse.c"
        break;
      case 146:
#line 460 "parse.y"
{yygotominor.yy318.z = 0; yygotominor.yy318.n = 0;}
#line 2371 "parse.c"
        break;
      case 152:
#line 474 "parse.y"
{yygotominor.yy22.limit = -1; yygotominor.yy22.offset = 0;}
#line 2376 "parse.c"
        break;
      case 153:
#line 475 "parse.y"
{yygotominor.yy22.limit = yymsp[0].minor.yy424; yygotominor.yy22.offset = 0;}
#line 2381 "parse.c"
        break;
      case 154:
#line 477 "parse.y"
{yygotominor.yy22.limit = yymsp[-2].minor.yy424; yygotominor.yy22.offset = yymsp[0].minor.yy424;}
#line 2386 "parse.c"
        break;
      case 155:
#line 479 "parse.y"
{yygotominor.yy22.limit = yymsp[0].minor.yy424; yygotominor.yy22.offset = yymsp[-2].minor.yy424;}
#line 2391 "parse.c"
        break;
      case 156:
#line 483 "parse.y"
{
   sqlite3DeleteFrom(pParse, sqlite3SrcListAppend(0,&yymsp[-2].minor.yy318,&yymsp[-1].minor.yy318), yymsp[0].minor.yy164);
}
#line 2398 "parse.c"
        break;
      case 159:
#line 499 "parse.y"
{sqlite3Update(pParse,sqlite3SrcListAppend(0,&yymsp[-4].minor.yy318,&yymsp[-3].minor.yy318),yymsp[-1].minor.yy232,yymsp[0].minor.yy164,yymsp[-5].minor.yy424);}
#line 2403 "parse.c"
        break;
      case 160:
#line 502 "parse.y"
{yygotominor.yy232 = sqlite3ExprListAppend(yymsp[-4].minor.yy232,yymsp[0].minor.yy164,&yymsp[-2].minor.yy318);}
#line 2408 "parse.c"
        break;
      case 161:
#line 503 "parse.y"
{yygotominor.yy232 = sqlite3ExprListAppend(0,yymsp[0].minor.yy164,&yymsp[-2].minor.yy318);}
#line 2413 "parse.c"
        break;
      case 162:
#line 509 "parse.y"
{sqlite3Insert(pParse, sqlite3SrcListAppend(0,&yymsp[-6].minor.yy318,&yymsp[-5].minor.yy318), yymsp[-1].minor.yy232, 0, yymsp[-4].minor.yy246, yymsp[-8].minor.yy424);}
#line 2418 "parse.c"
        break;
      case 163:
#line 511 "parse.y"
{sqlite3Insert(pParse, sqlite3SrcListAppend(0,&yymsp[-3].minor.yy318,&yymsp[-2].minor.yy318), 0, yymsp[0].minor.yy375, yymsp[-1].minor.yy246, yymsp[-5].minor.yy424);}
#line 2423 "parse.c"
        break;
      case 165:
#line 515 "parse.y"
{yygotominor.yy424 = OE_Replace;}
#line 2428 "parse.c"
        break;
      case 166:
      case 232:
#line 521 "parse.y"
{yygotominor.yy232 = sqlite3ExprListAppend(yymsp[-2].minor.yy232,yymsp[0].minor.yy164,0);}
#line 2434 "parse.c"
        break;
      case 167:
      case 233:
#line 522 "parse.y"
{yygotominor.yy232 = sqlite3ExprListAppend(0,yymsp[0].minor.yy164,0);}
#line 2440 "parse.c"
        break;
      case 170:
#line 531 "parse.y"
{yygotominor.yy246 = sqlite3IdListAppend(yymsp[-2].minor.yy246,&yymsp[0].minor.yy318);}
#line 2445 "parse.c"
        break;
      case 171:
#line 532 "parse.y"
{yygotominor.yy246 = sqlite3IdListAppend(0,&yymsp[0].minor.yy318);}
#line 2450 "parse.c"
        break;
      case 172:
#line 540 "parse.y"
{yygotominor.yy164 = yymsp[-1].minor.yy164; sqlite3ExprSpan(yygotominor.yy164,&yymsp[-2].minor.yy0,&yymsp[0].minor.yy0); }
#line 2455 "parse.c"
        break;
      case 173:
      case 178:
      case 179:
      case 180:
      case 181:
#line 541 "parse.y"
{yygotominor.yy164 = sqlite3Expr(yymsp[0].major, 0, 0, &yymsp[0].minor.yy0);}
#line 2464 "parse.c"
        break;
      case 174:
      case 175:
#line 542 "parse.y"
{yygotominor.yy164 = sqlite3Expr(TK_ID, 0, 0, &yymsp[0].minor.yy0);}
#line 2470 "parse.c"
        break;
      case 176:
#line 544 "parse.y"
{
  Expr *temp1 = sqlite3Expr(TK_ID, 0, 0, &yymsp[-2].minor.yy318);
  Expr *temp2 = sqlite3Expr(TK_ID, 0, 0, &yymsp[0].minor.yy318);
  yygotominor.yy164 = sqlite3Expr(TK_DOT, temp1, temp2, 0);
}
#line 2479 "parse.c"
        break;
      case 177:
#line 549 "parse.y"
{
  Expr *temp1 = sqlite3Expr(TK_ID, 0, 0, &yymsp[-4].minor.yy318);
  Expr *temp2 = sqlite3Expr(TK_ID, 0, 0, &yymsp[-2].minor.yy318);
  Expr *temp3 = sqlite3Expr(TK_ID, 0, 0, &yymsp[0].minor.yy318);
  Expr *temp4 = sqlite3Expr(TK_DOT, temp2, temp3, 0);
  yygotominor.yy164 = sqlite3Expr(TK_DOT, temp1, temp4, 0);
}
#line 2490 "parse.c"
        break;
      case 182:
#line 560 "parse.y"
{
  Token *pToken = &yymsp[0].minor.yy0;
  Expr *pExpr = yygotominor.yy164 = sqlite3Expr(TK_VARIABLE, 0, 0, pToken);
  if( pExpr ){
    pExpr->iTable = ++pParse->nVar;
  }
}
#line 2501 "parse.c"
        break;
      case 183:
#line 567 "parse.y"
{
  yygotominor.yy164 = sqlite3ExprFunction(yymsp[-1].minor.yy232, &yymsp[-3].minor.yy0);
  sqlite3ExprSpan(yygotominor.yy164,&yymsp[-3].minor.yy0,&yymsp[0].minor.yy0);
}
#line 2509 "parse.c"
        break;
      case 184:
#line 571 "parse.y"
{
  yygotominor.yy164 = sqlite3ExprFunction(0, &yymsp[-3].minor.yy0);
  sqlite3ExprSpan(yygotominor.yy164,&yymsp[-3].minor.yy0,&yymsp[0].minor.yy0);
}
#line 2517 "parse.c"
        break;
      case 185:
      case 186:
      case 187:
      case 188:
      case 189:
      case 190:
      case 191:
      case 192:
      case 193:
      case 194:
      case 195:
      case 196:
      case 201:
      case 202:
      case 203:
      case 204:
      case 205:
      case 206:
#line 575 "parse.y"
{yygotominor.yy164 = sqlite3Expr(yymsp[-1].major, yymsp[-2].minor.yy164, yymsp[0].minor.yy164, 0);}
#line 2539 "parse.c"
        break;
      case 197:
#line 587 "parse.y"
{
  ExprList *pList = sqlite3ExprListAppend(0, yymsp[0].minor.yy164, 0);
  pList = sqlite3ExprListAppend(pList, yymsp[-2].minor.yy164, 0);
  yygotominor.yy164 = sqlite3ExprFunction(pList, 0);
  if( yygotominor.yy164 ) yygotominor.yy164->op = yymsp[-1].minor.yy424;
  sqlite3ExprSpan(yygotominor.yy164, &yymsp[-2].minor.yy164->span, &yymsp[0].minor.yy164->span);
}
#line 2550 "parse.c"
        break;
      case 198:
#line 594 "parse.y"
{
  ExprList *pList = sqlite3ExprListAppend(0, yymsp[0].minor.yy164, 0);
  pList = sqlite3ExprListAppend(pList, yymsp[-3].minor.yy164, 0);
  yygotominor.yy164 = sqlite3ExprFunction(pList, 0);
  if( yygotominor.yy164 ) yygotominor.yy164->op = yymsp[-1].minor.yy424;
  yygotominor.yy164 = sqlite3Expr(TK_NOT, yygotominor.yy164, 0, 0);
  sqlite3ExprSpan(yygotominor.yy164,&yymsp[-3].minor.yy164->span,&yymsp[0].minor.yy164->span);
}
#line 2562 "parse.c"
        break;
      case 199:
#line 603 "parse.y"
{yygotominor.yy424 = TK_LIKE;}
#line 2567 "parse.c"
        break;
      case 200:
#line 604 "parse.y"
{yygotominor.yy424 = TK_GLOB;}
#line 2572 "parse.c"
        break;
      case 207:
#line 611 "parse.y"
{
  yygotominor.yy164 = sqlite3Expr(TK_ISNULL, yymsp[-1].minor.yy164, 0, 0);
  sqlite3ExprSpan(yygotominor.yy164,&yymsp[-1].minor.yy164->span,&yymsp[0].minor.yy0);
}
#line 2580 "parse.c"
        break;
      case 208:
#line 615 "parse.y"
{
  yygotominor.yy164 = sqlite3Expr(TK_ISNULL, yymsp[-2].minor.yy164, 0, 0);
  sqlite3ExprSpan(yygotominor.yy164,&yymsp[-2].minor.yy164->span,&yymsp[0].minor.yy0);
}
#line 2588 "parse.c"
        break;
      case 209:
#line 619 "parse.y"
{
  yygotominor.yy164 = sqlite3Expr(TK_NOTNULL, yymsp[-1].minor.yy164, 0, 0);
  sqlite3ExprSpan(yygotominor.yy164,&yymsp[-1].minor.yy164->span,&yymsp[0].minor.yy0);
}
#line 2596 "parse.c"
        break;
      case 210:
#line 623 "parse.y"
{
  yygotominor.yy164 = sqlite3Expr(TK_NOTNULL, yymsp[-2].minor.yy164, 0, 0);
  sqlite3ExprSpan(yygotominor.yy164,&yymsp[-2].minor.yy164->span,&yymsp[0].minor.yy0);
}
#line 2604 "parse.c"
        break;
      case 211:
#line 627 "parse.y"
{
  yygotominor.yy164 = sqlite3Expr(TK_NOTNULL, yymsp[-3].minor.yy164, 0, 0);
  sqlite3ExprSpan(yygotominor.yy164,&yymsp[-3].minor.yy164->span,&yymsp[0].minor.yy0);
}
#line 2612 "parse.c"
        break;
      case 212:
      case 213:
#line 631 "parse.y"
{
  yygotominor.yy164 = sqlite3Expr(yymsp[-1].major, yymsp[0].minor.yy164, 0, 0);
  sqlite3ExprSpan(yygotominor.yy164,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy164->span);
}
#line 2621 "parse.c"
        break;
      case 214:
#line 639 "parse.y"
{
  yygotominor.yy164 = sqlite3Expr(TK_UMINUS, yymsp[0].minor.yy164, 0, 0);
  sqlite3ExprSpan(yygotominor.yy164,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy164->span);
}
#line 2629 "parse.c"
        break;
      case 215:
#line 643 "parse.y"
{
  yygotominor.yy164 = sqlite3Expr(TK_UPLUS, yymsp[0].minor.yy164, 0, 0);
  sqlite3ExprSpan(yygotominor.yy164,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy164->span);
}
#line 2637 "parse.c"
        break;
      case 216:
#line 647 "parse.y"
{
  yygotominor.yy164 = sqlite3Expr(TK_SELECT, 0, 0, 0);
  if( yygotominor.yy164 ) yygotominor.yy164->pSelect = yymsp[-1].minor.yy375;
  sqlite3ExprSpan(yygotominor.yy164,&yymsp[-2].minor.yy0,&yymsp[0].minor.yy0);
}
#line 2646 "parse.c"
        break;
      case 217:
#line 652 "parse.y"
{
  ExprList *pList = sqlite3ExprListAppend(0, yymsp[-2].minor.yy164, 0);
  pList = sqlite3ExprListAppend(pList, yymsp[0].minor.yy164, 0);
  yygotominor.yy164 = sqlite3Expr(TK_BETWEEN, yymsp[-4].minor.yy164, 0, 0);
  if( yygotominor.yy164 ) yygotominor.yy164->pList = pList;
  sqlite3ExprSpan(yygotominor.yy164,&yymsp[-4].minor.yy164->span,&yymsp[0].minor.yy164->span);
}
#line 2657 "parse.c"
        break;
      case 218:
#line 659 "parse.y"
{
  ExprList *pList = sqlite3ExprListAppend(0, yymsp[-2].minor.yy164, 0);
  pList = sqlite3ExprListAppend(pList, yymsp[0].minor.yy164, 0);
  yygotominor.yy164 = sqlite3Expr(TK_BETWEEN, yymsp[-5].minor.yy164, 0, 0);
  if( yygotominor.yy164 ) yygotominor.yy164->pList = pList;
  yygotominor.yy164 = sqlite3Expr(TK_NOT, yygotominor.yy164, 0, 0);
  sqlite3ExprSpan(yygotominor.yy164,&yymsp[-5].minor.yy164->span,&yymsp[0].minor.yy164->span);
}
#line 2669 "parse.c"
        break;
      case 219:
#line 667 "parse.y"
{
  yygotominor.yy164 = sqlite3Expr(TK_IN, yymsp[-4].minor.yy164, 0, 0);
  if( yygotominor.yy164 ) yygotominor.yy164->pList = yymsp[-1].minor.yy232;
  sqlite3ExprSpan(yygotominor.yy164,&yymsp[-4].minor.yy164->span,&yymsp[0].minor.yy0);
}
#line 2678 "parse.c"
        break;
      case 220:
#line 672 "parse.y"
{
  yygotominor.yy164 = sqlite3Expr(TK_IN, yymsp[-4].minor.yy164, 0, 0);
  if( yygotominor.yy164 ) yygotominor.yy164->pSelect = yymsp[-1].minor.yy375;
  sqlite3ExprSpan(yygotominor.yy164,&yymsp[-4].minor.yy164->span,&yymsp[0].minor.yy0);
}
#line 2687 "parse.c"
        break;
      case 221:
#line 677 "parse.y"
{
  yygotominor.yy164 = sqlite3Expr(TK_IN, yymsp[-5].minor.yy164, 0, 0);
  if( yygotominor.yy164 ) yygotominor.yy164->pList = yymsp[-1].minor.yy232;
  yygotominor.yy164 = sqlite3Expr(TK_NOT, yygotominor.yy164, 0, 0);
  sqlite3ExprSpan(yygotominor.yy164,&yymsp[-5].minor.yy164->span,&yymsp[0].minor.yy0);
}
#line 2697 "parse.c"
        break;
      case 222:
#line 683 "parse.y"
{
  yygotominor.yy164 = sqlite3Expr(TK_IN, yymsp[-5].minor.yy164, 0, 0);
  if( yygotominor.yy164 ) yygotominor.yy164->pSelect = yymsp[-1].minor.yy375;
  yygotominor.yy164 = sqlite3Expr(TK_NOT, yygotominor.yy164, 0, 0);
  sqlite3ExprSpan(yygotominor.yy164,&yymsp[-5].minor.yy164->span,&yymsp[0].minor.yy0);
}
#line 2707 "parse.c"
        break;
      case 223:
#line 689 "parse.y"
{
  SrcList *pSrc = sqlite3SrcListAppend(0, &yymsp[-1].minor.yy318, &yymsp[0].minor.yy318);
  yygotominor.yy164 = sqlite3Expr(TK_IN, yymsp[-3].minor.yy164, 0, 0);
  if( yygotominor.yy164 ) yygotominor.yy164->pSelect = sqlite3SelectNew(0,pSrc,0,0,0,0,0,-1,0);
  sqlite3ExprSpan(yygotominor.yy164,&yymsp[-3].minor.yy164->span,yymsp[0].minor.yy318.z?&yymsp[0].minor.yy318:&yymsp[-1].minor.yy318);
}
#line 2717 "parse.c"
        break;
      case 224:
#line 695 "parse.y"
{
  SrcList *pSrc = sqlite3SrcListAppend(0, &yymsp[-1].minor.yy318, &yymsp[0].minor.yy318);
  yygotominor.yy164 = sqlite3Expr(TK_IN, yymsp[-4].minor.yy164, 0, 0);
  if( yygotominor.yy164 ) yygotominor.yy164->pSelect = sqlite3SelectNew(0,pSrc,0,0,0,0,0,-1,0);
  yygotominor.yy164 = sqlite3Expr(TK_NOT, yygotominor.yy164, 0, 0);
  sqlite3ExprSpan(yygotominor.yy164,&yymsp[-4].minor.yy164->span,yymsp[0].minor.yy318.z?&yymsp[0].minor.yy318:&yymsp[-1].minor.yy318);
}
#line 2728 "parse.c"
        break;
      case 225:
#line 705 "parse.y"
{
  yygotominor.yy164 = sqlite3Expr(TK_CASE, yymsp[-3].minor.yy164, yymsp[-1].minor.yy164, 0);
  if( yygotominor.yy164 ) yygotominor.yy164->pList = yymsp[-2].minor.yy232;
  sqlite3ExprSpan(yygotominor.yy164, &yymsp[-4].minor.yy0, &yymsp[0].minor.yy0);
}
#line 2737 "parse.c"
        break;
      case 226:
#line 712 "parse.y"
{
  yygotominor.yy232 = sqlite3ExprListAppend(yymsp[-4].minor.yy232, yymsp[-2].minor.yy164, 0);
  yygotominor.yy232 = sqlite3ExprListAppend(yygotominor.yy232, yymsp[0].minor.yy164, 0);
}
#line 2745 "parse.c"
        break;
      case 227:
#line 716 "parse.y"
{
  yygotominor.yy232 = sqlite3ExprListAppend(0, yymsp[-2].minor.yy164, 0);
  yygotominor.yy232 = sqlite3ExprListAppend(yygotominor.yy232, yymsp[0].minor.yy164, 0);
}
#line 2753 "parse.c"
        break;
      case 236:
#line 741 "parse.y"
{
  if( yymsp[-10].minor.yy424!=OE_None ) yymsp[-10].minor.yy424 = yymsp[0].minor.yy424;
  if( yymsp[-10].minor.yy424==OE_Default) yymsp[-10].minor.yy424 = OE_Abort;
  sqlite3CreateIndex(pParse, &yymsp[-8].minor.yy318, &yymsp[-7].minor.yy318, sqlite3SrcListAppend(0,&yymsp[-5].minor.yy318,&yymsp[-4].minor.yy318),
      yymsp[-2].minor.yy232, yymsp[-10].minor.yy424, &yymsp[-11].minor.yy0, &yymsp[-1].minor.yy0);
}
#line 2763 "parse.c"
        break;
      case 238:
#line 750 "parse.y"
{ yygotominor.yy424 = OE_None; }
#line 2768 "parse.c"
        break;
      case 241:
#line 760 "parse.y"
{
  Expr *p = 0;
  if( yymsp[-1].minor.yy318.n>0 ){
    p = sqlite3Expr(TK_COLUMN, 0, 0, 0);
    if( p ) p->pColl = sqlite3LocateCollSeq(pParse, yymsp[-1].minor.yy318.z, yymsp[-1].minor.yy318.n);
  }
  yygotominor.yy232 = sqlite3ExprListAppend(yymsp[-4].minor.yy232, p, &yymsp[-2].minor.yy318);
}
#line 2780 "parse.c"
        break;
      case 242:
#line 768 "parse.y"
{
  Expr *p = 0;
  if( yymsp[-1].minor.yy318.n>0 ){
    p = sqlite3Expr(TK_COLUMN, 0, 0, 0);
    if( p ) p->pColl = sqlite3LocateCollSeq(pParse, yymsp[-1].minor.yy318.z, yymsp[-1].minor.yy318.n);
  }
  yygotominor.yy232 = sqlite3ExprListAppend(0, p, &yymsp[-2].minor.yy318);
}
#line 2792 "parse.c"
        break;
      case 244:
#line 782 "parse.y"
{
  sqlite3DropIndex(pParse, sqlite3SrcListAppend(0,&yymsp[-1].minor.yy318,&yymsp[0].minor.yy318));
}
#line 2799 "parse.c"
        break;
      case 245:
#line 788 "parse.y"
{sqlite3Vacuum(pParse,0);}
#line 2804 "parse.c"
        break;
      case 246:
#line 789 "parse.y"
{sqlite3Vacuum(pParse,&yymsp[0].minor.yy318);}
#line 2809 "parse.c"
        break;
      case 247:
      case 249:
#line 793 "parse.y"
{sqlite3Pragma(pParse,&yymsp[-3].minor.yy318,&yymsp[-2].minor.yy318,&yymsp[0].minor.yy318,0);}
#line 2815 "parse.c"
        break;
      case 248:
#line 794 "parse.y"
{sqlite3Pragma(pParse,&yymsp[-3].minor.yy318,&yymsp[-2].minor.yy318,&yymsp[0].minor.yy0,0);}
#line 2820 "parse.c"
        break;
      case 250:
#line 796 "parse.y"
{
  sqlite3Pragma(pParse,&yymsp[-3].minor.yy318,&yymsp[-2].minor.yy318,&yymsp[0].minor.yy318,1);
}
#line 2827 "parse.c"
        break;
      case 251:
#line 799 "parse.y"
{sqlite3Pragma(pParse,&yymsp[-4].minor.yy318,&yymsp[-3].minor.yy318,&yymsp[-1].minor.yy318,0);}
#line 2832 "parse.c"
        break;
      case 252:
#line 800 "parse.y"
{sqlite3Pragma(pParse,&yymsp[-1].minor.yy318,&yymsp[0].minor.yy318,0,0);}
#line 2837 "parse.c"
        break;
      case 259:
#line 810 "parse.y"
{
  Token all;
  all.z = yymsp[-3].minor.yy318.z;
  all.n = (yymsp[0].minor.yy0.z - yymsp[-3].minor.yy318.z) + yymsp[0].minor.yy0.n;
  sqlite3FinishTrigger(pParse, yymsp[-1].minor.yy107, &all);
}
#line 2847 "parse.c"
        break;
      case 260:
#line 818 "parse.y"
{
  SrcList *pTab = sqlite3SrcListAppend(0, &yymsp[-3].minor.yy318, &yymsp[-2].minor.yy318);
  sqlite3BeginTrigger(pParse, &yymsp[-8].minor.yy318, &yymsp[-7].minor.yy318, yymsp[-6].minor.yy424, yymsp[-5].minor.yy414.a, yymsp[-5].minor.yy414.b, pTab, yymsp[-1].minor.yy424, yymsp[0].minor.yy164, yymsp[-10].minor.yy424);
  yygotominor.yy318 = (yymsp[-7].minor.yy318.n==0?yymsp[-8].minor.yy318:yymsp[-7].minor.yy318);
}
#line 2856 "parse.c"
        break;
      case 261:
      case 264:
#line 825 "parse.y"
{ yygotominor.yy424 = TK_BEFORE; }
#line 2862 "parse.c"
        break;
      case 262:
#line 826 "parse.y"
{ yygotominor.yy424 = TK_AFTER;  }
#line 2867 "parse.c"
        break;
      case 263:
#line 827 "parse.y"
{ yygotominor.yy424 = TK_INSTEAD;}
#line 2872 "parse.c"
        break;
      case 265:
#line 832 "parse.y"
{ yygotominor.yy414.a = TK_DELETE; yygotominor.yy414.b = 0; }
#line 2877 "parse.c"
        break;
      case 266:
#line 833 "parse.y"
{ yygotominor.yy414.a = TK_INSERT; yygotominor.yy414.b = 0; }
#line 2882 "parse.c"
        break;
      case 267:
#line 834 "parse.y"
{ yygotominor.yy414.a = TK_UPDATE; yygotominor.yy414.b = 0;}
#line 2887 "parse.c"
        break;
      case 268:
#line 835 "parse.y"
{yygotominor.yy414.a = TK_UPDATE; yygotominor.yy414.b = yymsp[0].minor.yy246; }
#line 2892 "parse.c"
        break;
      case 269:
      case 270:
#line 838 "parse.y"
{ yygotominor.yy424 = TK_ROW; }
#line 2898 "parse.c"
        break;
      case 271:
#line 840 "parse.y"
{ yygotominor.yy424 = TK_STATEMENT; }
#line 2903 "parse.c"
        break;
      case 272:
#line 843 "parse.y"
{ yygotominor.yy164 = 0; }
#line 2908 "parse.c"
        break;
      case 273:
#line 844 "parse.y"
{ yygotominor.yy164 = yymsp[0].minor.yy164; }
#line 2913 "parse.c"
        break;
      case 274:
#line 848 "parse.y"
{
  yymsp[-2].minor.yy107->pNext = yymsp[0].minor.yy107;
  yygotominor.yy107 = yymsp[-2].minor.yy107;
}
#line 2921 "parse.c"
        break;
      case 275:
#line 852 "parse.y"
{ yygotominor.yy107 = 0; }
#line 2926 "parse.c"
        break;
      case 276:
#line 858 "parse.y"
{ yygotominor.yy107 = sqlite3TriggerUpdateStep(&yymsp[-3].minor.yy318, yymsp[-1].minor.yy232, yymsp[0].minor.yy164, yymsp[-4].minor.yy424); }
#line 2931 "parse.c"
        break;
      case 277:
#line 863 "parse.y"
{yygotominor.yy107 = sqlite3TriggerInsertStep(&yymsp[-5].minor.yy318, yymsp[-4].minor.yy246, yymsp[-1].minor.yy232, 0, yymsp[-7].minor.yy424);}
#line 2936 "parse.c"
        break;
      case 278:
#line 866 "parse.y"
{yygotominor.yy107 = sqlite3TriggerInsertStep(&yymsp[-2].minor.yy318, yymsp[-1].minor.yy246, 0, yymsp[0].minor.yy375, yymsp[-4].minor.yy424);}
#line 2941 "parse.c"
        break;
      case 279:
#line 870 "parse.y"
{yygotominor.yy107 = sqlite3TriggerDeleteStep(&yymsp[-1].minor.yy318, yymsp[0].minor.yy164);}
#line 2946 "parse.c"
        break;
      case 280:
#line 873 "parse.y"
{yygotominor.yy107 = sqlite3TriggerSelectStep(yymsp[0].minor.yy375); }
#line 2951 "parse.c"
        break;
      case 281:
#line 876 "parse.y"
{
  yygotominor.yy164 = sqlite3Expr(TK_RAISE, 0, 0, 0); 
  yygotominor.yy164->iColumn = OE_Ignore;
  sqlite3ExprSpan(yygotominor.yy164, &yymsp[-3].minor.yy0, &yymsp[0].minor.yy0);
}
#line 2960 "parse.c"
        break;
      case 282:
#line 881 "parse.y"
{
  yygotominor.yy164 = sqlite3Expr(TK_RAISE, 0, 0, &yymsp[-1].minor.yy318); 
  yygotominor.yy164->iColumn = OE_Rollback;
  sqlite3ExprSpan(yygotominor.yy164, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0);
}
#line 2969 "parse.c"
        break;
      case 283:
#line 886 "parse.y"
{
  yygotominor.yy164 = sqlite3Expr(TK_RAISE, 0, 0, &yymsp[-1].minor.yy318); 
  yygotominor.yy164->iColumn = OE_Abort;
  sqlite3ExprSpan(yygotominor.yy164, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0);
}
#line 2978 "parse.c"
        break;
      case 284:
#line 891 "parse.y"
{
  yygotominor.yy164 = sqlite3Expr(TK_RAISE, 0, 0, &yymsp[-1].minor.yy318); 
  yygotominor.yy164->iColumn = OE_Fail;
  sqlite3ExprSpan(yygotominor.yy164, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0);
}
#line 2987 "parse.c"
        break;
      case 285:
#line 898 "parse.y"
{
  sqlite3DropTrigger(pParse,sqlite3SrcListAppend(0,&yymsp[-1].minor.yy318,&yymsp[0].minor.yy318));
}
#line 2994 "parse.c"
        break;
      case 286:
#line 903 "parse.y"
{
  sqlite3Attach(pParse, &yymsp[-3].minor.yy318, &yymsp[-1].minor.yy318, yymsp[0].minor.yy72.type, &yymsp[0].minor.yy72.key);
}
#line 3001 "parse.c"
        break;
      case 287:
#line 907 "parse.y"
{ yygotominor.yy72.type = 0; }
#line 3006 "parse.c"
        break;
      case 288:
#line 908 "parse.y"
{ yygotominor.yy72.type=1; yygotominor.yy72.key = yymsp[0].minor.yy318; }
#line 3011 "parse.c"
        break;
      case 289:
#line 909 "parse.y"
{ yygotominor.yy72.type=2; yygotominor.yy72.key = yymsp[0].minor.yy0; }
#line 3016 "parse.c"
        break;
      case 292:
#line 915 "parse.y"
{
  sqlite3Detach(pParse, &yymsp[0].minor.yy318);
}
#line 3023 "parse.c"
        break;
  };
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yypParser->yyidx -= yysize;
  yyact = yy_find_reduce_action(yypParser,yygoto);
  if( yyact < YYNSTATE ){
    yy_shift(yypParser,yyact,yygoto,&yygotominor);
  }else if( yyact == YYNSTATE + YYNRULE + 1 ){
    yy_accept(yypParser);
  }
}

/*
** The following code executes when the parse fails
*/
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  sqlite3ParserARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
  sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  YYMINORTYPE yyminor            /* The minor type of the error token */
){
  sqlite3ParserARG_FETCH;
#define TOKEN (yyminor.yy0)
#line 23 "parse.y"

  if( pParse->zErrMsg==0 ){
    if( TOKEN.z[0] ){
      sqlite3ErrorMsg(pParse, "near \"%T\": syntax error", &TOKEN);
    }else{
      sqlite3ErrorMsg(pParse, "incomplete SQL statement");
    }
  }

#line 3075 "parse.c"
  sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  sqlite3ParserARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
  sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "sqlite3ParserAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void sqlite3Parser(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  sqlite3ParserTOKENTYPE yyminor       /* The value for the token */
  sqlite3ParserARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  int yyact;            /* The parser action. */
  int yyendofinput;     /* True if we are at the end of input */
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
  yyParser *yypParser;  /* The parser */

  /* (re)initialize the parser, if necessary */
  yypParser = (yyParser*)yyp;
  if( yypParser->yyidx<0 ){
    if( yymajor==0 ) return;
    yypParser->yyidx = 0;
    yypParser->yyerrcnt = -1;
    yypParser->yystack[0].stateno = 0;
    yypParser->yystack[0].major = 0;
  }
  yyminorunion.yy0 = yyminor;
  yyendofinput = (yymajor==0);
  sqlite3ParserARG_STORE;

#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sInput %s\n",yyTracePrompt,yyTokenName[yymajor]);
  }
#endif

  do{
    yyact = yy_find_shift_action(yypParser,yymajor);
    if( yyact<YYNSTATE ){
      yy_shift(yypParser,yyact,yymajor,&yyminorunion);
      yypParser->yyerrcnt--;
      if( yyendofinput && yypParser->yyidx>=0 ){
        yymajor = 0;
      }else{
        yymajor = YYNOCODE;
      }
    }else if( yyact < YYNSTATE + YYNRULE ){
      yy_reduce(yypParser,yyact-YYNSTATE);
    }else if( yyact == YY_ERROR_ACTION ){
      int yymx;
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yymx = yypParser->yystack[yypParser->yyidx].major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yymajor,&yyminorunion);
        yymajor = YYNOCODE;
      }else{
         while(
          yypParser->yyidx >= 0 &&
          yymx != YYERRORSYMBOL &&
          (yyact = yy_find_shift_action(yypParser,YYERRORSYMBOL)) >= YYNSTATE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yyidx < 0 || yymajor==0 ){
          yy_destructor(yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          YYMINORTYPE u2;
          u2.YYERRSYMDT = 0;
          yy_shift(yypParser,yyact,YYERRORSYMBOL,&u2);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
      }
      yymajor = YYNOCODE;
#endif
    }else{
      yy_accept(yypParser);
      yymajor = YYNOCODE;
    }
  }while( yymajor!=YYNOCODE && yypParser->yyidx>=0 );
  return;
}
