#
# This file is part of Dist-Zilla-Plugin-Travis-ConfigForReleaseBranch
#
# This software is Copyright (c) 2013 by Chris Weyl.
#
# This is free software, licensed under:
#
#   The GNU Lesser General Public License, Version 2.1, February 1999
#
package Dist::Zilla::Plugin::Travis::ConfigForReleaseBranch;
BEGIN {
  $Dist::Zilla::Plugin::Travis::ConfigForReleaseBranch::AUTHORITY = 'cpan:RSRCHBOY';
}
{
  $Dist::Zilla::Plugin::Travis::ConfigForReleaseBranch::VERSION = '0.001';
}
# git description: 0.000_01-0-gc7c2f1d


# ABSTRACT: Create a .travis.yml suitable for built branches

use Moose;
use namespace::autoclean;
extends 'Dist::Zilla::Plugin::InlineFiles';


__PACKAGE__->meta->make_immutable;
!!42;

=pod

=encoding utf-8

=for :stopwords Chris Weyl

=head1 NAME

Dist::Zilla::Plugin::Travis::ConfigForReleaseBranch - Create a .travis.yml suitable for built branches

=head1 VERSION

This document describes version 0.001 of Dist::Zilla::Plugin::Travis::ConfigForReleaseBranch - released August 12, 2013 as part of Dist-Zilla-Plugin-Travis-ConfigForReleaseBranch.

=head1 SYNOPSIS

    ; in your dist.ini
    [Travis::ConfigForReleaseBranch]

=head1 DESCRIPTION

This is a simple L<Dist::Zilla::Plugin::InlineFiles> plugin to include a
sensible -- or so this author believes -- C<.travis.yml> suitable for running
L<Travis-CI jobs|http://travis-ci.org> off of a release branch like one
generated by the L<Dist::Zilla::Plugin::Git::CommitBuild>
plugin.

By default, we build against Perl 5.8, 5.10, 5.12, 5.14, 5.16 and 5.18.
The 5.8 build job is allowed to fail without causing the entire build run
to fail.

=head1 EARLY VERSION!

Yep, this is an early, early version.  No tests, and no flexibility in
configuration details.  Anyone wishing to assist (and faster than this author
in remedying this sad, sad state of affairs) is more than welcome to submit
pull requests.  Good pull requests are likely to earn the undying gratitude of
this humble CPAN author.

=head1 SEE ALSO

Please see those modules/websites for more information related to this module.

=over 4

=item *

L<Dist::Zilla::Plugin::Git::CommitBuild|Dist::Zilla::Plugin::Git::CommitBuild>

=item *

L<Dist::Zilla::TravisCI|Dist::Zilla::TravisCI>

=back

=head1 SOURCE

The development version is on github at L<http://github.com/RsrchBoy/dist-zilla-plugin-travis-configforreleasebranch>
and may be cloned from L<git://github.com/RsrchBoy/dist-zilla-plugin-travis-configforreleasebranch.git>

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website
https://github.com/RsrchBoy/dist-zilla-plugin-travis-configforreleasebranch
/issues

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

Chris Weyl <cweyl@alumni.drew.edu>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2013 by Chris Weyl.

This is free software, licensed under:

  The GNU Lesser General Public License, Version 2.1, February 1999

=cut

__DATA__
___[ .travis.yml ]___
language: perl
perl:
   - "5.8"
   - "5.10"
   - "5.12"
   - "5.14"
   - "5.16"
   - "5.18"

matrix:
   allow_failures:
      - perl: "5.8"

before_install:
   # git bits sometimes needed...
   - git config user.name 'Travis-CI'
   - git config user.email 'travis@nowhere.dne'

install:
   # not so much install our package as all its prereqs
   - cpanm --installdeps . || { cat ~/.cpanm/build.log ; false ; }

script:
   - perl Makefile.PL
   - make test
