use strict;
use warnings;
package App::Addex::Entry;
{
  $App::Addex::Entry::VERSION = '0.024';
}
# ABSTRACT: an entry in your address book

use Mixin::ExtraFields::Param -fields => {
  driver  => 'HashGuts',
  moniker => 'field',
  id      => undef,
};

use Carp ();


sub new {
  my ($class, $arg) = @_;

  # XXX: do some validation -- rjbs, 2007-04-06
  my $self = {
    name   => $arg->{name},
    nick   => $arg->{nick},
    emails => $arg->{emails},
  };

  bless $self => $class;

  $self->field(%{ $arg->{fields} }) if $arg->{fields};

  return $self;
}


sub name { $_[0]->{name} }
sub nick { $_[0]->{nick} }


sub emails { @{ $_[0]->{emails} } }


1;

__END__

=pod

=head1 NAME

App::Addex::Entry - an entry in your address book

=head1 VERSION

version 0.024

=head1 METHODS

=head2 new

  my $entry = App::Addex::Entry->new(\%arg);

This method returns an Addex Entry object.

Valid parameters (sure to change) are:

  name   - a full name (required)
  nick   - a nickname (optional)
  emails - an arrayref of email addresses (required)

=head2 name

=head2 nick

These methods return the value of the property they name.

=head2 emails

This method returns the entry's email addresses.  In scalar context it returns
the number of addresses.

=head2 field

  my $value = $entry->field($name);

  $entry->field($name => $value);

This method is generated by L<Mixin::ExtraFields::Param|Mixin::ExtraFields::Param>.

=head1 AUTHOR

Ricardo SIGNES <rjbs@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2006 by Ricardo SIGNES.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
