# -*- perl -*-

use 5.005; # new "for" syntax

if (!eval q{ use Date::Calc; 1 } && !eval q{ use Date::Pcalc; 1 }) {
    print <<EOF;

*** To select dates before 1970-01-01 and after year 2036, you need to
    install either Date::Calc or Date::Pcalc.

EOF
}

use ExtUtils::MakeMaker;
# See lib/ExtUtils/MakeMaker.pm for details of how to influence
# the contents of the Makefile that is written.
WriteMakefile(
    'NAME'	=> 'Tk::DateEntry',
    'VERSION_FROM' => 'DateEntry.pm', # finds $VERSION
    'PREREQ_PM' => {Tk => 400},
    'dist'      => {'COMPRESS'=>'gzip -9f', 'SUFFIX' => '.gz',
                    'POSTOP'=>'-$(CHMOD) 644 $(DISTVNAME).tar$(SUFFIX)'},
    ($ExtUtils::MakeMaker::VERSION >= 6.54 ?
      (META_ADD => { resources => { repository => 'git://github.com/eserte/tk-dateentry.git' },
		     recommends => {'Date::Calc'     => 0,
				    'Encode'	     => 0,
				    ($^O eq 'MSWin32' ? ('Win32::Console' => 0) : ('I18N::Langinfo' => 0)),
				    'Tk::FireButton' => 0,
				   },
		   }) : ()),
);

sub MY::postamble {
    my $postamble = "";

    if (defined $ENV{USER} && $ENV{USER} eq 'eserte' && $^O =~ /bsd/i && -f "../../perl.release.mk") {
	$postamble .= <<'EOF';

.include "../../perl.release.mk"
.include "../../perl.cvs.mk"

EOF
    }

    $postamble;
}
