# IUP::Dialog + TRAY / TRAYTIP / TRAYIMAGE example

use strict;
use warnings;

use IUP ':all';

my $tecgraf = IUP::Image->new( pixels=>
  [[  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, ],
   [  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  2,  5,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, ],
   [  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  4,  5,  5,  5,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, ],
   [  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 11,  5,  5,  5,  5, 12,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, ],
   [  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 10,  6,  5,  3,  5,  5,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, ],
   [  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  7,  5,  1,  1,  3,  5,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, ],
   [  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  7,  5,  1,  1,  3,  5,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, ],
   [  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  2,  9,  9,  1,  1,  3,  7,  6,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, ],
   [  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  7,  6,  1,  1,  1,  1,  2,  7,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, ],
   [  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  7,  6,  1,  1,  1,  1,  4,  7,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, ],
   [  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  7,  6,  1,  1,  1,  1,  4,  7,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, ],
   [  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 11,  2,  7,  5,  4,  4,  4,  4,  4,  4, 11,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, ],
   [  1,  1,  1,  1,  1,  1,  7,  4,  4,  4,  6,  3,  3,  7,  5,  5,  7,  7,  4,  4,  4,  4, 10, 10, 10, 10, 10,  1,  1,  1,  1,  1, ],
   [  1,  1,  1,  1,  4,  4,  4,  9,  9,  6,  5,  4,  8,  7,  5,  1,  1,  1,  1,  7,  5,  6,  3,  3,  3,  3,  4, 10,  7,  9,  1,  1, ],
   [  1,  1,  1,  4,  4,  6,  6,  8,  1,  1,  1,  1,  1, 10,  5,  1,  1,  1,  1, 10,  6,  1,  1,  1,  1,  1,  3,  3,  7,  7,  7,  1, ],
   [  1,  1,  2,  4,  4,  5,  1,  1,  1,  1,  1,  1,  1,  4,  5,  1,  1,  1,  1,  7,  9,  1,  1,  1,  1,  1,  1,  1,  7,  7,  5,  1, ],
   [  1,  1,  1,  3,  4,  4,  4,  1,  1,  1,  1,  1,  1,  4,  5,  1,  1,  1,  1,  7,  6,  1,  1,  1,  1,  1,  7,  7,  7,  9,  7,  1, ],
   [  1,  1,  1,  1,  3,  3,  3,  4, 10, 10, 10, 11,  1,  4,  5,  1,  1,  1,  1,  5,  6, 15,  5,  7,  7,  7,  9,  6,  5,  5,  1,  1, ],
   [  1,  1,  1,  1,  1,  1,  3,  3,  3,  3,  3,  2,  4,  7,  5,  5,  5,  5,  6,  9, 14, 14,  6,  5,  5,  5,  7, 12,  1,  1,  1,  1, ],
   [  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  6,  3,  3,  2,  2,  2,  4,  4,  2,  2, 10, 16,  1,  1,  1,  1,  1,  1,  1,  1,  1, ],
   [  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  2,  5,  1,  1,  1,  1,  6,  7,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, ],
   [  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  2,  5,  1,  1,  1,  1,  6,  7,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, ],
   [  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  2,  5,  1,  1,  1,  1,  6,  7,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, ],
   [  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  3,  7,  9,  1,  1,  4,  9,  5,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, ],
   [  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 12,  3,  5,  1,  1,  5,  7,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, ],
   [  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  3,  5,  1,  1,  7,  7,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, ],
   [  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  3,  5,  5,  4,  7,  7,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, ],
   [  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  9,  3,  5,  7,  7, 13,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, ],
   [  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  3,  7,  7,  7,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, ],
   [  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  3,  4,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, ],
   [  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, ],
   [  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, ],
  ], colors => [
      "  0   0   0",
      "BGCOLOR",
      "079  86  99",
      "040  45  53",
      "104 113 129",
      "136 147 170",
      "155 164 179",
      "121 136 167",
      "239 239 243",
      "176 190 214",
      "127 133 143",
      "207 209 214",
      "247 255 255",
      "244 247 249",
      "212 217 225",
      "215 226 241",
      "231 237 245",
   ]
);

my $dg = IUP::Dialog->new( child=>IUP::Label->new( TITLE=>"Tray example" ),
                           TITLE=>"Tray",
                           TRAY=>"YES",
			   TRAYTIP=>"This is a tip at tray",
			   TRAYIMAGE=>$tecgraf,
			   SIZE=>"QUARTERx" );

$dg->Show();

$dg->HIDETASKBAR("YES");

$dg->TRAYCLICK_CB( sub {
  my ($self, $button, $press, $dclick) = @_;
  if ( defined $button && $button == 1 && $press ) {
    my $item_show = IUP::Item->new( TITLE=>"Show", ACTION=>sub { $dg->Show() } );
    my $item_exit = IUP::Item->new( TITLE=>"Exit", ACTION=>sub { $dg->TRAY("NO"); $dg->Hide(); } );
    my $menu = IUP::Menu->new( child=>[$item_show, $item_exit] );
    $menu->Popup(IUP_MOUSEPOS, IUP_MOUSEPOS);
  }
  return IUP_DEFAULT;
} );

IUP->MainLoop;
