#$Id: Exceptions.pm 17684 2012-09-23 01:12:42Z jensenma $
package REST::Neo4p::Exceptions;
BEGIN {
  $REST::Neo4p::Exceptions::VERSION = '0.1';
}
use Exception::Class (
  'REST::Neo4p::Exception',
  'REST::Neo4p::LocalException' => {
    isa => 'REST::Neo4p::Exception',
    description => 'REST::Neo4p code-local error'
   },
  'REST::Neo4p::Neo4jException' => {
    isa => 'REST::Neo4p::Exception',
    fields => [ 'code', 'neo4j_message', 
		'neo4j_exception', 'neo4j_stacktrace' ],
    description => 'Neo4j server errors'
   },
  'REST::Neo4p::CommException' =>
    {
    isa => 'REST::Neo4p::Exception',
    fields => [ 'code' ],
    description => 'Network or HTTP errors'
   },
  'REST::Neo4p::NotFoundException' => {
    isa => 'REST::Neo4p::Neo4jException',
    fields => [ 'code', 'neo4j_message', 
		'neo4j_exception', 'neo4j_stacktrace' ],
    description => 'URL or item not found'
   },
  'REST::Neo4p::QuerySyntaxException' =>
    {
      isa => 'REST::Neo4p::Neo4jException',
      fields => [ 'code', 'neo4j_message', 
		  'neo4j_exception', 'neo4j_stacktrace' ],
      description => 'Cypher query language syntax error'
     },
  'REST::Neo4p::NotImplException' => {
    isa => 'REST::Neo4p::LocalException',
    description => 'Attempt to call an currently unimplemented method'
   },
  'REST::Neo4p::NotSuppException' => {
    isa => 'REST::Neo4p::LocalException',
    description => 'Attempt to call a non-supported inherited method'
   },
  'REST::Neo4p::ClassOnlyException' => {
    isa => 'REST::Neo4p::LocalException',
    message => 'This is a class method only',
    description => 'Attempt to call a class method from an instance'
   },
  'REST::Neo4p::QueryResponseException' => {
    isa => 'REST::Neo4p::LocalException',
    description => 'Problem parsing the response to a cypher query (prob. a bug)'
   }
   );

=head1 NAME

REST::Neo4p::Exceptions - Exception::Class objects for REST::Neo4p

=head1 SYNOPSIS

 use REST::Neo4p;
 
 my $server = 'http:127.0.0.1:7474';
 my $RETRIES = 3;
 my $e;
 do {
   eval {
     REST::Neo4p->connect($server);
     $RETRIES--;
   };
 } while ( $e = Exception::Class->caught('REST::Neo4p::CommException') );
 ref $e ? $e->rethrow : die $e if $e;

=head1 Classes

=over

=item * Base Class : REST::Neo4p::Exception

=over

=item * REST::Neo4p::CommException

Network and server communication errors. Method C<code()> returns the
HTTP status code.

=item * REST::Neo4p::LocalException

L<REST::Neo4p> module-local errors.

=over

=item * REST::Neo4p::ClassOnlyException

Attempt to use a class-only method on a class instance.

=item * REST::Neo4p::NotSuppException

Attempt to use a base method not supported in the subclass.

=item * REST::Neo4p::NotImplException

Attempt to use a not yet implemented method.

=back

=item * REST::Neo4p::Neo4jException

Exceptions and errors generated by the Neo4j server. Methods
C<neo4j_message()>, C<neo4j_stacktrace()>, C<neo4j_exception()> return
server-generated info.

=over 

=item * REST::Neo4p::NotFoundException

Requested item not found in database.

=item * REST::Neo4p::QuerySyntaxException

Bad query syntax (see L<REST::Neo4p::Query>).

=back

=back

=back

=head1 SEE ALSO

L<REST::Neo4p>, L<Exception::Class>

=head1 AUTHOR

    Mark A. Jensen
    CPAN ID: MAJENSEN
    TCGA DCC
    mark -dot- jensen -at- nih -dot- gov
    http://tcga-data.nci.nih.gov

=head1 LICENSE

Copyright (c) 2012 Mark A. Jensen. This program is free software; you
can redistribute it and/or modify it under the same terms as Perl
itself.

=cut

1;
