/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.ScriptResult;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HtmlAnchor;
import com.gargoylesoftware.htmlunit.html.HtmlArea;
import com.gargoylesoftware.htmlunit.html.SubmittableElement;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import java.util.LinkedList;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.ScriptableObject;
import net.sourceforge.htmlunit.corejs.javascript.Undefined;

public class Event
extends SimpleScriptable {
    static final String KEY_CURRENT_EVENT = "Event#current";
    public static final String TYPE_SUBMIT = "submit";
    public static final String TYPE_CHANGE = "change";
    public static final String TYPE_LOAD = "load";
    public static final String TYPE_UNLOAD = "unload";
    public static final String TYPE_FOCUS = "focus";
    public static final String TYPE_FOCUS_IN = "focusin";
    public static final String TYPE_FOCUS_OUT = "focusout";
    public static final String TYPE_BLUR = "blur";
    public static final String TYPE_KEY_DOWN = "keydown";
    public static final String TYPE_KEY_PRESS = "keypress";
    public static final String TYPE_INPUT = "input";
    public static final String TYPE_KEY_UP = "keyup";
    public static final String TYPE_RESET = "reset";
    public static final String TYPE_BEFORE_UNLOAD = "beforeunload";
    public static final String TYPE_DOM_DOCUMENT_LOADED = "DOMContentLoaded";
    public static final String TYPE_PROPERTY_CHANGE = "propertychange";
    public static final String TYPE_READY_STATE_CHANGE = "readystatechange";
    public static final String TYPE_ERROR = "error";
    public static final short CAPTURING_PHASE = 1;
    public static final short AT_TARGET = 2;
    public static final short BUBBLING_PHASE = 3;
    public static final int ABORT = 0x400000;
    public static final int ALT_MASK = 1;
    public static final int BACK = 0x20000000;
    public static final int BLUR = 8192;
    public static final int CHANGE = 32768;
    public static final int CLICK = 64;
    public static final int CONTROL_MASK = 2;
    public static final int DBLCLICK = 128;
    public static final int DRAGDROP = 2048;
    public static final int ERROR = 0x800000;
    public static final int FOCUS = 4096;
    public static final int FORWARD = 0x8000000;
    public static final int HELP = 0x10000000;
    public static final int KEYDOWN = 256;
    public static final int KEYPRESS = 1024;
    public static final int KEYUP = 512;
    public static final int LOAD = 524288;
    public static final int LOCATE = 0x1000000;
    public static final int META_MASK = 8;
    public static final int MOUSEDOWN = 1;
    public static final int MOUSEDRAG = 32;
    public static final int MOUSEMOVE = 16;
    public static final int MOUSEOUT = 8;
    public static final int MOUSEOVER = 4;
    public static final int MOUSEUP = 2;
    public static final int MOVE = 0x2000000;
    public static final int RESET = 65536;
    public static final int RESIZE = 0x4000000;
    public static final int SCROLL = 262144;
    public static final int SELECT = 16384;
    public static final int SHIFT_MASK = 4;
    public static final int SUBMIT = 131072;
    public static final int TEXT = 0x40000000;
    public static final int UNLOAD = 0x100000;
    public static final int XFER_DONE = 0x200000;
    private static final long serialVersionUID = 4050485607908455730L;
    private Object srcElement_;
    private Object target_;
    private Object currentTarget_;
    private String type_;
    private Object keyCode_;
    private boolean shiftKey_;
    private boolean ctrlKey_;
    private boolean altKey_;
    private String propertyName_;
    private boolean stopPropagation_;
    private Object returnValue_;
    private boolean preventDefault_;
    private short eventPhase_;
    private boolean bubbles_ = true;
    private boolean cancelable_ = true;
    private long timeStamp_ = System.currentTimeMillis();

    public Event(DomNode domNode, String type) {
        ScriptableObject target = domNode.getScriptObject();
        this.srcElement_ = target;
        this.target_ = target;
        this.currentTarget_ = target;
        this.type_ = type;
        this.setParentScope((Scriptable)((SimpleScriptable)target));
        this.setPrototype(this.getPrototype(this.getClass()));
        this.setDomNode(domNode, false);
    }

    public static Event createPropertyChangeEvent(DomNode domNode, String propertyName) {
        Event event = new Event(domNode, TYPE_PROPERTY_CHANGE);
        event.propertyName_ = propertyName;
        return event;
    }

    public Event() {
    }

    void startFire() {
        LinkedList<Event> events = (LinkedList<Event>)Context.getCurrentContext().getThreadLocal((Object)KEY_CURRENT_EVENT);
        if (events == null) {
            events = new LinkedList<Event>();
            Context.getCurrentContext().putThreadLocal((Object)KEY_CURRENT_EVENT, events);
        }
        events.add(this);
    }

    void endFire() {
        ((LinkedList)Context.getCurrentContext().getThreadLocal((Object)KEY_CURRENT_EVENT)).removeLast();
    }

    public Object jsxGet_srcElement() {
        return this.srcElement_;
    }

    public void jsxSet_srcElement(Object srcElement) {
        this.srcElement_ = srcElement;
    }

    public Object jsxGet_target() {
        return this.target_;
    }

    public void setTarget(Object target) {
        this.target_ = target;
    }

    public Object jsxGet_currentTarget() {
        return this.currentTarget_;
    }

    public void setCurrentTarget(Scriptable target) {
        this.currentTarget_ = target;
    }

    public String jsxGet_type() {
        return this.type_;
    }

    public void setEventType(String eventType) {
        this.type_ = eventType;
    }

    public long jsxGet_timeStamp() {
        return this.timeStamp_;
    }

    protected void setKeyCode(Object keyCode) {
        this.keyCode_ = keyCode;
    }

    public Object jsxGet_keyCode() {
        if (this.keyCode_ == null) {
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.GENERATED_155)) {
                return 0;
            }
            return Undefined.instance;
        }
        return this.keyCode_;
    }

    public boolean jsxGet_shiftKey() {
        return this.shiftKey_;
    }

    protected void setShiftKey(boolean shiftKey) {
        this.shiftKey_ = shiftKey;
    }

    public boolean jsxGet_ctrlKey() {
        return this.ctrlKey_;
    }

    protected void setCtrlKey(boolean ctrlKey) {
        this.ctrlKey_ = ctrlKey;
    }

    public boolean jsxGet_altKey() {
        return this.altKey_;
    }

    protected void setAltKey(boolean altKey) {
        this.altKey_ = altKey;
    }

    public int jsxGet_eventPhase() {
        return this.eventPhase_;
    }

    public void setEventPhase(short phase) {
        if (phase != 1 && phase != 2 && phase != 3) {
            throw new IllegalArgumentException("Illegal phase specified: " + phase);
        }
        this.eventPhase_ = phase;
    }

    public boolean jsxGet_bubbles() {
        return this.bubbles_;
    }

    public boolean jsxGet_cancelable() {
        return this.cancelable_;
    }

    public boolean jsxGet_cancelBubble() {
        return this.stopPropagation_;
    }

    public void jsxSet_cancelBubble(boolean newValue) {
        this.stopPropagation_ = newValue;
    }

    public void jsxFunction_stopPropagation() {
        this.stopPropagation_ = true;
    }

    public boolean isPropagationStopped() {
        return this.stopPropagation_;
    }

    public Object jsxGet_returnValue() {
        return this.returnValue_;
    }

    public String jsxGet_propertyName() {
        return this.propertyName_;
    }

    public void jsxSet_returnValue(Object returnValue) {
        this.returnValue_ = returnValue;
    }

    public void jsxFunction_initEvent(String type, boolean bubbles, boolean cancelable) {
        this.type_ = type;
        this.bubbles_ = bubbles;
        this.cancelable_ = cancelable;
    }

    public void jsxFunction_preventDefault() {
        this.preventDefault_ = true;
    }

    public boolean isAborted(ScriptResult result) {
        boolean ie = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.GENERATED_38);
        return ScriptResult.isFalse(result) || !ie && this.preventDefault_ || ie && Boolean.FALSE.equals(this.returnValue_);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder("Event ");
        buffer.append(this.jsxGet_type());
        buffer.append(" (");
        buffer.append("Current Target: ");
        buffer.append(this.currentTarget_);
        buffer.append(");");
        return buffer.toString();
    }

    public boolean applies(DomNode node) {
        if (TYPE_BLUR.equals(this.jsxGet_type()) || TYPE_FOCUS.equals(this.jsxGet_type())) {
            return node instanceof SubmittableElement || node instanceof HtmlAnchor || node instanceof HtmlArea;
        }
        return true;
    }
}

