/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host;

import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.html.DomDocumentFragment;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.impl.SimpleRange;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.host.Node;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLDocument;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLElement;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import org.apache.commons.collections.ListUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Range
extends SimpleScriptable {
    private static final long serialVersionUID = 4326375945958952177L;
    private Node startContainer_;
    private Node endContainer_;
    private int startOffset_;
    private int endOffset_;

    public Range() {
    }

    public Range(HTMLDocument document) {
        this.startContainer_ = document;
        this.endContainer_ = document;
    }

    Range(org.w3c.dom.ranges.Range w3cRange) {
        DomNode domNodeStartContainer = (DomNode)w3cRange.getStartContainer();
        this.startContainer_ = (Node)domNodeStartContainer.getScriptObject();
        this.startOffset_ = w3cRange.getStartOffset();
        DomNode domNodeEndContainer = (DomNode)w3cRange.getEndContainer();
        this.endContainer_ = (Node)domNodeEndContainer.getScriptObject();
        this.endOffset_ = w3cRange.getEndOffset();
    }

    @Override
    public Object getDefaultValue(Class<?> hint) {
        return this.toW3C().toString();
    }

    public Object jsxGet_startContainer() {
        if (this.startContainer_ == null) {
            return Context.getUndefinedValue();
        }
        return this.startContainer_;
    }

    public Object jsxGet_endContainer() {
        if (this.endContainer_ == null) {
            return Context.getUndefinedValue();
        }
        return this.endContainer_;
    }

    public int jsxGet_startOffset() {
        return this.startOffset_;
    }

    public int jsxGet_endOffset() {
        return this.endOffset_;
    }

    public void jsxFunction_setStart(Node refNode, int offset) {
        if (refNode == null) {
            throw Context.reportRuntimeError((String)"It is illegal to call Range.setStart() with a null node.");
        }
        this.startContainer_ = refNode;
        this.startOffset_ = offset;
    }

    public void jsxFunction_setStartAfter(Node refNode) {
        if (refNode == null) {
            throw Context.reportRuntimeError((String)"It is illegal to call Range.setStartAfter() with a null node.");
        }
        this.startContainer_ = refNode.getParent();
        this.startOffset_ = this.getPositionInContainer(refNode) + 1;
    }

    public void jsxFunction_setStartBefore(Node refNode) {
        if (refNode == null) {
            throw Context.reportRuntimeError((String)"It is illegal to call Range.setStartBefore() with a null node.");
        }
        this.startContainer_ = refNode.getParent();
        this.startOffset_ = this.getPositionInContainer(refNode);
    }

    private int getPositionInContainer(Node refNode) {
        int i = 0;
        Node node = refNode;
        while (node.jsxGet_previousSibling() != null) {
            node = node.jsxGet_previousSibling();
            ++i;
        }
        return i;
    }

    public boolean jsxGet_collapsed() {
        return this.startContainer_ == this.endContainer_ && this.startOffset_ == this.endOffset_;
    }

    public void jsxFunction_setEnd(Node refNode, int offset) {
        if (refNode == null) {
            throw Context.reportRuntimeError((String)"It is illegal to call Range.setEnd() with a null node.");
        }
        this.endContainer_ = refNode;
        this.endOffset_ = offset;
    }

    public void jsxFunction_setEndAfter(Node refNode) {
        if (refNode == null) {
            throw Context.reportRuntimeError((String)"It is illegal to call Range.setEndAfter() with a null node.");
        }
        this.endContainer_ = refNode.getParent();
        this.endOffset_ = this.getPositionInContainer(refNode) + 1;
    }

    public void jsxFunction_setEndBefore(Node refNode) {
        if (refNode == null) {
            throw Context.reportRuntimeError((String)"It is illegal to call Range.setEndBefore() with a null node.");
        }
        this.startContainer_ = refNode.getParent();
        this.startOffset_ = this.getPositionInContainer(refNode);
    }

    public void jsxFunction_selectNodeContents(Node refNode) {
        this.startContainer_ = refNode;
        this.startOffset_ = 0;
        this.endContainer_ = refNode;
        this.endOffset_ = refNode.jsxGet_childNodes().jsxGet_length();
    }

    public void jsxFunction_selectNode(Node refNode) {
        this.jsxFunction_setStartBefore(refNode);
        this.jsxFunction_setEndAfter(refNode);
    }

    public void jsxFunction_collapse(boolean toStart) {
        if (toStart) {
            this.endContainer_ = this.startContainer_;
            this.endOffset_ = this.startOffset_;
        } else {
            this.startContainer_ = this.endContainer_;
            this.startOffset_ = this.endOffset_;
        }
    }

    public Object jsxGet_commonAncestorContainer() {
        Node ancestor = this.getCommonAncestor();
        if (ancestor == null) {
            return Context.getUndefinedValue();
        }
        return ancestor;
    }

    private Node getCommonAncestor() {
        List<Node> endAncestors;
        List<Node> startAncestors = this.getAncestorsAndSelf(this.startContainer_);
        List commonAncestors = ListUtils.intersection(startAncestors, endAncestors = this.getAncestorsAndSelf(this.endContainer_));
        if (commonAncestors.isEmpty()) {
            return null;
        }
        return (Node)commonAncestors.get(commonAncestors.size() - 1);
    }

    private List<Node> getAncestorsAndSelf(Node node) {
        ArrayList<Node> ancestors = new ArrayList<Node>();
        for (Node ancestor = node; ancestor != null; ancestor = ancestor.getParent()) {
            ancestors.add(0, ancestor);
        }
        return ancestors;
    }

    public Object jsxFunction_createContextualFragment(String valueAsString) {
        SgmlPage page = ((DomNode)this.startContainer_.getDomNodeOrDie()).getPage();
        DomDocumentFragment fragment = new DomDocumentFragment(page);
        HTMLElement.parseHtmlSnippet(fragment, true, valueAsString);
        return fragment.getScriptObject();
    }

    public Object jsxFunction_extractContents() {
        return this.toW3C().extractContents().getScriptObject();
    }

    public SimpleRange toW3C() {
        return new SimpleRange((org.w3c.dom.Node)this.startContainer_.getDomNodeOrNull(), this.startOffset_, (org.w3c.dom.Node)this.endContainer_.getDomNodeOrDie(), this.endOffset_);
    }
}

