/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.html;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.HtmlTable;
import com.gargoylesoftware.htmlunit.html.HtmlTableRow;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLCollection;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLTableComponent;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Undefined;

public class HTMLTableRowElement
extends HTMLTableComponent {
    private static final long serialVersionUID = 3256441404401397812L;
    private HTMLCollection cells_;

    public int jsxGet_rowIndex() {
        HtmlTableRow row = (HtmlTableRow)this.getDomNodeOrDie();
        HtmlTable table = row.getEnclosingTable();
        if (table == null) {
            return -1;
        }
        return table.getRows().indexOf(row);
    }

    public int jsxGet_sectionRowIndex() {
        DomNode row = this.getDomNodeOrDie();
        HtmlTable table = ((HtmlTableRow)row).getEnclosingTable();
        if (table == null) {
            if (!this.getBrowserVersion().hasFeature(BrowserVersionFeatures.GENERATED_108)) {
                return -1;
            }
            return 5461640;
        }
        int index = -1;
        while (row != null) {
            if (row instanceof HtmlTableRow) {
                ++index;
            }
            row = row.getPreviousSibling();
        }
        return index;
    }

    public Object jsxGet_cells() {
        if (this.cells_ == null) {
            this.cells_ = new HTMLCollection(this);
            this.cells_.init(this.getDomNodeOrDie(), "./td|th");
        }
        return this.cells_;
    }

    public String jsxGet_bgColor() {
        return this.getDomNodeOrDie().getAttribute("bgColor");
    }

    public void jsxSet_bgColor(String bgColor) {
        this.setColorAttribute("bgColor", bgColor);
    }

    public Object jsxFunction_insertCell(Object index) {
        boolean indexValid;
        int position = -1;
        if (index != Undefined.instance) {
            position = (int)Context.toNumber((Object)index);
        }
        HtmlTableRow htmlRow = (HtmlTableRow)this.getDomNodeOrDie();
        boolean bl = indexValid = position >= -1 && position <= htmlRow.getCells().size();
        if (indexValid) {
            HtmlElement newCell = ((HtmlPage)htmlRow.getPage()).createElement("td");
            if (position == -1 || position == htmlRow.getCells().size()) {
                htmlRow.appendChild(newCell);
            } else {
                htmlRow.getCell(position).insertBefore(newCell);
            }
            return this.getScriptableFor(newCell);
        }
        throw Context.reportRuntimeError((String)"Index or size is negative or greater than the allowed amount");
    }

    public void jsxFunction_deleteCell(Object index) {
        boolean indexValid;
        int position = -1;
        if (index != Undefined.instance) {
            position = (int)Context.toNumber((Object)index);
        } else if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.GENERATED_172)) {
            throw Context.reportRuntimeError((String)"No enough arguments");
        }
        HtmlTableRow htmlRow = (HtmlTableRow)this.getDomNodeOrDie();
        if (position == -1) {
            position = htmlRow.getCells().size() - 1;
        }
        boolean bl = indexValid = position >= -1 && position <= htmlRow.getCells().size();
        if (!indexValid) {
            throw Context.reportRuntimeError((String)"Index or size is negative or greater than the allowed amount");
        }
        htmlRow.getCell(position).remove();
    }
}

