/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.http.cookie.ClientCookie;
import org.apache.http.impl.cookie.BasicClientCookie;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Cookie
implements Serializable {
    private final String name_;
    private final String value_;
    private final String domain_;
    private final String path_;
    private final Date expires_;
    private final boolean secure_;
    private final boolean httponly_;

    @Deprecated
    public Cookie(String name, String value) {
        this(null, name, value);
    }

    public Cookie(String domain, String name, String value) {
        this(domain, name, value, null, null, false);
    }

    public Cookie(String domain, String name, String value, String path, Date expires, boolean secure) {
        this(domain, name, value, path, expires, secure, false);
    }

    public Cookie(String domain, String name, String value, String path, Date expires, boolean secure, boolean httpOnly) {
        if (domain == null) {
            throw new IllegalArgumentException("Cookie domain must be specified");
        }
        this.domain_ = domain;
        this.name_ = name;
        this.value_ = value != null ? value : "";
        this.path_ = path;
        this.expires_ = expires;
        this.secure_ = secure;
        this.httponly_ = httpOnly;
    }

    public Cookie(org.apache.http.cookie.Cookie c) {
        this(c.getDomain(), c.getName(), c.getValue(), c.getPath(), c.getExpiryDate(), c.isSecure(), ((ClientCookie)c).getAttribute("httponly") != null);
    }

    public Cookie(String domain, String name, String value, String path, int maxAge, boolean secure) {
        this.domain_ = domain;
        this.name_ = name;
        this.value_ = value != null ? value : "";
        this.path_ = path;
        this.secure_ = secure;
        this.httponly_ = false;
        if (maxAge < -1) {
            throw new IllegalArgumentException("invalid max age:  " + maxAge);
        }
        this.expires_ = maxAge >= 0 ? new Date(System.currentTimeMillis() + (long)maxAge * 1000L) : null;
    }

    public String getName() {
        return this.name_;
    }

    public String getValue() {
        return this.value_;
    }

    public String getDomain() {
        return this.domain_;
    }

    public String getPath() {
        return this.path_;
    }

    public Date getExpires() {
        return this.expires_;
    }

    public boolean isSecure() {
        return this.secure_;
    }

    public boolean isHttpOnly() {
        return this.httponly_;
    }

    public String toString() {
        return this.name_ + "=" + this.value_ + (this.domain_ != null ? ";domain=" + this.domain_ : "") + (this.path_ != null ? ";path=" + this.path_ : "") + (this.expires_ != null ? ";expires=" + this.expires_ : "") + (this.secure_ ? ";secure" : "") + (this.httponly_ ? ";httpOnly" : "");
    }

    public boolean equals(Object o) {
        if (!(o instanceof Cookie)) {
            return false;
        }
        Cookie other = (Cookie)o;
        String path = this.path_ == null ? "/" : this.path_;
        String otherPath = other.path_ == null ? "/" : other.path_;
        return new EqualsBuilder().append((Object)this.name_, (Object)other.name_).append((Object)this.domain_, (Object)other.domain_).append((Object)path, (Object)otherPath).isEquals();
    }

    public int hashCode() {
        String path = this.path_ == null ? "/" : this.path_;
        return new HashCodeBuilder().append((Object)this.name_).append((Object)this.domain_).append((Object)path).toHashCode();
    }

    public org.apache.http.cookie.Cookie toHttpClient() {
        BasicClientCookie cookie = new BasicClientCookie(this.name_, this.value_);
        cookie.setDomain(this.domain_);
        cookie.setPath(this.path_);
        cookie.setExpiryDate(this.expires_);
        cookie.setSecure(this.secure_);
        if (this.httponly_) {
            cookie.setAttribute("httponly", "true");
        }
        return cookie;
    }

    public static org.apache.http.cookie.Cookie[] toHttpClient(Collection<Cookie> cookies) {
        org.apache.http.cookie.Cookie[] array = new org.apache.http.cookie.Cookie[cookies.size()];
        Iterator<Cookie> it = cookies.iterator();
        for (int i = 0; i < cookies.size(); ++i) {
            array[i] = it.next().toHttpClient();
        }
        return array;
    }

    public static List<Cookie> fromHttpClient(List<org.apache.http.cookie.Cookie> cookies) {
        ArrayList<Cookie> list = new ArrayList<Cookie>(cookies.size());
        for (org.apache.http.cookie.Cookie c : cookies) {
            list.add(new Cookie(c));
        }
        return list;
    }
}

