/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.html;

import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.HtmlAnchor;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.javascript.configuration.BrowserName;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxSetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.WebBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLElement;
import com.gargoylesoftware.htmlunit.util.UrlUtils;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.lang3.StringUtils;

@JsxClass(domClasses={HtmlAnchor.class})
public class HTMLAnchorElement
extends HTMLElement {
    @JsxSetter
    public void setHref(String href) {
        this.getDomNodeOrDie().setAttribute("href", href);
    }

    @JsxGetter
    public String getHref() {
        HtmlAnchor anchor = (HtmlAnchor)this.getDomNodeOrDie();
        String hrefAttr = anchor.getHrefAttribute();
        if (hrefAttr == DomElement.ATTRIBUTE_NOT_DEFINED) {
            return "";
        }
        try {
            return this.getUrl().toString();
        }
        catch (MalformedURLException e) {
            return hrefAttr;
        }
    }

    @JsxSetter
    public void setName(String name) {
        this.getDomNodeOrDie().setAttribute("name", name);
    }

    @JsxGetter
    public String getName() {
        return this.getDomNodeOrDie().getAttribute("name");
    }

    @JsxSetter
    public void setTarget(String target) {
        this.getDomNodeOrDie().setAttribute("target", target);
    }

    @JsxGetter
    public String getTarget() {
        return this.getDomNodeOrDie().getAttribute("target");
    }

    private URL getUrl() throws MalformedURLException {
        HtmlAnchor anchor = (HtmlAnchor)this.getDomNodeOrDie();
        return ((HtmlPage)anchor.getPage()).getFullyQualifiedUrl(anchor.getHrefAttribute());
    }

    private void setUrl(URL url) {
        this.getDomNodeOrDie().setAttribute("href", url.toString());
    }

    @JsxSetter
    public void setRel(String rel) {
        this.getDomNodeOrDie().setAttribute("rel", rel);
    }

    @JsxGetter
    public String getRel() {
        return ((HtmlAnchor)this.getDomNodeOrDie()).getRelAttribute();
    }

    @JsxSetter
    public void setRev(String rel) {
        this.getDomNodeOrDie().setAttribute("rev", rel);
    }

    @JsxGetter
    public String getRev() {
        return ((HtmlAnchor)this.getDomNodeOrDie()).getRevAttribute();
    }

    @JsxGetter
    public String getSearch() throws Exception {
        String query = this.getUrl().getQuery();
        if (query == null) {
            return "";
        }
        return "?" + query;
    }

    @JsxSetter
    public void setSearch(String search) throws Exception {
        String query = search == null || "?".equals(search) || "".equals(search) ? null : (search.charAt(0) == '?' ? search.substring(1) : search);
        this.setUrl(UrlUtils.getUrlWithNewQuery(this.getUrl(), query));
    }

    @JsxGetter
    public String getHash() throws Exception {
        String hash = this.getUrl().getRef();
        if (hash == null) {
            return "";
        }
        return "#" + hash;
    }

    @JsxSetter
    public void setHash(String hash) throws Exception {
        this.setUrl(UrlUtils.getUrlWithNewRef(this.getUrl(), hash));
    }

    @JsxGetter
    public String getHost() throws Exception {
        URL url = this.getUrl();
        int port = url.getPort();
        String host = url.getHost();
        if (port == -1) {
            return host;
        }
        return host + ":" + port;
    }

    @JsxSetter
    public void setHost(String host) throws Exception {
        int port;
        String hostname;
        int index = host.indexOf(58);
        if (index != -1) {
            hostname = host.substring(0, index);
            port = Integer.parseInt(host.substring(index + 1));
        } else {
            hostname = host;
            port = -1;
        }
        URL url = UrlUtils.getUrlWithNewHostAndPort(this.getUrl(), hostname, port);
        this.setUrl(url);
    }

    @JsxGetter
    public String getHostname() throws Exception {
        return this.getUrl().getHost();
    }

    @JsxSetter
    public void setHostname(String hostname) throws Exception {
        this.setUrl(UrlUtils.getUrlWithNewHost(this.getUrl(), hostname));
    }

    @JsxGetter
    public String getPathname() throws Exception {
        return this.getUrl().getPath();
    }

    @JsxSetter
    public void setPathname(String pathname) throws Exception {
        this.setUrl(UrlUtils.getUrlWithNewPath(this.getUrl(), pathname));
    }

    @JsxGetter
    public String getPort() throws Exception {
        int port = this.getUrl().getPort();
        if (port == -1) {
            return "";
        }
        return Integer.toString(port);
    }

    @JsxSetter
    public void setPort(String port) throws Exception {
        this.setUrl(UrlUtils.getUrlWithNewPort(this.getUrl(), Integer.parseInt(port)));
    }

    @JsxGetter
    public String getProtocol() throws Exception {
        return this.getUrl().getProtocol() + ":";
    }

    @JsxSetter
    public void setProtocol(String protocol) throws Exception {
        String bareProtocol = StringUtils.substringBefore((String)protocol, (String)":");
        this.setUrl(UrlUtils.getUrlWithNewProtocol(this.getUrl(), bareProtocol));
    }

    @Override
    public Object getDefaultValue(Class<?> hint) {
        HtmlElement element = this.getDomNodeOrNull();
        if (element == null) {
            return super.getDefaultValue(null);
        }
        return HTMLAnchorElement.getDefaultValue(element);
    }

    static String getDefaultValue(HtmlElement element) {
        String anchorPart;
        String beforeAnchor;
        String href = element.getAttribute("href");
        if (DomElement.ATTRIBUTE_NOT_DEFINED == href) {
            return "";
        }
        href = href.trim();
        SgmlPage sgmlPage = element.getPage();
        if (!(sgmlPage instanceof HtmlPage)) {
            return href;
        }
        int indexAnchor = href.indexOf(35);
        if (indexAnchor == -1) {
            beforeAnchor = href;
            anchorPart = "";
        } else {
            beforeAnchor = href.substring(0, indexAnchor);
            anchorPart = href.substring(indexAnchor);
        }
        try {
            HtmlPage htmlPage = (HtmlPage)sgmlPage;
            String response = htmlPage.getFullyQualifiedUrl(beforeAnchor).toExternalForm() + anchorPart;
            return response;
        }
        catch (MalformedURLException e) {
            return href;
        }
    }

    @Override
    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)})
    public String getAccessKey() {
        return super.getAccessKey();
    }

    @Override
    @JsxSetter(value={@WebBrowser(value=BrowserName.FF)})
    public void setAccessKey(String accessKey) {
        super.setAccessKey(accessKey);
    }
}

