/*
 * This file was generated automatically by ExtUtils::ParseXS version 3.07 from the
 * contents of perl_libzmq2.xs. Do not edit this file, edit perl_libzmq2.xs instead.
 *
 *    ANY CHANGES MADE HERE WILL BE LOST!
 *
 */

#line 1 "xs/perl_libzmq2.xs"
#include "perl_libzmq2.h"
#include "xshelper.h"

#if (PERLZMQ_TRACE > 0)
#define PerlLibzmq2_trace(...) \
    { \
        PerlIO_printf(PerlIO_stderr(), "[perlzmq] "); \
        PerlIO_printf(PerlIO_stderr(), __VA_ARGS__); \
        PerlIO_printf(PerlIO_stderr(), "\n"); \
    }
#else
#define PerlLibzmq2_trace(...)
#endif

STATIC_INLINE void
PerlLibzmq2_set_bang(pTHX_ int err) {
    SV *errsv = get_sv("!", GV_ADD);
    PerlLibzmq2_trace("Set ERRSV ($!) to %d", err);
    sv_setiv(errsv, err);
}

static
SV *
PerlLibzmq2_zmq_getsockopt_int(PerlLibzmq2_Socket *sock, int option) {
    size_t len;
    int    status;
    I32    i32;
    SV     *sv;

    len = sizeof(i32);
    status = zmq_getsockopt(sock->socket, option, &i32, &len);
    if(status == 0) {
        sv = newSViv(i32);
    } else {
        SET_BANG;
    }
    return sv;
}

static
SV *
PerlLibzmq2_zmq_getsockopt_int64(PerlLibzmq2_Socket *sock, int option) {
    size_t  len;
    int     status;
    int64_t i64;
    SV      *sv;

    len = sizeof(i64);
    status = zmq_getsockopt(sock->socket, option, &i64, &len);
    if(status == 0) {
        sv = newSViv(i64);
    } else {
        SET_BANG;
    }
    return sv;
}

static
SV *
PerlLibzmq2_zmq_getsockopt_uint64(PerlLibzmq2_Socket *sock, int option) {
    size_t len;
    int    status;
    uint64_t u64;
    SV *sv;

    len = sizeof(u64);
    status = zmq_getsockopt(sock->socket, option, &u64, &len);
    if(status == 0) {
        sv = newSVuv(u64);
    } else {
        SET_BANG;
    }
    return sv;
}

static
SV *
PerlLibzmq2_zmq_getsockopt_string(PerlLibzmq2_Socket *sock, int option, size_t len) {
    int    status;
    char   *string;
    SV     *sv;

    Newxz(string, len, char);
    status = zmq_getsockopt(sock->socket, option, &string, &len);
    if(status == 0) {
        sv = newSVpvn(string, len);
    } else {
        SET_BANG;
    }
    Safefree(string);

    return sv;
}


STATIC_INLINE
int
PerlLibzmq2_zmq_setsockopt_int( PerlLibzmq2_Socket *sock, int option, int val) {
    int status;
    status = zmq_setsockopt(sock->socket, option, &val, sizeof(int));
    if (status != 0) {
        SET_BANG;
    }
    return status;
}

STATIC_INLINE
int
PerlLibzmq2_zmq_setsockopt_int64( PerlLibzmq2_Socket *sock, int option, int64_t val) {
    int status;
    status = zmq_setsockopt(sock->socket, option, &val, sizeof(int64_t));
    if (status != 0) {
        SET_BANG;
    }
    return status;
}

static
int
PerlLibzmq2_zmq_setsockopt_uint64(PerlLibzmq2_Socket *sock, int option, uint64_t val) {
    int status;
    status = zmq_setsockopt(sock->socket, option, &val, sizeof(uint64_t));
    if (status != 0) {
        SET_BANG;
    }
    return status;
}
    
static
int
PerlLibzmq2_zmq_setsockopt_string(PerlLibzmq2_Socket *sock, int option, const char *ptr, size_t len) {
    int status;
    status = zmq_setsockopt(sock->socket, option, ptr, len);
    if (status != 0) {
        SET_BANG;
    }
    return status;
}

STATIC_INLINE int
PerlLibzmq2_Message_mg_dup(pTHX_ MAGIC* const mg, CLONE_PARAMS* const param) {
    PerlLibzmq2_Message *const src = (PerlLibzmq2_Message *) mg->mg_ptr;
    PerlLibzmq2_Message *dest;

    PerlLibzmq2_trace("Message -> dup");
    PERL_UNUSED_VAR( param );
 
    Newxz( dest, 1, PerlLibzmq2_Message );
    zmq_msg_init( dest );
    zmq_msg_copy ( dest, src );
    mg->mg_ptr = (char *) dest;
    return 0;
}

STATIC_INLINE int
PerlLibzmq2_Message_mg_free( pTHX_ SV * const sv, MAGIC *const mg ) {
    PerlLibzmq2_Message* const msg = (PerlLibzmq2_Message *) mg->mg_ptr;

    PERL_UNUSED_VAR(sv);
    PerlLibzmq2_trace( "START mg_free (Message)" );
    if ( msg != NULL ) {
        PerlLibzmq2_trace( " + zmq message %p", msg );
        zmq_msg_close( msg );
        Safefree( msg );
    }
    PerlLibzmq2_trace( "END mg_free (Message)" );
    return 1;
}

STATIC_INLINE MAGIC*
PerlLibzmq2_Message_mg_find(pTHX_ SV* const sv, const MGVTBL* const vtbl){
    MAGIC* mg;

    assert(sv   != NULL);
    assert(vtbl != NULL);

    for(mg = SvMAGIC(sv); mg; mg = mg->mg_moremagic){
        if(mg->mg_virtual == vtbl){
            assert(mg->mg_type == PERL_MAGIC_ext);
            return mg;
        }
    }

    croak("ZMQ::LibZMQ2::Message: Invalid ZMQ::LibZMQ2::Message object was passed to mg_find");
    return NULL; /* not reached */
}

STATIC_INLINE int
PerlLibzmq2_Context_mg_free( pTHX_ SV * const sv, MAGIC *const mg ) {
    PerlLibzmq2_Context* const ctxt = (PerlLibzmq2_Context *) mg->mg_ptr;
    PERL_UNUSED_VAR(sv);

    PerlLibzmq2_trace("START mg_free (Context)");
    if (ctxt != NULL) {
#ifdef USE_ITHREADS
        PerlLibzmq2_trace( " + thread enabled. thread %p", aTHX );
        PerlLibzmq2_trace( " + context wrapper %p with zmq context %p", ctxt, ctxt->ctxt );
        if ( ctxt->interp == aTHX ) { /* is where I came from */
            PerlLibzmq2_trace( " + detected mg_free from creating thread %p, cleaning up", aTHX );
            zmq_term( ctxt->ctxt );
            mg->mg_ptr = NULL;
            Safefree(ctxt);
        }
#else
        PerlLibzmq2_trace(" + zmq context %p", ctxt);
        zmq_term( ctxt );
        mg->mg_ptr = NULL;
#endif
    }
    PerlLibzmq2_trace("END mg_free (Context)");
    return 1;
}

STATIC_INLINE MAGIC*
PerlLibzmq2_Context_mg_find(pTHX_ SV* const sv, const MGVTBL* const vtbl){
    MAGIC* mg;

    assert(sv   != NULL);
    assert(vtbl != NULL);

    for(mg = SvMAGIC(sv); mg; mg = mg->mg_moremagic){
        if(mg->mg_virtual == vtbl){
            assert(mg->mg_type == PERL_MAGIC_ext);
            return mg;
        }
    }

    croak("ZMQ::LibZMQ2::Context: Invalid ZMQ::LibZMQ2::Context object was passed to mg_find");
    return NULL; /* not reached */
}

STATIC_INLINE int
PerlLibzmq2_Context_mg_dup(pTHX_ MAGIC* const mg, CLONE_PARAMS* const param){
    PERL_UNUSED_VAR(mg);
    PERL_UNUSED_VAR(param);
    return 0;
}

STATIC_INLINE int
PerlLibzmq2_Socket_invalidate( PerlLibzmq2_Socket *sock )
{
    SV *ctxt_sv = sock->assoc_ctxt;
    int rv;

    PerlLibzmq2_trace("START socket_invalidate");
    PerlLibzmq2_trace(" + zmq socket %p", sock->socket);
    rv = zmq_close( sock->socket );

    if ( SvOK(ctxt_sv) ) {
        PerlLibzmq2_trace(" + associated context: %p", ctxt_sv);
        SvREFCNT_dec(ctxt_sv);
        sock->assoc_ctxt = NULL;
    }

    Safefree(sock);

    PerlLibzmq2_trace("END socket_invalidate");
    return rv;
}

STATIC_INLINE int
PerlLibzmq2_Socket_mg_free(pTHX_ SV* const sv, MAGIC* const mg)
{
    PerlLibzmq2_Socket* const sock = (PerlLibzmq2_Socket *) mg->mg_ptr;
    PERL_UNUSED_VAR(sv);
    PerlLibzmq2_trace("START mg_free (Socket)");
    if (sock) {
        PerlLibzmq2_Socket_invalidate( sock );
        mg->mg_ptr = NULL;
    }
    PerlLibzmq2_trace("END mg_free (Socket)");
    return 1;
}

STATIC_INLINE int
PerlLibzmq2_Socket_mg_dup(pTHX_ MAGIC* const mg, CLONE_PARAMS* const param){
#ifdef USE_ITHREADS /* single threaded perl has no "xxx_dup()" APIs */
    mg->mg_ptr = NULL;
    PERL_UNUSED_VAR(param);
#else
    PERL_UNUSED_VAR(mg);
    PERL_UNUSED_VAR(param);
#endif
    return 0;
}

STATIC_INLINE MAGIC*
PerlLibzmq2_Socket_mg_find(pTHX_ SV* const sv, const MGVTBL* const vtbl){
    MAGIC* mg;

    assert(sv   != NULL);
    assert(vtbl != NULL);

    for(mg = SvMAGIC(sv); mg; mg = mg->mg_moremagic){
        if(mg->mg_virtual == vtbl){
            assert(mg->mg_type == PERL_MAGIC_ext);
            return mg;
        }
    }

    croak("ZMQ::LibZMQ2::Socket: Invalid ZMQ::LibZMQ2::Socket object was passed to mg_find");
    return NULL; /* not reached */
}

STATIC_INLINE void 
PerlLibzmq2_free_string(void *data, void *hint) {
    PerlLibzmq2_trace("START free_string");
    PERL_UNUSED_ARG(hint);
    free(data);
    PerlLibzmq2_trace("END free_string");
}

#include "mg-xs.inc"

#line 325 "xs/perl_libzmq2.c"
#ifndef PERL_UNUSED_VAR
#  define PERL_UNUSED_VAR(var) if (0) var = var
#endif

#ifndef dVAR
#  define dVAR		dNOOP
#endif


/* This stuff is not part of the API! You have been warned. */
#ifndef PERL_VERSION_DECIMAL
#  define PERL_VERSION_DECIMAL(r,v,s) (r*1000000 + v*1000 + s)
#endif
#ifndef PERL_DECIMAL_VERSION
#  define PERL_DECIMAL_VERSION \
	  PERL_VERSION_DECIMAL(PERL_REVISION,PERL_VERSION,PERL_SUBVERSION)
#endif
#ifndef PERL_VERSION_GE
#  define PERL_VERSION_GE(r,v,s) \
	  (PERL_DECIMAL_VERSION >= PERL_VERSION_DECIMAL(r,v,s))
#endif
#ifndef PERL_VERSION_LE
#  define PERL_VERSION_LE(r,v,s) \
	  (PERL_DECIMAL_VERSION <= PERL_VERSION_DECIMAL(r,v,s))
#endif

/* XS_INTERNAL is the explicit static-linkage variant of the default
 * XS macro.
 *
 * XS_EXTERNAL is the same as XS_INTERNAL except it does not include
 * "STATIC", ie. it exports XSUB symbols. You probably don't want that
 * for anything but the BOOT XSUB.
 *
 * See XSUB.h in core!
 */


/* TODO: This might be compatible further back than 5.10.0. */
#if PERL_VERSION_GE(5, 10, 0) && PERL_VERSION_LE(5, 15, 1)
#  undef XS_EXTERNAL
#  undef XS_INTERNAL
#  if defined(__CYGWIN__) && defined(USE_DYNAMIC_LOADING)
#    define XS_EXTERNAL(name) __declspec(dllexport) XSPROTO(name)
#    define XS_INTERNAL(name) STATIC XSPROTO(name)
#  endif
#  if defined(__SYMBIAN32__)
#    define XS_EXTERNAL(name) EXPORT_C XSPROTO(name)
#    define XS_INTERNAL(name) EXPORT_C STATIC XSPROTO(name)
#  endif
#  ifndef XS_EXTERNAL
#    if defined(HASATTRIBUTE_UNUSED) && !defined(__cplusplus)
#      define XS_EXTERNAL(name) void name(pTHX_ CV* cv __attribute__unused__)
#      define XS_INTERNAL(name) STATIC void name(pTHX_ CV* cv __attribute__unused__)
#    else
#      ifdef __cplusplus
#        define XS_EXTERNAL(name) extern "C" XSPROTO(name)
#        define XS_INTERNAL(name) static XSPROTO(name)
#      else
#        define XS_EXTERNAL(name) XSPROTO(name)
#        define XS_INTERNAL(name) STATIC XSPROTO(name)
#      endif
#    endif
#  endif
#endif

/* perl >= 5.10.0 && perl <= 5.15.1 */


/* The XS_EXTERNAL macro is used for functions that must not be static
 * like the boot XSUB of a module. If perl didn't have an XS_EXTERNAL
 * macro defined, the best we can do is assume XS is the same.
 * Dito for XS_INTERNAL.
 */
#ifndef XS_EXTERNAL
#  define XS_EXTERNAL(name) XS(name)
#endif
#ifndef XS_INTERNAL
#  define XS_INTERNAL(name) XS(name)
#endif

/* Now, finally, after all this mess, we want an ExtUtils::ParseXS
 * internal macro that we're free to redefine for varying linkage due
 * to the EXPORT_XSUB_SYMBOLS XS keyword. This is internal, use
 * XS_EXTERNAL(name) or XS_INTERNAL(name) in your code if you need to!
 */

#undef XS_EUPXS
#if defined(PERL_EUPXS_ALWAYS_EXPORT)
#  define XS_EUPXS(name) XS_EXTERNAL(name)
#else
   /* default to internal */
#  define XS_EUPXS(name) XS_INTERNAL(name)
#endif

#ifndef PERL_ARGS_ASSERT_CROAK_XS_USAGE
#define PERL_ARGS_ASSERT_CROAK_XS_USAGE assert(cv); assert(params)

/* prototype to pass -Wmissing-prototypes */
STATIC void
S_croak_xs_usage(pTHX_ const CV *const cv, const char *const params);

STATIC void
S_croak_xs_usage(pTHX_ const CV *const cv, const char *const params)
{
    const GV *const gv = CvGV(cv);

    PERL_ARGS_ASSERT_CROAK_XS_USAGE;

    if (gv) {
        const char *const gvname = GvNAME(gv);
        const HV *const stash = GvSTASH(gv);
        const char *const hvname = stash ? HvNAME(stash) : NULL;

        if (hvname)
            Perl_croak(aTHX_ "Usage: %s::%s(%s)", hvname, gvname, params);
        else
            Perl_croak(aTHX_ "Usage: %s(%s)", gvname, params);
    } else {
        /* Pants. I don't think that it should be possible to get here. */
        Perl_croak(aTHX_ "Usage: CODE(0x%"UVxf")(%s)", PTR2UV(cv), params);
    }
}
#undef  PERL_ARGS_ASSERT_CROAK_XS_USAGE

#ifdef PERL_IMPLICIT_CONTEXT
#define croak_xs_usage(a,b)    S_croak_xs_usage(aTHX_ a,b)
#else
#define croak_xs_usage        S_croak_xs_usage
#endif

#endif

/* NOTE: the prototype of newXSproto() is different in versions of perls,
 * so we define a portable version of newXSproto()
 */
#ifdef newXS_flags
#define newXSproto_portable(name, c_impl, file, proto) newXS_flags(name, c_impl, file, proto, 0)
#else
#define newXSproto_portable(name, c_impl, file, proto) (PL_Sv=(SV*)newXS(name, c_impl, file), sv_setpv(PL_Sv, proto), (CV*)PL_Sv)
#endif /* !defined(newXS_flags) */

#line 467 "xs/perl_libzmq2.c"

/* INCLUDE:  Including 'const-xs.inc' from 'perl_libzmq2.xs' */


XS_EUPXS(XS_ZMQ__LibZMQ2__Constants__constant); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_ZMQ__LibZMQ2__Constants__constant)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	IV	RETVAL;
	dXSTARG;
#line 63 "xs/const-xs.inc"
        RETVAL = ix;
#line 484 "xs/perl_libzmq2.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


/* INCLUDE: Returning to 'perl_libzmq2.xs' from 'const-xs.inc' */


XS_EUPXS(XS_ZMQ__LibZMQ2_zmq_version); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_ZMQ__LibZMQ2_zmq_version)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
#line 331 "xs/perl_libzmq2.xs"
        int major, minor, patch;
        I32 gimme;
#line 506 "xs/perl_libzmq2.c"
#line 334 "xs/perl_libzmq2.xs"
        gimme = GIMME_V;
        if (gimme == G_VOID) {
            /* WTF? you don't want a return value?! */
            XSRETURN(0);
        }

        zmq_version(&major, &minor, &patch);
        if (gimme == G_SCALAR) {
            XPUSHs( sv_2mortal( newSVpvf( "%d.%d.%d", major, minor, patch ) ) );
            XSRETURN(1);
        } else {
            mXPUSHi( major );
            mXPUSHi( minor );
            mXPUSHi( patch );
            XSRETURN(3);
        }
#line 524 "xs/perl_libzmq2.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_ZMQ__LibZMQ2_zmq_init); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_ZMQ__LibZMQ2_zmq_init)
{
    dVAR; dXSARGS;
    if (items < 0 || items > 1)
       croak_xs_usage(cv,  "nthreads = 5");
    {
	int	nthreads;
#line 355 "xs/perl_libzmq2.xs"
        SV *class_sv = sv_2mortal(newSVpvn( "ZMQ::LibZMQ2::Context", 20 ));
#line 541 "xs/perl_libzmq2.c"
	PerlLibzmq2_Context *	RETVAL;

	if (items < 1)
	    nthreads = 5;
	else {
	    nthreads = (int)SvIV(ST(0))
;
	}
#line 357 "xs/perl_libzmq2.xs"
        PerlLibzmq2_trace( "START zmq_init" );
#ifdef USE_ITHREADS
        PerlLibzmq2_trace( " + threads enabled, aTHX %p", aTHX );
        Newxz( RETVAL, 1, PerlLibzmq2_Context );
        RETVAL->interp = aTHX;
        RETVAL->ctxt   = zmq_init( nthreads );
        PerlLibzmq2_trace( " + created context wrapper %p", RETVAL );
        PerlLibzmq2_trace( " + zmq context %p", RETVAL->ctxt );
#else
        PerlLibzmq2_trace( " + non-threaded context");
        RETVAL = zmq_init( nthreads );
#endif
        PerlLibzmq2_trace( "END zmq_init");
#line 564 "xs/perl_libzmq2.c"
	ST(0) = sv_newmortal();
        if (!RETVAL)          /* if null */
            SvOK_off(ST(0)); /* then return as undef instead of reaf to undef */
        else {
            /* setup ST(0) as a ref to a blessed hash hv */
            MAGIC *mg;
            HV *hv = newHV();
            const char *classname = "ZMQ::LibZMQ2::Context";
            /* take (sub)class name to use from class_sv if appropriate */
            if (SvMAGICAL(class_sv))
                mg_get(class_sv);
            if (SvOK( class_sv ) && sv_derived_from(class_sv, classname ) ) {
                if(SvROK(class_sv) && SvOBJECT(SvRV(class_sv))) {
                    classname = sv_reftype(SvRV(class_sv), TRUE);
                } else {
                    classname = SvPV_nolen(class_sv);
                }
            }
            sv_setsv(ST(0), sv_2mortal(newRV_noinc((SV*)hv)));
            (void)sv_bless(ST(0), gv_stashpv(classname, TRUE));
            mg = sv_magicext((SV*)hv, NULL, PERL_MAGIC_ext, &PerlLibzmq2_Context_vtbl, (char*) RETVAL, 0);
            mg->mg_flags |= MGf_DUP;
        }
    }
    XSRETURN(1);
}


XS_EUPXS(XS_ZMQ__LibZMQ2_zmq_term); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_ZMQ__LibZMQ2_zmq_term)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "context");
    {
	PerlLibzmq2_Context *	context;
	int	RETVAL;
	dXSTARG;

    {
        MAGIC *mg;
        context = NULL;
        if (! sv_isobject(ST(0))) {
            croak("Argument is not an object");
        }
        /* if it got here, it's a blessed reference. better be an HV */
        {
            SV *svr;
            SV **closed;
            svr = SvRV(ST(0));
            if (! svr ) {
                croak("PANIC: Could not get reference from blessed object.");
            }
            if (SvTYPE(svr) != SVt_PVHV) {
                croak("PANIC: Underlying storage of blessed reference is not a hash.");
            }
            closed = hv_fetchs( (HV *) svr, "_closed", 0 );
            if (closed != NULL && SvTRUE(*closed)) {
                /* if it's already closed, just return */
                XSRETURN_EMPTY;
            }
        }
        mg = PerlLibzmq2_Context_mg_find(aTHX_ SvRV(ST(0)), &PerlLibzmq2_Context_vtbl);
        if (mg) {
            context = (PerlLibzmq2_Context *) mg->mg_ptr;
        }
        if (context == NULL)
            croak("Invalid ZMQ::LibZMQ2::Context object (perhaps you've already freed it?)");
    }
;
#line 377 "xs/perl_libzmq2.xs"
#ifdef USE_ITHREADS
        RETVAL = zmq_term( context->ctxt );
#else
        RETVAL = zmq_term( context );
#endif
        if (RETVAL == 0) {
            /* Cancel the SV's mg attr so to not call zmq_term automatically */
            MAGIC *mg =
                PerlLibzmq2_Context_mg_find( aTHX_ SvRV(ST(0)), &PerlLibzmq2_Context_vtbl );
            mg->mg_ptr = NULL;
        }

        /* mark the original SV's _closed flag as true */
        {
            SV *svr = SvRV(ST(0));
            if (hv_stores( (HV *) svr, "_closed", &PL_sv_yes ) == NULL) {
                croak("PANIC: Failed to store closed flag on blessed reference");
            }
        }
#line 655 "xs/perl_libzmq2.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_ZMQ__LibZMQ2_zmq_msg_init); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_ZMQ__LibZMQ2_zmq_msg_init)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 402 "xs/perl_libzmq2.xs"
        SV *class_sv = sv_2mortal(newSVpvn( "ZMQ::LibZMQ2::Message", 20 ));
        int rc;
#line 672 "xs/perl_libzmq2.c"
	PerlLibzmq2_Message *	RETVAL;
#line 405 "xs/perl_libzmq2.xs"
        Newxz( RETVAL, 1, PerlLibzmq2_Message );
        rc = zmq_msg_init( RETVAL );
        if ( rc != 0 ) {
            SET_BANG;
            zmq_msg_close( RETVAL );
            RETVAL = NULL;
        }
#line 682 "xs/perl_libzmq2.c"
	ST(0) = sv_newmortal();
        if (!RETVAL)          /* if null */
            SvOK_off(ST(0)); /* then return as undef instead of reaf to undef */
        else {
            /* setup ST(0) as a ref to a blessed hash hv */
            MAGIC *mg;
            HV *hv = newHV();
            const char *classname = "ZMQ::LibZMQ2::Message";
            /* take (sub)class name to use from class_sv if appropriate */
            if (SvMAGICAL(class_sv))
                mg_get(class_sv);
            if (SvOK( class_sv ) && sv_derived_from(class_sv, classname ) ) {
                if(SvROK(class_sv) && SvOBJECT(SvRV(class_sv))) {
                    classname = sv_reftype(SvRV(class_sv), TRUE);
                } else {
                    classname = SvPV_nolen(class_sv);
                }
            }
            sv_setsv(ST(0), sv_2mortal(newRV_noinc((SV*)hv)));
            (void)sv_bless(ST(0), gv_stashpv(classname, TRUE));
            mg = sv_magicext((SV*)hv, NULL, PERL_MAGIC_ext, &PerlLibzmq2_Message_vtbl, (char*) RETVAL, 0);
            mg->mg_flags |= MGf_DUP;
        }
    }
    XSRETURN(1);
}


XS_EUPXS(XS_ZMQ__LibZMQ2_zmq_msg_init_size); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_ZMQ__LibZMQ2_zmq_msg_init_size)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "size");
    {
	IV	size = (IV)SvIV(ST(0))
;
#line 419 "xs/perl_libzmq2.xs"
        SV *class_sv = sv_2mortal(newSVpvn( "ZMQ::LibZMQ2::Message", 20 ));
        int rc;
#line 723 "xs/perl_libzmq2.c"
	PerlLibzmq2_Message *	RETVAL;
#line 422 "xs/perl_libzmq2.xs"
        Newxz( RETVAL, 1, PerlLibzmq2_Message );
        rc = zmq_msg_init_size(RETVAL, size);
        if ( rc != 0 ) {
            SET_BANG;
            zmq_msg_close( RETVAL );
            RETVAL = NULL;
        }
#line 733 "xs/perl_libzmq2.c"
	ST(0) = sv_newmortal();
        if (!RETVAL)          /* if null */
            SvOK_off(ST(0)); /* then return as undef instead of reaf to undef */
        else {
            /* setup ST(0) as a ref to a blessed hash hv */
            MAGIC *mg;
            HV *hv = newHV();
            const char *classname = "ZMQ::LibZMQ2::Message";
            /* take (sub)class name to use from class_sv if appropriate */
            if (SvMAGICAL(class_sv))
                mg_get(class_sv);
            if (SvOK( class_sv ) && sv_derived_from(class_sv, classname ) ) {
                if(SvROK(class_sv) && SvOBJECT(SvRV(class_sv))) {
                    classname = sv_reftype(SvRV(class_sv), TRUE);
                } else {
                    classname = SvPV_nolen(class_sv);
                }
            }
            sv_setsv(ST(0), sv_2mortal(newRV_noinc((SV*)hv)));
            (void)sv_bless(ST(0), gv_stashpv(classname, TRUE));
            mg = sv_magicext((SV*)hv, NULL, PERL_MAGIC_ext, &PerlLibzmq2_Message_vtbl, (char*) RETVAL, 0);
            mg->mg_flags |= MGf_DUP;
        }
    }
    XSRETURN(1);
}


XS_EUPXS(XS_ZMQ__LibZMQ2_zmq_msg_init_data); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_ZMQ__LibZMQ2_zmq_msg_init_data)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "data, size = -1");
    {
	SV *	data = ST(0)
;
	IV	size;
#line 437 "xs/perl_libzmq2.xs"
        SV *class_sv = sv_2mortal(newSVpvn( "ZMQ::LibZMQ2::Message", 20 ));
        STRLEN x_data_len;
        char *sv_data = SvPV(data, x_data_len);
        char *x_data;
        int rc;
#line 778 "xs/perl_libzmq2.c"
	PerlLibzmq2_Message *	RETVAL;

	if (items < 2)
	    size = -1;
	else {
	    size = (IV)SvIV(ST(1))
;
	}
#line 443 "xs/perl_libzmq2.xs"
        if (size >= 0) {
            x_data_len = size;
        }
        Newxz( RETVAL, 1, PerlLibzmq2_Message );
        x_data = (char *) malloc(x_data_len);
        memcpy(x_data, sv_data, x_data_len);
        rc = zmq_msg_init_data(RETVAL, x_data, x_data_len, PerlLibzmq2_free_string, NULL);
        if ( rc != 0 ) {
            SET_BANG;
            zmq_msg_close( RETVAL );
            RETVAL = NULL;
        }
        else {
            PerlLibzmq2_trace("zmq_msg_init_data created message %p", RETVAL);
        }
#line 803 "xs/perl_libzmq2.c"
	ST(0) = sv_newmortal();
        if (!RETVAL)          /* if null */
            SvOK_off(ST(0)); /* then return as undef instead of reaf to undef */
        else {
            /* setup ST(0) as a ref to a blessed hash hv */
            MAGIC *mg;
            HV *hv = newHV();
            const char *classname = "ZMQ::LibZMQ2::Message";
            /* take (sub)class name to use from class_sv if appropriate */
            if (SvMAGICAL(class_sv))
                mg_get(class_sv);
            if (SvOK( class_sv ) && sv_derived_from(class_sv, classname ) ) {
                if(SvROK(class_sv) && SvOBJECT(SvRV(class_sv))) {
                    classname = sv_reftype(SvRV(class_sv), TRUE);
                } else {
                    classname = SvPV_nolen(class_sv);
                }
            }
            sv_setsv(ST(0), sv_2mortal(newRV_noinc((SV*)hv)));
            (void)sv_bless(ST(0), gv_stashpv(classname, TRUE));
            mg = sv_magicext((SV*)hv, NULL, PERL_MAGIC_ext, &PerlLibzmq2_Message_vtbl, (char*) RETVAL, 0);
            mg->mg_flags |= MGf_DUP;
        }
    }
    XSRETURN(1);
}


XS_EUPXS(XS_ZMQ__LibZMQ2_zmq_msg_data); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_ZMQ__LibZMQ2_zmq_msg_data)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "message");
    {
	PerlLibzmq2_Message *	message;
	SV *	RETVAL;

    {
        MAGIC *mg;
        message = NULL;
        if (! sv_isobject(ST(0))) {
            croak("Argument is not an object");
        }
        /* if it got here, it's a blessed reference. better be an HV */
        {
            SV *svr;
            SV **closed;
            svr = SvRV(ST(0));
            if (! svr ) {
                croak("PANIC: Could not get reference from blessed object.");
            }
            if (SvTYPE(svr) != SVt_PVHV) {
                croak("PANIC: Underlying storage of blessed reference is not a hash.");
            }
            closed = hv_fetchs( (HV *) svr, "_closed", 0 );
            if (closed != NULL && SvTRUE(*closed)) {
                /* if it's already closed, just return */
                XSRETURN_EMPTY;
            }
        }
        mg = PerlLibzmq2_Message_mg_find(aTHX_ SvRV(ST(0)), &PerlLibzmq2_Message_vtbl);
        if (mg) {
            message = (PerlLibzmq2_Message *) mg->mg_ptr;
        }
        if (message == NULL)
            croak("Invalid ZMQ::LibZMQ2::Message object (perhaps you've already freed it?)");
    }
;
#line 465 "xs/perl_libzmq2.xs"
        RETVAL = newSV(0);
        sv_setpvn( RETVAL, (char *) zmq_msg_data(message), (STRLEN) zmq_msg_size(message) );
#line 876 "xs/perl_libzmq2.c"
	ST(0) = RETVAL;
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_ZMQ__LibZMQ2_zmq_msg_size); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_ZMQ__LibZMQ2_zmq_msg_size)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "message");
    {
	PerlLibzmq2_Message *	message;
	size_t	RETVAL;
	dXSTARG;

    {
        MAGIC *mg;
        message = NULL;
        if (! sv_isobject(ST(0))) {
            croak("Argument is not an object");
        }
        /* if it got here, it's a blessed reference. better be an HV */
        {
            SV *svr;
            SV **closed;
            svr = SvRV(ST(0));
            if (! svr ) {
                croak("PANIC: Could not get reference from blessed object.");
            }
            if (SvTYPE(svr) != SVt_PVHV) {
                croak("PANIC: Underlying storage of blessed reference is not a hash.");
            }
            closed = hv_fetchs( (HV *) svr, "_closed", 0 );
            if (closed != NULL && SvTRUE(*closed)) {
                /* if it's already closed, just return */
                XSRETURN_EMPTY;
            }
        }
        mg = PerlLibzmq2_Message_mg_find(aTHX_ SvRV(ST(0)), &PerlLibzmq2_Message_vtbl);
        if (mg) {
            message = (PerlLibzmq2_Message *) mg->mg_ptr;
        }
        if (message == NULL)
            croak("Invalid ZMQ::LibZMQ2::Message object (perhaps you've already freed it?)");
    }
;
#line 474 "xs/perl_libzmq2.xs"
        RETVAL = zmq_msg_size(message);
#line 928 "xs/perl_libzmq2.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_ZMQ__LibZMQ2_zmq_msg_close); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_ZMQ__LibZMQ2_zmq_msg_close)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "message");
    {
	PerlLibzmq2_Message *	message;
	int	RETVAL;
	dXSTARG;

    {
        MAGIC *mg;
        message = NULL;
        if (! sv_isobject(ST(0))) {
            croak("Argument is not an object");
        }
        /* if it got here, it's a blessed reference. better be an HV */
        {
            SV *svr;
            SV **closed;
            svr = SvRV(ST(0));
            if (! svr ) {
                croak("PANIC: Could not get reference from blessed object.");
            }
            if (SvTYPE(svr) != SVt_PVHV) {
                croak("PANIC: Underlying storage of blessed reference is not a hash.");
            }
            closed = hv_fetchs( (HV *) svr, "_closed", 0 );
            if (closed != NULL && SvTRUE(*closed)) {
                /* if it's already closed, just return */
                XSRETURN_EMPTY;
            }
        }
        mg = PerlLibzmq2_Message_mg_find(aTHX_ SvRV(ST(0)), &PerlLibzmq2_Message_vtbl);
        if (mg) {
            message = (PerlLibzmq2_Message *) mg->mg_ptr;
        }
        if (message == NULL)
            croak("Invalid ZMQ::LibZMQ2::Message object (perhaps you've already freed it?)");
    }
;
#line 482 "xs/perl_libzmq2.xs"
        PerlLibzmq2_trace("START zmq_msg_close");
        RETVAL = zmq_msg_close(message);
        Safefree(message);
        {
            MAGIC *mg =
                 PerlLibzmq2_Message_mg_find( aTHX_ SvRV(ST(0)), &PerlLibzmq2_Message_vtbl );
             mg->mg_ptr = NULL;
        }
        /* mark the original SV's _closed flag as true */
        {
            SV *svr = SvRV(ST(0));
            if (hv_stores( (HV *) svr, "_closed", &PL_sv_yes ) == NULL) {
                croak("PANIC: Failed to store closed flag on blessed reference");
            }
        }
        PerlLibzmq2_trace("END zmq_msg_close");
#line 994 "xs/perl_libzmq2.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_ZMQ__LibZMQ2_zmq_msg_move); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_ZMQ__LibZMQ2_zmq_msg_move)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "dest, src");
    {
	PerlLibzmq2_Message *	dest;
	PerlLibzmq2_Message *	src;
	int	RETVAL;
	dXSTARG;

    {
        MAGIC *mg;
        dest = NULL;
        if (! sv_isobject(ST(0))) {
            croak("Argument is not an object");
        }
        /* if it got here, it's a blessed reference. better be an HV */
        {
            SV *svr;
            SV **closed;
            svr = SvRV(ST(0));
            if (! svr ) {
                croak("PANIC: Could not get reference from blessed object.");
            }
            if (SvTYPE(svr) != SVt_PVHV) {
                croak("PANIC: Underlying storage of blessed reference is not a hash.");
            }
            closed = hv_fetchs( (HV *) svr, "_closed", 0 );
            if (closed != NULL && SvTRUE(*closed)) {
                /* if it's already closed, just return */
                XSRETURN_EMPTY;
            }
        }
        mg = PerlLibzmq2_Message_mg_find(aTHX_ SvRV(ST(0)), &PerlLibzmq2_Message_vtbl);
        if (mg) {
            dest = (PerlLibzmq2_Message *) mg->mg_ptr;
        }
        if (dest == NULL)
            croak("Invalid ZMQ::LibZMQ2::Message object (perhaps you've already freed it?)");
    }
;

    {
        MAGIC *mg;
        src = NULL;
        if (! sv_isobject(ST(1))) {
            croak("Argument is not an object");
        }
        /* if it got here, it's a blessed reference. better be an HV */
        {
            SV *svr;
            SV **closed;
            svr = SvRV(ST(1));
            if (! svr ) {
                croak("PANIC: Could not get reference from blessed object.");
            }
            if (SvTYPE(svr) != SVt_PVHV) {
                croak("PANIC: Underlying storage of blessed reference is not a hash.");
            }
            closed = hv_fetchs( (HV *) svr, "_closed", 0 );
            if (closed != NULL && SvTRUE(*closed)) {
                /* if it's already closed, just return */
                XSRETURN_EMPTY;
            }
        }
        mg = PerlLibzmq2_Message_mg_find(aTHX_ SvRV(ST(1)), &PerlLibzmq2_Message_vtbl);
        if (mg) {
            src = (PerlLibzmq2_Message *) mg->mg_ptr;
        }
        if (src == NULL)
            croak("Invalid ZMQ::LibZMQ2::Message object (perhaps you've already freed it?)");
    }
;
#line 506 "xs/perl_libzmq2.xs"
        RETVAL = zmq_msg_move( dest, src );
#line 1078 "xs/perl_libzmq2.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_ZMQ__LibZMQ2_zmq_msg_copy); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_ZMQ__LibZMQ2_zmq_msg_copy)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "dest, src");
    {
	PerlLibzmq2_Message *	dest;
	PerlLibzmq2_Message *	src;
	int	RETVAL;
	dXSTARG;

    {
        MAGIC *mg;
        dest = NULL;
        if (! sv_isobject(ST(0))) {
            croak("Argument is not an object");
        }
        /* if it got here, it's a blessed reference. better be an HV */
        {
            SV *svr;
            SV **closed;
            svr = SvRV(ST(0));
            if (! svr ) {
                croak("PANIC: Could not get reference from blessed object.");
            }
            if (SvTYPE(svr) != SVt_PVHV) {
                croak("PANIC: Underlying storage of blessed reference is not a hash.");
            }
            closed = hv_fetchs( (HV *) svr, "_closed", 0 );
            if (closed != NULL && SvTRUE(*closed)) {
                /* if it's already closed, just return */
                XSRETURN_EMPTY;
            }
        }
        mg = PerlLibzmq2_Message_mg_find(aTHX_ SvRV(ST(0)), &PerlLibzmq2_Message_vtbl);
        if (mg) {
            dest = (PerlLibzmq2_Message *) mg->mg_ptr;
        }
        if (dest == NULL)
            croak("Invalid ZMQ::LibZMQ2::Message object (perhaps you've already freed it?)");
    }
;

    {
        MAGIC *mg;
        src = NULL;
        if (! sv_isobject(ST(1))) {
            croak("Argument is not an object");
        }
        /* if it got here, it's a blessed reference. better be an HV */
        {
            SV *svr;
            SV **closed;
            svr = SvRV(ST(1));
            if (! svr ) {
                croak("PANIC: Could not get reference from blessed object.");
            }
            if (SvTYPE(svr) != SVt_PVHV) {
                croak("PANIC: Underlying storage of blessed reference is not a hash.");
            }
            closed = hv_fetchs( (HV *) svr, "_closed", 0 );
            if (closed != NULL && SvTRUE(*closed)) {
                /* if it's already closed, just return */
                XSRETURN_EMPTY;
            }
        }
        mg = PerlLibzmq2_Message_mg_find(aTHX_ SvRV(ST(1)), &PerlLibzmq2_Message_vtbl);
        if (mg) {
            src = (PerlLibzmq2_Message *) mg->mg_ptr;
        }
        if (src == NULL)
            croak("Invalid ZMQ::LibZMQ2::Message object (perhaps you've already freed it?)");
    }
;
#line 515 "xs/perl_libzmq2.xs"
        RETVAL = zmq_msg_copy( dest, src );
#line 1162 "xs/perl_libzmq2.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_ZMQ__LibZMQ2_zmq_socket); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_ZMQ__LibZMQ2_zmq_socket)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "ctxt, type");
    {
	PerlLibzmq2_Context *	ctxt;
	IV	type = (IV)SvIV(ST(1))
;
#line 524 "xs/perl_libzmq2.xs"
        SV *class_sv = sv_2mortal(newSVpvn( "ZMQ::LibZMQ2::Socket", 19 ));
#line 1181 "xs/perl_libzmq2.c"
	PerlLibzmq2_Socket *	RETVAL;

    {
        MAGIC *mg;
        ctxt = NULL;
        if (! sv_isobject(ST(0))) {
            croak("Argument is not an object");
        }
        /* if it got here, it's a blessed reference. better be an HV */
        {
            SV *svr;
            SV **closed;
            svr = SvRV(ST(0));
            if (! svr ) {
                croak("PANIC: Could not get reference from blessed object.");
            }
            if (SvTYPE(svr) != SVt_PVHV) {
                croak("PANIC: Underlying storage of blessed reference is not a hash.");
            }
            closed = hv_fetchs( (HV *) svr, "_closed", 0 );
            if (closed != NULL && SvTRUE(*closed)) {
                /* if it's already closed, just return */
                XSRETURN_EMPTY;
            }
        }
        mg = PerlLibzmq2_Context_mg_find(aTHX_ SvRV(ST(0)), &PerlLibzmq2_Context_vtbl);
        if (mg) {
            ctxt = (PerlLibzmq2_Context *) mg->mg_ptr;
        }
        if (ctxt == NULL)
            croak("Invalid ZMQ::LibZMQ2::Context object (perhaps you've already freed it?)");
    }
;
#line 526 "xs/perl_libzmq2.xs"
        PerlLibzmq2_trace( "START zmq_socket" );
        Newxz( RETVAL, 1, PerlLibzmq2_Socket );
        RETVAL->assoc_ctxt = NULL;
        RETVAL->socket = NULL;
#ifdef USE_ITHREADS
        PerlLibzmq2_trace( " + context wrapper %p, zmq context %p", ctxt, ctxt->ctxt );
        RETVAL->socket = zmq_socket( ctxt->ctxt, type );
#else
        PerlLibzmq2_trace( " + zmq context %p", ctxt );
        RETVAL->socket = zmq_socket( ctxt, type );
#endif
        RETVAL->assoc_ctxt = ST(0);
        SvREFCNT_inc(RETVAL->assoc_ctxt);
        PerlLibzmq2_trace( " + created socket %p", RETVAL );
        PerlLibzmq2_trace( "END zmq_socket" );
#line 1231 "xs/perl_libzmq2.c"
	ST(0) = sv_newmortal();
        if (!RETVAL)          /* if null */
            SvOK_off(ST(0)); /* then return as undef instead of reaf to undef */
        else {
            /* setup ST(0) as a ref to a blessed hash hv */
            MAGIC *mg;
            HV *hv = newHV();
            const char *classname = "ZMQ::LibZMQ2::Socket";
            /* take (sub)class name to use from class_sv if appropriate */
            if (SvMAGICAL(class_sv))
                mg_get(class_sv);
            if (SvOK( class_sv ) && sv_derived_from(class_sv, classname ) ) {
                if(SvROK(class_sv) && SvOBJECT(SvRV(class_sv))) {
                    classname = sv_reftype(SvRV(class_sv), TRUE);
                } else {
                    classname = SvPV_nolen(class_sv);
                }
            }
            sv_setsv(ST(0), sv_2mortal(newRV_noinc((SV*)hv)));
            (void)sv_bless(ST(0), gv_stashpv(classname, TRUE));
            mg = sv_magicext((SV*)hv, NULL, PERL_MAGIC_ext, &PerlLibzmq2_Socket_vtbl, (char*) RETVAL, 0);
            mg->mg_flags |= MGf_DUP;
        }
    }
    XSRETURN(1);
}


XS_EUPXS(XS_ZMQ__LibZMQ2_zmq_close); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_ZMQ__LibZMQ2_zmq_close)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "socket");
    {
	PerlLibzmq2_Socket *	socket;
	int	RETVAL;
	dXSTARG;

    {
        MAGIC *mg;
        socket = NULL;
        if (! sv_isobject(ST(0))) {
            croak("Argument is not an object");
        }
        /* if it got here, it's a blessed reference. better be an HV */
        {
            SV *svr;
            SV **closed;
            svr = SvRV(ST(0));
            if (! svr ) {
                croak("PANIC: Could not get reference from blessed object.");
            }
            if (SvTYPE(svr) != SVt_PVHV) {
                croak("PANIC: Underlying storage of blessed reference is not a hash.");
            }
            closed = hv_fetchs( (HV *) svr, "_closed", 0 );
            if (closed != NULL && SvTRUE(*closed)) {
                /* if it's already closed, just return */
                XSRETURN_EMPTY;
            }
        }
        mg = PerlLibzmq2_Socket_mg_find(aTHX_ SvRV(ST(0)), &PerlLibzmq2_Socket_vtbl);
        if (mg) {
            socket = (PerlLibzmq2_Socket *) mg->mg_ptr;
        }
        if (socket == NULL)
            croak("Invalid ZMQ::LibZMQ2::Socket object (perhaps you've already freed it?)");
    }
;
#line 548 "xs/perl_libzmq2.xs"
        RETVAL = PerlLibzmq2_Socket_invalidate( socket );
        /* Cancel the SV's mg attr so to not call socket_invalidate again
           during Socket_mg_free
        */
        {
            MAGIC *mg =
                 PerlLibzmq2_Socket_mg_find( aTHX_ SvRV(ST(0)), &PerlLibzmq2_Socket_vtbl );
             mg->mg_ptr = NULL;
        }

        /* mark the original SV's _closed flag as true */
        {
            SV *svr = SvRV(ST(0));
            if (hv_stores( (HV *) svr, "_closed", &PL_sv_yes ) == NULL) {
                croak("PANIC: Failed to store closed flag on blessed reference");
            }
        }
#line 1320 "xs/perl_libzmq2.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_ZMQ__LibZMQ2_zmq_connect); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_ZMQ__LibZMQ2_zmq_connect)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "socket, addr");
    {
	PerlLibzmq2_Socket *	socket;
	char *	addr = (char *)SvPV_nolen(ST(1))
;
	int	RETVAL;
	dXSTARG;

    {
        MAGIC *mg;
        socket = NULL;
        if (! sv_isobject(ST(0))) {
            croak("Argument is not an object");
        }
        /* if it got here, it's a blessed reference. better be an HV */
        {
            SV *svr;
            SV **closed;
            svr = SvRV(ST(0));
            if (! svr ) {
                croak("PANIC: Could not get reference from blessed object.");
            }
            if (SvTYPE(svr) != SVt_PVHV) {
                croak("PANIC: Underlying storage of blessed reference is not a hash.");
            }
            closed = hv_fetchs( (HV *) svr, "_closed", 0 );
            if (closed != NULL && SvTRUE(*closed)) {
                /* if it's already closed, just return */
                XSRETURN_EMPTY;
            }
        }
        mg = PerlLibzmq2_Socket_mg_find(aTHX_ SvRV(ST(0)), &PerlLibzmq2_Socket_vtbl);
        if (mg) {
            socket = (PerlLibzmq2_Socket *) mg->mg_ptr;
        }
        if (socket == NULL)
            croak("Invalid ZMQ::LibZMQ2::Socket object (perhaps you've already freed it?)");
    }
;
#line 573 "xs/perl_libzmq2.xs"
        PerlLibzmq2_trace( "START zmq_connect" );
        PerlLibzmq2_trace( " + socket %p", socket );
        RETVAL = zmq_connect( socket->socket, addr );
        if (RETVAL != 0) {
            croak( "%s", zmq_strerror( zmq_errno() ) );
        }
        PerlLibzmq2_trace( "END zmq_connect" );
#line 1379 "xs/perl_libzmq2.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_ZMQ__LibZMQ2_zmq_bind); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_ZMQ__LibZMQ2_zmq_bind)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "socket, addr");
    {
	PerlLibzmq2_Socket *	socket;
	char *	addr = (char *)SvPV_nolen(ST(1))
;
	int	RETVAL;
	dXSTARG;

    {
        MAGIC *mg;
        socket = NULL;
        if (! sv_isobject(ST(0))) {
            croak("Argument is not an object");
        }
        /* if it got here, it's a blessed reference. better be an HV */
        {
            SV *svr;
            SV **closed;
            svr = SvRV(ST(0));
            if (! svr ) {
                croak("PANIC: Could not get reference from blessed object.");
            }
            if (SvTYPE(svr) != SVt_PVHV) {
                croak("PANIC: Underlying storage of blessed reference is not a hash.");
            }
            closed = hv_fetchs( (HV *) svr, "_closed", 0 );
            if (closed != NULL && SvTRUE(*closed)) {
                /* if it's already closed, just return */
                XSRETURN_EMPTY;
            }
        }
        mg = PerlLibzmq2_Socket_mg_find(aTHX_ SvRV(ST(0)), &PerlLibzmq2_Socket_vtbl);
        if (mg) {
            socket = (PerlLibzmq2_Socket *) mg->mg_ptr;
        }
        if (socket == NULL)
            croak("Invalid ZMQ::LibZMQ2::Socket object (perhaps you've already freed it?)");
    }
;
#line 588 "xs/perl_libzmq2.xs"
        PerlLibzmq2_trace( "zmq_bind: socket %p", socket );
        RETVAL = zmq_bind( socket->socket, addr );
        if (RETVAL != 0) {
            croak( "%s", zmq_strerror( zmq_errno() ) );
        }
#line 1436 "xs/perl_libzmq2.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_ZMQ__LibZMQ2_zmq_recv); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_ZMQ__LibZMQ2_zmq_recv)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "socket, flags = 0");
    {
	PerlLibzmq2_Socket *	socket;
	int	flags;
#line 601 "xs/perl_libzmq2.xs"
        SV *class_sv = sv_2mortal(newSVpvn( "ZMQ::LibZMQ2::Message", 20 ));
        int rv;
        zmq_msg_t msg;
#line 1456 "xs/perl_libzmq2.c"
	PerlLibzmq2_Message *	RETVAL;

    {
        MAGIC *mg;
        socket = NULL;
        if (! sv_isobject(ST(0))) {
            croak("Argument is not an object");
        }
        /* if it got here, it's a blessed reference. better be an HV */
        {
            SV *svr;
            SV **closed;
            svr = SvRV(ST(0));
            if (! svr ) {
                croak("PANIC: Could not get reference from blessed object.");
            }
            if (SvTYPE(svr) != SVt_PVHV) {
                croak("PANIC: Underlying storage of blessed reference is not a hash.");
            }
            closed = hv_fetchs( (HV *) svr, "_closed", 0 );
            if (closed != NULL && SvTRUE(*closed)) {
                /* if it's already closed, just return */
                XSRETURN_EMPTY;
            }
        }
        mg = PerlLibzmq2_Socket_mg_find(aTHX_ SvRV(ST(0)), &PerlLibzmq2_Socket_vtbl);
        if (mg) {
            socket = (PerlLibzmq2_Socket *) mg->mg_ptr;
        }
        if (socket == NULL)
            croak("Invalid ZMQ::LibZMQ2::Socket object (perhaps you've already freed it?)");
    }
;

	if (items < 2)
	    flags = 0;
	else {
	    flags = (int)SvIV(ST(1))
;
	}
#line 605 "xs/perl_libzmq2.xs"
        PerlLibzmq2_trace( "START zmq_recv" );
        RETVAL = NULL;
        zmq_msg_init(&msg);
        rv = zmq_recv(socket->socket, &msg, flags);
        PerlLibzmq2_trace(" + zmq recv with flags %d", flags);
        PerlLibzmq2_trace(" + zmq_recv returned with rv '%d'", rv);
        if (rv != 0) {
            SET_BANG;
            zmq_msg_close(&msg);
            PerlLibzmq2_trace(" + zmq_recv got bad status, closing temporary message");
        } else {
            Newxz(RETVAL, 1, PerlLibzmq2_Message);
            zmq_msg_init(RETVAL);
            zmq_msg_copy( RETVAL, &msg );
            zmq_msg_close(&msg);
            PerlLibzmq2_trace(" + zmq_recv created message %p", RETVAL );
        }
        PerlLibzmq2_trace( "END zmq_recv" );
#line 1516 "xs/perl_libzmq2.c"
	ST(0) = sv_newmortal();
        if (!RETVAL)          /* if null */
            SvOK_off(ST(0)); /* then return as undef instead of reaf to undef */
        else {
            /* setup ST(0) as a ref to a blessed hash hv */
            MAGIC *mg;
            HV *hv = newHV();
            const char *classname = "ZMQ::LibZMQ2::Message";
            /* take (sub)class name to use from class_sv if appropriate */
            if (SvMAGICAL(class_sv))
                mg_get(class_sv);
            if (SvOK( class_sv ) && sv_derived_from(class_sv, classname ) ) {
                if(SvROK(class_sv) && SvOBJECT(SvRV(class_sv))) {
                    classname = sv_reftype(SvRV(class_sv), TRUE);
                } else {
                    classname = SvPV_nolen(class_sv);
                }
            }
            sv_setsv(ST(0), sv_2mortal(newRV_noinc((SV*)hv)));
            (void)sv_bless(ST(0), gv_stashpv(classname, TRUE));
            mg = sv_magicext((SV*)hv, NULL, PERL_MAGIC_ext, &PerlLibzmq2_Message_vtbl, (char*) RETVAL, 0);
            mg->mg_flags |= MGf_DUP;
        }
    }
    XSRETURN(1);
}


XS_EUPXS(XS_ZMQ__LibZMQ2_zmq_send); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_ZMQ__LibZMQ2_zmq_send)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "socket, message, flags = 0");
    {
	PerlLibzmq2_Socket *	socket;
	SV *	message = ST(1)
;
	int	flags;
#line 632 "xs/perl_libzmq2.xs"
        PerlLibzmq2_Message *msg = NULL;
#line 1558 "xs/perl_libzmq2.c"
	int	RETVAL;
	dXSTARG;

    {
        MAGIC *mg;
        socket = NULL;
        if (! sv_isobject(ST(0))) {
            croak("Argument is not an object");
        }
        /* if it got here, it's a blessed reference. better be an HV */
        {
            SV *svr;
            SV **closed;
            svr = SvRV(ST(0));
            if (! svr ) {
                croak("PANIC: Could not get reference from blessed object.");
            }
            if (SvTYPE(svr) != SVt_PVHV) {
                croak("PANIC: Underlying storage of blessed reference is not a hash.");
            }
            closed = hv_fetchs( (HV *) svr, "_closed", 0 );
            if (closed != NULL && SvTRUE(*closed)) {
                /* if it's already closed, just return */
                XSRETURN_EMPTY;
            }
        }
        mg = PerlLibzmq2_Socket_mg_find(aTHX_ SvRV(ST(0)), &PerlLibzmq2_Socket_vtbl);
        if (mg) {
            socket = (PerlLibzmq2_Socket *) mg->mg_ptr;
        }
        if (socket == NULL)
            croak("Invalid ZMQ::LibZMQ2::Socket object (perhaps you've already freed it?)");
    }
;

	if (items < 3)
	    flags = 0;
	else {
	    flags = (int)SvIV(ST(2))
;
	}
#line 634 "xs/perl_libzmq2.xs"
        if (! SvOK(message))
            croak("ZMQ::LibZMQ2::Socket::send() NULL message passed");

        if (sv_isobject(message) && sv_isa(message, "ZMQ::LibZMQ2::Message")) {
            MAGIC *mg = PerlLibzmq2_Context_mg_find(aTHX_ SvRV(message), &PerlLibzmq2_Message_vtbl);
            if (mg) {
                msg = (PerlLibzmq2_Message *) mg->mg_ptr;
            }

            if (msg == NULL) {
                croak("Got invalid message object");
            }

            RETVAL = zmq_send(socket->socket, msg, flags);
        } else {
            STRLEN data_len;
            char *x_data;
            char *data = SvPV(message, data_len);
            zmq_msg_t msg;

            x_data = (char *)malloc(data_len);
            memcpy(x_data, data, data_len);
            zmq_msg_init_data(&msg, x_data, data_len, PerlLibzmq2_free_string, NULL);
            RETVAL = zmq_send(socket->socket, &msg, flags);
            zmq_msg_close( &msg ); 
        }
#line 1627 "xs/perl_libzmq2.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_ZMQ__LibZMQ2_zmq_getsockopt_int); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_ZMQ__LibZMQ2_zmq_getsockopt_int)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "sock, option");
    {
	PerlLibzmq2_Socket *	sock;
	int	option = (int)SvIV(ST(1))
;
	SV *	RETVAL;

    {
        MAGIC *mg;
        sock = NULL;
        if (! sv_isobject(ST(0))) {
            croak("Argument is not an object");
        }
        /* if it got here, it's a blessed reference. better be an HV */
        {
            SV *svr;
            SV **closed;
            svr = SvRV(ST(0));
            if (! svr ) {
                croak("PANIC: Could not get reference from blessed object.");
            }
            if (SvTYPE(svr) != SVt_PVHV) {
                croak("PANIC: Underlying storage of blessed reference is not a hash.");
            }
            closed = hv_fetchs( (HV *) svr, "_closed", 0 );
            if (closed != NULL && SvTRUE(*closed)) {
                /* if it's already closed, just return */
                XSRETURN_EMPTY;
            }
        }
        mg = PerlLibzmq2_Socket_mg_find(aTHX_ SvRV(ST(0)), &PerlLibzmq2_Socket_vtbl);
        if (mg) {
            sock = (PerlLibzmq2_Socket *) mg->mg_ptr;
        }
        if (sock == NULL)
            croak("Invalid ZMQ::LibZMQ2::Socket object (perhaps you've already freed it?)");
    }
;

	RETVAL = PerlLibzmq2_zmq_getsockopt_int(sock, option);
	ST(0) = RETVAL;
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_ZMQ__LibZMQ2_zmq_getsockopt_int64); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_ZMQ__LibZMQ2_zmq_getsockopt_int64)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "sock, option");
    {
	PerlLibzmq2_Socket *	sock;
	int	option = (int)SvIV(ST(1))
;
	SV *	RETVAL;

    {
        MAGIC *mg;
        sock = NULL;
        if (! sv_isobject(ST(0))) {
            croak("Argument is not an object");
        }
        /* if it got here, it's a blessed reference. better be an HV */
        {
            SV *svr;
            SV **closed;
            svr = SvRV(ST(0));
            if (! svr ) {
                croak("PANIC: Could not get reference from blessed object.");
            }
            if (SvTYPE(svr) != SVt_PVHV) {
                croak("PANIC: Underlying storage of blessed reference is not a hash.");
            }
            closed = hv_fetchs( (HV *) svr, "_closed", 0 );
            if (closed != NULL && SvTRUE(*closed)) {
                /* if it's already closed, just return */
                XSRETURN_EMPTY;
            }
        }
        mg = PerlLibzmq2_Socket_mg_find(aTHX_ SvRV(ST(0)), &PerlLibzmq2_Socket_vtbl);
        if (mg) {
            sock = (PerlLibzmq2_Socket *) mg->mg_ptr;
        }
        if (sock == NULL)
            croak("Invalid ZMQ::LibZMQ2::Socket object (perhaps you've already freed it?)");
    }
;

	RETVAL = PerlLibzmq2_zmq_getsockopt_int64(sock, option);
	ST(0) = RETVAL;
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_ZMQ__LibZMQ2_zmq_getsockopt_uint64); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_ZMQ__LibZMQ2_zmq_getsockopt_uint64)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "sock, option");
    {
	PerlLibzmq2_Socket *	sock;
	int	option = (int)SvIV(ST(1))
;
	SV *	RETVAL;

    {
        MAGIC *mg;
        sock = NULL;
        if (! sv_isobject(ST(0))) {
            croak("Argument is not an object");
        }
        /* if it got here, it's a blessed reference. better be an HV */
        {
            SV *svr;
            SV **closed;
            svr = SvRV(ST(0));
            if (! svr ) {
                croak("PANIC: Could not get reference from blessed object.");
            }
            if (SvTYPE(svr) != SVt_PVHV) {
                croak("PANIC: Underlying storage of blessed reference is not a hash.");
            }
            closed = hv_fetchs( (HV *) svr, "_closed", 0 );
            if (closed != NULL && SvTRUE(*closed)) {
                /* if it's already closed, just return */
                XSRETURN_EMPTY;
            }
        }
        mg = PerlLibzmq2_Socket_mg_find(aTHX_ SvRV(ST(0)), &PerlLibzmq2_Socket_vtbl);
        if (mg) {
            sock = (PerlLibzmq2_Socket *) mg->mg_ptr;
        }
        if (sock == NULL)
            croak("Invalid ZMQ::LibZMQ2::Socket object (perhaps you've already freed it?)");
    }
;

	RETVAL = PerlLibzmq2_zmq_getsockopt_uint64(sock, option);
	ST(0) = RETVAL;
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_ZMQ__LibZMQ2_zmq_getsockopt_string); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_ZMQ__LibZMQ2_zmq_getsockopt_string)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "sock, option, len = 1024");
    {
	PerlLibzmq2_Socket *	sock;
	int	option = (int)SvIV(ST(1))
;
	size_t	len;
	SV *	RETVAL;

    {
        MAGIC *mg;
        sock = NULL;
        if (! sv_isobject(ST(0))) {
            croak("Argument is not an object");
        }
        /* if it got here, it's a blessed reference. better be an HV */
        {
            SV *svr;
            SV **closed;
            svr = SvRV(ST(0));
            if (! svr ) {
                croak("PANIC: Could not get reference from blessed object.");
            }
            if (SvTYPE(svr) != SVt_PVHV) {
                croak("PANIC: Underlying storage of blessed reference is not a hash.");
            }
            closed = hv_fetchs( (HV *) svr, "_closed", 0 );
            if (closed != NULL && SvTRUE(*closed)) {
                /* if it's already closed, just return */
                XSRETURN_EMPTY;
            }
        }
        mg = PerlLibzmq2_Socket_mg_find(aTHX_ SvRV(ST(0)), &PerlLibzmq2_Socket_vtbl);
        if (mg) {
            sock = (PerlLibzmq2_Socket *) mg->mg_ptr;
        }
        if (sock == NULL)
            croak("Invalid ZMQ::LibZMQ2::Socket object (perhaps you've already freed it?)");
    }
;

	if (items < 3)
	    len = 1024;
	else {
	    len = (size_t)SvUV(ST(2))
;
	}

	RETVAL = PerlLibzmq2_zmq_getsockopt_string(sock, option, len);
	ST(0) = RETVAL;
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_ZMQ__LibZMQ2_zmq_setsockopt_int); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_ZMQ__LibZMQ2_zmq_setsockopt_int)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "sock, option, val");
    {
	PerlLibzmq2_Socket *	sock;
	int	option = (int)SvIV(ST(1))
;
	int	val = (int)SvIV(ST(2))
;
	int	RETVAL;
	dXSTARG;

    {
        MAGIC *mg;
        sock = NULL;
        if (! sv_isobject(ST(0))) {
            croak("Argument is not an object");
        }
        /* if it got here, it's a blessed reference. better be an HV */
        {
            SV *svr;
            SV **closed;
            svr = SvRV(ST(0));
            if (! svr ) {
                croak("PANIC: Could not get reference from blessed object.");
            }
            if (SvTYPE(svr) != SVt_PVHV) {
                croak("PANIC: Underlying storage of blessed reference is not a hash.");
            }
            closed = hv_fetchs( (HV *) svr, "_closed", 0 );
            if (closed != NULL && SvTRUE(*closed)) {
                /* if it's already closed, just return */
                XSRETURN_EMPTY;
            }
        }
        mg = PerlLibzmq2_Socket_mg_find(aTHX_ SvRV(ST(0)), &PerlLibzmq2_Socket_vtbl);
        if (mg) {
            sock = (PerlLibzmq2_Socket *) mg->mg_ptr;
        }
        if (sock == NULL)
            croak("Invalid ZMQ::LibZMQ2::Socket object (perhaps you've already freed it?)");
    }
;

	RETVAL = PerlLibzmq2_zmq_setsockopt_int(sock, option, val);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_ZMQ__LibZMQ2_zmq_setsockopt_int64); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_ZMQ__LibZMQ2_zmq_setsockopt_int64)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "sock, option, val");
    {
	PerlLibzmq2_Socket *	sock;
	int	option = (int)SvIV(ST(1))
;
	int64_t	val = (int64_t)SvIV(ST(2))
;
	int	RETVAL;
	dXSTARG;

    {
        MAGIC *mg;
        sock = NULL;
        if (! sv_isobject(ST(0))) {
            croak("Argument is not an object");
        }
        /* if it got here, it's a blessed reference. better be an HV */
        {
            SV *svr;
            SV **closed;
            svr = SvRV(ST(0));
            if (! svr ) {
                croak("PANIC: Could not get reference from blessed object.");
            }
            if (SvTYPE(svr) != SVt_PVHV) {
                croak("PANIC: Underlying storage of blessed reference is not a hash.");
            }
            closed = hv_fetchs( (HV *) svr, "_closed", 0 );
            if (closed != NULL && SvTRUE(*closed)) {
                /* if it's already closed, just return */
                XSRETURN_EMPTY;
            }
        }
        mg = PerlLibzmq2_Socket_mg_find(aTHX_ SvRV(ST(0)), &PerlLibzmq2_Socket_vtbl);
        if (mg) {
            sock = (PerlLibzmq2_Socket *) mg->mg_ptr;
        }
        if (sock == NULL)
            croak("Invalid ZMQ::LibZMQ2::Socket object (perhaps you've already freed it?)");
    }
;

	RETVAL = PerlLibzmq2_zmq_setsockopt_int64(sock, option, val);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_ZMQ__LibZMQ2_zmq_setsockopt_uint64); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_ZMQ__LibZMQ2_zmq_setsockopt_uint64)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "sock, option, val");
    {
	PerlLibzmq2_Socket *	sock;
	int	option = (int)SvIV(ST(1))
;
	uint64_t	val = (uint64_t)SvUV(ST(2))
;
	int	RETVAL;
	dXSTARG;

    {
        MAGIC *mg;
        sock = NULL;
        if (! sv_isobject(ST(0))) {
            croak("Argument is not an object");
        }
        /* if it got here, it's a blessed reference. better be an HV */
        {
            SV *svr;
            SV **closed;
            svr = SvRV(ST(0));
            if (! svr ) {
                croak("PANIC: Could not get reference from blessed object.");
            }
            if (SvTYPE(svr) != SVt_PVHV) {
                croak("PANIC: Underlying storage of blessed reference is not a hash.");
            }
            closed = hv_fetchs( (HV *) svr, "_closed", 0 );
            if (closed != NULL && SvTRUE(*closed)) {
                /* if it's already closed, just return */
                XSRETURN_EMPTY;
            }
        }
        mg = PerlLibzmq2_Socket_mg_find(aTHX_ SvRV(ST(0)), &PerlLibzmq2_Socket_vtbl);
        if (mg) {
            sock = (PerlLibzmq2_Socket *) mg->mg_ptr;
        }
        if (sock == NULL)
            croak("Invalid ZMQ::LibZMQ2::Socket object (perhaps you've already freed it?)");
    }
;

	RETVAL = PerlLibzmq2_zmq_setsockopt_uint64(sock, option, val);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_ZMQ__LibZMQ2_zmq_setsockopt_string); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_ZMQ__LibZMQ2_zmq_setsockopt_string)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "sock, option, value");
    {
	PerlLibzmq2_Socket *	sock;
	int	option = (int)SvIV(ST(1))
;
	SV *	value = ST(2)
;
#line 708 "xs/perl_libzmq2.xs"
        size_t len;
        const char *string;
#line 2027 "xs/perl_libzmq2.c"
	int	RETVAL;
	dXSTARG;

    {
        MAGIC *mg;
        sock = NULL;
        if (! sv_isobject(ST(0))) {
            croak("Argument is not an object");
        }
        /* if it got here, it's a blessed reference. better be an HV */
        {
            SV *svr;
            SV **closed;
            svr = SvRV(ST(0));
            if (! svr ) {
                croak("PANIC: Could not get reference from blessed object.");
            }
            if (SvTYPE(svr) != SVt_PVHV) {
                croak("PANIC: Underlying storage of blessed reference is not a hash.");
            }
            closed = hv_fetchs( (HV *) svr, "_closed", 0 );
            if (closed != NULL && SvTRUE(*closed)) {
                /* if it's already closed, just return */
                XSRETURN_EMPTY;
            }
        }
        mg = PerlLibzmq2_Socket_mg_find(aTHX_ SvRV(ST(0)), &PerlLibzmq2_Socket_vtbl);
        if (mg) {
            sock = (PerlLibzmq2_Socket *) mg->mg_ptr;
        }
        if (sock == NULL)
            croak("Invalid ZMQ::LibZMQ2::Socket object (perhaps you've already freed it?)");
    }
;
#line 711 "xs/perl_libzmq2.xs"
        string = SvPV( value, len );
        RETVAL = PerlLibzmq2_zmq_setsockopt_string(sock, option, string, len);
#line 2065 "xs/perl_libzmq2.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_ZMQ__LibZMQ2_zmq_poll); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_ZMQ__LibZMQ2_zmq_poll)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "list, timeout = 0");
    {
	AV *	list;
	long	timeout;
#line 721 "xs/perl_libzmq2.xs"
        I32 list_len;
        zmq_pollitem_t *pollitems;
        CV **callbacks;
        int i;
#line 2086 "xs/perl_libzmq2.c"
	int	RETVAL;
	dXSTARG;

	STMT_START {
		SV* const xsub_tmp_sv = ST(0);
		SvGETMAGIC(xsub_tmp_sv);
		if (SvROK(xsub_tmp_sv) && SvTYPE(SvRV(xsub_tmp_sv)) == SVt_PVAV){
		    list = (AV*)SvRV(xsub_tmp_sv);
		}
		else{
		    Perl_croak(aTHX_ "%s: %s is not an ARRAY reference",
				"ZMQ::LibZMQ2::zmq_poll",
				"list");
		}
	} STMT_END
;

	if (items < 2)
	    timeout = 0;
	else {
	    timeout = (long)SvIV(ST(1))
;
	}
#line 726 "xs/perl_libzmq2.xs"
        list_len = av_len( list ) + 1;
        if (list_len <= 0) {
            XSRETURN(0);
        }

        Newxz( pollitems, list_len, zmq_pollitem_t);
        Newxz( callbacks, list_len, CV *);

        /* list should be a list of hashrefs fd, events, and callbacks */
        for (i = 0; i < list_len; i++) {
            SV **svr = av_fetch( list, i, 0 );
            HV  *elm;
            if (svr == NULL || ! SvOK(*svr) || ! SvROK(*svr) || SvTYPE(SvRV(*svr)) != SVt_PVHV) {
                Safefree( pollitems );
                Safefree( callbacks );
                croak("Invalid value on index %d", i);
            }
            elm = (HV *) SvRV(*svr);

            callbacks[i] = NULL;
            pollitems[i].revents = 0;
            pollitems[i].events  = 0;
            pollitems[i].fd      = 0;
            pollitems[i].socket  = NULL;

            svr = hv_fetch( elm, "socket", 6, NULL );
            if (svr != NULL) {
                MAGIC *mg;
                if (! SvOK(*svr) || !sv_isobject( *svr) || ! sv_isa(*svr, "ZMQ::LibZMQ2::Socket")) {
                    Safefree( pollitems );
                    Safefree( callbacks );
                    croak("Invalid 'socket' given for index %d", i);
                }
                mg = PerlLibzmq2_Socket_mg_find( aTHX_ SvRV(*svr), &PerlLibzmq2_Socket_vtbl );
                pollitems[i].socket = ((PerlLibzmq2_Socket *) mg->mg_ptr)->socket;
                PerlLibzmq2_trace( " + pollitem[%d].socket = %p", i, pollitems[i].socket );
            } else {
                svr = hv_fetch( elm, "fd", 2, NULL );
                if (svr == NULL || ! SvOK(*svr) || SvTYPE(*svr) != SVt_IV) {
                    Safefree( pollitems );
                    Safefree( callbacks );
                    croak("Invalid 'fd' given for index %d", i);
                }
                pollitems[i].fd = SvIV( *svr );
            }

            svr = hv_fetch( elm, "events", 6, NULL );
            if (svr == NULL || ! SvOK(*svr) || SvTYPE(*svr) != SVt_IV) {
                Safefree( pollitems );
                Safefree( callbacks );
                croak("Invalid 'events' given for index %d", i);
            }
            pollitems[i].events = SvIV( *svr );

            svr = hv_fetch( elm, "callback", 8, NULL );
            if (svr == NULL || ! SvOK(*svr) || ! SvROK(*svr) || SvTYPE(SvRV(*svr)) != SVt_PVCV) {
                Safefree( pollitems );
                Safefree( callbacks );
                croak("Invalid 'callback' given for index %d", i);
            }
            callbacks[i] = (CV *) SvRV( *svr );
        }

        /* now call zmq_poll */
        RETVAL = zmq_poll( pollitems, list_len, timeout );
        for ( i = 0; i < list_len; i++ ) {
            if (pollitems[i].revents & pollitems[i].events) {
                dSP;
                ENTER;
                SAVETMPS;
                PUSHMARK(SP);
                PUTBACK;

                call_sv( (SV*)callbacks[i], G_SCALAR );
                SPAGAIN;

                PUTBACK;
                FREETMPS;
                LEAVE;
            }
        }
        Safefree(pollitems);
        Safefree(callbacks);
#line 2194 "xs/perl_libzmq2.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_ZMQ__LibZMQ2_zmq_device); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_ZMQ__LibZMQ2_zmq_device)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "device, insocket, outsocket");
    {
	int	device = (int)SvIV(ST(0))
;
	PerlLibzmq2_Socket *	insocket;
	PerlLibzmq2_Socket *	outsocket;
	int	RETVAL;
	dXSTARG;

    {
        MAGIC *mg;
        insocket = NULL;
        if (! sv_isobject(ST(1))) {
            croak("Argument is not an object");
        }
        /* if it got here, it's a blessed reference. better be an HV */
        {
            SV *svr;
            SV **closed;
            svr = SvRV(ST(1));
            if (! svr ) {
                croak("PANIC: Could not get reference from blessed object.");
            }
            if (SvTYPE(svr) != SVt_PVHV) {
                croak("PANIC: Underlying storage of blessed reference is not a hash.");
            }
            closed = hv_fetchs( (HV *) svr, "_closed", 0 );
            if (closed != NULL && SvTRUE(*closed)) {
                /* if it's already closed, just return */
                XSRETURN_EMPTY;
            }
        }
        mg = PerlLibzmq2_Socket_mg_find(aTHX_ SvRV(ST(1)), &PerlLibzmq2_Socket_vtbl);
        if (mg) {
            insocket = (PerlLibzmq2_Socket *) mg->mg_ptr;
        }
        if (insocket == NULL)
            croak("Invalid ZMQ::LibZMQ2::Socket object (perhaps you've already freed it?)");
    }
;

    {
        MAGIC *mg;
        outsocket = NULL;
        if (! sv_isobject(ST(2))) {
            croak("Argument is not an object");
        }
        /* if it got here, it's a blessed reference. better be an HV */
        {
            SV *svr;
            SV **closed;
            svr = SvRV(ST(2));
            if (! svr ) {
                croak("PANIC: Could not get reference from blessed object.");
            }
            if (SvTYPE(svr) != SVt_PVHV) {
                croak("PANIC: Underlying storage of blessed reference is not a hash.");
            }
            closed = hv_fetchs( (HV *) svr, "_closed", 0 );
            if (closed != NULL && SvTRUE(*closed)) {
                /* if it's already closed, just return */
                XSRETURN_EMPTY;
            }
        }
        mg = PerlLibzmq2_Socket_mg_find(aTHX_ SvRV(ST(2)), &PerlLibzmq2_Socket_vtbl);
        if (mg) {
            outsocket = (PerlLibzmq2_Socket *) mg->mg_ptr;
        }
        if (outsocket == NULL)
            croak("Invalid ZMQ::LibZMQ2::Socket object (perhaps you've already freed it?)");
    }
;
#line 818 "xs/perl_libzmq2.xs"
        RETVAL = zmq_device( device, insocket->socket, outsocket->socket );
#line 2280 "xs/perl_libzmq2.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

#ifdef __cplusplus
extern "C"
#endif
XS_EXTERNAL(boot_ZMQ__LibZMQ2); /* prototype to pass -Wmissing-prototypes */
XS_EXTERNAL(boot_ZMQ__LibZMQ2)
{
    dVAR; dXSARGS;
#if (PERL_REVISION == 5 && PERL_VERSION < 9)
    char* file = __FILE__;
#else
    const char* file = __FILE__;
#endif

    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(items); /* -W */
#ifdef XS_APIVERSION_BOOTCHECK
    XS_APIVERSION_BOOTCHECK;
#endif
    XS_VERSION_BOOTCHECK;

    {
        CV * cv;

        cv = newXS("ZMQ::LibZMQ2::Constants::ZMQ_RCVMORE", XS_ZMQ__LibZMQ2__Constants__constant, file);
        XSANY.any_i32 = ZMQ_RCVMORE;
        cv = newXS("ZMQ::LibZMQ2::Constants::ZMQ_HAUSNUMERO", XS_ZMQ__LibZMQ2__Constants__constant, file);
        XSANY.any_i32 = ZMQ_HAUSNUMERO;
        cv = newXS("ZMQ::LibZMQ2::Constants::ZMQ_UNSUBSCRIBE", XS_ZMQ__LibZMQ2__Constants__constant, file);
        XSANY.any_i32 = ZMQ_UNSUBSCRIBE;
        cv = newXS("ZMQ::LibZMQ2::Constants::ZMQ_PAIR", XS_ZMQ__LibZMQ2__Constants__constant, file);
        XSANY.any_i32 = ZMQ_PAIR;
        cv = newXS("ZMQ::LibZMQ2::Constants::ZMQ_QUEUE", XS_ZMQ__LibZMQ2__Constants__constant, file);
        XSANY.any_i32 = ZMQ_QUEUE;
        cv = newXS("ZMQ::LibZMQ2::Constants::ZMQ_VERSION_MAJOR", XS_ZMQ__LibZMQ2__Constants__constant, file);
        XSANY.any_i32 = ZMQ_VERSION_MAJOR;
        cv = newXS("ZMQ::LibZMQ2::Constants::ZMQ_DOWNSTREAM", XS_ZMQ__LibZMQ2__Constants__constant, file);
        XSANY.any_i32 = ZMQ_DOWNSTREAM;
        cv = newXS("ZMQ::LibZMQ2::Constants::ZMQ_XREQ", XS_ZMQ__LibZMQ2__Constants__constant, file);
        XSANY.any_i32 = ZMQ_XREQ;
        cv = newXS("ZMQ::LibZMQ2::Constants::_constant", XS_ZMQ__LibZMQ2__Constants__constant, file);
        XSANY.any_i32 = 0;
        cv = newXS("ZMQ::LibZMQ2::Constants::ZMQ_TYPE", XS_ZMQ__LibZMQ2__Constants__constant, file);
        XSANY.any_i32 = ZMQ_TYPE;
        cv = newXS("ZMQ::LibZMQ2::Constants::ZMQ_SUB", XS_ZMQ__LibZMQ2__Constants__constant, file);
        XSANY.any_i32 = ZMQ_SUB;
        cv = newXS("ZMQ::LibZMQ2::Constants::ZMQ_HWM", XS_ZMQ__LibZMQ2__Constants__constant, file);
        XSANY.any_i32 = ZMQ_HWM;
        cv = newXS("ZMQ::LibZMQ2::Constants::ZMQ_EVENTS", XS_ZMQ__LibZMQ2__Constants__constant, file);
        XSANY.any_i32 = ZMQ_EVENTS;
        cv = newXS("ZMQ::LibZMQ2::Constants::ZMQ_SUBSCRIBE", XS_ZMQ__LibZMQ2__Constants__constant, file);
        XSANY.any_i32 = ZMQ_SUBSCRIBE;
        cv = newXS("ZMQ::LibZMQ2::Constants::ZMQ_XREP", XS_ZMQ__LibZMQ2__Constants__constant, file);
        XSANY.any_i32 = ZMQ_XREP;
        cv = newXS("ZMQ::LibZMQ2::Constants::ZMQ_AFFINITY", XS_ZMQ__LibZMQ2__Constants__constant, file);
        XSANY.any_i32 = ZMQ_AFFINITY;
        cv = newXS("ZMQ::LibZMQ2::Constants::ZMQ_RECONNECT_IVL_MAX", XS_ZMQ__LibZMQ2__Constants__constant, file);
        XSANY.any_i32 = ZMQ_RECONNECT_IVL_MAX;
        cv = newXS("ZMQ::LibZMQ2::Constants::ZMQ_SNDMORE", XS_ZMQ__LibZMQ2__Constants__constant, file);
        XSANY.any_i32 = ZMQ_SNDMORE;
        cv = newXS("ZMQ::LibZMQ2::Constants::ZMQ_BACKLOG", XS_ZMQ__LibZMQ2__Constants__constant, file);
        XSANY.any_i32 = ZMQ_BACKLOG;
        cv = newXS("ZMQ::LibZMQ2::Constants::ZMQ_NOBLOCK", XS_ZMQ__LibZMQ2__Constants__constant, file);
        XSANY.any_i32 = ZMQ_NOBLOCK;
        cv = newXS("ZMQ::LibZMQ2::Constants::ZMQ_MSG_SHARED", XS_ZMQ__LibZMQ2__Constants__constant, file);
        XSANY.any_i32 = ZMQ_MSG_SHARED;
        cv = newXS("ZMQ::LibZMQ2::Constants::ZMQ_XPUB", XS_ZMQ__LibZMQ2__Constants__constant, file);
        XSANY.any_i32 = ZMQ_XPUB;
        cv = newXS("ZMQ::LibZMQ2::Constants::ZMQ_RCVBUF", XS_ZMQ__LibZMQ2__Constants__constant, file);
        XSANY.any_i32 = ZMQ_RCVBUF;
        cv = newXS("ZMQ::LibZMQ2::Constants::ZMQ_POLLOUT", XS_ZMQ__LibZMQ2__Constants__constant, file);
        XSANY.any_i32 = ZMQ_POLLOUT;
        cv = newXS("ZMQ::LibZMQ2::Constants::ZMQ_VERSION_PATCH", XS_ZMQ__LibZMQ2__Constants__constant, file);
        XSANY.any_i32 = ZMQ_VERSION_PATCH;
        cv = newXS("ZMQ::LibZMQ2::Constants::ZMQ_VERSION_MINOR", XS_ZMQ__LibZMQ2__Constants__constant, file);
        XSANY.any_i32 = ZMQ_VERSION_MINOR;
        cv = newXS("ZMQ::LibZMQ2::Constants::ZMQ_POLLERR", XS_ZMQ__LibZMQ2__Constants__constant, file);
        XSANY.any_i32 = ZMQ_POLLERR;
        cv = newXS("ZMQ::LibZMQ2::Constants::ZMQ_RECONNECT_IVL", XS_ZMQ__LibZMQ2__Constants__constant, file);
        XSANY.any_i32 = ZMQ_RECONNECT_IVL;
        cv = newXS("ZMQ::LibZMQ2::Constants::ZMQ_DELIMITER", XS_ZMQ__LibZMQ2__Constants__constant, file);
        XSANY.any_i32 = ZMQ_DELIMITER;
        cv = newXS("ZMQ::LibZMQ2::Constants::ZMQ_ROUTER", XS_ZMQ__LibZMQ2__Constants__constant, file);
        XSANY.any_i32 = ZMQ_ROUTER;
        cv = newXS("ZMQ::LibZMQ2::Constants::ZMQ_LINGER", XS_ZMQ__LibZMQ2__Constants__constant, file);
        XSANY.any_i32 = ZMQ_LINGER;
        cv = newXS("ZMQ::LibZMQ2::Constants::ZMQ_IDENTITY", XS_ZMQ__LibZMQ2__Constants__constant, file);
        XSANY.any_i32 = ZMQ_IDENTITY;
        cv = newXS("ZMQ::LibZMQ2::Constants::ZMQ_MSG_MASK", XS_ZMQ__LibZMQ2__Constants__constant, file);
        XSANY.any_i32 = ZMQ_MSG_MASK;
        cv = newXS("ZMQ::LibZMQ2::Constants::ZMQ_PUSH", XS_ZMQ__LibZMQ2__Constants__constant, file);
        XSANY.any_i32 = ZMQ_PUSH;
        cv = newXS("ZMQ::LibZMQ2::Constants::ZMQ_RECOVERY_IVL_MSEC", XS_ZMQ__LibZMQ2__Constants__constant, file);
        XSANY.any_i32 = ZMQ_RECOVERY_IVL_MSEC;
        cv = newXS("ZMQ::LibZMQ2::Constants::ZMQ_PULL", XS_ZMQ__LibZMQ2__Constants__constant, file);
        XSANY.any_i32 = ZMQ_PULL;
        cv = newXS("ZMQ::LibZMQ2::Constants::ZMQ_SNDBUF", XS_ZMQ__LibZMQ2__Constants__constant, file);
        XSANY.any_i32 = ZMQ_SNDBUF;
        cv = newXS("ZMQ::LibZMQ2::Constants::ZMQ_MSG_MORE", XS_ZMQ__LibZMQ2__Constants__constant, file);
        XSANY.any_i32 = ZMQ_MSG_MORE;
        cv = newXS("ZMQ::LibZMQ2::Constants::ZMQ_POLLIN", XS_ZMQ__LibZMQ2__Constants__constant, file);
        XSANY.any_i32 = ZMQ_POLLIN;
        cv = newXS("ZMQ::LibZMQ2::Constants::ZMQ_VSM", XS_ZMQ__LibZMQ2__Constants__constant, file);
        XSANY.any_i32 = ZMQ_VSM;
        cv = newXS("ZMQ::LibZMQ2::Constants::ZMQ_XSUB", XS_ZMQ__LibZMQ2__Constants__constant, file);
        XSANY.any_i32 = ZMQ_XSUB;
        cv = newXS("ZMQ::LibZMQ2::Constants::ZMQ_STREAMER", XS_ZMQ__LibZMQ2__Constants__constant, file);
        XSANY.any_i32 = ZMQ_STREAMER;
        cv = newXS("ZMQ::LibZMQ2::Constants::ZMQ_RATE", XS_ZMQ__LibZMQ2__Constants__constant, file);
        XSANY.any_i32 = ZMQ_RATE;
        cv = newXS("ZMQ::LibZMQ2::Constants::ZMQ_MCAST_LOOP", XS_ZMQ__LibZMQ2__Constants__constant, file);
        XSANY.any_i32 = ZMQ_MCAST_LOOP;
        cv = newXS("ZMQ::LibZMQ2::Constants::ZMQ_REQ", XS_ZMQ__LibZMQ2__Constants__constant, file);
        XSANY.any_i32 = ZMQ_REQ;
        cv = newXS("ZMQ::LibZMQ2::Constants::ZMQ_UPSTREAM", XS_ZMQ__LibZMQ2__Constants__constant, file);
        XSANY.any_i32 = ZMQ_UPSTREAM;
        cv = newXS("ZMQ::LibZMQ2::Constants::ZMQ_PUB", XS_ZMQ__LibZMQ2__Constants__constant, file);
        XSANY.any_i32 = ZMQ_PUB;
        cv = newXS("ZMQ::LibZMQ2::Constants::ZMQ_FORWARDER", XS_ZMQ__LibZMQ2__Constants__constant, file);
        XSANY.any_i32 = ZMQ_FORWARDER;
        cv = newXS("ZMQ::LibZMQ2::Constants::ZMQ_FD", XS_ZMQ__LibZMQ2__Constants__constant, file);
        XSANY.any_i32 = ZMQ_FD;
        cv = newXS("ZMQ::LibZMQ2::Constants::ZMQ_VERSION", XS_ZMQ__LibZMQ2__Constants__constant, file);
        XSANY.any_i32 = ZMQ_VERSION;
        cv = newXS("ZMQ::LibZMQ2::Constants::ZMQ_SWAP", XS_ZMQ__LibZMQ2__Constants__constant, file);
        XSANY.any_i32 = ZMQ_SWAP;
        cv = newXS("ZMQ::LibZMQ2::Constants::ZMQ_DEALER", XS_ZMQ__LibZMQ2__Constants__constant, file);
        XSANY.any_i32 = ZMQ_DEALER;
        cv = newXS("ZMQ::LibZMQ2::Constants::ZMQ_RECOVERY_IVL", XS_ZMQ__LibZMQ2__Constants__constant, file);
        XSANY.any_i32 = ZMQ_RECOVERY_IVL;
        cv = newXS("ZMQ::LibZMQ2::Constants::ZMQ_REP", XS_ZMQ__LibZMQ2__Constants__constant, file);
        XSANY.any_i32 = ZMQ_REP;
        cv = newXS("ZMQ::LibZMQ2::Constants::ZMQ_MAX_VSM_SIZE", XS_ZMQ__LibZMQ2__Constants__constant, file);
        XSANY.any_i32 = ZMQ_MAX_VSM_SIZE;
        newXS("ZMQ::LibZMQ2::zmq_version", XS_ZMQ__LibZMQ2_zmq_version, file);
        newXS("ZMQ::LibZMQ2::zmq_init", XS_ZMQ__LibZMQ2_zmq_init, file);
        newXS("ZMQ::LibZMQ2::zmq_term", XS_ZMQ__LibZMQ2_zmq_term, file);
        newXS("ZMQ::LibZMQ2::zmq_msg_init", XS_ZMQ__LibZMQ2_zmq_msg_init, file);
        newXS("ZMQ::LibZMQ2::zmq_msg_init_size", XS_ZMQ__LibZMQ2_zmq_msg_init_size, file);
        newXS("ZMQ::LibZMQ2::zmq_msg_init_data", XS_ZMQ__LibZMQ2_zmq_msg_init_data, file);
        newXS("ZMQ::LibZMQ2::zmq_msg_data", XS_ZMQ__LibZMQ2_zmq_msg_data, file);
        newXS("ZMQ::LibZMQ2::zmq_msg_size", XS_ZMQ__LibZMQ2_zmq_msg_size, file);
        newXS("ZMQ::LibZMQ2::zmq_msg_close", XS_ZMQ__LibZMQ2_zmq_msg_close, file);
        newXS("ZMQ::LibZMQ2::zmq_msg_move", XS_ZMQ__LibZMQ2_zmq_msg_move, file);
        newXS("ZMQ::LibZMQ2::zmq_msg_copy", XS_ZMQ__LibZMQ2_zmq_msg_copy, file);
        newXS("ZMQ::LibZMQ2::zmq_socket", XS_ZMQ__LibZMQ2_zmq_socket, file);
        newXS("ZMQ::LibZMQ2::zmq_close", XS_ZMQ__LibZMQ2_zmq_close, file);
        newXS("ZMQ::LibZMQ2::zmq_connect", XS_ZMQ__LibZMQ2_zmq_connect, file);
        newXS("ZMQ::LibZMQ2::zmq_bind", XS_ZMQ__LibZMQ2_zmq_bind, file);
        newXS("ZMQ::LibZMQ2::zmq_recv", XS_ZMQ__LibZMQ2_zmq_recv, file);
        newXS("ZMQ::LibZMQ2::zmq_send", XS_ZMQ__LibZMQ2_zmq_send, file);
        newXS("ZMQ::LibZMQ2::zmq_getsockopt_int", XS_ZMQ__LibZMQ2_zmq_getsockopt_int, file);
        newXS("ZMQ::LibZMQ2::zmq_getsockopt_int64", XS_ZMQ__LibZMQ2_zmq_getsockopt_int64, file);
        newXS("ZMQ::LibZMQ2::zmq_getsockopt_uint64", XS_ZMQ__LibZMQ2_zmq_getsockopt_uint64, file);
        newXS("ZMQ::LibZMQ2::zmq_getsockopt_string", XS_ZMQ__LibZMQ2_zmq_getsockopt_string, file);
        newXS("ZMQ::LibZMQ2::zmq_setsockopt_int", XS_ZMQ__LibZMQ2_zmq_setsockopt_int, file);
        newXS("ZMQ::LibZMQ2::zmq_setsockopt_int64", XS_ZMQ__LibZMQ2_zmq_setsockopt_int64, file);
        newXS("ZMQ::LibZMQ2::zmq_setsockopt_uint64", XS_ZMQ__LibZMQ2_zmq_setsockopt_uint64, file);
        newXS("ZMQ::LibZMQ2::zmq_setsockopt_string", XS_ZMQ__LibZMQ2_zmq_setsockopt_string, file);
        newXS("ZMQ::LibZMQ2::zmq_poll", XS_ZMQ__LibZMQ2_zmq_poll, file);
        newXS("ZMQ::LibZMQ2::zmq_device", XS_ZMQ__LibZMQ2_zmq_device, file);
    }

    /* Initialisation Section */

#line 324 "xs/perl_libzmq2.xs"
    {
        PerlLibzmq2_trace( "Booting Perl ZMQ::LibZMQ2" );
    }

#line 2455 "xs/perl_libzmq2.c"

    /* End of Initialisation Section */

#if (PERL_REVISION == 5 && PERL_VERSION >= 9)
  if (PL_unitcheckav)
       call_list(PL_scopestack_ix, PL_unitcheckav);
#endif
    XSRETURN_YES;
}

