# This file was automatically generated by SWIG (http://www.swig.org).
# Version 2.0.4
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

package Math::GSL::Combination;
use base qw(Exporter);
use base qw(DynaLoader);
package Math::GSL::Combinationc;
bootstrap Math::GSL::Combination;
package Math::GSL::Combination;
@EXPORT = qw();

# ---------- BASE METHODS -------------

package Math::GSL::Combination;

sub TIEHASH {
    my ($classname,$obj) = @_;
    return bless $obj, $classname;
}

sub CLEAR { }

sub FIRSTKEY { }

sub NEXTKEY { }

sub FETCH {
    my ($self,$field) = @_;
    my $member_func = "swig_${field}_get";
    $self->$member_func();
}

sub STORE {
    my ($self,$field,$newval) = @_;
    my $member_func = "swig_${field}_set";
    $self->$member_func($newval);
}

sub this {
    my $ptr = shift;
    return tied(%$ptr);
}


# ------- FUNCTION WRAPPERS --------

package Math::GSL::Combination;

*gsl_combination_alloc = *Math::GSL::Combinationc::gsl_combination_alloc;
*gsl_combination_calloc = *Math::GSL::Combinationc::gsl_combination_calloc;
*gsl_combination_init_first = *Math::GSL::Combinationc::gsl_combination_init_first;
*gsl_combination_init_last = *Math::GSL::Combinationc::gsl_combination_init_last;
*gsl_combination_free = *Math::GSL::Combinationc::gsl_combination_free;
*gsl_combination_memcpy = *Math::GSL::Combinationc::gsl_combination_memcpy;
*gsl_combination_fread = *Math::GSL::Combinationc::gsl_combination_fread;
*gsl_combination_fwrite = *Math::GSL::Combinationc::gsl_combination_fwrite;
*gsl_combination_fscanf = *Math::GSL::Combinationc::gsl_combination_fscanf;
*gsl_combination_fprintf = *Math::GSL::Combinationc::gsl_combination_fprintf;
*gsl_combination_n = *Math::GSL::Combinationc::gsl_combination_n;
*gsl_combination_k = *Math::GSL::Combinationc::gsl_combination_k;
*gsl_combination_data = *Math::GSL::Combinationc::gsl_combination_data;
*gsl_combination_valid = *Math::GSL::Combinationc::gsl_combination_valid;
*gsl_combination_next = *Math::GSL::Combinationc::gsl_combination_next;
*gsl_combination_prev = *Math::GSL::Combinationc::gsl_combination_prev;
*gsl_combination_get = *Math::GSL::Combinationc::gsl_combination_get;

############# Class : Math::GSL::Combination::gsl_combination_struct ##############

package Math::GSL::Combination::gsl_combination_struct;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( Math::GSL::Combination );
%OWNER = ();
%ITERATORS = ();
*swig_n_get = *Math::GSL::Combinationc::gsl_combination_struct_n_get;
*swig_n_set = *Math::GSL::Combinationc::gsl_combination_struct_n_set;
*swig_k_get = *Math::GSL::Combinationc::gsl_combination_struct_k_get;
*swig_k_set = *Math::GSL::Combinationc::gsl_combination_struct_k_set;
*swig_data_get = *Math::GSL::Combinationc::gsl_combination_struct_data_get;
*swig_data_set = *Math::GSL::Combinationc::gsl_combination_struct_data_set;
sub new {
    my $pkg = shift;
    my $self = Math::GSL::Combinationc::new_gsl_combination_struct(@_);
    bless $self, $pkg if defined($self);
}

sub DESTROY {
    return unless $_[0]->isa('HASH');
    my $self = tied(%{$_[0]});
    return unless defined $self;
    delete $ITERATORS{$self};
    if (exists $OWNER{$self}) {
        Math::GSL::Combinationc::delete_gsl_combination_struct($self);
        delete $OWNER{$self};
    }
}

sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
}

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
}


# ------- VARIABLE STUBS --------

package Math::GSL::Combination;

*GSL_MAJOR_VERSION = *Math::GSL::Combinationc::GSL_MAJOR_VERSION;
*GSL_MINOR_VERSION = *Math::GSL::Combinationc::GSL_MINOR_VERSION;
*GSL_POSZERO = *Math::GSL::Combinationc::GSL_POSZERO;
*GSL_NEGZERO = *Math::GSL::Combinationc::GSL_NEGZERO;

@EXPORT_OK = qw/
               gsl_combination_alloc 
               gsl_combination_calloc 
               gsl_combination_init_first 
               gsl_combination_init_last 
               gsl_combination_free 
               gsl_combination_memcpy 
               gsl_combination_fread 
               gsl_combination_fwrite 
               gsl_combination_fscanf 
               gsl_combination_fprintf 
               gsl_combination_n 
               gsl_combination_k 
               gsl_combination_data 
               gsl_combination_get 
               gsl_combination_valid 
               gsl_combination_next 
               gsl_combination_prev 
             /;
%EXPORT_TAGS = ( all => [ @EXPORT_OK ] );

=head1 NAME

Math::GSL::Combination - Combinations

=head1 SYNOPSIS

    use Math::GSL qw/:all/;
    use Math::GSL::Combination qw/:all/;

    my $c   = Math::GSL::Combination->new(6,3);
    print join (" ", $c->as_list) . "\n";
    $c->next;
    print join (" ", $c->as_list) . "\n";

    my $fd = gsl_fopen('combination.dat', 'w');
    gsl_combination_fwrite($fd, $c->raw);
    gsl_fclose($fd);

=head1 DESCRIPTION

Here is a list of all the functions in this module :

=over

=item * C<gsl_combination_alloc($n, $k)>

This function allocates memory for a new combination with parameters $n, $k.
The combination is not initialized and its elements are undefined. Use the
function gsl_combination_calloc if you want to create a combination which is
initialized to the lexicographically first combination.

=item * C<gsl_combination_calloc($n, $k)>

This function allocates memory for a new combination with parameters $n, $k and
initializes it to the lexicographically first combination.

=item * C<gsl_combination_init_first($c)>

This function initializes the combination $c to the lexicographically first
combination, i.e. (0,1,2,...,k-1). 

=item * C<gsl_combination_init_last($c)>

This function initializes the combination $c to the lexicographically last
combination, i.e. (n-k,n-k+1,...,n-1). 

=item * C<gsl_combination_free($c)>

This function frees all the memory used by the combination $c.

=item * C<gsl_combination_memcpy($dest, $src)>

This function copies the elements of the combination $src into the combination
$dest. The two combinations must have the same size.

=item * C<gsl_combination_get($c, $i)>

This function returns the value of the i-th element of the combination $c. If
$i lies outside the allowed range of 0 to k-1 then the error handler is invoked
and 0 is returned.

=item * C<gsl_combination_fwrite($stream, $c)>

This function writes the elements of the combination $c to the stream $stream,
opened with the gsl_fopen function from the Math::GSL module, in binary format.
The function returns $GSL_EFAILED if there was a problem writing to the file.
Since the data is written in the native binary format it may not be portable
between different architectures.

=item * C<gsl_combination_fread($stream, $c)>

This function reads elements from the open stream $stream, opened with the
gsl_fopen function from the Math::GSL module, into the combination $c in binary
format. The combination $c must be preallocated with correct values of n and k
since the function uses the size of $c to determine how many bytes to read. The
function returns $GSL_EFAILED if there was a problem reading from the file. The
data is assumed to have been written in the native binary format on the same
architecture.

=item * C<gsl_combination_fprintf($stream, $c, $format)>

This function writes the elements of the combination $c line-by-line to the
stream $stream, opened with the gsl_fopen function from the Math::GSL module,
using the format specifier $format, which should be suitable for a type of
size_t. In ISO C99 the type modifier z represents size_t, so "%zu\n" is a
suitable format. The function returns $GSL_EFAILED if there was a problem
writing to the file.

=item * C<gsl_combination_fscanf($stream, $c)>

This function reads formatted data from the stream $stream into the combination
$c. The combination $c must be preallocated with correct values of n and k
since the function uses the size of $c to determine how many numbers to read.
The function returns $GSL_EFAILED if there was a problem reading from the file.

=item * C<gsl_combination_n($c)>

This function returns the range (n) of the combination $c.

=item * C<gsl_combination_k($c)>

This function returns the number of elements (k) in the combination $c.

=item * C<gsl_combination_data($c)>

This function returns a pointer to the array of elements in the combination $c.

=item * C<gsl_combination_valid($c)>

This function checks that the combination $c is valid. The k elements should
lie in the range 0 to n-1, with each value occurring once at most and in
increasing order.

=item * C<gsl_combination_next($c)>

This function advances the combination $c to the next combination in
lexicographic order and returns $GSL_SUCCESS. If no further combinations are
available it returns $GSL_FAILURE and leaves $c unmodified. Starting with the
first combination and repeatedly applying this function will iterate through
all possible combinations of a given order.

=item * C<gsl_combination_prev($c)>

This function steps backwards from the combination $c to the previous
combination in lexicographic order, returning $GSL_SUCCESS. If no previous
combination is available it returns $GSL_FAILURE and leaves $c unmodified.

=back

=cut

sub new {
    my ($class, $n, $k) = @_;
    my $this = {};
    $this->{_length} = $n;
    $this->{_combination} = gsl_combination_calloc($n, $k);
    bless $this, $class;
}

sub as_list {
    my $self=shift;
    $self->get( [ 0 .. $self->elements - 1  ] );
}

sub get {
    my ($self, $indices) = @_;
    return map {  gsl_combination_get($self->{_combination}, $_ ) } @$indices ;
}

sub raw { (shift)->{_combination} }
sub length { (shift)->{_length} }

sub elements { 
    my $self = shift;
    return gsl_combination_k($self->{_combination});
}

sub status {
    my ($self,$status) = @_;
    if (defined $status) {
        $self->{status} = $status;
        return $self;
    } else {
        return $self->{status};
   }
}

sub next {
    my $self = shift;
    my $status = gsl_combination_next($self->{_combination});
    $self->status($status);
    return $self;
}

sub prev {
    my $self = shift;
    my $status = gsl_combination_prev($self->{_combination});
    $self->status($status);
    return $status;
}

=head1 MORE INFO

For more informations on the functions, we refer you to the GSL offcial
documentation: L<http://www.gnu.org/software/gsl/manual/html_node/>

 


=head1 AUTHORS

Jonathan "Duke" Leto <jonathan@leto.net> and Thierry Moisan <thierry.moisan@gmail.com>

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2008-2011 Jonathan "Duke" Leto and Thierry Moisan

This program is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

=cut

1;
