package Module::OTRS::CoreList;

use strict;
use warnings;

our $VERSION = 0.02;

# ABSTRACT: what modules shipped with versions of OTRS (>= 2.3.x)


my %global = (
    'core' => {
        'Kernel::Config::Defaults' => 21,
        'Kernel::Language' => 21,
        'Kernel::Language::ar_SA' => 21,
        'Kernel::Language::bg' => 21,
        'Kernel::Language::ct' => 21,
        'Kernel::Language::da' => 21,
        'Kernel::Language::de' => 21,
        'Kernel::Language::el' => 21,
        'Kernel::Language::en' => 21,
        'Kernel::Language::es' => 21,
        'Kernel::Language::et' => 21,
        'Kernel::Language::fa' => 21,
        'Kernel::Language::fi' => 21,
        'Kernel::Language::fr' => 21,
        'Kernel::Language::hu' => 21,
        'Kernel::Language::it' => 21,
        'Kernel::Language::nb_NO' => 21,
        'Kernel::Language::nl' => 21,
        'Kernel::Language::pl' => 21,
        'Kernel::Language::pt' => 21,
        'Kernel::Language::pt_BR' => 21,
        'Kernel::Language::ru' => 21,
        'Kernel::Language::sk_SK' => 21,
        'Kernel::Language::sv' => 21,
        'Kernel::Language::tr' => 21,
        'Kernel::Language::vi_VN' => 21,
        'Kernel::Language::xx_AgentZoom' => 21,
        'Kernel::Language::xx_Custom' => 21,
        'Kernel::Language::zh_CN' => 21,
        'Kernel::Modules::Admin' => 21,
        'Kernel::Modules::AdminAttachment' => 21,
        'Kernel::Modules::AdminAutoResponse' => 21,
        'Kernel::Modules::AdminCustomerCompany' => 21,
        'Kernel::Modules::AdminCustomerUser' => 21,
        'Kernel::Modules::AdminCustomerUserGroup' => 21,
        'Kernel::Modules::AdminCustomerUserService' => 21,
        'Kernel::Modules::AdminEmail' => 21,
        'Kernel::Modules::AdminGenericAgent' => 21,
        'Kernel::Modules::AdminGroup' => 21,
        'Kernel::Modules::AdminInit' => 21,
        'Kernel::Modules::AdminLog' => 21,
        'Kernel::Modules::AdminMailAccount' => 21,
        'Kernel::Modules::AdminNotification' => 21,
        'Kernel::Modules::AdminPGP' => 21,
        'Kernel::Modules::AdminPackageManager' => 21,
        'Kernel::Modules::AdminPerformanceLog' => 21,
        'Kernel::Modules::AdminPostMasterFilter' => 21,
        'Kernel::Modules::AdminPriority' => 21,
        'Kernel::Modules::AdminQueue' => 21,
        'Kernel::Modules::AdminQueueAutoResponse' => 21,
        'Kernel::Modules::AdminQueueResponses' => 21,
        'Kernel::Modules::AdminResponse' => 21,
        'Kernel::Modules::AdminResponseAttachment' => 21,
        'Kernel::Modules::AdminRole' => 21,
        'Kernel::Modules::AdminRoleGroup' => 21,
        'Kernel::Modules::AdminRoleUser' => 21,
        'Kernel::Modules::AdminSLA' => 21,
        'Kernel::Modules::AdminSMIME' => 21,
        'Kernel::Modules::AdminSalutation' => 21,
        'Kernel::Modules::AdminSelectBox' => 21,
        'Kernel::Modules::AdminService' => 21,
        'Kernel::Modules::AdminSession' => 21,
        'Kernel::Modules::AdminSignature' => 21,
        'Kernel::Modules::AdminState' => 21,
        'Kernel::Modules::AdminSysConfig' => 21,
        'Kernel::Modules::AdminSystemAddress' => 21,
        'Kernel::Modules::AdminType' => 21,
        'Kernel::Modules::AdminUser' => 21,
        'Kernel::Modules::AdminUserGroup' => 21,
        'Kernel::Modules::AgentBook' => 21,
        'Kernel::Modules::AgentInfo' => 21,
        'Kernel::Modules::AgentLinkObject' => 21,
        'Kernel::Modules::AgentPreferences' => 21,
        'Kernel::Modules::AgentSpelling' => 21,
        'Kernel::Modules::AgentStats' => 21,
        'Kernel::Modules::AgentTicketAttachment' => 21,
        'Kernel::Modules::AgentTicketBounce' => 21,
        'Kernel::Modules::AgentTicketBulk' => 21,
        'Kernel::Modules::AgentTicketClose' => 21,
        'Kernel::Modules::AgentTicketCompose' => 21,
        'Kernel::Modules::AgentTicketCustomer' => 21,
        'Kernel::Modules::AgentTicketEmail' => 21,
        'Kernel::Modules::AgentTicketEscalationView' => 21,
        'Kernel::Modules::AgentTicketForward' => 21,
        'Kernel::Modules::AgentTicketFreeText' => 21,
        'Kernel::Modules::AgentTicketHistory' => 21,
        'Kernel::Modules::AgentTicketLock' => 21,
        'Kernel::Modules::AgentTicketMerge' => 21,
        'Kernel::Modules::AgentTicketMove' => 21,
        'Kernel::Modules::AgentTicketNote' => 21,
        'Kernel::Modules::AgentTicketOwner' => 21,
        'Kernel::Modules::AgentTicketPending' => 21,
        'Kernel::Modules::AgentTicketPhone' => 21,
        'Kernel::Modules::AgentTicketPhoneOutbound' => 21,
        'Kernel::Modules::AgentTicketPlain' => 21,
        'Kernel::Modules::AgentTicketPrint' => 21,
        'Kernel::Modules::AgentTicketPriority' => 21,
        'Kernel::Modules::AgentTicketQueue' => 21,
        'Kernel::Modules::AgentTicketResponsible' => 21,
        'Kernel::Modules::AgentTicketSearch' => 21,
        'Kernel::Modules::AgentTicketStatusView' => 21,
        'Kernel::Modules::AgentTicketWatcher' => 21,
        'Kernel::Modules::AgentTicketZoom' => 21,
        'Kernel::Modules::AgentZoom' => 21,
        'Kernel::Modules::CustomerAccept' => 21,
        'Kernel::Modules::CustomerPreferences' => 21,
        'Kernel::Modules::CustomerTicketAttachment' => 21,
        'Kernel::Modules::CustomerTicketMessage' => 21,
        'Kernel::Modules::CustomerTicketOverView' => 21,
        'Kernel::Modules::CustomerTicketPrint' => 21,
        'Kernel::Modules::CustomerTicketSearch' => 21,
        'Kernel::Modules::CustomerTicketZoom' => 21,
        'Kernel::Modules::CustomerZoom' => 21,
        'Kernel::Modules::Installer' => 21,
        'Kernel::Modules::PublicRepository' => 21,
        'Kernel::Modules::Test' => 21,
        'Kernel::Output::HTML::ArticleAttachmentDownload' => 21,
        'Kernel::Output::HTML::ArticleAttachmentHTMLViewer' => 21,
        'Kernel::Output::HTML::ArticleCheckPGP' => 21,
        'Kernel::Output::HTML::ArticleCheckSMIME' => 21,
        'Kernel::Output::HTML::ArticleComposeCrypt' => 21,
        'Kernel::Output::HTML::ArticleComposeSign' => 21,
        'Kernel::Output::HTML::CustomerNewTicketQueueSelectionGeneric' => 21,
        'Kernel::Output::HTML::CustomerUserGeneric' => 21,
        'Kernel::Output::HTML::CustomerUserGenericTicket' => 21,
        'Kernel::Output::HTML::HeaderMetaRefresh' => 21,
        'Kernel::Output::HTML::HeaderMetaTicketSearch' => 21,
        'Kernel::Output::HTML::Layout' => 21,
        'Kernel::Output::HTML::LayoutAJAX' => 21,
        'Kernel::Output::HTML::LayoutLinkObject' => 21,
        'Kernel::Output::HTML::LayoutTicket' => 21,
        'Kernel::Output::HTML::LinkObjectTicket' => 21,
        'Kernel::Output::HTML::NavBarCustomerCompany' => 21,
        'Kernel::Output::HTML::NavBarModuleAdmin' => 21,
        'Kernel::Output::HTML::NotificationAgentOnline' => 21,
        'Kernel::Output::HTML::NotificationAgentTicketEscalation' => 21,
        'Kernel::Output::HTML::NotificationCharsetCheck' => 21,
        'Kernel::Output::HTML::NotificationCustomerOnline' => 21,
        'Kernel::Output::HTML::NotificationUIDCheck' => 21,
        'Kernel::Output::HTML::OutputFilterTextURL' => 21,
        'Kernel::Output::HTML::PreferencesCustomQueue' => 21,
        'Kernel::Output::HTML::PreferencesGeneric' => 21,
        'Kernel::Output::HTML::PreferencesLanguage' => 21,
        'Kernel::Output::HTML::PreferencesPGP' => 21,
        'Kernel::Output::HTML::PreferencesPassword' => 21,
        'Kernel::Output::HTML::PreferencesSMIME' => 21,
        'Kernel::Output::HTML::PreferencesTheme' => 21,
        'Kernel::Output::HTML::PreferencesTimeZone' => 21,
        'Kernel::Output::HTML::QueuePreferencesGeneric' => 21,
        'Kernel::Output::HTML::TicketMenuGeneric' => 21,
        'Kernel::Output::HTML::TicketMenuLock' => 21,
        'Kernel::Output::HTML::TicketMenuResponsible' => 21,
        'Kernel::Output::HTML::TicketMenuTicketWatcher' => 21,
        'Kernel::System::Auth' => 21,
        'Kernel::System::Auth::DB' => 21,
        'Kernel::System::Auth::HTTPBasicAuth' => 21,
        'Kernel::System::Auth::LDAP' => 21,
        'Kernel::System::Auth::Radius' => 21,
        'Kernel::System::AuthSession' => 21,
        'Kernel::System::AuthSession::DB' => 21,
        'Kernel::System::AuthSession::FS' => 21,
        'Kernel::System::AutoResponse' => 21,
        'Kernel::System::CSV' => 21,
        'Kernel::System::Cache' => 21,
        'Kernel::System::CheckItem' => 21,
        'Kernel::System::Crypt' => 21,
        'Kernel::System::Crypt::PGP' => 21,
        'Kernel::System::Crypt::SMIME' => 21,
        'Kernel::System::CustomerAuth' => 21,
        'Kernel::System::CustomerAuth::DB' => 21,
        'Kernel::System::CustomerAuth::HTTPBasicAuth' => 21,
        'Kernel::System::CustomerAuth::LDAP' => 21,
        'Kernel::System::CustomerAuth::Radius' => 21,
        'Kernel::System::CustomerCompany' => 21,
        'Kernel::System::CustomerGroup' => 21,
        'Kernel::System::CustomerUser' => 21,
        'Kernel::System::CustomerUser::DB' => 21,
        'Kernel::System::CustomerUser::LDAP' => 21,
        'Kernel::System::CustomerUser::Preferences::DB' => 21,
        'Kernel::System::DB' => 21,
        'Kernel::System::DB::db2' => 21,
        'Kernel::System::DB::ingres' => 21,
        'Kernel::System::DB::mssql' => 21,
        'Kernel::System::DB::mysql' => 21,
        'Kernel::System::DB::oracle' => 21,
        'Kernel::System::DB::postgresql' => 21,
        'Kernel::System::Email' => 21,
        'Kernel::System::Email::DoNotSendEmail' => 21,
        'Kernel::System::Email::SMTP' => 21,
        'Kernel::System::Email::Sendmail' => 21,
        'Kernel::System::EmailParser' => 21,
        'Kernel::System::Encode' => 21,
        'Kernel::System::FileTemp' => 21,
        'Kernel::System::GenericAgent' => 21,
        'Kernel::System::GenericAgent::AutoPriorityIncrease' => 21,
        'Kernel::System::GenericAgent::NotifyAgentGroupOfCustomQueue' => 21,
        'Kernel::System::GenericAgent::NotifyAgentGroupWithWritePermission' => 21,
        'Kernel::System::Group' => 21,
        'Kernel::System::LinkObject' => 21,
        'Kernel::System::LinkObject::Ticket' => 21,
        'Kernel::System::Lock' => 21,
        'Kernel::System::Log' => 21,
        'Kernel::System::Log::File' => 21,
        'Kernel::System::Log::SysLog' => 21,
        'Kernel::System::MailAccount' => 21,
        'Kernel::System::MailAccount::IMAP' => 21,
        'Kernel::System::MailAccount::IMAPS' => 21,
        'Kernel::System::MailAccount::POP3' => 21,
        'Kernel::System::MailAccount::POP3S' => 21,
        'Kernel::System::Main' => 21,
        'Kernel::System::Notification' => 21,
        'Kernel::System::PDF' => 21,
        'Kernel::System::PID' => 21,
        'Kernel::System::Package' => 21,
        'Kernel::System::PostMaster' => 21,
        'Kernel::System::PostMaster::DestQueue' => 21,
        'Kernel::System::PostMaster::Filter' => 21,
        'Kernel::System::PostMaster::Filter::CMD' => 21,
        'Kernel::System::PostMaster::Filter::Match' => 21,
        'Kernel::System::PostMaster::Filter::MatchDBSource' => 21,
        'Kernel::System::PostMaster::Filter::NewTicketReject' => 21,
        'Kernel::System::PostMaster::FollowUp' => 21,
        'Kernel::System::PostMaster::LoopProtection' => 21,
        'Kernel::System::PostMaster::LoopProtection::DB' => 21,
        'Kernel::System::PostMaster::LoopProtection::FS' => 21,
        'Kernel::System::PostMaster::NewTicket' => 21,
        'Kernel::System::PostMaster::Reject' => 21,
        'Kernel::System::Priority' => 21,
        'Kernel::System::Queue' => 21,
        'Kernel::System::Queue::PreferencesDB' => 21,
        'Kernel::System::SLA' => 21,
        'Kernel::System::Salutation' => 21,
        'Kernel::System::SearchProfile' => 21,
        'Kernel::System::Service' => 21,
        'Kernel::System::Signature' => 21,
        'Kernel::System::Spelling' => 21,
        'Kernel::System::State' => 21,
        'Kernel::System::Stats' => 21,
        'Kernel::System::Stats::Dynamic::Ticket' => 21,
        'Kernel::System::StdAttachment' => 21,
        'Kernel::System::SystemAddress' => 21,
        'Kernel::System::Ticket' => 21,
        'Kernel::System::Ticket::Acl::CloseParentAfterClosedChilds' => 21,
        'Kernel::System::Ticket::Article' => 21,
        'Kernel::System::Ticket::ArticleSearchIndex::RuntimeDB' => 21,
        'Kernel::System::Ticket::ArticleSearchIndex::StaticDB' => 21,
        'Kernel::System::Ticket::ArticleStorageDB' => 21,
        'Kernel::System::Ticket::ArticleStorageFS' => 21,
        'Kernel::System::Ticket::CustomerPermission::CustomerIDCheck' => 21,
        'Kernel::System::Ticket::CustomerPermission::CustomerUserIDCheck' => 21,
        'Kernel::System::Ticket::CustomerPermission::GroupCheck' => 21,
        'Kernel::System::Ticket::Event::ArticleSearchIndex' => 21,
        'Kernel::System::Ticket::Event::ForceOwnerReset' => 21,
        'Kernel::System::Ticket::Event::ForceState' => 21,
        'Kernel::System::Ticket::Event::ForceUnlock' => 21,
        'Kernel::System::Ticket::Event::ResponsibleAutoSet' => 21,
        'Kernel::System::Ticket::Event::Test' => 21,
        'Kernel::System::Ticket::Event::TicketEscalationIndex' => 21,
        'Kernel::System::Ticket::Event::TicketFreeFieldDefault' => 21,
        'Kernel::System::Ticket::IndexAccelerator::RuntimeDB' => 21,
        'Kernel::System::Ticket::IndexAccelerator::StaticDB' => 21,
        'Kernel::System::Ticket::Number::AutoIncrement' => 21,
        'Kernel::System::Ticket::Number::Date' => 21,
        'Kernel::System::Ticket::Number::DateChecksum' => 21,
        'Kernel::System::Ticket::Number::Random' => 21,
        'Kernel::System::Ticket::Permission::GroupCheck' => 21,
        'Kernel::System::Ticket::Permission::OwnerCheck' => 21,
        'Kernel::System::Ticket::Permission::ResponsibleCheck' => 21,
        'Kernel::System::Time' => 21,
        'Kernel::System::Type' => 21,
        'Kernel::System::UnitTest' => 21,
        'Kernel::System::User' => 21,
        'Kernel::System::User::Preferences::DB' => 21,
        'Kernel::System::Valid' => 21,
        'Kernel::System::Web::InterfaceAgent' => 21,
        'Kernel::System::Web::InterfaceCustomer' => 21,
        'Kernel::System::Web::InterfacePublic' => 21,
        'Kernel::System::Web::Request' => 21,
        'Kernel::System::Web::UploadCache' => 21,
        'Kernel::System::Web::UploadCache::DB' => 21,
        'Kernel::System::Web::UploadCache::FS' => 21,
        'Kernel::System::XML' => 21,
        'Kernel::System::XMLMaster' => 21
    },
    'cpan' => {
        'Algorithm::Diff' => 21,
        'Algorithm::DiffOld' => 21,
        'Authen::SASL' => 21,
        'Authen::SASL::CRAM_MD5' => 21,
        'Authen::SASL::EXTERNAL' => 21,
        'Authen::SASL::Perl' => 21,
        'Authen::SASL::Perl::ANONYMOUS' => 21,
        'Authen::SASL::Perl::CRAM_MD5' => 21,
        'Authen::SASL::Perl::DIGEST_MD5' => 21,
        'Authen::SASL::Perl::EXTERNAL' => 21,
        'Authen::SASL::Perl::GSSAPI' => 21,
        'Authen::SASL::Perl::LOGIN' => 21,
        'Authen::SASL::Perl::PLAIN' => 21,
        'Crypt::PasswdMD5' => 21,
        'Date::Pcalc' => 21,
        'File::Temp' => 21,
        'IO::AtomicFile' => 21,
        'IO::InnerFile' => 21,
        'IO::Lines' => 21,
        'IO::Scalar' => 21,
        'IO::ScalarArray' => 21,
        'IO::Stringy' => 21,
        'IO::Wrap' => 21,
        'IO::WrapTie' => 21,
        'MIME::Body' => 21,
        'MIME::Decoder' => 21,
        'MIME::Decoder::Base64' => 21,
        'MIME::Decoder::BinHex' => 21,
        'MIME::Decoder::Binary' => 21,
        'MIME::Decoder::Gzip64' => 21,
        'MIME::Decoder::NBit' => 21,
        'MIME::Decoder::QuotedPrint' => 21,
        'MIME::Decoder::UU' => 21,
        'MIME::Entity' => 21,
        'MIME::Field::ConTraEnc' => 21,
        'MIME::Field::ContDisp' => 21,
        'MIME::Field::ContType' => 21,
        'MIME::Field::ParamVal' => 21,
        'MIME::Head' => 21,
        'MIME::Parser' => 21,
        'MIME::Parser::Filer' => 21,
        'MIME::Parser::Reader' => 21,
        'MIME::Parser::Results' => 21,
        'MIME::Tools' => 21,
        'MIME::WordDecoder' => 21,
        'MIME::Words' => 21,
        'Mail::Address' => 21,
        'Mail::Cap' => 21,
        'Mail::Field' => 21,
        'Mail::Field::AddrList' => 21,
        'Mail::Field::Date' => 21,
        'Mail::Field::Generic' => 21,
        'Mail::Filter' => 21,
        'Mail::Header' => 21,
        'Mail::Internet' => 21,
        'Mail::Mailer' => 21,
        'Mail::Mailer::qmail' => 21,
        'Mail::Mailer::rfc822' => 21,
        'Mail::Mailer::sendmail' => 21,
        'Mail::Mailer::smtp' => 21,
        'Mail::Mailer::testfile' => 21,
        'Mail::Send' => 21,
        'Mail::Util' => 21,
        'Net::IMAP::Simple' => 21,
        'Net::IMAP::Simple::SSL' => 21,
        'Net::POP3::SSLWrapper' => 21,
        'Text::CSV' => 21,
        'Text::CSV_PP' => 21,
        'Text::Diff' => 21,
        'Text::Diff::Table' => 21,
        'XML::Parser::Lite' => 21
    },
);

my %modules = (
    '2.3.1' => {
        'core' => {
            'Kernel::Language::bb' => 1,
            'Kernel::Language::cz' => 1,
            'Kernel::Modules::AgentCalendarSmall' => 1,
            'Kernel::Modules::AgentLookup' => 1,
            'Kernel::Modules::AgentTicketCustomerFollowUp' => 1,
            'Kernel::Modules::AgentTicketMailbox' => 1,
            'Kernel::Modules::CustomerCalendarSmall' => 1,
            'Kernel::Output::HTML::NavBarLockedTickets' => 1,
            'Kernel::Output::HTML::NavBarTicketBulkAction' => 1,
            'Kernel::Output::HTML::NavBarTicketWatcher' => 1,
            'Kernel::Output::HTML::NotificationAgentTicket' => 1,
            'Kernel::Output::HTML::NotificationAgentTicketSeen' => 1,
            'Kernel::Output::HTML::OutputFilterActiveElement' => 1,
            'Kernel::System::AuthSession::IPC' => 1,
            'Kernel::System::Cache::File' => 1,
            'Kernel::System::Config' => 1,
            'Kernel::System::DB::maxdb' => 1,
            'Kernel::System::PostMaster::Filter::AgentInterface' => 1,
            'Kernel::System::StdResponse' => 1
        },
        'cpan' => {
            'HTML::Safe' => 1
        },
    },
    '2.3.2' => {
        'core' => {
            'Kernel::Language::bb' => 1,
            'Kernel::Language::cz' => 1,
            'Kernel::Modules::AgentCalendarSmall' => 1,
            'Kernel::Modules::AgentLookup' => 1,
            'Kernel::Modules::AgentTicketCustomerFollowUp' => 1,
            'Kernel::Modules::AgentTicketMailbox' => 1,
            'Kernel::Modules::CustomerCalendarSmall' => 1,
            'Kernel::Output::HTML::NavBarLockedTickets' => 1,
            'Kernel::Output::HTML::NavBarTicketBulkAction' => 1,
            'Kernel::Output::HTML::NavBarTicketSearchProfile' => 1,
            'Kernel::Output::HTML::NavBarTicketWatcher' => 1,
            'Kernel::Output::HTML::NotificationAgentTicket' => 1,
            'Kernel::Output::HTML::NotificationAgentTicketSeen' => 1,
            'Kernel::Output::HTML::OutputFilterActiveElement' => 1,
            'Kernel::System::AuthSession::IPC' => 1,
            'Kernel::System::Cache::File' => 1,
            'Kernel::System::Config' => 1,
            'Kernel::System::DB::maxdb' => 1,
            'Kernel::System::PostMaster::Filter::AgentInterface' => 1,
            'Kernel::System::StdResponse' => 1
        },
        'cpan' => {
            'HTML::Safe' => 1
        },
    },
    '2.3.3' => {
        'core' => {
            'Kernel::Language::bb' => 1,
            'Kernel::Language::cz' => 1,
            'Kernel::Modules::AgentCalendarSmall' => 1,
            'Kernel::Modules::AgentLookup' => 1,
            'Kernel::Modules::AgentTicketCustomerFollowUp' => 1,
            'Kernel::Modules::AgentTicketMailbox' => 1,
            'Kernel::Modules::CustomerCalendarSmall' => 1,
            'Kernel::Output::HTML::NavBarLockedTickets' => 1,
            'Kernel::Output::HTML::NavBarTicketBulkAction' => 1,
            'Kernel::Output::HTML::NavBarTicketSearchProfile' => 1,
            'Kernel::Output::HTML::NavBarTicketWatcher' => 1,
            'Kernel::Output::HTML::NotificationAgentTicket' => 1,
            'Kernel::Output::HTML::NotificationAgentTicketSeen' => 1,
            'Kernel::Output::HTML::OutputFilterActiveElement' => 1,
            'Kernel::System::AuthSession::IPC' => 1,
            'Kernel::System::Cache::File' => 1,
            'Kernel::System::Config' => 1,
            'Kernel::System::DB::maxdb' => 1,
            'Kernel::System::PostMaster::Filter::AgentInterface' => 1,
            'Kernel::System::StdResponse' => 1
        },
        'cpan' => {
            'HTML::Safe' => 1,
            'Mail::POP3Client' => 1
        },
    },
    '2.3.4' => {
        'core' => {
            'Kernel::Language::bb' => 1,
            'Kernel::Language::cz' => 1,
            'Kernel::Modules::AgentCalendarSmall' => 1,
            'Kernel::Modules::AgentLookup' => 1,
            'Kernel::Modules::AgentTicketCustomerFollowUp' => 1,
            'Kernel::Modules::AgentTicketMailbox' => 1,
            'Kernel::Modules::CustomerCalendarSmall' => 1,
            'Kernel::Modules::PublicDefault' => 1,
            'Kernel::Output::HTML::NavBarLockedTickets' => 1,
            'Kernel::Output::HTML::NavBarTicketBulkAction' => 1,
            'Kernel::Output::HTML::NavBarTicketSearchProfile' => 1,
            'Kernel::Output::HTML::NavBarTicketWatcher' => 1,
            'Kernel::Output::HTML::NotificationAgentTicket' => 1,
            'Kernel::Output::HTML::NotificationAgentTicketSeen' => 1,
            'Kernel::Output::HTML::OutputFilterActiveElement' => 1,
            'Kernel::System::AuthSession::IPC' => 1,
            'Kernel::System::Cache::File' => 1,
            'Kernel::System::Config' => 1,
            'Kernel::System::DB::maxdb' => 1,
            'Kernel::System::PostMaster::Filter::AgentInterface' => 1,
            'Kernel::System::StdResponse' => 1
        },
        'cpan' => {
            'HTML::Safe' => 1,
            'Mail::POP3Client' => 1
        },
    },
    '2.3.5' => {
        'core' => {
            'Kernel::Language::bb' => 1,
            'Kernel::Language::cz' => 1,
            'Kernel::Modules::AgentCalendarSmall' => 1,
            'Kernel::Modules::AgentLookup' => 1,
            'Kernel::Modules::AgentTicketCustomerFollowUp' => 1,
            'Kernel::Modules::AgentTicketMailbox' => 1,
            'Kernel::Modules::CustomerCalendarSmall' => 1,
            'Kernel::Modules::PublicDefault' => 1,
            'Kernel::Output::HTML::NavBarLockedTickets' => 1,
            'Kernel::Output::HTML::NavBarTicketBulkAction' => 1,
            'Kernel::Output::HTML::NavBarTicketSearchProfile' => 1,
            'Kernel::Output::HTML::NavBarTicketWatcher' => 1,
            'Kernel::Output::HTML::NotificationAgentTicket' => 1,
            'Kernel::Output::HTML::NotificationAgentTicketSeen' => 1,
            'Kernel::Output::HTML::OutputFilterActiveElement' => 1,
            'Kernel::System::AuthSession::IPC' => 1,
            'Kernel::System::Cache::File' => 1,
            'Kernel::System::Config' => 1,
            'Kernel::System::DB::maxdb' => 1,
            'Kernel::System::PostMaster::Filter::AgentInterface' => 1,
            'Kernel::System::StdResponse' => 1
        },
        'cpan' => {
            'HTML::Safe' => 1,
            'Mail::POP3Client' => 1
        },
    },
    '2.3.6' => {
        'core' => {
            'Kernel::Language::bb' => 1,
            'Kernel::Language::cz' => 1,
            'Kernel::Modules::AgentCalendarSmall' => 1,
            'Kernel::Modules::AgentLookup' => 1,
            'Kernel::Modules::AgentTicketCustomerFollowUp' => 1,
            'Kernel::Modules::AgentTicketMailbox' => 1,
            'Kernel::Modules::CustomerCalendarSmall' => 1,
            'Kernel::Modules::PublicDefault' => 1,
            'Kernel::Output::HTML::NavBarLockedTickets' => 1,
            'Kernel::Output::HTML::NavBarTicketBulkAction' => 1,
            'Kernel::Output::HTML::NavBarTicketSearchProfile' => 1,
            'Kernel::Output::HTML::NavBarTicketWatcher' => 1,
            'Kernel::Output::HTML::NotificationAgentTicket' => 1,
            'Kernel::Output::HTML::NotificationAgentTicketSeen' => 1,
            'Kernel::Output::HTML::OutputFilterActiveElement' => 1,
            'Kernel::System::AuthSession::IPC' => 1,
            'Kernel::System::Cache::File' => 1,
            'Kernel::System::Config' => 1,
            'Kernel::System::DB::maxdb' => 1,
            'Kernel::System::PostMaster::Filter::AgentInterface' => 1,
            'Kernel::System::StdResponse' => 1
        },
        'cpan' => {
            'HTML::Safe' => 1,
            'Mail::POP3Client' => 1
        },
    },
    '2.4.1' => {
        'core' => {
             'Kernel::Language::cz' => 1,
             'Kernel::Language::en_CA' => 1,
             'Kernel::Language::en_GB' => 1,
             'Kernel::Language::lv' => 1,
             'Kernel::Language::zh_TW' => 1,
             'Kernel::Modules::AdminNotificationEvent' => 1,
             'Kernel::Modules::AgentCalendarSmall' => 1,
             'Kernel::Modules::AgentCustomerSearch' => 1,
             'Kernel::Modules::AgentDashboard' => 1,
             'Kernel::Modules::AgentLookup' => 1,
             'Kernel::Modules::AgentTicketLockedView' => 1,
             'Kernel::Modules::AgentTicketResponsibleView' => 1,
             'Kernel::Modules::AgentTicketWatchView' => 1,
             'Kernel::Modules::CustomerCalendarSmall' => 1,
             'Kernel::Modules::PictureUpload' => 1,
             'Kernel::Modules::PublicDefault' => 1,
             'Kernel::Output::HTML::DashboardCalendar' => 1,
             'Kernel::Output::HTML::DashboardImage' => 1,
             'Kernel::Output::HTML::DashboardProductNotify' => 1,
             'Kernel::Output::HTML::DashboardRSS' => 1,
             'Kernel::Output::HTML::DashboardTicketGeneric' => 1,
             'Kernel::Output::HTML::DashboardTicketStatsGeneric' => 1,
             'Kernel::Output::HTML::DashboardUserOnline' => 1,
             'Kernel::Output::HTML::NavBarLockedTickets' => 1,
             'Kernel::Output::HTML::NavBarTicketSearchFulltext' => 1,
             'Kernel::Output::HTML::NavBarTicketSearchProfile' => 1,
             'Kernel::Output::HTML::NavBarTicketWatcher' => 1,
             'Kernel::Output::HTML::NotificationAgentTicket' => 1,
             'Kernel::Output::HTML::NotificationAgentTicketSeen' => 1,
             'Kernel::Output::HTML::OutputFilterTextAutoLink' => 1,
             'Kernel::Output::HTML::PreferencesOutOfOffice' => 1,
             'Kernel::Output::HTML::PreferencesTicketWatcher' => 1,
             'Kernel::Output::HTML::SLAPreferencesGeneric' => 1,
             'Kernel::Output::HTML::ServicePreferencesGeneric' => 1,
             'Kernel::Output::HTML::TicketOverviewMedium' => 1,
             'Kernel::Output::HTML::TicketOverviewPreview' => 1,
             'Kernel::Output::HTML::TicketOverviewSmall' => 1,
             'Kernel::System::Auth::Sync::LDAP' => 1,
             'Kernel::System::AuthSession::IPC' => 1,
             'Kernel::System::Cache::File' => 1,
             'Kernel::System::Config' => 1,
             'Kernel::System::Email::SMTPS' => 1,
             'Kernel::System::HTMLUtils' => 1,
             'Kernel::System::NotificationEvent' => 1,
             'Kernel::System::PostMaster::Filter::FollowUpArticleTypeCheck' => 1,
             'Kernel::System::SLA::PreferencesDB' => 1,
             'Kernel::System::Service::PreferencesDB' => 1,
             'Kernel::System::Stats::Dynamic::TicketAccountedTime' => 1,
             'Kernel::System::Stats::Dynamic::TicketList' => 1,
             'Kernel::System::Stats::Dynamic::TicketSolutionResponseTime' => 1,
             'Kernel::System::Stats::Static::StateAction' => 1,
             'Kernel::System::StdResponse' => 1,
             'Kernel::System::TemplateGenerator' => 1,
             'Kernel::System::Ticket::Event::NotificationEvent' => 1,
             'Kernel::System::Ticket::Event::TicketAcceleratorUpdate' => 1,
             'Kernel::System::Ticket::Permission::WatcherCheck' => 1,
             'Kernel::System::WebUserAgent' => 1
        },
        'cpan' => {
            'Mail::POP3Client' => 1,
            'Net::SMTP::SSL' => 1,
            'XML::FeedPP' => 1,
            'XML::TreePP' => 1
        }
    },
    '2.4.2' => {
        'core' => {
            'Kernel::Language::cz' => 1,
            'Kernel::Language::en_CA' => 1,
            'Kernel::Language::en_GB' => 1,
            'Kernel::Language::lv' => 1,
            'Kernel::Language::zh_TW' => 1,
            'Kernel::Modules::AdminNotificationEvent' => 1,
            'Kernel::Modules::AgentCalendarSmall' => 1,
            'Kernel::Modules::AgentCustomerSearch' => 1,
            'Kernel::Modules::AgentDashboard' => 1,
            'Kernel::Modules::AgentLookup' => 1,
            'Kernel::Modules::AgentTicketLockedView' => 1,
            'Kernel::Modules::AgentTicketResponsibleView' => 1,
            'Kernel::Modules::AgentTicketWatchView' => 1,
            'Kernel::Modules::CustomerCalendarSmall' => 1,
            'Kernel::Modules::PictureUpload' => 1,
            'Kernel::Modules::PublicDefault' => 1,
            'Kernel::Output::HTML::DashboardCalendar' => 1,
            'Kernel::Output::HTML::DashboardImage' => 1,
            'Kernel::Output::HTML::DashboardProductNotify' => 1,
            'Kernel::Output::HTML::DashboardRSS' => 1,
            'Kernel::Output::HTML::DashboardTicketGeneric' => 1,
            'Kernel::Output::HTML::DashboardTicketStatsGeneric' => 1,
            'Kernel::Output::HTML::DashboardUserOnline' => 1,
            'Kernel::Output::HTML::NavBarLockedTickets' => 1,
            'Kernel::Output::HTML::NavBarTicketSearchFulltext' => 1,
            'Kernel::Output::HTML::NavBarTicketSearchProfile' => 1,
            'Kernel::Output::HTML::NavBarTicketWatcher' => 1,
            'Kernel::Output::HTML::NotificationAgentTicket' => 1,
            'Kernel::Output::HTML::NotificationAgentTicketSeen' => 1,
            'Kernel::Output::HTML::OutputFilterTextAutoLink' => 1,
            'Kernel::Output::HTML::PreferencesOutOfOffice' => 1,
            'Kernel::Output::HTML::PreferencesTicketWatcher' => 1,
            'Kernel::Output::HTML::SLAPreferencesGeneric' => 1,
            'Kernel::Output::HTML::ServicePreferencesGeneric' => 1,
            'Kernel::Output::HTML::TicketOverviewMedium' => 1,
            'Kernel::Output::HTML::TicketOverviewPreview' => 1,
            'Kernel::Output::HTML::TicketOverviewSmall' => 1,
            'Kernel::System::Auth::Sync::LDAP' => 1,
            'Kernel::System::AuthSession::IPC' => 1,
            'Kernel::System::Cache::File' => 1,
            'Kernel::System::Config' => 1,
            'Kernel::System::Email::SMTPS' => 1,
            'Kernel::System::HTMLUtils' => 1,
            'Kernel::System::NotificationEvent' => 1,
            'Kernel::System::PostMaster::Filter::FollowUpArticleTypeCheck' => 1,
            'Kernel::System::SLA::PreferencesDB' => 1,
            'Kernel::System::Service::PreferencesDB' => 1,
            'Kernel::System::Stats::Dynamic::TicketAccountedTime' => 1,
            'Kernel::System::Stats::Dynamic::TicketList' => 1,
            'Kernel::System::Stats::Dynamic::TicketSolutionResponseTime' => 1,
            'Kernel::System::Stats::Static::StateAction' => 1,
            'Kernel::System::StdResponse' => 1,
            'Kernel::System::TemplateGenerator' => 1,
            'Kernel::System::Ticket::Event::NotificationEvent' => 1,
            'Kernel::System::Ticket::Event::TicketAcceleratorUpdate' => 1,
            'Kernel::System::Ticket::Permission::WatcherCheck' => 1,
            'Kernel::System::WebUserAgent' => 1
        },
        'cpan' => {
            'Mail::POP3Client' => 1,
            'Net::SMTP::SSL' => 1,
            'XML::FeedPP' => 1,
            'XML::TreePP' => 1
        }
    },
    '2.4.3' => {
        'core' => {
            'Kernel::Language::cz' => 1,
            'Kernel::Language::en_CA' => 1,
            'Kernel::Language::en_GB' => 1,
            'Kernel::Language::lv' => 1,
            'Kernel::Language::zh_TW' => 1,
            'Kernel::Modules::AdminNotificationEvent' => 1,
            'Kernel::Modules::AgentCalendarSmall' => 1,
            'Kernel::Modules::AgentCustomerSearch' => 1,
            'Kernel::Modules::AgentDashboard' => 1,
            'Kernel::Modules::AgentLookup' => 1,
            'Kernel::Modules::AgentTicketLockedView' => 1,
            'Kernel::Modules::AgentTicketMailbox' => 1,
            'Kernel::Modules::AgentTicketResponsibleView' => 1,
            'Kernel::Modules::AgentTicketWatchView' => 1,
            'Kernel::Modules::CustomerCalendarSmall' => 1,
            'Kernel::Modules::PictureUpload' => 1,
            'Kernel::Modules::PublicDefault' => 1,
            'Kernel::Output::HTML::DashboardCalendar' => 1,
            'Kernel::Output::HTML::DashboardImage' => 1,
            'Kernel::Output::HTML::DashboardProductNotify' => 1,
            'Kernel::Output::HTML::DashboardRSS' => 1,
            'Kernel::Output::HTML::DashboardTicketGeneric' => 1,
            'Kernel::Output::HTML::DashboardTicketStatsGeneric' => 1,
            'Kernel::Output::HTML::DashboardUserOnline' => 1,
            'Kernel::Output::HTML::NavBarLockedTickets' => 1,
            'Kernel::Output::HTML::NavBarTicketSearchFulltext' => 1,
            'Kernel::Output::HTML::NavBarTicketSearchProfile' => 1,
            'Kernel::Output::HTML::NavBarTicketWatcher' => 1,
            'Kernel::Output::HTML::NotificationAgentTicket' => 1,
            'Kernel::Output::HTML::NotificationAgentTicketSeen' => 1,
            'Kernel::Output::HTML::OutputFilterTextAutoLink' => 1,
            'Kernel::Output::HTML::PreferencesOutOfOffice' => 1,
            'Kernel::Output::HTML::PreferencesTicketWatcher' => 1,
            'Kernel::Output::HTML::SLAPreferencesGeneric' => 1,
            'Kernel::Output::HTML::ServicePreferencesGeneric' => 1,
            'Kernel::Output::HTML::TicketOverviewMedium' => 1,
            'Kernel::Output::HTML::TicketOverviewPreview' => 1,
            'Kernel::Output::HTML::TicketOverviewSmall' => 1,
            'Kernel::System::Auth::Sync::LDAP' => 1,
            'Kernel::System::AuthSession::IPC' => 1,
            'Kernel::System::Cache::File' => 1,
            'Kernel::System::Config' => 1,
            'Kernel::System::Email::SMTPS' => 1,
            'Kernel::System::HTMLUtils' => 1,
            'Kernel::System::NotificationEvent' => 1,
            'Kernel::System::PostMaster::Filter::FollowUpArticleTypeCheck' => 1,
            'Kernel::System::SLA::PreferencesDB' => 1,
            'Kernel::System::Service::PreferencesDB' => 1,
            'Kernel::System::Stats::Dynamic::TicketAccountedTime' => 1,
            'Kernel::System::Stats::Dynamic::TicketList' => 1,
            'Kernel::System::Stats::Dynamic::TicketSolutionResponseTime' => 1,
            'Kernel::System::Stats::Static::StateAction' => 1,
            'Kernel::System::StdResponse' => 1,
            'Kernel::System::TemplateGenerator' => 1,
            'Kernel::System::Ticket::Event::NotificationEvent' => 1,
            'Kernel::System::Ticket::Event::TicketAcceleratorUpdate' => 1,
            'Kernel::System::Ticket::Permission::WatcherCheck' => 1,
            'Kernel::System::WebUserAgent' => 1
        },
        'cpan' => {
            'Mail::POP3Client' => 1,
            'Net::SMTP::SSL' => 1,
            'XML::FeedPP' => 1,
            'XML::TreePP' => 1
        }
    },
    '2.4.4' => {
        'core' => {
            'Kernel::Language::cz' => 1,
            'Kernel::Language::en_CA' => 1,
            'Kernel::Language::en_GB' => 1,
            'Kernel::Language::lv' => 1,
            'Kernel::Language::zh_TW' => 1,
            'Kernel::Modules::AdminNotificationEvent' => 1,
            'Kernel::Modules::AgentCalendarSmall' => 1,
            'Kernel::Modules::AgentCustomerSearch' => 1,
            'Kernel::Modules::AgentDashboard' => 1,
            'Kernel::Modules::AgentLookup' => 1,
            'Kernel::Modules::AgentTicketLockedView' => 1,
            'Kernel::Modules::AgentTicketMailbox' => 1,
            'Kernel::Modules::AgentTicketResponsibleView' => 1,
            'Kernel::Modules::AgentTicketWatchView' => 1,
            'Kernel::Modules::CustomerCalendarSmall' => 1,
            'Kernel::Modules::PictureUpload' => 1,
            'Kernel::Modules::PublicDefault' => 1,
            'Kernel::Output::HTML::DashboardCalendar' => 1,
            'Kernel::Output::HTML::DashboardImage' => 1,
            'Kernel::Output::HTML::DashboardProductNotify' => 1,
            'Kernel::Output::HTML::DashboardRSS' => 1,
            'Kernel::Output::HTML::DashboardTicketGeneric' => 1,
            'Kernel::Output::HTML::DashboardTicketStatsGeneric' => 1,
            'Kernel::Output::HTML::DashboardUserOnline' => 1,
            'Kernel::Output::HTML::NavBarLockedTickets' => 1,
            'Kernel::Output::HTML::NavBarTicketSearchFulltext' => 1,
            'Kernel::Output::HTML::NavBarTicketSearchProfile' => 1,
            'Kernel::Output::HTML::NavBarTicketWatcher' => 1,
            'Kernel::Output::HTML::NotificationAgentTicket' => 1,
            'Kernel::Output::HTML::NotificationAgentTicketSeen' => 1,
            'Kernel::Output::HTML::OutputFilterTextAutoLink' => 1,
            'Kernel::Output::HTML::PreferencesOutOfOffice' => 1,
            'Kernel::Output::HTML::PreferencesTicketWatcher' => 1,
            'Kernel::Output::HTML::SLAPreferencesGeneric' => 1,
            'Kernel::Output::HTML::ServicePreferencesGeneric' => 1,
            'Kernel::Output::HTML::TicketOverviewMedium' => 1,
            'Kernel::Output::HTML::TicketOverviewPreview' => 1,
            'Kernel::Output::HTML::TicketOverviewSmall' => 1,
            'Kernel::System::Auth::Sync::LDAP' => 1,
            'Kernel::System::AuthSession::IPC' => 1,
            'Kernel::System::Cache::File' => 1,
            'Kernel::System::Config' => 1,
            'Kernel::System::Email::SMTPS' => 1,
            'Kernel::System::HTMLUtils' => 1,
            'Kernel::System::NotificationEvent' => 1,
            'Kernel::System::PostMaster::Filter::FollowUpArticleTypeCheck' => 1,
            'Kernel::System::SLA::PreferencesDB' => 1,
            'Kernel::System::Service::PreferencesDB' => 1,
            'Kernel::System::Stats::Dynamic::TicketAccountedTime' => 1,
            'Kernel::System::Stats::Dynamic::TicketList' => 1,
            'Kernel::System::Stats::Dynamic::TicketSolutionResponseTime' => 1,
            'Kernel::System::Stats::Static::StateAction' => 1,
            'Kernel::System::StdResponse' => 1,
            'Kernel::System::TemplateGenerator' => 1,
            'Kernel::System::Ticket::Event::NotificationEvent' => 1,
            'Kernel::System::Ticket::Event::TicketAcceleratorUpdate' => 1,
            'Kernel::System::Ticket::Permission::WatcherCheck' => 1,
            'Kernel::System::WebUserAgent' => 1
        },
        'cpan' => {
            'Apache2::Reload' => 1,
            'Apache::Reload' => 1,
            'Mail::POP3Client' => 1,
            'Net::SMTP::SSL' => 1,
            'XML::FeedPP' => 1,
            'XML::TreePP' => 1
        }
    },
    '2.4.5' => {
        'core' => {
            'Kernel::Language::cz' => 1,
            'Kernel::Language::en_CA' => 1,
            'Kernel::Language::en_GB' => 1,
            'Kernel::Language::lv' => 1,
            'Kernel::Language::zh_TW' => 1,
            'Kernel::Modules::AdminNotificationEvent' => 1,
            'Kernel::Modules::AgentCalendarSmall' => 1,
            'Kernel::Modules::AgentCustomerSearch' => 1,
            'Kernel::Modules::AgentDashboard' => 1,
            'Kernel::Modules::AgentLookup' => 1,
            'Kernel::Modules::AgentTicketLockedView' => 1,
            'Kernel::Modules::AgentTicketMailbox' => 1,
            'Kernel::Modules::AgentTicketResponsibleView' => 1,
            'Kernel::Modules::AgentTicketWatchView' => 1,
            'Kernel::Modules::CustomerCalendarSmall' => 1,
            'Kernel::Modules::PictureUpload' => 1,
            'Kernel::Modules::PublicDefault' => 1,
            'Kernel::Modules::SpellingInline' => 1,
            'Kernel::Output::HTML::DashboardCalendar' => 1,
            'Kernel::Output::HTML::DashboardImage' => 1,
            'Kernel::Output::HTML::DashboardProductNotify' => 1,
            'Kernel::Output::HTML::DashboardRSS' => 1,
            'Kernel::Output::HTML::DashboardTicketGeneric' => 1,
            'Kernel::Output::HTML::DashboardTicketStatsGeneric' => 1,
            'Kernel::Output::HTML::DashboardUserOnline' => 1,
            'Kernel::Output::HTML::NavBarLockedTickets' => 1,
            'Kernel::Output::HTML::NavBarTicketSearchFulltext' => 1,
            'Kernel::Output::HTML::NavBarTicketSearchProfile' => 1,
            'Kernel::Output::HTML::NavBarTicketWatcher' => 1,
            'Kernel::Output::HTML::NotificationAgentTicket' => 1,
            'Kernel::Output::HTML::NotificationAgentTicketSeen' => 1,
            'Kernel::Output::HTML::OutputFilterTextAutoLink' => 1,
            'Kernel::Output::HTML::PreferencesOutOfOffice' => 1,
            'Kernel::Output::HTML::PreferencesTicketWatcher' => 1,
            'Kernel::Output::HTML::SLAPreferencesGeneric' => 1,
            'Kernel::Output::HTML::ServicePreferencesGeneric' => 1,
            'Kernel::Output::HTML::TicketOverviewMedium' => 1,
            'Kernel::Output::HTML::TicketOverviewPreview' => 1,
            'Kernel::Output::HTML::TicketOverviewSmall' => 1,
            'Kernel::System::Auth::Sync::LDAP' => 1,
            'Kernel::System::AuthSession::IPC' => 1,
            'Kernel::System::Cache::File' => 1,
            'Kernel::System::Config' => 1,
            'Kernel::System::Email::SMTPS' => 1,
            'Kernel::System::HTMLUtils' => 1,
            'Kernel::System::NotificationEvent' => 1,
            'Kernel::System::PostMaster::Filter::FollowUpArticleTypeCheck' => 1,
            'Kernel::System::SLA::PreferencesDB' => 1,
            'Kernel::System::Service::PreferencesDB' => 1,
            'Kernel::System::Stats::Dynamic::TicketAccountedTime' => 1,
            'Kernel::System::Stats::Dynamic::TicketList' => 1,
            'Kernel::System::Stats::Dynamic::TicketSolutionResponseTime' => 1,
            'Kernel::System::Stats::Static::StateAction' => 1,
            'Kernel::System::StdResponse' => 1,
            'Kernel::System::TemplateGenerator' => 1,
            'Kernel::System::Ticket::Event::NotificationEvent' => 1,
            'Kernel::System::Ticket::Event::TicketAcceleratorUpdate' => 1,
            'Kernel::System::Ticket::Permission::WatcherCheck' => 1,
            'Kernel::System::WebUserAgent' => 1
        },
        'cpan' => {
            'Apache2::Reload' => 1,
            'Apache::Reload' => 1,
            'Mail::POP3Client' => 1,
            'Net::SMTP::SSL' => 1,
            'XML::FeedPP' => 1,
            'XML::TreePP' => 1
        },
    },
    '2.4.6' => {
        'core' => {
            'Kernel::Language::cz' => 1,
            'Kernel::Language::en_CA' => 1,
            'Kernel::Language::en_GB' => 1,
            'Kernel::Language::lv' => 1,
            'Kernel::Language::uk' => 1,
            'Kernel::Language::zh_TW' => 1,
            'Kernel::Modules::AdminNotificationEvent' => 1,
            'Kernel::Modules::AgentCalendarSmall' => 1,
            'Kernel::Modules::AgentCustomerSearch' => 1,
            'Kernel::Modules::AgentDashboard' => 1,
            'Kernel::Modules::AgentLookup' => 1,
            'Kernel::Modules::AgentTicketLockedView' => 1,
            'Kernel::Modules::AgentTicketMailbox' => 1,
            'Kernel::Modules::AgentTicketResponsibleView' => 1,
            'Kernel::Modules::AgentTicketWatchView' => 1,
            'Kernel::Modules::CustomerCalendarSmall' => 1,
            'Kernel::Modules::PictureUpload' => 1,
            'Kernel::Modules::PublicDefault' => 1,
            'Kernel::Modules::SpellingInline' => 1,
            'Kernel::Output::HTML::DashboardCalendar' => 1,
            'Kernel::Output::HTML::DashboardImage' => 1,
            'Kernel::Output::HTML::DashboardProductNotify' => 1,
            'Kernel::Output::HTML::DashboardRSS' => 1,
            'Kernel::Output::HTML::DashboardTicketGeneric' => 1,
            'Kernel::Output::HTML::DashboardTicketStatsGeneric' => 1,
            'Kernel::Output::HTML::DashboardUserOnline' => 1,
            'Kernel::Output::HTML::NavBarLockedTickets' => 1,
            'Kernel::Output::HTML::NavBarTicketSearchFulltext' => 1,
            'Kernel::Output::HTML::NavBarTicketSearchProfile' => 1,
            'Kernel::Output::HTML::NavBarTicketWatcher' => 1,
            'Kernel::Output::HTML::NotificationAgentTicket' => 1,
            'Kernel::Output::HTML::NotificationAgentTicketSeen' => 1,
            'Kernel::Output::HTML::OutputFilterTextAutoLink' => 1,
            'Kernel::Output::HTML::PreferencesOutOfOffice' => 1,
            'Kernel::Output::HTML::PreferencesTicketWatcher' => 1,
            'Kernel::Output::HTML::SLAPreferencesGeneric' => 1,
            'Kernel::Output::HTML::ServicePreferencesGeneric' => 1,
            'Kernel::Output::HTML::TicketOverviewMedium' => 1,
            'Kernel::Output::HTML::TicketOverviewPreview' => 1,
            'Kernel::Output::HTML::TicketOverviewSmall' => 1,
            'Kernel::System::Auth::Sync::LDAP' => 1,
            'Kernel::System::AuthSession::IPC' => 1,
            'Kernel::System::Cache::File' => 1,
            'Kernel::System::Config' => 1,
            'Kernel::System::Email::SMTPS' => 1,
            'Kernel::System::HTMLUtils' => 1,
            'Kernel::System::NotificationEvent' => 1,
            'Kernel::System::PostMaster::Filter::FollowUpArticleTypeCheck' => 1,
            'Kernel::System::SLA::PreferencesDB' => 1,
            'Kernel::System::Service::PreferencesDB' => 1,
            'Kernel::System::Stats::Dynamic::TicketAccountedTime' => 1,
            'Kernel::System::Stats::Dynamic::TicketList' => 1,
            'Kernel::System::Stats::Dynamic::TicketSolutionResponseTime' => 1,
            'Kernel::System::Stats::Static::StateAction' => 1,
            'Kernel::System::StdResponse' => 1,
            'Kernel::System::TemplateGenerator' => 1,
            'Kernel::System::Ticket::Event::NotificationEvent' => 1,
            'Kernel::System::Ticket::Event::TicketAcceleratorUpdate' => 1,
            'Kernel::System::Ticket::Permission::WatcherCheck' => 1,
            'Kernel::System::Web::InterfaceInstaller' => 1,
            'Kernel::System::WebUserAgent' => 1
        },
        'cpan' => {
            'Apache2::Reload' => 1,
            'Apache::Reload' => 1,
            'Mail::POP3Client' => 1,
            'Net::SMTP::SSL' => 1,
            'XML::FeedPP' => 1,
            'XML::TreePP' => 1
        }
    },
    '2.4.7' => {
        'core' => {
            'Kernel::Language::cz' => 1,
            'Kernel::Language::en_CA' => 1,
            'Kernel::Language::en_GB' => 1,
            'Kernel::Language::lv' => 1,
            'Kernel::Language::uk' => 1,
            'Kernel::Language::zh_TW' => 1,
            'Kernel::Modules::AdminNotificationEvent' => 1,
            'Kernel::Modules::AgentCalendarSmall' => 1,
            'Kernel::Modules::AgentCustomerSearch' => 1,
            'Kernel::Modules::AgentDashboard' => 1,
            'Kernel::Modules::AgentLookup' => 1,
            'Kernel::Modules::AgentTicketLockedView' => 1,
            'Kernel::Modules::AgentTicketMailbox' => 1,
            'Kernel::Modules::AgentTicketResponsibleView' => 1,
            'Kernel::Modules::AgentTicketWatchView' => 1,
            'Kernel::Modules::CustomerCalendarSmall' => 1,
            'Kernel::Modules::PictureUpload' => 1,
            'Kernel::Modules::PublicDefault' => 1,
            'Kernel::Modules::SpellingInline' => 1,
            'Kernel::Output::HTML::DashboardCalendar' => 1,
            'Kernel::Output::HTML::DashboardImage' => 1,
            'Kernel::Output::HTML::DashboardProductNotify' => 1,
            'Kernel::Output::HTML::DashboardRSS' => 1,
            'Kernel::Output::HTML::DashboardTicketGeneric' => 1,
            'Kernel::Output::HTML::DashboardTicketStatsGeneric' => 1,
            'Kernel::Output::HTML::DashboardUserOnline' => 1,
            'Kernel::Output::HTML::NavBarLockedTickets' => 1,
            'Kernel::Output::HTML::NavBarTicketSearchFulltext' => 1,
            'Kernel::Output::HTML::NavBarTicketSearchProfile' => 1,
            'Kernel::Output::HTML::NavBarTicketWatcher' => 1,
            'Kernel::Output::HTML::NotificationAgentTicket' => 1,
            'Kernel::Output::HTML::NotificationAgentTicketSeen' => 1,
            'Kernel::Output::HTML::OutputFilterTextAutoLink' => 1,
            'Kernel::Output::HTML::PreferencesOutOfOffice' => 1,
            'Kernel::Output::HTML::PreferencesTicketWatcher' => 1,
            'Kernel::Output::HTML::SLAPreferencesGeneric' => 1,
            'Kernel::Output::HTML::ServicePreferencesGeneric' => 1,
            'Kernel::Output::HTML::TicketOverviewMedium' => 1,
            'Kernel::Output::HTML::TicketOverviewPreview' => 1,
            'Kernel::Output::HTML::TicketOverviewSmall' => 1,
            'Kernel::System::Auth::Sync::LDAP' => 1,
            'Kernel::System::AuthSession::IPC' => 1,
            'Kernel::System::Cache::File' => 1,
            'Kernel::System::Config' => 1,
            'Kernel::System::Email::SMTPS' => 1,
            'Kernel::System::HTMLUtils' => 1,
            'Kernel::System::NotificationEvent' => 1,
            'Kernel::System::PostMaster::Filter::FollowUpArticleTypeCheck' => 1,
            'Kernel::System::SLA::PreferencesDB' => 1,
            'Kernel::System::Service::PreferencesDB' => 1,
            'Kernel::System::Stats::Dynamic::TicketAccountedTime' => 1,
            'Kernel::System::Stats::Dynamic::TicketList' => 1,
            'Kernel::System::Stats::Dynamic::TicketSolutionResponseTime' => 1,
            'Kernel::System::Stats::Static::StateAction' => 1,
            'Kernel::System::StdResponse' => 1,
            'Kernel::System::TemplateGenerator' => 1,
            'Kernel::System::Ticket::Event::NotificationEvent' => 1,
            'Kernel::System::Ticket::Event::TicketAcceleratorUpdate' => 1,
            'Kernel::System::Ticket::Permission::WatcherCheck' => 1,
            'Kernel::System::Web::InterfaceInstaller' => 1,
            'Kernel::System::WebUserAgent' => 1
        },
        'cpan' => {
            'Apache2::Reload' => 1,
            'Apache::Reload' => 1,
            'Mail::POP3Client' => 1,
            'Net::SMTP::SSL' => 1,
            'XML::FeedPP' => 1,
            'XML::TreePP' => 1
        }
    },
    '2.4.8' => {
        'core' => {
            'Kernel::Language::cz' => 1,
            'Kernel::Language::en_CA' => 1,
            'Kernel::Language::en_GB' => 1,
            'Kernel::Language::lv' => 1,
            'Kernel::Language::uk' => 1,
            'Kernel::Language::zh_TW' => 1,
            'Kernel::Modules::AdminNotificationEvent' => 1,
            'Kernel::Modules::AgentCalendarSmall' => 1,
            'Kernel::Modules::AgentCustomerSearch' => 1,
            'Kernel::Modules::AgentDashboard' => 1,
            'Kernel::Modules::AgentLookup' => 1,
            'Kernel::Modules::AgentTicketLockedView' => 1,
            'Kernel::Modules::AgentTicketMailbox' => 1,
            'Kernel::Modules::AgentTicketResponsibleView' => 1,
            'Kernel::Modules::AgentTicketWatchView' => 1,
            'Kernel::Modules::CustomerCalendarSmall' => 1,
            'Kernel::Modules::PictureUpload' => 1,
            'Kernel::Modules::PublicDefault' => 1,
            'Kernel::Modules::SpellingInline' => 1,
            'Kernel::Output::HTML::DashboardCalendar' => 1,
            'Kernel::Output::HTML::DashboardImage' => 1,
            'Kernel::Output::HTML::DashboardProductNotify' => 1,
            'Kernel::Output::HTML::DashboardRSS' => 1,
            'Kernel::Output::HTML::DashboardTicketGeneric' => 1,
            'Kernel::Output::HTML::DashboardTicketStatsGeneric' => 1,
            'Kernel::Output::HTML::DashboardUserOnline' => 1,
            'Kernel::Output::HTML::NavBarLockedTickets' => 1,
            'Kernel::Output::HTML::NavBarTicketSearchFulltext' => 1,
            'Kernel::Output::HTML::NavBarTicketSearchProfile' => 1,
            'Kernel::Output::HTML::NavBarTicketWatcher' => 1,
            'Kernel::Output::HTML::NotificationAgentTicket' => 1,
            'Kernel::Output::HTML::NotificationAgentTicketSeen' => 1,
            'Kernel::Output::HTML::OutputFilterTextAutoLink' => 1,
            'Kernel::Output::HTML::PreferencesOutOfOffice' => 1,
            'Kernel::Output::HTML::PreferencesTicketWatcher' => 1,
            'Kernel::Output::HTML::SLAPreferencesGeneric' => 1,
            'Kernel::Output::HTML::ServicePreferencesGeneric' => 1,
            'Kernel::Output::HTML::TicketOverviewMedium' => 1,
            'Kernel::Output::HTML::TicketOverviewPreview' => 1,
            'Kernel::Output::HTML::TicketOverviewSmall' => 1,
            'Kernel::System::Auth::Sync::LDAP' => 1,
            'Kernel::System::AuthSession::IPC' => 1,
            'Kernel::System::Cache::File' => 1,
            'Kernel::System::Config' => 1,
            'Kernel::System::Email::SMTPS' => 1,
            'Kernel::System::HTMLUtils' => 1,
            'Kernel::System::NotificationEvent' => 1,
            'Kernel::System::PostMaster::Filter::FollowUpArticleTypeCheck' => 1,
            'Kernel::System::SLA::PreferencesDB' => 1,
            'Kernel::System::Service::PreferencesDB' => 1,
            'Kernel::System::Stats::Dynamic::TicketAccountedTime' => 1,
            'Kernel::System::Stats::Dynamic::TicketList' => 1,
            'Kernel::System::Stats::Dynamic::TicketSolutionResponseTime' => 1,
            'Kernel::System::Stats::Static::StateAction' => 1,
            'Kernel::System::StdResponse' => 1,
            'Kernel::System::TemplateGenerator' => 1,
            'Kernel::System::Ticket::Event::NotificationEvent' => 1,
            'Kernel::System::Ticket::Event::TicketAcceleratorUpdate' => 1,
            'Kernel::System::Ticket::Permission::WatcherCheck' => 1,
            'Kernel::System::Web::InterfaceInstaller' => 1,
            'Kernel::System::WebUserAgent' => 1
        },
        'cpan' => {
            'Apache2::Reload' => 1,
            'Apache::Reload' => 1,
            'Mail::POP3Client' => 1,
            'Net::SMTP::SSL' => 1,
            'XML::FeedPP' => 1,
            'XML::TreePP' => 1
        }
    },
    '2.4.9' => {
        'core' => {
            'Kernel::Language::cz' => 1,
            'Kernel::Language::en_CA' => 1,
            'Kernel::Language::en_GB' => 1,
            'Kernel::Language::lv' => 1,
            'Kernel::Language::uk' => 1,
            'Kernel::Language::zh_TW' => 1,
            'Kernel::Modules::AdminNotificationEvent' => 1,
            'Kernel::Modules::AgentCalendarSmall' => 1,
            'Kernel::Modules::AgentCustomerSearch' => 1,
            'Kernel::Modules::AgentDashboard' => 1,
            'Kernel::Modules::AgentLookup' => 1,
            'Kernel::Modules::AgentTicketLockedView' => 1,
            'Kernel::Modules::AgentTicketMailbox' => 1,
            'Kernel::Modules::AgentTicketResponsibleView' => 1,
            'Kernel::Modules::AgentTicketWatchView' => 1,
            'Kernel::Modules::CustomerCalendarSmall' => 1,
            'Kernel::Modules::PictureUpload' => 1,
            'Kernel::Modules::PublicDefault' => 1,
            'Kernel::Modules::SpellingInline' => 1,
            'Kernel::Output::HTML::DashboardCalendar' => 1,
            'Kernel::Output::HTML::DashboardImage' => 1,
            'Kernel::Output::HTML::DashboardProductNotify' => 1,
            'Kernel::Output::HTML::DashboardRSS' => 1,
            'Kernel::Output::HTML::DashboardTicketGeneric' => 1,
            'Kernel::Output::HTML::DashboardTicketStatsGeneric' => 1,
            'Kernel::Output::HTML::DashboardUserOnline' => 1,
            'Kernel::Output::HTML::NavBarLockedTickets' => 1,
            'Kernel::Output::HTML::NavBarTicketSearchFulltext' => 1,
            'Kernel::Output::HTML::NavBarTicketSearchProfile' => 1,
            'Kernel::Output::HTML::NavBarTicketWatcher' => 1,
            'Kernel::Output::HTML::NotificationAgentTicket' => 1,
            'Kernel::Output::HTML::NotificationAgentTicketSeen' => 1,
            'Kernel::Output::HTML::OutputFilterTextAutoLink' => 1,
            'Kernel::Output::HTML::PreferencesOutOfOffice' => 1,
            'Kernel::Output::HTML::PreferencesTicketWatcher' => 1,
            'Kernel::Output::HTML::SLAPreferencesGeneric' => 1,
            'Kernel::Output::HTML::ServicePreferencesGeneric' => 1,
            'Kernel::Output::HTML::TicketOverviewMedium' => 1,
            'Kernel::Output::HTML::TicketOverviewPreview' => 1,
            'Kernel::Output::HTML::TicketOverviewSmall' => 1,
            'Kernel::System::Auth::Sync::LDAP' => 1,
            'Kernel::System::AuthSession::IPC' => 1,
            'Kernel::System::Cache::File' => 1,
            'Kernel::System::Config' => 1,
            'Kernel::System::Email::SMTPS' => 1,
            'Kernel::System::HTMLUtils' => 1,
            'Kernel::System::NotificationEvent' => 1,
            'Kernel::System::PostMaster::Filter::FollowUpArticleTypeCheck' => 1,
            'Kernel::System::SLA::PreferencesDB' => 1,
            'Kernel::System::Service::PreferencesDB' => 1,
            'Kernel::System::Stats::Dynamic::TicketAccountedTime' => 1,
            'Kernel::System::Stats::Dynamic::TicketList' => 1,
            'Kernel::System::Stats::Dynamic::TicketSolutionResponseTime' => 1,
            'Kernel::System::Stats::Static::StateAction' => 1,
            'Kernel::System::StdResponse' => 1,
            'Kernel::System::TemplateGenerator' => 1,
            'Kernel::System::Ticket::Event::NotificationEvent' => 1,
            'Kernel::System::Ticket::Event::TicketAcceleratorUpdate' => 1,
            'Kernel::System::Ticket::Permission::WatcherCheck' => 1,
            'Kernel::System::Web::InterfaceInstaller' => 1,
            'Kernel::System::WebUserAgent' => 1
        },
        'cpan' => {
            'Apache2::Reload' => 1,
            'Apache::Reload' => 1,
            'Mail::POP3Client' => 1,
            'Net::SMTP::SSL' => 1,
            'XML::FeedPP' => 1,
            'XML::TreePP' => 1
        }
    },
    '3.0.1' => {
        'core' => {
            'Kernel::Language::cz' => 1,
            'Kernel::Language::en_CA' => 1,
            'Kernel::Language::en_GB' => 1,
            'Kernel::Language::es_MX' => 1,
            'Kernel::Language::lv' => 1,
            'Kernel::Language::sr_Cyrl' => 1,
            'Kernel::Language::sr_Latn' => 1,
            'Kernel::Language::uk' => 1,
            'Kernel::Language::zh_TW' => 1,
            'Kernel::Modules::AdminNotificationEvent' => 1,
            'Kernel::Modules::AgentCustomerSearch' => 1,
            'Kernel::Modules::AgentDashboard' => 1,
            'Kernel::Modules::AgentHTMLReference' => 1,
            'Kernel::Modules::AgentSearch' => 1,
            'Kernel::Modules::AgentTicketActionCommon' => 1,
            'Kernel::Modules::AgentTicketLockedView' => 1,
            'Kernel::Modules::AgentTicketMailbox' => 1,
            'Kernel::Modules::AgentTicketResponsibleView' => 1,
            'Kernel::Modules::AgentTicketWatchView' => 1,
            'Kernel::Modules::PictureUpload' => 1,
            'Kernel::Modules::PublicDefault' => 1,
            'Kernel::Modules::SpellingInline' => 1,
            'Kernel::Output::HTML::DashboardCalendar' => 1,
            'Kernel::Output::HTML::DashboardIFrame' => 1,
            'Kernel::Output::HTML::DashboardImage' => 1,
            'Kernel::Output::HTML::DashboardMOTD' => 1,
            'Kernel::Output::HTML::DashboardProductNotify' => 1,
            'Kernel::Output::HTML::DashboardRSS' => 1,
            'Kernel::Output::HTML::DashboardTicketGeneric' => 1,
            'Kernel::Output::HTML::DashboardTicketStatsGeneric' => 1,
            'Kernel::Output::HTML::DashboardUserOnline' => 1,
            'Kernel::Output::HTML::LayoutDatepicker' => 1,
            'Kernel::Output::HTML::LayoutLoader' => 1,
            'Kernel::Output::HTML::LayoutPopup' => 1,
            'Kernel::Output::HTML::OutputFilterTextAutoLink' => 1,
            'Kernel::Output::HTML::PreferencesOutOfOffice' => 1,
            'Kernel::Output::HTML::PreferencesSkin' => 1,
            'Kernel::Output::HTML::PreferencesTicketWatcher' => 1,
            'Kernel::Output::HTML::SLAPreferencesGeneric' => 1,
            'Kernel::Output::HTML::ServicePreferencesGeneric' => 1,
            'Kernel::Output::HTML::TicketMenuMove' => 1,
            'Kernel::Output::HTML::TicketOverviewMedium' => 1,
            'Kernel::Output::HTML::TicketOverviewPreview' => 1,
            'Kernel::Output::HTML::TicketOverviewSmall' => 1,
            'Kernel::Output::HTML::ToolBarLink' => 1,
            'Kernel::Output::HTML::ToolBarTicketLocked' => 1,
            'Kernel::Output::HTML::ToolBarTicketResponsible' => 1,
            'Kernel::Output::HTML::ToolBarTicketSearchFulltext' => 1,
            'Kernel::Output::HTML::ToolBarTicketSearchProfile' => 1,
            'Kernel::Output::HTML::ToolBarTicketWatcher' => 1,
            'Kernel::System::Auth::Sync::LDAP' => 1,
            'Kernel::System::Cache::FileRaw' => 1,
            'Kernel::System::Cache::FileStorable' => 1,
            'Kernel::System::CacheInternal' => 1,
            'Kernel::System::Email::SMTPS' => 1,
            'Kernel::System::Email::SMTPTLS' => 1,
            'Kernel::System::EventHandler' => 1,
            'Kernel::System::HTMLUtils' => 1,
            'Kernel::System::JSON' => 1,
            'Kernel::System::Loader' => 1,
            'Kernel::System::NotificationEvent' => 1,
            'Kernel::System::PostMaster::Filter::FollowUpArticleTypeCheck' => 1,
            'Kernel::System::SLA::PreferencesDB' => 1,
            'Kernel::System::Service::PreferencesDB' => 1,
            'Kernel::System::StandardResponse' => 1,
            'Kernel::System::Stats::Dynamic::TicketAccountedTime' => 1,
            'Kernel::System::Stats::Dynamic::TicketList' => 1,
            'Kernel::System::Stats::Dynamic::TicketSolutionResponseTime' => 1,
            'Kernel::System::Stats::Static::StateAction' => 1,
            'Kernel::System::SysConfig' => 1,
            'Kernel::System::SysConfig::PriorityValidate' => 1,
            'Kernel::System::SysConfig::QueueValidate' => 1,
            'Kernel::System::SysConfig::StateValidate' => 1,
            'Kernel::System::TemplateGenerator' => 1,
            'Kernel::System::Ticket::Event::ArchiveRestore' => 1,
            'Kernel::System::Ticket::Event::NotificationEvent' => 1,
            'Kernel::System::Ticket::Event::TicketAcceleratorUpdate' => 1,
            'Kernel::System::Ticket::Event::TicketNewMessageUpdate' => 1,
            'Kernel::System::Ticket::Event::TicketPendingTimeReset' => 1,
            'Kernel::System::Ticket::Permission::WatcherCheck' => 1,
            'Kernel::System::VirtualFS' => 1,
            'Kernel::System::VirtualFS::DB' => 1,
            'Kernel::System::VirtualFS::FS' => 1,
            'Kernel::System::Web::InterfaceInstaller' => 1,
            'Kernel::System::WebUserAgent' => 1
        },
        'cpan' => {
            'Apache2::Reload' => 1,
            'Apache::Reload' => 1,
            'CGI' => 1,
            'CGI::Apache' => 1,
            'CGI::Carp' => 1,
            'CGI::Cookie' => 1,
            'CGI::Fast' => 1,
            'CGI::Pretty' => 1,
            'CGI::Push' => 1,
            'CGI::Switch' => 1,
            'CGI::Util' => 1,
            'CSS::Minifier' => 1,
            'Digest::SHA::PurePerl' => 1,
            'JSON' => 1,
            'JSON::PP' => 1,
            'JSON::PP5005' => 1,
            'JSON::PP56' => 1,
            'JSON::PP58' => 1,
            'JSON::PP::Boolean' => 1,
            'JavaScript::Minifier' => 1,
            'Mail::Mailer::smtps' => 1,
            'Mail::POP3Client' => 1,
            'Net::IMAP::Simple::PipeSocket' => 1,
            'Net::SMTP::SSL' => 1,
            'Net::SMTP::TLS' => 1,
            'XML::FeedPP' => 1,
            'XML::TreePP' => 1
        }
    },
    '3.0.2' => {
        'core' => {
            'Kernel::Language::cz' => 1,
            'Kernel::Language::en_CA' => 1,
            'Kernel::Language::en_GB' => 1,
            'Kernel::Language::es_MX' => 1,
            'Kernel::Language::lv' => 1,
            'Kernel::Language::sr_Cyrl' => 1,
            'Kernel::Language::sr_Latn' => 1,
            'Kernel::Language::uk' => 1,
            'Kernel::Language::zh_TW' => 1,
            'Kernel::Modules::AdminNotificationEvent' => 1,
            'Kernel::Modules::AgentCustomerSearch' => 1,
            'Kernel::Modules::AgentDashboard' => 1,
            'Kernel::Modules::AgentHTMLReference' => 1,
            'Kernel::Modules::AgentSearch' => 1,
            'Kernel::Modules::AgentTicketActionCommon' => 1,
            'Kernel::Modules::AgentTicketLockedView' => 1,
            'Kernel::Modules::AgentTicketMailbox' => 1,
            'Kernel::Modules::AgentTicketResponsibleView' => 1,
            'Kernel::Modules::AgentTicketWatchView' => 1,
            'Kernel::Modules::PictureUpload' => 1,
            'Kernel::Modules::PublicDefault' => 1,
            'Kernel::Modules::SpellingInline' => 1,
            'Kernel::Output::HTML::DashboardCalendar' => 1,
            'Kernel::Output::HTML::DashboardIFrame' => 1,
            'Kernel::Output::HTML::DashboardImage' => 1,
            'Kernel::Output::HTML::DashboardMOTD' => 1,
            'Kernel::Output::HTML::DashboardProductNotify' => 1,
            'Kernel::Output::HTML::DashboardRSS' => 1,
            'Kernel::Output::HTML::DashboardTicketGeneric' => 1,
            'Kernel::Output::HTML::DashboardTicketStatsGeneric' => 1,
            'Kernel::Output::HTML::DashboardUserOnline' => 1,
            'Kernel::Output::HTML::LayoutDatepicker' => 1,
            'Kernel::Output::HTML::LayoutLoader' => 1,
            'Kernel::Output::HTML::LayoutPopup' => 1,
            'Kernel::Output::HTML::OutputFilterTextAutoLink' => 1,
            'Kernel::Output::HTML::PreferencesOutOfOffice' => 1,
            'Kernel::Output::HTML::PreferencesSkin' => 1,
            'Kernel::Output::HTML::PreferencesTicketWatcher' => 1,
            'Kernel::Output::HTML::SLAPreferencesGeneric' => 1,
            'Kernel::Output::HTML::ServicePreferencesGeneric' => 1,
            'Kernel::Output::HTML::TicketMenuMove' => 1,
            'Kernel::Output::HTML::TicketOverviewMedium' => 1,
            'Kernel::Output::HTML::TicketOverviewPreview' => 1,
            'Kernel::Output::HTML::TicketOverviewSmall' => 1,
            'Kernel::Output::HTML::ToolBarLink' => 1,
            'Kernel::Output::HTML::ToolBarTicketLocked' => 1,
            'Kernel::Output::HTML::ToolBarTicketResponsible' => 1,
            'Kernel::Output::HTML::ToolBarTicketSearchFulltext' => 1,
            'Kernel::Output::HTML::ToolBarTicketSearchProfile' => 1,
            'Kernel::Output::HTML::ToolBarTicketWatcher' => 1,
            'Kernel::System::Auth::Sync::LDAP' => 1,
            'Kernel::System::Cache::FileRaw' => 1,
            'Kernel::System::Cache::FileStorable' => 1,
            'Kernel::System::CacheInternal' => 1,
            'Kernel::System::Email::SMTPS' => 1,
            'Kernel::System::Email::SMTPTLS' => 1,
            'Kernel::System::EventHandler' => 1,
            'Kernel::System::HTMLUtils' => 1,
            'Kernel::System::JSON' => 1,
            'Kernel::System::Loader' => 1,
            'Kernel::System::NotificationEvent' => 1,
            'Kernel::System::PostMaster::Filter::FollowUpArticleTypeCheck' => 1,
            'Kernel::System::SLA::PreferencesDB' => 1,
            'Kernel::System::Service::PreferencesDB' => 1,
            'Kernel::System::StandardResponse' => 1,
            'Kernel::System::Stats::Dynamic::TicketAccountedTime' => 1,
            'Kernel::System::Stats::Dynamic::TicketList' => 1,
            'Kernel::System::Stats::Dynamic::TicketSolutionResponseTime' => 1,
            'Kernel::System::Stats::Static::StateAction' => 1,
            'Kernel::System::SysConfig' => 1,
            'Kernel::System::SysConfig::PriorityValidate' => 1,
            'Kernel::System::SysConfig::QueueValidate' => 1,
            'Kernel::System::SysConfig::StateValidate' => 1,
            'Kernel::System::TemplateGenerator' => 1,
            'Kernel::System::Ticket::Event::ArchiveRestore' => 1,
            'Kernel::System::Ticket::Event::NotificationEvent' => 1,
            'Kernel::System::Ticket::Event::TicketAcceleratorUpdate' => 1,
            'Kernel::System::Ticket::Event::TicketNewMessageUpdate' => 1,
            'Kernel::System::Ticket::Event::TicketPendingTimeReset' => 1,
            'Kernel::System::Ticket::Permission::WatcherCheck' => 1,
            'Kernel::System::VirtualFS' => 1,
            'Kernel::System::VirtualFS::DB' => 1,
            'Kernel::System::VirtualFS::FS' => 1,
            'Kernel::System::Web::InterfaceInstaller' => 1,
            'Kernel::System::WebUserAgent' => 1
        },
        'cpan' => {
            'Apache2::Reload' => 1,
            'Apache::Reload' => 1,
            'CGI' => 1,
            'CGI::Apache' => 1,
            'CGI::Carp' => 1,
            'CGI::Cookie' => 1,
            'CGI::Fast' => 1,
            'CGI::Pretty' => 1,
            'CGI::Push' => 1,
            'CGI::Switch' => 1,
            'CGI::Util' => 1,
            'CSS::Minifier' => 1,
            'Digest::SHA::PurePerl' => 1,
            'JSON' => 1,
            'JSON::PP' => 1,
            'JSON::PP5005' => 1,
            'JSON::PP56' => 1,
            'JSON::PP58' => 1,
            'JSON::PP::Boolean' => 1,
            'JavaScript::Minifier' => 1,
            'Mail::Mailer::smtps' => 1,
            'Mail::POP3Client' => 1,
            'Net::IMAP::Simple::PipeSocket' => 1,
            'Net::SMTP::SSL' => 1,
            'Net::SMTP::TLS' => 1,
            'XML::FeedPP' => 1,
            'XML::TreePP' => 1
        }
    },
    '3.0.3' => {
        'core' => {
            'Kernel::Language::cz' => 1,
            'Kernel::Language::en_CA' => 1,
            'Kernel::Language::en_GB' => 1,
            'Kernel::Language::es_MX' => 1,
            'Kernel::Language::ja' => 1,
            'Kernel::Language::lv' => 1,
            'Kernel::Language::sr_Cyrl' => 1,
            'Kernel::Language::sr_Latn' => 1,
            'Kernel::Language::uk' => 1,
            'Kernel::Language::zh_TW' => 1,
            'Kernel::Modules::AdminNotificationEvent' => 1,
            'Kernel::Modules::AgentCustomerSearch' => 1,
            'Kernel::Modules::AgentDashboard' => 1,
            'Kernel::Modules::AgentHTMLReference' => 1,
            'Kernel::Modules::AgentSearch' => 1,
            'Kernel::Modules::AgentTicketActionCommon' => 1,
            'Kernel::Modules::AgentTicketLockedView' => 1,
            'Kernel::Modules::AgentTicketMailbox' => 1,
            'Kernel::Modules::AgentTicketResponsibleView' => 1,
            'Kernel::Modules::AgentTicketWatchView' => 1,
            'Kernel::Modules::PictureUpload' => 1,
            'Kernel::Modules::PublicDefault' => 1,
            'Kernel::Modules::SpellingInline' => 1,
            'Kernel::Output::HTML::DashboardCalendar' => 1,
            'Kernel::Output::HTML::DashboardIFrame' => 1,
            'Kernel::Output::HTML::DashboardImage' => 1,
            'Kernel::Output::HTML::DashboardMOTD' => 1,
            'Kernel::Output::HTML::DashboardProductNotify' => 1,
            'Kernel::Output::HTML::DashboardRSS' => 1,
            'Kernel::Output::HTML::DashboardTicketGeneric' => 1,
            'Kernel::Output::HTML::DashboardTicketStatsGeneric' => 1,
            'Kernel::Output::HTML::DashboardUserOnline' => 1,
            'Kernel::Output::HTML::LayoutDatepicker' => 1,
            'Kernel::Output::HTML::LayoutLoader' => 1,
            'Kernel::Output::HTML::LayoutPopup' => 1,
            'Kernel::Output::HTML::OutputFilterTextAutoLink' => 1,
            'Kernel::Output::HTML::PreferencesOutOfOffice' => 1,
            'Kernel::Output::HTML::PreferencesSkin' => 1,
            'Kernel::Output::HTML::PreferencesTicketWatcher' => 1,
            'Kernel::Output::HTML::SLAPreferencesGeneric' => 1,
            'Kernel::Output::HTML::ServicePreferencesGeneric' => 1,
            'Kernel::Output::HTML::TicketMenuMove' => 1,
            'Kernel::Output::HTML::TicketOverviewMedium' => 1,
            'Kernel::Output::HTML::TicketOverviewPreview' => 1,
            'Kernel::Output::HTML::TicketOverviewSmall' => 1,
            'Kernel::Output::HTML::ToolBarLink' => 1,
            'Kernel::Output::HTML::ToolBarTicketLocked' => 1,
            'Kernel::Output::HTML::ToolBarTicketResponsible' => 1,
            'Kernel::Output::HTML::ToolBarTicketSearchFulltext' => 1,
            'Kernel::Output::HTML::ToolBarTicketSearchProfile' => 1,
            'Kernel::Output::HTML::ToolBarTicketWatcher' => 1,
            'Kernel::System::Auth::Sync::LDAP' => 1,
            'Kernel::System::Cache::FileRaw' => 1,
            'Kernel::System::Cache::FileStorable' => 1,
            'Kernel::System::CacheInternal' => 1,
            'Kernel::System::Email::SMTPS' => 1,
            'Kernel::System::Email::SMTPTLS' => 1,
            'Kernel::System::EventHandler' => 1,
            'Kernel::System::HTMLUtils' => 1,
            'Kernel::System::JSON' => 1,
            'Kernel::System::Loader' => 1,
            'Kernel::System::NotificationEvent' => 1,
            'Kernel::System::PostMaster::Filter::FollowUpArticleTypeCheck' => 1,
            'Kernel::System::SLA::PreferencesDB' => 1,
            'Kernel::System::Service::PreferencesDB' => 1,
            'Kernel::System::StandardResponse' => 1,
            'Kernel::System::Stats::Dynamic::TicketAccountedTime' => 1,
            'Kernel::System::Stats::Dynamic::TicketList' => 1,
            'Kernel::System::Stats::Dynamic::TicketSolutionResponseTime' => 1,
            'Kernel::System::Stats::Static::StateAction' => 1,
            'Kernel::System::SysConfig' => 1,
            'Kernel::System::SysConfig::PriorityValidate' => 1,
            'Kernel::System::SysConfig::QueueValidate' => 1,
            'Kernel::System::SysConfig::StateValidate' => 1,
            'Kernel::System::TemplateGenerator' => 1,
            'Kernel::System::Ticket::Event::ArchiveRestore' => 1,
            'Kernel::System::Ticket::Event::NotificationEvent' => 1,
            'Kernel::System::Ticket::Event::TicketAcceleratorUpdate' => 1,
            'Kernel::System::Ticket::Event::TicketNewMessageUpdate' => 1,
            'Kernel::System::Ticket::Event::TicketPendingTimeReset' => 1,
            'Kernel::System::Ticket::Permission::WatcherCheck' => 1,
            'Kernel::System::UnitTest::Selenium' => 1,
            'Kernel::System::VirtualFS' => 1,
            'Kernel::System::VirtualFS::DB' => 1,
            'Kernel::System::VirtualFS::FS' => 1,
            'Kernel::System::Web::InterfaceInstaller' => 1,
            'Kernel::System::WebUserAgent' => 1
        },
        'cpan' => {
            'Apache2::Reload' => 1,
            'Apache::Reload' => 1,
            'CGI' => 1,
            'CGI::Apache' => 1,
            'CGI::Carp' => 1,
            'CGI::Cookie' => 1,
            'CGI::Fast' => 1,
            'CGI::Pretty' => 1,
            'CGI::Push' => 1,
            'CGI::Switch' => 1,
            'CGI::Util' => 1,
            'CSS::Minifier' => 1,
            'Digest::SHA::PurePerl' => 1,
            'JSON' => 1,
            'JSON::PP' => 1,
            'JSON::PP5005' => 1,
            'JSON::PP56' => 1,
            'JSON::PP58' => 1,
            'JSON::PP::Boolean' => 1,
            'JavaScript::Minifier' => 1,
            'Mail::Mailer::smtps' => 1,
            'Mail::POP3Client' => 1,
            'Net::IMAP::Simple::PipeSocket' => 1,
            'Net::SMTP::SSL' => 1,
            'Net::SMTP::TLS' => 1,
            'XML::FeedPP' => 1,
            'XML::TreePP' => 1
        }
    },
    '3.0.4' => {
        'core' => {
            'Kernel::Language::cz' => 1,
            'Kernel::Language::en_CA' => 1,
            'Kernel::Language::en_GB' => 1,
            'Kernel::Language::es_MX' => 1,
            'Kernel::Language::ja' => 1,
            'Kernel::Language::lv' => 1,
            'Kernel::Language::sr_Cyrl' => 1,
            'Kernel::Language::sr_Latn' => 1,
            'Kernel::Language::uk' => 1,
            'Kernel::Language::zh_TW' => 1,
            'Kernel::Modules::AdminNotificationEvent' => 1,
            'Kernel::Modules::AgentCustomerSearch' => 1,
            'Kernel::Modules::AgentDashboard' => 1,
            'Kernel::Modules::AgentHTMLReference' => 1,
            'Kernel::Modules::AgentSearch' => 1,
            'Kernel::Modules::AgentTicketActionCommon' => 1,
            'Kernel::Modules::AgentTicketLockedView' => 1,
            'Kernel::Modules::AgentTicketMailbox' => 1,
            'Kernel::Modules::AgentTicketResponsibleView' => 1,
            'Kernel::Modules::AgentTicketWatchView' => 1,
            'Kernel::Modules::PictureUpload' => 1,
            'Kernel::Modules::PublicDefault' => 1,
            'Kernel::Modules::SpellingInline' => 1,
            'Kernel::Output::HTML::DashboardCalendar' => 1,
            'Kernel::Output::HTML::DashboardIFrame' => 1,
            'Kernel::Output::HTML::DashboardImage' => 1,
            'Kernel::Output::HTML::DashboardMOTD' => 1,
            'Kernel::Output::HTML::DashboardProductNotify' => 1,
            'Kernel::Output::HTML::DashboardRSS' => 1,
            'Kernel::Output::HTML::DashboardTicketGeneric' => 1,
            'Kernel::Output::HTML::DashboardTicketStatsGeneric' => 1,
            'Kernel::Output::HTML::DashboardUserOnline' => 1,
            'Kernel::Output::HTML::LayoutDatepicker' => 1,
            'Kernel::Output::HTML::LayoutLoader' => 1,
            'Kernel::Output::HTML::LayoutPopup' => 1,
            'Kernel::Output::HTML::OutputFilterTextAutoLink' => 1,
            'Kernel::Output::HTML::PreferencesOutOfOffice' => 1,
            'Kernel::Output::HTML::PreferencesSkin' => 1,
            'Kernel::Output::HTML::PreferencesTicketWatcher' => 1,
            'Kernel::Output::HTML::SLAPreferencesGeneric' => 1,
            'Kernel::Output::HTML::ServicePreferencesGeneric' => 1,
            'Kernel::Output::HTML::TicketMenuMove' => 1,
            'Kernel::Output::HTML::TicketOverviewMedium' => 1,
            'Kernel::Output::HTML::TicketOverviewPreview' => 1,
            'Kernel::Output::HTML::TicketOverviewSmall' => 1,
            'Kernel::Output::HTML::ToolBarLink' => 1,
            'Kernel::Output::HTML::ToolBarTicketLocked' => 1,
            'Kernel::Output::HTML::ToolBarTicketResponsible' => 1,
            'Kernel::Output::HTML::ToolBarTicketSearchFulltext' => 1,
            'Kernel::Output::HTML::ToolBarTicketSearchProfile' => 1,
            'Kernel::Output::HTML::ToolBarTicketWatcher' => 1,
            'Kernel::System::Auth::Sync::LDAP' => 1,
            'Kernel::System::Cache::FileRaw' => 1,
            'Kernel::System::Cache::FileStorable' => 1,
            'Kernel::System::CacheInternal' => 1,
            'Kernel::System::Email::SMTPS' => 1,
            'Kernel::System::Email::SMTPTLS' => 1,
            'Kernel::System::EventHandler' => 1,
            'Kernel::System::HTMLUtils' => 1,
            'Kernel::System::JSON' => 1,
            'Kernel::System::Loader' => 1,
            'Kernel::System::NotificationEvent' => 1,
            'Kernel::System::PostMaster::Filter::FollowUpArticleTypeCheck' => 1,
            'Kernel::System::SLA::PreferencesDB' => 1,
            'Kernel::System::Service::PreferencesDB' => 1,
            'Kernel::System::StandardResponse' => 1,
            'Kernel::System::Stats::Dynamic::TicketAccountedTime' => 1,
            'Kernel::System::Stats::Dynamic::TicketList' => 1,
            'Kernel::System::Stats::Dynamic::TicketSolutionResponseTime' => 1,
            'Kernel::System::Stats::Static::StateAction' => 1,
            'Kernel::System::SysConfig' => 1,
            'Kernel::System::SysConfig::PriorityValidate' => 1,
            'Kernel::System::SysConfig::QueueValidate' => 1,
            'Kernel::System::SysConfig::StateValidate' => 1,
            'Kernel::System::TemplateGenerator' => 1,
            'Kernel::System::Ticket::Event::ArchiveRestore' => 1,
            'Kernel::System::Ticket::Event::NotificationEvent' => 1,
            'Kernel::System::Ticket::Event::TicketAcceleratorUpdate' => 1,
            'Kernel::System::Ticket::Event::TicketNewMessageUpdate' => 1,
            'Kernel::System::Ticket::Event::TicketPendingTimeReset' => 1,
            'Kernel::System::Ticket::Permission::WatcherCheck' => 1,
            'Kernel::System::UnitTest::Selenium' => 1,
            'Kernel::System::VirtualFS' => 1,
            'Kernel::System::VirtualFS::DB' => 1,
            'Kernel::System::VirtualFS::FS' => 1,
            'Kernel::System::Web::InterfaceInstaller' => 1,
            'Kernel::System::WebUserAgent' => 1
        },
        'cpan' => {
            'Apache2::Reload' => 1,
            'Apache::Reload' => 1,
            'CGI' => 1,
            'CGI::Apache' => 1,
            'CGI::Carp' => 1,
            'CGI::Cookie' => 1,
            'CGI::Fast' => 1,
            'CGI::Pretty' => 1,
            'CGI::Push' => 1,
            'CGI::Switch' => 1,
            'CGI::Util' => 1,
            'CSS::Minifier' => 1,
            'Digest::SHA::PurePerl' => 1,
            'JSON' => 1,
            'JSON::PP' => 1,
            'JSON::PP5005' => 1,
            'JSON::PP56' => 1,
            'JSON::PP58' => 1,
            'JSON::PP::Boolean' => 1,
            'JavaScript::Minifier' => 1,
            'Mail::Mailer::smtps' => 1,
            'Mail::POP3Client' => 1,
            'Net::IMAP::Simple::PipeSocket' => 1,
            'Net::SMTP::SSL' => 1,
            'Net::SMTP::TLS' => 1,
            'XML::FeedPP' => 1,
            'XML::TreePP' => 1
        }
    },
    '3.0.5' => {
        'core' => {
            'Kernel::Language::cs' => 1,
            'Kernel::Language::en_CA' => 1,
            'Kernel::Language::en_GB' => 1,
            'Kernel::Language::es_MX' => 1,
            'Kernel::Language::ja' => 1,
            'Kernel::Language::lv' => 1,
            'Kernel::Language::sr_Cyrl' => 1,
            'Kernel::Language::sr_Latn' => 1,
            'Kernel::Language::uk' => 1,
            'Kernel::Language::zh_TW' => 1,
            'Kernel::Modules::AdminNotificationEvent' => 1,
            'Kernel::Modules::AgentCustomerSearch' => 1,
            'Kernel::Modules::AgentDashboard' => 1,
            'Kernel::Modules::AgentHTMLReference' => 1,
            'Kernel::Modules::AgentSearch' => 1,
            'Kernel::Modules::AgentTicketActionCommon' => 1,
            'Kernel::Modules::AgentTicketLockedView' => 1,
            'Kernel::Modules::AgentTicketMailbox' => 1,
            'Kernel::Modules::AgentTicketResponsibleView' => 1,
            'Kernel::Modules::AgentTicketWatchView' => 1,
            'Kernel::Modules::PictureUpload' => 1,
            'Kernel::Modules::PublicDefault' => 1,
            'Kernel::Modules::SpellingInline' => 1,
            'Kernel::Output::HTML::DashboardCalendar' => 1,
            'Kernel::Output::HTML::DashboardIFrame' => 1,
            'Kernel::Output::HTML::DashboardImage' => 1,
            'Kernel::Output::HTML::DashboardMOTD' => 1,
            'Kernel::Output::HTML::DashboardProductNotify' => 1,
            'Kernel::Output::HTML::DashboardRSS' => 1,
            'Kernel::Output::HTML::DashboardTicketGeneric' => 1,
            'Kernel::Output::HTML::DashboardTicketStatsGeneric' => 1,
            'Kernel::Output::HTML::DashboardUserOnline' => 1,
            'Kernel::Output::HTML::LayoutDatepicker' => 1,
            'Kernel::Output::HTML::LayoutLoader' => 1,
            'Kernel::Output::HTML::LayoutPopup' => 1,
            'Kernel::Output::HTML::OutputFilterTextAutoLink' => 1,
            'Kernel::Output::HTML::PreferencesOutOfOffice' => 1,
            'Kernel::Output::HTML::PreferencesSkin' => 1,
            'Kernel::Output::HTML::PreferencesTicketWatcher' => 1,
            'Kernel::Output::HTML::SLAPreferencesGeneric' => 1,
            'Kernel::Output::HTML::ServicePreferencesGeneric' => 1,
            'Kernel::Output::HTML::TicketMenuMove' => 1,
            'Kernel::Output::HTML::TicketOverviewMedium' => 1,
            'Kernel::Output::HTML::TicketOverviewPreview' => 1,
            'Kernel::Output::HTML::TicketOverviewSmall' => 1,
            'Kernel::Output::HTML::ToolBarLink' => 1,
            'Kernel::Output::HTML::ToolBarTicketLocked' => 1,
            'Kernel::Output::HTML::ToolBarTicketResponsible' => 1,
            'Kernel::Output::HTML::ToolBarTicketSearchFulltext' => 1,
            'Kernel::Output::HTML::ToolBarTicketSearchProfile' => 1,
            'Kernel::Output::HTML::ToolBarTicketWatcher' => 1,
            'Kernel::System::Auth::Sync::LDAP' => 1,
            'Kernel::System::Cache::FileRaw' => 1,
            'Kernel::System::Cache::FileStorable' => 1,
            'Kernel::System::CacheInternal' => 1,
            'Kernel::System::Email::SMTPS' => 1,
            'Kernel::System::Email::SMTPTLS' => 1,
            'Kernel::System::EventHandler' => 1,
            'Kernel::System::HTMLUtils' => 1,
            'Kernel::System::JSON' => 1,
            'Kernel::System::Loader' => 1,
            'Kernel::System::NotificationEvent' => 1,
            'Kernel::System::PostMaster::Filter::FollowUpArticleTypeCheck' => 1,
            'Kernel::System::SLA::PreferencesDB' => 1,
            'Kernel::System::Service::PreferencesDB' => 1,
            'Kernel::System::StandardResponse' => 1,
            'Kernel::System::Stats::Dynamic::TicketAccountedTime' => 1,
            'Kernel::System::Stats::Dynamic::TicketList' => 1,
            'Kernel::System::Stats::Dynamic::TicketSolutionResponseTime' => 1,
            'Kernel::System::Stats::Static::StateAction' => 1,
            'Kernel::System::SysConfig' => 1,
            'Kernel::System::SysConfig::PriorityValidate' => 1,
            'Kernel::System::SysConfig::QueueValidate' => 1,
            'Kernel::System::SysConfig::StateValidate' => 1,
            'Kernel::System::TemplateGenerator' => 1,
            'Kernel::System::Ticket::Event::ArchiveRestore' => 1,
            'Kernel::System::Ticket::Event::NotificationEvent' => 1,
            'Kernel::System::Ticket::Event::TicketAcceleratorUpdate' => 1,
            'Kernel::System::Ticket::Event::TicketNewMessageUpdate' => 1,
            'Kernel::System::Ticket::Event::TicketPendingTimeReset' => 1,
            'Kernel::System::Ticket::Permission::WatcherCheck' => 1,
            'Kernel::System::UnitTest::Helper' => 1,
            'Kernel::System::UnitTest::Selenium' => 1,
            'Kernel::System::VirtualFS' => 1,
            'Kernel::System::VirtualFS::DB' => 1,
            'Kernel::System::VirtualFS::FS' => 1,
            'Kernel::System::Web::InterfaceInstaller' => 1,
            'Kernel::System::WebUserAgent' => 1
        },
        'cpan' => {
            'Apache2::Reload' => 1,
            'Apache::Reload' => 1,
            'CGI' => 1,
            'CGI::Apache' => 1,
            'CGI::Carp' => 1,
            'CGI::Cookie' => 1,
            'CGI::Fast' => 1,
            'CGI::Pretty' => 1,
            'CGI::Push' => 1,
            'CGI::Switch' => 1,
            'CGI::Util' => 1,
            'CSS::Minifier' => 1,
            'Digest::SHA::PurePerl' => 1,
            'JSON' => 1,
            'JSON::PP' => 1,
            'JSON::PP::Boolean' => 1,
            'JSON::backportPP' => 1,
            'JSON::backportPP::Boolean' => 1,
            'JSON::backportPP::Compat5005' => 1,
            'JSON::backportPP::Compat5006' => 1,
            'JavaScript::Minifier' => 1,
            'Mail::Mailer::smtps' => 1,
            'Mail::POP3Client' => 1,
            'Net::IMAP::Simple::PipeSocket' => 1,
            'Net::SMTP::SSL' => 1,
            'Net::SMTP::TLS::ButMaintained' => 1,
            'XML::FeedPP' => 1,
            'XML::TreePP' => 1
        }
    },
    '3.0.6' => {
        'core' => {
            'Kernel::Language::cs' => 1,
            'Kernel::Language::en_CA' => 1,
            'Kernel::Language::en_GB' => 1,
            'Kernel::Language::es_MX' => 1,
            'Kernel::Language::ja' => 1,
            'Kernel::Language::lv' => 1,
            'Kernel::Language::sr_Cyrl' => 1,
            'Kernel::Language::sr_Latn' => 1,
            'Kernel::Language::uk' => 1,
            'Kernel::Language::zh_TW' => 1,
            'Kernel::Modules::AdminNotificationEvent' => 1,
            'Kernel::Modules::AgentCustomerSearch' => 1,
            'Kernel::Modules::AgentDashboard' => 1,
            'Kernel::Modules::AgentHTMLReference' => 1,
            'Kernel::Modules::AgentSearch' => 1,
            'Kernel::Modules::AgentTicketActionCommon' => 1,
            'Kernel::Modules::AgentTicketLockedView' => 1,
            'Kernel::Modules::AgentTicketMailbox' => 1,
            'Kernel::Modules::AgentTicketResponsibleView' => 1,
            'Kernel::Modules::AgentTicketWatchView' => 1,
            'Kernel::Modules::PictureUpload' => 1,
            'Kernel::Modules::PublicDefault' => 1,
            'Kernel::Modules::SpellingInline' => 1,
            'Kernel::Output::HTML::CustomerHeaderMetaTicketSearch' => 1,
            'Kernel::Output::HTML::DashboardCalendar' => 1,
            'Kernel::Output::HTML::DashboardIFrame' => 1,
            'Kernel::Output::HTML::DashboardImage' => 1,
            'Kernel::Output::HTML::DashboardMOTD' => 1,
            'Kernel::Output::HTML::DashboardProductNotify' => 1,
            'Kernel::Output::HTML::DashboardRSS' => 1,
            'Kernel::Output::HTML::DashboardTicketGeneric' => 1,
            'Kernel::Output::HTML::DashboardTicketStatsGeneric' => 1,
            'Kernel::Output::HTML::DashboardUserOnline' => 1,
            'Kernel::Output::HTML::LayoutDatepicker' => 1,
            'Kernel::Output::HTML::LayoutLoader' => 1,
            'Kernel::Output::HTML::LayoutPopup' => 1,
            'Kernel::Output::HTML::OutputFilterTextAutoLink' => 1,
            'Kernel::Output::HTML::PreferencesOutOfOffice' => 1,
            'Kernel::Output::HTML::PreferencesSkin' => 1,
            'Kernel::Output::HTML::PreferencesTicketWatcher' => 1,
            'Kernel::Output::HTML::SLAPreferencesGeneric' => 1,
            'Kernel::Output::HTML::ServicePreferencesGeneric' => 1,
            'Kernel::Output::HTML::TicketMenuMove' => 1,
            'Kernel::Output::HTML::TicketOverviewMedium' => 1,
            'Kernel::Output::HTML::TicketOverviewPreview' => 1,
            'Kernel::Output::HTML::TicketOverviewSmall' => 1,
            'Kernel::Output::HTML::ToolBarLink' => 1,
            'Kernel::Output::HTML::ToolBarTicketLocked' => 1,
            'Kernel::Output::HTML::ToolBarTicketResponsible' => 1,
            'Kernel::Output::HTML::ToolBarTicketSearchFulltext' => 1,
            'Kernel::Output::HTML::ToolBarTicketSearchProfile' => 1,
            'Kernel::Output::HTML::ToolBarTicketWatcher' => 1,
            'Kernel::System::Auth::Sync::LDAP' => 1,
            'Kernel::System::Cache::FileRaw' => 1,
            'Kernel::System::Cache::FileStorable' => 1,
            'Kernel::System::CacheInternal' => 1,
            'Kernel::System::Email::SMTPS' => 1,
            'Kernel::System::Email::SMTPTLS' => 1,
            'Kernel::System::EventHandler' => 1,
            'Kernel::System::HTMLUtils' => 1,
            'Kernel::System::JSON' => 1,
            'Kernel::System::Loader' => 1,
            'Kernel::System::NotificationEvent' => 1,
            'Kernel::System::PostMaster::Filter::FollowUpArticleTypeCheck' => 1,
            'Kernel::System::SLA::PreferencesDB' => 1,
            'Kernel::System::Service::PreferencesDB' => 1,
            'Kernel::System::StandardResponse' => 1,
            'Kernel::System::Stats::Dynamic::TicketAccountedTime' => 1,
            'Kernel::System::Stats::Dynamic::TicketList' => 1,
            'Kernel::System::Stats::Dynamic::TicketSolutionResponseTime' => 1,
            'Kernel::System::Stats::Static::StateAction' => 1,
            'Kernel::System::SysConfig' => 1,
            'Kernel::System::SysConfig::PriorityValidate' => 1,
            'Kernel::System::SysConfig::QueueValidate' => 1,
            'Kernel::System::SysConfig::StateValidate' => 1,
            'Kernel::System::TemplateGenerator' => 1,
            'Kernel::System::Ticket::Event::ArchiveRestore' => 1,
            'Kernel::System::Ticket::Event::NotificationEvent' => 1,
            'Kernel::System::Ticket::Event::TicketAcceleratorUpdate' => 1,
            'Kernel::System::Ticket::Event::TicketNewMessageUpdate' => 1,
            'Kernel::System::Ticket::Event::TicketPendingTimeReset' => 1,
            'Kernel::System::Ticket::Permission::WatcherCheck' => 1,
            'Kernel::System::UnitTest::Helper' => 1,
            'Kernel::System::UnitTest::Selenium' => 1,
            'Kernel::System::VirtualFS' => 1,
            'Kernel::System::VirtualFS::DB' => 1,
            'Kernel::System::VirtualFS::FS' => 1,
            'Kernel::System::Web::InterfaceInstaller' => 1,
            'Kernel::System::WebUserAgent' => 1
        },
        'cpan' => {
            'Apache2::Reload' => 1,
            'Apache::DBI' => 1,
            'Apache::Reload' => 1,
            'CGI' => 1,
            'CGI::Apache' => 1,
            'CGI::Carp' => 1,
            'CGI::Cookie' => 1,
            'CGI::Fast' => 1,
            'CGI::Pretty' => 1,
            'CGI::Push' => 1,
            'CGI::Switch' => 1,
            'CGI::Util' => 1,
            'CSS::Minifier' => 1,
            'Digest::SHA::PurePerl' => 1,
            'JSON' => 1,
            'JSON::PP' => 1,
            'JSON::PP::Boolean' => 1,
            'JSON::backportPP' => 1,
            'JSON::backportPP::Boolean' => 1,
            'JSON::backportPP::Compat5005' => 1,
            'JSON::backportPP::Compat5006' => 1,
            'JavaScript::Minifier' => 1,
            'Mail::Mailer::smtps' => 1,
            'Mail::POP3Client' => 1,
            'Net::IMAP::Simple::PipeSocket' => 1,
            'Net::SMTP::SSL' => 1,
            'Net::SMTP::TLS::ButMaintained' => 1,
            'XML::FeedPP' => 1,
            'XML::TreePP' => 1
        }
    }
);

sub shipped {
    my ($class,$version,$module) = @_;
    
    return if !$version =~ m{ \A [0-9]+\.[0-9]\.(?:[0-9]+|x) \z }xms;
    
    $version =~ s{\.}{\.}g;
    $version =~ s{x}{.*};
    
    my $version_re = qr{ \A $version \z }xms;
    
    my @versions_with_module;
    
    OTRSVERSION:
    for my $otrs_version ( sort keys %modules ) {
        next unless $otrs_version =~ $version_re;
        
        if ( $modules{$otrs_version}->{core}->{$module} || 
             $modules{$otrs_version}->{cpan}->{$module} ||
             $global{core}->{$module} ||
             $global{cpan}->{$module} ) {
            push @versions_with_module, $otrs_version;
        }
    }
    
    return @versions_with_module;
}

sub modules {
    my ($class,$version) = @_;
    
    return if !$version =~ m{ \A [0-9]+\.[0-9]\.(?:[0-9]+|x) \z }xms;
    
    $version =~ s{\.}{\.}g;
    $version =~ s{x}{.*};
    
    my $version_re = qr{ \A $version \z }xms;
    
    my %modules;
    
    OTRSVERSION:
    for my $otrs_version ( keys %modules ) {
        next unless $otrs_version =~ $version_re;
        
        my $hashref = $modules{$otrs_version}->{core};
        my @modulenames = keys %{$hashref || {}};
        
        @modules{@modulenames} = (1) x @modulenames;
    }
    
    if ( $version =~ m{x} || exists $modules{$version} ) {
        my @global_modules = keys %{ $global{core} };
        @modules{@global_modules} = (1) x @global_modules;
    }
    
    return keys %modules;
}

sub cpan_modules {
    my ($class,$version) = @_;
    
    return if !$version =~ m{ \A [0-9]+\.[0-9]\.(?:[0-9]+|x) \z }xms;
    
    $version =~ s{\.}{\.}g;
    $version =~ s{x}{.*};
    
    my $version_re = qr{ \A $version \z }xms;
    
    my %modules;
    
    OTRSVERSION:
    for my $otrs_version ( keys %modules ) {
        next unless $otrs_version =~ $version_re;
        
        my $hashref = $modules{$otrs_version}->{cpan};
        my @modulenames = keys %{$hashref || {}};
        
        @modules{@modulenames} = (1) x @modulenames;
    }
    
    if ( $version =~ m{x} || exists $modules{$version} ) {
        my @global_modules = keys %{ $global{cpan} };
        @modules{@global_modules} = (1) x @global_modules;
    }
    
    return keys %modules;
}

1;
__END__
=pod

=head1 NAME

Module::OTRS::CoreList - what modules shipped with versions of OTRS (>= 2.3.x)

=head1 VERSION

version 0.02

=head1 SYNOPSIS

 use Module::OTRS::CoreList;

 my @otrs_versions = Module::OTRS::CoreList->shipped(
    '2.4.x',
    'Kernel::System::DB',
 );
 
 # returns (2.4.0, 2.4.1, 2.4.2,...)
 
 my @modules = Module::OTRS::CoreList->modules( '2.4.8' );
 my @modules = Module::OTRS::CoreList->modules( '2.4.x' );
 
 # methods to check for CPAN modules shipped with OTRS
 
 my @cpan_modules = Module::OTRS::CoreList->cpan_modules( '2.4.x' );

 my @otrs_versions = Module::OTRS::CoreList->shipped(
    '3.0.x',
    'CGI',
 );

=head1 AUTHOR

Renee Baecker <module@renee-baecker.de>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2010 by Renee Baecker.

This is free software, licensed under:

  The Artistic License 2.0

=cut

