# Before `make install' is performed this script should be runnable with
# `make test'. After `make install' it should work as `perl iban_gen.t'

use Test::More tests => 4332;

BEGIN { use_ok('Business::KontoCheck') };

$ok_cnt=1;
$nok_cnt=0;
$retval=lut_init("blz.lut",9);
$ret_txt=$kto_retval{$retval};
if($retval gt 0){$ok_cnt++;}else{$nok_cnt++;}
ok($retval gt 0,"lut_init(): $retval => $ret_txt (ok: $ok_cnt, nok: $nok_cnt)");

if($retval gt 0){
   while(<DATA>){
      chomp;
      ($blz,$kto,$bic,$iban,$ret)=split(/;/);
      ($retval,$iban_p,$papier_p,$bic_p,$regel,$pz_methode)=Business::KontoCheck::iban_gen($blz,$kto);
      $iban="" if not defined($iban);
      $bic="" if not defined($bic);
      $iban_p="" if not defined($iban_p);
      $papier_p="" if not defined($papier_p);
      $bic_p="" if not defined($bic_p);
      $regel/=100;
#      $ret_txt=$kto_retval{$retval};
      if($ret==$retval && $iban_p eq $iban && $bic_p eq $bic){$ok_cnt++;}else{$nok_cnt++;}
      $r1=($ret==$retval)?1:0;
      $r2=($iban_p eq $iban)?1:0;
      $r3=($bic_p eq $bic)?1:0;
      ok($ret==$retval && $iban_p eq $iban && $bic_p eq $bic,"iban_gen($blz,$kto): $r1 $r2 $r3 [ $retval / $ret @ $iban_p / $iban @ $bic_p / $bic] (Regel $regel, PZ $pz_methode) (ok: $ok_cnt, nok: $nok_cnt)");
   }
}

__DATA__
14000000;7451828539;;;-124
16000000;7581438801;;;-124
17000000;6252042986;;;-124
18000000;1673837456;;;-124
20110401;7451828539;;;-124
44010300;5718384479;;;-124
44040085;393312437;;;-124
72020700;2794705885;AUGBDE77XXX;DE22720207002794705885;1
51010800;1673837456;AARBDE5W108;DE44510108001673837456;1
10050000;7941055770;BELADEBEXXX;DE12100500007941055770;1
10050000;135;BELADEBEXXX;DE86100500000990021440;18
10050000;1111;BELADEBEXXX;DE19100500006600012020;18
10050000;1900;BELADEBEXXX;DE73100500000920019005;18
10050000;7878;BELADEBEXXX;DE48100500000780008006;18
10050000;8888;BELADEBEXXX;DE43100500000250030942;18
10050000;9595;BELADEBEXXX;DE60100500001653524703;18
10050000;97097;BELADEBEXXX;DE15100500000013044150;18
10050000;112233;BELADEBEXXX;DE54100500000630025819;18
10050000;336666;BELADEBEXXX;DE22100500006604058903;18
10050000;484848;BELADEBEXXX;DE43100500000920018963;18
10080900;998132813;;;-124
12080000;998132813;;;-124
13080000;998132813;;;-124
14080000;998132813;;;-124
15080000;998132813;;;-124
16080000;998132813;;;-124
17080000;998132813;;;-124
18080000;998132813;;;-124
20080055;998132813;;;-124
20080057;998132813;;;-124
21080050;998132813;;;-124
21280002;998132813;;;-124
21480003;998132813;;;-124
21580000;998132813;;;-124
22180000;998132813;;;-124
22181400;998132813;;;-124
22280000;998132813;;;-124
24080000;998132813;;;-124
24180001;998132813;;;-124
25480021;998132813;;;-124
25780022;998132813;;;-124
25980027;998132813;;;-124
26080024;998132813;;;-124
26281420;998132813;;;-124
26580070;998132813;;;-124
26880063;998132813;;;-124
26981062;998132813;;;-124
28280012;998132813;;;-124
29280011;998132813;;;-124
30080055;998132813;;;-124
30080057;998132813;;;-124
31080015;998132813;;;-124
32080010;998132813;;;-124
33080030;998132813;;;-124
34080031;998132813;;;-124
34280032;998132813;;;-124
36280071;998132813;;;-124
36580072;998132813;;;-124
40080040;998132813;;;-124
41280043;998132813;;;-124
42080082;998132813;;;-124
42680081;998132813;;;-124
43080083;998132813;;;-124
44080055;998132813;;;-124
44080057;998132813;;;-124
44580070;998132813;;;-124
45080060;998132813;;;-124
46080010;998132813;;;-124
47880031;998132813;;;-124
49080025;998132813;;;-124
50080055;998132813;;;-124
50080057;998132813;;;-124
50080081;998132813;;;-4
50080082;998132813;;;-124
50680002;998132813;;;-124
50780006;998132813;;;-124
50880050;998132813;;;-124
51080000;998132813;;;-4
51380040;998132813;;;-124
52080080;998132813;;;-124
53080030;998132813;;;-124
54080021;998132813;;;-124
54280023;998132813;;;-124
54580020;998132813;;;-124
54680022;998132813;;;-124
55080065;998132813;;;-124
57080070;998132813;;;-124
58580074;998132813;;;-124
59080090;998132813;;;-124
60080055;998132813;;;-124
60080057;998132813;;;-124
60380002;998132813;;;-124
60480008;998132813;;;-124
61080006;998132813;;;-124
61281007;998132813;;;-124
61480001;998132813;;;-124
62080012;998132813;;;-124
62280012;998132813;;;-124
63080015;998132813;;;-124
64080014;998132813;;;-124
64380011;998132813;;;-124
65080009;998132813;;;-124
65180005;998132813;;;-124
65380003;998132813;;;-124
66280053;998132813;;;-124
66680013;998132813;;;-124
67280051;998132813;;;-124
69280035;998132813;;;-124
70080056;998132813;;;-124
70080057;998132813;;;-124
70380006;998132813;;;-124
71180005;998132813;;;-124
72180002;998132813;;;-124
73180011;998132813;;;-124
73380004;998132813;;;-124
73480013;998132813;;;-124
74180009;998132813;;;-124
74380007;998132813;;;-124
75080003;998132813;;;-124
76080053;998132813;;;-124
79080052;998132813;;;-124
79380051;998132813;;;-124
79580099;998132813;;;-124
80080000;998132813;;;-124
81080000;998132813;;;-124
82080000;998132813;;;-124
83080000;998132813;;;-124
84080000;998132813;;;-124
85080200;998132813;;;-124
86080055;998132813;;;-124
86080057;998132813;;;-124
87080000;998132813;;;-124
10045050;998132813;;;-124
50040033;998132813;;;-124
70045050;998132813;;;-124
10040085;998132813;;;-124
35040085;998132813;;;-124
36040085;998132813;;;-124
44040085;998132813;;;-124
50040085;998132813;;;-124
67040085;998132813;;;-124
82040085;998132813;;;-124
30040000;36;COBADEFFXXX;DE95300400000261103600;18
47880031;50;DRESDEFF478;DE06478800310519899900;18
47840065;50;COBADEFFXXX;DE07478400650150103000;18
47840065;55;COBADEFFXXX;DE07478400650150103000;18
70080000;94;DRESDEFF700;DE17700800000928553201;18
70040041;94;COBADEFFXXX;DE60700400410212808000;18
47840065;99;COBADEFFXXX;DE07478400650150103000;18
37080040;100;DRESDEFF370;DE52370800400269100000;18
38040007;100;COBADEFFXXX;DE65380400070119160000;18
37080040;111;DRESDEFF370;DE69370800400215022000;18
51080060;123;DRESDEFF510;DE35510800600012299300;18
36040039;150;COBADEFFXXX;DE82360400390161620000;18
68080030;202;DRESDEFF680;DE27680800300416520200;18
30040000;222;COBADEFFXXX;DE18300400000348010002;18
38040007;240;COBADEFFXXX;DE48380400070109024000;18
69240075;444;COBADEFFXXX;DE91692400750445520000;18
60080000;502;DRESDEFF600;DE45600800000901581400;18
60040071;502;COBADEFFXXX;DE23600400710525950200;18
55040022;555;COBADEFFXXX;DE81550400220211050000;18
39080005;556;DRESDEFF390;DE34390800050204655600;18
39040013;556;COBADEFFXXX;DE79390400130106555600;18
57080070;661;DRESDEFF570;DE49570800700604101200;18
26580070;700;DRESDEFF265;DE29265800700710000000;18
50640015;777;COBADEFFXXX;DE79506400150222222200;18
30040000;999;COBADEFFXXX;DE63300400000123799900;18
86080000;1212;DRESDEFF860;DE78860800000480375900;18
37040044;1888;COBADEFFXXX;DE09370400440212129101;18
25040066;1919;COBADEFFXXX;DE09250400660141919100;18
10080000;1987;DRESDEFF100;DE06100800000928127700;18
50040000;2000;COBADEFFXXX;DE49500400000728400300;18
20080000;2222;DRESDEFF200;DE13200800000903927200;18
38040007;3366;COBADEFFXXX;DE89380400070385333000;18
37080040;4004;DRESDEFF370;DE14370800400233533500;18
37080040;4444;DRESDEFF370;DE62370800400233000300;18
43080083;4630;DRESDEFF430;DE55430800830825110100;18
50080000;6060;DRESDEFFXXX;DE16500800000096736100;18
10040000;7878;COBADEFFXXX;DE54100400000267878700;18
10080000;8888;DRESDEFF100;DE78100800000928126501;18
50080000;9000;DRESDEFFXXX;DE75500800000026492100;18
79080052;9696;DRESDEFF790;DE88790800520300021700;18
79040047;9696;COBADEFFXXX;DE16790400470680210200;18
39080005;9800;DRESDEFF390;DE68390800050208457000;18
50080000;42195;DRESDEFFXXX;DE15500800000900333200;18
32040024;47800;COBADEFFXXX;DE35320400240155515000;18
37080040;55555;DRESDEFF370;DE21370800400263602501;18
38040007;55555;COBADEFFXXX;DE16380400070305555500;18
50080000;101010;DRESDEFFXXX;DE82500800000090003500;18
50040000;101010;COBADEFFXXX;DE46500400000311011100;18
37040044;102030;COBADEFFXXX;DE34370400440222344400;18
86080000;121200;DRESDEFF860;DE78860800000480375900;18
66280053;121212;DRESDEFF662;DE08662800530625242400;18
16080000;123456;DRESDEFF160;DE10160800000012345600;18
29080010;124124;DRESDEFF290;DE36290800100107502000;18
37080040;182002;DRESDEFF370;DE47370800400216603302;18
12080000;212121;DRESDEFF120;DE02120800004050462200;18
37080040;300000;DRESDEFF370;DE41370800400983307900;18
37040044;300000;COBADEFFXXX;DE21370400440300000700;18
37080040;333333;DRESDEFF370;DE39370800400270330000;18
38040007;336666;COBADEFFXXX;DE14380400070105232300;18
55040022;343434;COBADEFFXXX;DE78550400220217900000;18
85080000;400000;DRESDEFF850;DE33850800000459488501;18
37080040;414141;DRESDEFF370;DE16370800400041414100;18
38040007;414141;COBADEFFXXX;DE57380400070108000100;18
20080000;505050;DRESDEFF200;DE39200800000500100600;18
37080040;555666;DRESDEFF370;DE48370800400055566600;18
20080000;666666;DRESDEFF200;DE51200800000900732500;18
30080000;700000;DRESDEFF300;DE48300800000800005000;18
70080000;700000;DRESDEFF700;DE25700800000750055500;18
70080000;900000;DRESDEFF700;DE96700800000319966601;18
37080040;909090;DRESDEFF370;DE52370800400269100000;18
38040007;909090;COBADEFFXXX;DE65380400070119160000;18
70080000;949494;DRESDEFF700;DE39700800000575757500;18
70080000;1111111;DRESDEFF700;DE34700800000448060000;18
70040041;1111111;COBADEFFXXX;DE67700400410152140000;18
10080000;1234567;DRESDEFF100;DE94100800000920192001;18
38040007;1555555;COBADEFFXXX;DE83380400070258266600;18
76040061;2500000;COBADEFFXXX;DE46760400610482146800;18
16080000;3030400;DRESDEFF160;DE50160800004205227110;18
37080040;5555500;DRESDEFF370;DE21370800400263602501;18
75040062;6008833;COBADEFFXXX;DE11750400620600883300;18
12080000;7654321;DRESDEFF120;DE18120800000144000700;18
70080000;7777777;DRESDEFF700;DE66700800000443540000;18
70040041;7777777;COBADEFFXXX;DE98700400410213600000;18
64140036;8907339;COBADEFFXXX;DE12641400360890733900;18
70080000;9000000;DRESDEFF700;DE96700800000319966601;18
61080006;9999999;DRESDEFF610;DE80610800060202427500;18
12080000;12121212;DRESDEFF120;DE37120800004101725100;18
29080010;12412400;DRESDEFF290;DE36290800100107502000;18
34280032;14111935;DRESDEFF342;DE96342800320645753800;18
38040007;43434343;COBADEFFXXX;DE93380400070118163500;18
30080000;70000000;DRESDEFF300;DE48300800000800005000;18
70080000;70000000;DRESDEFF700;DE25700800000750055500;18
44040037;111111111;COBADEFFXXX;DE20440400370320565500;18
70040041;400500500;COBADEFFXXX;DE48700400410400500500;18
60080000;500500500;DRESDEFF600;DE45600800000901581400;18
60040071;500500500;COBADEFFXXX;DE22600400710512700600;18
26580070;732502200;DRESDEFF265;DE32265800700732502200;1
26580070;7325022;DRESDEFF265;DE32265800700732502200;18
26580070;8732502200;DRESDEFF265;DE60265800708732502200;1
26580070;4820379900;DRESDEFF265;DE37265800704820379900;1
50080000;1814706100;DRESDEFFXXX;;-3
50080000;2814706100;DRESDEFFXXX;;-3
50080000;3814706100;DRESDEFFXXX;;-3
50080000;4814706100;DRESDEFFXXX;DE70500800004814706100;1
50080000;5814706100;DRESDEFFXXX;;-3
50080000;6814706100;DRESDEFFXXX;DE77500800006814706100;1
50080000;7814706100;DRESDEFFXXX;DE32500800007814706100;1
50080000;8814706100;DRESDEFFXXX;DE84500800008814706100;1
50080000;9814706100;DRESDEFFXXX;DE39500800009814706100;1
50080000;23165400;DRESDEFFXXX;DE42500800000023165400;1
50080000;231654;DRESDEFFXXX;DE42500800000023165400;18
50080000;4350300;DRESDEFFXXX;DE21500800000004350300;1
50080000;43503;DRESDEFFXXX;DE21500800000004350300;18
50080000;526400;DRESDEFFXXX;;-3
50089400;526400;DRESDEFFI01;DE49500894000000526400;1
10080000;998761700;DRESDEFF100;DE73100800000998761700;1
12080000;998761700;;;-124
26580070;43434280;DRESDEFF265;;-3
26580070;343428000;DRESDEFF265;;-3
26580070;99021000;DRESDEFF265;DE10265800709902100000;18
50540028;4217386;COBADEFFXXX;DE24505400280421738600;18
50540028;4217387;COBADEFFXXX;;0
72040046;111198800;COBADEFFXXX;DE10720400460111198800;1
72040046;111198700;COBADEFFXXX;;0
50540028;420086100;COBADEFFXXX;DE46505400280420086100;1
50540028;421573704;COBADEFFXXX;DE13505400280421573704;1
50540028;421679200;COBADEFFXXX;DE26505400280421679200;1
65440087;130023500;COBADEFFXXX;DE63654400870130023500;1
23040022;104414;COBADEFFXXX;DE29230400220010441400;18
23040022;104417;COBADEFFXXX;;0
12040000;40050700;COBADEFFXXX;DE27120400000040050700;1
23040022;101337;COBADEFFXXX;DE73230400220010133700;18
23040022;10503101;COBADEFFXXX;DE77230400220010503101;1
12040000;52065002;COBADEFFXXX;DE12120400000052065002;1
50040000;930125001;COBADEFFXXX;DE97500400000930125001;1
70040041;930125000;COBADEFFXXX;DE89700400410930125000;1
50040000;930125006;COBADEFFXXX;DE59500400000930125006;1
10045050;930125001;;;-124
50040033;930125004;;;-124
70045050;930125007;;;-124
20041111;130023500;COBADEFFXXX;DE81200411110130023500;1
37080040;111;DRESDEFF370;DE69370800400215022000;18
50040000;101010;COBADEFFXXX;DE46500400000311011100;18
70150000;1111111;SSKMDEMMXXX;DE62701500000020228888;18
70150000;7777777;SSKMDEMMXXX;DE48701500000903286003;18
70150000;34343434;SSKMDEMMXXX;DE30701500001000506517;18
70150000;70000;SSKMDEMMXXX;DE64701500000018180018;18
70150000;20228888;SSKMDEMMXXX;DE62701500000020228888;1
70150000;903286003;SSKMDEMMXXX;DE48701500000903286003;1
70150000;1000506517;SSKMDEMMXXX;DE30701500001000506517;1
70150000;18180018;SSKMDEMMXXX;DE64701500000018180018;1
37050198;111;COLSDE33XXX;DE15370501980000001115;18
37050198;221;COLSDE33XXX;DE25370501980023002157;18
37050198;1888;COLSDE33XXX;DE15370501980018882068;18
37050198;2006;COLSDE33XXX;DE57370501981900668508;18
37050198;2626;COLSDE33XXX;DE41370501981900730100;18
37050198;3004;COLSDE33XXX;DE39370501981900637016;18
37050198;3636;COLSDE33XXX;DE52370501980023002447;18
37050198;4000;COLSDE33XXX;DE31370501980000004028;18
37050198;4444;COLSDE33XXX;DE12370501980000017368;18
37050198;5050;COLSDE33XXX;DE83370501980000073999;18
37050198;8888;COLSDE33XXX;DE42370501981901335750;18
37050198;1901335750;COLSDE33XXX;DE42370501981901335750;1
37050198;30000;COLSDE33XXX;DE22370501980009992959;18
37050198;43430;COLSDE33XXX;DE56370501981901693331;18
37050198;46664;COLSDE33XXX;DE98370501981900399856;18
37050198;55555;COLSDE33XXX;DE81370501980034407379;18
37050198;102030;COLSDE33XXX;DE17370501981900480466;18
37050198;151515;COLSDE33XXX;DE64370501980057762957;18
37050198;222222;COLSDE33XXX;DE85370501980002222222;18
37050198;300000;COLSDE33XXX;DE22370501980009992959;18
37050198;333333;COLSDE33XXX;DE53370501980000033217;18
37050198;414141;COLSDE33XXX;DE83370501980000092817;18
37050198;606060;COLSDE33XXX;DE64370501980000091025;18
37050198;909090;COLSDE33XXX;DE20370501980000090944;18
37050198;2602024;COLSDE33XXX;DE24370501980005602024;18
37050198;3000000;COLSDE33XXX;DE22370501980009992959;18
37050198;7777777;COLSDE33XXX;DE85370501980002222222;18
37050198;8090100;COLSDE33XXX;DE39370501980000038901;18
37050198;14141414;COLSDE33XXX;DE96370501980043597665;18
37050198;15000023;COLSDE33XXX;DE98370501980015002223;18
37050198;15151515;COLSDE33XXX;DE64370501980057762957;18
37050198;22222222;COLSDE33XXX;DE85370501980002222222;18
37050198;200820082;COLSDE33XXX;DE54370501981901783868;18
37050198;222220022;COLSDE33XXX;DE85370501980002222222;18
50020200;38000;BHFBDEFF500;DE80500202000000038000;1
51020000;30009963;BHFBDEFF500;DE46500202000030009963;19
30020500;40033086;BHFBDEFF500;DE02500202000040033086;19
20120200;50017409;BHFBDEFF500;DE55500202000050017409;19
70220200;55036107;BHFBDEFF500;DE38500202000055036107;19
10020200;70049754;BHFBDEFF500;DE98500202000070049754;19
10020200;38000;BHFBDEFF500;DE80500202000000038000;19
20120200;30009963;BHFBDEFF500;DE46500202000030009963;19
25020200;40033086;BHFBDEFF500;DE02500202000040033086;19
30020500;50017409;BHFBDEFF500;DE55500202000050017409;19
51020000;55036107;BHFBDEFF500;DE38500202000055036107;19
55020000;70049754;BHFBDEFF500;DE98500202000070049754;19
60120200;38000;BHFBDEFF500;DE80500202000000038000;19
70220200;30009963;BHFBDEFF500;DE46500202000030009963;19
86020200;40033086;BHFBDEFF860;DE72860202000040033086;1
68351976;1116232594;SOLADES1SFH;DE03683515573047232594;20
68351976;16005845;SOLADES1SFH;DE10683515570016005845;19
50050201;2000;HELADEF1822;DE42500502010000222000;18
50050201;800000;HELADEF1822;DE89500502010000180802;18
50050201;180802;HELADEF1822;DE89500502010000180802;1
50050201;222000;HELADEF1822;DE42500502010000222000;1
32050000;1000;SPKRDE33XXX;DE44320500000008010001;18
32050000;47800;SPKRDE33XXX;DE36320500000000047803;18
32050000;8010001;SPKRDE33XXX;DE44320500000008010001;1
32050000;47803;SPKRDE33XXX;DE36320500000000047803;1
50850049;5000002096;HELADEFFXXX;DE95500500005000002096;19
40050000;60624;WELADEDDXXX;DE15300500000000060624;19
10090603;1174936462;DAAEDEDDXXX;DE14300606011174936462;19
12090640;4154993701;DAAEDEDDXXX;DE54300606014154993701;19
20090602;1525423622;DAAEDEDDXXX;DE48300606011525423622;19
21090619;5515096740;DAAEDEDDXXX;DE55300606015515096740;19
23092620;6155902233;DAAEDEDDXXX;DE27300606016155902233;19
25090608;4735332690;DAAEDEDDXXX;DE80300606014735332690;19
26560625;4215244113;DAAEDEDDXXX;DE31300606014215244113;19
27090618;4505579221;DAAEDEDDXXX;DE34300606014505579221;19
28090633;9905015003;DAAEDEDDXXX;DE21300606019905015003;19
29090605;9625098890;DAAEDEDDXXX;DE54300606019625098890;19
30060601;4255092235;DAAEDEDDXXX;DE02300606014255092235;1
33060616;8525479572;DAAEDEDDXXX;DE52300606018525479572;19
35060632;3595938913;DAAEDEDDXXX;DE94300606013595938913;19
36060610;6375593380;DAAEDEDDXXX;DE26300606016375593380;19
37060615;6855001556;DAAEDEDDXXX;DE35300606016855001556;19
39060630;2575591206;DAAEDEDDXXX;DE16300606012575591206;19
40060614;3685927923;DAAEDEDDXXX;DE63300606013685927923;19
44060604;5115689603;DAAEDEDDXXX;DE03300606015115689603;19
50090607;9075183044;DAAEDEDDXXX;DE73300606019075183044;19
50890634;5195836615;DAAEDEDDXXX;DE90300606015195836615;19
51090636;1315439466;DAAEDEDDXXX;DE54300606011315439466;19
52090611;7355229775;DAAEDEDDXXX;DE73300606017355229775;19
53390635;1335377904;DAAEDEDDXXX;DE06300606011335377904;19
54690623;8055624956;DAAEDEDDXXX;DE09300606018055624956;19
55060831;6855528945;DAAEDEDDXXX;DE35300606016855528945;19
57060612;1775475487;DAAEDEDDXXX;DE95300606011775475487;19
59090626;8456396259;DAAEDEDDXXX;DE31300606018456396259;19
60090609;6730569756;DAAEDEDDXXX;DE03300606016730569756;19
66090621;8381793169;DAAEDEDDXXX;DE85300606018381793169;19
67090617;7799110791;DAAEDEDDXXX;DE14300606017799110791;19
68090622;3240860196;DAAEDEDDXXX;DE85300606013240860196;19
70090606;9174867266;DAAEDEDDXXX;DE17300606019174867266;19
75090629;3055455145;DAAEDEDDXXX;DE38300606013055455145;19
76090613;8513292259;DAAEDEDDXXX;DE38300606018513292259;19
77390628;3664711251;DAAEDEDDXXX;DE23300606013664711251;19
79090624;2746505500;DAAEDEDDXXX;DE32300606012746505500;19
37060193;556;GENODED1PAX;DE75370601930000101010;18
37060193;888;GENODED1PAX;DE94370601930031870011;18
37060193;4040;GENODED1PAX;DE13370601934003600101;18
37060193;5826;GENODED1PAX;DE49370601931015826017;18
37060193;25000;GENODED1PAX;DE44370601930025000110;18
37060193;393393;GENODED1PAX;DE10370601930033013019;18
37060193;444555;GENODED1PAX;DE38370601930032230016;18
37060193;603060;GENODED1PAX;DE98370601936002919018;18
37060193;2120041;GENODED1PAX;DE92370601930002130041;18
37060193;80868086;GENODED1PAX;DE42370601934007375013;18
37060193;400569017;GENODED1PAX;DE90370601934000569017;18
37160087;300000;GENODED1CGN;DE68371600870018128012;18
38060186;100;GENODED1BRS;DE43380601862009090013;18
38060186;111;GENODED1BRS;DE38380601862111111017;18
38060186;240;GENODED1BRS;DE77380601862100240010;18
38060186;4004;GENODED1BRS;DE23380601862204004016;18
38060186;4444;GENODED1BRS;DE04380601862044444014;18
38060186;6060;GENODED1BRS;DE07380601862016060014;18
38060186;102030;GENODED1BRS;DE16380601861102030016;18
38060186;333333;GENODED1BRS;DE06380601862033333016;18
38060186;909090;GENODED1BRS;DE43380601862009090013;18
38060186;50005000;GENODED1BRS;DE95380601865000500013;18
37060193;101010;GENODED1PAX;DE75370601930000101010;1
37060193;31870011;GENODED1PAX;DE94370601930031870011;1
37060193;4003600101;GENODED1PAX;DE13370601934003600101;1
37060193;1015826017;GENODED1PAX;DE49370601931015826017;1
37060193;25000110;GENODED1PAX;DE44370601930025000110;1
37060193;33013019;GENODED1PAX;DE10370601930033013019;1
37060193;32230016;GENODED1PAX;DE38370601930032230016;1
37060193;6002919018;GENODED1PAX;DE98370601936002919018;1
37060193;2130041;GENODED1PAX;DE92370601930002130041;1
37060193;4007375013;GENODED1PAX;DE42370601934007375013;1
37060193;4000569017;GENODED1PAX;DE90370601934000569017;1
37160087;18128012;GENODED1CGN;DE68371600870018128012;1
38060186;2009090013;GENODED1BRS;DE43380601862009090013;1
38060186;2111111017;GENODED1BRS;DE38380601862111111017;1
38060186;2100240010;GENODED1BRS;DE77380601862100240010;1
38060186;2204004016;GENODED1BRS;DE23380601862204004016;1
38060186;2044444014;GENODED1BRS;DE04380601862044444014;1
38060186;2016060014;GENODED1BRS;DE07380601862016060014;1
38060186;1102030016;GENODED1BRS;DE16380601861102030016;1
38060186;2033333016;GENODED1BRS;DE06380601862033333016;1
38060186;2009090013;GENODED1BRS;DE43380601862009090013;1
38060186;5000500013;GENODED1BRS;DE95380601865000500013;1
39060180;556;GENODED1AAC;DE05390601800120440110;18
39060180;5435435430;GENODED1AAC;DE37390601800543543543;18
39060180;2157;GENODED1AAC;DE07390601800121787016;18
39060180;9800;GENODED1AAC;DE19390601800120800019;18
39060180;202050;GENODED1AAC;DE61390601801221864014;18
39060180;120440110;GENODED1AAC;DE05390601800120440110;1
39060180;543543543;GENODED1AAC;DE37390601800543543543;1
39060180;121787016;GENODED1AAC;DE07390601800121787016;1
39060180;120800019;GENODED1AAC;DE19390601800120800019;1
39060180;1221864014;GENODED1AAC;DE61390601801221864014;1
50130100;20475000;DELBDE33XXX;DE82501203830020475000;19
50220200;20475000;DELBDE33XXX;DE82501203830020475000;19
70030800;20475000;DELBDE33XXX;DE82501203830020475000;19
10020000;9746976388;;;-4
50070010;9999;DEUTDEFFXXX;DE80500700100092777202;18
10070024;3500022;DEUTDEDBBER;DE39100700240350002200;18
10070100;38150900;DEUTDEBB101;DE90100701000038150900;1
10070124;600103660;DEUTDEDB101;DE17100701240600103660;1
10070848;39101181;DEUTDEDB110;DE60100708480039101181;1
10077777;56002;NORSDE51XXX;DE10100777770005600200;18
12070000;752691;;;-127
12070024;5719083;;;-127
13070000;8007759;;;-127
13070024;1415900000;;;-127
20070000;4287900000;DEUTDEHHXXX;DE41200700000428790000;18
20070024;4915518000;DEUTDEDBHAM;DE68200700240491551800;18
21070020;5814488000;DEUTDEHH210;DE69210700200581448800;18
21070024;3805868000;DEUTDEDB210;DE38210700240380586800;18
21270020;3805868000;DEUTDEHH212;DE87212700200380586800;18
21270024;94012341;;;-3
21570011;5073321010;;;-3
76026000;94012341;;;-124
76026000;5073321010;;;-124
76026000;1234517892;NORSDE71XXX;;0
76026000;987614325;NORSDE71XXX;;0
35020030;305200;NBAGDE3EXXX;DE81360200300000305200;19
36220030;900826;NBAGDE3EXXX;DE03360200300000900826;19
36520030;705020;NBAGDE3EXXX;DE71360200300000705020;19
36020030;9197354;NBAGDE3EXXX;DE18360200300009197354;1
43060967;1111111;GENODEM1GLS;DE22430609672222200000;18
26590025;700;GENODEF1OSV;DE76265900251000700800;18
36060295;94;GENODED1BBE;DE48360602950000001694;18
36060295;248;GENODED1BBE;DE03360602950000017248;18
36060295;345;GENODED1BBE;DE03360602950000017345;18
36060295;400;GENODED1BBE;DE75360602950000014400;18
64150182;2777939;SOLADEST600;DE81600501010002777939;19
64450288;7893500686;SOLADEST600;DE80600501017893500686;19
35060190;55111;GENODED1DKD;DE21350601900000055111;21
35060190;8090100;GENODED1DKD;DE86350601900008090100;21
32060362;3333;GENODED1HTK;DE47320603620000003333;21
32060362;4444;GENODED1HTK;DE23320603620000004444;21
25050299;17095;SPKHDE2HXXX;DE69250501800000017095;19
51210800;2600123456;SOGEDEFFXXX;DE02512108000260123456;18
51210800;1410123456;SOGEDEFFXXX;DE35512108000141123456;18
13091054;1718190;GENODEF1HST;DE47130910540001718190;21
13091054;22000225;GENODEF1HST;DE57130910540022000225;21
13091054;49902271;GENODEF1HST;DE68130910540049902271;21
13091054;49902280;GENODEF1HST;DE19130910540049902280;21
13091054;101680029;GENODEF1HST;DE07130910540101680029;21
13091054;104200028;GENODEF1HST;DE05130910540104200028;21
13091054;106200025;GENODEF1HST;DE83130910540106200025;21
13091054;108000171;GENODEF1HST;DE28130910540108000171;21
13091054;108000279;GENODEF1HST;DE22130910540108000279;21
13091054;108001364;GENODEF1HST;DE21130910540108001364;21
13091054;108001801;GENODEF1HST;DE56130910540108001801;21
13091054;108002514;GENODEF1HST;DE11130910540108002514;21
13091054;300008542;GENODEF1HST;DE24130910540300008542;21
13091054;9130099995;GENODEF1HST;DE69130910549130099995;21
13091054;9130500002;GENODEF1HST;DE54130910549130500002;21
13091054;9131100008;GENODEF1HST;DE56130910549131100008;21
13091054;9131600000;GENODEF1HST;DE53130910549131600000;21
13091054;9131610006;GENODEF1HST;DE36130910549131610006;21
13091054;9132200006;GENODEF1HST;DE55130910549132200006;21
13091054;9132400005;GENODEF1HST;DE72130910549132400005;21
13091054;9132600004;GENODEF1HST;DE89130910549132600004;21
13091054;9132700017;GENODEF1HST;DE24130910549132700017;21
13091054;9132700025;GENODEF1HST;DE02130910549132700025;21
13091054;9132700033;GENODEF1HST;DE77130910549132700033;21
13091054;9132700041;GENODEF1HST;DE55130910549132700041;21
13091054;9133200700;GENODEF1HST;DE85130910549133200700;21
13091054;9133200735;GENODEF1HST;DE13130910549133200735;21
13091054;9133200743;GENODEF1HST;DE88130910549133200743;21
13091054;9133200751;GENODEF1HST;DE66130910549133200751;21
13091054;9133200786;GENODEF1HST;DE91130910549133200786;21
13091054;9133200808;GENODEF1HST;DE79130910549133200808;21
13091054;9133200816;GENODEF1HST;DE57130910549133200816;21
13091054;9133200824;GENODEF1HST;DE35130910549133200824;21
13091054;9133200832;GENODEF1HST;DE13130910549133200832;21
13091054;9136700003;GENODEF1HST;DE08130910549136700003;21
13091054;9177300010;GENODEF1HST;DE20130910549177300010;21
13091054;9177300060;GENODEF1HST;DE28130910549177300060;21
13091054;9198100002;GENODEF1HST;DE69130910549198100002;21
13091054;9198200007;GENODEF1HST;DE26130910549198200007;21
13091054;9198200104;GENODEF1HST;DE26130910549198200104;21
13091054;9198300001;GENODEF1HST;DE86130910549198300001;21
13091054;9331300141;GENODEF1HST;DE35130910549331300141;21
13091054;9331300150;GENODEF1HST;DE83130910549331300150;21
13091054;9331401010;GENODEF1HST;DE41130910549331401010;21
13091054;9331401061;GENODEF1HST;DE22130910549331401061;21
13091054;9349010000;GENODEF1HST;DE95130910549349010000;21
13091054;9349100000;GENODEF1HST;DE42130910549349100000;21
13091054;9360500001;GENODEF1HST;DE27130910549360500001;21
13091054;9364902007;GENODEF1HST;DE62130910549364902007;21
13091054;9366101001;GENODEF1HST;DE04130910549366101001;21
13091054;9366104000;GENODEF1HST;DE26130910549366104000;21
13091054;9370620030;GENODEF1HST;DE96130910549370620030;21
13091054;9370620080;GENODEF1HST;DE07130910549370620080;21
13091054;9371900010;GENODEF1HST;DE87130910549371900010;21
13091054;9373600005;GENODEF1HST;DE40130910549373600005;21
13091054;9402900021;GENODEF1HST;DE83130910549402900021;21
13091054;9605110000;GENODEF1HST;DE94130910549605110000;21
13091054;9614001000;GENODEF1HST;DE52130910549614001000;21
13091054;9615000016;GENODEF1HST;DE89130910549615000016;21
13091054;9615010003;GENODEF1HST;DE03130910549615010003;21
13091054;9618500036;GENODEF1HST;DE53130910549618500036;21
13091054;9631020000;GENODEF1HST;DE11130910549631020000;21
13091054;9632600051;GENODEF1HST;DE10130910549632600051;21
13091054;9632600060;GENODEF1HST;DE58130910549632600060;21
13091054;9635000012;GENODEF1HST;DE70130910549635000012;21
13091054;9635000020;GENODEF1HST;DE48130910549635000020;21
13091054;9635701002;GENODEF1HST;DE77130910549635701002;21
13091054;9636010003;GENODEF1HST;DE20130910549636010003;21
13091054;9636013002;GENODEF1HST;DE42130910549636013002;21
13091054;9636016001;GENODEF1HST;DE64130910549636016001;21
13091054;9636018004;GENODEF1HST;DE12130910549636018004;21
13091054;9636019000;GENODEF1HST;DE86130910549636019000;21
13091054;9636022001;GENODEF1HST;DE54130910549636022001;21
13091054;9636024004;GENODEF1HST;DE02130910549636024004;21
13091054;9636025000;GENODEF1HST;DE76130910549636025000;21
13091054;9636027003;GENODEF1HST;DE24130910549636027003;21
13091054;9636028000;GENODEF1HST;DE71130910549636028000;21
13091054;9636045001;GENODEF1HST;DE48130910549636045001;21
13091054;9636048000;GENODEF1HST;DE70130910549636048000;21
13091054;9636051001;GENODEF1HST;DE38130910549636051001;21
13091054;9636053004;GENODEF1HST;DE83130910549636053004;21
13091054;9636120003;GENODEF1HST;DE63130910549636120003;21
13091054;9636140004;GENODEF1HST;DE35130910549636140004;21
13091054;9636150000;GENODEF1HST;DE94130910549636150000;21
13091054;9636320002;GENODEF1HST;DE80130910549636320002;21
13091054;9636700000;GENODEF1HST;DE18130910549636700000;21
13091054;9638120000;GENODEF1HST;DE44130910549638120000;21
13091054;9639401100;GENODEF1HST;DE59130910549639401100;21
13091054;9639801001;GENODEF1HST;DE93130910549639801001;21
13091054;9670010004;GENODEF1HST;DE39130910549670010004;21
13091054;9680610000;GENODEF1HST;DE05130910549680610000;21
13091054;9705010002;GENODEF1HST;DE89130910549705010002;21
13091054;9705403004;GENODEF1HST;DE59130910549705403004;21
13091054;9705404000;GENODEF1HST;DE36130910549705404000;21
13091054;9705509996;GENODEF1HST;DE32130910549705509996;21
13091054;9707901001;GENODEF1HST;DE83130910549707901001;21
13091054;9736010000;GENODEF1HST;DE48130910549736010000;21
13091054;9780100050;GENODEF1HST;DE34130910549780100050;21
13091054;9791000030;GENODEF1HST;DE29130910549791000030;21
13091054;9990001003;GENODEF1HST;DE86130910549990001003;21
13091054;9990001100;GENODEF1HST;DE86130910549990001100;21
13091054;9990002000;GENODEF1HST;DE36130910549990002000;21
13091054;9990004002;GENODEF1HST;DE11130910549990004002;21
13091054;9991020001;GENODEF1HST;DE26130910549991020001;21
13091054;9991040002;GENODEF1HST;DE95130910549991040002;21
13091054;9991060003;GENODEF1HST;DE67130910549991060003;21
13091054;9999999993;GENODEF1HST;DE84130910549999999993;21
13091054;9999999994;GENODEF1HST;DE57130910549999999994;21
13091054;9999999995;GENODEF1HST;DE30130910549999999995;21
13091054;9999999996;GENODEF1HST;DE03130910549999999996;21
13091054;9999999997;GENODEF1HST;DE73130910549999999997;21
13091054;9999999998;GENODEF1HST;DE46130910549999999998;21
13091054;9999999999;GENODEF1HST;DE19130910549999999999;21
54520071;6790149813;HYVEDEMM483;DE77545201946790149813;19
54520071;54520071;HYVEDEMM483;;0
10120760;897;HYVEDEMM488;;0
79020325;1210100047;HYVEDEMM419;DE70762200731210100047;19
70020001;1210100047;HYVEDEMM419;DE70762200731210100047;19
76020214;1210100047;HYVEDEMM419;DE70762200731210100047;19
76220073;1210100047;HYVEDEMM419;DE70762200731210100047;1
63020450;44613352;;;-124
66020150;1457032621;HYVEDEMM475;DE92660202861457032621;19
79020325;1210100040;HYVEDEMM455;;0
76220073;1210100047;HYVEDEMM419;DE70762200731210100047;1
66020286;1457032621;HYVEDEMM475;DE92660202861457032621;1
76220073;3200000012;HYVEDEMM453;DE06710221823200000012;19
10020890;5951950;HYVEDEMM488;DE07100208900005951950;1
10020890;897;HYVEDEMM488;;0
85020086;847321750;;;-124
70020270;2950219435;HYVEDEMMXXX;DE76700202702950219435;1
70020270;1457032621;HYVEDEMM475;DE92660202861457032621;19
70020270;897;HYVEDEMMXXX;DE55700202700000000897;1
70020270;847321750;HYVEDEMMXXX;DE36700202700847321750;1
72020270;847321750;;;-4
70020270;22222;HYVEDEMMXXX;DE11700202705803435253;18
70020270;1111111;HYVEDEMMXXX;DE88700202700039908140;18
70020270;94;HYVEDEMMXXX;DE83700202700002711931;18
70020270;7777777;HYVEDEMMXXX;DE40700202705800522694;18
70020270;55555;HYVEDEMMXXX;DE61700202705801800000;18
60020290;1320815432;HYVEDEMM473;DE69600202901320815432;1
60020290;1457032621;HYVEDEMM475;DE92660202861457032621;19
60020290;5951950;HYVEDEMM473;DE67600202900005951950;1
60020290;847321750;;;-124
60020290;500500500;HYVEDEMM473;DE82600202904340111112;18
60020290;502;HYVEDEMM473;DE28600202904340118001;18
79020076;1050958422;HYVEDEMM455;DE42790200761050958422;1
79020076;1320815432;HYVEDEMM473;DE69600202901320815432;19
79020076;5951950;HYVEDEMM455;DE56790200760005951950;1
79020076;847321750;;;-124
79020076;9696;HYVEDEMM455;DE29790200761490196966;18
20050000;101105;HSHNDEHHXXX;DE32210500000101105000;20
21050000;840132;HSHNDEHHXXX;DE91210500000840132000;18
23050000;631879;HSHNDEHHXXX;DE81210500000631879000;20
21050000;101105;HSHNDEHHXXX;DE32210500000101105000;18
20050000;840132;HSHNDEHHXXX;DE91210500000840132000;20
23050000;631879;HSHNDEHHXXX;DE81210500000631879000;20
21050000;101105;HSHNDEHHXXX;DE32210500000101105000;18
21050000;631879;HSHNDEHHXXX;DE81210500000631879000;18
20050000;30000025;HSHNDEHHXXX;DE75210500000030000025;19
23050000;51300528;HSHNDEHHXXX;DE76210500000051300528;19
21050000;30000025;HSHNDEHHXXX;DE75210500000030000025;1
21050000;100271010;HSHNDEHHXXX;DE85210500000100271010;1
21050000;319574000;HSHNDEHHXXX;DE55210500000319574000;1
20050000;100271010;HSHNDEHHXXX;DE85210500000100271010;19
21050000;319574000;HSHNDEHHXXX;DE55210500000319574000;1
20050000;100271010;HSHNDEHHXXX;DE85210500000100271010;19
23050000;319574000;HSHNDEHHXXX;DE55210500000319574000;19
21050000;3060000035;HSHNDEHHXXX;DE13210500003060000035;1
21050000;3070010313;HSHNDEHHXXX;DE09210500003070010313;1
21050000;1100001928;HSHNDEHHXXX;DE51210500001100001928;1
20050000;3060000035;HSHNDEHHXXX;DE13210500003060000035;19
23050000;3070010313;HSHNDEHHXXX;DE09210500003070010313;19
21050000;1100001928;HSHNDEHHXXX;DE51210500001100001928;1
21050000;7052000037;HSHNDEHHXXX;DE82210500007052000037;1
21050000;7053001166;HSHNDEHHXXX;DE07210500007053001166;1
20050000;7052000037;HSHNDEHHXXX;DE82210500007052000037;19
23050000;7053001166;HSHNDEHHXXX;DE07210500007053001166;19
21050000;7052000037;HSHNDEHHXXX;DE82210500007052000037;1
21050000;8553002045;HSHNDEHHXXX;DE20210500008553002045;1
21050000;8553009087;HSHNDEHHXXX;DE06210500008553009087;1
20050000;8553002045;HSHNDEHHXXX;DE20210500008553002045;19
23050000;8553009087;HSHNDEHHXXX;DE06210500008553009087;19
21050000;8553002045;HSHNDEHHXXX;DE20210500008553002045;1
21050000;9000010040;HSHNDEHHXXX;DE37210500009000010040;1
21050000;9000906093;HSHNDEHHXXX;DE55210500009000906093;1
20050000;9000010040;HSHNDEHHXXX;DE37210500009000010040;19
23050000;9000906093;HSHNDEHHXXX;DE55210500009000906093;19
21050000;9000010040;HSHNDEHHXXX;DE37210500009000010040;1
20050000;91399;;;-124
20050000;29991399;;;-124
20050000;99991399;;;-124
20050000;992291399;;;-124
20050000;2992291399;;;-124
20050000;8492291399;;;-124
20050000;8992291399;;;-124
21050000;1;;;-124
21050000;900000;;;-124
21050000;60000000;;;-124
21050000;900000000;;;-124
21050000;2000000000;;;-124
21050000;7100000000;;;-124
21050000;8600000000;;;-124
23050000;99999;;;-124
23050000;29999999;;;-124
23050000;99999999;;;-124
23050000;999999999;;;-124
23050000;2999999999;;;-124
23050000;8499999999;;;-124
23050000;8999999999;;;-124
20110700;123456;BOTKDEDXXXX;DE41300107000000123456;19
30010700;654321;BOTKDEDXXXX;DE85300107000000654321;1
26691213;28590075;GENODEF1LER;DE68285900750028590075;19
28591579;28590075;GENODEF1LER;DE68285900750028590075;19
25090300;28590075;GENODEF1LER;DE68285900750028590075;19
25621327;5581286156;OLBODEH2XXX;DE21280200505581286156;19
26520017;7415406394;OLBODEH2XXX;DE53280200507415406394;19
26521703;8346392754;OLBODEH2XXX;DE34280200508346392754;19
26522319;4808378657;OLBODEH2XXX;DE94280200504808378657;19
26620010;1654279733;OLBODEH2XXX;DE28280200501654279733;19
26621413;8056221843;OLBODEH2XXX;DE97280200508056221843;19
26720028;1593727939;OLBODEH2XXX;DE35280200501593727939;19
28021002;2795633312;OLBODEH2XXX;DE24280200502795633312;19
28021301;6919455381;OLBODEH2XXX;DE64280200506919455381;19
28021504;5285238126;OLBODEH2XXX;DE94280200505285238126;19
28021623;2872371660;OLBODEH2XXX;DE51280200502872371660;19
28021705;5810643662;OLBODEH2XXX;DE19280200505810643662;19
28021906;4743574815;OLBODEH2XXX;DE77280200504743574815;19
28022015;2400750274;OLBODEH2XXX;DE41280200502400750274;19
28022412;6924721136;OLBODEH2XXX;DE04280200506924721136;19
28022511;2880486230;OLBODEH2XXX;DE76280200502880486230;19
28022620;6711423146;OLBODEH2XXX;DE49280200506711423146;19
28022822;3110425006;OLBODEH2XXX;DE93280200503110425006;19
28023224;1572825628;OLBODEH2XXX;DE39280200501572825628;19
28023325;9875317178;OLBODEH2XXX;DE80280200509875317178;19
28220026;7676767220;OLBODEH2XXX;DE88280200507676767220;19
28222208;6184087281;OLBODEH2XXX;DE34280200506184087281;19
28222621;6727019997;OLBODEH2XXX;DE96280200506727019997;19
28320014;6721382733;OLBODEH2XXX;DE32280200506721382733;19
28321816;4177138723;OLBODEH2XXX;DE95280200504177138723;19
28420007;6166075948;OLBODEH2XXX;DE17280200506166075948;19
28421030;8374531558;OLBODEH2XXX;DE73280200508374531558;19
28520009;2225214221;OLBODEH2XXX;DE25280200502225214221;19
28521518;6812269646;OLBODEH2XXX;DE24280200506812269646;19
29121731;6680524302;OLBODEH2XXX;DE64280200506680524302;19
68051310;6015002;SOLADES1STF;DE17680523280006015002;19
62220000;62220000;GENODEFFXXX;DE96500604000000011404;20
62220000;1234567890;GENODEFFXXX;DE96500604000000011404;20
10000000;29121731;;;-124
10000000;50462000;MARKDEF1100;DE08100000000050462000;1
10000000;50469999;MARKDEF1100;DE54100000000050469999;1
10000000;12300578;;;-124
60651070;868;PZHSDE66XXX;DE49666500850000000868;19
60651070;12602;PZHSDE66XXX;DE33666500850000012602;19
68050101;202;FRSPDE66XXX;DE51680501010002282022;18
50210130;1325547;ESSEDE5FXXX;DE87502101300001325547;19
50210131;1325547;ESSEDE5FXXX;DE25502101310001325547;19
50210132;1325547;ESSEDE5FXXX;DE60502101320001325547;19
50210133;1325547;ESSEDE5FXXX;DE95502101330001325547;19
50210134;1325547;ESSEDE5FXXX;DE33502101340001325547;19
50210135;1325547;ESSEDE5FXXX;DE68502101350001325547;19
50210136;1325547;ESSEDE5FXXX;DE06502101360001325547;19
50210137;1325547;ESSEDE5FXXX;DE41502101370001325547;19
50210138;1325547;ESSEDE5FXXX;DE76502101380001325547;19
10120600;5239525866;GEMKDE21BER;DE65101206005239525866;1
25020600;9429742495;GEMKDE2HXXX;DE72250206009429742495;1
10033300;10643662;SCFBDE33XXX;DE82100333001064366200;18
20133300;43574815;SCFBDE33XXX;DE49201333004357481500;18
36033300;40750274;SCFBDE33XXX;DE23360333004075027400;18
50033300;24721136;SCFBDE33XXX;DE10500333002472113600;18
55033300;80486230;SCFBDE33XXX;DE81550333008048623000;18
60133300;11423146;SCFBDE33XXX;DE11601333001142314600;18
70133300;10425006;SCFBDE33XXX;DE86701333001042500600;18
86033300;72825628;SCFBDE33XXX;DE38860333007282562800;18
10033300;120643662;SCFBDE33XXX;DE73100333000120643662;1
20133300;334574815;SCFBDE33XXX;DE91201333000334574815;1
36033300;750274;SCFBDE33XXX;DE39360333000000750274;1
50033300;721136;SCFBDE33XXX;DE36500333000000721136;1
55033300;486230;SCFBDE33XXX;DE28550333000000486230;1
60133300;13146;SCFBDE33XXX;DE63601333000000013146;1
70133300;425006;SCFBDE33XXX;DE61701333000000425006;1
86033300;282528;SCFBDE33XXX;DE83860333000000282528;1
10033300;5810643662;SCFBDE33XXX;DE74100333005810643662;1
20133300;4743574815;SCFBDE33XXX;DE25201333004743574815;1
36033300;2400750274;SCFBDE33XXX;DE28360333002400750274;1
50033300;6924721136;SCFBDE33XXX;DE29500333006924721136;1
55033300;2880486230;SCFBDE33XXX;DE73550333002880486230;1
60133300;6711423146;SCFBDE33XXX;DE64601333006711423146;1
70133300;3110425006;SCFBDE33XXX;DE52701333003110425006;1
86033300;1572825628;SCFBDE33XXX;DE37860333001572825628;1
10010010;73245108;PBNKDEFF100;DE08100100100073245108;1
10010010;73395105;PBNKDEFF100;DE33100100100073395105;1
14051462;0069000000;NOLADE21SNS;DE93140514620069000000;1
16050000;4636004502;WELADED1PMB;DE64160500004636004502;1
17052302;48074470;WELADED1UMX;DE33170523020048074470;1
18062678;4004469;GENODEF1FWA;DE48180626780004004469;1
20040000;225050400;COBADEFFXXX;DE35200400000225050400;1
20050550;1268118377;HASPDEHHXXX;DE97200505501268118377;1
20080000;620616500;DRESDEFF200;DE50200800000620616500;1
21050170;0000239314;NOLADE21KIE;DE35210501700000239314;1
21050170;844675;NOLADE21KIE;DE79210501700000844675;1
21566356;110060;GENODEF1SBR;DE93215663560000110060;1
25010030;749044307;PBNKDEFF250;DE04250100300749044307;1
25010030;763548309;PBNKDEFF250;DE59250100300763548309;1
25010030;904278305;PBNKDEFF250;DE66250100300904278305;1
25020600;2323222881;GEMKDE2HXXX;DE44250206002323222881;1
25020700;3100755555;HSTBDEH1HAN;DE91250207003100755555;1
25050180;19968;SPKHDE2HXXX;DE98250501800000019968;1
30050000;632935;WELADEDDXXX;DE09300500000000632935;1
32250050;236075;WELADED1GOC;DE73322500500000236075;1
36010043;319310430;PBNKDEFF360;DE07360100430319310430;1
36010043;444444431;PBNKDEFF360;DE38360100430444444431;1
36080080;429090203;DRESDEFF360;DE73360800800429090203;1
37010050;277501502;PBNKDEFF370;DE97370100500277501502;1
37010050;285526507;PBNKDEFF370;DE70370100500285526507;1
37010050;313753507;PBNKDEFF370;DE70370100500313753507;1
37010050;33323502;PBNKDEFF370;DE16370100500033323502;1
37010050;38522505;PBNKDEFF370;DE97370100500038522505;1
37010050;491830508;PBNKDEFF370;DE68370100500491830508;1
37050299;184004087;COKSDE33XXX;DE48370502990184004087;1
37060193;122122;GENODED1PAX;DE23370601930000122122;1
37060193;19963012;GENODED1PAX;DE27370601930019963012;1
37070024;781200100;DEUTDEDBKOE;DE69370700240781200100;1
38070724;143867000;DEUTDEDBXXX;DE91380707240143867000;1
40060265;3161600;GENODEM1DKM;DE17400602650003161600;1
44010046;266722467;PBNKDEFF440;DE68440100460266722467;1
44040037;366026300;COBADEFFXXX;DE09440400370366026300;1
44080050;771220000;DRESDEFF440;DE50440800500771220000;1
45070024;210550005;DEUTDEDB450;DE72450700240210550005;1
46040033;891695900;COBADEFFXXX;DE98460400330891695900;1
46262456;102484800;GENODEM1HUL;DE22462624560102484800;1
50010060;106728602;PBNKDEFFXXX;DE97500100600106728602;1
50010060;283557609;PBNKDEFFXXX;DE73500100600283557609;1
50010060;301230605;PBNKDEFFXXX;DE20500100600301230605;1
50010517;782919930;INGDDEFFXXX;DE19500105170782919930;1
50080000;710481900;DRESDEFFXXX;DE36500800000710481900;1
50190000;500130598;FFVBDEFFXXX;DE42501900000500130598;1
50850150;639630;HELADEF1DAS;DE29508501500000639630;1
50950068;1440106;HELADEF1BEN;DE27509500680001440106;1
50951469;10324037;HELADEF1HEP;DE02509514690010324037;1
50951469;13116620;HELADEF1HEP;DE10509514690013116620;1
50991400;4138406;;;-4
50991400;5004403;;;-4
51140029;3700739;COBADEFFXXX;DE32511400290370073900;18
51190000;627003;GENODE51LIM;DE31511900000000627003;1
54050220;100984855;MALADE51KLK;DE61540502200100984855;1
54051990;120006895;MALADE51ROK;DE63540519900120006895;1
54510067;146201675;PBNKDEFF545;DE63545100670146201675;1
54510067;149311676;PBNKDEFF545;DE26545100670149311676;1
54510067;158480675;PBNKDEFF545;DE65545100670158480675;1
54510067;159025677;PBNKDEFF545;DE08545100670159025677;1
54510067;17764674;PBNKDEFF545;DE08545100670017764674;1
54510067;194067673;PBNKDEFF545;DE42545100670194067673;1
54510067;216914677;PBNKDEFF545;DE09545100670216914677;1
54510067;35486679;PBNKDEFF545;DE83545100670035486679;1
54510067;6432676;PBNKDEFF545;DE55545100670006432676;1
54510067;73144675;PBNKDEFF545;DE25545100670073144675;1
54510067;76910671;PBNKDEFF545;DE32545100670076910671;1
54520194;3930184682;HYVEDEMM483;DE21545201943930184682;1
54540033;2068609;COBADEFFXXX;DE56545400330206860900;18
54550010;8856296;LUHSDE6AXXX;DE11545500100008856296;1
54550010;978700;LUHSDE6AXXX;DE02545500100000978700;1
54550120;139691;MALADE51LUH;DE29545501200000139691;1
54550120;189233;MALADE51LUH;DE25545501200000189233;1
54550120;1928183;MALADE51LUH;DE61545501200001928183;1
54561310;815381;GENODE61LBS;DE26545613100000815381;1
54570024;1546019;DEUTDEDB545;DE64545700240154601900;18
54580020;103790000;DRESDEFF545;DE02545800200103790000;1
54651240;1009510635;MALADE51DKH;DE33546512401009510635;1
54651240;117127225;MALADE51DKH;DE49546512400117127225;1
54651240;1406893014;MALADE51DKH;DE30546512401406893014;1
54651240;380105;MALADE51DKH;DE52546512400000380105;1
54690623;105186323;DAAEDEDDXXX;DE73300606010105186323;19
54761411;992526;GENODE61SFS;DE25547614110000992526;1
54790000;20164700;GENODE61SPE;DE35547900000020164700;1
54790000;350010;GENODE61SPE;DE52547900000000350010;1
54850010;135062560;SOLADES1SUW;DE87548500100135062560;1
54850010;135302842;SOLADES1SUW;DE27548500100135302842;1
54851440;1000033165;MALADE51KAD;DE11548514401000033165;1
54851440;20000030;MALADE51KAD;DE40548514400020000030;1
54851440;20000444;MALADE51KAD;DE17548514400020000444;1
54851440;26001594;MALADE51KAD;DE95548514400026001594;1
54851440;26012757;MALADE51KAD;DE73548514400026012757;1
54851440;26014035;MALADE51KAD;DE02548514400026014035;1
54851440;26028399;MALADE51KAD;DE77548514400026028399;1
54862500;102804026;GENODE61SUW;DE16548625000102804026;1
54862500;45500;GENODE61SUW;DE82548625000000045500;1
54862500;781355;GENODE61SUW;DE22548625000000781355;1
55090500;100161711;GENODEF1S01;DE92550905000100161711;1
55090500;110581974;GENODEF1S01;DE36550905000110581974;1
55090500;204568;GENODEF1S01;DE22550905000000204568;1
55090500;220427;GENODEF1S01;DE84550905000000220427;1
55090500;3360091;GENODEF1S01;DE75550905000003360091;1
55090500;3463494;GENODEF1S01;DE48550905000003463494;1
55090500;3695549;GENODEF1S01;DE84550905000003695549;1
55090500;581974;GENODEF1S01;DE07550905000000581974;1
55090500;731516;GENODEF1S01;DE95550905000000731516;1
55350010;4302379;MALADE51WOR;DE05553500100004302379;1
55350010;7270086;MALADE51WOR;DE27553500100007270086;1
55390000;6060005;GENODE61WO1;DE32553900000006060005;1
58570048;506071;DEUTDE5M585;DE46585700480050607100;18
60010070;267474702;PBNKDEFF600;DE23600100700267474702;1
60010070;276606707;PBNKDEFF600;DE91600100700276606707;1
60040071;523308501;COBADEFFXXX;DE50600400710523308501;1
60040071;624080805;COBADEFFXXX;DE73600400710624080805;1
60050101;1018668;SOLADEST600;DE80600501010001018668;1
60050101;2247067;SOLADEST600;DE32600501010002247067;1
60090800;1236650;GENODEF1S02;DE61600908000001236650;1
60090800;204862;GENODEF1S02;DE34600908000000204862;1
60090800;339515;GENODEF1S02;DE60600908000000339515;1
60350130;6554;BBKRDE6BXXX;DE16603501300000006554;1
64390130;11149000;GENODES1TUT;DE52643901300011149000;1
66010075;142321756;PBNKDEFF660;DE51660100750142321756;1
66010075;321052756;PBNKDEFF660;DE53660100750321052756;1
66010075;354826753;PBNKDEFF660;DE07660100750354826753;1
66010075;363266753;PBNKDEFF660;DE70660100750363266753;1
66010075;382734759;PBNKDEFF660;DE21660100750382734759;1
66010075;94089759;PBNKDEFF660;DE73660100750094089759;1
66050101;10543361;KARSDE66XXX;DE07660501010010543361;1
66050101;22636104;KARSDE66XXX;DE80660501010022636104;1
66090800;1278797;GENODE61BBB;DE43660908000001278797;1
66090800;1486101;GENODE61BBB;DE26660908000001486101;1
66090800;1581058;GENODE61BBB;DE91660908000001581058;1
66090800;2768836;GENODE61BBB;DE31660908000002768836;1
66090800;3042871;GENODE61BBB;DE52660908000003042871;1
66090800;3330036;GENODE61BBB;DE98660908000003330036;1
66090800;3668657;GENODE61BBB;DE66660908000003668657;1
66090800;4334671;GENODE61BBB;DE33660908000004334671;1
66090800;4346327;GENODE61BBB;DE86660908000004346327;1
66090800;5012287;GENODE61BBB;DE56660908000005012287;1
67010111;2384856100;ESSEDE5F670;DE64670101112384856100;1
67040031;317450500;COBADEFFXXX;DE94670400310317450500;1
67040031;352029300;COBADEFFXXX;DE16670400310352029300;1
67040031;366096600;COBADEFFXXX;DE93670400310366096600;1
67040031;3782323;COBADEFFXXX;DE59670400310378232300;18
67040031;6060065;COBADEFFXXX;DE61670400310606006500;18
67050101;3136892;;;-4
67050101;3152386;;;-4
67050101;3245362;;;-4
67050101;4055976;;;-4
67050101;4199105;;;-4
67050101;4298261;;;-4
67050101;4704011;;;-4
67050101;7218381;;;-4
67050101;7566284;;;-4
67050101;7692700;;;-4
67050101;7863764;;;-4
67050101;7882665;;;-4
67050101;7890452;;;-4
67050101;7951056;;;-4
67050505;33168381;MANSDE66XXX;DE59670505050033168381;1
67050505;34006865;MANSDE66XXX;DE15670505050034006865;1
67050505;34704015;MANSDE66XXX;DE09670505050034704015;1
67050505;37381870;MANSDE66XXX;DE75670505050037381870;1
67050505;37904074;MANSDE66XXX;DE02670505050037904074;1
67050505;68010446;MANSDE66XXX;DE83670505050068010446;1
67050505;73201888;MANSDE66XXX;DE29670505050073201888;1
67052385;15184523;;;-4
67060031;35182500;GENODE61MA3;DE74670600310035182500;1
67070010;101063;DEUTDESMXXX;DE61670700100010106300;18
67070010;6074066;DEUTDESMXXX;DE23670700100607406600;18
67070010;6074454;DEUTDESMXXX;DE23670700100607445400;18
67070010;7106289;DEUTDESMXXX;DE80670700100710628900;18
67070010;7654312;DEUTDESMXXX;DE36670700100765431200;18
67070024;243451;DEUTDEDBMAN;DE35670700240024345100;18
67070024;6200471;DEUTDEDBMAN;DE58670700240620047100;18
67070024;7849250;DEUTDEDBMAN;DE14670700240784925000;18
67080050;4701862900;DRESDEFF670;DE26670800504701862900;1
67080050;677332100;DRESDEFF670;DE92670800500677332100;1
67080050;712615300;DRESDEFF670;DE04670800500712615300;1
67080050;741259900;DRESDEFF670;DE84670800500741259900;1
67080050;744499000;DRESDEFF670;DE69670800500744499000;1
67090000;2310007;GENODE61MA2;DE67670900000002310007;1
67090000;2420708;GENODE61MA2;DE98670900000002420708;1
67090000;2743108;GENODE61MA2;DE78670900000002743108;1
67090000;3190706;GENODE61MA2;DE65670900000003190706;1
67090000;3830608;GENODE61MA2;DE60670900000003830608;1
67090000;4897900;GENODE61MA2;DE33670900000004897900;1
67090000;5481406;GENODE61MA2;DE14670900000005481406;1
67090000;6502300;GENODE61MA2;DE75670900000006502300;1
67090000;760307;GENODE61MA2;DE47670900000000760307;1
67090000;779105;GENODE61MA2;DE05670900000000779105;1
67090000;8449600;GENODE61MA2;DE79670900000008449600;1
67092300;31558808;GENODE61WNM;DE73670923000031558808;1
67210111;2080918600;ESSEDE5F672;DE39672101112080918600;1
67230000;4039634044;MLPBDE61XXX;DE35672300004039634044;1
67250020;25123239;SOLADES1HDB;DE95672500200025123239;1
67250020;3510921;SOLADES1HDB;DE81672500200003510921;1
67250020;4318919;SOLADES1HDB;DE17672500200004318919;1
67270003;454009;DEUTDESM672;DE92672700030045400900;18
67292200;50767507;GENODE61WIE;DE34672922000050767507;1
70010080;30042806;PBNKDEFF700;DE88700100800030042806;1
70010080;626687800;PBNKDEFF700;DE27700100800626687800;1
70054306;532713;BYLADEM1WOR;DE33700543060000532713;1
70070010;852616202;DEUTDEMMXXX;DE34700700100852616202;1
70070024;531869601;DEUTDEDBMUC;DE12700700240531869601;1
70091600;5147522;GENODEF1DSS;DE46700916000005147522;1
71061009;22284;GENODEF1AOE;DE84710610090000022284;1
71152570;8737462;BYLADEM1MIB;DE05711525700008737462;1
72120078;5724414;HYVEDEMM426;DE33721200780005724414;1
73150000;247247;BYLADEM1MLM;DE91731500000000247247;1
74351310;616144;BYLADEM1DGF;DE62743513100000616144;1
75090300;103002721;GENODEF1M05;DE03750903000103002721;1
75090300;2152002;GENODEF1M05;DE63750903000002152002;1
75090300;51799;GENODEF1M05;DE23750903000000051799;1
75090300;58882;GENODEF1M05;DE66750903000000058882;1
76010085;78245851;PBNKDEFF760;DE72760100850078245851;1
76026000;2702164004;;;-124
76080040;621733300;DRESDEFF760;DE64760800400621733300;1
80053762;485065366;NOLADE21HAL;DE73800537620485065366;1
82020087;4063503;HYVEDEMM098;DE94820200870004063503;1
82054052;41010076;HELADEF1NOR;DE72820540520041010076;1
87096124;9072772692;GENODEF1MIW;DE35870961249072772692;1
20690500;556343;GENODEF1S11;DE33206905000000556343;1
30020900;1607761319;CMCIDEDDXXX;DE96300209001607761319;1
37020500;5379552220;BFSWDE33XXX;DE33370205005379552220;1
50010700;533472;DEGUDEFFXXX;DE10500107000000533472;1
70020270;345661;HYVEDEMMXXX;DE32700202700000345661;1
76060000;210850;GENODEFF760;DE06760600000000210850;1
14051462;0071433699;NOLADE21SNS;DE57140514620071433699;1
14051462;0046996983;NOLADE21SNS;DE08140514620046996983;1
14051462;0098138585;NOLADE21SNS;DE78140514620098138585;1
14051462;0083239121;NOLADE21SNS;DE28140514620083239121;1
14051462;0017801841;NOLADE21SNS;DE88140514620017801841;1
14051462;0062117328;NOLADE21SNS;DE25140514620062117328;1
14051462;0043949698;NOLADE21SNS;DE42140514620043949698;1
14051462;0098234702;NOLADE21SNS;DE57140514620098234702;1
14051462;0097151235;NOLADE21SNS;DE18140514620097151235;1
14051462;0021306093;NOLADE21SNS;DE54140514620021306093;1
15051732;0062316937;NOLADE21MST;DE15150517320062316937;1
15051732;0050945322;NOLADE21MST;DE05150517320050945322;1
15051732;0074926978;NOLADE21MST;DE72150517320074926978;1
15051732;0070921723;NOLADE21MST;DE52150517320070921723;1
15051732;0033094628;NOLADE21MST;DE90150517320033094628;1
15051732;0098610038;NOLADE21MST;DE76150517320098610038;1
15051732;0010516267;NOLADE21MST;DE34150517320010516267;1
15051732;0084530280;NOLADE21MST;DE66150517320084530280;1
15051732;0016834215;NOLADE21MST;DE26150517320016834215;1
15051732;0029840550;NOLADE21MST;DE21150517320029840550;1
17052302;0069295778;WELADED1UMX;DE31170523020069295778;1
17052302;0073355024;WELADED1UMX;DE10170523020073355024;1
17052302;0088014264;WELADED1UMX;DE09170523020088014264;1
17052302;0010973407;WELADED1UMX;DE34170523020010973407;1
17052302;0090304376;WELADED1UMX;DE23170523020090304376;1
17052302;0011781562;WELADED1UMX;DE96170523020011781562;1
17052302;0027358945;WELADED1UMX;DE39170523020027358945;1
17052302;0046727902;WELADED1UMX;DE23170523020046727902;1
17052302;0062076693;WELADED1UMX;DE34170523020062076693;1
17052302;0073160593;WELADED1UMX;DE07170523020073160593;1
80053572;0043939385;NOLADE21DES;DE38800535720043939385;1
80053572;0052621053;NOLADE21DES;DE61800535720052621053;1
80053572;0048723364;NOLADE21DES;DE36800535720048723364;1
80053572;0011294877;NOLADE21DES;DE02800535720011294877;1
80053572;0096147488;NOLADE21DES;DE98800535720096147488;1
80053572;0013675307;NOLADE21DES;DE10800535720013675307;1
80053572;0062235244;NOLADE21DES;DE59800535720062235244;1
80053572;0019704658;NOLADE21DES;DE14800535720019704658;1
80053572;0017943233;NOLADE21DES;DE68800535720017943233;1
80053572;0072835403;NOLADE21DES;DE86800535720072835403;1
82054052;0052219981;HELADEF1NOR;DE88820540520052219981;1
82054052;0095627360;HELADEF1NOR;DE57820540520095627360;1
82054052;0064356764;HELADEF1NOR;DE10820540520064356764;1
82054052;0087367255;HELADEF1NOR;DE07820540520087367255;1
82054052;0027936129;HELADEF1NOR;DE61820540520027936129;1
82054052;0096978023;HELADEF1NOR;DE82820540520096978023;1
82054052;0052398174;HELADEF1NOR;DE77820540520052398174;1
82054052;0069999742;HELADEF1NOR;DE26820540520069999742;1
82054052;0094783775;HELADEF1NOR;DE88820540520094783775;1
82054052;0089769733;HELADEF1NOR;DE08820540520089769733;1
80053762;0894117043;NOLADE21HAL;DE59800537620894117043;1
80053762;0418866278;NOLADE21HAL;DE02800537620418866278;1
80053762;0780136839;NOLADE21HAL;DE14800537620780136839;1
80053762;0162098747;NOLADE21HAL;DE61800537620162098747;1
80053762;0361733017;NOLADE21HAL;DE65800537620361733017;1
80053762;0217818082;NOLADE21HAL;DE98800537620217818082;1
80053762;0950493119;NOLADE21HAL;DE77800537620950493119;1
80053762;0664777745;NOLADE21HAL;DE41800537620664777745;1
80053762;0338369533;NOLADE21HAL;DE47800537620338369533;1
80053762;0637508985;NOLADE21HAL;DE80800537620637508985;1
80053762;0356336198;NOLADE21HAL;DE02800537620356336198;1
80053762;0309534824;NOLADE21HAL;DE58800537620309534824;1
80053762;0133040659;NOLADE21HAL;DE39800537620133040659;1
80053762;0716411107;NOLADE21HAL;DE48800537620716411107;1
80053762;0663254125;NOLADE21HAL;DE81800537620663254125;1
80053762;0894508335;NOLADE21HAL;DE27800537620894508335;1
80053762;0111694222;NOLADE21HAL;DE14800537620111694222;1
80053762;0736556073;NOLADE21HAL;DE80800537620736556073;1
80053762;0725448439;NOLADE21HAL;DE46800537620725448439;1
80053762;0817853939;NOLADE21HAL;DE89800537620817853939;1
10000000;2002825743;;;-124
10010010;1082365500;PBNKDEFF100;DE78100100101082365500;1
10010010;4387692074;PBNKDEFF100;DE15100100104387692074;1
10010010;6138334814;PBNKDEFF100;DE08100100106138334814;1
10010010;9494125577;PBNKDEFF100;DE40100100109494125577;1
10010111;0662784826;ESSEDE5F100;DE13100101110662784826;1
10010222;5699890440;;;-124
10010424;9293812903;AARBDE5W100;DE83100104249293812903;1
10019610;9339047028;DXIADEBBXXX;DE37100196109339047028;1
10020200;1018798280;BHFBDEFF500;DE73500202001018798280;19
10020500;2182100387;BFSWDE33BER;DE18100205002182100387;1
10020890;0396198304;HYVEDEMM488;DE27100208900396198304;1
10030200;5396355299;BHYPDEB2XXX;DE58100302005396355299;1
10030400;2523971892;ABKBDEBBXXX;DE69100304002523971892;1
10030500;6145842321;LOEBDEBBXXX;DE91100305006145842321;1
10030600;4485055245;GENODEF1OGK;DE68100306004485055245;1
10030700;3660648959;DLGHDEB1XXX;DE43100307003660648959;1
10033300;6757421861;SCFBDE33XXX;DE04100333006757421861;1
10040000;0803667514;COBADEFFXXX;DE97100400000803667514;1
10040010;9591142015;COBADEFFXXX;DE61100400109591142015;1
10040048;0287586215;COBADEFFXXX;DE89100400480287586215;1
10040060;9366918348;COBADEFFXXX;DE93100400609366918348;1
10040061;6308990768;COBADEFFXXX;DE45100400616308990768;1
10040062;4175295281;COBADEFFXXX;DE46100400624175295281;1
10040063;1590071728;COBADEFFXXX;DE39100400631590071728;1
10040085;0357802899;;;-124
10045050;0328229013;;;-124
10050000;1006164653;BELADEBEXXX;DE22100500001006164653;1
10050005;8500005764;BELADEB1DB5;DE95100500058500005764;1
10050006;0110606422;BELADEB1DB6;DE60100500060110606422;1
10050006;1689193487;BELADEB1DB6;DE36100500061689193487;1
10050006;3312970281;BELADEB1DB6;DE74100500063312970281;1
10050006;5053481345;BELADEB1DB6;DE90100500065053481345;1
10050006;6694308731;BELADEB1DB6;DE24100500066694308731;1
10050006;9477456792;BELADEB1DB6;DE83100500069477456792;1
10050007;1003552162;BELADEB1DB7;DE94100500071003552162;1
10050007;2705325030;BELADEB1DB7;DE93100500072705325030;1
10050007;4454352173;BELADEB1DB7;DE14100500074454352173;1
10050007;6056491762;BELADEB1DB7;DE68100500076056491762;1
10050007;7780063380;BELADEB1DB7;DE38100500077780063380;1
10050007;9460891817;BELADEB1DB7;DE53100500079460891817;1
10050008;2155141913;BELADEB1DB8;DE52100500082155141913;1
10050020;1098027970;SKPADEB1XXX;DE78100500201098027970;1
10050021;7522915918;SKPADEB1HOM;DE04100500217522915918;1
10050500;9342467191;LBSODEB1BLN;DE12100505009342467191;1
10050600;1283347472;;;-124
10050999;7218312745;DGZFDEFFBER;DE14100509997218312745;1
10060198;7634777959;GENODED1PA6;DE37100601987634777959;1
10060237;1786337927;GENODEF1EDB;DE02100602371786337927;1
10061006;5860377751;GENODED1KDB;DE45100610065860377751;1
10070000;0003914678;DEUTDEBBXXX;DE59100700000391467800;18
10070024;0004630430;DEUTDEDBBER;DE44100700240463043000;18
10070100;0005949425;DEUTDEBB101;DE06100701000594942500;18
10070124;0006996599;DEUTDEDB101;DE44100701240699659900;18
10070848;0005339445;DEUTDEDB110;DE68100708480533944500;18
10077777;0003710233;NORSDE51XXX;DE83100777770371023300;18
10080000;0000585701;DRESDEFF100;DE24100800000058570100;18
10080000;0004620674;DRESDEFF100;DE76100800000004620674;1
10080005;0000934124;DRESDEFFI26;DE86100800050093412400;18
10080005;0007267929;DRESDEFFI26;DE77100800050007267929;1
10080006;0000943101;DRESDEF1S02;DE96100800060094310100;18
10080006;0004995522;DRESDEF1S02;DE79100800060004995522;1
10080055;0000452464;DRESDEFF112;DE83100800550045246400;18
10080055;0008326406;DRESDEFF112;DE21100800550008326406;1
10080057;0000109848;DRESDEFF114;DE58100800570010984800;18
10080057;0005342924;DRESDEFF114;DE67100800570005342924;1
10080085;4339400430;DRESDEFFI53;DE92100800854339400430;1
10080086;8960095974;DRESDEFFI71;DE81100800868960095974;1
10080087;4829639988;DRESDEFFI72;DE97100800874829639988;1
10080088;0000576438;DRESDEF1S03;DE08100800880057643800;18
10080088;0008098632;DRESDEF1S03;DE13100800880008098632;1
10080089;3295289965;DRESDEFFI73;DE51100800893295289965;1
10080900;0000309734;DRESDEFF199;DE64100809000030973400;18
10080900;0002726111;DRESDEFF199;DE11100809000002726111;1
10089260;7741336105;DRESDEFFI14;DE78100892607741336105;1
10089999;7686203247;DRESDEFFI99;DE87100899997686203247;1
10090000;9956247044;BEVODEBBXXX;DE23100900009956247044;1
10090300;5972538980;GENODEF1BSB;DE54100903005972538980;1
10090603;0000241946;DAAEDEDDXXX;DE18300606010000241946;19
10090603;1543668553;DAAEDEDDXXX;DE53300606011543668553;19
10090603;2043177920;DAAEDEDDXXX;DE74300606012043177920;19
10090603;2753352994;DAAEDEDDXXX;DE82300606012753352994;19
10090603;3307992914;DAAEDEDDXXX;DE21300606013307992914;19
10090603;3726760504;DAAEDEDDXXX;DE66300606013726760504;19
10090603;4338510754;DAAEDEDDXXX;DE25300606014338510754;19
10090603;4766446613;DAAEDEDDXXX;DE31300606014766446613;19
10090603;5775068875;DAAEDEDDXXX;DE76300606015775068875;19
10090603;6284617376;DAAEDEDDXXX;DE85300606016284617376;19
10090603;7022416310;DAAEDEDDXXX;DE28300606017022416310;19
10090603;7586005292;DAAEDEDDXXX;DE62300606017586005292;19
10090603;8025908736;DAAEDEDDXXX;DE24300606018025908736;19
10090603;8720603643;DAAEDEDDXXX;DE77300606018720603643;19
10090603;9138561052;DAAEDEDDXXX;DE54300606019138561052;19
10090603;9777101422;DAAEDEDDXXX;DE41300606019777101422;19
10090900;1090881498;GENODEF1P01;DE47100909001090881498;1
10110300;8917968764;MACODEB1XXX;DE40101103008917968764;1
10110400;6949422895;IBBBDEBBXXX;DE82101104006949422895;1
10110600;1025910388;QUBKDEBBXXX;DE67101106001025910388;1
10120100;1001021422;WELADED1WBB;DE04101201001001021422;1
10120600;1016581413;GEMKDE21BER;DE91101206001016581413;1
10120760;0399878092;;;-124
10120760;6417851982;HYVEDEMMXXX;DE86700202706417851982;19
10120800;2378047539;VONEDE33BLN;DE14101208002378047539;1
10130600;1596819482;ISBKDEFXBER;DE57101306001596819482;1
10130800;1245289867;BIWBDE33XXX;DE28101308001245289867;1
10220600;1709289358;SYBKDE22BER;DE83102206001709289358;1
10310600;4152847517;TRDADEBBXXX;DE93103106004152847517;1
12016836;7958158408;KFWIDEFF100;DE11120168367958158408;1
12030000;8611587125;BYLADEM1001;DE79120300008611587125;1
12030900;3578794139;MEFIDEMM100;DE42120309003578794139;1
12040000;0107592870;COBADEFFXXX;DE43120400000107592870;1
12050555;9535629132;NOLADE21DVS;DE59120505559535629132;1
12060000;7492807242;GENODEFF120;DE66120600007492807242;1
12070000;0002297299;DEUTDEBB160;DE90120700000229729900;18
12070024;0001825462;DEUTDEDB160;DE78120700240182546200;18
12070070;3779894562;DEUTDEFFVAC;DE52120700703779894562;1
12070088;4618007570;DEUTDEDBPAL;DE23120700884618007570;1
12080000;0000461659;DRESDEFF120;DE19120800000046165900;18
12080000;0007631475;DRESDEFF120;DE25120800000007631475;1
12090640;0000610321;DAAEDEDDXXX;DE79300606010000610321;19
12090640;2138847161;DAAEDEDDXXX;DE21300606012138847161;19
12090640;4271082225;DAAEDEDDXXX;DE06300606014271082225;19
12090640;5530706140;DAAEDEDDXXX;DE03300606015530706140;19
12090640;6686339786;DAAEDEDDXXX;DE95300606016686339786;19
12090640;7932024934;DAAEDEDDXXX;DE90300606017932024934;19
12090640;8599601446;DAAEDEDDXXX;DE68300606018599601446;19
12090640;9331278895;DAAEDEDDXXX;DE60300606019331278895;19
12096597;1014068946;GENODEF1S10;DE03120965971014068946;1
12096597;1656055792;GENODEF1S10;DE51120965971656055792;1
12096597;2475658365;GENODEF1S10;DE83120965972475658365;1
12096597;3264709507;GENODEF1S10;DE73120965973264709507;1
12096597;3948048860;GENODEF1S10;DE59120965973948048860;1
12096597;4704488393;GENODEF1S10;DE66120965974704488393;1
12096597;5478110025;GENODEF1S10;DE62120965975478110025;1
12096597;6216761305;GENODEF1S10;DE10120965976216761305;1
12096597;7048553394;GENODEF1S10;DE36120965977048553394;1
12096597;7818785716;GENODEF1S10;DE50120965977818785716;1
12096597;8511391911;GENODEF1S10;DE12120965978511391911;1
12096597;9333648680;GENODEF1S10;DE61120965979333648680;1
13000000;6384726070;;;-124
13010111;0383520401;ESSEDE5F130;DE98130101110383520401;1
13040000;0256486283;COBADEFFXXX;DE90130400000256486283;1
13050000;5672809849;NOLADE21ROS;DE64130500005672809849;1
13051042;1180292339;NOLADE21RUE;DE27130510421180292339;1
13051172;0010519154;TESTDEX9876;DE20130511720010519154;1
13051172;0090202818;TESTDEX9876;DE25130511720090202818;1
13061008;1076891004;GENODEF1WOG;DE15130610081076891004;1
13061028;2490114138;GENODEF1GW1;DE54130610282490114138;1
13061078;1804964675;GENODEF1HWI;DE77130610781804964675;1
13061088;4217622716;GENODEF1HWI;DE43130610784217622716;1
13061128;4593148378;GENODEF1DBR;DE87130611284593148378;1
13070000;0007466923;DEUTDEBRXXX;DE15130700000746692300;18
13070024;0008691065;DEUTDEDBROS;DE14130700240869106500;18
13080000;0000172881;DRESDEFF130;DE44130800000017288100;18
13080000;0004618881;DRESDEFF130;DE09130800000004618881;1
13090000;1549984933;GENODEF1HR1;DE18130900001549984933;1
13091054;4345794749;GENODEF1HST;DE07130910544345794749;1
13091084;2106473857;GENODEF1HWI;DE55130610782106473857;1
14000000;4973113140;;;-124
14040000;0821702830;COBADEFFXXX;DE45140400000821702830;1
14051000;2849731849;NOLADE21WIS;DE70140510002849731849;1
14051362;1387509442;NOLADE21PCH;DE05140513621387509442;1
14051462;2029815384;NOLADE21SNS;DE09140514622029815384;1
14052000;6399678380;NOLADE21LWL;DE75140520006399678380;1
14061308;4402870371;GENODEF1GUE;DE89140613084402870371;1
14061438;6955750610;GENODEF1GDB;DE37140614386955750610;1
14080000;0000610124;DRESDEFF140;DE73140800000061012400;18
14080000;0002060625;DRESDEFF140;DE69140800000002060625;1
14080011;0000691690;DRESDEFFI27;DE88140800110069169000;18
14080011;0005029554;DRESDEFFI27;DE74140800110005029554;1
14091464;6573190021;GENODEF1SN1;DE63140914646573190021;1
15000000;2892415266;;;-124
15040068;0149449142;COBADEFFXXX;DE31150400680149449142;1
15050100;3702000983;NOLADE21WRN;DE93150501003702000983;1
15050200;5971608926;NOLADE21NBS;DE20150502005971608926;1
15050400;4041131710;NOLADE21PSW;DE52150504004041131710;1
15050500;1361449558;NOLADE21GRW;DE88150505001361449558;1
15051732;1819935147;NOLADE21MST;DE40150517321819935147;1
15061618;4874460383;GENODEF1WRN;DE57150616184874460383;1
15061638;5508380678;GENODEF1ANK;DE90150616385508380678;1
15061658;1723901220;GENODEF1STG;DE04150616581723901220;1
15061698;5782992426;GENODEF1MAL;DE94150616985782992426;1
15080000;0000556099;DRESDEFF150;DE15150800000055609900;18
15080000;0003447248;DRESDEFF150;DE22150800000003447248;1
15091674;8558791757;GENODEF1DM1;DE43150916748558791757;1
15091704;4363263424;GENODEF1PZ1;DE39150917044363263424;1
16000000;6001504463;;;-124
16010111;0272278373;ESSEDE5F160;DE07160101110272278373;1
16010300;1358968456;ILBXDE8XXXX;DE50160103001358968456;1
16020086;0396112630;HYVEDEMM470;DE03160200860396112630;1
16040000;0980483283;COBADEFFXXX;DE98160400000980483283;1
16050000;1431717459;WELADED1PMB;DE75160500001431717459;1
16050101;1087169638;WELADED1PRP;DE77160501011087169638;1
16050202;3641939010;WELADED1OPR;DE63160502023641939010;1
16050500;9953890483;LBSODEB1XXX;DE08160505009953890483;1
16052072;0101610272;TESTDEX9876;DE51160520720101610272;1
16060122;7064570162;GENODEF1PER;DE61160601227064570162;1
16061938;8222543117;GENODEF1NPP;DE94160619388222543117;1
16062008;1562583447;GENODEF1LUK;DE33160620081562583447;1
16062073;2750149098;GENODEF1BRB;DE67160620732750149098;1
16080000;0000699949;DRESDEFF160;DE71160800000069994900;18
16080000;0009592838;DRESDEFF160;DE80160800000009592838;1
16091994;3006379940;GENODEF1RN1;DE95160919943006379940;1
17000000;9565884923;;;-124
17020086;0396645319;HYVEDEMM471;DE50170200860396645319;1
17020086;6136477194;HYVEDEMMXXX;DE16700202706136477194;19
17040000;0437328804;COBADEFFXXX;DE93170400000437328804;1
17052000;7631962680;WELADED1GZE;DE87170520007631962680;1
17052302;1824522254;WELADED1UMX;DE94170523021824522254;1
17054040;1027872359;WELADED1MOL;DE97170540401027872359;1
17055050;7510991425;WELADED1LOS;DE58170550507510991425;1
17056060;8227183299;WELADED1UMP;DE71170560608227183299;1
17062428;3551766139;GENODEF1BKW;DE93170624283551766139;1
17080000;0000927223;DRESDEFF170;DE94170800000092722300;18
17080000;0003887891;DRESDEFF170;DE49170800000003887891;1
17092404;1131518380;GENODEF1FW1;DE30170924041131518380;1
18000000;1634926103;;;-124
18020086;0396954130;HYVEDEMM472;DE54180200860396954130;1
18020086;1350329915;HYVEDEMM411;DE38770200701350329915;19
18040000;0786878944;COBADEFFXXX;DE05180400000786878944;1
18050000;1590816460;WELADED1CBN;DE31180500001590816460;1
18051000;4041918176;WELADED1EES;DE04180510004041918176;1
18055000;1321737110;WELADED1OSL;DE21180550001321737110;1
18062678;1728145598;GENODEF1FWA;DE49180626781728145598;1
18062758;9824580923;GENODEF1FOR;DE23180627589824580923;1
18080000;0000279924;DRESDEFF180;DE72180800000027992400;18
18080000;0004396595;DRESDEFF180;DE22180800000004396595;1
18092684;6385381622;GENODEF1LN1;DE48180926846385381622;1
18092744;2462309840;GENODEF1SPM;DE84180927442462309840;1
20000000;3218325727;;;-124
20010020;1154640965;PBNKDEFF200;DE87200100201154640965;1
20010020;6177808743;PBNKDEFF200;DE61200100206177808743;1
20010111;0107852677;ESSEDE5F200;DE27200101110107852677;1
20010424;2688490189;AARBDE5W200;DE51200104242688490189;1
20020200;9391953922;ESSEDEFFHAM;DE46200202009391953922;1
20020500;3270711842;JYBADEHHXXX;DE94200205003270711842;1
20020900;9506021048;SIBSDEHHXXX;DE71200209009506021048;1
20030000;0000259192;HYVEDEMM300;DE71200300000000259192;1
20030300;8644504145;CHDBDEHHXXX;DE50200303008644504145;1
20030400;7143847379;MCRDDEHHXXX;DE92200304007143847379;1
20030600;4865834250;SYBKDE22HAM;DE78200306004865834250;1
20030700;5301924036;MEFIDEMM200;DE16200307005301924036;1
20030900;2936405943;WOELDEHHXXX;DE83200309002936405943;1
20040000;0500239935;COBADEFFXXX;DE43200400000500239935;1
20040020;2431410755;COBADEFFXXX;DE45200400202431410755;1
20040040;0764093139;COBADEFFXXX;DE52200400400764093139;1
20040048;0457414190;COBADEFFXXX;DE93200400480457414190;1
20040050;0675205957;COBADEFFXXX;DE07200400500675205957;1
20040060;9607554452;COBADEFFXXX;DE77200400609607554452;1
20040061;5754346939;COBADEFFXXX;DE57200400615754346939;1
20040062;2771879276;COBADEFFXXX;DE29200400622771879276;1
20040063;3432248304;COBADEFFXXX;DE31200400633432248304;1
20041111;0694662848;COBADEFFXXX;DE26200411110694662848;1
20041133;0238453508;COBADEFFXXX;DE15200411330238453508;1
20041144;0619970734;COBADEFFXXX;DE59200411440619970734;1
20041155;0832507896;COBADEFFXXX;DE95200411550832507896;1
20050000;0000104877;HSHNDEHHXXX;DE18210500000104877000;20
20050000;0000131201;HSHNDEHHXXX;DE21210500000131201000;20
20050000;0000144485;HSHNDEHHXXX;DE94210500000144485000;20
20050000;0000175786;HSHNDEHHXXX;DE47210500000175786000;20
20050000;0000203919;HSHNDEHHXXX;DE42210500000203919000;20
20050000;0000226001;HSHNDEHHXXX;DE34210500000226001000;20
20050000;0000262766;HSHNDEHHXXX;DE63210500000262766000;20
20050000;0000282673;HSHNDEHHXXX;DE91210500000282673000;20
20050000;0000306712;HSHNDEHHXXX;DE87210500000306712000;20
20050000;0000337006;HSHNDEHHXXX;DE37210500000337006000;20
20050000;0000351601;HSHNDEHHXXX;DE59210500000351601000;20
20050000;0000389890;HSHNDEHHXXX;DE70210500000389890000;20
20050000;0000410373;HSHNDEHHXXX;DE11210500000410373000;20
20050000;0000445957;HSHNDEHHXXX;DE36210500000445957000;20
20050000;0000470252;HSHNDEHHXXX;DE58210500000470252000;20
20050000;0000492108;HSHNDEHHXXX;DE71210500000492108000;20
20050000;0000519967;HSHNDEHHXXX;DE70210500000519967000;20
20050000;0000538447;HSHNDEHHXXX;DE19210500000538447000;20
20050000;0000568089;HSHNDEHHXXX;DE21210500000568089000;20
20050000;0000590109;HSHNDEHHXXX;DE84210500000590109000;20
20050000;0000629535;HSHNDEHHXXX;DE43210500000629535000;20
20050000;0000654657;HSHNDEHHXXX;DE77210500000654657000;20
20050000;0000668970;HSHNDEHHXXX;DE84210500000668970000;20
20050000;0000699041;HSHNDEHHXXX;DE50210500000699041000;20
20050000;0000723965;HSHNDEHHXXX;DE26210500000723965000;20
20050000;0000752519;HSHNDEHHXXX;DE63210500000752519000;20
20050000;0000772228;HSHNDEHHXXX;DE33210500000772228000;20
20050000;0000801258;HSHNDEHHXXX;DE85210500000801258000;20
20050000;0000836940;HSHNDEHHXXX;DE76210500000836940000;20
20050000;0000864959;HSHNDEHHXXX;DE67210500000864959000;20
20050000;0000884767;HSHNDEHHXXX;DE66210500000884767000;20
20050000;0030019336;HSHNDEHHXXX;DE53210500000030019336;19
20050000;0032988717;HSHNDEHHXXX;DE79210500000032988717;19
20050000;0034578870;HSHNDEHHXXX;DE88210500000034578870;19
20050000;0037760146;HSHNDEHHXXX;DE09210500000037760146;19
20050000;0040167614;HSHNDEHHXXX;DE13210500000040167614;19
20050000;0043263567;HSHNDEHHXXX;DE02210500000043263567;19
20050000;0046377284;HSHNDEHHXXX;DE28210500000046377284;19
20050000;0048308416;HSHNDEHHXXX;DE68210500000048308416;19
20050000;0051164185;HSHNDEHHXXX;DE90210500000051164185;19
20050000;0053211769;HSHNDEHHXXX;DE84210500000053211769;19
20050000;0055889855;HSHNDEHHXXX;DE24210500000055889855;19
20050000;0057712790;HSHNDEHHXXX;DE34210500000057712790;19
20050000;0115212359;HSHNDEHHXXX;DE66210500000115212359;19
20050000;0132357267;HSHNDEHHXXX;DE68210500000132357267;19
20050000;0168047832;HSHNDEHHXXX;DE52210500000168047832;19
20050000;0190363336;HSHNDEHHXXX;DE48210500000190363336;19
20050000;0220202438;HSHNDEHHXXX;DE07210500000220202438;19
20050000;0252056748;HSHNDEHHXXX;DE45210500000252056748;19
20050000;0267997132;HSHNDEHHXXX;DE35210500000267997132;19
20050000;0295154795;HSHNDEHHXXX;DE84210500000295154795;19
20050000;0327569443;HSHNDEHHXXX;DE86210500000327569443;19
20050000;0355966393;HSHNDEHHXXX;DE21210500000355966393;19
20050000;0382325930;HSHNDEHHXXX;DE49210500000382325930;19
20050000;0398230268;HSHNDEHHXXX;DE80210500000398230268;19
20050000;0414987777;HSHNDEHHXXX;DE54210500000414987777;19
20050000;0448555408;HSHNDEHHXXX;DE16210500000448555408;19
20050000;0471078211;HSHNDEHHXXX;DE33210500000471078211;19
20050000;0502492237;HSHNDEHHXXX;DE98210500000502492237;19
20050000;0524413554;HSHNDEHHXXX;DE12210500000524413554;19
20050000;0545640436;HSHNDEHHXXX;DE56210500000545640436;19
20050000;0580167709;HSHNDEHHXXX;DE33210500000580167709;19
20050000;0609560459;HSHNDEHHXXX;DE22210500000609560459;19
20050000;0626275745;HSHNDEHHXXX;DE73210500000626275745;19
20050000;0662734523;HSHNDEHHXXX;DE10210500000662734523;19
20050000;0681718332;HSHNDEHHXXX;DE08210500000681718332;19
20050000;0717876923;HSHNDEHHXXX;DE62210500000717876923;19
20050000;0744334205;HSHNDEHHXXX;DE54210500000744334205;19
20050000;0757419686;HSHNDEHHXXX;DE17210500000757419686;19
20050000;0787275257;HSHNDEHHXXX;DE58210500000787275257;19
20050000;0814186956;HSHNDEHHXXX;DE30210500000814186956;19
20050000;0837997118;HSHNDEHHXXX;DE43210500000837997118;19
20050000;0868851261;HSHNDEHHXXX;DE81210500000868851261;19
20050000;0896829132;HSHNDEHHXXX;DE02210500000896829132;19
20050000;1121928919;HSHNDEHHXXX;DE27210500001121928919;19
20050000;1301757940;HSHNDEHHXXX;DE57210500001301757940;19
20050000;1504396869;HSHNDEHHXXX;DE24210500001504396869;19
20050000;1874099800;HSHNDEHHXXX;DE81210500001874099800;19
20050000;3314242011;HSHNDEHHXXX;DE06210500003314242011;19
20050000;3643331253;HSHNDEHHXXX;DE89210500003643331253;19
20050000;3858385747;HSHNDEHHXXX;DE64210500003858385747;19
20050000;4030331978;HSHNDEHHXXX;DE61210500004030331978;19
20050000;4290557099;HSHNDEHHXXX;DE06210500004290557099;19
20050000;4454503048;HSHNDEHHXXX;DE63210500004454503048;19
20050000;4736431265;HSHNDEHHXXX;DE12210500004736431265;19
20050000;5007515260;HSHNDEHHXXX;DE37210500005007515260;19
20050000;5267219119;HSHNDEHHXXX;DE35210500005267219119;19
20050000;5660538639;HSHNDEHHXXX;DE22210500005660538639;19
20050000;5877341626;HSHNDEHHXXX;DE04210500005877341626;19
20050000;6060881230;HSHNDEHHXXX;DE64210500006060881230;19
20050000;6360533663;HSHNDEHHXXX;DE46210500006360533663;19
20050000;6571200410;HSHNDEHHXXX;DE83210500006571200410;19
20050000;6830792145;HSHNDEHHXXX;DE59210500006830792145;19
20050000;7019479995;HSHNDEHHXXX;DE29210500007019479995;19
20050000;7044505292;HSHNDEHHXXX;DE95210500007044505292;19
20050000;7059075763;HSHNDEHHXXX;DE84210500007059075763;19
20050000;7086455013;HSHNDEHHXXX;DE50210500007086455013;19
20050000;8512456883;HSHNDEHHXXX;DE92210500008512456883;19
20050000;8530983067;HSHNDEHHXXX;DE08210500008530983067;19
20050000;8567182341;HSHNDEHHXXX;DE49210500008567182341;19
20050000;8594379569;HSHNDEHHXXX;DE07210500008594379569;19
20050000;9244412104;HSHNDEHHXXX;DE86210500009244412104;19
20050000;9449113893;HSHNDEHHXXX;DE39210500009449113893;19
20050000;9745306522;HSHNDEHHXXX;DE43210500009745306522;19
20050000;9984823276;HSHNDEHHXXX;DE49210500009984823276;19
20050550;3501299949;HASPDEHHXXX;DE30200505503501299949;1
20060000;2996849770;GENODEFF200;DE44200600002996849770;1
20069111;6656908250;GENODEF1NDR;DE38200691116656908250;1
20069125;2078449709;GENODEF1KLK;DE35200691252078449709;1
20069130;4096533680;GENODEF1BBR;DE57200691304096533680;1
20069144;3916541770;GENODEF1SST;DE55200691443916541770;1
20069177;3669576584;GENODEF1GRS;DE29200691773669576584;1
20069232;1361025909;GENODEF1STV;DE49200692321361025909;1
20069641;2739751120;GENODEF1OWS;DE89200696412739751120;1
20069780;9418770376;GENODEF1AST;DE36200697809418770376;1
20069782;9067281020;GENODEF1APE;DE50200697829067281020;1
20069786;7446599624;GENODEF1DRO;DE91200697867446599624;1
20069800;5962870714;GENODEF1HAA;DE87200698005962870714;1
20069812;4126866087;GENODEF1FRB;DE53200698124126866087;1
20069815;3466473440;GENODEF1815;DE32200698153466473440;1
20069861;4209388548;GENODEF1RRZ;DE65200698614209388548;1
20069882;1315603325;GENODEF1RLT;DE69200698821315603325;1
20069965;2425484302;GENODEF1WIM;DE59200699652425484302;1
20069989;3860353557;GENODEF1WUL;DE50200699893860353557;1
20070000;0007225089;DEUTDEHHXXX;DE20200700000722508900;18
20070024;0001582824;DEUTDEDBHAM;DE95200700240158282400;18
20080000;0000193902;DRESDEFF200;DE03200800000019390200;18
20080000;0006679512;DRESDEFF200;DE57200800000006679512;1
20080055;0000223463;DRESDEFF207;DE89200800550022346300;18
20080055;0002538022;DRESDEFF207;DE30200800550002538022;1
20080057;0000106719;DRESDEFF208;DE87200800570010671900;18
20080057;0001913630;DRESDEFF208;DE84200800570001913630;1
20080085;5545596276;DRESDEFFI56;DE86200800855545596276;1
20080086;5251850171;DRESDEFFI63;DE96200800865251850171;1
20080087;2511156652;DRESDEFFI64;DE09200800872511156652;1
20080088;6997656559;DRESDEFFI74;DE69200800886997656559;1
20080089;9334902699;DRESDEFFI75;DE23200800899334902699;1
20080091;5032838663;DRESDEFFJ33;DE91200800915032838663;1
20080092;6707097979;DRESDEFFJ34;DE65200800926707097979;1
20080093;1951614296;DRESDEFFJ35;DE46200800931951614296;1
20080094;3260916633;DRESDEFFJ36;DE42200800943260916633;1
20080095;8060915400;DRESDEFFJ37;DE75200800958060915400;1
20089200;2324414955;DRESDEFFI06;DE88200892002324414955;1
20090400;1037018156;DGHYDEH1XXX;DE49200904001037018156;1
20090500;1282217953;GENODEF1S15;DE68200905001282217953;1
20090602;0000153842;DAAEDEDDXXX;DE95300606010000153842;19
20090602;1745201172;DAAEDEDDXXX;DE16300606011745201172;19
20090602;3321030043;DAAEDEDDXXX;DE62300606013321030043;19
20090602;4223139611;DAAEDEDDXXX;DE37300606014223139611;19
20090602;5348879680;DAAEDEDDXXX;DE87300606015348879680;19
20090602;6481327702;DAAEDEDDXXX;DE23300606016481327702;19
20090602;7154777700;DAAEDEDDXXX;DE15300606017154777700;19
20090602;8542128860;DAAEDEDDXXX;DE62300606018542128860;19
20090700;0001367960;EDEKDEHHXXX;DE86200907001367960000;1
20090745;0001215990;EDECDEH1XXX;DE93200907451215990000;1
20090900;1384775330;GENODEF1P08;DE27200909001384775330;1
20110022;1302036593;PBNKDEFF201;DE06201100221302036593;1
20110401;4463480771;;;-124
20110700;7972250078;BOTKDEDXXXX;DE82300107007972250078;19
20110800;4959062851;BKCHDEFFHMB;DE78201108004959062851;1
20120000;5291671286;BEGODEHHXXX;DE06201200005291671286;1
20120100;0000102016;WBWCDEHHXXX;DE06201201000000102016;1
20120100;0006563021;WBWCDEHHXXX;DE96201201000006563021;1
20120100;0415213152;WBWCDEHHXXX;DE37201201000415213152;1
20120200;2183671008;BHFBDEFF500;DE45500202002183671008;19
20120400;9178553545;DRBKDEH1XXX;DE05201204009178553545;1
20120600;6220498086;GOGODEH1XXX;DE97201206006220498086;1
20120700;1768204469;HSTBDEHHXXX;DE36201207001768204469;1
20120701;2781387196;HSTBDEH1OV1;DE40201207012781387196;1
20120744;0001099304;HSTBDEH1NKO;DE78201207440001099304;1
20120766;0001178975;HSTBDEH1NKS;DE27201207660001178975;1
20130400;6909253715;GREBDEH1XXX;DE70201304006909253715;1
20130412;7635892370;GREBDEH1ABS;DE85201304127635892370;1
20130600;7037702412;BARCDEHAXXX;DE84201306007037702412;1
20133300;3135440496;SCFBDE33XXX;DE86201333003135440496;1
20190003;9869103448;GENODEF1HH2;DE08201900039869103448;1
20190109;1105023322;GENODEF1HH4;DE94201901091105023322;1
20190206;2895898197;GENODEF1HH1;DE37201902062895898197;1
20190301;7434420030;GENODEF1HH3;DE97201903017434420030;1
20190800;3560731923;GENODEF1MKB;DE37201908003560731923;1
20210200;1250950030;           ;DE88202102001250950030;1
20210300;4138946024;           ;DE39202103004138946024;1
20220100;1573645168;DNBADEHXXXX;DE07202201001573645168;1
20220400;9526014811;MMWHDEH1XXX;DE03202204009526014811;1
20230300;2926868185;OSCBDEH1XXX;DE16202303002926868185;1
20230600;3571894830;ISBKDEFXHAM;DE28202306003571894830;1
20230800;2802903207;MHSBDEHBXXX;DE10202308002802903207;1
20310300;1388162844;           ;DE93203103001388162844;1
20310600;6428857618;;;-124
20320500;6634185556;DABADEHHXXX;DE34203205006634185556;1
20350000;1306829936;;;-124
20690500;1018560062;GENODEF1S11;DE40206905001018560062;1
20690500;4499260190;GENODEF1S11;DE59206905004499260190;1
20690500;8616533695;GENODEF1S11;DE18206905008616533695;1
20730000;0000411322;HYVEDEMM300;DE26200300000000411322;1
20730001;8311391360;HYVEDEMME01;DE35207300018311391360;1
20730002;7089314107;HYVEDEMME02;DE03207300027089314107;1
20730003;3519644346;HYVEDEMME03;DE39207300033519644346;1
20730004;5577206660;HYVEDEMME04;DE06207300045577206660;1
20730005;4193706101;HYVEDEMME05;DE16207300054193706101;1
20730006;9583032707;HYVEDEMME06;DE72207300069583032707;1
20730007;2203406208;HYVEDEMME07;DE03207300072203406208;1
20730008;2039055119;HYVEDEMME08;DE71207300082039055119;1
20730009;7391203338;HYVEDEMME09;DE48207300097391203338;1
20730010;2803426007;HYVEDEMME10;DE75207300102803426007;1
20730011;3990810563;HYVEDEMME11;DE89207300113990810563;1
20730012;1073197498;HYVEDEMME12;DE82207300121073197498;1
20730013;9504374229;HYVEDEMME13;DE16207300139504374229;1
20730014;2439031619;HYVEDEMME14;DE92207300142439031619;1
20730015;5398312599;HYVEDEMME15;DE12207300155398312599;1
20730016;6076543546;HYVEDEMME16;DE76207300166076543546;1
20730017;6904838367;HYVEDEMME17;DE74207300176904838367;1
20730018;6390789022;HYVEDEMME18;DE27207300186390789022;1
20730019;3916266004;HYVEDEMME19;DE22207300193916266004;1
20730023;0396505362;HYVEDEMME23;DE66207300230396505362;1
20730051;0000199976;HYVEDEMM300;DE52200300000000199976;1
20730053;0000150326;HYVEDEMM300;DE62200300000000150326;1
20730054;0000130278;HYVEDEMM300;DE98200300000000130278;1
20750000;6173309599;NOLADE21HAM;DE75207500006173309599;1
21010111;0101658398;ESSEDE5F210;DE75210101110101658398;1
21020600;3675568681;SYBKDE22KIE;DE94210206003675568681;1
21030000;0000686915;HYVEDEMM300;DE79200300000000686915;1
21030092;0000258384;HYVEDEMM300;DE62200300000000258384;1
21030093;0000334508;HYVEDEMM300;DE47200300000000334508;1
21030094;0000183772;HYVEDEMM300;DE90200300000000183772;1
21030095;0000242776;HYVEDEMM300;DE13200300000000242776;1
21040010;0869613019;COBADEFFXXX;DE45210400100869613019;1
21042076;0493191155;COBADEFFXXX;DE78210420760493191155;1
21050000;0000106195;HSHNDEHHXXX;DE20210500000106195000;18
21050000;0000159590;HSHNDEHHXXX;DE42210500000159590000;18
21050000;0000211367;HSHNDEHHXXX;DE77210500000211367000;18
21050000;0000252247;HSHNDEHHXXX;DE70210500000252247000;18
21050000;0000312744;HSHNDEHHXXX;DE57210500000312744000;18
21050000;0000362178;HSHNDEHHXXX;DE20210500000362178000;18
21050000;0000415646;HSHNDEHHXXX;DE82210500000415646000;18
21050000;0000480939;HSHNDEHHXXX;DE62210500000480939000;18
21050000;0000506014;HSHNDEHHXXX;DE45210500000506014000;18
21050000;0000579870;HSHNDEHHXXX;DE77210500000579870000;18
21050000;0000634378;HSHNDEHHXXX;DE87210500000634378000;18
21050000;0000674093;HSHNDEHHXXX;DE17210500000674093000;18
21050000;0000744458;HSHNDEHHXXX;DE15210500000744458000;18
21050000;0000782417;HSHNDEHHXXX;DE91210500000782417000;18
21050000;0000836387;HSHNDEHHXXX;DE60210500000836387000;18
21050000;0000880823;HSHNDEHHXXX;DE11210500000880823000;18
21050000;0030240766;HSHNDEHHXXX;DE38210500000030240766;1
21050000;0479246227;HSHNDEHHXXX;DE85210500000479246227;1
21050000;4458064244;HSHNDEHHXXX;DE88210500004458064244;1
21050170;0000101258;NOLADE21KIE;DE31210501700000101258;1
21050170;0000887005;NOLADE21KIE;DE23210501700000887005;1
21050170;0044522423;NOLADE21KIE;DE14210501700044522423;1
21050170;1725720013;NOLADE21KIE;DE36210501701725720013;1
21051275;1123268474;NOLADE21BOR;DE49210512751123268474;1
21051580;9212527601;NOLADE21PLN;DE81210515809212527601;1
21052090;8037810812;NOLADE21ECK;DE58210520908037810812;1
21060237;5860227226;GENODEF1EDG;DE84210602375860227226;1
21064045;1226565105;GENODEF1LTJ;DE73210640451226565105;1
21070020;0008192296;DEUTDEHH210;DE45210700200819229600;18
21070024;0005427885;DEUTDEDB210;DE57210700240542788500;18
21080050;0000296570;DRESDEFF210;DE72210800500029657000;18
21080050;0002876948;DRESDEFF210;DE02210800500002876948;1
21090007;1772829030;GENODEF1KIL;DE37210900071772829030;1
21090619;0000594024;DAAEDEDDXXX;DE09300606010000594024;19
21090619;2023675904;DAAEDEDDXXX;DE94300606012023675904;19
21090619;2839510681;DAAEDEDDXXX;DE25300606012839510681;19
21090619;3591596672;DAAEDEDDXXX;DE96300606013591596672;19
21090619;5435167126;DAAEDEDDXXX;DE80300606015435167126;19
21090619;6582908000;DAAEDEDDXXX;DE90300606016582908000;19
21090619;8053096831;DAAEDEDDXXX;DE96300606018053096831;19
21090619;8968227330;DAAEDEDDXXX;DE85300606018968227330;19
21090900;2058418135;GENODEF1P11;DE98210909002058418135;1
21092023;1789033795;GENODEF1EFO;DE11210920231789033795;1
21210111;0168585808;ESSEDE5F212;DE63212101110168585808;1
21230085;0000524272;HYVEDEMM300;DE56200300000000524272;1
21230086;0000167767;HYVEDEMM300;DE90200300000000167767;1
21240040;0136866100;COBADEFFXXX;DE82212400400136866100;1
21241540;0936694911;COBADEFFXXX;DE25212415400936694911;1
21261089;1064893072;GENODEF1WAS;DE80212610891064893072;1
21261227;2807262412;GENODEF1BOO;DE68212612272807262412;1
21270020;0007998693;DEUTDEHH212;DE87212700200799869300;18
21270024;0004980322;DEUTDEDB212;DE69212700240498032200;18
21280002;0000190561;DRESDEFF212;DE34212800020019056100;18
21280002;0007212668;DRESDEFF212;DE73212800020007212668;1
21290016;1200059594;GENODEF1NMS;DE32212900161200059594;1
21340010;0446801389;COBADEFFXXX;DE04213400100446801389;1
21352240;1176107777;NOLADE21HOL;DE87213522401176107777;1
21390008;8757587163;GENODEF1NSH;DE44213900088757587163;1
21392218;2456848417;GENODEF1EUT;DE61213922182456848417;1
21430070;0000122267;HYVEDEMM300;DE85200300000000122267;1
21440045;0119824152;COBADEFFXXX;DE59214400450119824152;1
21450000;1057199679;NOLADE21RDB;DE48214500001057199679;1
21450000;8773413219;NOLADE21RDB;DE20214500008773413219;1
21451205;1759607524;NOLADE21BDF;DE55214512051759607524;1
21452030;1029535775;NOLADE21HWS;DE88214520301029535775;1
21463603;8887741553;GENODEF1NTO;DE78214636038887741553;1
21464671;3033451983;GENODEF1TOB;DE63214646713033451983;1
21480003;0000379050;DRESDEFF214;DE61214800030037905000;18
21480003;0003467888;DRESDEFF214;DE49214800030003467888;1
21510600;1032301099;SYBKDE22XXX;DE05215106001032301099;1
21520100;4316475030;UNBNDE21XXX;DE31215201004316475030;1
21530080;0000135053;HYVEDEMM300;DE86200300000000135053;1
21540060;0214960701;COBADEFFXXX;DE04215400600214960701;1
21550050;1015539653;;;-124
21565316;2567008206;GENODEF1HDW;DE60215653162567008206;1
21566356;1247010944;GENODEF1SBR;DE16215663561247010944;1
21567360;3817020249;GENODEF1KJO;DE62215673603817020249;1
21570011;0004161428;DEUTDEHH215;DE14215700110416142800;18
21570024;0008170268;DEUTDEDB215;DE77215700240817026800;18
21580000;0000864043;DRESDEFF215;DE84215800000086404300;18
21580000;0001691313;DRESDEFF215;DE45215800000001691313;1
21630060;0000668939;HYVEDEMM300;DE43200300000000668939;1
21630061;0000145912;HYVEDEMM300;DE27200300000000145912;1
21630062;0000270348;HYVEDEMM300;DE44200300000000270348;1
21630063;0000182238;HYVEDEMM300;DE89200300000000182238;1
21650110;1076817584;;;-124
21661719;3455889340;GENODEF1RSL;DE36216617193455889340;1
21690020;5009383328;GENODEF1SLW;DE72216900205009383328;1
21730040;0000380303;HYVEDEMM300;DE41200300000000380303;1
21730042;0000303487;HYVEDEMM300;DE19200300000000303487;1
21730043;0000383588;HYVEDEMM300;DE04200300000000383588;1
21730044;0000333344;HYVEDEMM300;DE47200300000000333344;1
21730045;0000235986;HYVEDEMM300;DE13200300000000235986;1
21730046;0000193268;HYVEDEMM300;DE69200300000000193268;1
21740043;0517282058;COBADEFFXXX;DE29217400430517282058;1
21741674;0866422972;COBADEFFXXX;DE41217416740866422972;1
21741825;0657969211;COBADEFFXXX;DE71217418250657969211;1
21750000;1041542280;NOLADE21NOS;DE97217500001041542280;1
21750000;6259870265;NOLADE21NOS;DE50217500006259870265;1
21751230;5188390180;NOLADE21BRD;DE29217512305188390180;1
21762550;9220646695;GENODEF1HUM;DE39217625509220646695;1
21763542;3208827222;GENODEF1BDS;DE51217635423208827222;1
21770011;0009474909;DEUTDEHH217;DE55217700110947490900;18
21770024;0007518640;DEUTDEDB217;DE69217700240751864000;18
21791805;2377282375;GENODEF1SYL;DE30217918052377282375;1
21791906;4080768731;GENODEF1WYK;DE46217919064080768731;1
21830030;0000124875;HYVEDEMM300;DE91200300000000124875;1
21830032;0000113993;HYVEDEMM300;DE92200300000000113993;1
21830033;0000259036;HYVEDEMM300;DE15200300000000259036;1
21830034;0000100149;HYVEDEMM300;DE42200300000000100149;1
21830035;0000115113;HYVEDEMM300;DE19200300000000115113;1
21840078;0999438594;COBADEFFXXX;DE07218400780999438594;1
21841328;0973014486;COBADEFFXXX;DE18218413280973014486;1
21851720;1372795588;NOLADE21MRN;DE06218517201372795588;1
21851830;2537296598;NOLADE21MLD;DE35218518302537296598;1
21852310;2133109598;NOLADE21WEB;DE34218523102133109598;1
21860418;8199019260;GENODEF1RHE;DE72218604188199019260;1
21890022;2031734865;GENODEF1DVR;DE93218900222031734865;1
22130075;0000173005;HYVEDEMM300;DE90200300000000173005;1
22140028;0102604627;COBADEFFXXX;DE44221400280102604627;1
22141028;0569174631;COBADEFFXXX;DE16221410280569174631;1
22141428;0336457769;COBADEFFXXX;DE96221414280336457769;1
22141628;0618518506;COBADEFFXXX;DE60221416280618518506;1
22150000;1271840191;NOLADE21ELH;DE64221500001271840191;1
22151730;1014271495;NOLADE21WED;DE18221517301014271495;1
22151730;6059978258;NOLADE21WED;DE80221517306059978258;1
22163114;4403341380;GENODEF1HTE;DE37221631144403341380;1
22180000;0000780212;DRESDEFF221;DE89221800000078021200;18
22180000;0009981822;DRESDEFF221;DE83221800000009981822;1
22181400;0000654899;DRESDEFF206;DE86221814000065489900;18
22181400;0002553732;DRESDEFF206;DE67221814000002553732;1
22190030;1751389229;GENODEF1ELM;DE54221900301751389229;1
22191405;3797050318;GENODEF1PIN;DE10221914053797050318;1
22230020;0000104752;HYVEDEMM300;DE18200300000000104752;1
22230022;0000143172;HYVEDEMM300;DE93200300000000143172;1
22230023;0000139808;HYVEDEMM300;DE32200300000000139808;1
22230025;0000112169;HYVEDEMM300;DE64200300000000112169;1
22240073;0450499965;COBADEFFXXX;DE49222400730450499965;1
22250020;1203711161;NOLADE21WHO;DE94222500201203711161;1
22251580;1312542656;NOLADE21SHF;DE12222515801312542656;1
22260136;2499416258;GENODEF1RIT;DE42222601362499416258;1
22280000;0000856502;DRESDEFF201;DE30222800000085650200;18
22280000;0003663882;DRESDEFF201;DE18222800000003663882;1
22290031;1971953490;GENODEF1VIT;DE63222900311971953490;1
23010111;0491405793;ESSEDE5F230;DE93230101110491405793;1
23030000;0000424531;HYVEDEMM300;DE52200300000000424531;1
23040022;0656537820;COBADEFFXXX;DE73230400220656537820;1
23050000;0000100560;HSHNDEHHXXX;DE35210500000100560000;20
23050000;0000151159;HSHNDEHHXXX;DE61210500000151159000;20
23050000;0000207373;HSHNDEHHXXX;DE73210500000207373000;20
23050000;0000260018;HSHNDEHHXXX;DE84210500000260018000;20
23050000;0000329193;HSHNDEHHXXX;DE93210500000329193000;20
23050000;0000358143;HSHNDEHHXXX;DE52210500000358143000;20
23050000;0000409367;HSHNDEHHXXX;DE71210500000409367000;20
23050000;0000452359;HSHNDEHHXXX;DE36210500000452359000;20
23050000;0000532242;HSHNDEHHXXX;DE14210500000532242000;20
23050000;0000579508;HSHNDEHHXXX;DE66210500000579508000;20
23050000;0000629162;HSHNDEHHXXX;DE18210500000629162000;20
23050000;0000683292;HSHNDEHHXXX;DE76210500000683292000;20
23050000;0000729624;HSHNDEHHXXX;DE68210500000729624000;20
23050000;0000779751;HSHNDEHHXXX;DE40210500000779751000;20
23050000;0000837195;HSHNDEHHXXX;DE39210500000837195000;20
23050000;0000882738;HSHNDEHHXXX;DE85210500000882738000;20
23050000;0030168874;HSHNDEHHXXX;DE55210500000030168874;19
23050000;0035975060;HSHNDEHHXXX;DE68210500000035975060;19
23050000;0040560206;HSHNDEHHXXX;DE92210500000040560206;19
23050000;0044872190;HSHNDEHHXXX;DE95210500000044872190;19
23050000;0050556396;HSHNDEHHXXX;DE30210500000050556396;19
23050000;0056568396;HSHNDEHHXXX;DE98210500000056568396;19
23050000;0110676306;HSHNDEHHXXX;DE36210500000110676306;19
23050000;0159293345;HSHNDEHHXXX;DE49210500000159293345;19
23050000;0223966138;HSHNDEHHXXX;DE23210500000223966138;19
23050000;0275453978;HSHNDEHHXXX;DE42210500000275453978;19
23050000;0312595817;HSHNDEHHXXX;DE39210500000312595817;19
23050000;0354654465;HSHNDEHHXXX;DE05210500000354654465;19
23050000;0442095403;HSHNDEHHXXX;DE86210500000442095403;19
23050000;0476663966;HSHNDEHHXXX;DE54210500000476663966;19
23050000;0524322703;HSHNDEHHXXX;DE53210500000524322703;19
23050000;0567610272;HSHNDEHHXXX;DE39210500000567610272;19
23050000;0646174936;HSHNDEHHXXX;DE66210500000646174936;19
23050000;0686972112;HSHNDEHHXXX;DE69210500000686972112;19
23050000;0745422282;HSHNDEHHXXX;DE74210500000745422282;19
23050000;0789909039;HSHNDEHHXXX;DE02210500000789909039;19
23050000;0851287161;HSHNDEHHXXX;DE12210500000851287161;19
23050000;0892711714;HSHNDEHHXXX;DE43210500000892711714;19
23050000;1506435701;HSHNDEHHXXX;DE30210500001506435701;19
23050000;1965199574;HSHNDEHHXXX;DE76210500001965199574;19
23050000;3451284982;HSHNDEHHXXX;DE43210500003451284982;19
23050000;4007561651;HSHNDEHHXXX;DE86210500004007561651;19
23050000;4456611772;HSHNDEHHXXX;DE23210500004456611772;19
23050000;5086075727;HSHNDEHHXXX;DE87210500005086075727;19
23050000;5669048081;HSHNDEHHXXX;DE64210500005669048081;19
23050000;6165004080;HSHNDEHHXXX;DE67210500006165004080;19
23050000;6735855107;HSHNDEHHXXX;DE07210500006735855107;19
23050000;7006416681;HSHNDEHHXXX;DE47210500007006416681;19
23050000;7078313409;HSHNDEHHXXX;DE18210500007078313409;19
23050000;8523463645;HSHNDEHHXXX;DE07210500008523463645;19
23050000;8583380866;HSHNDEHHXXX;DE70210500008583380866;19
23050000;9262713034;HSHNDEHHXXX;DE57210500009262713034;19
23050000;9788168026;HSHNDEHHXXX;DE69210500009788168026;19
23050101;2287054650;NOLADE21SPL;DE39230501012287054650;1
23051030;1828616222;NOLADE21SHO;DE34230510301828616222;1
23051610;1003055373;NOLADE21STO;DE48230516101003055373;1
23052750;1179051295;NOLADE21RZB;DE22230527501179051295;1
23061220;5973385159;GENODEF1LZN;DE06230612205973385159;1
23062124;1320511811;GENODEF1BAR;DE05230621241320511811;1
23062807;2235834971;GENODEF1MOE;DE09230628072235834971;1
23063129;1375543691;GENODEF1RLB;DE50230631291375543691;1
23064107;8061240552;GENODEF1BCH;DE88230641078061240552;1
23070700;0002092179;DEUTDEDB237;DE43230707000209217900;18
23070710;0001686435;DEUTDEHH222;DE20230707100168643500;18
23080040;0000965327;DRESDEFF230;DE05230800400096532700;18
23080040;0002859959;DRESDEFF230;DE77230800400002859959;1
23090142;9182891311;GENODEF1HLU;DE04230901429182891311;1
23092502;5122296367;GENODEF1VLB;DE33230925025122296367;1
23092620;0000477362;DAAEDEDDXXX;DE02300606010000477362;19
23092620;1920809098;DAAEDEDDXXX;DE43300606011920809098;19
23092620;2645416752;DAAEDEDDXXX;DE43300606012645416752;19
23092620;3438718021;DAAEDEDDXXX;DE29300606013438718021;19
23092620;4650194692;DAAEDEDDXXX;DE44300606014650194692;19
23092620;6198634670;DAAEDEDDXXX;DE40300606016198634670;19
23092620;7777652577;DAAEDEDDXXX;DE07300606017777652577;19
23092620;9444996011;DAAEDEDDXXX;DE74300606019444996011;19
24030000;0000175117;HYVEDEMM300;DE05200300000000175117;1
24040000;0278341325;COBADEFFXXX;DE86240400000278341325;1
24050110;2558093338;NOLADE21LBG;DE85240501102558093338;1
24060300;4590337974;GENODEF1NBU;DE68240603004590337974;1
24061392;2498587226;GENODEF1DAB;DE63240613922498587226;1
24070024;0008884421;DEUTDEDB240;DE08240700240888442100;18
24070075;0009965625;DEUTDE2H240;DE40240700750996562500;18
24080000;0000188967;DRESDEFF240;DE95240800000018896700;18
24080000;0006403885;DRESDEFF240;DE46240800000006403885;1
24090041;6424972741;GENODEF1LUE;DE88240900416424972741;1
24130000;0000169185;HYVEDEMM300;DE22200300000000169185;1
24140041;0567461939;COBADEFFXXX;DE21241400410567461939;1
24150001;3744216155;BRLADE21CUX;DE49241500013744216155;1
24151005;6888144349;NOLADE21STS;DE38241510056888144349;1
24151116;3162723377;NOLADE21STK;DE31241511163162723377;1
24151235;5068814853;BRLADE21ROB;DE38241512355068814853;1
24161594;6048884086;GENODEF1SIT;DE95241615946048884086;1
24162898;1477837849;GENODEF1LAS;DE75241628981477837849;1
24180000;0000827435;DRESDEFF242;DE74241800000082743500;18
24180000;0009117008;DRESDEFF242;DE74241800000009117008;1
24180001;0000729541;DRESDEFF241;DE64241800010072954100;18
24180001;0003411302;DRESDEFF241;DE32241800010003411302;1
24191015;6965491362;GENODEF1SDE;DE05241910156965491362;1
25010030;1170843231;PBNKDEFF250;DE12250100301170843231;1
25010030;6036256205;PBNKDEFF250;DE84250100306036256205;1
25010111;0726804806;ESSEDE5F250;DE81250101110726804806;1
25010600;5798372021;DEHYDE2HXXX;DE75250106005798372021;1
25010900;1588982338;CKVHDE21XXX;DE07250109001588982338;1
25020200;1511855665;BHFBDEFF500;DE47500202001511855665;19
25020600;1139264284;GEMKDE2HXXX;DE21250206001139264284;1
25020700;2730150140;HSTBDEH1HAN;DE23250207002730150140;1
25030000;0000115824;HYVEDEMM300;DE28200300000000115824;1
25040066;0771594932;COBADEFFXXX;DE66250400660771594932;1
25050000;0147396311;NOLADE2HXXX;DE02250500000147396311;1
25050180;1103867469;SPKHDE2HXXX;DE11250501801103867469;1
25050299;1450269540;SPKHDE2HXXX;DE09250501801450269540;19
25050299;3121830520;SPKHDE2HXXX;DE66250501803121830520;19
25050299;5071022133;SPKHDE2HXXX;DE45250501805071022133;19
25050299;7082154415;SPKHDE2HXXX;DE10250501807082154415;19
25055500;0011401880;NOLADE21LBS;DE17250555001140188000;1
25060180;0128688769;HALLDE2HXXX;DE17250601800128688769;1
25060180;4195040763;HALLDE2HXXX;DE57250601804195040763;1
25060180;8471396906;HALLDE2HXXX;DE85250601808471396906;1
25060701;1984067983;GENODEF1EK1;DE59520604101984067983;1
25069168;6858745768;GENODEF1DES;DE48250691686858745768;1
25069262;6549296030;GENODEF1NST;DE48250692626549296030;1
25069270;1938784975;GENODEF1MUA;DE09250692701938784975;1
25069370;5582746203;GENODEF1WBU;DE03250693705582746203;1
25069503;1554551201;GENODEF1BNT;DE21250695031554551201;1
25070024;0007896483;;;-127
25070066;0008647281;DEUTDE2H265;DE10250700660864728100;18
25070070;0004844643;DEUTDE2HXXX;DE28250700700484464300;18
25070077;0001708361;DEUTDE2H256;DE92250700770170836100;18
25070084;0001740067;;;-127
25070086;0009698184;DEUTDE2H251;DE14250700860969818400;18
25080020;0000636459;DRESDEFF250;DE05250800200063645900;18
25080020;0006536538;DRESDEFF250;DE39250800200006536538;1
25090300;4178794302;GENODEF1LER;DE81285900754178794302;19
25090500;1018528489;GENODEF1S09;DE62250905001018528489;1
25090608;0000462870;DAAEDEDDXXX;DE85300606010000462870;19
25090608;1853179770;DAAEDEDDXXX;DE73300606011853179770;19
25090608;3530831310;DAAEDEDDXXX;DE80300606013530831310;19
25090608;4853710845;DAAEDEDDXXX;DE35300606014853710845;19
25090608;6362449952;DAAEDEDDXXX;DE22300606016362449952;19
25090608;7432907161;DAAEDEDDXXX;DE31300606017432907161;19
25090608;8589532421;DAAEDEDDXXX;DE97300606018589532421;19
25090608;9378637423;DAAEDEDDXXX;DE91300606019378637423;19
25090900;1434759564;GENODEF1P09;DE67250909001434759564;1
25151270;7395437242;NOLADE21BAH;DE48251512707395437242;1
25151371;9568597083;NOLADE21BUF;DE98251513719568597083;1
25152375;4711770372;NOLADE21WAL;DE78251523754711770372;1
25152490;3801063847;NOLADE21WST;DE94251524903801063847;1
25190001;6344899801;VOHADE2HXXX;DE79251900016344899801;1
25193331;6736309191;GENODEF1PAT;DE87251933316736309191;1
25250001;4753475914;NOLADE21PEI;DE55252500014753475914;1
25260010;6291009488;GENODEF1PEV;DE19252600106291009488;1
25410111;0582059226;ESSEDE5F254;DE52254101110582059226;1
25430000;0000546143;HYVEDEMM300;DE75200300000000546143;1
25440047;0804387921;COBADEFFXXX;DE32254400470804387921;1
25450001;6341396023;NOLADE21HMS;DE64254500016341396023;1
25450110;9734002562;NOLADE21SWB;DE09254501109734002562;1
25451345;5463227610;NOLADE21PMT;DE03254513455463227610;1
25451450;7433483778;NOLADE21BOW;DE93254514507433483778;1
25451655;4513114829;NOLADE21HEO;DE22254516554513114829;1
25462160;1140145176;GENODEF1HMP;DE24254621601140145176;1
25462680;6994379639;GENODEF1COP;DE44254626806994379639;1
25470024;0007534696;DEUTDEDB254;DE65254700240753469600;18
25470073;0008463655;DEUTDE2H254;DE68254700730846365500;18
25471024;0009900879;DEUTDEDB264;DE70254710240990087900;18
25471073;0009699513;DEUTDE2H264;DE38254710730969951300;18
25480021;0000501864;DRESDEFF254;DE07254800210050186400;18
25480021;0004655374;DRESDEFF254;DE61254800210004655374;1
25491071;3487993592;GENODEF1RIV;DE22254910713487993592;1
25491273;1281255252;GENODED1AEZ;DE53254912731281255252;1
25491744;1961545044;GENODED1BMU;DE22254917441961545044;1
25541426;0127767258;COBADEFFXXX;DE68255414260127767258;1
25551480;2207453560;NOLADE21SHG;DE26255514802207453560;1
25562308;6015525642;GENODEF1BNE;DE32255623086015525642;1
25562604;8383885689;GENODEF1HEL;DE24255626048383885689;1
25591413;4230974352;GENODEF1BCK;DE56255914134230974352;1
25591748;8448809352;GENODEF1OBK;DE06255917488448809352;1
25621327;2526498885;OLBODEH2XXX;DE71280200502526498885;19
25641302;0148885751;COBADEFFXXX;DE02256413020148885751;1
25650106;9097159942;NOLADE21NIB;DE14256501069097159942;1
25651325;2561631470;BRLADE21DHZ;DE97256513252561631470;1
25662540;2312974300;GENODEF1STY;DE09256625402312974300;1
25663584;9406908557;GENODEF1HOY;DE67256635849406908557;1
25690009;1443617587;GENODEF1NIN;DE75256900091443617587;1
25691633;9588077110;GENODEF1SUL;DE34256916339588077110;1
25730000;0000336479;HYVEDEMM300;DE83200300000000336479;1
25740061;0149598564;COBADEFFXXX;DE82257400610149598564;1
25750001;4040808406;NOLADE21CEL;DE14257500014040808406;1
25761894;5126934107;GENODEF1WIK;DE68257618945126934107;1
25770024;0006141006;DEUTDEDB257;DE08257700240614100600;18
25770069;0007401672;DEUTDE2H257;DE22257700690740167200;18
25780022;0000467388;DRESDEFF257;DE09257800220046738800;18
25780022;0007535809;DRESDEFF257;DE82257800220007535809;1
25791516;8463788964;GENODEF1HKB;DE56257915168463788964;1
25791635;2897242206;GENODEF1HMN;DE93257916352897242206;1
25840048;0191052001;COBADEFFXXX;DE07258400480191052001;1
25841403;0640399201;COBADEFFXXX;DE24258414030640399201;1
25841708;0194419856;COBADEFFXXX;DE84258417080194419856;1
25850110;2827727021;NOLADE21UEL;DE74258501102827727021;1
25851335;3767316254;NOLADE21DAN;DE43258513353767316254;1
25851660;4042831984;NOLADE21SOL;DE24258516604042831984;1
25861395;5400007644;GENODEF1DAN;DE33258613955400007644;1
25861990;9526664060;GENODEF1CLZ;DE48258619909526664060;1
25862292;9982973872;GENODEF1EUB;DE08258622929982973872;1
25863489;8935088024;GENODEF1WOT;DE90258634898935088024;1
25891483;8191298675;GENODEF1LCH;DE53258914838191298675;1
25891636;9065479070;GENODEF1SOL;DE19258916369065479070;1
25910111;0152954423;ESSEDE5F259;DE98259101110152954423;1
25930000;0000208991;HYVEDEMM300;DE20200300000000208991;1
25940033;0540440589;COBADEFFXXX;DE55259400330540440589;1
25950001;1019298785;NOLADE21HIS;DE56259500011019298785;1
25950130;1000396713;NOLADE21HIK;DE59259501301000396713;1
25960192;0286192349;HALLDE2HHIL;DE09259601920286192349;1
25960192;8458293985;HALLDE2HHIL;DE28259601928458293985;1
25970024;0003760352;DEUTDEDB259;DE81259700240376035200;18
25970074;0009080698;DEUTDE2H259;DE70259700740908069800;18
25971024;0004241790;DEUTDEDB253;DE11259710240424179000;18
25971071;0008413080;DEUTDE2H253;DE88259710710841308000;18
25980027;0000118175;DRESDEFF259;DE82259800270000118175;1
25980027;0098497382;DRESDEFF259;DE74259800279849738200;18
25990011;1162222982;GENODEF1HIH;DE26259900111162222982;1
25991528;5440125908;GENODEF1SLD;DE08259915285440125908;1
25991911;1650154331;GENODEF1SLD;DE13259915281650154331;1
26010111;0918383167;ESSEDE5F260;DE04260101110918383167;1
26030000;0000244400;HYVEDEMM300;DE09200300000000244400;1
26040030;0989988116;COBADEFFXXX;DE09260400300989988116;1
26050001;3553440292;NOLADE21GOE;DE31260500013553440292;1
26051260;7188119866;NOLADE21DUD;DE61260512607188119866;1
26051450;9842618374;NOLADE21HMU;DE18260514509842618374;1
26060184;0156080202;HALLDE2HGOE;DE84260601840156080202;1
26060184;8591941862;HALLDE2HGOE;DE41260601848591941862;1
26061291;1969665002;GENODEF1DUD;DE37260612911969665002;1
26061556;1460837581;GENODEF1ADE;DE89260615561460837581;1
26062433;1038184267;GENODEF1DRA;DE17260624331038184267;1
26062575;2168210030;GENODEF1RDO;DE77260625752168210030;1
26070024;0009770777;DEUTDEDB260;DE60260700240977077700;18
26070072;0008746885;DEUTDE2H260;DE52260700720874688500;18
26080024;0000220942;DRESDEFF260;DE34260800240022094200;18
26080024;0004469636;DRESDEFF260;DE80260800240004469636;1
26090050;6740621136;GENODEF1GOE;DE18260900506740621136;1
26240039;0165086075;COBADEFFXXX;DE59262400390165086075;1
26250001;7172663846;NOLADE21NOM;DE42262500017172663846;1
26251425;6275065453;NOLADE21EIN;DE60262514256275065453;1
26261396;6619101725;GENODEF1VDA;DE73262613966619101725;1
26261492;4174406301;GENODEF1EIN;DE79262614924174406301;1
26261693;9323308668;GENODEF1HDG;DE40262616939323308668;1
26271424;0003065588;DEUTDEDB262;DE16262714240306558800;18
26271471;0009597584;DEUTDE2H262;DE74262714710959758400;18
26280020;0000247030;DRESDEFF261;DE03262800200024703000;18
26280020;0006359989;DRESDEFF261;DE58262800200006359989;1
26281420;0000590976;DRESDEFF262;DE53262814200059097600;18
26281420;0005242579;DRESDEFF262;DE39262814200005242579;1
26340056;0372860786;COBADEFFXXX;DE30263400560372860786;1
26341072;0550574846;COBADEFFXXX;DE68263410720550574846;1
26350001;6166033966;NOLADE21OHA;DE86263500016166033966;1
26351015;3382362683;NOLADE21HZB;DE26263510153382362683;1
26351445;2643670579;NOLADE21SAC;DE33263514452643670579;1
26361299;4548242062;GENODEF1GOH;DE85263612994548242062;1
26510111;0795875448;ESSEDE5F265;DE14265101110795875448;1
26520017;1531341386;OLBODEH2XXX;DE53280200501531341386;19
26521703;1139486370;OLBODEH2XXX;DE23280200501139486370;19
26522319;1537707037;OLBODEH2XXX;DE30280200501537707037;19
26540070;0622717751;COBADEFFXXX;DE30265400700622717751;1
26550105;6035717260;NOLADE22XXX;DE63265501056035717260;1
26551540;8097997145;NOLADE21BEB;DE40265515408097997145;1
26552286;9345506878;NOLADE21MEL;DE35265522869345506878;1
26560189;0104984315;HALLDE2HOSN;DE51265601890104984315;1
26560189;8529706668;HALLDE2HOSN;DE90265601898529706668;1
26560625;0000249289;DAAEDEDDXXX;DE25300606010000249289;19
26560625;2253133311;DAAEDEDDXXX;DE44300606012253133311;19
26560625;3099875813;DAAEDEDDXXX;DE54300606013099875813;19
26560625;4017344072;DAAEDEDDXXX;DE72300606014017344072;19
26560625;5273148734;DAAEDEDDXXX;DE73300606015273148734;19
26560625;5984034774;DAAEDEDDXXX;DE08300606015984034774;19
26560625;6961203300;DAAEDEDDXXX;DE17300606016961203300;19
26560625;8735988004;DAAEDEDDXXX;DE95300606018735988004;19
26562490;3535492589;GENODEF1HTR;DE40265624903535492589;1
26562694;5990429181;GENODEF1WTB;DE20265626945990429181;1
26563960;2098047771;GENODEF1WHO;DE84265639602098047771;1
26565928;8946839285;GENODEF1HGM;DE72265659288946839285;1
26566939;2347998173;GENODEF1MRZ;DE51265669392347998173;1
26567943;6112741886;GENODEF1NOP;DE67265679436112741886;1
26570024;0001734433;DEUTDEDB265;DE46265700240173443300;18
26570090;0004398418;;;-127
26580070;0000086770;DRESDEFF265;DE83265800700008677000;18
26580070;0006898628;DRESDEFF265;DE60265800700006898628;1
26590025;3138433162;GENODEF1OSV;DE87265900253138433162;1
26620010;1935913589;OLBODEH2XXX;DE29280200501935913589;19
26621413;2004404669;OLBODEH2XXX;DE85280200502004404669;19
26640049;0994125360;COBADEFFXXX;DE77266400490994125360;1
26650001;2978301774;NOLADE21EMS;DE11266500012978301774;1
26660060;7433956757;GENODEF1LIG;DE39266600607433956757;1
26661380;6458548437;GENODEF1HLN;DE34266613806458548437;1
26661494;6923210597;GENODEF1MEP;DE71266614946923210597;1
26661912;8089293001;GENODEF1SPL;DE15280699948089293001;1
26662932;4136932772;GENODEF1LEN;DE40266629324136932772;1
26691213;9445791353;GENODEF1LER;DE72285900759445791353;19
26720028;1308024686;OLBODEH2XXX;DE10280200501308024686;19
26740044;0292661675;COBADEFFXXX;DE74267400440292661675;1
26750001;5234618329;NOLADE21NOH;DE44267500015234618329;1
26760005;8510760309;GENODEF1NEV;DE98280699568510760309;1
26770024;0008268963;DEUTDEDB267;DE04267700240826896300;18
26770095;0004404752;DEUTDE3B267;DE03267700950440475200;18
26840032;0927489559;COBADEFFXXX;DE16268400320927489559;1
26850001;9193808285;NOLADE21GSL;DE83268500019193808285;1
26851410;3260631647;NOLADE21CLZ;DE76268514103260631647;1
26851620;1058803780;NOLADE21SZG;DE29268516201058803780;1
26870024;0007887300;;;-127
26870032;0003766938;DEUTDE2H268;DE33268700320376693800;18
26880063;0000019598;DRESDEFF268;DE81268800630001959800;18
26880063;0002250074;DRESDEFF268;DE89268800630002250074;1
26890019;8864963635;GENODEF1VNH;DE17268900198864963635;1
26891484;4160876308;GENODEF1OHA;DE04268914844160876308;1
26941053;0982599310;COBADEFFXXX;DE43269410530982599310;1
26951311;1285700009;NOLADE21GFW;DE95269513111285700009;1
26971024;0001589142;;;-127
26971038;0008015273;DEUTDE2H269;DE09269710380801527300;18
26981062;0000080354;DRESDEFF269;DE37269810620008035400;18
26981062;0004370996;DRESDEFF269;DE12269810620004370996;1
26991066;0002050234;GENODEF1WOB;DE08269910662050234000;1
27010111;0868585190;ESSEDE5F270;DE34270101110868585190;1
27020000;0012732878;VOWADE2BXXX;DE73270200000012732878;1
27020001;0013349436;AUDFDE21XXX;DE85270200010013349436;1
27020003;0018479024;SKODDE21XXX;DE13270200030018479024;1
27020004;0011820819;ECBKDE21XXX;DE28270200040011820819;1
27020800;0016147993;SEATDE21XXX;DE38270208000016147993;1
27030000;0000240945;HYVEDEMM300;DE77200300000000240945;1
27040080;0873991454;COBADEFFXXX;DE52270400800873991454;1
27062290;8030146007;GENODEF1BOH;DE86270622908030146007;1
27070024;0006848337;DEUTDEDB270;DE39270700240684833700;18
27070030;0009961186;DEUTDE2H270;DE19270700300996118600;18
27070031;0004093357;DEUTDE2H271;DE23270700310409335700;18
27070034;0004605184;DEUTDE2H274;DE38270700340460518400;18
27070041;0009059965;DEUTDE2H279;DE15270700410905996500;18
27070042;0004429528;DEUTDE2H272;DE09270700420442952800;18
27070043;0006458509;DEUTDE2H273;DE71270700430645850900;18
27070079;0001314152;DEUTDE2H275;DE96270700790131415200;18
27072524;0007073315;DEUTDEDB277;DE23270725240707331500;18
27072537;0003506847;DEUTDE2H277;DE53270725370350684700;18
27072724;0002848836;DEUTDEDB276;DE12270727240284883600;18
27072736;0006972210;DEUTDE2H276;DE60270727360697221000;18
27080060;0000012208;DRESDEFF270;DE71270800600001220800;18
27080060;0005559129;DRESDEFF270;DE60270800600005559129;1
27090077;0001050222;GENODEF1WOB;DE73269910661050222000;1
27090618;0000151912;DAAEDEDDXXX;DE19300606010000151912;19
27090618;1866506420;DAAEDEDDXXX;DE83300606011866506420;19
27090618;2903989154;DAAEDEDDXXX;DE06300606012903989154;19
27090618;4186837050;DAAEDEDDXXX;DE92300606014186837050;19
27090618;5148209690;DAAEDEDDXXX;DE05300606015148209690;19
27090618;6901456989;DAAEDEDDXXX;DE62300606016901456989;19
27090618;8127563833;DAAEDEDDXXX;DE58300606018127563833;19
27090618;8833110494;DAAEDEDDXXX;DE80300606018833110494;19
27090900;1738097408;GENODEF1P02;DE91270909001738097408;1
27092555;4382984802;GENODEF1WFV;DE62270925554382984802;1
27131300;5274252195;GENODEF1RTS;DE52271313005274252195;1
27190082;3848071979;GENODEF1HMS;DE78271900823848071979;1
27240004;0958585223;COBADEFFXXX;DE83272400040958585223;1
27290087;1084169169;GENODEF1HMV;DE91272900871084169169;1
27893215;3619779655;GENODEF1BHA;DE63278932153619779655;1
27893359;1442331073;GENODEF1BLG;DE78278933591442331073;1
27893760;5934641892;GENODEF1SES;DE39278937605934641892;1
28010111;0800932663;ESSEDE5F280;DE83280101110800932663;1
28020050;1636156028;OLBODEH2XXX;DE89280200501636156028;1
28021002;2533431921;OLBODEH2XXX;DE57280200502533431921;19
28021301;4069191885;OLBODEH2XXX;DE95280200504069191885;19
28021504;2886848487;OLBODEH2XXX;DE26280200502886848487;19
28021623;2969885948;OLBODEH2XXX;DE19280200502969885948;19
28021705;2735456229;OLBODEH2XXX;DE31280200502735456229;19
28021906;1273057388;OLBODEH2XXX;DE51280200501273057388;19
28022015;2177014457;OLBODEH2XXX;DE40280200502177014457;19
28022412;3115192146;OLBODEH2XXX;DE08280200503115192146;19
28022511;2620896885;OLBODEH2XXX;DE75280200502620896885;19
28022620;1579300399;OLBODEH2XXX;DE54280200501579300399;19
28022822;2349727585;OLBODEH2XXX;DE20280200502349727585;19
28023224;2386592084;OLBODEH2XXX;DE88280200502386592084;19
28023325;1865727882;OLBODEH2XXX;DE02280200501865727882;19
28040046;0231226292;COBADEFFXXX;DE17280400460231226292;1
28042865;0863554298;COBADEFFXXX;DE90280428650863554298;1
28050100;5081859083;BRLADE21LZO;DE20280501005081859083;1
28060228;3898123887;GENODEF1OL2;DE60280602283898123887;1
28061410;5366534156;GENODEF1BRN;DE80280614105366534156;1
28061501;6836861544;GENODEF1CLP;DE30280615016836861544;1
28061679;4903502990;GENODEF1DAM;DE60280616794903502990;1
28061822;6651786937;GENODEF1EDE;DE38280618226651786937;1
28062165;3776084064;GENODEF1RSE;DE17280621653776084064;1
28062249;4426830088;GENODEF1HUD;DE26280622494426830088;1
28062560;9784540006;GENODEF1LON;DE10280625609784540006;1
28062740;3548759336;GENODEF1GBH;DE84280627403548759336;1
28062913;2622657001;GENODEF1BSL;DE59280629132622657001;1
28063253;8895569980;GENODEF1WRE;DE12280632538895569980;1
28063526;3668268306;GENODEF1ESO;DE07280635263668268306;1
28063607;1927124761;GENODEF1BAM;DE53280636071927124761;1
28064090;4621299096;GENODEF1SEI;DE90280640904621299096;1
28064179;1906018144;GENODEF1VEC;DE64280641791906018144;1
28064241;9615722483;GENODEF1NHE;DE19280642419615722483;1
28065061;1387780100;GENODEF1LOG;DE57280650611387780100;1
28065108;5476468868;GENODEF1DIK;DE39280651085476468868;1
28070024;0005154687;DEUTDEDB280;DE19280700240515468700;18
28070057;0005681614;DEUTDEHB280;DE87280700570568161400;18
28090633;0000619108;DAAEDEDDXXX;DE92300606010000619108;19
28090633;1918712496;DAAEDEDDXXX;DE67300606011918712496;19
28090633;2445996384;DAAEDEDDXXX;DE65300606012445996384;19
28090633;3773780643;DAAEDEDDXXX;DE73300606013773780643;19
28090633;5155137135;DAAEDEDDXXX;DE16300606015155137135;19
28090633;5976703876;DAAEDEDDXXX;DE31300606015976703876;19
28090633;6965050332;DAAEDEDDXXX;DE81300606016965050332;19
28090633;8734043219;DAAEDEDDXXX;DE86300606018734043219;19
28220026;5245479280;OLBODEH2XXX;DE24280200505245479280;19
28222208;1476081349;OLBODEH2XXX;DE32280200501476081349;19
28222621;2667469724;OLBODEH2XXX;DE03280200502667469724;19
28240023;0768050783;COBADEFFXXX;DE04282400230768050783;1
28250110;1999588534;BRLADE21WHV;DE85282501101999588534;1
28252760;6150278015;BRLADE21WTM;DE48282527606150278015;1
28262254;1557352933;GENODEF1JEV;DE22282622541557352933;1
28270024;0005198213;DEUTDEDB282;DE67282700240519821300;18
28270056;0006328611;DEUTDEHB282;DE62282700560632861100;18
28280012;0000090074;DRESDEFF282;DE95282800120009007400;18
28280012;0008901155;DRESDEFF282;DE32282800120008901155;1
28290063;1451975773;GENODEF1WHV;DE20282900631451975773;1
28320014;1019638481;OLBODEH2XXX;DE89280200501019638481;19
28321816;1414862086;OLBODEH2XXX;DE72280200501414862086;19
28350000;5022309891;BRLADE21ANO;DE81283500005022309891;1
28420007;1134869486;OLBODEH2XXX;DE27280200501134869486;19
28421030;3220123080;OLBODEH2XXX;DE50280200503220123080;19
28440037;0142646901;COBADEFFXXX;DE94284400370142646901;1
28450000;5750408857;BRLADE21EMD;DE79284500005750408857;1
28470024;0005990163;DEUTDEDB284;DE55284700240599016300;18
28470091;0004911566;DEUTDEHB284;DE81284700910491156600;18
28520009;2664222374;OLBODEH2XXX;DE56280200502664222374;19
28521518;2707676180;OLBODEH2XXX;DE27280200502707676180;19
28540034;0750258649;COBADEFFXXX;DE10285400340750258649;1
28550000;4097438487;BRLADE21LER;DE80285500004097438487;1
28570024;0001890904;DEUTDEDB285;DE59285700240189090400;18
28570092;0003159191;;;-127
29010111;0414301225;ESSEDE5F290;DE64290101110414301225;1
29020000;0115113471;NEELDE22XXX;DE39290200000115113471;1
29020000;4328703691;NEELDE22XXX;DE69290200004328703691;1
29020100;1057419469;BANVDEHBXXX;DE21290201001057419469;1
29030400;0111522195;PLUMDE29XXX;DE49290304000111522195;1
29030400;1709061719;PLUMDE29XXX;DE51290304001709061719;1
29030400;3421694927;PLUMDE29XXX;DE27290304003421694927;1
29030400;5111905398;PLUMDE29XXX;DE42290304005111905398;1
29030400;6687095486;PLUMDE29XXX;DE47290304006687095486;1
29030400;8389239543;PLUMDE29XXX;DE80290304008389239543;1
29040090;0141052129;COBADEFFXXX;DE53290400900141052129;1
29050000;1048092815;BRLADE22XXX;DE80290500001048092815;1
29050101;6128275770;SBREDE22XXX;DE09290501016128275770;1
29070024;0001172824;DEUTDEDBBRE;DE77290700240117282400;18
29070050;0007126501;DEUTDEHBXXX;DE96290700500712650100;18
29070051;0004950655;DEUTDEHB292;DE89290700510495065500;18
29070052;0002194041;DEUTDEHB294;DE06290700520219404100;18
29070058;0002524197;DEUTDEHB293;DE92290700580252419700;18
29070059;0003567922;DEUTDEHB290;DE13290700590356792200;18
29080010;0000017115;DRESDEFF290;DE56290800100001711500;18
29080010;0000404202;DRESDEFF290;DE63290800100000404202;1
29090605;0000507326;DAAEDEDDXXX;DE51300606010000507326;19
29090605;2162461285;DAAEDEDDXXX;DE61300606012162461285;19
29090605;3274687060;DAAEDEDDXXX;DE82300606013274687060;19
29090605;4888929483;DAAEDEDDXXX;DE31300606014888929483;19
29090605;6316291814;DAAEDEDDXXX;DE71300606016316291814;19
29090605;6848522235;DAAEDEDDXXX;DE68300606016848522235;19
29090605;7765397151;DAAEDEDDXXX;DE21300606017765397151;19
29090605;8788851085;DAAEDEDDXXX;DE13300606018788851085;19
29090900;1075373018;GENODEF1P03;DE96290909001075373018;1
29121731;1405016505;OLBODEH2XXX;DE28280200501405016505;19
29151700;2868606282;BRLADE21SYK;DE73291517002868606282;1
29152300;6122895953;BRLADE21OHZ;DE83291523006122895953;1
29152550;9203359782;BRLADE21SHL;DE38291525509203359782;1
29152670;8119144858;BRLADE21VER;DE64291526708119144858;1
29172624;0001515584;DEUTDEDB291;DE14291726240151558400;18
29172655;0009551813;DEUTDEHB291;DE85291726550955181300;18
29210111;0863065938;ESSEDE5F292;DE41292101110863065938;1
29240024;0361358526;COBADEFFXXX;DE50292400240361358526;1
29250000;7671101036;BRLADE21BRS;DE52292500007671101036;1
29250150;6835669748;BRLADE21BRK;DE30292501506835669748;1
29280011;0000098279;DRESDEFF292;DE74292800110009827900;18
29280011;0009309995;DRESDEFF292;DE86292800110009309995;1
30010111;0301674829;ESSEDE5F300;DE76300101110301674829;1
30020300;1401512500;CCBADE31RBS;DE56300203001401512500;1
30020500;1809157017;BHFBDEFF500;DE88500202001809157017;19
30020900;0103683371;CMCIDEDDXXX;DE11300209000103683371;1
30020900;1606003458;CMCIDEDDXXX;DE49300209001606003458;1
30020900;3407536492;CMCIDEDDXXX;DE84300209003407536492;1
30020900;4755162793;CMCIDEDDXXX;DE32300209004755162793;1
30020900;6435875344;CMCIDEDDXXX;DE40300209006435875344;1
30020900;7777771722;CMCIDEDDXXX;DE87300209007777771722;1
30020900;8175301990;CMCIDEDDXXX;DE86300209008175301990;1
30020900;8888889799;CMCIDEDDXXX;DE41300209008888889799;1
30020900;9551925130;CMCIDEDDXXX;DE26300209009551925130;1
30020900;9741291998;CMCIDEDDXXX;DE92300209009741291998;1
30020900;9903847953;CMCIDEDDXXX;DE08300209009903847953;1
30022000;2477671974;NRWBDEDMXXX;DE65300220002477671974;1
30025500;1512719442;PORTDEDDXXX;DE23300255001512719442;1
30030100;1160316639;PULSDEDDXXX;DE87300301001160316639;1
30030400;7194370867;FXDBDE31XXX;DE43300304007194370867;1
30030500;1145439768;CUABDED1XXX;DE91300305001145439768;1
30030600;7058072740;ETRIDE31XXX;DE50300306007058072740;1
30030880;1071649497;TUBDDEDDXXX;DE02300308801071649497;1
30030900;9692535124;MEFIDEMM300;DE20300309009692535124;1
30040000;0747407569;COBADEFFXXX;DE52300400000747407569;1
30040048;0974981380;COBADEFFXXX;DE25300400480974981380;1
30050000;1436976110;WELADEDDXXX;DE92300500001436976110;1
30050110;7881797976;DUSSDEDDXXX;DE16300501107881797976;1
30060010;1040517106;GENODEDDXXX;DE90300600101040517106;1
30060601;0000335827;DAAEDEDDXXX;DE35300606010000335827;1
30060992;1333435177;GENODEF1P05;DE20300609921333435177;1
30070010;0003624848;DEUTDEDDXXX;DE05300700100362484800;18
30070024;0005771118;;;-127
30080000;0000084050;DRESDEFF300;DE52300800000008405000;18
30080000;0006232733;DRESDEFF300;DE17300800000006232733;1
30080005;0000094080;DRESDEF1S04;DE75300800050009408000;18
30080005;0005953554;DRESDEF1S04;DE58300800050005953554;1
30080022;0000060203;DRESDEFFI28;DE92300800220006020300;18
30080022;0002202001;DRESDEFFI28;DE43300800220002202001;1
30080038;0000046644;DRESDEF1S05;DE18300800380004664400;18
30080038;0005089104;DRESDEF1S05;DE59300800380005089104;1
30080041;0000013109;DRESDEFFI29;DE70300800410001310900;18
30080041;0001603213;DRESDEFFI29;DE24300800410001603213;1
30080053;0000074317;DRESDEFFI30;DE21300800530007431700;18
30080053;0006842102;DRESDEFFI30;DE12300800530006842102;1
30080055;0000090803;DRESDEFF309;DE27300800550009080300;18
30080055;0006433665;DRESDEFF309;DE48300800550006433665;1
30080057;0000085169;DRESDEFF316;DE34300800570000085169;1
30080057;0000693716;DRESDEFF316;DE55300800570069371600;18
30080057;0941541529;;;-124
30080061;0000010352;DRESDEFFI31;DE14300800610000010352;1
30080061;0000942352;DRESDEFFI31;DE13300800610094235200;18
30080074;0000027042;DRESDEFFI32;DE83300800740002704200;18
30080074;0002345097;DRESDEFFI32;DE35300800740002345097;1
30080095;0000057034;DRESDEFFI33;DE55300800950005703400;18
30080095;0003436870;DRESDEFFI33;DE35300800950003436870;1
30120400;2671256078;;;-124
30120500;1635684830;BANVDEHB300;DE44301205001635684830;1
30120764;0396654462;;;-124
30120764;2419053905;HYVEDEMM419;DE17762200732419053905;19
30130600;3650225294;ISBKDEFXDUS;DE20301306003650225294;1
30150200;1598801353;WELADED1KSD;DE76301502001598801353;1
30160213;6036566793;GENODED1DNE;DE96301602136036566793;1
30220190;0396430820;HYVEDEMM414;DE53302201900396430820;1
30351220;8443242162;WELADED1HAA;DE51303512208443242162;1
30550000;8027596678;WELADEDNXXX;DE96305500008027596678;1
30551240;7275457336;WELADED1KST;DE93305512407275457336;1
30560090;9201735472;GENODED1NSS;DE17305600909201735472;1
30560548;9827906589;GENODED1NLD;DE24305605489827906589;1
31010111;0780804167;ESSEDE5F310;DE31310101110780804167;1
31040015;0554131333;COBADEFFXXX;DE59310400150554131333;1
31050000;4547042798;MGLSDE33XXX;DE93310500004547042798;1
31060181;3046849379;GENODED1GBM;DE96310601813046849379;1
31060517;9127159219;GENODED1MRB;DE08310605179127159219;1
31062154;2795621191;GENODED1KBN;DE51310621542795621191;1
31062553;3371643965;GENODED1NKR;DE42310625533371643965;1
31070001;0006650089;DEUTDEDD310;DE36310700010665008900;18
31070024;0005860549;DEUTDEDB310;DE26310700240586054900;18
31080015;0000025331;DRESDEFF310;DE08310800150002533100;18
31080015;0004171304;DRESDEFF310;DE15310800150004171304;1
31080061;0000085200;DRESDEFFI34;DE95310800610008520000;18
31080061;0004251145;DRESDEFFI34;DE94310800610004251145;1
31251220;4534710704;WELADED1ERK;DE81312512204534710704;1
31261282;9808822382;GENODED1EHE;DE26312612829808822382;1
31263359;2981490633;GENODED1LOE;DE27312633592981490633;1
31460290;5151263994;GENODED1VSN;DE37314602905151263994;1
31470004;0006788756;DEUTDEDD314;DE25314700040678875600;18
31470024;0008807760;DEUTDEDB314;DE06314700240880776000;18
32040024;0376447988;COBADEFFXXX;DE26320400240376447988;1
32050000;9979654952;SPKRDE33XXX;DE31320500009979654952;1
32051996;9446396617;WELADED1STR;DE92320519969446396617;1
32060362;6017621791;GENODED1HTK;DE81320603626017621791;1
32061384;4045752823;GENODED1GDL;DE26320613844045752823;1
32061414;5899346035;GENODED1KMP;DE07320614145899346035;1
32070024;0004038295;DEUTDEDB320;DE03320700240403829500;18
32070080;0008588782;DEUTDEDD320;DE03320700800858878200;18
32080010;0000056844;DRESDEFF320;DE04320800100005684400;18
32080010;0004045936;DRESDEFF320;DE33320800100004045936;1
32250050;7912395394;WELADED1GOC;DE85322500507912395394;1
32440023;0672984234;COBADEFFXXX;DE85324400230672984234;1
32450000;3261382828;WELADED1KLE;DE93324500003261382828;1
32460422;7580343117;GENODED1KLL;DE74324604227580343117;1
32470024;0003823622;DEUTDEDB324;DE92324700240382362200;18
32470077;0006703326;;;-127
33010111;0932814797;ESSEDE5F330;DE57330101110932814797;1
33020190;0396172471;HYVEDEMM809;DE39330201900396172471;1
33020190;1434178998;HYVEDEMM473;DE66600202901434178998;19
33030000;9043264556;GGABDE31XXX;DE94330300009043264556;1
33040001;0926832729;COBADEFFXXX;DE34330400010926832729;1
33040310;0304288442;COBADEFFXXX;DE03330403100304288442;1
33050000;3978977712;WUPSDE33XXX;DE92330500003978977712;1
33060098;3434870720;GENODED1CVW;DE24330600983434870720;1
33060592;1034936154;GENODED1SPW;DE02330605921034936154;1
33060592;2940659771;GENODED1SPW;DE87330605922940659771;1
33060592;4799058711;GENODED1SPW;DE98330605924799058711;1
33060592;6586473532;GENODED1SPW;DE23330605926586473532;1
33060592;8486618608;GENODED1SPW;DE85330605928486618608;1
33060616;0000141321;DAAEDEDDXXX;DE20300606010000141321;19
33060616;1567218023;DAAEDEDDXXX;DE42300606011567218023;19
33060616;2421631730;DAAEDEDDXXX;DE65300606012421631730;19
33060616;3732225842;DAAEDEDDXXX;DE03300606013732225842;19
33060616;4470703826;DAAEDEDDXXX;DE51300606014470703826;19
33060616;5735665442;DAAEDEDDXXX;DE65300606015735665442;19
33060616;6576708846;DAAEDEDDXXX;DE62300606016576708846;19
33060616;8125198836;DAAEDEDDXXX;DE71300606018125198836;19
33070024;0005075783;;;-127
33070090;0002540508;DEUTDEDWXXX;DE91330700900254050800;18
33080030;0000058087;DRESDEFF332;DE03330800300005808700;18
33080030;0001152683;DRESDEFF332;DE74330800300001152683;1
33440035;0744354243;COBADEFFXXX;DE15334400350744354243;1
33450000;3875361259;WELADED1VEL;DE92334500003875361259;1
33451220;4513365686;WELADED1HGH;DE03334512204513365686;1
34040049;0985558677;COBADEFFXXX;DE50340400490985558677;1
34050000;1917316455;WELADEDRXXX;DE28340500001917316455;1
34051350;2602192946;WELADED1RVW;DE10340513502602192946;1
34051570;5953813531;WELADED1WMK;DE98340515705953813531;1
34060094;3954066530;VBRSDE33XXX;DE20340600943954066530;1
34070024;0007810948;DEUTDEDB340;DE77340700240781094800;18
34070093;0002172898;DEUTDEDW340;DE06340700930217289800;18
34080031;0000029725;DRESDEFF340;DE84340800310002972500;18
34080031;0009331218;DRESDEFF340;DE42340800310009331218;1
34240050;0957333845;COBADEFFXXX;DE35342400500957333845;1
34250000;3887367955;SOLSDE33XXX;DE70342500003887367955;1
34270024;0008531295;DEUTDEDB342;DE84342700240853129500;18
34270094;0004934097;DEUTDEDW342;DE85342700940493409700;18
34280032;0000013304;DRESDEFF342;DE54342800320001330400;18
34280032;0003094654;DRESDEFF342;DE53342800320003094654;1
35010111;0852976098;ESSEDE5F350;DE09350101110852976098;1
35020030;9731621318;NBAGDE3EXXX;DE24360200309731621318;19
35040038;0560646292;COBADEFFXXX;DE66350400380560646292;1
35040085;0491214308;;;-124
35050000;2238442434;DUISDE33XXX;DE24350500002238442434;1
35060190;8859325000;GENODED1DKD;DE95350601908859325000;1
35060386;1148005179;GENODED1VRR;DE76350603861148005179;1
35060632;0000363723;DAAEDEDDXXX;DE48300606010000363723;19
35060632;1785453064;DAAEDEDDXXX;DE27300606011785453064;19
35060632;2960224871;DAAEDEDDXXX;DE24300606012960224871;19
35060632;3724841261;DAAEDEDDXXX;DE93300606013724841261;19
35060632;5077377681;DAAEDEDDXXX;DE26300606015077377681;19
35060632;6301126892;DAAEDEDDXXX;DE57300606016301126892;19
35060632;7261555731;DAAEDEDDXXX;DE18300606017261555731;19
35060632;8641015389;DAAEDEDDXXX;DE31300606018641015389;19
35070024;0001774512;DEUTDEDB350;DE73350700240177451200;18
35070030;0004009718;;;-127
35080070;0000090517;DRESDEFF350;DE13350800700000090517;1
35080070;0006425410;DRESDEFF350;DE03350800700642541000;18
35211012;0632821577;ESSEDE5F352;DE53352110120632821577;1
35251000;1143776142;WELADED1DIN;DE64352510001143776142;1
35261248;9928988195;GENODED1DLK;DE95352612489928988195;1
35450000;1236460572;WELADED1MOR;DE89354500001236460572;1
35451460;2636312759;;;-124
35451775;9210723095;;;-124
35461106;5618407200;GENODED1NRH;DE58354611065618407200;1
35640064;0822617762;COBADEFFXXX;DE19356400640822617762;1
35650000;2563507348;WELADED1WES;DE70356500002563507348;1
35660599;2452075167;GENODED1RLW;DE12356605992452075167;1
35850000;7146800268;WELADED1EMR;DE84358500007146800268;1
35860245;3489587679;GENODED1EMR;DE80358602453489587679;1
36010043;1040618807;PBNKDEFF360;DE51360100431040618807;1
36010043;6111330707;PBNKDEFF360;DE38360100436111330707;1
36010111;0027029069;ESSEDE5F360;DE51360101112702906900;1
36010600;8583718738;GABKDE31XXX;DE50360106008583718738;1
36010699;2442349455;GABKDE31699;DE79360106992442349455;1
36020030;7864108040;NBAGDE3EXXX;DE79360200307864108040;1
36020186;0396948003;HYVEDEMM360;DE44360201860396948003;1
36020186;3961017644;HYVEDEMMXXX;DE27700202703961017644;19
36020700;2346572151;HSTBDEH1ESS;DE35360207002346572151;1
36040039;0084468435;COBADEFFXXX;DE71360400390084468435;1
36040085;0099757139;;;-124
36050000;9104476412;;;-124
36050105;0010927747;SPESDE3EXXX;DE20360501050010927747;1
36050105;7909973179;SPESDE3EXXX;DE52360501057909973179;1
36060192;2102685906;GENODED1PA2;DE06360601922102685906;1
36060295;2691532065;GENODED1BBE;DE33360602952691532065;1
36060488;4123374094;GENODEM1GBE;DE14360604884123374094;1
36060591;1013531350;GENODED1SPE;DE11360605911013531350;1
36060591;1930099960;GENODED1SPE;DE06360605911930099960;1
36060591;2887036760;GENODED1SPE;DE50360605912887036760;1
36060591;3768605909;GENODED1SPE;DE46360605913768605909;1
36060591;4562798778;GENODED1SPE;DE98360605914562798778;1
36060591;5366507750;GENODED1SPE;DE36360605915366507750;1
36060591;6349276580;GENODED1SPE;DE93360605916349276580;1
36060591;7256409202;GENODED1SPE;DE03360605917256409202;1
36060591;8087889437;GENODED1SPE;DE02360605918087889437;1
36060591;9040697854;GENODED1SPE;DE98360605919040697854;1
36060591;9969994104;GENODED1SPE;DE78360605919969994104;1
36060610;0000155349;DAAEDEDDXXX;DE49300606010000155349;19
36060610;1886380891;DAAEDEDDXXX;DE59300606011886380891;19
36060610;3699612227;DAAEDEDDXXX;DE56300606013699612227;19
36060610;4427625634;DAAEDEDDXXX;DE46300606014427625634;19
36060610;5701425072;DAAEDEDDXXX;DE30300606015701425072;19
36060610;6615328594;DAAEDEDDXXX;DE85300606016615328594;19
36060610;7432710978;DAAEDEDDXXX;DE93300606017432710978;19
36060610;8946873355;DAAEDEDDXXX;DE80300606018946873355;19
36070024;0005905765;DEUTDEDBESS;DE28360700240590576500;18
36070050;0004112462;DEUTDEDEXXX;DE11360700500411246200;18
36080080;0000061098;DRESDEFF360;DE93360800800006109800;18
36080080;0002470377;DRESDEFF360;DE22360800800002470377;1
36210111;0089206962;ESSEDE5F362;DE75362101118920696200;1
36220030;2160759813;NBAGDE3EXXX;DE65360200302160759813;19
36240045;0021933001;COBADEFFXXX;DE13362400450021933001;1
36250000;8968662393;SPMHDE3EXXX;DE16362500008968662393;1
36270024;0192995987;DEUTDEDB362;DE94362700240192995987;1
36270048;0910663457;DEUTDEDE362;DE41362700480910663457;1
36280071;0000042778;DRESDEFF362;DE78362800710004277800;18
36280071;0006093806;DRESDEFF362;DE58362800710006093806;1
36520030;1422708845;NBAGDE3EXXX;DE05360200301422708845;19
36540046;0027586068;COBADEFFXXX;DE78365400460027586068;1
36550000;6774836438;WELADED1OBH;DE97365500006774836438;1
36570024;0607399331;DEUTDEDB365;DE95365700240607399331;1
36570049;0584172158;DEUTDEDE365;DE56365700490584172158;1
36580072;0000020928;DRESDEFF365;DE45365800720002092800;18
36580072;0004770376;DRESDEFF365;DE78365800720004770376;1
36580072;0961473467;;;-124
37010050;1229676020;PBNKDEFF370;DE10370100501229676020;1
37010050;6067533807;PBNKDEFF370;DE34370100506067533807;1
37010111;0031792696;ESSEDE5F370;DE17370101113179269600;1
37010222;3253270955;;;-124
37011000;1322856179;PBNKDEFFETR;DE58370110001322856179;1
37011000;6101323333;PBNKDEFFETR;DE15370110006101323333;1
37013030;8115117732;DEZMDE31XXX;DE61370130308115117732;1
37020090;0396587957;HYVEDEMM429;DE53370200900396587957;1
37030700;1375691129;WWBADE31XXX;DE27370307001375691129;1
37030800;8582961892;ISBKDEFXKOL;DE38370308008582961892;1
37040044;0039478603;COBADEFFXXX;DE20370400440039478603;1
37040048;0010723460;COBADEFFXXX;DE51370400480010723460;1
37050198;6003820260;COLSDE33XXX;DE38370501986003820260;1
37050299;0103199311;COKSDE33XXX;DE53370502990103199311;1
37050299;1538356682;COKSDE33XXX;DE54370502991538356682;1
37050299;3119214447;COKSDE33XXX;DE77370502993119214447;1
37050299;4704969122;COKSDE33XXX;DE59370502994704969122;1
37050299;6192739461;COKSDE33XXX;DE83370502996192739461;1
37050299;7611811089;COKSDE33XXX;DE70370502997611811089;1
37060120;3788122470;GENODED1PA7;DE44370601203788122470;1
37060193;8328956617;GENODED1PAX;DE33370601938328956617;1
37060590;1023469467;GENODED1SPK;DE49370605901023469467;1
37060590;4599337471;GENODED1SPK;DE35370605904599337471;1
37060590;8514696944;GENODED1SPK;DE80370605908514696944;1
37060615;0000574538;DAAEDEDDXXX;DE03300606010000574538;19
37060615;1987995932;DAAEDEDDXXX;DE55300606011987995932;19
37060615;3203313069;DAAEDEDDXXX;DE03300606013203313069;19
37060615;4417079419;DAAEDEDDXXX;DE83300606014417079419;19
37060615;5375028731;DAAEDEDDXXX;DE07300606015375028731;19
37060615;6560397202;DAAEDEDDXXX;DE15300606016560397202;19
37060615;7076220797;DAAEDEDDXXX;DE58300606017076220797;19
37060615;8659158154;DAAEDEDDXXX;DE32300606018659158154;19
37060993;2340585899;GENODEF1P13;DE14370609932340585899;1
37062124;9157913864;GENODED1BGL;DE09370621249157913864;1
37062365;5545483450;GENODED1FHH;DE84370623655545483450;1
37062600;4280314442;GENODED1PAF;DE18370626004280314442;1
37063367;7396177905;GENODED1FKH;DE87370633677396177905;1
37069101;1983491886;GENODED1AEG;DE29370691011983491886;1
37069103;7253006980;GENODED1ALD;DE35370691037253006980;1
37069125;1831074074;GENODED1RKO;DE48370691251831074074;1
37069153;4610096897;GENODED1HCK;DE32370691534610096897;1
37069164;4656022227;GENODED1MBU;DE02370691644656022227;1
37069252;9259846665;GENODED1ERE;DE34370692529259846665;1
37069302;9682045040;GENODED1GLK;DE08370693029682045040;1
37069303;6937501003;GENODED1GKK;DE83370693036937501003;1
37069306;3018618876;GENODED1GRB;DE03370693063018618876;1
37069322;6961196335;GENODED1EGY;DE81370693226961196335;1
37069330;2643140686;GENODED1HAW;DE41370693302643140686;1
37069331;2325250600;GENODED1KHO;DE08370693312325250600;1
37069342;4780992471;GENODED1HMB;DE40370693424780992471;1
37069354;3358939022;GENODED1HRB;DE21370694123358939022;1
37069355;9500304640;GENODED1AHO;DE22370693559500304640;1
37069381;6920207705;GENODED1IMM;DE40370693816920207705;1
37069401;5375116032;GENODED1JUK;DE24370694015375116032;1
37069405;3644377732;GENODED1KAA;DE61370694053644377732;1
37069412;8954754554;GENODED1HRB;DE43370694128954754554;1
37069427;2941289552;GENODED1DHK;DE86370694272941289552;1
37069429;6202715590;GENODED1KNL;DE76370694296202715590;1
37069472;3222219107;GENODED1ERF;DE66370694723222219107;1
37069520;3961207249;GENODED1RST;DE73370695203961207249;1
37069521;3983678920;GENODED1MNH;DE88370695213983678920;1
37069524;5464066065;GENODED1MUC;DE09370695245464066065;1
37069577;1278885840;GENODED1RKO;DE06370691251278885840;1
37069627;8428998244;GENODED1RBC;DE89370696278428998244;1
37069639;6683409659;GENODED1WND;DE65370696396683409659;1
37069642;6457775170;GENODED1SMR;DE07370696426457775170;1
37069707;2396369420;GENODED1SAM;DE53370697072396369420;1
37069720;3878731009;GENODED1SLE;DE81370697203878731009;1
37069805;4204041674;GENODED1WVI;DE21370698054204041674;1
37069833;7894277542;GENODED1WSL;DE27370698337894277542;1
37069840;7440957778;GENODED1WPF;DE76370698407440957778;1
37069991;4149715040;GENODED1BRL;DE88370699914149715040;1
37070000;0213598633;DEUTDEDK402;DE94370700000213598633;1
37070024;0207413656;DEUTDEDBKOE;DE16370700240207413656;1
37070060;0326788778;DEUTDEDKXXX;DE40370700600326788778;1
37080040;0000030752;DRESDEFF370;DE72370800400003075200;18
37080040;0001628709;DRESDEFF370;DE25370800400001628709;1
37080096;0000034344;DRESDEF1S06;DE43370800960003434400;18
37080096;0005405735;DRESDEF1S06;DE32370800960005405735;1
37080097;0000057903;DRESDEF1S07;DE80370800970005790300;18
37080097;0001728014;DRESDEF1S07;DE22370800970001728014;1
37080099;0000092435;DRESDEFFI36;DE53370800990009243500;18
37080099;0003170763;DRESDEFFI36;DE02370800990003170763;1
37160087;3368191824;GENODED1CGN;DE77371600873368191824;1
37161289;2146810228;GENODED1BRH;DE32371612892146810228;1
37540050;0034164604;COBADEFFXXX;DE10375400500034164604;1
37551020;8532767749;WELADED1LEI;DE21375510208532767749;1
37551440;4465343632;WELADEDLLEV;DE33375514404465343632;1
37551670;8062984649;;;-124
37551780;1359251210;WELADED1LAF;DE74375517801359251210;1
37560092;8923248936;GENODED1RWL;DE91375600928923248936;1
37570024;0747678186;DEUTDEDB375;DE12375700240747678186;1
37570064;0605878884;DEUTDEDK375;DE35375700640605878884;1
38010111;0066185771;ESSEDE5F380;DE44380101116618577100;1
38010999;8226390651;DTABDED1AUS;DE17380109998226390651;1
38020090;0396409780;HYVEDEMM402;DE92380200900396409780;1
38020090;1127602480;HYVEDEMM451;DE43793200751127602480;19
38040007;0030226647;COBADEFFXXX;DE31380400070030226647;1
38050000;3112797877;COLSDE33XXX;DE89370501983112797877;1
38051290;1065707323;WELADED1HON;DE57380512901065707323;1
38060186;4496385271;GENODED1BRS;DE26380601864496385271;1
38070024;0704568554;DEUTDEDB380;DE76380700240704568554;1
38070059;0160990813;DEUTDEDK380;DE79380700590160990813;1
38070724;0801438361;DEUTDEDBXXX;DE63380707240801438361;1
38077724;0683163056;DEUTDEDB383;DE52380777240683163056;1
38080055;0000020576;DRESDEFF380;DE37380800550002057600;18
38080055;0003500201;DRESDEFF380;DE63380800550003500201;1
38160220;6098329038;GENODED1HBO;DE70381602206098329038;1
38250110;2981196542;WELADED1EUS;DE28382501102981196542;1
38260082;4157457638;GENODED1EVB;DE04382600824157457638;1
38440016;0066219257;COBADEFFXXX;DE89384400160066219257;1
38450000;1074653922;WELADED1GMB;DE56384500001074653922;1
38452490;3834194205;WELADED1WIE;DE79384524903834194205;1
38462135;8368577163;GENODED1WIL;DE29384621358368577163;1
38470024;0922872786;DEUTDEDB384;DE17384700240922872786;1
38470091;0389365861;DEUTDEDW384;DE90384700910389365861;1
38621500;1289165338;GENODED1STB;DE78386215001289165338;1
39010111;0047383755;ESSEDE5F390;DE71390101114738375500;1
39040013;0036091110;COBADEFFXXX;DE90390400130036091110;1
39060180;9228260387;GENODED1AAC;DE19390601809228260387;1
39060630;0000341169;DAAEDEDDXXX;DE40300606010000341169;19
39060630;2313976637;DAAEDEDDXXX;DE29300606012313976637;19
39060630;3620392014;DAAEDEDDXXX;DE68300606013620392014;19
39060630;4351005306;DAAEDEDDXXX;DE26300606014351005306;19
39060630;5978007756;DAAEDEDDXXX;DE63300606015978007756;19
39060630;7425682650;DAAEDEDDXXX;DE66300606017425682650;19
39060630;8382670895;DAAEDEDDXXX;DE38300606018382670895;19
39060630;9295821362;DAAEDEDDXXX;DE20300606019295821362;19
39061981;2397002520;GENODED1HNB;DE57390619812397002520;1
39070020;0341304445;DEUTDEDK390;DE07390700200341304445;1
39070024;0985002526;DEUTDEDB390;DE84390700240985002526;1
39080005;0000082958;DRESDEFF390;DE87390800050008295800;18
39080005;0009482115;DRESDEFF390;DE49390800050009482115;1
39080098;0000029555;DRESDEFFI37;DE69390800980002955500;18
39080098;0006450695;DRESDEFFI37;DE37390800980006450695;1
39080099;0000025264;DRESDEFFI38;DE27390800990002526400;18
39080099;0005034978;DRESDEFFI38;DE29390800990005034978;1
39160191;5567924795;GENODED1PA1;DE43391601915567924795;1
39161490;9738093906;GENODED1AAS;DE52391614909738093906;1
39162980;1463188250;GENODED1WUR;DE90391629801463188250;1
39362254;4957666880;GENODED1RSC;DE95393622544957666880;1
39540052;0011969534;COBADEFFXXX;DE47395400520011969534;1
39560201;9233084210;GENODED1DUE;DE51395602019233084210;1
39570024;0341793857;DEUTDEDB395;DE78395700240341793857;1
39570061;0996915506;DEUTDEDK395;DE45395700610996915506;1
39580041;0000071456;DRESDEFF395;DE02395800410007145600;18
39580041;0006945032;DRESDEFF395;DE22395800410006945032;1
40010111;0063110905;ESSEDE5F400;DE53400101116311090500;1
40022000;1251264998;NRWBDEDMMST;DE03400220001251264998;1
40030000;2523034399;MLBKDEH1MUE;DE30400300002523034399;1
40040028;0028665473;COBADEFFXXX;DE94400400280028665473;1
40050000;3239978012;WELADEDDXXX;DE14300500003239978012;19
40060000;1953307627;GENODEMSXXX;DE69400600001953307627;1
40060265;8558975771;GENODEM1DKM;DE45400602658558975771;1
40060560;1061725530;GENODEF1S08;DE05400605601061725530;1
40060560;4806538812;GENODEF1S08;DE67400605604806538812;1
40060560;8912299022;GENODEF1S08;DE84400605608912299022;1
40060614;0000231320;DAAEDEDDXXX;DE91300606010000231320;19
40060614;1773924132;DAAEDEDDXXX;DE43300606011773924132;19
40060614;3005046214;DAAEDEDDXXX;DE31300606013005046214;19
40060614;4482583501;DAAEDEDDXXX;DE84300606014482583501;19
40060614;5181388376;DAAEDEDDXXX;DE68300606015181388376;19
40060614;6299902527;DAAEDEDDXXX;DE21300606016299902527;19
40060614;7042747499;DAAEDEDDXXX;DE34300606017042747499;19
40060614;8316469910;DAAEDEDDXXX;DE67300606018316469910;19
40061238;5219099354;GENODEM1GRV;DE78400612385219099354;1
40069226;4524953999;GENODEM1CND;DE43400692264524953999;1
40069266;8383888791;GENODEM1MAS;DE37400692668383888791;1
40069283;6250859800;GENODEM1SLN;DE64400692836250859800;1
40069348;5073476654;GENODEM1MDB;DE68400693485073476654;1
40069362;1265335958;GENODEM1SAE;DE43400693621265335958;1
40069363;7331369001;GENODEM1SMB;DE45400693637331369001;1
40069371;3730434086;GENODEM1BTH;DE09400693713730434086;1
40069408;9928879584;GENODEM1BAU;DE97400694089928879584;1
40069462;6230336572;GENODEM1MSS;DE33400694626230336572;1
40069477;4976813354;GENODEM1DWU;DE61400694774976813354;1
40069546;3311978830;GENODEM1SDN;DE43400695463311978830;1
40069600;6682118629;GENODEM1MAB;DE67400696006682118629;1
40069601;4145083341;GENODEM1CAN;DE21400696014145083341;1
40069606;2790519288;GENODEM1ERR;DE39400696062790519288;1
40069622;9716740452;GENODEM1LSP;DE93400696229716740452;1
40069636;3873537982;GENODEM1CLE;DE48400696363873537982;1
40069709;2225580525;GENODEM1DLR;DE44400697092225580525;1
40069716;4864749568;GENODEM1SCN;DE45400697164864749568;1
40070024;0503315470;DEUTDEDB400;DE91400700240503315470;1
40070080;0755092475;DEUTDE3B400;DE02400700800755092475;1
40080040;0000080676;DRESDEFF400;DE83400800400008067600;18
40080040;0004388618;DRESDEFF400;DE38400800400004388618;1
40090900;1224629980;GENODEF1P15;DE82400909001224629980;1
40153768;2910382964;WELADED1EMS;DE13401537682910382964;1
40160050;5954888020;GENODEM1MSC;DE16401600505954888020;1
40163720;3927379414;GENODEM1SEE;DE95401637203927379414;1
40164024;8741309375;GENODEM1GRN;DE60401640248741309375;1
40164256;5163402074;GENODEM1LAE;DE82401642565163402074;1
40164352;7939538233;GENODEM1CNO;DE61401643527939538233;1
40164528;2382311432;GENODEM1LHN;DE72401645282382311432;1
40164618;5556128672;GENODEM1OTR;DE46401646185556128672;1
40164901;9616439103;GENODEM1GE1;DE17401649019616439103;1
40165366;8767872918;GENODEM1SEM;DE93401653668767872918;1
40166439;1246881577;GENODEM1LLE;DE67401664391246881577;1
40166800;2370352687;GENODEM1BUL;DE36401668002370352687;1
40340030;0023561560;COBADEFFXXX;DE90403400300023561560;1
40361627;7637986273;GENODEM1WKP;DE81403616277637986273;1
40361906;4513421397;GENODEM1IBB;DE33403619064513421397;1
40363433;9860657976;GENODEM1HRL;DE24403634339860657976;1
40370024;0931641548;DEUTDEDB403;DE74403700240931641548;1
40370079;0399073676;DEUTDE3B403;DE29403700790399073676;1
41010111;0016728448;ESSEDE5F410;DE71410101111672844800;1
41040018;0044691945;COBADEFFXXX;DE35410400180044691945;1
41041000;0015026455;COBADEFFXXX;DE12410410000015026455;1
41060120;2841532046;GENODEM1HMM;DE85410601202841532046;1
41061011;8248939865;GENODEM1HBH;DE61410610118248939865;1
41061903;2602421195;GENODEM1BAG;DE83410619032602421195;1
41062215;7679305171;GENODEM1BO1;DE74410622157679305171;1
41070024;0279416260;DEUTDEDB410;DE19410700240279416260;1
41070049;0713698959;DEUTDEDE410;DE09410700490713698959;1
41240048;0094024162;COBADEFFXXX;DE10412400480094024162;1
41260006;4444365595;GENODEM1BEK;DE12412600064444365595;1
41261324;6793262060;GENODEM1EOW;DE86412613246793262060;1
41261419;9383567177;GENODEM1OEN;DE62412614199383567177;1
41262501;2969016405;GENODEM1AHL;DE88412625012969016405;1
41262621;3226932037;GENODEM1SDH;DE09412626213226932037;1
41280043;0000032578;DRESDEFF413;DE91412800430003257800;18
41280043;0005878629;DRESDEFF413;DE81412800430005878629;1
41440018;0083545738;COBADEFFXXX;DE92414400180083545738;1
41460116;6489989502;GENODEM1SOE;DE78414601166489989502;1
41462295;8270272655;GENODEM1WRU;DE71414622958270272655;1
41660124;4363179348;GENODEM1LPS;DE29416601244363179348;1
41661206;5122799399;GENODEM1ANR;DE93416612065122799399;1
41661504;8941093713;GENODEM1LBH;DE96416615048941093713;1
41661719;1102258065;GENODEM1BRI;DE80416617191102258065;1
41662465;7083097426;GENODEM1SGE;DE93416624657083097426;1
41662557;8659655378;GENODEM1WST;DE54416625578659655378;1
41663335;3325506948;GENODEM1HOE;DE32416633353325506948;1
41670024;0104075710;DEUTDEDB416;DE50416700240104075710;1
41670027;0756640945;DEUTDE3B416;DE06416700270756640945;1
41670028;0497168559;DEUTDE3B417;DE79416700280497168559;1
41670029;0143896962;DEUTDE3B414;DE29416700290143896962;1
41670030;0142728518;DEUTDE3B418;DE63416700300142728518;1
42010111;0089856303;ESSEDE5F420;DE07420101118985630300;1
42030600;6183675638;ISBKDEFXGEL;DE47420306006183675638;1
42040040;0018809410;COBADEFFXXX;DE97420400400018809410;1
42050001;0119132907;WELADED1GEK;DE07420500010119132907;1
42070024;0223228803;DEUTDEDB420;DE54420700240223228803;1
42070062;0520043176;DEUTDEDE420;DE53420700620520043176;1
42080082;0000076405;DRESDEFF420;DE97420800820007640500;18
42080082;0002830780;DRESDEFF420;DE04420800820002830780;1
42080082;0937314704;;;-124
42260001;9300723507;GENODEM1GBU;DE95422600019300723507;1
42461435;9090879160;GENODEM1KIH;DE49424614359090879160;1
42610112;0072088706;ESSEDE5F426;DE61426101127208870600;1
42640048;0099054800;COBADEFFXXX;DE06426400480099054800;1
42661008;2334303017;GENODEM1MRL;DE54426610082334303017;1
42661330;5992567361;GENODEM1HLT;DE86426613305992567361;1
42661522;2930829580;GENODEM1HWE;DE70426615222930829580;1
42661717;7217767324;GENODEM1WLW;DE27426617177217767324;1
42662320;6977525094;GENODEM1DST;DE40426623206977525094;1
42680081;0000096854;DRESDEFF426;DE50426800810009685400;18
42680081;0007806242;DRESDEFF426;DE11426800810007806242;1
42840005;0051217470;COBADEFFXXX;DE93428400050051217470;1
42860003;3065481435;BOVBDE3MXXX;DE32428600033065481435;1
42861239;9205184035;GENODEM1RKN;DE78428612399205184035;1
42861387;7228322236;GENODEM1BOB;DE93428613877228322236;1
42861416;7712288202;GENODEM1HDI;DE31428614167712288202;1
42861515;5502249348;GENODEM1BOG;DE24428615155502249348;1
42861608;5009866719;GENODEM1HEI;DE38428616085009866719;1
42861814;9997775048;GENODEM1RHD;DE25428618149997775048;1
42862451;9230353473;GENODEM1RAE;DE08428624519230353473;1
42870024;0620512440;DEUTDEDB428;DE20428700240620512440;1
42870077;0926566149;DEUTDE3B428;DE65428700770926566149;1
43010111;0082618791;ESSEDE5F430;DE39430101118261879100;1
43040036;0045121546;COBADEFFXXX;DE66430400360045121546;1
43060129;5083439616;GENODEM1BOC;DE85430601295083439616;1
43060967;2233504784;GENODEM1GLS;DE75430609672233504784;1
43070024;0133576925;DEUTDEDB430;DE73430700240133576925;1
43070061;0732658051;DEUTDEDE430;DE85430700610732658051;1
43080083;0000098334;DRESDEFF430;DE25430800830009833400;18
43080083;0004446554;DRESDEFF430;DE60430800830004446554;1
44010046;1119127507;PBNKDEFF440;DE42440100461119127507;1
44010046;6121764758;PBNKDEFF440;DE91440100466121764758;1
44010111;0071481795;ESSEDE5F440;DE85440101117148179500;1
44010300;4760394826;;;-124
44020090;0396090799;HYVEDEMM808;DE90440200900396090799;1
44040037;0042314367;COBADEFFXXX;DE49440400370042314367;1
44040085;0080324491;;;-124
44050000;1340576170;WELADEDDXXX;DE91300500001340576170;19
44050199;5654783286;DORTDE33XXX;DE56440501995654783286;1
44060122;1569684803;GENODEM1DNW;DE49440601221569684803;1
44060604;0000821837;DAAEDEDDXXX;DE22300606010000821837;19
44060604;2228395080;DAAEDEDDXXX;DE78300606012228395080;19
44060604;3998810796;DAAEDEDDXXX;DE65300606013998810796;19
44060604;4883033651;DAAEDEDDXXX;DE19300606014883033651;19
44060604;6374329430;DAAEDEDDXXX;DE39300606016374329430;19
44060604;7394901342;DAAEDEDDXXX;DE61300606017394901342;19
44060604;8334686241;DAAEDEDDXXX;DE55300606018334686241;19
44060604;8976480471;DAAEDEDDXXX;DE80300606018976480471;19
44070024;0223882286;DEUTDEDB440;DE69440700240223882286;1
44070050;0333952039;DEUTDEDE440;DE59440700500333952039;1
44080050;0000013031;DRESDEFF440;DE48440800500001303100;18
44080050;0003902064;DRESDEFF440;DE51440800500003902064;1
44080055;0000027418;DRESDEFF446;DE40440800550002741800;18
44080055;0009414601;DRESDEFF446;DE79440800550009414601;1
44080057;0000089151;DRESDEFF447;DE87440800570008915100;18
44080057;0006105005;DRESDEFF447;DE28440800570006105005;1
44090920;1580787843;GENODEF1P04;DE27440909201580787843;1
44160014;6672212923;GENODEM1DOR;DE62441600146672212923;1
44340037;0078069577;COBADEFFXXX;DE77443400370078069577;1
44360002;1320033539;GENODEM1DOR;DE03441600141320033539;1
44361342;4962100032;GENODEM1KWK;DE46443613424962100032;1
44540022;0071029347;COBADEFFXXX;DE95445400220071029347;1
44570004;0875852669;DEUTDEDW445;DE67445700040875852669;1
44570024;0120747128;DEUTDEDB445;DE46445700240120747128;1
44580070;0000098395;DRESDEFF445;DE72445800700009839500;18
44580070;0007938824;DRESDEFF445;DE86445800700007938824;1
44580070;0929718257;;;-124
44761312;4418721750;GENODEM1MEN;DE42447613124418721750;1
44761534;3335950364;GENODEM1NRD;DE93447615343335950364;1
45040042;0023861937;COBADEFFXXX;DE44450400420023861937;1
45050001;1048586259;WELADE3HXXX;DE65450500011048586259;1
45060009;3213612119;GENODEM1HGN;DE66450600093213612119;1
45061524;7497519314;GENODEM1HLH;DE39450615247497519314;1
45070002;0134901864;DEUTDEDW450;DE82450700020134901864;1
45070024;0676471691;DEUTDEDB450;DE27450700240676471691;1
45080060;0000062157;DRESDEFF450;DE10450800600006215700;18
45080060;0008571643;DRESDEFF450;DE15450800600008571643;1
45240056;0094007746;COBADEFFXXX;DE35452400560094007746;1
45260041;7402098779;GENODEM1WTN;DE34452600417402098779;1
45260475;6808638157;GENODEM1BFG;DE96452604756808638157;1
45261547;8998887803;GENODEM1SPO;DE81452615478998887803;1
45660029;8822709033;GENODEM1ALA;DE43456600298822709033;1
45840026;0073571858;COBADEFFXXX;DE33458400260073571858;1
45841031;0088575805;COBADEFFXXX;DE57458410310088575805;1
45860033;1500171990;GENODEM1LHA;DE25458600331500171990;1
45861434;2168957220;GENODEM1KIE;DE26458614342168957220;1
45861617;7695765045;GENODEM1MOM;DE33458616177695765045;1
46010111;0081782184;ESSEDE5F460;DE58460101118178218400;1
46040033;0022936664;COBADEFFXXX;DE16460400330022936664;1
46060040;7277222986;GENODEM1SNS;DE13460600407277222986;1
46061724;8207035119;GENODEM1FRF;DE25460617248207035119;1
46062817;8016842797;GENODEM1SMA;DE49460628178016842797;1
46063405;2192424580;GENODEM1BB1;DE63460634052192424580;1
46070024;0727029103;DEUTDEDB460;DE32460700240727029103;1
46070090;0266072849;DEUTDEDK460;DE05460700900266072849;1
46080010;0000060884;DRESDEFF460;DE80460800100006088400;18
46080010;0006279001;DRESDEFF460;DE91460800100006279001;1
46240016;0066431985;COBADEFFXXX;DE93462400160066431985;1
46260023;9531245243;GENODEM1OLP;DE82462600239531245243;1
46261306;2125114046;GENODEM1ATT;DE06462613062125114046;1
46261607;9154324545;GENODEM1GLG;DE94462616079154324545;1
46261822;8801082728;GENODEM1WDD;DE38462618228801082728;1
46262456;1334271298;GENODEM1HUL;DE55462624561334271298;1
46441003;0092087187;COBADEFFXXX;DE33464410030092087187;1
46461126;2548053076;GENODEM1SRL;DE05464611262548053076;1
46462271;9907686432;GENODEM1ANO;DE90464622719907686432;1
46464453;5238947672;GENODEM1RET;DE64464644535238947672;1
46640018;0017417140;COBADEFFXXX;DE92466400180017417140;1
46660022;7354475401;GENODEM1NEH;DE92466600227354475401;1
46670007;0170270302;DEUTDEDW466;DE28466700070170270302;1
46670024;0681929675;DEUTDEDB961;DE20466700240681929675;1
47240047;0013665478;COBADEFFXXX;DE30472400470013665478;1
47260121;9257453731;DGPBDE3MXXX;DE43472601219257453731;1
47270024;0321593677;DEUTDEDB472;DE81472700240321593677;1
47270029;0567710966;DEUTDE3B472;DE37472700290567710966;1
47640051;0052635720;COBADEFFXXX;DE68476400510052635720;1
47670023;0107511818;DEUTDE3B476;DE17476700230107511818;1
47670024;0825056524;DEUTDEDB476;DE73476700240825056524;1
47840065;0036501365;COBADEFFXXX;DE71478400650036501365;1
47850065;1093318020;WELADED1GTL;DE30478500651093318020;1
47880031;0000016317;DRESDEFF478;DE66478800310001631700;18
47880031;0001474633;DRESDEFF478;DE35478800310001474633;1
48010111;0016951305;ESSEDE5F480;DE82480101111695130500;1
48020086;0396134642;HYVEDEMM344;DE71480200860396134642;1
48020086;5366662598;HYVEDEMM496;DE50850200865366662598;19
48020151;6367232306;LAMPDEDDXXX;DE51480201516367232306;1
48040035;0023246980;COBADEFFXXX;DE73480400350023246980;1
48050000;2246832915;;;-124
48070020;0279412169;DEUTDE3BXXX;DE66480700200279412169;1
48070024;0808301687;DEUTDEDBBIE;DE16480700240808301687;1
48070040;0636377448;DEUTDE3B480;DE47480700400636377448;1
48070042;0798969211;DEUTDE3B484;DE16480700420798969211;1
48070043;0333130343;DEUTDE3B489;DE54480700430333130343;1
48070044;0674000536;DEUTDE3B487;DE96480700440674000536;1
48070045;0815931160;DEUTDE3B413;DE97480700450815931160;1
48070050;0599353020;DEUTDE3B481;DE69480700500599353020;1
48070052;0320506978;DEUTDE3B492;DE93480700520320506978;1
48080020;0000045020;DRESDEFF480;DE83480800200000045020;1
48080020;0005707341;DRESDEFF480;DE26480800200570734100;18
49040043;0086282420;COBADEFFXXX;DE16490400430086282420;1
49070024;0483224273;DEUTDEDB490;DE64490700240483224273;1
49070028;0227989144;DEUTDE3B490;DE80490700280227989144;1
49080025;0000017139;DRESDEFF491;DE77490800250001713900;18
49080025;0004187739;DRESDEFF491;DE42490800250004187739;1
49240096;0049099607;COBADEFFXXX;DE39492400960049099607;1
49440043;0082026839;COBADEFFXXX;DE22494400430082026839;1
50010060;1060525404;PBNKDEFFXXX;DE50500100601060525404;1
50010060;6218732048;PBNKDEFFXXX;DE28500100606218732048;1
50010111;0052357978;ESSEDE5FXXX;DE28500101115235797800;1
50010517;0100748509;INGDDEFFXXX;DE84500105170100748509;1
50010517;1705754353;INGDDEFFXXX;DE84500105171705754353;1
50010517;3312667160;INGDDEFFXXX;DE71500105173312667160;1
50010517;5057030398;INGDDEFFXXX;DE27500105175057030398;1
50010517;6751567121;INGDDEFFXXX;DE93500105176751567121;1
50010517;8471589588;INGDDEFFXXX;DE64500105178471589588;1
50010700;0001000229;DEGUDEFFXXX;DE05500107000001000229;1
50010700;0002666631;DEGUDEFFXXX;DE19500107000002666631;1
50010700;0004414740;DEGUDEFFXXX;DE15500107000004414740;1
50010700;0707781110;DEGUDEFFXXX;DE49500107000707781110;1
50010700;0881992894;DEGUDEFFXXX;DE61500107000881992894;1
50020160;0396043014;;;-124
50020160;2215318284;HYVEDEMM436;DE31731200752215318284;19
50020200;1624320152;BHFBDEFF500;DE54500202001624320152;1
50020300;1400020467;BANVDEHB500;DE56500203001400020467;1
50021000;1285643849;INGBDEFFXXX;DE71500210001285643849;1
50021100;1227529825;FFBKDEFFXXX;DE34500211001227529825;1
50021120;1003740131;FFBKDEFFTHK;DE24500211201003740131;1
50031000;6800666048;TRODDEF1XXX;DE09500310006800666048;1
50040000;0074570784;COBADEFFXXX;DE30500400000074570784;1
50040038;0061858927;COBADEFFXXX;DE94500400380061858927;1
50040040;0035394028;COBADEFFXXX;DE94500400400035394028;1
50040048;0025746706;COBADEFFXXX;DE88500400480025746706;1
50040051;0056835649;COBADEFFXXX;DE66500400510056835649;1
50040052;0011363571;COBADEFFXXX;DE38500400520011363571;1
50040075;0057156755;COBADEFFXXX;DE31500400750057156755;1
50040085;0050154997;;;-124
50040088;0028372104;COBADEFFXXX;DE44500400880028372104;1
50040099;0086325823;COBADEFFXXX;DE84500400990086325823;1
50042500;0079952532;COBADEFFXXX;DE04500425000079952532;1
50044444;0067392566;COBADEFFXXX;DE48500444440067392566;1
50047010;0018766818;COBADEFFXXX;DE38500470100018766818;1
50050201;0001300894;HELADEF1822;DE71500502010001300894;1
50050201;0001467538;HELADEF1822;DE28500502010001467538;1
50050201;0001637681;HELADEF1822;DE87500502010001637681;1
50050201;0001808607;HELADEF1822;DE54500502010001808607;1
50050201;0001980785;HELADEF1822;DE70500502010001980785;1
50050201;0003475632;HELADEF1822;DE28500502010003475632;1
50050201;0005210929;HELADEF1822;DE46500502010005210929;1
50050201;0006831931;HELADEF1822;DE71500502010006831931;1
50050201;0008540007;HELADEF1822;DE87500502010008540007;1
50050201;0010273025;HELADEF1822;DE43500502010010273025;1
50050201;0020933260;HELADEF1822;DE52500502010020933260;1
50050201;0040557240;HELADEF1822;DE57500502010040557240;1
50050201;0060276298;HELADEF1822;DE61500502010060276298;1
50050201;0070971071;HELADEF1822;DE05500502010070971071;1
50050201;0090714063;HELADEF1822;DE05500502010090714063;1
50050201;0092324468;HELADEF1822;DE96500502010092324468;1
50050201;0094039687;HELADEF1822;DE87500502010094039687;1
50050201;0095711499;HELADEF1822;DE16500502010095711499;1
50050201;0097405636;HELADEF1822;DE25500502010097405636;1
50050201;0099103231;HELADEF1822;DE79500502010099103231;1
50050201;0099250959;HELADEF1822;DE63500502010099250959;1
50050201;0099433648;HELADEF1822;DE07500502010099433648;1
50050201;6121202011;HELADEF1822;DE22500502016121202011;1
50050222;2855493273;HELADEF1822;DE37500502222855493273;1
50060500;1439317490;GENODEF1EK1;DE13520604101439317490;1
50061741;8864793528;GENODE51OBU;DE16500617418864793528;1
50069126;1550799181;GENODE51ABO;DE43500691261550799181;1
50069146;8609565825;GENODE51GRC;DE74500691468609565825;1
50069187;2111638521;GENODE51EGE;DE07500691872111638521;1
50069241;2869296255;GENODE51ERB;DE73500692412869296255;1
50069345;7878649421;GENODE51GWB;DE37500693457878649421;1
50069455;7624990560;GENODE51HUT;DE76500694557624990560;1
50069464;9563671704;GENODE51HUI;DE27500694649563671704;1
50069477;5510337790;GENODE51KIF;DE27500694775510337790;1
50069693;4429789448;GENODE51BH1;DE19500696934429789448;1
50069828;1045261520;GENODE51MNO;DE35513625141045261520;1
50069842;4038666865;GENODE51SWB;DE53500698424038666865;1
50069976;3093639169;GENODE51WWI;DE20500699763093639169;1
50070010;0679005953;DEUTDEFFXXX;DE78500700100679005953;1
50070024;0403591183;DEUTDEDBFRA;DE05500700240403591183;1
50073019;0393775225;DEUTDEFF502;DE67500730190393775225;1
50073024;0418612850;DEUTDEDB502;DE75500730240418612850;1
50073081;0296381727;DEUTDE5XXXX;DE42500730810296381727;1
50080000;0000063204;DRESDEFFXXX;DE58500800000000063204;1
50080000;0009870416;DRESDEFFXXX;DE31500800000987041600;18
50080015;0000081231;DRESDEFFI39;DE78500800150008123100;18
50080015;0008117642;DRESDEFFI39;DE04500800150008117642;1
50080025;0000058889;DRESDEF1S01;DE13500800250005888900;18
50080025;0005399560;DRESDEF1S01;DE17500800250005399560;1
50080035;0000015702;DRESDEFFI40;DE11500800350001570200;18
50080035;0003903235;DRESDEFFI40;DE60500800350003903235;1
50080055;0000082703;DRESDEFF516;DE04500800550008270300;18
50080055;0003522121;DRESDEFF516;DE11500800550003522121;1
50080055;0986172536;;;-124
50080057;0000047909;DRESDEFF522;DE53500800570004790900;18
50080057;0001119848;DRESDEFF522;DE74500800570001119848;1
50080060;0000056480;DRESDEFFXXX;DE39500800600005648000;18
50080060;0009374993;DRESDEFFXXX;DE95500800600009374993;1
50080061;0000069036;DRESDEFFLDG;DE83500800610006903600;18
50080061;0002295022;DRESDEFFLDG;DE89500800610002295022;1
50080079;0000047673;DRESDEFFXXX;DE54500800790004767300;18
50080079;0002312708;DRESDEFFXXX;DE49500800790002312708;1
50080080;0000067544;DRESDEFFI41;DE59500800800006754400;18
50080080;0008255705;DRESDEFFI41;DE57500800800008255705;1
50080082;0000084840;DRESDEFFAVB;DE27500800820008484000;18
50080082;0008569805;DRESDEFFAVB;DE40500800820008569805;1
50080092;0000085261;DRESDEFFFCO;DE32500800920008526100;18
50080092;0007785937;DRESDEFFFCO;DE08500800920007785937;1
50080099;0000033169;DRESDEFFI42;DE35500800990003316900;18
50080099;0006090247;DRESDEFFI42;DE77500800990006090247;1
50080300;0000055992;DRESDEFF500;DE49500803000005599200;18
50080300;0048374679;DRESDEFF500;DE85500803000048374679;1
50083007;0000074639;DRESDEFF502;DE05500830070007463900;18
50083007;0063528537;DRESDEFF502;DE43500830070063528537;1
50083838;0000073064;DRESDEFFMBP;DE10500838380007306400;18
50083838;0011382788;DRESDEFFMBP;DE39500838380011382788;1
50090500;1130098754;GENODEF1S12;DE41500905001130098754;1
50090500;8355311926;GENODEF1S12;DE64500905008355311926;1
50090607;0000162620;DAAEDEDDXXX;DE60300606010000162620;19
50090607;1851767431;DAAEDEDDXXX;DE04300606011851767431;19
50090607;3698610061;DAAEDEDDXXX;DE97300606013698610061;19
50090607;5043705995;DAAEDEDDXXX;DE41300606015043705995;19
50090607;5806512513;DAAEDEDDXXX;DE91300606015806512513;19
50090607;6928828199;DAAEDEDDXXX;DE22300606016928828199;19
50090607;8071499804;DAAEDEDDXXX;DE94300606018071499804;19
50090607;9062497689;DAAEDEDDXXX;DE83300606019062497689;19
50090900;1448058853;GENODEF1P06;DE29500909001448058853;1
50092100;2395255684;GENODE51BH2;DE13500921002395255684;1
50092200;2825636865;GENODE51KEL;DE62500922002825636865;1
50110300;8640316929;DVKBDEFFXXX;DE48501103008640316929;1
50110801;1146851064;CHASDEFXVR1;DE39501108011146851064;1
50120383;1001060704;DELBDE33XXX;DE66501203831001060704;1
50120500;0102671642;CRESDE55XXX;DE38501205000102671642;1
50130100;1040447037;DELBDE33XXX;DE57501203831040447037;19
50130100;2881233139;DELBDE33XXX;DE23501203832881233139;19
50130100;5312540171;DELBDE33XXX;DE61501203835312540171;19
50130100;7206449725;DELBDE33XXX;DE03501203837206449725;19
50130100;9138892553;DELBDE33XXX;DE73501203839138892553;19
50130400;8649140572;MEFIDEMM501;DE48501304008649140572;1
50210111;0046790273;ESSEDE51SCH;DE12502101110046790273;1
50210189;1092958366;ESSEDE5FXXX;DE31502101891092958366;19
50210189;4191590503;ESSEDE5FXXX;DE73502101894191590503;19
50210189;7375514198;ESSEDE5FXXX;DE05502101897375514198;19
50210200;1060412611;RABODEFFTAR;DE94502102001060412611;1
50210212;1407707815;RABODEFFDIR;DE24502102121407707815;1
50210600;2173401393;EQUNDEFFXXX;DE12502106002173401393;1
50220200;1449604820;DELBDE33XXX;DE76501203831449604820;19
50220200;2910841820;DELBDE33XXX;DE60501203832910841820;19
50220200;4689557183;DELBDE33XXX;DE45501203834689557183;19
50220200;6433582613;DELBDE33XXX;DE04501203836433582613;19
50220200;9153181549;DELBDE33XXX;DE34501203839153181549;19
50230400;9077422056;ABNADEFFFRA;DE13502304009077422056;1
50310400;1004954911;BARCDEFFXXX;DE96503104001004954911;1
50310455;1052758040;BARCDEF1TCS;DE23503104551052758040;1
50320191;0396605312;HYVEDEMM430;DE28503201910396605312;1
50324000;1019822082;FTSBDEFAXXX;DE48503240001019822082;1
50324040;1413783139;FTSBDEFAMYO;DE62503240401413783139;1
50510111;0024766986;ESSEDE5F505;DE19505101112476698600;1
50510136;1196486058;ESSEDE5FXXX;DE18505101361196486058;19
50510136;7848781638;ESSEDE5FXXX;DE46505101367848781638;19
50510169;1134523253;ESSEDE5FXXX;DE78505101691134523253;19
50510169;8807428923;ESSEDE5FXXX;DE44505101698807428923;19
50510180;1240148242;ESSEDE5FXXX;DE62505101801240148242;19
50510180;5589198311;ESSEDE5FXXX;DE15505101805589198311;19
50520190;0396682268;HYVEDEMM467;DE13505201900396682268;1
50520190;3515600166;HYVEDEMM451;DE60793200753515600166;19
50540028;0010435636;COBADEFFXXX;DE28505400280010435636;1
50560102;3531573802;GENODE51OF2;DE93505601023531573802;1
50561315;9577197721;GENODE51OBH;DE47505613159577197721;1
50570018;0266736891;DEUTDEFF505;DE95505700180266736891;1
50570024;0973154853;DEUTDEDB505;DE28505700240973154853;1
50580005;0000079790;DRESDEFF505;DE85505800050007979000;18
50580005;0032155217;DRESDEFF505;DE40505800050032155217;1
50592200;4572660288;GENODE51DRE;DE67505922004572660288;1
50620700;4909210840;HSTBDEH1HAU;DE55506207004909210840;1
50640015;0059095456;COBADEFFXXX;DE09506400150059095456;1
50661639;1776371043;GENODEF1LSR;DE71506616391776371043;1
50662299;4304340159;GENODEF1BKO;DE35506622994304340159;1
50662669;5730643084;RBMFDEF1XXX;DE47506626695730643084;1
50663699;9605823994;GENODEF1RDB;DE31506636999605823994;1
50670009;0546347684;DEUTDEFF506;DE82506700090546347684;1
50670024;0243788709;DEUTDEDB506;DE88506700240243788709;1
50680002;0000045640;DRESDEFF506;DE27506800020004564000;18
50680002;0052062782;DRESDEFF506;DE80506800020052062782;1
50690000;6307708424;GENODEF1HUV;DE33506900006307708424;1
50740048;0097766306;COBADEFFXXX;DE43507400480097766306;1
50750094;1336026496;HELADEF1GEL;DE12507500941336026496;1
50761613;8707703341;GENODE51NID;DE80507616138707703341;1
50763319;9320422835;GENODE51SLU;DE48530613139320422835;1
50780006;0000091765;DRESDEFF524;DE11507800060000091765;1
50780006;0072400790;DRESDEFF524;DE29507800067240079000;18
50790000;1721407325;GENODE51GEL;DE77507900001721407325;1
50794300;2673925927;GENODE51WBH;DE47507943002673925927;1
50820292;0396781885;HYVEDEMM487;DE89508202920396781885;1
50840005;0017292451;COBADEFFXXX;DE41508400050017292451;1
50861393;5382040760;GENODE51BKZ;DE58508613935382040760;1
50861501;5199579931;GENODE51ABH;DE36508615015199579931;1
50862311;5649064605;GENODE51WGH;DE91508623115649064605;1
50862408;1318056706;GENODE51GRI;DE10508624081318056706;1
50862703;5293368858;GENODE51REI;DE88508627035293368858;1
50862835;8732733897;GENODE51SHM;DE06508628358732733897;1
50862903;1151700162;GENODE51GIN;DE47508629031151700162;1
50863317;5546991963;GENODE51SJ1;DE43508633175546991963;1
50863513;6388757593;GENODE51MIC;DE15508635136388757593;1
50863906;7622694441;GENODE51ORM;DE26508639067622694441;1
50864322;1645435439;GENODE51ORA;DE62508643221645435439;1
50864808;4011669826;GENODE51SJ2;DE65508648084011669826;1
50865224;2129268154;GENODE51MWA;DE47508652242129268154;1
50865503;8176132146;GENODE51EPT;DE04508655038176132146;1
50870005;0828623962;DEUTDEFF508;DE84508700050828623962;1
50870024;0207828539;DEUTDEDB508;DE69508700240207828539;1
50880050;0000092526;DRESDEFF508;DE31508800500009252600;18
50880050;0067594583;DRESDEFF508;DE27508800500067594583;1
50890634;0000456233;DAAEDEDDXXX;DE28300606010000456233;19
50890634;2570839773;DAAEDEDDXXX;DE96300606012570839773;19
50890634;4008383715;DAAEDEDDXXX;DE71300606014008383715;19
50890634;4756965113;DAAEDEDDXXX;DE71300606014756965113;19
50890634;5753162396;DAAEDEDDXXX;DE49300606015753162396;19
50890634;7040784480;DAAEDEDDXXX;DE68300606017040784480;19
50890634;8262980623;DAAEDEDDXXX;DE29300606018262980623;19
50890634;9228043885;DAAEDEDDXXX;DE84300606019228043885;19
50951469;5423892340;HELADEF1HEP;DE37509514695423892340;1
50961206;7441914421;GENODE51RBU;DE26509612067441914421;1
50961312;4493896250;GENODE51GRM;DE98509613124493896250;1
50961592;5837784430;GENODE51FHO;DE40509615925837784430;1
50961685;7228533326;GENODE51ABT;DE86509616857228533326;1
50970004;0185104714;DEUTDEFF509;DE36509700040185104714;1
50970024;0430487973;DEUTDEDB509;DE93509700240430487973;1
51010111;0093259132;ESSEDE5F510;DE13510101119325913200;1
51020000;2477148526;BHFBDEFF500;DE05500202002477148526;19
51020186;0396938797;HYVEDEMM478;DE08510201860396938797;1
51020186;2069273982;HYVEDEMM407;DE59795200702069273982;19
51040038;0022276145;COBADEFFXXX;DE47510400380022276145;1
51050015;1439910827;NASSDE55XXX;DE93510500151439910827;1
51051000;1102484645;PULSDE5WXXX;DE06510510001102484645;1
51070021;0860931593;DEUTDEFF510;DE82510700210860931593;1
51070024;0112104567;DEUTDEDB510;DE59510700240112104567;1
51080060;0000056443;DRESDEFF510;DE04510800600005644300;18
51080060;0021348231;DRESDEFF510;DE73510800600021348231;1
51090636;0000280801;DAAEDEDDXXX;DE85300606010000280801;19
51090636;1678501682;DAAEDEDDXXX;DE57300606011678501682;19
51090636;2657263899;DAAEDEDDXXX;DE94300606012657263899;19
51090636;4470055065;DAAEDEDDXXX;DE47300606014470055065;19
51090636;5278414386;DAAEDEDDXXX;DE78300606015278414386;19
51090636;6041707255;DAAEDEDDXXX;DE26300606016041707255;19
51090636;7230959766;DAAEDEDDXXX;DE79300606017230959766;19
51090636;8716189172;DAAEDEDDXXX;DE07300606018716189172;19
51140029;0016798367;COBADEFFXXX;DE04511400290016798367;1
51161606;4917112254;GENODE51LDD;DE17511616064917112254;1
51170010;0873037623;DEUTDEFF511;DE64511700100873037623;1
51170024;0547708856;DEUTDEDB511;DE68511700240547708856;1
51180041;0000014412;DRESDEFF511;DE69511800410001441200;18
51180041;0022829190;DRESDEFF511;DE65511800410022829190;1
51192200;6281042599;GENODE51WEM;DE64511922006281042599;1
51220910;0001255509;MSFFDEFXCND;DE68512209101255509000;1
51230400;8713071165;ABNADE55FRA;DE19512304008713071165;1
51310111;0038263931;ESSEDE5F513;DE19513101113826393100;1
51340013;0032775302;COBADEFFXXX;DE12513400130032775302;1
51343224;0057719149;COBADEFFXXX;DE06513432240057719149;1
51350025;9700970345;SKGIDE5FXXX;DE85513500259700970345;1
51361021;3768873194;GENODE51HHE;DE26513610213768873194;1
51361704;3647170688;GENODE51PLH;DE96513617043647170688;1
51362514;6001371541;GENODE51MNO;DE31513625146001371541;1
51363407;8337588143;GENODE51PMG;DE13513634078337588143;1
51370008;0748954528;DEUTDEFF513;DE33513700080748954528;1
51370024;0140827717;DEUTDEDB513;DE41513700240140827717;1
51380040;0000061414;DRESDEFF513;DE20513800400006141400;18
51380040;0068337157;DRESDEFF513;DE18513800400068337157;1
51410111;0021387976;ESSEDE5F514;DE96514101112138797600;1
51420300;1245195643;BAERDEF1XXX;DE76514203001245195643;1
51540037;0074191425;COBADEFFXXX;DE53515400370074191425;1
51560231;3268319049;GENODE51WZ1;DE43515602313268319049;1
51570008;0142097516;DEUTDEFF515;DE38515700080142097516;1
51570024;0477885833;DEUTDEDB515;DE04515700240477885833;1
51580044;0000057228;DRESDEFF515;DE12515800440005722800;18
51580044;0043900917;DRESDEFF515;DE56515800440043900917;1
51640043;0023001062;COBADEFFXXX;DE11516400430023001062;1
51861403;2424226364;GENODE51BUT;DE70518614032424226364;1
51861616;4859334769;GENODE51REW;DE81518616164859334769;1
51861806;6687074530;GENODE51OBM;DE76518618066687074530;1
51862677;9468860238;GENODE51BNW;DE32518626779468860238;1
51961023;7799179984;GENODE51ULR;DE35519610237799179984;1
51961515;5921790978;GENODE51HSH;DE42519615155921790978;1
52010111;0095373386;ESSEDE5F520;DE78520101119537338600;1
52040021;0017317050;COBADEFFXXX;DE72520400210017317050;1
52050353;1153891644;HELADEF1KAS;DE66520503531153891644;1
52070012;0251236652;DEUTDEFF520;DE43520700120251236652;1
52070024;0461725425;DEUTDEDB520;DE30520700240461725425;1
52071212;0783771942;DEUTDEFF521;DE93520712120783771942;1
52071224;0805421555;DEUTDEDB521;DE34520712240805421555;1
52080080;0000066114;DRESDEFF520;DE21520800800006611400;18
52080080;0060505087;DRESDEFF520;DE64520800800060505087;1
52090611;0000198927;DAAEDEDDXXX;DE53300606010000198927;19
52090611;2111038184;DAAEDEDDXXX;DE29300606012111038184;19
52090611;3136422015;DAAEDEDDXXX;DE38300606013136422015;19
52090611;4811813080;DAAEDEDDXXX;DE82300606014811813080;19
52090611;5765843766;DAAEDEDDXXX;DE61300606015765843766;19
52090611;7041744076;DAAEDEDDXXX;DE64300606017041744076;19
52090611;8182941597;DAAEDEDDXXX;DE43300606018182941597;19
52090611;9176933017;DAAEDEDDXXX;DE31300606019176933017;19
52240006;0046574065;COBADEFFXXX;DE07522400060046574065;1
52270012;0561950739;DEUTDEFF522;DE11522700120561950739;1
52270024;0560391568;DEUTDEDB522;DE48522700240560391568;1
52410400;1151924812;KOEXDEFAXXX;DE24524104001151924812;1
52420600;1363514984;ABGRDEFFXXX;DE21524206001363514984;1
53040012;0023000916;COBADEFFXXX;DE20530400120023000916;1
53050180;4073804253;HELADEF1FDS;DE17530501804073804253;1
53051396;4123206079;HELADEF1SLU;DE20530513964123206079;1
53070007;0881568003;DEUTDEFF530;DE89530700070881568003;1
53070024;0237620010;DEUTDEDB530;DE81530700240237620010;1
53080030;0000044787;DRESDEFF530;DE06530800300004478700;18
53080030;0081966992;DRESDEFF530;DE04530800300081966992;1
53240048;0064128070;COBADEFFXXX;DE61532400480064128070;1
53250000;1004792423;HELADEF1HER;DE02532500001004792423;1
53250000;2775849642;HELADEF1HER;DE19532500002775849642;1
53250000;4245409149;HELADEF1HER;DE89532500004245409149;1
53250000;5710797677;HELADEF1HER;DE77532500005710797677;1
53250000;7126197618;HELADEF1HER;DE61532500007126197618;1
53250000;8550487917;HELADEF1HER;DE71532500008550487917;1
53270012;0662002570;DEUTDEFF532;DE12532700120662002570;1
53270024;0460002946;DEUTDEDB518;DE89532700240460002946;1
53280081;0000050131;DRESDEFF532;DE87532800810005013100;18
53280081;0045982332;DRESDEFF532;DE05532800810045982332;1
53340024;0091240886;COBADEFFXXX;DE13533400240091240886;1
53370008;0741368534;DEUTDEFF533;DE16533700080741368534;1
53370024;0972492396;DEUTDEDB533;DE79533700240972492396;1
53380042;0000096854;DRESDEFF533;DE18533800420009685400;18
53380042;0078105894;DRESDEFF533;DE40533800420078105894;1
53381843;0000091534;DRESDEFF568;DE49533818430009153400;18
53381843;0007849928;DRESDEFF568;DE59533818430007849928;1
53390635;0000153230;DAAEDEDDXXX;DE32300606010000153230;19
53390635;1793722645;DAAEDEDDXXX;DE14300606011793722645;19
53390635;3088847851;DAAEDEDDXXX;DE45300606013088847851;19
53390635;4009080287;DAAEDEDDXXX;DE54300606014009080287;19
53390635;5201514490;DAAEDEDDXXX;DE48300606015201514490;19
53390635;6076986585;DAAEDEDDXXX;DE56300606016076986585;19
53390635;7258965714;DAAEDEDDXXX;DE73300606017258965714;19
53390635;8563040976;DAAEDEDDXXX;DE36300606018563040976;19
54020090;0396993210;HYVEDEMM482;DE76540200900396993210;1
54020090;5229487576;HYVEDEMM488;DE03100208905229487576;19
54020474;0485791724;;;-124
54020474;2626328906;HYVEDEMM408;DE78720200702626328906;19
54040042;0082159853;COBADEFFXXX;DE16540400420082159853;1
54051660;0101444788;MALADE51LAS;DE61540516600101444788;1
54051660;2510253888;MALADE51LAS;DE96540516602510253888;1
54051660;5153985640;MALADE51LAS;DE07540516605153985640;1
54051660;7667009660;MALADE51LAS;DE71540516607667009660;1
54070024;0471558749;DEUTDEDB540;DE96540700240471558749;1
54070092;0900465663;DEUTDESM540;DE90540700920900465663;1
54080021;0000023991;DRESDEFF540;DE28540800210002399100;18
54080021;0082982110;DRESDEFF540;DE89540800210082982110;1
54080021;0918893945;;;-124
54210111;0018077588;ESSEDE5F542;DE86542101111807758800;1
54220091;0396439620;HYVEDEMM485;DE15542200910396439620;1
54220091;4275992416;HYVEDEMM430;DE20503201914275992416;19
54220576;0400853525;;;-124
54220576;2536632320;HYVEDEMMXXX;DE42700202702536632320;19
54240032;0064191573;COBADEFFXXX;DE49542400320064191573;1
54270024;0649426402;DEUTDEDB542;DE04542700240649426402;1
54270096;0400232523;DEUTDESM542;DE67542700960400232523;1
54280023;0000025525;DRESDEFF542;DE76542800230000025525;1
54280023;0007184840;DRESDEFF542;DE90542800230718484000;18
54510067;1171095758;PBNKDEFF545;DE34545100671171095758;1
54510067;6073689796;PBNKDEFF545;DE74545100676073689796;1
54520071;0412679840;;;-124
54520071;3763499218;;;-3
54520194;0396705016;HYVEDEMM483;DE61545201940396705016;1
54540033;0019508532;COBADEFFXXX;DE76545400330019508532;1
54570024;0224606422;DEUTDEDB545;DE85545700240224606422;1
54570094;0412142214;DEUTDESM545;DE74545700940412142214;1
54580020;0000058877;DRESDEFF545;DE67545800200005887700;18
54580020;0072794597;DRESDEFF545;DE41545800200072794597;1
54620093;0396558701;HYVEDEMM620;DE50546200930396558701;1
54620574;0396836548;;;-124
54620574;3589679406;HYVEDEMM485;DE70542200913589679406;19
54640035;0017348519;COBADEFFXXX;DE69546400350017348519;1
54680022;0000088249;DRESDEFF546;DE73546800220008824900;18
54680022;0058418626;DRESDEFF546;DE54546800220058418626;1
54690623;0000177563;DAAEDEDDXXX;DE22300606010000177563;19
54690623;2354131479;DAAEDEDDXXX;DE32300606012354131479;19
54690623;3499015172;DAAEDEDDXXX;DE23300606013499015172;19
54690623;4670137553;DAAEDEDDXXX;DE79300606014670137553;19
54690623;5801878090;DAAEDEDDXXX;DE94300606015801878090;19
54690623;6903006999;DAAEDEDDXXX;DE54300606016903006999;19
54690623;8038171556;DAAEDEDDXXX;DE95300606018038171556;19
54690623;8834985655;DAAEDEDDXXX;DE77300606018834985655;19
54820674;0396503060;;;-124
54820674;9621884112;;;-3
55010111;0092887156;ESSEDE5F550;DE23550101119288715600;1
55010400;4689964783;AARBDE5WDOM;DE89550104004689964783;1
55020000;2691436774;BHFBDEFF500;DE74500202002691436774;19
55020486;0396304377;HYVEDEMM486;DE42550204860396304377;1
55020486;6944173321;HYVEDEMM418;DE22700211806944173321;19
55020600;2439031838;IMMODE5MXXX;DE82550206002439031838;1
55020700;2603906732;SUFGDE51XXX;DE19550207002603906732;1
55040022;0091363571;COBADEFFXXX;DE04550400220091363571;1
55050000;0010627012;SOLADEST550;DE16550500000010627012;1
55050000;0730114048;SOLADEST550;DE80550500000730114048;1
55060831;0000381942;DAAEDEDDXXX;DE22300606010000381942;19
55060831;2631444239;DAAEDEDDXXX;DE62300606012631444239;19
55060831;4064536231;DAAEDEDDXXX;DE93300606014064536231;19
55060831;4988124491;DAAEDEDDXXX;DE69300606014988124491;19
55060831;6335601806;DAAEDEDDXXX;DE49300606016335601806;19
55060831;7024203886;DAAEDEDDXXX;DE57300606017024203886;19
55060831;7972783163;DAAEDEDDXXX;DE85300606017972783163;19
55060831;9190214884;DAAEDEDDXXX;DE77300606019190214884;19
55080044;0000034848;COBADEFF555;DE17550800440003484800;18
55080044;0085918741;COBADEFF555;DE20550800440085918741;1
55080065;0000081097;DRESDEFF550;DE44550800650008109700;18
55080065;0048232891;DRESDEFF550;DE54550800650048232891;1
55080088;0000060392;DRESDEFF555;DE48550800880006039200;18
55080088;0027572443;DRESDEFF555;DE20550800880027572443;1
55090500;1000501271;GENODEF1S01;DE32550905001000501271;1
55090500;1153739341;GENODEF1S01;DE54550905001153739341;1
55090500;1332119702;GENODEF1S01;DE12550905001332119702;1
55090500;1477522703;GENODEF1S01;DE82550905001477522703;1
55090500;1625301946;GENODEF1S01;DE37550905001625301946;1
55090500;1782976040;GENODEF1S01;DE04550905001782976040;1
55090500;1944619132;GENODEF1S01;DE06550905001944619132;1
55090500;2112343030;GENODEF1S01;DE58550905002112343030;1
55090500;2270435312;GENODEF1S01;DE40550905002270435312;1
55090500;2425758039;GENODEF1S01;DE28550905002425758039;1
55090500;2564226041;GENODEF1S01;DE54550905002564226041;1
55090500;2720250694;GENODEF1S01;DE94550905002720250694;1
55090500;2871849158;GENODEF1S01;DE36550905002871849158;1
55090500;3037301766;GENODEF1S01;DE63550905003037301766;1
55090500;3183836036;GENODEF1S01;DE06550905003183836036;1
55090500;3355712209;GENODEF1S01;DE69550905003355712209;1
55090500;3530197504;GENODEF1S01;DE88550905003530197504;1
55090500;3709175366;GENODEF1S01;DE74550905003709175366;1
55090500;3866695672;GENODEF1S01;DE38550905003866695672;1
55090500;4025708555;GENODEF1S01;DE43550905004025708555;1
55090500;4187600155;GENODEF1S01;DE13550905004187600155;1
55090500;4367214370;GENODEF1S01;DE78550905004367214370;1
55090500;4530807768;GENODEF1S01;DE14550905004530807768;1
55090500;4677453850;GENODEF1S01;DE61550905004677453850;1
55090500;4851265969;GENODEF1S01;DE69550905004851265969;1
55090500;5005881074;GENODEF1S01;DE52550905005005881074;1
55090500;5151045780;GENODEF1S01;DE77550905005151045780;1
55090500;5313257070;GENODEF1S01;DE59550905005313257070;1
55090500;5447901598;GENODEF1S01;DE81550905005447901598;1
55090500;5623398455;GENODEF1S01;DE22550905005623398455;1
55090500;5801008818;GENODEF1S01;DE13550905005801008818;1
55090500;5954869929;GENODEF1S01;DE56550905005954869929;1
55090500;6107822115;GENODEF1S01;DE74550905006107822115;1
55090500;6262367785;GENODEF1S01;DE83550905006262367785;1
55090500;6437498432;GENODEF1S01;DE96550905006437498432;1
55090500;6610594415;GENODEF1S01;DE87550905006610594415;1
55090500;6770294160;GENODEF1S01;DE54550905006770294160;1
55090500;6926679675;GENODEF1S01;DE82550905006926679675;1
55090500;7084181486;GENODEF1S01;DE55550905007084181486;1
55090500;7244713214;GENODEF1S01;DE32550905007244713214;1
55090500;7378464123;GENODEF1S01;DE84550905007378464123;1
55090500;7551004325;GENODEF1S01;DE68550905007551004325;1
55090500;8028787830;GENODEF1S01;DE78550905008028787830;1
55090500;8171324476;GENODEF1S01;DE89550905008171324476;1
55090500;8332353954;GENODEF1S01;DE69550905008332353954;1
55090500;8505973600;GENODEF1S01;DE73550905008505973600;1
55090500;8663537668;GENODEF1S01;DE20550905008663537668;1
55090500;8825131855;GENODEF1S01;DE93550905008825131855;1
55090500;8975787830;GENODEF1S01;DE64550905008975787830;1
55090500;9131966211;GENODEF1S01;DE78550905009131966211;1
55090500;9288463795;GENODEF1S01;DE61550905009288463795;1
55090500;9449100100;GENODEF1S01;DE32550905009449100100;1
55090500;9600005322;GENODEF1S01;DE97550905009600005322;1
55090500;9752691143;GENODEF1S01;DE02550905009752691143;1
55090500;9906634595;GENODEF1S01;DE78550905009906634595;1
55340041;0038521858;COBADEFFXXX;DE36553400410038521858;1
55350010;1466045250;MALADE51WOR;DE42553500101466045250;1
56020086;0396307880;HYVEDEMM515;DE76560200860396307880;1
56020086;6312242700;HYVEDEMM453;DE59710221826312242700;19
56061151;1780359056;GENODED1KSL;DE76560611511780359056;1
56061472;1762090636;GENODED1KHK;DE71560614721762090636;1
56062227;1071317229;GENODED1RBO;DE06560622271071317229;1
56062577;3074518501;GENODED1VRK;DE69560625773074518501;1
56090000;4064020447;GENODE51KRE;DE86560900004064020447;1
56240050;0071885177;COBADEFFXXX;DE82562400500071885177;1
56250030;0101571399;BILADE55XXX;DE66562500300101571399;1
56250030;5158550545;BILADE55XXX;DE68562500305158550545;1
56261735;1627082310;GENODED1FIN;DE69562617351627082310;1
57010111;0097478274;ESSEDE5F570;DE16570101110097478274;1
57020086;0396630878;HYVEDEMM401;DE84570200860396630878;1
57020086;6375806647;HYVEDEMM426;DE23721200786375806647;19
57020500;1210698029;OYAKDE5KXXX;DE14570205001210698029;1
57040044;0012821486;COBADEFFXXX;DE30570400440012821486;1
57060000;1424799844;GENODEDD570;DE15570600001424799844;1
57060612;0000175749;DAAEDEDDXXX;DE15300606010000175749;19
57060612;1764830377;DAAEDEDDXXX;DE81300606011764830377;19
57060612;3718302464;DAAEDEDDXXX;DE46300606013718302464;19
57060612;4360713198;DAAEDEDDXXX;DE51300606014360713198;19
57060612;5331635093;DAAEDEDDXXX;DE56300606015331635093;19
57060612;6578452390;DAAEDEDDXXX;DE26300606016578452390;19
57060612;7442593130;DAAEDEDDXXX;DE83300606017442593130;19
57060612;8513933711;DAAEDEDDXXX;DE87300606018513933711;19
57062675;3379150152;GENODE51NWA;DE71570626753379150152;1
57063478;1608624029;GENODED1VAN;DE44570634781608624029;1
57064221;7581666226;GENODED1MKA;DE12570642217581666226;1
57069067;3726007502;GENODED1LUH;DE93570690673726007502;1
57069081;2112519535;GENODED1MOK;DE31570690812112519535;1
57069144;3469225530;GENODED1KAI;DE98570691443469225530;1
57069238;2697559675;GENODED1ASN;DE42570692382697559675;1
57069257;3995516196;GENODED1UMO;DE60570692573995516196;1
57069315;5464437947;GENODED1SRH;DE95570693155464437947;1
57069361;1661195428;GENODED1WLG;DE17570693611661195428;1
57069526;2272180527;GENODED1IDW;DE45570695262272180527;1
57069727;1967124882;GENODED1IRR;DE02570697271967124882;1
57069806;1305014460;GENODED1MBA;DE76570698061305014460;1
57080070;0000045354;DRESDEFF570;DE96570800700004535400;18
57080070;0027508638;DRESDEFF570;DE34570800700027508638;1
57090000;1030498315;GENODE51KOB;DE72570900001030498315;1
57090900;4549724713;GENODEF1P12;DE55570909004549724713;1
57091500;1921212873;GENODED1BOP;DE61570915001921212873;1
57263015;5552908581;GENODE51ARZ;DE15572630155552908581;1
57361476;1536157578;GENODED1GBS;DE48573614761536157578;1
57363243;1483687282;GENODED1NFB;DE98573632431483687282;1
57460117;1973290330;GENODED1NWD;DE74574601171973290330;1
57661253;3694526106;GENODED1KEH;DE12576612533694526106;1
57662263;5821150780;GENODED1MPO;DE34576622635821150780;1
57762265;2054405988;GENODED1GRO;DE02577622652054405988;1
58510111;0094328399;ESSEDE5F585;DE62585101119432839900;1
58520086;0396164639;HYVEDEMM437;DE82585200860396164639;1
58520086;3146879216;HYVEDEMMXXX;DE36700202703146879216;19
58560103;1907832627;GENODED1TVB;DE29585601031907832627;1
58561250;5049206427;GENODED1HWM;DE26585647885049206427;1
58561626;2178731094;GENODED1SRB;DE88585616262178731094;1
58561771;4122483755;GENODED1MLW;DE10585617714122483755;1
58564788;2666170553;GENODED1HWM;DE16585647882666170553;1
58580074;0000088730;DRESDEFF585;DE42585800740000088730;1
58580074;0007395085;DRESDEFF585;DE30585800740739508500;18
58590900;1258958983;GENODEF1P21;DE87585909001258958983;1
58660101;3251187049;GENODED1BIT;DE23586601013251187049;1
58661901;5053508168;GENODED1WSC;DE21586619015053508168;1
58662653;1841135740;GENODED1OSE;DE73586626531841135740;1
58668818;6961511750;GENODED1NBL;DE47586688186961511750;1
58691500;4506799079;GENODED1PRU;DE97586915004506799079;1
58760954;4494411229;GENODED1WTL;DE15587609544494411229;1
58761343;5686064451;GENODED1BPU;DE89587613435686064451;1
59010066;1127371601;PBNKDEFF590;DE94590100661127371601;1
59010066;6062472679;PBNKDEFF590;DE04590100666062472679;1
59020090;0396669847;HYVEDEMM432;DE73590200900396669847;1
59020090;1865994571;HYVEDEMM455;DE23790200761865994571;19
59020700;3440249549;HSTBDEH1SAA;DE92590207003440249549;1
59050000;0103848610;SALADE55XXX;DE27590500000103848610;1
59051090;1467336941;SALADE51VKS;DE79590510901467336941;1
59052020;1026692524;SALADE51SKG;DE96590520201026692524;1
59052020;8739263054;SALADE51SKG;DE40590520208739263054;1
59080090;0000054252;DRESDEFF590;DE39590800900005425200;18
59080090;0081901382;DRESDEFF590;DE70590800900081901382;1
59090626;0000131091;DAAEDEDDXXX;DE71300606010000131091;19
59090626;1887300510;DAAEDEDDXXX;DE18300606011887300510;19
59090626;3078360515;DAAEDEDDXXX;DE82300606013078360515;19
59090626;4199475394;DAAEDEDDXXX;DE37300606014199475394;19
59090626;5579521110;DAAEDEDDXXX;DE94300606015579521110;19
59090626;6526276547;DAAEDEDDXXX;DE06300606016526276547;19
59090626;7301268708;DAAEDEDDXXX;DE55300606017301268708;19
59090626;9050960659;DAAEDEDDXXX;DE10300606019050960659;19
59090900;1267226311;GENODEF1P19;DE25590909001267226311;1
59252046;1240395922;SALADE51NKS;DE32592520461240395922;1
59320087;0396968639;HYVEDEMM838;DE18593200870396968639;1
59320087;2348222700;HYVEDEMM453;DE89710221822348222700;19
60010070;1174472159;PBNKDEFF600;DE54600100701174472159;1
60010070;6122442851;PBNKDEFF600;DE91600100706122442851;1
60020030;1994820763;SOLADEST601;DE57600200301994820763;1
60020290;0396344895;HYVEDEMM473;DE21600202900396344895;1
60020290;2148647987;HYVEDEMM447;DE14750200732148647987;19
60020700;1027980836;HSTBDEH1STU;DE38600207001027980836;1
60030000;1546955269;MEBEDE6SDCB;DE12600300001546955269;1
60030100;9295952898;BHBADES1XXX;DE82600301009295952898;1
60030200;9576319471;ELGEDES1XXX;DE79600302009576319471;1
60050101;3966358831;SOLADEST600;DE45600501013966358831;1
60060396;6747644778;GENODES1UTV;DE15600603966747644778;1
60060893;6598732980;GENODES1FIL;DE21600608936598732980;1
60062775;5163364472;GENODES1ECH;DE36600627755163364472;1
60062909;9942231749;GENODES1MCH;DE81600629099942231749;1
60069017;5271118983;GENODES1DMS;DE93600690175271118983;1
60069066;7023228861;GENODES1RBA;DE92600690667023228861;1
60069075;3168342696;GENODES1RVG;DE27600690753168342696;1
60069126;1627790829;GENODES1ROM;DE93600691261627790829;1
60069147;5063438083;GENODES1RSF;DE42600691475063438083;1
60069158;1863547207;GENODES1SAA;DE16600691581863547207;1
60069206;3322724069;GENODES1AID;DE77600692063322724069;1
60069224;3796571077;GENODES1GWS;DE35600692243796571077;1
60069235;1494881470;GENODES1PGW;DE18642618531494881470;1
60069239;4070322833;GENODES1BPF;DE37600692394070322833;1
60069242;6532732478;GENODES1RGR;DE48600692426532732478;1
60069245;3609314710;GENODES1ROB;DE21600692453609314710;1
60069251;5762585158;GENODES1RDI;DE24600692515762585158;1
60069302;7833776009;GENODES1ERM;DE63600693027833776009;1
60069303;8010145718;GENODES1RBS;DE58600693038010145718;1
60069308;8300144900;GENODES1RIN;DE59600693088300144900;1
60069315;5022152045;GENODES1MDH;DE98600693155022152045;1
60069325;4923955163;GENODES1HEG;DE33600693254923955163;1
60069336;7805119899;GENODES1RMA;DE88600693367805119899;1
60069343;2759895076;GENODES1RRI;DE53600693432759895076;1
60069346;8114936398;GENODES1REH;DE31600693468114936398;1
60069350;2899500023;GENODES1RRG;DE11600693502899500023;1
60069355;5351087197;GENODES1EHN;DE32600693555351087197;1
60069371;4638240330;GENODES1TET;DE83651915004638240330;1
60069378;5012950372;GENODES1DEH;DE16600693785012950372;1
60069387;2556255994;GENODES1DBE;DE84600693872556255994;1
60069417;7539852518;GENODES1KIB;DE36600694177539852518;1
60069419;8062035883;GENODES1UHL;DE27600694198062035883;1
60069420;4426659361;GENODES1MBI;DE43600694204426659361;1
60069431;7691193270;GENODES1OED;DE09600694317691193270;1
60069442;4177996130;GENODES1RFS;DE88600694424177996130;1
60069455;5543393695;GENODES1RVS;DE55600694555543393695;1
60069457;6630497732;GENODES1OTT;DE22600694576630497732;1
60069461;2347650025;GENODES1RRE;DE55600694612347650025;1
60069462;4035279820;GENODES1WBB;DE56600694624035279820;1
60069463;5243575119;GENODES1GEI;DE95653624995243575119;1
60069476;8710558454;GENODES1DEA;DE89600694768710558454;1
60069485;2605210502;GENODES1ROW;DE67600694852605210502;1
60069505;8907551049;GENODES1VMT;DE02600695058907551049;1
60069511;1425788963;GENODES1GHO;DE39600695111425788963;1
60069517;7586737444;GENODES1SCA;DE13600695177586737444;1
60069520;5909438557;GENODES1OMT;DE97600695205909438557;1
60069527;4090415802;GENODES1RNS;DE02600695274090415802;1
60069538;1582842396;GENODES1LOC;DE11600695381582842396;1
60069544;5477186704;GENODES1RWN;DE73600695445477186704;1
60069545;6713502261;GENODES1NUF;DE53600695456713502261;1
60069549;5105802306;GENODES1KIB;DE53600694175105802306;1
60069553;7616291619;GENODES1HAR;DE27600695537616291619;1
60069564;7770710936;GENODES1RVA;DE74600695647770710936;1
60069593;9501939049;GENODES1ROS;DE57600695939501939049;1
60069595;5496707994;GENODES1SBB;DE02600695955496707994;1
60069639;4086755580;GENODES1RIH;DE11600696394086755580;1
60069648;9953503443;GENODES1EHZ;DE58600696489953503443;1
60069669;9483592747;GENODES1EHB;DE61600696699483592747;1
60069670;7138103514;GENODES1HOC;DE98600696707138103514;1
60069673;2378155700;GENODES1ABR;DE68600696732378155700;1
60069680;6455808070;GENODES1BRZ;DE15600696806455808070;1
60069685;1126368539;GENODES1RWA;DE53600696851126368539;1
60069692;3355304034;GENODES1ENZ;DE10600696923355304034;1
60069705;3803982472;GENODES1SLA;DE29600697053803982472;1
60069706;5152922550;GENODES1MEH;DE60600697065152922550;1
60069714;4223886711;GENODES1IBR;DE17600697144223886711;1
60069724;6831426131;GENODES1RHS;DE13600697246831426131;1
60069727;7148509505;GENODES1ROF;DE60600697277148509505;1
60069738;7901455837;GENODES1FAN;DE93600697387901455837;1
60080000;0000099053;DRESDEFF600;DE51600800000009905300;18
60080000;0030757914;DRESDEFF600;DE65600800000030757914;1
60080055;0000036596;DRESDEFF608;DE18600800550003659600;18
60080055;0028330790;DRESDEFF608;DE71600800550028330790;1
60080057;0000081899;DRESDEFF609;DE55600800570008189900;18
60080057;0087135718;DRESDEFF609;DE42600800570087135718;1
60090609;0000223000;DAAEDEDDXXX;DE79300606010000223000;19
60090609;2053418884;DAAEDEDDXXX;DE15300606012053418884;19
60090609;3022738651;DAAEDEDDXXX;DE35300606013022738651;19
60090609;4154403258;DAAEDEDDXXX;DE65300606014154403258;19
60090609;5654620283;DAAEDEDDXXX;DE44300606015654620283;19
60090609;6811990803;DAAEDEDDXXX;DE61300606016811990803;19
60090609;8291057823;DAAEDEDDXXX;DE20300606018291057823;19
60090609;9214385993;DAAEDEDDXXX;DE14300606019214385993;19
60090800;0000104710;GENODEF1S02;DE69600908000000104710;1
60090800;0000846538;GENODEF1S02;DE49600908000000846538;1
60090800;0096590904;GENODEF1S02;DE85600908000096590904;1
60090900;1627642577;GENODEF1P20;DE56600909001627642577;1
60120050;0396500002;;;-124
60120050;4830945216;;;-3
60120200;2924255150;BHFBDEFF500;DE77500202002924255150;19
60220030;6865129791;;;-124
60250010;5578818891;SOLADES1WBN;DE69602500105578818891;1
60250184;6598422170;SOLADEST600;DE31600501016598422170;19
60320030;8780502590;;;-124
60320291;0396785506;HYVEDEMM858;DE68603202910396785506;1
60350130;6443481486;BBKRDE6BXXX;DE45603501306443481486;1
60380002;0000020801;DRESDEFF601;DE12603800020002080100;18
60380002;0013258576;DRESDEFF601;DE55603800020013258576;1
60420186;0396923750;HYVEDEMM860;DE97604201860396923750;1
60420186;2082929307;HYVEDEMM436;DE30731200752082929307;19
60430060;1388151141;;;-124
60431061;7199733698;;;-124
60450050;6180881239;SOLADES1LBG;DE18604500506180881239;1
60450193;8022713487;SOLADEST600;DE06600501018022713487;19
60480008;0000012117;DRESDEFF604;DE34604800080001211700;18
60480008;0076767002;DRESDEFF604;DE09604800080076767002;1
60651070;1034424779;PZHSDE66XXX;DE65666500851034424779;19
60651070;1298586380;PZHSDE66XXX;;0
60651070;1356140334;PZHSDE66XXX;DE10666500851356140334;19
60651070;1514157424;PZHSDE66XXX;;0
60651070;1596026520;PZHSDE66XXX;DE56666500851596026520;19
60651070;1714086986;PZHSDE66XXX;;0
60651070;1760295716;PZHSDE66XXX;DE19666500851760295716;19
60651070;2092301502;PZHSDE66XXX;;0
60651070;2138082167;PZHSDE66XXX;DE80666500852138082167;19
60651070;2180017667;PZHSDE66XXX;;0
60651070;2203500150;PZHSDE66XXX;DE52666500852203500150;19
60651070;2312333944;PZHSDE66XXX;;0
60651070;2314015048;PZHSDE66XXX;DE69666500852314015048;19
60651070;2327207113;PZHSDE66XXX;;0
60651070;2574218007;PZHSDE66XXX;DE92666500852574218007;19
60651070;2759546521;PZHSDE66XXX;;0
60651070;2776954163;PZHSDE66XXX;DE41666500852776954163;19
60651070;2875793997;PZHSDE66XXX;;0
60651070;2882887513;PZHSDE66XXX;DE82666500852882887513;19
60651070;3019294141;PZHSDE66XXX;;0
60651070;3033230396;PZHSDE66XXX;DE84666500853033230396;19
60651070;3062211047;PZHSDE66XXX;;0
60651070;3065017481;PZHSDE66XXX;DE36666500853065017481;19
60651070;3111273888;PZHSDE66XXX;;0
60651070;3133772943;PZHSDE66XXX;DE08666500853133772943;19
60651070;3153318828;PZHSDE66XXX;;0
60651070;3164854131;PZHSDE66XXX;DE37666500853164854131;19
60651070;3221897037;PZHSDE66XXX;;0
60651070;3283811025;PZHSDE66XXX;DE60666500853283811025;19
60651070;3368733896;PZHSDE66XXX;;0
60651070;3397603872;PZHSDE66XXX;DE97666500853397603872;19
60651070;3577873310;PZHSDE66XXX;;0
60651070;3649761484;PZHSDE66XXX;DE70666500853649761484;19
60651070;3684423684;PZHSDE66XXX;;0
60651070;3968754547;PZHSDE66XXX;DE20666500853968754547;19
60651070;4165349554;PZHSDE66XXX;;0
60651070;4206683096;PZHSDE66XXX;DE92666500854206683096;19
60651070;4307967897;PZHSDE66XXX;;0
60651070;4376022043;PZHSDE66XXX;DE74666500854376022043;19
60651070;4446797636;PZHSDE66XXX;;0
60651070;4572242663;PZHSDE66XXX;DE04666500854572242663;19
60651070;4704895074;PZHSDE66XXX;;0
60651070;4789740742;PZHSDE66XXX;DE62666500854789740742;19
60651070;4841711884;PZHSDE66XXX;;0
60651070;4892793935;PZHSDE66XXX;DE24666500854892793935;19
60651070;5158612565;PZHSDE66XXX;;0
60651070;5217465704;PZHSDE66XXX;DE96666500855217465704;19
60651070;5219524437;PZHSDE66XXX;;0
60651070;5290057282;PZHSDE66XXX;DE81666500855290057282;19
60651070;5769255689;PZHSDE66XXX;;0
60651070;5836010436;PZHSDE66XXX;DE97666500855836010436;19
60651070;5850089393;PZHSDE66XXX;;0
60651070;6071493170;PZHSDE66XXX;DE59666500856071493170;19
60651070;6204437019;PZHSDE66XXX;;0
60651070;6229707238;PZHSDE66XXX;DE22666500856229707238;19
60651070;6264711696;PZHSDE66XXX;;0
60651070;6402805550;PZHSDE66XXX;DE83666500856402805550;19
60651070;6479672881;PZHSDE66XXX;;0
60651070;6502545696;PZHSDE66XXX;DE78666500856502545696;19
60651070;6535242416;PZHSDE66XXX;;0
60651070;6559997275;PZHSDE66XXX;DE17666500856559997275;19
60651070;6587382434;PZHSDE66XXX;;0
60651070;6676692035;PZHSDE66XXX;DE56666500856676692035;19
60651070;6751068797;PZHSDE66XXX;;0
60651070;6768185024;PZHSDE66XXX;DE90666500856768185024;19
60651070;6826916059;PZHSDE66XXX;;0
60651070;6910111637;PZHSDE66XXX;DE04666500856910111637;19
60651070;7015530616;PZHSDE66XXX;;0
60651070;7046989451;PZHSDE66XXX;DE93666500857046989451;19
60651070;7210950338;PZHSDE66XXX;;0
60651070;7243625070;PZHSDE66XXX;DE05666500857243625070;19
60651070;7342317980;PZHSDE66XXX;;0
60651070;7396948979;PZHSDE66XXX;DE92666500857396948979;19
60651070;7652726821;PZHSDE66XXX;;0
60651070;7750162104;PZHSDE66XXX;DE52666500857750162104;19
60651070;7820301511;PZHSDE66XXX;;0
60651070;7949505949;PZHSDE66XXX;DE51666500857949505949;19
60651070;7990705054;PZHSDE66XXX;;0
60651070;7998024492;PZHSDE66XXX;DE07666500857998024492;19
60651070;8017637994;PZHSDE66XXX;;0
60651070;8163335990;PZHSDE66XXX;DE38666500858163335990;19
60651070;8225290886;PZHSDE66XXX;;0
60651070;8488975774;PZHSDE66XXX;DE64666500858488975774;19
60651070;8490896572;PZHSDE66XXX;;0
60651070;8503965659;PZHSDE66XXX;DE43666500858503965659;19
60651070;8531141966;PZHSDE66XXX;;0
60651070;8777658310;PZHSDE66XXX;DE93666500858777658310;19
60651070;8876440047;PZHSDE66XXX;;0
60651070;8973349326;PZHSDE66XXX;DE76666500858973349326;19
60651070;8977647914;PZHSDE66XXX;;0
60651070;9009610399;PZHSDE66XXX;DE41666500859009610399;19
60651070;9028463039;PZHSDE66XXX;;0
60651070;9146911894;PZHSDE66XXX;DE50666500859146911894;19
60651070;9159840655;PZHSDE66XXX;;0
60651070;9219605843;PZHSDE66XXX;DE33666500859219605843;19
60651070;9350876679;PZHSDE66XXX;;0
60651070;9362851006;PZHSDE66XXX;DE37666500859362851006;19
60651070;9627696410;PZHSDE66XXX;;0
60651070;9685058470;PZHSDE66XXX;DE67666500859685058470;19
60651070;9727529700;PZHSDE66XXX;;0
60651070;9886644814;PZHSDE66XXX;DE90666500859886644814;19
60651070;9904216575;PZHSDE66XXX;;0
61020030;2298115395;;;-124
61050000;1910655142;GOPSDE6GXXX;DE23610500001910655142;1
61050181;2444138749;SOLADEST600;DE91600501012444138749;19
61080006;0000083070;DRESDEFF610;DE06610800060008307000;18
61080006;0079497155;DRESDEFF610;DE70610800060079497155;1
61120030;3573306992;;;-124
61120286;0396364446;HYVEDEMM859;DE93611202860396364446;1
61150020;2665288423;ESSLDE66XXX;DE17611500202665288423;1
61150185;1110688672;SOLADEST600;DE21600501011110688672;19
61180004;0000023863;DRESDEFF611;DE69611800040002386300;18
61180004;0083797032;DRESDEFF611;DE48611800040083797032;1
61220030;1396007894;;;-124
61281007;0000097275;DRESDEFF612;DE28612810070009727500;18
61281007;0060992440;DRESDEFF612;DE79612810070060992440;1
61420086;0396436377;HYVEDEMM272;DE18614200860396436377;1
61420086;6598197812;HYVEDEMM483;DE21545201946598197812;19
61430000;3378027107;;;-124
61450050;7096352985;OASPDE6AXXX;DE52614500507096352985;1
61450191;1898852696;SOLADEST600;DE84600501011898852696;19
61480001;0000069528;DRESDEFF614;DE41614800010006952800;18
61480001;0036004122;DRESDEFF614;DE94614800010036004122;1
62020000;2189823668;HOEBDE61XXX;DE12620200002189823668;1
62030050;2348109193;;;-124
62030060;6961313179;;;-124
62050000;2745582740;HEISDE66XXX;DE68620500002745582740;1
62050181;1071381465;SOLADEST600;DE53600501011071381465;19
62080012;0000074810;DRESDEFF620;DE48620800120007481000;18
62080012;0069825802;DRESDEFF620;DE70620800120069825802;1
62230050;1545172735;;;-124
62250030;2549643270;SOLADES1SHA;DE92622500302549643270;1
62250182;4516092663;SOLADEST600;DE93600501014516092663;19
62251550;4068181345;SOLADES1KUN;DE46622515504068181345;1
62280012;0000834105;DRESDEFF622;DE95622800120083410500;18
62280012;0067055809;DRESDEFF622;DE63622800120067055809;1
62351060;3524846534;SOLADES1MGH;DE83623510603524846534;1
63020086;0396325530;HYVEDEMM461;DE09630200860396325530;1
63020130;3171776698;;;-124
63020450;0451534160;;;-124
63020450;6962080845;HYVEDEMM433;DE63743200736962080845;19
63050000;2522582334;SOLADES1ULM;DE39630500002522582334;1
63050181;6301203342;SOLADEST600;DE29600501016301203342;19
63080015;0000869272;DRESDEFF630;DE21630800150000869272;1
63080015;0004605779;DRESDEFF630;DE63630800150460577900;18
63220090;0396996959;HYVEDEMM271;DE85632200900396996959;1
63250030;3940284990;SOLADES1HDH;DE10632500303940284990;1
63291210;1286771607;GENODES1GVB;DE79632912101286771607;1
64020030;2737784396;;;-124
64020186;0396539729;HYVEDEMM374;DE50640201860396539729;1
64020186;2145056333;HYVEDEMM447;DE86750200732145056333;19
64050000;4092693081;SOLADES1REU;DE37640500004092693081;1
64050181;1532015940;SOLADEST600;DE96600501011532015940;19
64080014;0000363054;DRESDEFF640;DE10640800140036305400;18
64080014;0090864271;DRESDEFF640;DE23640800140090864271;1
64120030;1405343342;;;-124
64150020;2738873112;SOLADES1TUB;DE28641500202738873112;1
64150182;3924530677;SOLADEST600;DE67600501013924530677;19
64180014;0000313609;DRESDEFF641;DE68641800140031360900;18
64180014;0021098590;DRESDEFF641;DE95641800140021098590;1
64250040;4393280076;SOLADES1RWL;DE74642500404393280076;1
64251060;6114522203;SOLADES1FDS;DE50642510606114522203;1
64350070;5950944675;SOLADES1TUT;DE98643500705950944675;1
64380011;0000722145;DRESDEFF643;DE92643800110072214500;18
64380011;0012075313;DRESDEFF643;DE63643800110012075313;1
64420030;1973089898;;;-124
64450288;1515019736;SOLADEST600;DE13600501011515019736;19
65020030;2428199052;;;-124
65020186;0396720131;HYVEDEMM588;DE26650201860396720131;1
65020186;4800357166;HYVEDEMMXXX;DE66700202704800357166;19
65050110;3449401054;SOLADES1RVB;DE12650501103449401054;1
65050281;3620202089;SOLADEST600;DE03600501013620202089;19
65080009;0000144058;DRESDEFF650;DE96650800090014405800;18
65080009;0067238537;DRESDEFF650;DE40650800090067238537;1
65110200;1141132763;IBBFDE81XXX;DE69651102001141132763;1
65120091;0396832641;HYVEDEMM473;DE84600202900396832641;1
65180005;0000262821;DRESDEFF651;DE50651800050000262821;1
65180005;0001213428;DRESDEFF651;DE92651800050121342800;18
65350186;2290692642;SOLADEST600;DE89600501012290692642;19
65351050;1086630345;SOLADES1SIG;DE48653510501086630345;1
65351260;4735863264;SOLADES1BAL;DE21653512604735863264;1
65380003;0000795938;DRESDEFF653;DE82653800030079593800;18
65380003;0040621165;DRESDEFF653;DE86653800030040621165;1
65450070;9565591309;SBCRDE66XXX;DE42654500709565591309;1
66010075;1056450911;PBNKDEFF660;DE03660100751056450911;1
66010075;6048518403;PBNKDEFF660;DE39660100756048518403;1
66020020;3317851809;SOLADEST663;DE78660200203317851809;1
66020150;0396977153;;;-124
66020150;5901195015;;;-3
66020286;0396229484;HYVEDEMM475;DE91660202860396229484;1
66020286;1763835126;HYVEDEMM445;DE95740200741763835126;19
66080052;0000272346;DRESDEFF660;DE15660800520027234600;18
66080052;0030000732;DRESDEFF660;DE86660800520030000732;1
66090621;0000163317;DAAEDEDDXXX;DE59300606010000163317;19
66090621;1357172916;DAAEDEDDXXX;DE23300606011357172916;19
66090621;2715402444;DAAEDEDDXXX;DE97300606012715402444;19
66090621;4399259560;DAAEDEDDXXX;DE77300606014399259560;19
66090621;5741612723;DAAEDEDDXXX;DE91300606015741612723;19
66090621;7067224796;DAAEDEDDXXX;DE11300606017067224796;19
66090621;8165442380;DAAEDEDDXXX;DE50300606018165442380;19
66090621;9198972105;DAAEDEDDXXX;DE79300606019198972105;19
66090800;0100842516;GENODE61BBB;DE91660908000100842516;1
66090800;1664667603;GENODE61BBB;DE85660908001664667603;1
66090800;3345491770;GENODE61BBB;DE57660908003345491770;1
66090800;5053419096;GENODE61BBB;DE02660908005053419096;1
66090800;6810590126;GENODE61BBB;DE06660908006810590126;1
66090800;8464084098;GENODE61BBB;DE62660908008464084098;1
66090900;1183036759;GENODEF1P10;DE63660909001183036759;1
66220020;9711060582;;;-124
66280053;0000156371;DRESDEFF662;DE55662800530015637100;18
66280053;0081332151;DRESDEFF662;DE25662800530081332151;1
66350036;3013997602;BRUSDE66XXX;DE86663500363013997602;1
66420020;1198120636;;;-124
66450050;1841689235;SOLADES1OFG;DE63664500501841689235;1
66451346;1142422706;SOLADES1GEB;DE07664513461142422706;1
66451548;1517618930;SOLADES1HAL;DE59664515481517618930;1
66451862;4906394913;SOLADES1KEL;DE24664518624906394913;1
66452776;1648227767;SOLADES1WOF;DE58664527761648227767;1
66620020;2638586296;;;-124
66661454;1057030987;GENODE61NFO;DE23666614541057030987;1
66680013;0000496224;DRESDEFF666;DE25666800130049622400;18
66680013;0070896369;DRESDEFF666;DE02666800130070896369;1
66690000;1001959727;VBPFDE66XXX;DE92666900001001959727;1
67020020;2524666114;;;-124
67020190;0396482345;HYVEDEMM489;DE05670201900396482345;1
67020259;0396590579;;;-124
67020259;1838037620;HYVEDEMMXXX;DE27700202701838037620;19
67080050;0000355823;DRESDEFF670;DE56670800500035582300;18
67080050;0069922654;DRESDEFF670;DE33670800500069922654;1
67090617;0000344222;DAAEDEDDXXX;DE59300606010000344222;19
67090617;1911089888;DAAEDEDDXXX;DE54300606011911089888;19
67090617;2945914296;DAAEDEDDXXX;DE17300606012945914296;19
67090617;4450117316;DAAEDEDDXXX;DE19300606014450117316;19
67090617;5356111320;DAAEDEDDXXX;DE17300606015356111320;19
67090617;6288506850;DAAEDEDDXXX;DE76300606016288506850;19
67090617;7926191410;DAAEDEDDXXX;DE33300606017926191410;19
67090617;9012432838;DAAEDEDDXXX;DE91300606019012432838;19
67220020;2782004261;;;-124
67220286;0396259854;HYVEDEMM479;DE12672202860396259854;1
67220286;2776273204;HYVEDEMM433;DE15743200732776273204;19
67220464;0396600572;;;-124
67220464;9315305869;;;-3
67230000;1065414206;MLPBDE61XXX;DE36672300001065414206;1
67230001;1342740052;MLPBDE61001;DE53672300011342740052;1
67280051;0000284622;DRESDEFF672;DE38672800510028462200;18
67280051;0068221464;DRESDEFF672;DE74672800510068221464;1
67320020;5428875990;;;-124
68020020;9132322066;;;-124
68020186;0396398987;HYVEDEMM357;DE09680201860396398987;1
68020186;2305681205;HYVEDEMM426;DE02721200782305681205;19
68020460;0396248568;;;-124
68020460;6356146067;HYVEDEMM654;DE59703200906356146067;19
68050101;5384456014;FRSPDE66XXX;DE52680501015384456014;1
68080030;0000815780;DRESDEFF680;DE29680800300081578000;18
68080030;0045236125;DRESDEFF680;DE91680800300045236125;1
68080031;0000575963;DRESDEFFI44;DE21680800310057596300;18
68080031;0070186523;DRESDEFFI44;DE15680800310070186523;1
68090622;0000200360;DAAEDEDDXXX;DE65300606010000200360;19
68090622;2029555474;DAAEDEDDXXX;DE61300606012029555474;19
68090622;2916021182;DAAEDEDDXXX;DE84300606012916021182;19
68090622;4206536735;DAAEDEDDXXX;DE46300606014206536735;19
68090622;5351518483;DAAEDEDDXXX;DE70300606015351518483;19
68090622;6422829908;DAAEDEDDXXX;DE34300606016422829908;19
68090622;7915011976;DAAEDEDDXXX;DE54300606017915011976;19
68090622;8864142233;DAAEDEDDXXX;DE27300606018864142233;19
68090900;1805924140;GENODEF1P07;DE54680909001805924140;1
68250040;1430489567;SOLADES1LAR;DE12682500401430489567;1
68320020;1555130284;;;-124
69020190;0396863683;HYVEDEMM591;DE88690201900396863683;1
69020190;4772277402;HYVEDEMM480;DE80783200764772277402;19
69220020;9457206992;;;-124
69220186;0396815834;HYVEDEMM590;DE20692201860396815834;1
69220186;1140438584;HYVEDEMM460;DE80760200701140438584;19
69280035;0000290749;DRESDEFF692;DE72692800350029074900;18
69280035;0053368347;DRESDEFF692;DE24692800350053368347;1
69421020;4908190495;;;-124
69450065;1633429477;SOLADES1VSS;DE27694500651633429477;1
69451070;1084179366;SOLADES1DOE;DE41694510701084179366;1
70010080;1027449306;PBNKDEFF700;DE49700100801027449306;1
70010080;6331400645;PBNKDEFF700;DE29700100806331400645;1
70010555;5826688742;REBMDEMM555;DE05700105555826688742;1
70011300;2216774453;AUZDDEM1XXX;DE96700113002216774453;1
70011700;4663421314;BVDHDEMMXXX;DE39700117004663421314;1
70012100;1160297685;VEAKDEMMXXX;DE58700121001160297685;1
70012300;1226502534;VBANDEMMXXX;DE89700123001226502534;1
70013000;1327083011;COBADEMXXXX;DE85700130001327083011;1
70013010;1124299710;EFSGDEM1XXX;DE82700130101124299710;1
70020001;0398843556;;;-124
70020001;1124318609;HYVEDEMM451;DE61793200751124318609;19
70020001;1877428024;;;-3
70020001;4529148394;HYVEDEMMXXX;DE16700202704529148394;19
70020270;0001017118;HYVEDEMMXXX;DE90700202700001017118;1
70020270;0023698138;HYVEDEMMXXX;DE31700202700023698138;1
70020270;0440367439;HYVEDEMMXXX;DE59700202700440367439;1
70020270;1079649356;HYVEDEMM451;DE22793200751079649356;19
70020270;6645305610;HYVEDEMM426;DE94721200786645305610;19
70021180;0396839935;HYVEDEMM418;DE13700211800396839935;1
70021180;1353012386;HYVEDEMM411;DE20770200701353012386;19
70022200;1766148685;FDDODEMMXXX;DE76700222001766148685;1
70025175;0396945193;HYVEDEMM643;DE98700251750396945193;1
70030800;1408207183;DELBDE33XXX;DE37501203831408207183;19
70030800;2990267093;DELBDE33XXX;DE91501203832990267093;19
70030800;5227816186;DELBDE33XXX;DE51501203835227816186;19
70030800;7069712421;DELBDE33XXX;DE08501203837069712421;19
70030800;8947876941;DELBDE33XXX;DE79501203838947876941;19
70035000;2150284988;OLBODEH2700;DE38700350002150284988;1
70080000;0000412028;DRESDEFF700;DE67700800000041202800;18
70080000;0062086541;DRESDEFF700;DE60700800000062086541;1
70080056;0000799749;DRESDEFF714;DE94700800560000799749;1
70080056;0007564181;DRESDEFF714;DE46700800560756418100;18
70080057;0000325314;DRESDEFF724;DE89700800570032531400;18
70080057;0097432878;DRESDEFF724;DE06700800570097432878;1
70090100;3498167448;GENODEF1M04;DE30700901003498167448;1
70090500;1398668826;GENODEF1S04;DE28700905001398668826;1
70090606;0000382817;DAAEDEDDXXX;DE65300606010000382817;19
70090606;2015972040;DAAEDEDDXXX;DE47300606012015972040;19
70090606;2870919261;DAAEDEDDXXX;DE80300606012870919261;19
70090606;3523334793;DAAEDEDDXXX;DE19300606013523334793;19
70090606;4740563075;DAAEDEDDXXX;DE45300606014740563075;19
70090606;6705769476;DAAEDEDDXXX;DE73300606016705769476;19
70090606;7122070758;DAAEDEDDXXX;DE31300606017122070758;19
70090606;8531952333;DAAEDEDDXXX;DE17300606018531952333;19
70091500;5302562294;GENODEF1DCA;DE95700915005302562294;1
70091600;1072261332;GENODEF1DSS;DE39700916001072261332;1
70091900;5439544429;GENODEF1EDV;DE41700919005439544429;1
70093200;2651539795;GENODEF1STH;DE47700932002651539795;1
70093400;3921986902;GENODEF1ISV;DE53700934003921986902;1
70120500;0000112847;FMBKDEMMXXX;DE67701205000000112847;1
70120500;0000893800;FMBKDEMMXXX;DE02701205000000893800;1
70120500;0002873315;FMBKDEMMXXX;DE97701205000002873315;1
70120500;0009160205;FMBKDEMMXXX;DE90701205000009160205;1
70120500;0016426088;FMBKDEMMXXX;DE63701205000016426088;1
70120500;0021197705;FMBKDEMMXXX;DE58701205000021197705;1
70120500;0022793167;FMBKDEMMXXX;DE90701205000022793167;1
70120500;0024440182;FMBKDEMMXXX;DE44701205000024440182;1
70120500;0031860296;FMBKDEMMXXX;DE87701205000031860296;1
70120500;0167676709;FMBKDEMMXXX;DE32701205000167676709;1
70120500;0397173277;FMBKDEMMXXX;DE32701205000397173277;1
70120500;0398771965;FMBKDEMMXXX;DE68701205000398771965;1
70120500;0415013985;FMBKDEMMXXX;DE06701205000415013985;1
70120500;0467247549;FMBKDEMMXXX;DE58701205000467247549;1
70120500;0724273857;FMBKDEMMXXX;DE27701205000724273857;1
70120500;1812715662;FMBKDEMMXXX;DE78701205001812715662;1
70120500;7709590654;FMBKDEMMXXX;DE15701205007709590654;1
70120600;1228419835;RVSADEMXXXX;DE50701206001228419835;1
70120900;0001045798;HYVEDEMMXXX;DE81700202700001045798;1
70120900;0023738547;HYVEDEMMXXX;DE44700202700023738547;1
70120900;0456542753;HYVEDEMMXXX;DE60700202700456542753;1
70130800;1744821890;GENODEF1M06;DE71701308001744821890;1
70160300;8606590624;GENODEF1M02;DE93701603008606590624;1
70163370;8908079951;GENODEF1FFB;DE11701633708908079951;1
70166486;7222329859;GENODEF1OHC;DE48701664867222329859;1
70169132;8616265006;GENODEF1HFG;DE53701691328616265006;1
70169165;4854101910;GENODEF1SBC;DE47701691654854101910;1
70169168;6644126076;GENODEF1RIW;DE26701691686644126076;1
70169186;4347666586;GENODEF1ODZ;DE53701691864347666586;1
70169190;8324412869;GENODEF1GKT;DE24701691908324412869;1
70169191;2579286241;GENODEF1TEI;DE89701691912579286241;1
70169195;8428670579;GENODEF1TRU;DE71701691958428670579;1
70169310;7015348692;GENODEF1ALX;DE96701693107015348692;1
70169322;6280591084;GENODEF1SSB;DE48701693316280591084;1
70169331;5092983790;GENODEF1SSB;DE92701693315092983790;1
70169333;6834487192;GENODEF1EUR;DE04701693336834487192;1
70169351;3657344686;GENODEF1ELB;DE76701693513657344686;1
70169356;1132657686;GENODEF1EDR;DE41701693561132657686;1
70169382;7954670515;GENODEF1GIL;DE34701693827954670515;1
70169383;6495274049;GENODEF1GMU;DE28701693836495274049;1
70169388;4198742680;GENODEF1HMA;DE42701693884198742680;1
70169402;9511427121;GENODEF1HHK;DE81701694029511427121;1
70169410;9537246692;GENODEF1HZO;DE80701694109537246692;1
70169413;5040665800;GENODEF1HUA;DE02701694135040665800;1
70169433;9198174240;GENODEF1KOG;DE89701694339198174240;1
70169444;5630104027;GENODEF1LGR;DE86701694445630104027;1
70169450;2225108012;GENODEF1ASG;DE95701694502225108012;1
70169459;9580863882;GENODEF1MTW;DE18701694599580863882;1
70169460;3251058037;GENODEF1MOO;DE28701694603251058037;1
70169464;9866481230;GENODEF1M07;DE92701694649866481230;1
70169465;6381285866;GENODEF1M08;DE36701694656381285866;1
70169466;9791718970;GENODEF1M03;DE27701694669791718970;1
70169470;7000163058;GENODEF1GAA;DE75701694707000163058;1
70169472;5857759835;GENODEF1NFA;DE47701694725857759835;1
70169474;2478180300;GENODEF1NSV;DE80701694742478180300;1
70169476;9671497960;GENODEF1NBK;DE96701694769671497960;1
70169493;6224275489;GENODEF1OBS;DE82701694936224275489;1
70169495;7286332773;GENODEF1SGO;DE11701694957286332773;1
70169505;4361136607;GENODEF1FOA;DE35701695054361136607;1
70169509;5437212500;GENODEF1PEI;DE30701695095437212500;1
70169521;7986981844;GENODEF1RIG;DE41701695217986981844;1
70169524;4986565727;GENODEF1RME;DE27701695244986565727;1
70169530;8361158503;GENODEF1RWZ;DE74701695308361158503;1
70169538;4403152308;GENODEF1SWO;DE23701695384403152308;1
70169541;4653482316;GENODEF1THG;DE54701695414653482316;1
70169543;1270405310;GENODEF1HHS;DE73701695431270405310;1
70169558;5913632857;GENODEF1SGA;DE04701695585913632857;1
70169566;1985117356;GENODEF1TAV;DE62701695661985117356;1
70169568;7193141785;GENODEF1TAE;DE97701695687193141785;1
70169570;8792958117;GENODEF1FTH;DE06701695708792958117;1
70169571;3691141680;GENODEF1DTZ;DE45701695713691141680;1
70169575;5747903740;GENODEF1TRH;DE31701695755747903740;1
70169576;7353192210;GENODEF1TUS;DE57701695767353192210;1
70169585;7462734478;GENODEF1UNS;DE07701695857462734478;1
70169596;4811803085;GENODEF1WWO;DE72701695964811803085;1
70169598;6525630185;GENODEF1MIB;DE74701695986525630185;1
70169599;4084251792;GENODEF1WEI;DE25701695994084251792;1
70169602;7593555725;GENODEF1WM1;DE65701696027593555725;1
70169605;9712107180;GENODEF1ISE;DE21701696059712107180;1
70169614;4402199335;GENODEF1FSR;DE18701696144402199335;1
70169619;4700093190;GENODEF1ZOR;DE87701696194700093190;1
70169653;7553495302;GENODEF1AIG;DE45701696537553495302;1
70169693;2108878480;GENODEF1RHT;DE78701696932108878480;1
70190000;2060059390;GENODEF1M01;DE91701900002060059390;1
70190200;9059107819;GENODEF1M09;DE13701902009059107819;1
70220200;3319411438;BHFBDEFF500;DE33500202003319411438;19
70220400;1120658111;HSTBDEH1MUE;DE24702204001120658111;1
70220800;1026733049;VVAGDEM1XXX;DE97702208001026733049;1
70220900;1023128005;DRESDEFFBFC;DE91702209001023128005;1
70320090;0396761486;HYVEDEMM654;DE56703200900396761486;1
70320305;0396331415;;;-124
70320305;3745246060;HYVEDEMM436;DE24731200753745246060;19
70321194;0396959917;HYVEDEMM466;DE54703211940396959917;1
70322192;0396445903;HYVEDEMM664;DE70703221920396445903;1
70362595;6219154825;GENODEF1WAK;DE28703625956219154825;1
70380006;0000934240;DRESDEFF703;DE33703800060093424000;18
70380006;0045097267;DRESDEFF703;DE37703800060045097267;1
70390000;3750224227;GENODEF1GAP;DE28703900003750224227;1
70391800;7633263240;GENODEF1PZB;DE91703918007633263240;1
71020072;0396551789;HYVEDEMM410;DE65710200720396551789;1
71021270;0397318069;HYVEDEMM629;DE49710212700397318069;1
71021270;6297882420;HYVEDEMM436;DE63731200756297882420;19
71022182;0397302587;HYVEDEMM453;DE97710221820397302587;1
71023173;0397131988;HYVEDEMM632;DE87710231730397131988;1
71061009;5938509409;GENODEF1AOE;DE53710610095938509409;1
71062802;9526693628;GENODEF1AGE;DE55710628029526693628;1
71090000;4953252221;GENODEF1BGL;DE35710900004953252221;1
71120077;0397240366;HYVEDEMM448;DE18711200770397240366;1
71120078;0397931875;HYVEDEMM644;DE64711200780397931875;1
71120078;3164225010;HYVEDEMMXXX;DE65700202703164225010;19
71121176;0397918088;HYVEDEMM438;DE45711211760397918088;1
71121176;2463190839;HYVEDEMM433;DE81743200732463190839;19
71122183;0397666066;HYVEDEMM457;DE26711221830397666066;1
71122183;4885874687;HYVEDEMM479;DE12672202864885874687;19
71160000;2951808176;GENODEF1VRR;DE67711600002951808176;1
71160161;4659271546;GENODEF1ROR;DE59711601614659271546;1
71161964;3638576530;GENODEF1PRV;DE98711619643638576530;1
71162355;3626103669;GENODEF1OBD;DE37711623553626103669;1
71162804;3423760359;GENODEF1ASU;DE03711628043423760359;1
71165150;6437448767;GENODEF1AIB;DE69711651506437448767;1
71180005;0000692669;DRESDEFF711;DE98711800050069266900;18
71180005;0010173444;DRESDEFF711;DE92711800050010173444;1
71190000;5073392457;GENODEF1ROV;DE21711900005073392457;1
71191000;3880398330;GENODEF1MUL;DE23711910003880398330;1
72012300;0010735190;BTVADE61XXX;DE92720123001073519000;1
72020070;0397963800;HYVEDEMM408;DE68720200700397963800;1
72020070;4501916647;HYVEDEMM414;DE36302201904501916647;19
72020240;0399584220;;;-124
72020240;4312884408;;;-3
72020700;1161105425;AUGBDE77XXX;DE32720207001161105425;1
72020700;1475703664;;;-124
72021271;0397613078;HYVEDEMM236;DE68720212710397613078;1
72021876;0397892478;HYVEDEMM259;DE84720218760397892478;1
72060300;1231951572;GENODEF1A03;DE44720603001231951572;1
72062152;3534948327;GENODEF1MTG;DE81720621523534948327;1
72069002;2782010305;GENODEF1ADZ;DE02720690022782010305;1
72069005;9416216471;GENODEF1AIL;DE10720690059416216471;1
72069034;9003323684;GENODEF1BSI;DE64720690349003323684;1
72069036;3991478545;GENODEF1BOI;DE24720690363991478545;1
72069043;2878464936;GENODEF1GZ2;DE54720690432878464936;1
72069081;3057136218;GENODEF1GHF;DE80720690813057136218;1
72069090;9364106326;GENODEF1KEZ;DE48720690909364106326;1
72069105;6060583499;GENODEF1HTF;DE63720691056060583499;1
72069108;9220238325;GENODEF1DON;DE59722901009220238325;1
72069113;4083032663;GENODEF1HZH;DE09720691134083032663;1
72069114;6827756607;GENODEF1HZR;DE81720691146827756607;1
72069119;4639654810;GENODEF1ICH;DE70720691194639654810;1
72069123;7470281069;GENODEF1JET;DE86720691237470281069;1
72069126;6694399719;GENODEF1BBT;DE66720691266694399719;1
72069132;5895675329;GENODEF1KRR;DE50720691325895675329;1
72069135;8293758073;GENODEF1LST;DE66720691358293758073;1
72069139;2797552208;GENODEF1LWA;DE72720691392797552208;1
72069141;8696941170;GENODEF1ECK;DE94720691418696941170;1
72069155;1498140213;GENODEF1MRI;DE12720691551498140213;1
72069179;6696165103;GENODEF1BWI;DE25720691796696165103;1
72069181;1290061489;GENODEF1OFF;DE57720691811290061489;1
72069193;8097044776;GENODEF1RLI;DE22720691938097044776;1
72069209;7693228031;GENODEF1RGB;DE12720692097693228031;1
72069220;6497273694;GENODEF1SMU;DE26720692206497273694;1
72069235;9690019512;GENODEF1THS;DE48720692359690019512;1
72069263;7993758294;GENODEF1WTS;DE96720692637993758294;1
72069274;4799909561;GENODEF1ZUS;DE10720692744799909561;1
72069308;9895027823;GENODEF1WDN;DE77720693089895027823;1
72069329;2398718649;GENODEF1NOE;DE03720693292398718649;1
72069736;7492931340;GENODEF1BLT;DE45720697367492931340;1
72069789;5098313045;GENODEF1PFA;DE33720697895098313045;1
72080001;0000281955;DRESDEFF720;DE19720800010028195500;18
72080001;0045833859;DRESDEFF720;DE85720800010045833859;1
72090000;5596853557;GENODEF1AUB;DE46720900005596853557;1
72090500;1052120995;GENODEF1S03;DE16720905001052120995;1
72090500;8599373340;GENODEF1S03;DE58720905008599373340;1
72090900;2159175047;GENODEF1P14;DE46720909002159175047;1
72120078;0397830356;HYVEDEMM426;DE26721200780397830356;1
72120078;6600076238;HYVEDEMM620;DE39546200936600076238;19
72120079;0397954061;HYVEDEMM426;DE89721200780397954061;1
72120207;0397358938;;;-124
72120207;2421852386;;;-3
72122181;0397401476;HYVEDEMM665;DE05721221810397401476;1
72122181;1228183730;HYVEDEMM417;DE34763200721228183730;19
72160818;1193560591;GENODEF1INP;DE18721608181193560591;1
72169013;9398418424;GENODEF1ARH;DE02721690139398418424;1
72169080;2091507286;GENODEF1GSB;DE88721690802091507286;1
72169111;1995578641;GENODEF1HHW;DE85721691111995578641;1
72169218;7793224192;GENODEF1SBN;DE86721692187793224192;1
72169246;3497908010;GENODEF1WFN;DE32721692463497908010;1
72169380;4290463242;GENODEF1BLN;DE31721693804290463242;1
72169733;1997632210;GENODEF1LBE;DE31721697331997632210;1
72169745;8994268185;GENODEF1WDF;DE48721697458994268185;1
72169753;5399213478;GENODEF1OUS;DE19721697535399213478;1
72169756;5191129117;GENODEF1ND2;DE41721697565191129117;1
72169764;8999328500;GENODEF1WRI;DE06721697648999328500;1
72169812;7197785687;GENODEF1GAH;DE98721698127197785687;1
72169831;3790361067;GENODEF1RBL;DE24721698313790361067;1
72180002;0000387022;DRESDEFF721;DE65721800020038702200;18
72180002;0093901812;DRESDEFF721;DE21721800020093901812;1
72191300;7595197982;GENODEF1EIH;DE24721913007595197982;1
72191600;4193572921;GENODEF1PFI;DE62721916004193572921;1
72191800;4193836384;GENODEF1SHV;DE72721918004193836384;1
72220074;0397969247;HYVEDEMM255;DE89722200740397969247;1
72220074;2775939551;HYVEDEMM433;DE62743200732775939551;19
72223182;0397981833;HYVEDEMM263;DE04722231820397981833;1
72261754;8696540494;GENODEF1RLH;DE85722617548696540494;1
72262401;6691466423;GENODEF1DLG;DE52722624016691466423;1
72262901;3499268990;GENODEF1WTG;DE86722629013499268990;1
72290100;4299243881;GENODEF1DON;DE67722901004299243881;1
73061191;2890979818;GENODEF1NU1;DE24730611912890979818;1
73090000;7899760665;GENODEF1NUV;DE62730900007899760665;1
73120075;0397996177;HYVEDEMM436;DE55731200750397996177;1
73120075;5114383831;HYVEDEMM468;DE84830200865114383831;19
73160000;2495242864;GENODEF1MIR;DE11731600002495242864;1
73161455;5496544155;GENODEF1GNB;DE68731614555496544155;1
73180011;0000870079;DRESDEFF731;DE16731800110087007900;18
73180011;0055672524;DRESDEFF731;DE22731800110055672524;1
73190000;2593788193;GENODEF1MM1;DE71731900002593788193;1
73320073;0397875354;HYVEDEMM428;DE91733200730397875354;1
73320073;5416351050;HYVEDEMM462;DE91800200875416351050;19
73320442;0399853236;;;-124
73320442;9628652799;;;-3
73321177;0397834988;HYVEDEMM567;DE18733211770397834988;1
73321177;4507150140;HYVEDEMM414;DE87302201904507150140;19
73322380;0397606181;HYVEDEMM570;DE78733223800397606181;1
73361592;2480884513;           ;DE87733615922480884513;1
73362500;0010521953;RZTIDE71XXX;DE47733625000010521953;1
73362500;7487698965;RZTIDE71XXX;DE95733625007487698965;1
73369264;4395325360;GENODEF1DTA;DE54733692644395325360;1
73369821;7290017749;GENODEF1LBB;DE92733698217290017749;1
73369824;3493227833;GENODEF1HKE;DE25733698243493227833;1
73369826;4995689184;GENODEF1LIA;DE45733698264995689184;1
73369851;5095977520;GENODEF1AIT;DE45733698515095977520;1
73369854;1395623841;GENODEF1FCH;DE48733698541395623841;1
73369859;3399866048;GENODEF1BIN;DE84733698593399866048;1
73369871;8894061866;GENODEF1EGB;DE19733698718894061866;1
73369878;3791052467;GENODEF1FPN;DE34733698783791052467;1
73369881;6396022744;GENODEF1HWG;DE06733698816396022744;1
73369888;9593815352;GENODEF1PIR;DE78733698889593815352;1
73369902;6593004729;GENODEF1KM1;DE56733699026593004729;1
73369915;7491285976;GENODEF1GMG;DE13733699157491285976;1
73369918;3991545749;GENODEF1OKI;DE38733699183991545749;1
73369920;4893279035;GENODEF1SFO;DE14733699204893279035;1
73369933;1292249841;GENODEF1RHP;DE18733699331292249841;1
73369936;3591400937;GENODEF1SER;DE55733699363591400937;1
73369954;4499102234;GENODEF1WGO;DE15733699544499102234;1
73380004;0000872453;DRESDEFF733;DE17733800040087245300;18
73380004;0074989891;DRESDEFF733;DE57733800040074989891;1
73390000;8793435169;GENODEF1KEV;DE21733900008793435169;1
73392000;5197170321;GENODEF1IMV;DE05733920005197170321;1
73420071;0397221298;HYVEDEMM427;DE50734200710397221298;1
73420546;0399856644;;;-124
73420546;7092050500;;;-3
73421478;0397058281;HYVEDEMM666;DE06734214780397058281;1
73460046;8796042826;GENODEF1KFB;DE85734600468796042826;1
73480013;0000755321;DRESDEFF734;DE15734800130075532100;18
73480013;0076423197;DRESDEFF734;DE82734800130076423197;1
73491300;8398298305;GENODEF1OAL;DE52734913008398298305;1
74020074;0397388814;HYVEDEMM445;DE27740200740397388814;1
74020074;2317232775;HYVEDEMM408;DE19720200702317232775;19
74020100;1263655286;RZOODE77XXX;DE63740201001263655286;1
74020414;0397164317;;;-124
74020414;6962543357;HYVEDEMM433;DE19743200736962543357;19
74061101;1299267284;GENODEF1RGS;DE80740611011299267284;1
74061564;7898843303;GENODEF1NUI;DE15740615647898843303;1
74061670;2993180500;GENODEF1ORT;DE30740616702993180500;1
74061813;5791722047;GENODEF1PFK;DE73740618135791722047;1
74062490;4395485910;GENODEF1VIR;DE46740624904395485910;1
74062786;4592835953;GENODEF1TIE;DE08740627864592835953;1
74064593;5096939133;GENODEF1WSD;DE09740645935096939133;1
74064742;7093767013;GENODEF1FZE;DE16740647427093767013;1
74065782;9694120099;GENODEF1SZT;DE53740657829694120099;1
74066749;1199648717;GENODEF1HZN;DE23740667491199648717;1
74067000;2292111416;GENODEF1POC;DE40740670002292111416;1
74069186;6893978766;GENODEF1VIZ;DE20740691866893978766;1
74069744;3891259479;GENODEF1GRT;DE85740697443891259479;1
74069752;3494959226;GENODEF1HHU;DE45740697523494959226;1
74069758;9496470283;GENODEF1TKI;DE34740697589496470283;1
74069763;7091998972;GENODEF1MTH;DE96740697637091998972;1
74069768;2696720115;GENODEF1NHD;DE24740697682696720115;1
74090000;4791928427;GENODEF1PA1;DE78740900004791928427;1
74092400;7292429696;GENODEF1VIV;DE62740924007292429696;1
74120071;0397399953;HYVEDEMM415;DE12741200710397399953;1
74120071;6084010420;HYVEDEMM408;DE07720200706084010420;19
74120514;0397926494;;;-124
74120514;5499648199;HYVEDEMM098;DE06820200875499648199;19
74160025;3495796320;GENODEF1DEG;DE63741600253495796320;1
74161608;6691226651;GENODEF1HBW;DE07741616086691226651;1
74164149;3393128509;GENODEF1RGE;DE78741641493393128509;1
74165013;9993969058;GENODEF1AUS;DE24741650139993969058;1
74167099;4698061054;GENODEF1MTT;DE67741670994698061054;1
74180009;0000689646;DRESDEFF741;DE04741800090068964600;18
74180009;0027380657;DRESDEFF741;DE98741800090027380657;1
74190000;5995426655;GENODEF1DGV;DE15741900005995426655;1
74191000;3897198617;GENODEF1LND;DE89741910003897198617;1
74220075;0397883581;HYVEDEMM452;DE91742200750397883581;1
74220075;6502303072;HYVEDEMM483;DE51545201946502303072;19
74221170;0397089293;HYVEDEMM675;DE50742211700397089293;1
74260110;7396985674;GENODEF1SR2;DE18742601107396985674;1
74261024;3899270170;GENODEF1CHA;DE45742610243899270170;1
74290000;6490300530;GENODEF1SR1;DE42742900006490300530;1
74290100;1006571319;CBSRDE71XXX;DE06742901001006571319;1
74290100;8827298932;CBSRDE71XXX;DE66742901008827298932;1
74320073;0397087182;HYVEDEMM433;DE74743200730397087182;1
74320307;0397289793;;;-124
74320307;2466040412;HYVEDEMM433;DE70743200732466040412;19
74350000;1016612508;BYLADEM1LAH;DE32743500001016612508;1
74361211;9597729213;GENODEF1ARF;DE43743612119597729213;1
74362663;4596432187;GENODEF1ERG;DE52743626634596432187;1
74364689;6899852349;GENODEF1PFF;DE14743646896899852349;1
74366666;5090250737;GENODEF1GSH;DE95743666665090250737;1
74380007;0000563158;DRESDEFF743;DE26743800070056315800;18
74380007;0076192865;DRESDEFF743;DE95743800070076192865;1
75020073;0397104532;HYVEDEMM447;DE68750200730397104532;1
75020073;4733646670;HYVEDEMM445;DE85740200744733646670;19
75020314;0397956178;;;-124
75020314;2538378855;HYVEDEMMXXX;DE50700202702538378855;19
75021174;0397310069;HYVEDEMM804;DE62750211740397310069;1
75080003;0000380428;DRESDEFF750;DE11750800030038042800;18
75080003;0056873938;DRESDEFF750;DE14750800030056873938;1
75090500;1099715261;GENODEF1S05;DE89750905001099715261;1
75090629;0000293601;DAAEDEDDXXX;DE96300606010000293601;19
75090629;1323901663;DAAEDEDDXXX;DE64300606011323901663;19
75090629;2832929976;DAAEDEDDXXX;DE86300606012832929976;19
75090629;3986985491;DAAEDEDDXXX;DE40300606013986985491;19
75090629;4927808437;DAAEDEDDXXX;DE42300606014927808437;19
75090629;6378322896;DAAEDEDDXXX;DE08300606016378322896;19
75090629;7733467080;DAAEDEDDXXX;DE91300606017733467080;19
75090629;9377032230;DAAEDEDDXXX;DE23300606019377032230;19
75090900;1788066386;GENODEF1P18;DE76750909001788066386;1
75220070;0397093764;HYVEDEMM405;DE82752200700397093764;1
75220070;4769910110;HYVEDEMM480;DE75783200764769910110;19
75320075;0396125150;HYVEDEMM454;DE32753200750396125150;1
76010085;1047152532;PBNKDEFF760;DE63760100851047152532;1
76010085;6229166221;PBNKDEFF760;DE17760100856229166221;1
76020070;0396862199;HYVEDEMM460;DE85760200700396862199;1
76020214;0396756834;;;-124
76020600;1957004756;HSTBDEH1NUE;DE17760206001957004756;1
76026000;0001216171;NORSDE71XXX;DE39760260000001216171;1
76026000;0698237550;NORSDE71XXX;DE26760260000698237550;1
76026000;1222512103;;;-124
76026000;5812256183;;;-124
76026000;9914764731;;;-124
76030080;1937440842;CSDBDE71XXX;DE33760300801937440842;1
76035000;1273931977;UMWEDE7NXXX;DE18760350001273931977;1
76050101;1008773259;SSKNDE77XXX;DE81760501011008773259;1
76050101;8853924421;SSKNDE77XXX;DE97760501018853924421;1
76080040;0000955954;DRESDEFF760;DE32760800400095595400;18
76080040;0040351966;DRESDEFF760;DE64760800400040351966;1
76080053;0000398184;DRESDEFFAGI;DE70760800530039818400;18
76080053;0091487350;DRESDEFFAGI;DE83760800530091487350;1
76090500;1498577695;GENODEF1S06;DE54760905001498577695;1
76090613;0000107387;DAAEDEDDXXX;DE73300606010000107387;19
76090613;2212583194;DAAEDEDDXXX;DE41300606012212583194;19
76090613;2903561610;DAAEDEDDXXX;DE15300606012903561610;19
76090613;3995187982;DAAEDEDDXXX;DE79300606013995187982;19
76090613;4757062012;DAAEDEDDXXX;DE82300606014757062012;19
76090613;5690605468;DAAEDEDDXXX;DE64300606015690605468;19
76090613;7136136685;DAAEDEDDXXX;DE28300606017136136685;19
76090613;8314822595;DAAEDEDDXXX;DE65300606018314822595;19
76090900;1461534548;GENODEF1P17;DE92760909001461534548;1
76091000;1088229007;;;-124
76091000;4591538826;;;-124
76091000;9315729300;;;-124
76220073;0396969701;HYVEDEMM419;DE65762200730396969701;1
76230000;1147299285;QUBADE71XXX;DE10762300001147299285;1
76320072;0396026799;HYVEDEMM417;DE04763200720396026799;1
76350000;9769063248;BYLADEM1ERH;DE74763500009769063248;1
76420080;0396198400;HYVEDEMM065;DE17764200800396198400;1
76450000;0104203960;BYLADEM1SRS;DE91764500000104203960;1
76450000;1670192334;BYLADEM1SRS;DE80764500001670192334;1
76450000;3288694026;BYLADEM1SRS;DE56764500003288694026;1
76450000;4676993463;BYLADEM1SRS;DE65764500004676993463;1
76450000;6254189240;BYLADEM1SRS;DE15764500006254189240;1
76450000;7770830745;BYLADEM1SRS;DE45764500007770830745;1
76520071;0396901629;HYVEDEMM406;DE24765200710396901629;1
77020070;0396802648;HYVEDEMM411;DE65770200700396802648;1
77120073;0396008075;HYVEDEMM289;DE03771200730396008075;1
77320072;0396453233;HYVEDEMM412;DE64773200720396453233;1
77390500;1304839242;;;-124
77390500;6066715168;;;-124
77390500;9881731521;;;-124
77390628;0000306452;DAAEDEDDXXX;DE88300606010000306452;19
77390628;1840043915;DAAEDEDDXXX;DE74300606011840043915;19
77390628;2424553951;DAAEDEDDXXX;DE92300606012424553951;19
77390628;3233910252;DAAEDEDDXXX;DE36300606013233910252;19
77390628;3958298466;DAAEDEDDXXX;DE59300606013958298466;19
77390628;5236073484;DAAEDEDDXXX;DE68300606015236073484;19
77390628;7079320628;DAAEDEDDXXX;DE04300606017079320628;19
77390628;8436828086;DAAEDEDDXXX;DE35300606018436828086;19
78020070;0396642668;HYVEDEMM424;DE90780200700396642668;1
78020429;0396625131;;;-124
78030080;8174300133;DELMDE71XXX;DE29780300808174300133;1
78030081;3559366948;DESVDE71XXX;DE52780300813559366948;1
78320076;0396269735;HYVEDEMM480;DE59783200760396269735;1
79020076;0396773377;HYVEDEMM455;DE89790200760396773377;1
79020325;0396341956;;;-124
79020700;1499126600;HSTBDEH1WUE;DE22790207001499126600;1
79080052;0000439940;DRESDEFF790;DE17790800520043994000;18
79080052;0023530162;DRESDEFF790;DE03790800520023530162;1
79090624;0000349470;DAAEDEDDXXX;DE80300606010000349470;19
79090624;2239022783;DAAEDEDDXXX;DE19300606012239022783;19
79090624;3216638860;DAAEDEDDXXX;DE23300606013216638860;19
79090624;3999899372;DAAEDEDDXXX;DE95300606013999899372;19
79090624;5234810538;DAAEDEDDXXX;DE36300606015234810538;19
79090624;6579191275;DAAEDEDDXXX;DE24300606016579191275;19
79090624;7399950432;DAAEDEDDXXX;DE80300606017399950432;19
79090624;8651554581;DAAEDEDDXXX;DE77300606018651554581;19
79320075;0396975246;HYVEDEMM451;DE62793200750396975246;1
79320432;0396466903;;;-124
79380051;0000800545;DRESDEFF793;DE46793800510080054500;18
79380051;0068991960;DRESDEFF793;DE18793800510068991960;1
79520070;0396802512;HYVEDEMM407;DE37795200700396802512;1
79520533;0396823848;;;-124
79580099;0000691562;DRESDEFF795;DE16795800990069156200;18
79580099;0093381814;DRESDEFF795;DE02795800990093381814;1
80020086;0396845931;HYVEDEMM440;DE80800200860396845931;1
80020087;0396933453;HYVEDEMM462;DE38800200870396933453;1
80020130;5040545595;;;-124
80050500;8739888593;NOLADE21MQU;DE43800505008739888593;1
80053000;3607819075;NOLADE21BLK;DE23800530003607819075;1
80053552;1804266597;NOLADE21SGH;DE32800535521804266597;1
80053572;1461629140;NOLADE21DES;DE31800535721461629140;1
80053622;2500998692;NOLADE21KOT;DE78800536222500998692;1
80053722;2613598606;NOLADE21BTF;DE76800537222613598606;1
80053762;0104084239;NOLADE21HAL;DE81800537620104084239;1
80053762;1589848345;NOLADE21HAL;DE07800537621589848345;1
80053762;3422028195;NOLADE21HAL;DE39800537623422028195;1
80053762;5091018540;NOLADE21HAL;DE55800537625091018540;1
80053762;6753869989;NOLADE21HAL;DE58800537626753869989;1
80053762;8459001424;NOLADE21HAL;DE71800537628459001424;1
80053772;0103108042;TESTDEX9876;DE37800537720103108042;1
80053782;0105047105;TESTDEX9876;DE78800537820105047105;1
80054000;3342894406;NOLADE21BLK;DE40800530003342894406;1
80055008;5118227463;NOLADE21EIL;DE40800550085118227463;1
80055500;4050038280;NOLADE21SES;DE62800555004050038280;1
80080000;0000623015;DRESDEFF800;DE09800800000062301500;18
80080000;0051296557;DRESDEFF800;DE63800800000051296557;1
80550101;3082070603;NOLADE21WBL;DE74805501013082070603;1
80550200;6957584893;NOLADE21ZER;DE17805502006957584893;1
81050000;6568957966;NOLADE21SES;DE61800555006568957966;1
81050555;6424817334;NOLADE21SDL;DE30810505556424817334;1
81051000;4813359200;NOLADE21OCL;DE12810510004813359200;1
81052000;2429278793;NOLADE21HRZ;DE14810520002429278793;1
81053272;3207657230;NOLADE21MDG;DE92810532723207657230;1
81054000;8228760362;NOLADE21JEL;DE62810540008228760362;1
81055000;3046549899;NOLADE21HDL;DE08810550003046549899;1
81055555;3094250610;NOLADE21SAW;DE82810555553094250610;1
81080000;0000355690;DRESDEFF810;DE96810800000035569000;18
81080000;0037988837;DRESDEFF810;DE11810800000037988837;1
82020086;0396607716;HYVEDEMM498;DE56820200860396607716;1
82020087;0396095971;HYVEDEMM098;DE41820200870396095971;1
82020088;0396083039;HYVEDEMM824;DE40820200880396083039;1
82051000;1820138352;HELADEF1WEM;DE78820510001820138352;1
82052020;1026681754;HELADEF1GTH;DE87820520201026681754;1
82054052;2695473217;HELADEF1NOR;DE16820540522695473217;1
82055000;3751161154;HELADEF1KYF;DE77820550003751161154;1
82056060;3915185530;HELADEF1MUE;DE64820560603915185530;1
82057070;4154972150;HELADEF1EIC;DE79820570704154972150;1
82080000;0000576578;DRESDEFF827;DE84820800000057657800;18
82080000;0047920271;DRESDEFF827;DE08820800000047920271;1
83020086;0396335288;HYVEDEMM468;DE77830200860396335288;1
83020087;0396971562;HYVEDEMM463;DE93830200870396971562;1
83020088;0396829978;HYVEDEMM484;DE29830200880396829978;1
83050000;6553397323;HELADEF1GER;DE31830500006553397323;1
83050200;9483200366;HELADEF1ALT;DE25830502009483200366;1
83050303;5441812003;HELADEF1SAR;DE44830503035441812003;1
83050505;5236601969;HELADEF1SOK;DE08830505055236601969;1
83053030;1660476069;HELADEF1JEN;DE77830530301660476069;1
83080000;0000997067;DRESDEFF830;DE82830800000000997067;1
83080000;0070073775;DRESDEFF830;DE76830800007007377500;18
84020086;0396779743;HYVEDEMM477;DE25840200860396779743;1
84020087;0396324391;HYVEDEMM458;DE08840200870396324391;1
84050000;7115788000;HELADEF1RRS;DE22840500007115788000;1
84051010;4230700410;HELADEF1ILK;DE48840510104230700410;1
84054040;9715857954;HELADEF1HIL;DE02840540409715857954;1
84054722;9182085150;HELADEF1SON;DE23840547229182085150;1
84055050;9270182271;HELADEF1WAK;DE53840550509270182271;1
84080000;0000835699;DRESDEFF843;DE93840800000083569900;18
84080000;0099886209;DRESDEFF843;DE91840800000099886209;1
85020030;2601690745;;;-124
85020086;0396454293;HYVEDEMM496;DE17850200860396454293;1
85020890;0396145542;;;-124
85050100;6262389111;WELADED1GRL;DE68850501006262389111;1
85050200;3863570048;SOLADES1RGA;DE46850502003863570048;1
85050300;4789249013;OSDDDE81XXX;DE48850503004789249013;1
85050350;7831277000;OSDDDE81NET;DE29850503507831277000;1
85055000;2176507080;SOLADES1MEI;DE19850550002176507080;1
85080000;0000201194;DRESDEFF850;DE08850800000020119400;18
85080000;0058127632;DRESDEFF850;DE11850800000058127632;1
85080200;0000111879;DRESDEFF857;DE85850802000011187900;18
85080200;0026576770;DRESDEFF857;DE95850802000026576770;1
85550000;8737887115;SOLADES1BAT;DE53855500008737887115;1
85550200;9225744070;SOLADES1ZIT;DE79855502009225744070;1
86010090;1167184159;PBNKDEFF860;DE61860100901167184159;1
86010090;6192127015;PBNKDEFF860;DE47860100906192127015;1
86020030;1312199892;;;-124
86020086;0396287966;HYVEDEMM495;DE12860200860396287966;1
86020200;2043360437;BHFBDEFF860;DE92860202002043360437;1
86020600;1421962045;HSTBDEH1LEI;DE97860206001421962045;1
86020880;0396071819;;;-124
86050200;7836288751;SOLADES1GRM;DE43860502007836288751;1
86050600;6733437080;WELADED1TGU;DE85860506006733437080;1
86055002;6771935637;SOLADES1DES;DE04860550026771935637;1
86055462;1071286451;SOLADES1DLN;DE41860554621071286451;1
86055592;1056852166;WELADE8LXXX;DE97860555921056852166;1
86055592;7039604650;WELADE8LXXX;DE18860555927039604650;1
86080000;0000760602;DRESDEFF860;DE30860800000076060200;18
86080000;0045498952;DRESDEFF860;DE43860800000045498952;1
86080055;0000899100;DRESDEFF862;DE18860800550089910000;18
86080055;0018856602;DRESDEFF862;DE14860800550018856602;1
86080057;0000233912;DRESDEFF867;DE17860800570023391200;18
86080057;0022228857;DRESDEFF867;DE92860800570022228857;1
87020086;0396901729;HYVEDEMM497;DE60870200860396901729;1
87020087;0396188184;HYVEDEMM481;DE58870200870396188184;1
87020088;0396321227;HYVEDEMM441;DE36870200880396321227;1
87050000;9515234511;CHEKDE81XXX;DE28870500009515234511;1
87051000;5032479510;WELADED1MTW;DE33870510005032479510;1
87052000;9874011200;WELADED1FGX;DE60870520009874011200;1
87053000;2708411180;SOLADES1SME;DE60870530002708411180;1
87054000;8056681451;WELADED1STB;DE65870540008056681451;1
87055000;5421348212;WELADED1ZWI;DE96870550005421348212;1
87056000;5831948910;WELADED1AUS;DE85870560005831948910;1
87058000;2345054738;WELADED1PLX;DE65870580002345054738;1
87080000;0000520202;DRESDEFF870;DE43870800000052020200;18
87080000;0044634810;DRESDEFF870;DE54870800000044634810;1
