/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.xml;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.StringWebResponse;
import com.gargoylesoftware.htmlunit.WebRequest;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.DomCDataSection;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.DomProcessingInstruction;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.configuration.BrowserName;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxSetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.WebBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.Attr;
import com.gargoylesoftware.htmlunit.javascript.host.Document;
import com.gargoylesoftware.htmlunit.javascript.host.Element;
import com.gargoylesoftware.htmlunit.javascript.host.Node;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLCollection;
import com.gargoylesoftware.htmlunit.javascript.host.xml.XMLAttr;
import com.gargoylesoftware.htmlunit.javascript.host.xml.XMLDOMParseError;
import com.gargoylesoftware.htmlunit.javascript.host.xml.XMLSerializer;
import com.gargoylesoftware.htmlunit.xml.XmlPage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@JsxClass(browsers={@WebBrowser(value=BrowserName.FF)})
public class XMLDocument
extends Document {
    private static final Log LOG = LogFactory.getLog(XMLDocument.class);
    private boolean async_ = true;
    private boolean preserveWhiteSpace_;
    private XMLDOMParseError parseError_;

    public XMLDocument() {
        this(null);
    }

    public XMLDocument(WebWindow enclosingWindow) {
        if (enclosingWindow != null) {
            try {
                XmlPage page = new XmlPage((WebResponse)null, enclosingWindow);
                this.setDomNode(page);
            }
            catch (IOException e) {
                throw Context.reportRuntimeError((String)("IOException: " + e));
            }
        }
    }

    @JsxSetter
    public void setAsync(boolean async) {
        this.async_ = async;
    }

    @JsxGetter
    public boolean getAsync() {
        return this.async_;
    }

    @JsxFunction
    public boolean load(String xmlSource) {
        if (this.async_ && LOG.isDebugEnabled()) {
            LOG.debug((Object)"XMLDocument.load(): 'async' is true, currently treated as false.");
        }
        try {
            HtmlPage htmlPage = (HtmlPage)this.getWindow().getWebWindow().getEnclosedPage();
            WebRequest request = new WebRequest(htmlPage.getFullyQualifiedUrl(xmlSource));
            WebResponse webResponse = this.getWindow().getWebWindow().getWebClient().loadWebResponse(request);
            XmlPage page = new XmlPage(webResponse, this.getWindow().getWebWindow(), false);
            this.setDomNode(page);
            return true;
        }
        catch (IOException e) {
            XMLDOMParseError parseError = this.getParseError();
            parseError.setErrorCode(-1);
            parseError.setFilepos(1);
            parseError.setLine(1);
            parseError.setLinepos(1);
            parseError.setReason(e.getMessage());
            parseError.setSrcText("xml");
            parseError.setUrl(xmlSource);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Error parsing XML from '" + xmlSource + "'"), (Throwable)e);
            }
            return false;
        }
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.IE), @WebBrowser(value=BrowserName.CHROME)})
    public boolean loadXML(String strXML) {
        try {
            WebWindow webWindow = this.getWindow().getWebWindow();
            StringWebResponse webResponse = new StringWebResponse(strXML, webWindow.getEnclosedPage().getUrl());
            XmlPage page = new XmlPage(webResponse, webWindow);
            this.setDomNode(page);
            return true;
        }
        catch (IOException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Error parsing XML\n" + strXML), (Throwable)e);
            }
            return false;
        }
    }

    @Override
    public SimpleScriptable makeScriptableFor(DomNode domNode) {
        Node scriptable;
        if (domNode instanceof DomElement && !(domNode instanceof HtmlElement)) {
            scriptable = new Element();
        } else if (domNode instanceof DomAttr) {
            scriptable = this.getPage().getWebClient().getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_XML_ATTRIBUTE_HAS_TEXT_PROPERTY) ? new XMLAttr() : new Attr();
        } else {
            return super.makeScriptableFor(domNode);
        }
        scriptable.setPrototype(this.getPrototype(scriptable.getClass()));
        scriptable.setParentScope(this.getParentScope());
        ((SimpleScriptable)scriptable).setDomNode(domNode);
        return scriptable;
    }

    @Override
    protected void initParentScope(DomNode domNode, SimpleScriptable scriptable) {
        scriptable.setParentScope(this.getParentScope());
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE), @WebBrowser(value=BrowserName.CHROME)})
    public XMLDOMParseError getParseError() {
        if (this.parseError_ == null) {
            this.parseError_ = new XMLDOMParseError();
            this.parseError_.setPrototype(this.getPrototype(this.parseError_.getClass()));
            this.parseError_.setParentScope(this.getParentScope());
        }
        return this.parseError_;
    }

    @Override
    @JsxGetter(value={@WebBrowser(value=BrowserName.IE), @WebBrowser(value=BrowserName.CHROME)})
    public String getXml() {
        XMLSerializer seralizer = new XMLSerializer();
        seralizer.setParentScope(this.getWindow());
        seralizer.setPrototype(this.getPrototype(seralizer.getClass()));
        return seralizer.serializeToString(this.getDocumentElement());
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE), @WebBrowser(value=BrowserName.CHROME)})
    public boolean getPreserveWhiteSpace() {
        return this.preserveWhiteSpace_;
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.IE), @WebBrowser(value=BrowserName.CHROME)})
    public void setPreserveWhiteSpace(boolean preserveWhiteSpace) {
        this.preserveWhiteSpace_ = preserveWhiteSpace;
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.IE), @WebBrowser(value=BrowserName.CHROME)})
    public void setProperty(String name, String value) {
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.IE), @WebBrowser(value=BrowserName.CHROME)})
    public HTMLCollection selectNodes(final String expression) {
        boolean attributeChangeSensitive = expression.contains("@");
        String description = "XMLDocument.selectNodes('" + expression + "')";
        final SgmlPage page = this.getPage();
        HTMLCollection collection = new HTMLCollection(page.getDocumentElement(), attributeChangeSensitive, description){

            @Override
            protected List<Object> computeElements() {
                ArrayList<Object> list = new ArrayList<Object>(page.getByXPath(expression));
                return list;
            }
        };
        return collection;
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.IE), @WebBrowser(value=BrowserName.CHROME)})
    public Object selectSingleNode(String expression) {
        HTMLCollection collection = this.selectNodes(expression);
        if (collection.getLength() > 0) {
            return collection.get(0, (Scriptable)collection);
        }
        return null;
    }

    @Override
    @JsxFunction(value={@WebBrowser(value=BrowserName.IE), @WebBrowser(value=BrowserName.CHROME)})
    public HTMLCollection getElementsByTagName(final String tagName) {
        DomNode firstChild = ((DomNode)this.getDomNodeOrDie()).getFirstChild();
        if (firstChild == null) {
            return HTMLCollection.emptyCollection(this.getWindow());
        }
        HTMLCollection collection = new HTMLCollection((DomNode)this.getDomNodeOrDie(), false, "XMLDocument.getElementsByTagName"){

            @Override
            protected boolean isMatching(DomNode node) {
                return node.getNodeName().equals(tagName);
            }
        };
        return collection;
    }

    @JsxFunction
    public Object getElementById(String id) {
        XmlPage xmlPage = (XmlPage)this.getDomNodeOrDie();
        Object domElement = xmlPage.getFirstByXPath("//*[@id = \"" + id + "\"]");
        if (domElement == null) {
            return null;
        }
        if (domElement instanceof HtmlElement) {
            return ((HtmlElement)domElement).getScriptObject();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("getElementById(" + id + "): no HTML DOM node found with this ID"));
        }
        return null;
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.IE), @WebBrowser(value=BrowserName.CHROME)})
    public Object nodeFromID(String id) {
        return null;
    }

    @JsxFunction
    public Object createProcessingInstruction(String target, String data) {
        DomProcessingInstruction node = ((XmlPage)this.getPage()).createProcessingInstruction(target, data);
        return this.getScriptableFor(node);
    }

    @JsxFunction
    public Object createCDATASection(String data) {
        DomCDataSection node = ((XmlPage)this.getPage()).createCDATASection(data);
        return this.getScriptableFor(node);
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.IE), @WebBrowser(value=BrowserName.CHROME)})
    public Object createNode(Object type, String name, Object namespaceURI) {
        switch ((short)Context.toNumber((Object)type)) {
            case 1: {
                return this.createElementNS((String)namespaceURI, name);
            }
            case 2: {
                return this.createAttribute(name);
            }
        }
        throw Context.reportRuntimeError((String)("xmlDoc.createNode(): Unsupported type " + (short)Context.toNumber((Object)type)));
    }
}

