

package Blog::Spam::Plugin::hashcash;


use strict;
use warnings;
use URI::Find;


=begin doc

Constructor.  Called when this plugin is instantiated.

This merely saves away the name of our plugin.

=end doc

=cut

sub new
{
    my ( $proto, %supplied ) = (@_);
    my $class = ref($proto) || $proto;

    my $self = {};
    $self->{ 'name' } = $proto;

    # verbose?
    $self->{ 'verbose' } = $supplied{ 'verbose' } || 0;

    bless( $self, $class );
    return $self;
}


sub name
{
    my ($self) = (@_);
    return ( $self->{ 'name' } );
}


=begin doc

Block if we find a warning generated by the Wordpress HashCash plugin.

=end doc

=cut

sub testComment
{
    my ( $self, %params ) = (@_);

    #
    #  Get the body content.
    #
    my $body = $params{ 'comment' };

    #
    #  Strip newlines, etc.
    #
    $body =~ s/[\r\n]//g;

    #
    #  Bogus?
    #
    if ( $body =~
        /\[WORDPRESS HASHCASH\] The poster sent us .* which is not a hashcash value/i
       )
    {
        return "SPAM:Hashcash warning";
    }
    else
    {
        return "OK";
    }
}


1;
