#!/usr/bin/perl -w
# based on hecommon.bin
# http://bmrc.berkeley.edu/ftp/pub/multimedia/mpeg/mpeg2/conformance-bitstreams/audio/mpeg1/compliance/

use strict;
use integer;

my $n;
use Test::More tests => ($n = 30) * 12 + 2;
BEGIN { use_ok("MPEG::Audio::Frame") };

$MPEG::Audio::Frame::lax = 1; # there's an invalid emph bit

for (1 .. $n){
	isa_ok(my $frame = MPEG::Audio::Frame->read(*DATA), "MPEG::Audio::Frame", "frame $_");
	ok($frame->mpeg1, "frame is MPEG1");
	ok($frame->layer3, "frame is layer III");
	ok(($_ <= 5 xor $frame->has_crc), "proper has_crc bit");
	ok(($_ == 7 xor !$frame->private), "proper private bit");
	ok(($_ == 8 xor !$frame->copyright), "proper copyright bit");
	ok(($_ == 9 xor !$frame->home), "proper home bit");
	is($frame->emph, ($_ <= 9 || $_ >= 13 ? 0 : ($_-1) % 4), "proper home bit");
	ok(!$frame->broken, "frame isn't broken");
	is($frame->sample, 44100, "sample rate");
	is($frame->bitrate, 128, "bitrate");
	ok($frame->stereo, "frame is stereo");
}
is(MPEG::Audio::Frame->read(*DATA), undef, "nothing else in the file");

__DATA__
    :@CvHg, ]f5 ,y_kEc+s1,y_V27??,y_kEc+s1,y_V27??                                                                      ,y_kEc+s1,y_V27??                                         :@CvHg, ]f5                                                                                                                                                                                                                                                              ,y_kEc+s1,y_V27??                                        :@CvHg, ]f5                                                                                                                                                                                                                                                              ,y_kEc+s1,y_V27??                                        :@CvHg, ]f5                                                                                                                                                                                                                                                              ,y_kEc+s1,y_V27??                                        :@CvHg, ]f5                                                                                                                                                                                                                                                            ,y_kEc+s1,y_V27??                                         O :@CvHg, ]f5                                                                                                                                                                                                                                                          ,y_kEc+s1,y_V27??                                         xL :@CvHg, ]f5                                                                                                                                                                                                                                                          ,y_kEc+s1,y_V27??                                        , :@CvHg, ]f5                                                                                                                                                                                                                                                          ,y_kEc+s1,y_V27??                                         :@CvHg, ]f5                                                                                                                                                                                                                                                          ,y_kEc+s1,y_V27??                                          :@CvHg, ]f5                                                                                                                                                                                                                                                          ,y_kEc+s1,y_V27??                                         :@CvHg, ]f5                                                                                                                                                                                                                                                          ,y_kEc+s1,y_V27??                                         :@CvHg, ]f5                                                                                                                                                                                                                                                          ,y_kEc+s1,y_V27??                                         O :@CvHg, ]f5                                                                                                                                                                                                                                                          ,y_kEc+s1,y_V27??                                         O :@CvHg, ]f5                                                                                                                                                                                                                                                          ,y_kEc+s1,y_V27??                                         O :@CvHg, ]f5                                                                                                                                                                                                                                                          ,y_kEc+s1,y_V27??                                         O :@CvHg, ]f5                                                                                                                                                                                                                                                          ,y_kEc+s1,y_V27??                                         O :@CvHg, ]f5                                                                                                                                                                                                                                                          ,y_kEc+s1,y_V27??                                         O :@CvHg, ]f5                                                                                                                                                                                                                                                          ,y_kEc+s1,y_V27??                                         O :@CvHg, ]f5                                                                                                                                                                                                                                                          ,y_kEc+s1,y_V27??                                         O :@CvHg, ]f5                                                                                                                                                                                                                                                          ,y_kEc+s1,y_V27??                                         O :@CvHg, ]f5                                                                                                                                                                                                                                                          ,y_kEc+s1,y_V27??                                         O :@CvHg, ]f5                                                                                                                                                                                                                                                          ,y_kEc+s1,y_V27??                                         O :@CvHg, ]f5                                                                                                                                                                                                                                                          ,y_kEc+s1,y_V27??                                         O :@CvHg, ]f5                                                                                                                                                                                                                                                          ,y_kEc+s1,y_V27??                                         O :@CvHg, ]f5                                                                                                                                                                                                                                                         ,y_kEc+s1,y_V27??                                          L :@CvHg, ]f5                                                                                                                                                                                                                                                         ,y_kEc+s1,y_V27??                                         O :@CvHg, ]f5                                                                                                                                                                                                                                                          ,y_kEc+s1,y_V27??                                         O :@CvHg, ]f5                                                                                                                                                                                                                                                          ,y_kEc+s1,y_V27??                                         O :@CvHg, ]f5                                                                                                                                                                                                                                                          ,y_kEc+s1,y_V27??                                         O :@CvHg, ]f5                                                                                                                                                                                                                                                          ,y_kEc+s1,y_V27??                                        
