# Build.PL for Perl::Critic::logicLAB

# $Id: Build.PL 8176 2013-08-01 12:55:50Z jonasbn $

use strict;
use warnings;
use Module::Build;

our $VERSION = '0.07';

my $build = Module::Build->new(
    dist_author   => 'Jonas B. Nielsen (jonasbn), <jonasbn@cpan.org>',
    module_name   => 'Perl::Critic::logicLAB',
    license       => 'artistic',
    create_makefile_pl => 'traditional',
    create_readme => 1,
    requires      => {
        'Perl::Critic::Policy::logicLAB::ProhibitUseLib'        => '0',
        'Perl::Critic::Policy::logicLAB::RequireVersionFormat'  => '0',
        'Perl::Critic::Policy::logicLAB::ProhibitShellDispatch' => '0',
        'Perl::Critic::Policy::logicLAB::RequireSheBang'        => '0',
    },
    meta_merge => {
        resources => {
            homepage => 'http://logiclab.jira.com/wiki/display/PCLL/Home',
            bugtracker =>
                'http://rt.cpan.org/NoAuth/Bugs.html?Dist=Perl-Critic-logicLAB',
            repository => 'http://logicLAB.jira.com/svn/PCLL',
            ProjectChangelog =>
                'http://logiclab.jira.com/browse/PCLL#selectedTab=com.atlassian.jira.plugin.system.project%3Achangelog-panel',
            ProjectSite => 'http://logicLAB.jira.com/browse/PCLL',
            ProjectWiki => 'http://logiclab.jira.com/wiki/display/PCLL/Home',
        }
    },
);

$build->create_build_script();
