package Number::Phone::JP::Table::Home;

use strict;
require Exporter;
use vars qw($VERSION @ISA @EXPORT %TEL_TABLE);

$VERSION = '0.01';

@ISA    = qw(Exporter);
@EXPORT = qw(%TEL_TABLE);

# Table-Last-Modified: 2003/05/15
%TEL_TABLE = (
	# Area-Pref => q<Local-Pref-Regex>,
	11    => '\d{3}',
	123   => '\d\d',
	1242  => '\d',
	125   => '\d\d',
	126   => '\d\d',
	1267  => '\d',
	133   => '\d\d',
	134   => '\d\d',
	135   => '\d\d',
	136   => '\d\d',
	1372  => '\d',
	1374  => '\d',
	1376  => '\d',
	1377  => '\d',
	1378  => '\d',
	138   => '\d\d',
	1392  => '\d',
	1394  => '\d',
	1395  => '\d',
	1396  => '\d',
	1397  => '\d',
	1398  => '\d',
	142   => '\d\d',
	143   => '\d\d',
	144   => '\d\d',
	145   => '\d\d',
	1454  => '\d',
	1456  => '\d',
	1457  => '\d',
	146   => '\d\d',
	1466  => '\d',
	152   => '\d\d',
	1522  => '\d',
	1527  => '\d',
	153   => '\d\d',
	1537  => '\d',
	1538  => '\d',
	154   => '\d\d',
	1547  => '\d',
	1548  => '\d',
	155   => '\d\d',
	1557  => '\d',
	1558  => '\d',
	1562  => '\d',
	1564  => '\d',
	1566  => '\d',
	157   => '\d\d',
	1582  => '\d',
	15829 => '',
	1584  => '\d',
	1586  => '\d',
	1587  => '\d',
	1588  => '\d',
	162   => '\d\d',
	1632  => '\d',
	1634  => '\d',
	1635  => '\d',
	1636  => '\d',
	1638  => '\d',
	164   => '\d\d',
	1646  => '\d',
	1648  => '\d',
	1652  => '\d',
	16528 => '',
	1653  => '\d',
	16532 => '',
	16534 => '',
	1654  => '\d',
	1655  => '\d',
	1656  => '\d',
	1658  => '\d',
	166   => '\d\d',
	167   => '\d\d',
	172   => '\d\d',
	173   => '\d\d',
	174   => '\d\d',
	175   => '\d\d',
	176   => '\d\d',
	17    => '\d{3}',
	178   => '\d\d',
	179   => '\d\d',
	182   => '\d\d',
	183   => '\d\d',
	184   => '\d\d',
	185   => '\d\d',
	186   => '\d\d',
	187   => '\d\d',
	18    => '\d{3}',
	191   => '\d\d',
	192   => '\d\d',
	193   => '\d\d',
	194   => '\d\d',
	195   => '\d\d',
	19    => '\d{3}',
	197   => '\d\d',
	198   => '\d\d',
	22    => '\d{3}',
	220   => '\d\d',
	223   => '\d\d',
	224   => '\d\d',
	225   => '\d\d',
	226   => '\d\d',
	228   => '\d\d',
	229   => '\d\d',
	233   => '\d\d',
	234   => '\d\d',
	235   => '\d\d',
	23    => '\d{3}',
	237   => '\d\d',
	238   => '\d\d',
	240   => '\d\d',
	241   => '\d\d',
	242   => '\d\d',
	243   => '\d\d',
	244   => '\d\d',
	24    => '\d{3}',
	246   => '\d\d',
	247   => '\d\d',
	248   => '\d\d',
	25    => '\d{3}',
	250   => '\d\d',
	254   => '\d\d',
	2549  => '\d',
	255   => '\d\d',
	256   => '\d\d',
	257   => '\d\d',
	258   => '\d\d',
	259   => '\d\d',
	260   => '\d\d',
	261   => '\d\d',
	26    => '\d{3}',
	263   => '\d\d',
	264   => '\d\d',
	265   => '\d\d',
	266   => '\d\d',
	267   => '\d\d',
	268   => '\d\d',
	269   => '\d\d',
	270   => '\d\d',
	27    => '\d{3}',
	274   => '\d\d',
	276   => '\d\d',
	277   => '\d\d',
	278   => '\d\d',
	279   => '\d\d',
	280   => '\d\d',
	282   => '\d\d',
	283   => '\d\d',
	284   => '\d\d',
	285   => '\d\d',
	28    => '\d{3}',
	287   => '\d\d',
	288   => '\d\d',
	289   => '\d\d',
	291   => '\d\d',
	29    => '\d{3}',
	293   => '\d\d',
	294   => '\d\d',
	295   => '\d\d',
	2957  => '\d',
	296   => '\d\d',
	297   => '\d\d',
	299   => '\d\d',
	3     => '\d{4}',
	422   => '\d\d',
	42    => '\d{3}',
	424   => '\d\d',
	426   => '\d\d',
	428   => '\d\d',
	4     => '\d{4}',
	43    => '\d{3}',
	436   => '\d\d',
	438   => '\d\d',
	439   => '\d\d',
	44    => '\d{3}',
	45    => '\d{3}',
	460   => '\d',
	46    => '\d{3}',
	463   => '\d\d',
	465   => '\d\d',
	466   => '\d\d',
	467   => '\d\d',
	470   => '\d\d',
	47    => '\d{3}',
	475   => '\d\d',
	476   => '\d\d',
	478   => '\d\d',
	479   => '\d\d',
	48    => '\d{3}',
	480   => '\d\d',
	49    => '\d{3}',
	493   => '\d\d',
	494   => '\d\d',
	495   => '\d\d',
	4992  => '\d',
	4994  => '\d',
	4996  => '\d',
	4998  => '\d',
	52    => '\d{3}',
	53    => '\d{3}',
	531   => '\d\d',
	532   => '\d\d',
	533   => '\d\d',
	536   => '\d\d',
	537   => '\d\d',
	538   => '\d\d',
	539   => '\d\d',
	54    => '\d{3}',
	543   => '\d\d',
	544   => '\d\d',
	545   => '\d\d',
	547   => '\d\d',
	548   => '\d\d',
	550   => '\d\d',
	551   => '\d\d',
	55    => '\d{3}',
	553   => '\d\d',
	554   => '\d\d',
	555   => '\d\d',
	556   => '\d\d',
	557   => '\d\d',
	558   => '\d\d',
	561   => '\d\d',
	562   => '\d\d',
	563   => '\d\d',
	564   => '\d\d',
	565   => '\d\d',
	566   => '\d\d',
	567   => '\d\d',
	568   => '\d\d',
	569   => '\d\d',
	572   => '\d\d',
	573   => '\d\d',
	574   => '\d\d',
	575   => '\d\d',
	576   => '\d\d',
	5769  => '\d',
	577   => '\d\d',
	578   => '\d',
	58    => '\d{3}',
	581   => '\d\d',
	583   => '\d\d',
	584   => '\d\d',
	585   => '\d\d',
	586   => '\d\d',
	587   => '\d\d',
	59    => '\d{3}',
	593   => '\d\d',
	594   => '\d\d',
	595   => '\d\d',
	596   => '\d\d',
	597   => '\d\d',
	5974  => '\d',
	5979  => '\d',
	598   => '\d\d',
	599   => '\d\d',
	6     => '\d{4}',
	72    => '\d{3}',
	721   => '\d\d',
	724   => '\d\d',
	725   => '\d\d',
	729   => '\d\d',
	73    => '\d{3}',
	735   => '\d\d',
	736   => '\d\d',
	737   => '\d\d',
	738   => '\d\d',
	739   => '\d\d',
	740   => '\d\d',
	742   => '\d\d',
	743   => '\d\d',
	7439  => '\d',
	744   => '\d\d',
	7443  => '\d',
	745   => '\d\d',
	7463  => '\d',
	7464  => '\d',
	7465  => '\d',
	7466  => '\d',
	7468  => '\d',
	7472  => '\d',
	7473  => '\d',
	747   => '\d\d',
	748   => '\d\d',
	749   => '\d\d',
	75    => '\d{3}',
	761   => '\d\d',
	76    => '\d{3}',
	763   => '\d\d',
	765   => '\d\d',
	766   => '\d\d',
	767   => '\d\d',
	768   => '\d\d',
	770   => '\d\d',
	771   => '\d\d',
	772   => '\d\d',
	773   => '\d\d',
	774   => '\d\d',
	77    => '\d{3}',
	776   => '\d\d',
	778   => '\d\d',
	779   => '\d\d',
	7797  => '\d',
	78    => '\d{3}',
	790   => '\d\d',
	791   => '\d\d',
	792   => '\d\d',
	7932  => '\d',
	7933  => '\d',
	794   => '\d\d',
	795   => '\d\d',
	79    => '\d{3}',
	796   => '\d\d',
	797   => '\d\d',
	798   => '\d\d',
	799   => '\d\d',
	82    => '\d{3}',
	820   => '\d\d',
	823   => '\d\d',
	824   => '\d\d',
	826   => '\d\d',
	827   => '\d\d',
	829   => '\d\d',
	832   => '\d\d',
	833   => '\d\d',
	834   => '\d\d',
	835   => '\d\d',
	836   => '\d\d',
	837   => '\d\d',
	838   => '\d\d',
	8387  => '\d',
	8388  => '\d',
	83    => '\d{3}',
	8395  => '\d',
	8396  => '\d',
	8452  => '\d',
	846   => '\d\d',
	8466  => '\d',
	847   => '\d\d',
	8477  => '\d',
	8478  => '\d',
	848   => '\d\d',
	8487  => '\d',
	84    => '\d{3}',
	8512  => '\d',
	8514  => '\d',
	852   => '\d\d',
	853   => '\d\d',
	854   => '\d\d',
	855   => '\d\d',
	856   => '\d\d',
	857   => '\d\d',
	858   => '\d\d',
	859   => '\d\d',
	86    => '\d{3}',
	863   => '\d\d',
	8636  => '\d',
	865   => '\d\d',
	866   => '\d\d',
	867   => '\d\d',
	868   => '\d\d',
	869   => '\d\d',
	8699  => '\d',
	875   => '\d\d',
	877   => '\d\d',
	87    => '\d{3}',
	879   => '\d\d',
	880   => '\d\d',
	883   => '\d\d',
	884   => '\d\d',
	8853  => '\d',
	8854  => '\d',
	88    => '\d{3}',
	887   => '\d\d',
	8874  => '\d',
	889   => '\d\d',
	892   => '\d\d',
	893   => '\d\d',
	894   => '\d\d',
	895   => '\d\d',
	896   => '\d\d',
	897   => '\d\d',
	898   => '\d\d',
	89    => '\d{3}',
	92    => '\d{3}',
	920   => '\d\d',
	93    => '\d{3}',
	930   => '\d\d',
	940   => '\d\d',
	942   => '\d\d',
	943   => '\d\d',
	944   => '\d\d',
	946   => '\d\d',
	947   => '\d\d',
	948   => '\d\d',
	949   => '\d\d',
	9496  => '\d',
	950   => '\d\d',
	952   => '\d\d',
	954   => '\d\d',
	955   => '\d\d',
	956   => '\d\d',
	957   => '\d\d',
	95    => '\d{3}',
	959   => '\d\d',
	96    => '\d{3}',
	964   => '\d\d',
	965   => '\d\d',
	966   => '\d\d',
	967   => '\d\d',
	968   => '\d\d',
	969   => '\d\d',
	972   => '\d\d',
	973   => '\d\d',
	974   => '\d\d',
	97    => '\d{3}',
	977   => '\d\d',
	978   => '\d\d',
	979   => '\d\d',
	98    => '\d{3}',
	980   => '\d\d',
	9802  => '\d',
	982   => '\d\d',
	983   => '\d\d',
	984   => '\d\d',
	985   => '\d\d',
	986   => '\d\d',
	987   => '\d\d',
	9912  => '\d',
	9913  => '\d',
	99    => '\d{3}',
	993   => '\d\d',
	994   => '\d\d',
	995   => '\d\d',
	996   => '\d\d',
	9969  => '\d',
	997   => '\d\d',
);

%TEL_TABLE = map { $_ => $TEL_TABLE{$_} . '\d{4}' } keys %TEL_TABLE;

1;
__END__

=pod

=head1 NAME

Number::Phone::JP::Table::Home - Regex table for Japanese home telephones

=head1 SYNOPSIS

B<DO NOT USE THIS MODULE DIRECTLY>

=head1 DESCRIPTION

This module defines Japanese home telephones table to use by
Number::Phone::JP.

=head1 SEE ALSO

L<Number::Phone::JP>,
http://www.soumu.go.jp/joho_tsusin/top/tel_number/shigai_list.html

=head1 AUTHOR

Koichi Taniguchi <taniguchi@users.sourceforge.jp>

=cut
