/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.css;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlTableRow;
import com.gargoylesoftware.htmlunit.javascript.host.Text;
import com.gargoylesoftware.htmlunit.javascript.host.css.CSSStyleDeclaration;
import com.gargoylesoftware.htmlunit.javascript.host.css.SelectorSpecificity;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLBodyElement;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLCanvasElement;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLElement;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import org.apache.commons.lang.StringUtils;
import org.w3c.css.sac.Selector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComputedCSSStyleDeclaration
extends CSSStyleDeclaration {
    private static final int PIXELS_PER_CHAR = 10;
    private static final Set<String> INHERITABLE_ATTRIBUTES = new HashSet<String>(Arrays.asList("azimuth", "border-collapse", "border-spacing", "caption-side", "color", "cursor", "direction", "elevation", "empty-cells", "font-family", "font-size", "font-style", "font-variant", "font-weight", "font", "letter-spacing", "line-height", "list-style-image", "list-style-position", "list-style-type", "list-style", "orphans", "pitch-range", "pitch", "quotes", "richness", "speak-header", "speak-numeral", "speak-punctuation", "speak", "speech-rate", "stress", "text-align", "text-indent", "text-transform", "visibility", "voice-fFamily", "volume", "white-space", "widows", "word-spacing"));
    private SortedMap<String, CSSStyleDeclaration.StyleElement> localModifications_ = new TreeMap<String, CSSStyleDeclaration.StyleElement>();
    private Map<String, String> defaultDisplays_;
    private Integer width_;
    private Integer height_;
    private Integer height2_;
    private Integer paddingHorizontal_;
    private Integer paddingVertical_;
    private Integer borderHorizontal_;
    private Integer borderVertical_;

    public ComputedCSSStyleDeclaration() {
    }

    public ComputedCSSStyleDeclaration(CSSStyleDeclaration style) {
        super(style.getElement());
        this.getElement().setDefaults(this);
    }

    @Override
    protected String getStyleAttribute(String name, Map<String, CSSStyleDeclaration.StyleElement> styleMap) {
        HTMLElement parent;
        String s = super.getStyleAttribute(name, null);
        if (s.length() == 0 && this.isInheritable(name) && (parent = this.getElement().getParentHTMLElement()) != null) {
            s = this.getWindow().jsxFunction_getComputedStyle(parent, null).getStyleAttribute(name, null);
        }
        return s;
    }

    private boolean isInheritable(String name) {
        return INHERITABLE_ATTRIBUTES.contains(name);
    }

    @Override
    protected void setStyleAttribute(String name, String newValue) {
    }

    public void applyStyleFromSelector(org.w3c.dom.css.CSSStyleDeclaration declaration, Selector selector) {
        SelectorSpecificity specificity = new SelectorSpecificity(selector);
        for (int k = 0; k < declaration.getLength(); ++k) {
            String name = declaration.item(k);
            String value = declaration.getPropertyValue(name);
            String priority = declaration.getPropertyPriority(name);
            this.applyLocalStyleAttribute(name, value, priority, specificity);
        }
    }

    private void applyLocalStyleAttribute(String name, String newValue, String priority, SelectorSpecificity specificity) {
        CSSStyleDeclaration.StyleElement existingElement;
        if (!"important".equals(priority) && (existingElement = (CSSStyleDeclaration.StyleElement)this.localModifications_.get(name)) != null) {
            if ("important".equals(existingElement.getPriority())) {
                return;
            }
            if (specificity.compareTo(existingElement.getSpecificity()) < 0) {
                return;
            }
        }
        CSSStyleDeclaration.StyleElement element = new CSSStyleDeclaration.StyleElement(name, newValue, priority, specificity, this.getCurrentElementIndex());
        this.localModifications_.put(name, element);
    }

    public void setDefaultLocalStyleAttribute(String name, String newValue) {
        CSSStyleDeclaration.StyleElement element = new CSSStyleDeclaration.StyleElement(name, newValue);
        this.localModifications_.put(name, element);
    }

    @Override
    protected Map<String, CSSStyleDeclaration.StyleElement> getStyleMap() {
        Map<String, CSSStyleDeclaration.StyleElement> styleMap = super.getStyleMap();
        if (this.localModifications_ != null) {
            for (CSSStyleDeclaration.StyleElement e : this.localModifications_.values()) {
                String key = e.getName();
                CSSStyleDeclaration.StyleElement existent = styleMap.get(key);
                if (existent != null) continue;
                CSSStyleDeclaration.StyleElement element = new CSSStyleDeclaration.StyleElement(key, e.getValue(), e.getIndex());
                styleMap.put(key, element);
            }
        }
        return styleMap;
    }

    @Override
    public String jsxGet_backgroundAttachment() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_backgroundAttachment(), (String)"scroll");
    }

    @Override
    public String jsxGet_backgroundColor() {
        String value = super.jsxGet_backgroundColor();
        if (StringUtils.isEmpty((String)value)) {
            value = "transparent";
        } else if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_GET_BACKGROUND_COLOR_FOR_COMPUTED_STYLE_RETURNS_RGB)) {
            value = ComputedCSSStyleDeclaration.toRGBColor(value);
        }
        return value;
    }

    @Override
    public String jsxGet_backgroundImage() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_backgroundImage(), (String)"none");
    }

    @Override
    public String jsxGet_backgroundPosition() {
        String bg = super.jsxGet_backgroundPosition();
        if (StringUtils.isNotBlank((String)bg)) {
            bg = StringUtils.replace((String)bg, (String)"left", (String)"0%");
            bg = StringUtils.replace((String)bg, (String)"right", (String)"100%");
            bg = StringUtils.replace((String)bg, (String)"center", (String)"50%");
            bg = StringUtils.replace((String)bg, (String)"top", (String)"0%");
            bg = StringUtils.replace((String)bg, (String)"bottom", (String)"100%");
        }
        return StringUtils.defaultIfEmpty((String)bg, (String)"0% 0%");
    }

    @Override
    public String jsxGet_backgroundRepeat() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_backgroundRepeat(), (String)"repeat");
    }

    @Override
    public String jsxGet_borderBottomColor() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_borderBottomColor(), (String)"rgb(0, 0, 0)");
    }

    @Override
    public String jsxGet_borderBottomStyle() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_borderBottomStyle(), (String)"none");
    }

    @Override
    public String jsxGet_borderBottomWidth() {
        return this.pixelString(StringUtils.defaultIfEmpty((String)super.jsxGet_borderBottomWidth(), (String)"0px"));
    }

    @Override
    public String jsxGet_borderCollapse() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_borderCollapse(), (String)"separate");
    }

    @Override
    public String jsxGet_borderLeftColor() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_borderLeftColor(), (String)"rgb(0, 0, 0)");
    }

    @Override
    public String jsxGet_borderLeftStyle() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_borderLeftStyle(), (String)"none");
    }

    @Override
    public String jsxGet_borderLeftWidth() {
        return this.pixelString(StringUtils.defaultIfEmpty((String)super.jsxGet_borderLeftWidth(), (String)"0px"));
    }

    @Override
    public String jsxGet_borderRightColor() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_borderRightColor(), (String)"rgb(0, 0, 0)");
    }

    @Override
    public String jsxGet_borderRightStyle() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_borderRightStyle(), (String)"none");
    }

    @Override
    public String jsxGet_borderRightWidth() {
        return this.pixelString(StringUtils.defaultIfEmpty((String)super.jsxGet_borderRightWidth(), (String)"0px"));
    }

    @Override
    public String jsxGet_borderSpacing() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_borderSpacing(), (String)"0px 0px");
    }

    @Override
    public String jsxGet_borderTopColor() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_borderTopColor(), (String)"rgb(0, 0, 0)");
    }

    @Override
    public String jsxGet_borderTopStyle() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_borderTopStyle(), (String)"none");
    }

    @Override
    public String jsxGet_borderTopWidth() {
        return this.pixelString(StringUtils.defaultIfEmpty((String)super.jsxGet_borderTopWidth(), (String)"0px"));
    }

    @Override
    public String jsxGet_bottom() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_bottom(), (String)"auto");
    }

    @Override
    public String jsxGet_captionSide() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_captionSide(), (String)"top");
    }

    @Override
    public String jsxGet_clear() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_clear(), (String)"none");
    }

    @Override
    public String jsxGet_clip() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_clip(), (String)"auto");
    }

    @Override
    public String jsxGet_color() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_color(), (String)"rgb(0, 0, 0)");
    }

    @Override
    public String jsxGet_counterIncrement() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_counterIncrement(), (String)"none");
    }

    @Override
    public String jsxGet_counterReset() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_counterReset(), (String)"none");
    }

    @Override
    public String jsxGet_cssFloat() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_cssFloat(), (String)"none");
    }

    @Override
    public String jsxGet_cursor() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_cursor(), (String)"auto");
    }

    @Override
    public String jsxGet_direction() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_direction(), (String)"ltr");
    }

    @Override
    public String jsxGet_display() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_display(), (String)this.getDefaultStyleDisplay());
    }

    private String getDefaultStyleDisplay() {
        String defaultValue;
        if (this.defaultDisplays_ == null) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("A", "inline");
            map.put("CODE", "inline");
            map.put("SPAN", "inline");
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.CSS_DISPLAY_DEFAULT)) {
                map.put("LI", "list-item");
                map.put("TABLE", "table");
                map.put("TBODY", "table-row-group");
                map.put("TD", "table-cell");
                map.put("TH", "table-cell");
                map.put("THEAD", "table-header-group");
                map.put("TR", "table-row");
            }
            this.defaultDisplays_ = Collections.unmodifiableMap(map);
        }
        if ((defaultValue = this.defaultDisplays_.get(this.getElement().jsxGet_tagName())) == null) {
            return "block";
        }
        return defaultValue;
    }

    @Override
    public String jsxGet_emptyCells() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_emptyCells(), (String)"-moz-show-background");
    }

    @Override
    public String jsxGet_fontFamily() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_fontFamily(), (String)"serif");
    }

    @Override
    public String jsxGet_fontSize() {
        HTMLElement parent;
        String value = super.jsxGet_fontSize();
        if (value.length() == 0 && (parent = this.getElement().getParentHTMLElement()) != null) {
            value = parent.jsxGet_currentStyle().jsxGet_fontSize();
        }
        if (value.length() == 0) {
            value = "16px";
        }
        return value;
    }

    @Override
    public String jsxGet_fontSizeAdjust() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_fontSizeAdjust(), (String)"none");
    }

    @Override
    public String jsxGet_fontStyle() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_fontStyle(), (String)"normal");
    }

    @Override
    public String jsxGet_fontVariant() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_fontVariant(), (String)"normal");
    }

    @Override
    public String jsxGet_fontWeight() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_fontWeight(), (String)"400");
    }

    @Override
    public String jsxGet_height() {
        return this.pixelString(this.getElement(), new CSSStyleDeclaration.CssValue(605){

            public String get(ComputedCSSStyleDeclaration style) {
                return StringUtils.defaultIfEmpty((String)style.getStyleAttribute("height", null), (String)"363px");
            }
        });
    }

    @Override
    public String jsxGet_left() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_left(), (String)"auto");
    }

    @Override
    public String jsxGet_letterSpacing() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_letterSpacing(), (String)"normal");
    }

    @Override
    public String jsxGet_lineHeight() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_lineHeight(), (String)"normal");
    }

    @Override
    public String jsxGet_listStyleImage() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_listStyleImage(), (String)"none");
    }

    @Override
    public String jsxGet_listStylePosition() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_listStylePosition(), (String)"outside");
    }

    @Override
    public String jsxGet_listStyleType() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_listStyleType(), (String)"disc");
    }

    @Override
    public String jsxGet_marginBottom() {
        return this.pixelString(StringUtils.defaultIfEmpty((String)super.jsxGet_marginBottom(), (String)"0px"));
    }

    @Override
    public String jsxGet_marginLeft() {
        return this.pixelString(StringUtils.defaultIfEmpty((String)super.jsxGet_marginLeft(), (String)"0px"));
    }

    @Override
    public String jsxGet_marginRight() {
        return this.pixelString(StringUtils.defaultIfEmpty((String)super.jsxGet_marginRight(), (String)"0px"));
    }

    @Override
    public String jsxGet_marginTop() {
        return this.pixelString(StringUtils.defaultIfEmpty((String)super.jsxGet_marginTop(), (String)"0px"));
    }

    @Override
    public String jsxGet_markerOffset() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_markerOffset(), (String)"none");
    }

    @Override
    public String jsxGet_maxHeight() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_maxHeight(), (String)"none");
    }

    @Override
    public String jsxGet_maxWidth() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_maxWidth(), (String)"none");
    }

    @Override
    public String jsxGet_minHeight() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_minHeight(), (String)"0px");
    }

    @Override
    public String jsxGet_minWidth() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_minWidth(), (String)"0px");
    }

    @Override
    public String jsxGet_MozAppearance() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_MozAppearance(), (String)"none");
    }

    @Override
    public String jsxGet_MozBackgroundClip() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_MozBackgroundClip(), (String)"border");
    }

    @Override
    public String jsxGet_MozBackgroundInlinePolicy() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_MozBackgroundInlinePolicy(), (String)"continuous");
    }

    @Override
    public String jsxGet_MozBackgroundOrigin() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_MozBackgroundOrigin(), (String)"padding");
    }

    @Override
    public String jsxGet_MozBinding() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_MozBinding(), (String)"none");
    }

    @Override
    public String jsxGet_MozBorderBottomColors() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_MozBorderBottomColors(), (String)"none");
    }

    @Override
    public String jsxGet_MozBorderLeftColors() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_MozBorderLeftColors(), (String)"none");
    }

    @Override
    public String jsxGet_MozBorderRadiusBottomleft() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_MozBorderRadiusBottomleft(), (String)"0px");
    }

    @Override
    public String jsxGet_MozBorderRadiusBottomright() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_MozBorderRadiusBottomright(), (String)"0px");
    }

    @Override
    public String jsxGet_MozBorderRadiusTopleft() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_MozBorderRadiusTopleft(), (String)"0px");
    }

    @Override
    public String jsxGet_MozBorderRadiusTopright() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_MozBorderRadiusTopright(), (String)"0px");
    }

    @Override
    public String jsxGet_MozBorderRightColors() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_MozBorderRightColors(), (String)"none");
    }

    @Override
    public String jsxGet_MozBorderTopColors() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_MozBorderTopColors(), (String)"none");
    }

    @Override
    public String jsxGet_MozBoxAlign() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_MozBoxAlign(), (String)"stretch");
    }

    @Override
    public String jsxGet_MozBoxDirection() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_MozBoxDirection(), (String)"normal");
    }

    @Override
    public String jsxGet_MozBoxFlex() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_MozBoxFlex(), (String)"0");
    }

    @Override
    public String jsxGet_MozBoxOrdinalGroup() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_MozBoxOrdinalGroup(), (String)"1");
    }

    @Override
    public String jsxGet_MozBoxOrient() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_MozBoxOrient(), (String)"horizontal");
    }

    @Override
    public String jsxGet_MozBoxPack() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_MozBoxPack(), (String)"start");
    }

    @Override
    public String jsxGet_MozBoxSizing() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_MozBoxSizing(), (String)"content-box");
    }

    @Override
    public String jsxGet_MozColumnCount() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_MozColumnCount(), (String)"auto");
    }

    @Override
    public String jsxGet_MozColumnGap() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_MozColumnGap(), (String)"0px");
    }

    @Override
    public String jsxGet_MozColumnWidth() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_MozColumnWidth(), (String)"auto");
    }

    @Override
    public String jsxGet_MozFloatEdge() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_MozFloatEdge(), (String)"content-box");
    }

    @Override
    public String jsxGet_MozImageRegion() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_MozImageRegion(), (String)"auto");
    }

    @Override
    public String jsxGet_MozOpacity() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_MozOpacity(), (String)"1");
    }

    @Override
    public String jsxGet_MozOutlineColor() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_MozOutlineColor(), (String)"rgb(0, 0, 0)");
    }

    @Override
    public String jsxGet_MozOutlineOffset() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_MozOutlineOffset(), (String)"0px");
    }

    @Override
    public String jsxGet_MozOutlineRadiusBottomleft() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_MozOutlineRadiusBottomleft(), (String)"0px");
    }

    @Override
    public String jsxGet_MozOutlineRadiusBottomright() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_MozOutlineRadiusBottomright(), (String)"0px");
    }

    @Override
    public String jsxGet_MozOutlineRadiusTopleft() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_MozOutlineRadiusTopleft(), (String)"0px");
    }

    @Override
    public String jsxGet_MozOutlineRadiusTopright() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_MozOutlineRadiusTopright(), (String)"0px");
    }

    @Override
    public String jsxGet_MozOutlineStyle() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_MozOutlineStyle(), (String)"none");
    }

    @Override
    public String jsxGet_MozOutlineWidth() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_MozOutlineWidth(), (String)"0px");
    }

    @Override
    public String jsxGet_MozUserFocus() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_MozUserFocus(), (String)"none");
    }

    @Override
    public String jsxGet_MozUserInput() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_MozUserInput(), (String)"auto");
    }

    @Override
    public String jsxGet_MozUserModify() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_MozUserModify(), (String)"read-only");
    }

    @Override
    public String jsxGet_MozUserSelect() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_MozUserSelect(), (String)"auto");
    }

    @Override
    public String jsxGet_opacity() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_opacity(), (String)"1");
    }

    @Override
    public String jsxGet_outlineColor() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_outlineColor(), (String)"rgb(0, 0, 0)");
    }

    @Override
    public String jsxGet_outlineOffset() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_outlineOffset(), (String)"0px");
    }

    @Override
    public String jsxGet_outlineStyle() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_outlineStyle(), (String)"none");
    }

    @Override
    public String jsxGet_outlineWidth() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_outlineWidth(), (String)"0px");
    }

    @Override
    public String jsxGet_overflow() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_overflow(), (String)"visible");
    }

    @Override
    public String jsxGet_overflowX() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_overflowX(), (String)"visible");
    }

    @Override
    public String jsxGet_overflowY() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_overflowY(), (String)"visible");
    }

    @Override
    public String jsxGet_paddingBottom() {
        return this.pixelString(StringUtils.defaultIfEmpty((String)super.jsxGet_paddingBottom(), (String)"0px"));
    }

    @Override
    public String jsxGet_paddingLeft() {
        return this.pixelString(StringUtils.defaultIfEmpty((String)super.jsxGet_paddingLeft(), (String)"0px"));
    }

    @Override
    public String jsxGet_paddingRight() {
        return this.pixelString(StringUtils.defaultIfEmpty((String)super.jsxGet_paddingRight(), (String)"0px"));
    }

    @Override
    public String jsxGet_paddingTop() {
        return this.pixelString(StringUtils.defaultIfEmpty((String)super.jsxGet_paddingTop(), (String)"0px"));
    }

    @Override
    public String jsxGet_position() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_position(), (String)"static");
    }

    @Override
    public String jsxGet_right() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_right(), (String)"auto");
    }

    @Override
    public String jsxGet_tableLayout() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_tableLayout(), (String)"auto");
    }

    @Override
    public String jsxGet_textAlign() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_textAlign(), (String)"start");
    }

    @Override
    public String jsxGet_textDecoration() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_textDecoration(), (String)"none");
    }

    @Override
    public String jsxGet_textIndent() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_textIndent(), (String)"0px");
    }

    @Override
    public String jsxGet_textTransform() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_textTransform(), (String)"none");
    }

    @Override
    public String jsxGet_top() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_top(), (String)"auto");
    }

    @Override
    public String jsxGet_unicodeBidi() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_unicodeBidi(), (String)"normal");
    }

    @Override
    public String jsxGet_verticalAlign() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_verticalAlign(), (String)"baseline");
    }

    @Override
    public String jsxGet_visibility() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_visibility(), (String)"visible");
    }

    @Override
    public String jsxGet_whiteSpace() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_whiteSpace(), (String)"normal");
    }

    @Override
    public String jsxGet_width() {
        if ("none".equals(this.jsxGet_display())) {
            return "auto";
        }
        final String defaultWidth = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.CSS_DEFAULT_WIDTH_AUTO) ? "auto" : "1256px";
        return this.pixelString(this.getElement(), new CSSStyleDeclaration.CssValue(1256){

            public String get(ComputedCSSStyleDeclaration style) {
                return StringUtils.defaultIfEmpty((String)style.getStyleAttribute("width", null), (String)defaultWidth);
            }
        });
    }

    public int getCalculatedWidth(boolean includeBorder, boolean includePadding) {
        int width = this.getCalculatedWidth();
        if (includeBorder) {
            width += this.getBorderHorizontal();
        }
        if (includePadding) {
            width += this.getPaddingHorizontal();
        }
        return width;
    }

    private int getCalculatedWidth() {
        int width;
        if (this.width_ != null) {
            return this.width_;
        }
        HtmlElement node = this.getElement().getDomNodeOrDie();
        if (!node.mayBeDisplayed()) {
            this.width_ = 0;
            return 0;
        }
        String display = this.jsxGet_display();
        if ("none".equals(display)) {
            this.width_ = 0;
            return 0;
        }
        String styleWidth = super.jsxGet_width();
        DomNode parent = node.getParentNode();
        if (StringUtils.isEmpty((String)styleWidth) && parent instanceof HtmlElement) {
            if (this.getElement() instanceof HTMLCanvasElement) {
                return 300;
            }
            String cssFloat = this.jsxGet_cssFloat();
            if ("right".equals(cssFloat) || "left".equals(cssFloat)) {
                width = ((DomNode)this.getDomNodeOrDie()).getTextContent().length() * 10;
            } else if ("block".equals(display)) {
                HTMLElement parentJS = (HTMLElement)parent.getScriptObject();
                String parentWidth = this.getWindow().jsxFunction_getComputedStyle(parentJS, null).jsxGet_width();
                width = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.CSS_DEFAULT_WIDTH_AUTO) && "auto".equals(parentWidth) ? 1256 : ComputedCSSStyleDeclaration.pixelValue(parentJS, new CSSStyleDeclaration.CssValue(1256){

                    public String get(ComputedCSSStyleDeclaration style) {
                        return style.jsxGet_width();
                    }
                });
                width -= this.getBorderHorizontal() + this.getPaddingHorizontal();
            } else {
                width = this.getContentWidth();
            }
        } else {
            width = ComputedCSSStyleDeclaration.pixelValue(this.getElement(), new CSSStyleDeclaration.CssValue(1256){

                public String get(ComputedCSSStyleDeclaration style) {
                    return style.getStyleAttribute("width", null);
                }
            });
        }
        this.width_ = width;
        return width;
    }

    public int getContentWidth() {
        int width = 0;
        for (DomNode child : ((DomNode)this.getDomNodeOrDie()).getChildren()) {
            if (child.getScriptObject() instanceof HTMLElement) {
                HTMLElement e = (HTMLElement)child.getScriptObject();
                int w = e.jsxGet_currentStyle().getCalculatedWidth(true, true);
                width += w;
                continue;
            }
            if (!(child.getScriptObject() instanceof Text)) continue;
            width += child.getTextContent().length() * 10;
        }
        return width;
    }

    public int getCalculatedHeight(boolean includeBorder, boolean includePadding) {
        int height = this.getCalculatedHeight();
        if (includeBorder) {
            height += this.getBorderVertical();
        }
        if (includePadding) {
            height += this.getPaddingVertical();
        }
        return height;
    }

    private int getCalculatedHeight() {
        if (this.height_ != null) {
            return this.height_;
        }
        int elementHeight = this.getEmptyHeight();
        if (elementHeight == 0) {
            this.height_ = elementHeight;
            return elementHeight;
        }
        int contentHeight = this.getContentHeight();
        boolean useDefaultHeight = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.CSS_DEFAULT_ELMENT_HEIGHT_MARKS_MIN);
        boolean explicitHeightSpecified = super.jsxGet_height().length() > 0;
        int height = contentHeight > 0 && (useDefaultHeight && contentHeight > elementHeight || !useDefaultHeight && !explicitHeightSpecified) ? contentHeight : elementHeight;
        this.height_ = height;
        return height;
    }

    private int getEmptyHeight() {
        if (this.height2_ != null) {
            return this.height2_;
        }
        HtmlElement node = this.getElement().getDomNodeOrDie();
        if (!node.mayBeDisplayed()) {
            this.height2_ = 0;
            return 0;
        }
        if ("none".equals(this.jsxGet_display())) {
            this.height2_ = 0;
            return 0;
        }
        if (this.getElement() instanceof HTMLBodyElement) {
            this.height2_ = 605;
            return 605;
        }
        boolean explicitHeightSpecified = super.jsxGet_height().length() > 0;
        int defaultHeight = 20;
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.CSS_DEFAULT_ELMENT_HEIGHT_15)) {
            defaultHeight = 15;
        }
        int defaultValue = this.getElement() instanceof HTMLCanvasElement ? 150 : 605;
        int height = ComputedCSSStyleDeclaration.pixelValue(this.getElement(), new CSSStyleDeclaration.CssValue(defaultValue){

            public String get(ComputedCSSStyleDeclaration style) {
                return style.getStyleAttribute("height", null);
            }
        });
        boolean useDefaultHeight = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.CSS_DEFAULT_ELMENT_HEIGHT_MARKS_MIN);
        if (height == 0 && !explicitHeightSpecified || useDefaultHeight && height < defaultHeight) {
            height = defaultHeight;
        }
        this.height2_ = height;
        return height;
    }

    public int getContentHeight() {
        HtmlElement node = this.getElement().getDomNodeOrDie();
        if (!node.mayBeDisplayed()) {
            return 0;
        }
        HTMLElement lastFlowing = null;
        HashSet<HTMLElement> independent = new HashSet<HTMLElement>();
        for (DomNode child : node.getChildren()) {
            if (!child.mayBeDisplayed() || !(child.getScriptObject() instanceof HTMLElement)) continue;
            HTMLElement e = (HTMLElement)child.getScriptObject();
            ComputedCSSStyleDeclaration style = e.jsxGet_currentStyle();
            String pos = style.getPositionWithInheritance();
            if ("static".equals(pos) || "relative".equals(pos)) {
                lastFlowing = e;
                continue;
            }
            if (!"absolute".equals(pos)) continue;
            independent.add(e);
        }
        HashSet<HTMLElement> relevant = new HashSet<HTMLElement>();
        relevant.addAll(independent);
        if (lastFlowing != null) {
            relevant.add(lastFlowing);
        }
        int max = 0;
        for (HTMLElement e : relevant) {
            ComputedCSSStyleDeclaration style = e.jsxGet_currentStyle();
            int h = style.getTop(true, false, false) + style.getCalculatedHeight(true, true);
            if (h <= max) continue;
            max = h;
        }
        return max;
    }

    public boolean isScrollable(boolean horizontal) {
        HTMLElement node = this.getElement();
        String overflow = this.jsxGet_overflow();
        boolean scrollable = horizontal ? (node instanceof HTMLBodyElement || "scroll".equals(overflow) || "auto".equals(overflow)) && this.getContentWidth() > this.getCalculatedWidth() : (node instanceof HTMLBodyElement || "scroll".equals(overflow) || "auto".equals(overflow)) && this.getContentHeight() > this.getEmptyHeight();
        return scrollable;
    }

    public int getTop(boolean includeMargin, boolean includeBorder, boolean includePadding) {
        int top;
        String p = this.getPositionWithInheritance();
        String t = this.getTopWithInheritance();
        String b = this.getBottomWithInheritance();
        if ("absolute".equals(p) && !"auto".equals(t)) {
            top = ComputedCSSStyleDeclaration.pixelValue(t);
        } else if ("absolute".equals(p) && !"auto".equals(b)) {
            top = 0;
            for (DomNode child = this.getElement().getDomNodeOrDie().getParentNode().getFirstChild(); child != null; child = child.getNextSibling()) {
                if (!(child instanceof HtmlElement) || !child.mayBeDisplayed()) continue;
                top += 20;
            }
            top -= ComputedCSSStyleDeclaration.pixelValue(b);
        } else {
            DomNode prev;
            top = 0;
            for (prev = this.getElement().getDomNodeOrDie().getPreviousSibling(); prev != null && !(prev instanceof HtmlElement); prev = prev.getPreviousSibling()) {
            }
            if (prev != null) {
                HTMLElement e = (HTMLElement)((HtmlElement)prev).getScriptObject();
                ComputedCSSStyleDeclaration style = e.jsxGet_currentStyle();
                top = style.getTop(true, false, false) + style.getCalculatedHeight(true, true);
            }
            if ("relative".equals(p)) {
                top += ComputedCSSStyleDeclaration.pixelValue(t);
            }
        }
        if (includeMargin) {
            int margin = ComputedCSSStyleDeclaration.pixelValue(this.jsxGet_marginTop());
            top += margin;
        }
        if (includeBorder) {
            int border = ComputedCSSStyleDeclaration.pixelValue(this.jsxGet_borderTopWidth());
            top += border;
        }
        if (includePadding) {
            int padding = this.getPaddingTop();
            top += padding;
        }
        return top;
    }

    public int getLeft(boolean includeMargin, boolean includeBorder, boolean includePadding) {
        HTMLElement parent;
        int left;
        String p = this.getPositionWithInheritance();
        String l = this.getLeftWithInheritance();
        String r = this.getRightWithInheritance();
        if ("fixed".equals(p) && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.TREATS_POSITION_FIXED_LIKE_POSITION_STATIC)) {
            p = "static";
        }
        if ("absolute".equals(p) && !"auto".equals(l)) {
            left = ComputedCSSStyleDeclaration.pixelValue(l);
        } else if ("absolute".equals(p) && !"auto".equals(r)) {
            parent = this.getElement().getParentHTMLElement();
            int parentWidth = parent.jsxGet_currentStyle().getCalculatedWidth(false, false);
            left = parentWidth - ComputedCSSStyleDeclaration.pixelValue(r);
        } else if ("fixed".equals(p) && "auto".equals(l)) {
            parent = this.getElement().getParentHTMLElement();
            left = ComputedCSSStyleDeclaration.pixelValue(parent.jsxGet_currentStyle().getLeftWithInheritance());
        } else if ("static".equals(p)) {
            left = 0;
            for (Object n = this.getDomNodeOrDie(); n != null; n = ((DomNode)n).getPreviousSibling()) {
                if (((DomNode)n).getScriptObject() instanceof HTMLElement) {
                    HTMLElement e = (HTMLElement)((DomNode)n).getScriptObject();
                    String d = e.jsxGet_currentStyle().jsxGet_display();
                    if ("block".equals(d)) break;
                    if (!"none".equals(d)) {
                        left += e.jsxGet_currentStyle().getCalculatedWidth(true, true);
                    }
                } else if (((DomNode)n).getScriptObject() instanceof Text) {
                    left += ((DomNode)n).getTextContent().length() * 10;
                }
                if (!(n instanceof HtmlTableRow)) {
                    continue;
                }
                break;
            }
        } else {
            left = ComputedCSSStyleDeclaration.pixelValue(l);
        }
        if (includeMargin) {
            int margin = this.getMarginLeft();
            left += margin;
        }
        if (includeBorder) {
            int border = ComputedCSSStyleDeclaration.pixelValue(this.jsxGet_borderLeftWidth());
            left += border;
        }
        if (includePadding) {
            int padding = this.getPaddingLeft();
            left += padding;
        }
        return left;
    }

    public String getPositionWithInheritance() {
        String p = this.jsxGet_position();
        if ("inherit".equals(p)) {
            HTMLElement parent;
            p = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.CAN_INHERIT_CSS_PROPERTY_VALUES) ? ((parent = this.getElement().getParentHTMLElement()) != null ? parent.jsxGet_currentStyle().getPositionWithInheritance() : "static") : "static";
        }
        return p;
    }

    public String getLeftWithInheritance() {
        String left = this.jsxGet_left();
        if ("inherit".equals(left)) {
            HTMLElement parent;
            left = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.CAN_INHERIT_CSS_PROPERTY_VALUES) ? ((parent = this.getElement().getParentHTMLElement()) != null ? parent.jsxGet_currentStyle().getLeftWithInheritance() : "auto") : "auto";
        }
        return left;
    }

    public String getRightWithInheritance() {
        String right = this.jsxGet_right();
        if ("inherit".equals(right)) {
            HTMLElement parent;
            right = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.CAN_INHERIT_CSS_PROPERTY_VALUES) ? ((parent = this.getElement().getParentHTMLElement()) != null ? parent.jsxGet_currentStyle().getRightWithInheritance() : "auto") : "auto";
        }
        return right;
    }

    public String getTopWithInheritance() {
        String top = this.jsxGet_top();
        if ("inherit".equals(top)) {
            HTMLElement parent;
            top = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.CAN_INHERIT_CSS_PROPERTY_VALUES) ? ((parent = this.getElement().getParentHTMLElement()) != null ? parent.jsxGet_currentStyle().getTopWithInheritance() : "auto") : "auto";
        }
        return top;
    }

    public String getBottomWithInheritance() {
        String bottom = this.jsxGet_bottom();
        if ("inherit".equals(bottom)) {
            HTMLElement parent;
            bottom = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.CAN_INHERIT_CSS_PROPERTY_VALUES) ? ((parent = this.getElement().getParentHTMLElement()) != null ? parent.jsxGet_currentStyle().getBottomWithInheritance() : "auto") : "auto";
        }
        return bottom;
    }

    public int getMarginLeft() {
        return ComputedCSSStyleDeclaration.pixelValue(this.jsxGet_marginLeft());
    }

    public int getMarginRight() {
        return ComputedCSSStyleDeclaration.pixelValue(this.jsxGet_marginRight());
    }

    public int getMarginTop() {
        return ComputedCSSStyleDeclaration.pixelValue(this.jsxGet_marginTop());
    }

    public int getMarginBottom() {
        return ComputedCSSStyleDeclaration.pixelValue(this.jsxGet_marginBottom());
    }

    public int getPaddingLeft() {
        return ComputedCSSStyleDeclaration.pixelValue(this.jsxGet_paddingLeft());
    }

    public int getPaddingRight() {
        return ComputedCSSStyleDeclaration.pixelValue(this.jsxGet_paddingRight());
    }

    public int getPaddingTop() {
        return ComputedCSSStyleDeclaration.pixelValue(this.jsxGet_paddingTop());
    }

    public int getPaddingBottom() {
        return ComputedCSSStyleDeclaration.pixelValue(this.jsxGet_paddingBottom());
    }

    private int getPaddingHorizontal() {
        if (this.paddingHorizontal_ == null) {
            this.paddingHorizontal_ = "none".equals(this.jsxGet_display()) ? 0 : this.getPaddingLeft() + this.getPaddingRight();
        }
        return this.paddingHorizontal_;
    }

    private int getPaddingVertical() {
        if (this.paddingVertical_ == null) {
            this.paddingVertical_ = "none".equals(this.jsxGet_display()) ? 0 : this.getPaddingTop() + this.getPaddingBottom();
        }
        return this.paddingVertical_;
    }

    public int getBorderLeft() {
        return ComputedCSSStyleDeclaration.pixelValue(this.jsxGet_borderLeftWidth());
    }

    public int getBorderRight() {
        return ComputedCSSStyleDeclaration.pixelValue(this.jsxGet_borderRightWidth());
    }

    public int getBorderTop() {
        return ComputedCSSStyleDeclaration.pixelValue(this.jsxGet_borderTopWidth());
    }

    public int getBorderBottom() {
        return ComputedCSSStyleDeclaration.pixelValue(this.jsxGet_borderBottomWidth());
    }

    private int getBorderHorizontal() {
        if (this.borderHorizontal_ == null) {
            this.borderHorizontal_ = "none".equals(this.jsxGet_display()) ? 0 : this.getBorderLeft() + this.getBorderRight();
        }
        return this.borderHorizontal_;
    }

    private int getBorderVertical() {
        if (this.borderVertical_ == null) {
            this.borderVertical_ = "none".equals(this.jsxGet_display()) ? 0 : this.getBorderTop() + this.getBorderBottom();
        }
        return this.borderVertical_;
    }

    @Override
    public String jsxGet_wordSpacing() {
        return StringUtils.defaultIfEmpty((String)super.jsxGet_wordSpacing(), (String)"normal");
    }

    @Override
    public Object jsxGet_zIndex() {
        Object response = super.jsxGet_zIndex();
        if (response.toString().length() == 0) {
            return "auto";
        }
        return response;
    }

    @Override
    public String jsxFunction_getPropertyValue(String name) {
        String response = Context.toString((Object)ComputedCSSStyleDeclaration.getProperty((Scriptable)this, (String)ComputedCSSStyleDeclaration.camelize(name)));
        if (response == NOT_FOUND) {
            return super.jsxFunction_getPropertyValue(name);
        }
        return response;
    }

    protected String pixelString(String value) {
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_LENGTH_WITHOUT_PX)) {
            return value;
        }
        if (value.endsWith("px")) {
            return value;
        }
        return ComputedCSSStyleDeclaration.pixelValue(value) + "px";
    }

    protected String pixelString(HTMLElement element, CSSStyleDeclaration.CssValue value) {
        String s = value.get(element);
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_LENGTH_WITHOUT_PX)) {
            return s;
        }
        if (s.endsWith("px")) {
            return s;
        }
        return ComputedCSSStyleDeclaration.pixelValue(element, value) + "px";
    }
}

