#!/usr/bin/perl

use strict;
use warnings;

use Test::More tests => 2;

use Algorithm::ClusterPoints;


my @x = ( 0.544460345696681, 0.568466445804983, 0.862554556980758,
          0.409095438232068, 0.567847141151876, 0.685328615757253,
          0.0795686274517955, 0.29410178608526, 0.520030032850858,
          0.236259733286158, 0.0294282551552278, 0.914725723577785,
          0.276250858170588, 0.673800841587802, 0.297429085058173,
          0.586241459173603, 0.88596413841157, 0.225342515099054,
          0.737789393756561, 0.269533367118949, 0.463388079631361,
          0.649042080805298, 0.930544874640919, 0.633198454264001,
          0.628078652396542, 0.801246157236175, 0.30011506155093,
          0.470565399455349, 0.798169572718766, 0.558539849039942 );

my @y = ( 0.358415913711866, 0.0111357565266488, 0.440309055507598,
          0.904607404043666, 0.687700131389136, 0.889755301702884,
          0.00459189980161057, 0.957928203336728, 0.28874431781307,
          0.266509778785981, 0.184030028200354, 0.422151072766916,
          0.760171615357649, 0.830166876153932, 0.863055448524406,
          0.224287303394128, 0.95541986662036, 0.63777975282688,
          0.553363804922625, 0.329798376144389, 0.187917282423371,
          0.595342261598297, 0.527584022466343, 0.659698805332873,
          0.497660430676518, 0.575629268906887, 0.0512307657694322,
          0.931358361154217, 0.576637173055246, 0.357822901527335 );

my $n = @x;

my @sol = ( [ 0, 8, 15, 29 ],
            [ 1 ],
            [ 2, 11, 22 ],
            [ 3, 27 ],
            [ 4, 18, 21, 23, 24, 25, 28 ],
            [ 5, 13 ],
            [ 6 ],
            [ 7, 14 ],
            [ 9, 19 ],
            [ 10 ],
            [ 12 ],
            [ 16 ],
            [ 17 ],
            [ 20 ],
            [ 26 ] );

my $clp = Algorithm::ClusterPoints->new(dimension => 2,
                                        dimensional_groups => [[0],[1]],
                                        ordered => 1,
                                        radius => 0.1);
$clp->add_point($x[$_], $y[$_]) for 0..$n-1;

my @bfc = $clp->brute_force_clusters_ix;
my @c = $clp->clusters_ix;

# use Data::Dumper;
# print STDERR Data::Dumper->Dump([\@c, \@bfc], [qw($c $bfc)]);

is_deeply(\@c, \@sol, "simple 2d - 1+1");
is_deeply(\@bfc, \@sol, "simple 2d - 1+1, brute force");

